## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {@var{f} =} vtkGetDataRoot ()
## Internal function for many of the examples.  Determines the path for
## VTK example data.
## @end deftypefn

## Author: Jonathan Stickel


function f = vtkGetDataRoot()

  ## I guess this is a locally set variable; should put this in documents
  ##  f = "/usr/share/vtkdata";

  f = "";

  ## The file that marks the vtkdata/ directory
  readme = "VTKData.readme";

  ## check for a possible environmental variable
  env_data_root = getenv("VTK_DATA_ROOT");

  ## set at Octaviz's compile time
  oct_data_root = "@VTK_DATA_ROOT@";

  ## locally set path
  local_data_root = "/usr/share/VTKData";

  data_root_path = [ env_data_root; local_data_root; oct_data_root ];

  ## check where we have the readme file
  if (! isempty(data_root_path))
    for i=[1:rows(data_root_path)]
      filename = [data_root_path(i, :), '/', readme];
      if (! isempty(stat(filename)))
        f = data_root_path(i,:);
        break;
      endif
    endfor
  else
    error("Empty search path for VTK_DATA_ROOT!");
  endif

  if (isempty(f))
    error([readme, " not found! \n\t Did you install the vtkdata package?"]);
  endif
  
endfunction
