## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

vtk_init

xi = rand(10,10);

	[nr nc] = size(xi);
	x = 1:nr;
	y = xi;


[nr nc] = size(y);

xyplot = vtkXYPlotActor;
	xyplot.SetXValuesToValue();

xvalues = vtkFloatArray;

for i=1:length(x)
	xvalues.InsertValue(i-1,x(i));
end

for i = 1:nc
	yvalues = vtkFloatArray;
	yvalues.SetArray(y(:,i),nr,0);
	curve  = vtkRectilinearGrid;
	curve.SetDimensions(nr,1,1);
	curve.SetXCoordinates(xvalues);
	curve.GetPointData().SetScalars(yvalues);
	xyplot.AddInput(curve);
	xyplot.SetPlotColor(i,rand,rand,rand) 
end
xyplot.PlotPointsOn()
xyplot.LegendOn();
xyplot.GetProperty().SetPointSize(3);

xyplot.GetProperty().SetLineWidth(1)

ren = vtkRenderer();
	ren.AddActor(xyplot);
win = vtkRenderWindow();
	win.AddRenderer(ren);
iren = vtkXRenderWindowInteractor();
	iren.SetRenderWindow(win);
w = vtkXYPlotWidget;
	w.SetXYPlotActor(xyplot);
	w.SetInteractor(iren);
	w.SetEnabled(1);	
vtkInitializeInteractor(iren);

	