// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Image_PixelInterpolation_HeaderFile
#define _Image_PixelInterpolation_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Image_Image_HeaderFile
#include <Handle_Image_Image.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Image_DColorImage_HeaderFile
#include <Handle_Image_DColorImage.hxx>
#endif
#ifndef _Handle_Image_DIndexedImage_HeaderFile
#include <Handle_Image_DIndexedImage.hxx>
#endif
class Image_Image;
class Aspect_Pixel;
class Image_DColorImage;
class Aspect_ColorPixel;
class Image_DIndexedImage;
class Aspect_IndexPixel;


//! The class PixelInterpolation is used to compute a Pixel <br>
//!            value on non-integer Image coordinate. This Pixel type <br>
//!	      is called SubPixel . <br>
//!          PixelInterpolation is the default and is the simplest one, <br>
//!	      SubPixel value on non-integer Image coordinate is the <br>
//!	      value of the nearest Pixel at integer coordinate. <br>
//!	    The user can create a new kind of PixelInterpolation with a <br>
//!	      new algorithm by creating a new derived PixelInterpolation <br>
//!	      class and redefined Interpolate() method. <br>
//!	    If V1  is the value of the nearest Image Pixel <br>
//!		V = V1 is the Image SubPixel value on non-integer <br>
//!	      coordinate (FX,FY) <br>
class Image_PixelInterpolation  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Create a PixelInterpolation  object. <br>
  Standard_EXPORT   Image_PixelInterpolation();
  //! Compute SubPixel's value on non-integer Image coordinate. <br>
//!	    LowerX,LowerY,UpperX,UpperY is the Image Min Max, it's used <br>
//!	    to check if the SubPixel coordinate X,Y is outside of image. <br>
//!          Return True  if Interpolation Succes. <br>
//!	    Retrun False if the SubPixel is out from Image. <br>
  Standard_EXPORT   virtual  Standard_Boolean Interpolate(const Handle(Image_Image)& aImage,const Standard_Real X,const Standard_Real Y,const Standard_Integer LowerX,const Standard_Integer LowerY,const Standard_Integer UpperX,const Standard_Integer UpperY,Aspect_Pixel& RetPixel) const;
  //! Compute SubPixel's value on non-integer Image coordinate for <br>
//!	      DColorImage and ColorPixel. <br>
//!	    LowerX,LowerY,UpperX,UpperY is the Image Min Max, it's used <br>
//!	      to check if the SubPixel coordinate FX,FY is outside of <br>
//!	      image. <br>
//!          Return True  if Interpolation Succes. <br>
//!	    Return False if the SubPixel is out from Image. <br>
  Standard_EXPORT   virtual  Standard_Boolean Interpolate(const Handle(Image_DColorImage)& aImage,const Standard_Real FX,const Standard_Real FY,const Standard_Integer LowerX,const Standard_Integer LowerY,const Standard_Integer UpperX,const Standard_Integer UpperY,Aspect_ColorPixel& RetPixel) const;
  //! Compute SubPixel's value on non-integer Image coordinate for <br>
//!	      DIndexedImage and IndexPixel. <br>
//!	    LowerX,LowerY,UpperX,UpperY is the Image Min Max, it's use <br>
//!	    check if the SubPixel coordinate X,Y is outside of image. <br>
//!          Return True  if Interpolation Succes. <br>
//!	    Return False if the SubPixel is out from Image. <br>
  Standard_EXPORT   virtual  Standard_Boolean Interpolate(const Handle(Image_DIndexedImage)& aImage,const Standard_Real FX,const Standard_Real FY,const Standard_Integer LowerX,const Standard_Integer LowerY,const Standard_Integer UpperX,const Standard_Integer UpperY,Aspect_IndexPixel& RetPixel) const;





protected:





private:

  
  Standard_EXPORT     Standard_Boolean DoInterpolate(const Handle(Image_Image)& aImage,const Standard_Real X,const Standard_Real Y,const Standard_Integer LowerX,const Standard_Integer LowerY,const Standard_Integer UpperX,const Standard_Integer UpperY,Aspect_Pixel& RetPixel) const;




};





// other Inline functions and methods (like "C++: function call" methods)


#endif
