#ifndef __NWS_OBJ_H
#define __NWS_OBJ_H

#include "nws_back_cache.h"

/* Object Definitions for NWS "Object Store" */

/* Type codes for NWS Objects */
/* Type in most significant short, version in least. */
#define NWS_OBJ_nwsDaemon		0x00010001
#define NWS_OBJ_nwsControl		0x00020001
#define NWS_OBJ_nwsSkill		0x00030001
#define NWS_OBJ_nwsActivity		0x00040001
#define NWS_OBJ_nwsSeries		0x00050001
#define NWS_OBJ_nwsTopology		0x00060001
#define NWS_OBJ_Unknown			0xFFFFFFFF

typedef struct nws_host_obj {
  char *name;
  struct in_addr ip_in_addr;
} nwsHostObj;

typedef struct nws_list {
  char **item;
  int count;
} nwsList;

struct nws_forecast_obj {
  char *name;
  int	timestamp;
  float forecast;
  float mse;
  float mae;
} NWSforecast;

typedef struct nws_daemon_obj {
  char *hostname;
  char *daemonType;
  char *ipAddress;
  char *owner;
  char *port;
  char *started;
  char *version;
  unsigned int addr;
  int port_num;
} NWSdaemon;

typedef struct nws_control_obj {
  char *controlName;
  char *host;
  char *option;
  char *skillName;
  char *member;
  char *period;  
} NWScontrol;

typedef struct nws_series_obj {
/*   NWSdaemon *memory; */
  char *host;
  char *label;
  char *memory;
  char *option;
  char *resource;
  char *activity;
  char *buffer;
  char *message;
  char *size;
  char *target;
  char *nice;
  char *type;
  struct nws_series_cache *nsc;
} NWSseries;

typedef struct nws_activity_obj {
  char *controlName;
  char *host;
  char *option;
  char *resource;
  char *skillName;
  char *period;
/* XXX   int period; */
  char *member;
  char *type;
  char *size;
  char *buffer;
  char *message;
} NWSactivity;

typedef struct nws_skill_obj {
  char *host;
  char *option;
  char *skillName;
  char *path;
  char *nice;
  char *type;
  char *target;
  char *buffer;
  char *message;
  char *size;
} NWSskill;

typedef struct nws_obj {
  char *name;
  char *type;
  unsigned int nws_timestamp;
  int itype;
  union {  
 	NWSdaemon nd; 
  	NWSseries ns;
	NWSskill nk;
  	NWSactivity na;
	NWScontrol nc;
  } at;
  struct nws_obj *next;
} NWSobj;

int
nws_list_init(struct nws_list *list);

int 
nws_list_add(struct nws_list *list, char *addme);

char *
nws_list_read(struct nws_list *list);

int
nws_list_clear(struct nws_list *list);

int
nws_list_print(struct nws_list *list);

#endif
