#include "portable.h"
#include <stdio.h>
#include <sys/time.h>
#include "slap.h"
#include <ldap_pvt.h>
#include "external.h"
#include "nws_back_cache.h"
#include "nws_back.h"

void
check_free(char *ptr) 
{
		if (ptr != NULL) {
				free(ptr);
		}
}

NWSobj *
nws_new_obj(void)
{
  NWSobj *obj;
  if ((obj = malloc(sizeof(NWSobj))) == NULL) {
	perror("nws_new_obj(): malloc() failed");
	/*return(NULL);*/
	exit(-1);
  }
  memset(obj, 0, sizeof(NWSobj));

  return(obj);
}

nwsSeriesCache *
nws_find_series(nwsCacheConfig *ncc, char *name)
{
  
  nwsSeriesCache *nser;

  printf("nws_find_series(): called.\n");

  nser = ncc->nser_root->next; /* skip the head */
  /* nser = nbc->nser->next; */

  while(nser != NULL) {
	if(!strcmp(nser->name, name)) {
	  printf("nws_find_series(): hit: %s\n", name);
	  return(nser);
	}
	nser = nser->next;
  }
  printf("nws_find_series(): didn't find %s\n", name);
  return(NULL);
}

NWSobj *
nws_find_obj(nwsCacheConfig *ncc, char *name)
{
  NWSobj *tobj;

  tobj = ncc->nws_cache_root;

  return(tobj);
}

int
nws_insert_obj(nwsCacheConfig *ncc, NWSobj *root, NWSobj *newobj)
{
  NWSobj *tobj;

  /*tobj = ncc->nws_cache_root;*/
  tobj = root;

  while(tobj->next != NULL) {
	tobj = tobj->next;
  }

  tobj->next = newobj;

  newobj->next = NULL;

  return(1);
}

int 
nws_new_tree(nwsCacheConfig *ncc, NWSobj *newobj)
{
  return(1);
}

int
nws_free_coll(nwsCacheConfig *ncc, struct nws_series_collection *nser_coll)
{
  int i;

  for(i=0;i < nser_coll->member_count; i++) {
	free(nser_coll->member[i]);
	free(nser_coll->member);
	free(nser_coll->series_rel);
	if(nser_coll->name == NULL) {
	  printf("nws_free_coll(): nser_coll->name is NULL.\n");
	  exit(-1);
	}
	free(nser_coll->name);

	if(nser_coll->type == NULL) {
	  printf("nws_free_coll(): nser_coll->type is NULL.\n");
	  exit(-1);
	}
	free(nser_coll->type);
	return(1);
  }
}

struct nws_series_collection *
nws_new_coll(nwsCacheConfig *ncc)
{
  struct nws_series_collection *nser_coll;

  nser_coll = malloc(sizeof(struct nws_series_collection));
  nser_coll->status = 0;
  if ((nser_coll->member = (char **)malloc(sizeof(char *)))
	  == NULL) {
	perror("nws_nws_coll(): malloc of nser_coll->member failed");
	exit(-1);
  }
  nser_coll->member_count = 0;
  nser_coll->member[0] = NULL;
  nser_coll->series_rel = (struct nws_series_cache2coll **)
	malloc(sizeof(struct nws_series_cache2coll *)); 
  nser_coll->series_rel[0] = NULL; 
  nser_coll->series_rel_count = 0;

  if(gettimeofday(&nser_coll->lastseen, NULL) < 0) {
	printf("nws_new_coll(): gettimeofday failed.\n");
	exit(-1);
  }

  nser_coll->lastupdate.tv_sec = 0;
  nser_coll->lastupdate.tv_usec = 0;

  return(nser_coll);

}

int
nws_coll_addmember(nwsCacheConfig *ncc, nwsSeriesColl *nser_coll, char *member)
{

  nser_coll->member_count++;
  nser_coll->member = realloc(nser_coll->member,
							  sizeof(char *) * nser_coll->member_count + 1);

  nser_coll->member[nser_coll->member_count-1] = strdup(member);
  return(1);

}

int
nws_make_coll(nwsCacheConfig *ncc, char *name, char *memberlist, char *type)
{
  char *tmpc, *tmpc2;
  int len;
  int i; 
  struct nws_series_collection *nser_coll;

  rb_find_key_n(ncc->nser_coll_tree, name, &i);

  if (i != 0) {
	return(0);
  }

  nser_coll = nws_new_coll(ncc);

  tmpc = memberlist;
  tmpc2 = tmpc;
  while (tmpc2 != NULL) {
	tmpc2 = strchr(tmpc, ',');
	len = tmpc2 - tmpc;
	tmpc2++;
	nser_coll->member_count++;
	nser_coll->member = realloc(nser_coll->member,
								sizeof(char *) * nser_coll->member_count + 1);
	nser_coll->member[nser_coll->member_count-1] = malloc(len + 1);
	strncpy(nser_coll->member[nser_coll->member_count-1], tmpc, len);
	nser_coll->member[nser_coll->member_count-1][len] = '\0';
	tmpc = tmpc2;
	tmpc2 = strchr(tmpc, ',');
  }

  tmpc2 = strchr(tmpc, '\t');
  if(tmpc2 == NULL) {
	tmpc2 = strchr(tmpc, '\0');
	if(tmpc2 == NULL) {
	}
  }
		
  len = tmpc2 - tmpc;
  nser_coll->member_count++;
  nser_coll->member = realloc(nser_coll->member,
							  sizeof(char *) * nser_coll->member_count + 1);
  nser_coll->member[nser_coll->member_count-1] = malloc(len + 1);
  strncpy(nser_coll->member[nser_coll->member_count-1], tmpc, len);
  nser_coll->member[nser_coll->member_count-1][len] = '\0';

		
  for(i=0;i<nser_coll->member_count;i++) {
	Debug(LDAP_DEBUG_TRACE,"%d: %s\n", i, nser_coll->member[i], 0);
  }

  nser_coll->name = strdup(name);
  nser_coll->type = strdup(type);
		
  rb_insert(ncc->nser_coll_tree, nser_coll->name, (char *)nser_coll);

  return(1);
}


int
nws_print_obj(NWSobj *obj)
{
  printf("nws_print_obj(): name:%s\n", obj->name);
  printf("nws_print_obj(): type:%s\n", obj->type);
  printf("nws_print_obj(): itype:%d\n", obj->itype);

  if (!strcmp("nwsHost", obj->type)) {
	printf("nws_print_obj(): attr:%s\n", obj->at.nd.hostname);
	printf("nws_print_obj(): attr:%s\n", obj->at.nd.daemonType);
	printf("nws_print_obj(): attr:%s\n", obj->at.nd.ipAddress);
	printf("nws_print_obj(): attr:%s\n", obj->at.nd.owner);
	printf("nws_print_obj(): attr:%s\n", obj->at.nd.port);
	printf("nws_print_obj(): attr:%s\n", obj->at.nd.started);
	printf("nws_print_obj(): attr:%s\n", obj->at.nd.version);
  }
  else if (!strcmp("nwsControl", obj->type)) {
	printf("nws_print_obj(): attr:%s\n", obj->at.nc.controlName);
	printf("nws_print_obj(): attr:%s\n", obj->at.nc.host);
	printf("nws_print_obj(): attr:%s\n", obj->at.nc.option);
	printf("nws_print_obj(): attr:%s\n", obj->at.nc.skillName);
	printf("nws_print_obj(): attr:%s\n", obj->at.nc.member);
	printf("nws_print_obj(): attr:%s\n", obj->at.nc.period);
  }
  else if (!strcmp("nwsSeries", obj->type)) {
	printf("nws_print_obj(): attr:%s\n", obj->at.ns.target);
	printf("nws_print_obj(): attr:%s\n", obj->at.ns.memory);
	printf("nws_print_obj(): attr:%s\n", obj->at.ns.label);
	printf("nws_print_obj(): attr:%s\n", obj->at.ns.option);
	printf("nws_print_obj(): attr:%s\n", obj->at.ns.resource);
	printf("nws_print_obj(): attr:%s\n", obj->at.ns.activity);
	printf("nws_print_obj(): attr:%s\n", obj->at.ns.buffer);
	printf("nws_print_obj(): attr:%s\n", obj->at.ns.message);
	printf("nws_print_obj(): attr:%s\n", obj->at.ns.size);
	printf("nws_print_obj(): attr:%s\n", obj->at.ns.target);
	printf("nws_print_obj(): attr:%s\n", obj->at.ns.host);
	printf("nws_print_obj(): attr:%s\n", obj->at.ns.nice);
	printf("nws_print_obj(): attr:%s\n", obj->at.ns.type);
  }
  else if (!strcmp("nwsActivity", obj->type)) {
	printf("nws_print_obj(): attr:%s\n", obj->at.na.controlName);
	printf("nws_print_obj(): attr:%s\n", obj->at.na.host);
	printf("nws_print_obj(): attr:%s\n", obj->at.na.option);
	printf("nws_print_obj(): attr:%s\n", obj->at.na.resource);
	printf("nws_print_obj(): attr:%s\n", obj->at.na.skillName);
	printf("nws_print_obj(): attr:%s\n", obj->at.na.size);
	printf("nws_print_obj(): attr:%s\n", obj->at.na.period);
	printf("nws_print_obj(): attr:%s\n", obj->at.na.member);
	printf("nws_print_obj(): attr:%s\n", obj->at.na.type);
	printf("nws_print_obj(): attr:%s\n", obj->at.na.buffer);
	printf("nws_print_obj(): attr:%s\n", obj->at.na.message);
  }
  else if (!strcmp("nwsSkill", obj->type)) {
	printf("nws_print_obj(): attr:%s\n", obj->at.nk.host);
	printf("nws_print_obj(): attr:%s\n", obj->at.nk.option);
	printf("nws_print_obj(): attr:%s\n", obj->at.nk.skillName);
	printf("nws_print_obj(): attr:%s\n", obj->at.nk.path);
	printf("nws_print_obj(): attr:%s\n", obj->at.nk.nice);
	printf("nws_print_obj(): attr:%s\n", obj->at.nk.type);
	printf("nws_print_obj(): attr:%s\n", obj->at.nk.target);
	printf("nws_print_obj(): attr:%s\n", obj->at.nk.buffer);
	printf("nws_print_obj(): attr:%s\n", obj->at.nk.message);
	printf("nws_print_obj(): attr:%s\n", obj->at.nk.size);
  }
  return(1);

}
int
nws_free_obj(NWSobj *obj)
{
  if (!strcmp("nwsHost", obj->type)) {
	check_free(obj->at.nd.hostname);
	check_free(obj->at.nd.daemonType);
	check_free(obj->at.nd.ipAddress);
	check_free(obj->at.nd.owner);
	check_free(obj->at.nd.port);
	check_free(obj->at.nd.started);
	check_free(obj->at.nd.version);
  }
  else if (!strcmp("nwsControl", obj->type)) {
	check_free(obj->at.nc.controlName);
	check_free(obj->at.nc.host);
	check_free(obj->at.nc.option);
	check_free(obj->at.nc.skillName);
	check_free(obj->at.nc.member);
	check_free(obj->at.nc.period);
  }
  else if (!strcmp("nwsSeries", obj->type)) {
	check_free(obj->at.ns.host);
	check_free(obj->at.ns.label);
	check_free(obj->at.ns.memory);
	check_free(obj->at.ns.option);
	check_free(obj->at.ns.resource);
	check_free(obj->at.ns.activity);
	check_free(obj->at.ns.buffer);
	check_free(obj->at.ns.message);
	check_free(obj->at.ns.size);
	check_free(obj->at.ns.target);
	check_free(obj->at.ns.nice);
	check_free(obj->at.ns.type);
  }
  else if (!strcmp("nwsActivity", obj->type)) {
	check_free(obj->at.na.controlName);
	check_free(obj->at.na.host);
	check_free(obj->at.na.option);
	check_free(obj->at.na.resource);
	check_free(obj->at.na.skillName);
	check_free(obj->at.na.period);
	check_free(obj->at.na.member);
	check_free(obj->at.na.type);
	check_free(obj->at.na.size);
	check_free(obj->at.na.buffer);
	check_free(obj->at.na.message);
  }
  else if (!strcmp("nwsSkill", obj->type)) {
	check_free(obj->at.nk.host);
	check_free(obj->at.nk.option);
	check_free(obj->at.nk.skillName);
	check_free(obj->at.nk.path);
	check_free(obj->at.nk.nice);
	check_free(obj->at.nk.type);
	check_free(obj->at.nk.target);
	check_free(obj->at.nk.buffer);
	check_free(obj->at.nk.message);
	check_free(obj->at.nk.size);
  }
  else {
	printf("nws_free_obj(): Unknown object type: '%s'='%x' (obj->name = %s)\n",
		   obj->type, obj->itype, obj->name);
	exit(-1);
  }

  if(obj->name != NULL) {
	free(obj->name);
  }
  else {
	printf("nws_free_obj(): obj->name is NULL.\n");
	exit(-1);
  }

  if(obj->type != NULL) {
	free(obj->type);
  }
  else {
	printf("nws_free_obj(): obj->type is NULL.\n");
	exit(-1);
  }

  free(obj);
  
  return(1);
}

/*
 * List operations
 */

int
nws_list_init(struct nws_list *list)
{
  list->count = 0;
  list->item = (char **)malloc(sizeof(char *));
  list->item[0] = NULL;
  return(1);
}

int 
nws_list_add(struct nws_list *list, char *addme)
{

  list->item = (char **)realloc(list->item,
								(sizeof(char *) * list->count + 1));
  list->count++;
  list->item[list->count - 1] = addme;
  list->item[list->count] = NULL;

  return(1);
  
}

char *
nws_list_read(struct nws_list *list)
{
  char *retval;

  if(list->count == 0) {
	return(NULL);
  }

  retval = list->item[list->count - 1];
  list->count--;
  list->item = (char **)realloc(list->item,
								(sizeof(char *) * list->count + 1));
  list->item[list->count] = NULL;
  return(retval);
}

int
nws_list_clear(struct nws_list *list)
{
  int i;

  for(i = 0; i < list->count; i++) {
	free(list->item[i]);
  }

  list->count = 0;
  list->item = (char **)realloc(list->item,
								(sizeof(char *) * list->count + 1));
  list->item[list->count] = NULL;
  return(1);
}

int
nws_list_print(struct nws_list *list) {
  int i;

  for(i = 0; i < list->count; i++) {
	printf("nws_list_print(): %s\n", list->item[i]);
  }

  return(1);
}
