#     Copyright 2012, Kay Hayen, mailto:kayhayen@gmx.de
#
#     Part of "Nuitka", an optimizing Python compiler that is compatible and
#     integrates with CPython, but also works on its own.
#
#     If you submit patches or make the software available to licensors of
#     this software in either form, you automatically them grant them a
#     license for your part of the code under "Apache License 2.0" unless you
#     choose to remove this notice.
#
#     Kay Hayen uses the right to license his code under only GPL version 3,
#     to discourage a fork of Nuitka before it is "finished". He will later
#     make a new "Nuitka" release fully under "Apache License 2.0".
#
#     This program is free software: you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation, version 3 of the License.
#
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#     Please leave the whole of this copyright notice intact.
#
""" Call related templates.

"""

# Bad to read, but we wan't the helper name to say it all and the call on same line
# pylint: disable=C0301

template_call_star_dict = """\
CALL_FUNCTION_WITH_STAR_DICT( %(function)s, %(star_dict_arg)s )"""

template_call_star_list = """\
CALL_FUNCTION_WITH_STAR_LIST( %(function)s, %(star_list_arg)s )"""

template_call_star_list_star_dict = """\
CALL_FUNCTION_WITH_STAR_LIST_STAR_DICT( %(function)s, %(star_list_arg)s, %(star_dict_arg)s )"""

template_call_pos_star_dict = """\
CALL_FUNCTION_WITH_POSARGS_STAR_DICT( %(function)s, %(pos_args)s, %(star_dict_arg)s )"""

template_call_pos_star_list = """\
CALL_FUNCTION_WITH_POSARGS_STAR_LIST( %(function)s, %(pos_args)s, %(star_list_arg)s )"""

template_call_pos_star_list_star_dict = """\
CALL_FUNCTION_WITH_POSARGS_STAR_LIST_STAR_DICT( %(function)s, %(pos_args)s, %(star_list_arg)s, %(star_dict_arg)s )"""

template_call_pos_named_star_list = """\
CALL_FUNCTION_WITH_POSARGS_KEYARGS_STAR_LIST( %(function)s, %(pos_args)s, %(named_args)s, %(star_list_arg)s )"""

template_call_pos_named_star_dict = """\
CALL_FUNCTION_WITH_POSARGS_KEYARGS_STAR_DICT( %(function)s, %(pos_args)s, %(named_args)s, %(star_dict_arg)s )"""

template_call_pos_named_star_list_star_dict = """\
CALL_FUNCTION_WITH_POSARGS_KEYARGS_STAR_LIST_STAR_DICT( %(function)s, %(pos_args)s, %(named_args)s, %(star_list_arg)s, %(star_dict_arg)s )"""

template_call_named_star_list = """\
CALL_FUNCTION_WITH_KEYARGS_STAR_LIST( %(function)s, %(named_args)s, %(star_list_arg)s )"""

template_call_named_star_dict = """\
CALL_FUNCTION_WITH_KEYARGS_STAR_DICT( %(function)s, %(named_args)s, %(star_dict_arg)s )"""

template_call_named_star_list_star_dict = """\
CALL_FUNCTION_WITH_KEYARGS_STAR_LIST_STAR_DICT( %(function)s, %(named_args)s, %(star_list_arg)s, %(star_dict_arg)s )"""

template_reverse_macros_declaration = """\
#include "nuitka/eval_order.hpp"

#if NUITKA_REVERSED_ARGS == 0
%(noreverse_macros)s
#else
%(reverse_macros)s
#endif
"""
