/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#ifndef STAFF_H

#define STAFF_H
#include "config.h"
#include "resource.h"

#include <gtk/gtk.h>
#include <cairo.h>

class NedMainWindow;
class NedPage;
class NedSystem;
class NedVoice;
class NedChordOrRest;
class NedClipBoard;
class NedCommandList;
struct VoiceInfoContainer;
class NedMeasure;
class NedSlur;
class part;

class NedStaff {
	public:
		NedStaff(NedSystem *system, double ypos, double width, int nr, bool start);
		~NedStaff();
		void draw(cairo_t *cr, double botpos, bool first_page, double indent);
		NedMainWindow *getMainWindow();
		NedPage *getPage();
		NedSystem *getSystem() {return m_system;}
		int getStaffNumber() {return m_staff_number;}
		bool truncateAtStart(NedCommandList *command_list, unsigned long long midi_time);
		void setStaffNumber(int nr) {m_staff_number = nr;}
		void prepareForImport();
		void appendElementsOfMeasureLength(part *part_ptr, unsigned int meas_duration, int meas_num);
		void removeLastImported();
		bool handleImportedTuplets();
		void handleStaffElements();
		//bool find_new_cursor_pos(guint keyval, int *x, int *y, double *dist);
		bool trySelect (double x, double y, bool only_free_placeables);
		NedChordOrRest *findNearestElement(double x, double y, NedStaff *oldstaff, double *mindist, double *ydist);
		bool tryInsertOrErease (double x, double y, NedChordOrRest **newObj, bool force_rest);
		bool tryErease (double x, double y);
		bool findLine(double x, double y, double *ypos, int *line, double *bottom);
		double getBottomPos();
		double getMidPos();
		double getTopPos() {return m_ypos;}
		double getWidth() {return m_width;}
		double getRealYPosOfLine(int line);
		void setWidth(double w) {m_width = w;}
		double getHeight();
		void empty();
		bool hasOnlyRests();
		void cutEmptyVoices();
		void computeBeams();
		void computeTuplets();
		unsigned int getStaffDurationTotal();
		void resetPositionPointers(bool reset_multiple_flag = TRUE, bool resetRestYPos = FALSE);
		double computeMidDist(double y);
		void changeDirs();
		void placeRests(int position_counter);
		void collectChordsAndRests(NedClipBoard *board, unsigned long long midi_start, unsigned long long midi_end);
		void collectDestinationVoices(NedClipBoard *board);
		void collectElmentsAfter(unsigned long long midi_time, VoiceInfoContainer *containers, int *num_containers);
		void shiftX(int pc, double shift);
		bool tryChangeLength(NedChordOrRest *chord_or_rest);
		void searchForBeamGroups(unsigned int midi_start_time);
		double getTopYBorder() {return m_top_y_border;}
		double getBottomYBorder() {return m_bottom_y_border;}
		void convertStaffRel(double x, double y, double *x_trans, double *y_trans);
		double placeStaff(double staffpos);
		int getNumberOfVoices(int staff_number);
		void saveStaff(FILE *fp);
		void restoreStaff(FILE *fp);
		int computeVolume(unsigned long long midi_time);
		void prepareReplay();
		void findAccidentals(char offs_array[115], NedMeasure *meas_info, unsigned long long midi_time);
		void removeUnneededAccidentals();
		void appendWholeRest(NedCommandList *command_list = NULL);
		void stemDirDecicion(int position_counter);
		void getCurrentClefAndKeysig(unsigned long long miditime, int *clef, int *keysig, int *octave_shift);
		void appendAppropriateWholes(int start_measure);
		void setUpbeatRests(unsigned int upbeat_inverse);
		void testTies();
		bool hasReallyMultipleVoices() {return m_real_multiple_voices;}
		void collectSelectionRectangleElements(double xp, double yp, NedBbox *sel_rect, GList **sel_group,
			bool is_first_selected, bool is_last_selected);
		void findSelectedStaffs(double yp, NedBbox *sel_rect, int *number_of_first_selected_staff, int *number_of_last_selected_staff);
		void pasteElements(NedCommandList *command_list, GList **elements, int from_staff, unsigned long long start_midi_time);
		bool hasTupletConflict(unsigned int meas_duration, GList **elements, int from_staff, unsigned int long long midi_time);
		bool findFromTo(GList *clipboard);
		bool findStartMeasureLimits(GList *clipboard, unsigned long long *start_midi);
		bool findEndMeasureLimits(GList *clipboard, unsigned long long *end_midi);
		void deleteItemsFromTo(NedCommandList *command_list, bool is_first, bool is_last, unsigned long long start_midi, unsigned long long end_midi);
		void removeNotesFromTo(NedCommandList *command_list, GList *items, bool is_first, bool is_last);
		void insertBlocks(NedCommandList *command_list, int blockcount, unsigned long long midi_time);
		void testForPageBackwardTies(NedCommandList *command_list);
		void checkForElementsToSplit(NedCommandList *command_list);
		void placeCurrentElementAt(double xpos);
		void incrElementPointer();
		void insertStaffElement(NedChordOrRest *elem, bool redraw = true);
		void removeStaffElement(NedChordOrRest *elem);
		void deleteStaffElements(bool unexecute, GList *elems, unsigned long long reftime, unsigned long duration);
		bool hasStaffElem(unsigned long long miditime);
		void insertIntoStaff(GList *elems, unsigned long long duration);
		void appendAtStaff(GList *elems);
		void setAndUpdateClefTypeAndKeySig(int *clef_and_key_array, bool first);
		double getSystemEnd();
		double getSystemStart();
		GList *getFirstChordOrRest(int voice_nr, int lyrics_line, bool lyrics_required);
		GList *getLastChordOrRest(int voice_nr, int lyrics_line, bool lyrics_required);
		void determineVolume(unsigned int *vol, NedChordOrRest *element, int staff_nr);
		void determineTempoInverse(NedChordOrRest *element, unsigned long long till, double *tempoinverse, bool *found);
		bool detectVoices(unsigned int *voice_mask, unsigned long long *e_time);
		void exportLilyPond(FILE *fp, int voice_nr, int *last_line, unsigned int *midi_len,
				bool last_system, unsigned long long end_time, bool *in_alternative, NedSlur **lily_slur, unsigned int *lyrics_map);
		void exportLilyLyrics(FILE *fp, bool last_system, int voice_nr, int line_nr, unsigned long long end_time, int *sil_count);
		GList *getStaffElements(unsigned long long midi_time);
		static const char m_sharpPos[7][7];
		static const char m_flatPos[7][7];
	private:
		GList *m_position_ptr;
		GList *m_staffelems;
		NedVoice *m_voices[VOICE_COUNT];
		double m_ypos;
		double m_width;
		double m_top_y_border;
		int m_lyrics_lines;
		double m_bottom_y_border;
		int m_staff_number;
		int m_clef_type;
		int m_clef_octave_shift;
		int m_keysig;
		GList *m_volume_changes;
		NedSystem *m_system;
		bool m_real_multiple_voices;
};

#endif /* STAFF_H */
