var str = '"BB"/** sdfsdfs **/"CC"';
var str2 = '"BBB"/* sdfsdfs */ "CCC" /* "asdfasdf" **/ \n' +
          '"D""E"';


function extractStrings(str) {

	var result = [];

	var quote_opened;
	var afterSlash;
	var comment_opened;
	var buffer = '';

	for (var i = 0, character; character = str[i]; i++) {
		switch (character) {
			case '"':
				if (comment_opened) {
					break;
				}
				if (quote_opened) {
					result.push(buffer);
					buffer = '';
					quote_opened = false;
				} else {
					quote_opened = true;
				}
				break;
			case '/':
				if (quote_opened) {
					buffer += character;
				} else if (str[i + 1] == '*') {
					i++;
					comment_opened = true;
				}
				break;
			case '*':
				if (quote_opened) {
					buffer += character;
				} else if (comment_opened && str[i + 1] == '/') {
					i++;
					comment_opened = false;
				} else if (quote_opened && !comment_opened) {
					buffer += character;
				}
				break;
			default:
				if (quote_opened) {
					buffer += character;
				}
				break;
		}
	}

	return result;
}


console.log(extractStrings('"AAA"'));
console.log(extractStrings('"/*AAA*/"'));
console.log(extractStrings('/*"BBB"*/'));
console.log(extractStrings('/**"BBB"**/'));
console.log(extractStrings('"/*A" BBB "A*/"'));