/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#include <iostream>

#ifndef yf_defsHPP
#define yf_defsHPP

#define DEPRECATED   // label for deprecated code
#define EXPERIMENTAL // label for experimental code
#define INCOMPLETE   // label for incomplete code

#ifndef NDEBUG
	#define YF_ENABLE_CHECKS
#endif

#if defined(__BORLANDC__)
    #define OS_WINDOWS
#elif defined(WIN32) or defined(__WIN32) or defined(__WIN32__)
	#define OS_WINDOWS
#elif defined(LINUX) or defined(__LINUX) or defined(__LINUX__)
	#define OS_LINUX
#else
	#error You must specify you OS. Now supported next ones: WIN32, LINUX.
#endif

/*
#if not defined(YF_CODE_32) and not defined(YF_CODE_64)
	#error You must specify you your system bitness (YF_CODE_32 or YF_CODE_64)
#endif
*/
#ifdef __LP64__
	#define YF_CODE_64
#else
	#define YF_CODE_32
#endif

#ifdef OS_WINDOWS
	#include <windows.h>
#endif

//------------------------------------------------------------------------------
	// define YF_ENABLE_CHECKS if you want to verify exceptions in some classes...
	// define USE_YFSTRING if you want to use yf::sstring instead of std::string
//------------------------------------------------------------------------------

typedef unsigned long ulong; // 4/8 bytes
typedef unsigned int uint; // 4 bytes
typedef unsigned short ushort; // 2 bytes
typedef unsigned char byte; // 1 bytes
typedef unsigned long long ullong; // 8 bytes
typedef long long llong; // 8 bytes
typedef long double ldouble; // 10 bytes
typedef byte uint8;

#ifdef YF_CODE_64
	typedef unsigned short 	uint16;
	typedef unsigned int	uint32;
	typedef unsigned long	uint64;
	typedef short			sint16;
	typedef int				sint32;
	typedef long			sint64;
#else /* YF_CODE_32 */
	typedef unsigned short		uint16;
	typedef unsigned long		uint32;
	typedef unsigned long long	uint64;
	typedef short				sint16;
	typedef long				sint32;
	typedef long long			sint64;
#endif

namespace yf
{
	const byte LONG_DEC_LEN = 11;
	DEPRECATED const byte NAME_LEN = 50;

	const uint16  millisec_in_second = 1000;
	const byte  sec_in_minute = 60;
	const byte  min_in_hour = 60;
	const byte  hour_in_day = 24;

	const byte max_byte	= 0xFF ;
	const byte min_byte = 0x00 ;
	const char max_char = max_byte/2 ;
	const char min_char = -1 * (max_byte/2) - 1 ;

	const uint32 max_uint32  = 0xFFFFFFFF ;
	const uint32 min_uint32  = 0u ;
	const sint32 max_sint32  = max_uint32/2 ;
	const sint32 min_sint32  = -1 * (max_uint32/2) - 1 ;

	const uint16 max_uint16  = 0xFFFF ;
	const uint16 min_uint16  = 0 ;
	const sint16 max_sint16  = max_uint16/2 ;
	const sint16 min_sint16  = -1 * (max_uint16/2) - 1 ;

	#if (__GNUC__>4)
		const uint64 max_uint64 = 0xFFFFFFFFFFFFFFFF ;
	#else
		const uint64 max_uint64 = (max_uint64)-1;
	#endif
	const uint64 min_uint64 = 0 ;
	//------------------------------------------------------------------------------
	const ushort bits_in_byte  = 8;
	DEPRECATED const ushort bits_in_short = bits_in_byte * 2;
	DEPRECATED const ushort bits_in_long  = bits_in_byte * 4;
	DEPRECATED const ushort bits_in_llong = bits_in_byte * 8;
	//------------------------------------------------------------------------------
	DEPRECATED const ushort byte_size  = 1ul;
	DEPRECATED const ushort short_size = bits_in_short / bits_in_byte;
	DEPRECATED const ushort long_size  = bits_in_long  / bits_in_byte;
	DEPRECATED const ushort llong_size = bits_in_llong / bits_in_byte;
	//--------------------------------------------------------------
	const size_t npos = (size_t)-1;
	//------------------------------------------------------------------------------
	const size_t line_max = 255;
	//--------------------------------------------------------------
	/* some inline auxiliary functions */
	/**
	 * @brief 	Inverts uint32 value to sint32 value
	 * @param	value  Value to be inverted
	 * @return	Inverted value
	 */
	inline sint32 inv(uint32 value) { return -( (sint32)value ); }
}
#endif
