/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import gnu.bytecode.ArrayType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.ProcedureN;
import nice.tools.code.SpecialArray;

public class MultiArrayNewProc
extends ProcedureN
implements Inlineable {
    private ArrayType arrayType;
    private int nbDimensions;

    public MultiArrayNewProc(ArrayType arrayType, int nbDimensions) {
        this.arrayType = arrayType;
        this.nbDimensions = nbDimensions;
    }

    @Override
    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        for (int i = 0; i < this.nbDimensions; ++i) {
            args[i].compile(comp, Type.int_type);
        }
        this.arrayType = MultiArrayNewProc.creationType(this.arrayType, target, false);
        comp.getCode().emitNewArray(this.arrayType.getComponentType(), this.nbDimensions);
        target.compileFromStack(comp, this.arrayType);
    }

    static ArrayType creationType(ArrayType computedType, Target target, boolean promote) {
        ArrayType targetType;
        if (target.getType() instanceof ArrayType && MultiArrayNewProc.hasPrimitiveComponents(targetType = (ArrayType)target.getType())) {
            return targetType;
        }
        if (promote) {
            return MultiArrayNewProc.promoteComponent(computedType);
        }
        return computedType;
    }

    private static boolean hasPrimitiveComponents(ArrayType array) {
        Type componentType = array.getComponentType();
        return componentType instanceof ArrayType || componentType instanceof PrimType;
    }

    private static ArrayType promoteComponent(ArrayType array) {
        Type type = array.getComponentType();
        Type promoted = type == Type.byte_type || type == Type.short_type ? Type.int_type : (type.isArray() ? MultiArrayNewProc.promoteComponent((ArrayType)type) : type);
        if (promoted != type) {
            return SpecialArray.create(promoted);
        }
        return array;
    }

    @Override
    public Type getReturnType(Expression[] args) {
        return this.arrayType;
    }

    @Override
    public Object applyN(Object[] args) {
        throw new Error("Not implemented");
    }
}

