/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.SeriesTarget;
import gnu.expr.Target;

public class ConsumerTarget
extends Target {
    Variable consumer;

    public ConsumerTarget(Variable consumer) {
        this.consumer = consumer;
    }

    public Variable getConsumerVariable() {
        return this.consumer;
    }

    public static void compileUsingConsumer(Expression exp, Compilation comp, Target target) {
        if (target instanceof ConsumerTarget || target instanceof IgnoreTarget) {
            exp.compile(comp, target);
        } else {
            CodeAttr code = comp.getCode();
            Scope scope = code.pushScope();
            Variable values = scope.addVariable(code, Compilation.typeValues, null);
            ConsumerTarget ctarget = new ConsumerTarget(values);
            code.emitInvokeStatic(Compilation.typeValues.getDeclaredMethod("make", 0));
            code.emitStore(values);
            exp.compile(comp, ctarget);
            code.emitLoad(values);
            code.popScope();
            target.compileFromStack(comp, Compilation.typeValues);
        }
    }

    @Override
    public void compileFromStack(Compilation comp, Type stackType) {
        CodeAttr code = comp.getCode();
        String methodName = null;
        Method method = null;
        if (stackType instanceof PrimType) {
            char sig = stackType.getSignature().charAt(0);
            switch (sig) {
                case 'B': 
                case 'I': 
                case 'S': {
                    methodName = "writeInt";
                    break;
                }
                case 'J': {
                    methodName = "writeLong";
                    break;
                }
                case 'F': {
                    methodName = "writeFloat";
                    break;
                }
                case 'D': {
                    methodName = "writeDouble";
                    break;
                }
                case 'C': {
                    methodName = "writeChar";
                    break;
                }
                case 'Z': {
                    methodName = "writeBoolean";
                    break;
                }
                case 'V': {
                    return;
                }
            }
        } else if (SeriesTarget.isSingletonType(stackType)) {
            methodName = "writeObject";
        } else {
            method = Compilation.typeValues.getDeclaredMethod("writeValues", 2);
            code.emitLoad(this.consumer);
            code.emitInvokeStatic(method);
            return;
        }
        code.emitLoad(this.consumer);
        code.emitSwap();
        if (method == null && methodName != null) {
            method = Compilation.typeConsumer.getDeclaredMethod(methodName, 1);
        }
        if (method != null) {
            code.emitInvokeInterface(method);
        }
    }

    @Override
    public Type getType() {
        return Compilation.scmSequenceType;
    }
}

