/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// SockServerOCSP.cpp: implementation of the SockServerOCSP class.
//
//////////////////////////////////////////////////////////////////////
#include <openssl/ocsp.h>

#include "SockServerOCSP.h"
#include "svintl.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


SockServerOCSP::SockServerOCSP():SOCK_SERVER(MAX_OCSP_CONNECTIONS)
{
}

SockServerOCSP::~SockServerOCSP()
{
}

void SockServerOCSP::OnServerStopped()
{
}

void SockServerOCSP::OnConnection(const char * Ip, SOCKET connection)
{
	BIO * sconn;
	BIO * conn;
	
	conn = BIO_new(BIO_f_buffer());
	if(!conn)
	{
		closesocket(connection);
		return;
	}
	sconn = BIO_new_socket(connection, BIO_CLOSE);
	if(!sconn)
	{
		BIO_free_all(conn);
		return;
	}
	BIO_push(conn, sconn);


	int have_post = 0;
	OCSP_REQUEST * req = NULL;
	OCSP_RESPONSE * resp;
	char inbuf[1024];
	bool ShouldStopServer = false;
	char http_resp[] = 
		"HTTP/1.0 200 OK\r\nContent-type: application/ocsp-response\r\n"
		"Content-Length: %d\r\n\r\n";

	while(BIO_gets(conn, inbuf, sizeof(inbuf)) > 0)
	{
		// Look for "POST" signalling start of query
		if (!have_post)
		{
			if(strncmp(inbuf, "POST", 4))
			{
				break;
			}
			have_post = 1;
		}
		// Look for end of headers
		if ((inbuf[0] == '\r') || (inbuf[0] == '\n')) break;
	}
	// was not an error
	if(have_post && (req = (OCSP_REQUEST*)ASN1_d2i_bio( (char *(*)())OCSP_REQUEST_new, (char*(*)())d2i_OCSP_REQUEST, conn, NULL)) )
	{
		resp = NULL;
		m_Central->OnNewOCSP(Ip, req, &resp, m_PubEntityName, ShouldStopServer);
		if(ShouldStopServer)
		{
			AddRecvBytes(BIO_number_read(conn));
			AddSentBytes(BIO_number_written(conn));
			BIO_free_all(conn);
			Stop();
			OCSP_REQUEST_free(req);
			if(resp)
				OCSP_RESPONSE_free(resp);
			return;
		}
		OCSP_REQUEST_free(req);

		if(resp)
		{
			if(BIO_printf(conn, http_resp, i2d_OCSP_RESPONSE(resp, NULL)) > 0)
			{
				if(ASN1_i2d_bio((int (*)(void))i2d_OCSP_RESPONSE, conn, (unsigned char *)resp) > 0)
				{
					BIO_flush(conn);
				}
			}
			OCSP_RESPONSE_free(resp);
		}
	}

	AddRecvBytes(BIO_number_read(conn));
	AddSentBytes(BIO_number_written(conn));
	BIO_free_all(conn);
}

void SockServerOCSP::OnServerStarted()
{

}

bool SockServerOCSP::Load(PKIX_Central *Central, const mString & PubEntityName)
{
	m_Central = Central;
	m_PubEntityName = PubEntityName;
	return true;
}

