/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// SmtpClient.h: interface for the SmtpClient class.
//
//////////////////////////////////////////////////////////////////////

#ifndef SMTPCLIENT_H
#define SMTPCLIENT_H

#include <UnixWinSock.h>
#include <openssl/stack.h>
#include "EntityLog.h"
#include <FileLog.h>


#include <mString.h>
#include <PEM_DER.h>


/*!
	The class represents a mailer
*/
class SmtpClient  
{
public:
	/*! \brief This is the constructor.
	 */
	SmtpClient();
	
	/*! \brief This is the destructor.
	 */
	virtual ~SmtpClient();

	/*! \brief Set the SMTP server info.
	 *  \param MailFrom [IN] The SMTP Mail From.
	 *  \param Server [IN] The SMTP Server Address.
	 *  \param Port [IN] The SMTP Server Port.
	 *  \param Logging [IN] The logging class.
	 *  \return true on success, false on failure.
	 */
	bool SetInfo(mString MailFrom, mString Server, int Port, EntityLog * Logging);

	/*! \brief This function send an email.
	 *  \param AdminMail [IN] Is it an administrative mail.
	 *  \param MailTo [IN] The mail recipients.
	 *  \param Subject [IN] The mail subject.
	 *  \param Body [IN] The mail body.
	 *  \return true on success, false on failure.
	 */
	bool Send(bool AdminMail, const mVector<mString> & MailTo, mString Subject, mString Body) const;

	/*! \brief This function returns whether or not the mailer is enabled.
	 *  \return true when enabled, false when disabled.
	 */
	bool IsEnabled() const;

	/*! \brief This function return 1 when mailer is operable and 0 when not.
	 *  \return return 1 when mailer is operable and 0 when not.
	 */
	operator int() const;
private:
	bool ResolveServer();
	void LogError(bool AdminMail, const mString & MailTo, mString * cmd, mString * resp) const;
	bool Private_Send(bool AdminMail, const mString & MailTo, const mString & Subject, const mString & Body) const;
	bool m_IsEnabled;

	bool SendSmtp(SOCKET hSocket, mString & cmd, int Code, bool AdminMail, const mString & MailTo) const;
	bool ReceiveSmtp(SOCKET hSocket, mString * cmd, int Code, bool AdminMail, const mString & MailTo) const;
	sockaddr_in sockin;
	mString m_MailFrom;
	mString m_Server;
	int m_Port;
	EntityLog * m_Logging;
	PEM_DER PemCvrt;
};

#endif // MAILS_H
