/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

#if defined(_WIN32) && !defined(NO_BIO_MS_SSL)

#ifndef BIO_MS_SSL_H
#define BIO_MS_SSL_H

#include <windows.h>
#include <wincrypt.h>
#undef X509_NAME
#include <openssl/bio.h>

#ifdef  __cplusplus
extern "C" {
#endif

BIO *BIO_new_ms_ssl(BIO * rwbio, PCERT_CONTEXT pCert);
BIO_METHOD *BIO_f_ms_ssl(void);

#define BIO_C_SET_BIO		100
#define BIO_C_SET_CERT		101
#define BIO_C_GET_BIO		103
#define BIO_C_GET_PEER		104
#define BIO_C_DO_CONNECT	105

#define BIO_ms_ssl_get_bio(b) (BIO*)BIO_ctrl(b, BIO_C_GET_BIO, 0, NULL)
#define BIO_ms_ssl_set_cert(b, c) BIO_ctrl(b, BIO_C_SET_CERT, 0, (void*)c)
#define BIO_ms_ssl_set_bio(b, c)  BIO_ctrl(b, BIO_C_SET_BIO, 0, (void*)c)
#define BIO_ms_ssl_get_peer(b)  (X509*)BIO_ctrl(b, BIO_C_GET_PEER, 0, NULL)
#define BIO_ms_ssl_connect(b)  (X509*)BIO_ctrl(b, BIO_C_DO_CONNECT, 0, NULL)

#ifdef  __cplusplus
}
#endif

#endif

#endif
