/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// HashTable_Dn.h: interface for the HashTable_Dn class.
//
//////////////////////////////////////////////////////////////////////

#ifndef HASHTABLE_DN_H
#define HASHTABLE_DN_H



#include "PKI_HashTable.h"
#include "HashTable_String.h"

#include <Objects.h>
#include <openssl/x509.h>



/*!
  This represents a DN
*/
class HashTable_Dn : public PKI_HashTable
{
public:
	/*! \brief This is the constructor.
	 */
	HashTable_Dn();

	/*! \brief This is the destructor.
	 */
	virtual ~HashTable_Dn();

	/*! \brief This function adds one entry to the hashtable.
	 *  \param Name [IN] The Name of the new entry to add.
	 *  \param Value [IN] The value associated with the new entry.
	 *  \return true on success, false on failure.
	 */
	bool Add(const char * Name, const char * Value);
	
	/*! \brief This function modify an entry of the hashtable.
	 *  \param Pos [IN] The index of the new entry to modify.
	 *  \param Value [IN] The new value associated with the entry Name.
	 *  \return true on success, false on failure.
	 */
	bool Modify(long Pos, const char * Value);
	
	/*! \brief This function returns one entry.
	 *  \param Pos [IN] The position of the entry to return.
	 *  \return The entry.
	 */
	const char * Get(long Pos) const;

	/*! \brief This operator copies one HashTable_Dn into another.
	 *  \param other [IN] The other DN to copy from.
	 *  \return true on success, false on failure.
	 */
	bool operator=(const HashTable_Dn &other);

	/*! \brief This function is used to validate a DN.
	 *  \param Policies [IN] The policies to validate the DN against.
	 *  \return true on success, false on failure.
	 */
	bool ValidateAgainstPolicy(const HashTable_String & Policies);

	/*! \brief This function converts the DN to a X509_NAME.
	 *  \param name [OUT] The X509_NAME.
	 *  \return true on success, false on failure.
	 */
	bool To_X509_NAME(X509_NAME * name) const;

	/*! \brief This function loads the DN from a X509_NAME.
	 *  \param name [IN] The X509_NAME.
	 *  \return true on success, false on failure.
	 */
	bool From_X509_NAME(const X509_NAME * name);
};
#endif
