/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgSetRepsOrder.cpp: implementation of the DlgSetRepsOrder class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgSetRepsOrder.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgSetRepsOrder, wxDialog)
    EVT_BUTTON(IDC_OK, DlgSetRepsOrder::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgSetRepsOrder::OnCancel)
    EVT_BUTTON(IDC_MOVE_UP, DlgSetRepsOrder::OnMoveUp)
    EVT_BUTTON(IDC_MOVE_DOWN, DlgSetRepsOrder::OnMoveDown)
END_EVENT_TABLE()

DlgSetRepsOrder::DlgSetRepsOrder(wxWindow * wParent, mVector<EntityLinkInfo> & list):wxDialog(wParent, (wxWindowID)-1, _("Set repositories order"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION), m_list(list)
{
	DlgSetRepsOrder_SetWindow(this);

	m_listCtrl = ((wxListCtrl *)FindWindow(ID_LISTCTRL));

	m_imageListSmall = new wxImageList(16, 16, TRUE);
	wxIcon ico;
	ico.CopyFromBitmap(Entities_GetBitmap(IDB_REP_SMALL));
	m_imageListSmall->Add( ico );


	m_listCtrl->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listCtrl->InsertColumn(0, _("Name"), wxLIST_FORMAT_LEFT, 150);

	size_t i;
	int pos;
	for(i=0; i<m_list.size(); i++)
	{
		if(m_list[i].get_type() == ENTITY_TYPE_REPOSITORY)
		{
			pos = m_listCtrl->GetItemCount();
			m_listCtrl->InsertItem(pos, m_list[i].get_name().c_str(), 0);
			m_listCtrl->SetItemData(pos, (long)i);
		}
	}

	CenterOnScreen();
	ShowModal();
	
}

DlgSetRepsOrder::~DlgSetRepsOrder()
{
	if(m_imageListSmall) delete m_imageListSmall;
}


void DlgSetRepsOrder::OnMoveUp(wxCommandEvent& event)
{
	int SelectedItem;
	size_t index;

	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1 || SelectedItem == 0) return;
	index = (size_t)m_listCtrl->GetItemData(SelectedItem);

	m_listCtrl->DeleteItem(SelectedItem);

	m_listCtrl->InsertItem(SelectedItem-1, m_list[index].get_name().c_str(), 0);
	m_listCtrl->SetItemData(SelectedItem-1, (long)index);
	
}

void DlgSetRepsOrder::OnMoveDown(wxCommandEvent& event)
{
	int SelectedItem;
	size_t index;
	
	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	if((SelectedItem+1) >= m_listCtrl->GetItemCount()) return;
	index = (size_t)m_listCtrl->GetItemData(SelectedItem);
		
	m_listCtrl->DeleteItem(SelectedItem);

	m_listCtrl->InsertItem(SelectedItem+1, m_list[index].get_name().c_str(), 0);
	m_listCtrl->SetItemData(SelectedItem+1, (long)index);
}

void DlgSetRepsOrder::OnOk(wxCommandEvent& event)
{
	size_t i, index;
	mVector<EntityLinkInfo> list;

	//Add all the repositories to the list in display order
	for(i=0; i<(size_t)m_listCtrl->GetItemCount(); i++)
	{
		index = (size_t)m_listCtrl->GetItemData(i);
		list.push_back(m_list[index]);
	}


	//Remove all the repositories from the list
	for(i=0; i<m_list.size(); i++)
	{
		if(m_list[i].get_type() == ENTITY_TYPE_REPOSITORY)
		{
			m_list.erase(m_list.begin() + i);
			i--;
		}
	}

	//Merge the two lists
	m_list.insert(m_list.end(), list.begin(), list.end());

	Close(TRUE);
}

void DlgSetRepsOrder::OnCancel(wxCommandEvent& event)
{
	Close(TRUE);
}

