/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgManageRepInfo.cpp: implementation of the DlgManageRepInfo class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgMessage.h"
#include "DlgModifyRepInfo.h"

#include "DlgManageRepInfo.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgManageRepInfo, wxDialog)
    EVT_BUTTON(IDC_OK, DlgManageRepInfo::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgManageRepInfo::OnCancel)
    EVT_BUTTON(IDC_MODIFY, DlgManageRepInfo::OnModifyRep)
END_EVENT_TABLE()

DlgManageRepInfo::DlgManageRepInfo(wxWindow * wParent, PkiClient * ClientPKI):wxDialog(wParent, (wxWindowID)-1, _("Manage repositories info"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION)
{
	m_ClientPKI = ClientPKI;

	DlgManageRepInfo_SetWindow(this);

	m_listCtrl = ((wxListCtrl *)FindWindow(ID_LISTCTRL));

	m_imageListSmall = new wxImageList(16, 16, TRUE);
	wxIcon ico;
	ico.CopyFromBitmap(Entities_GetBitmap(IDB_REP_SMALL));
	m_imageListSmall->Add( ico );


	m_listCtrl->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listCtrl->InsertColumn(0, _("Name"), wxLIST_FORMAT_LEFT, 250);
	m_listCtrl->InsertColumn(1, _("Address"), wxLIST_FORMAT_LEFT, 90);
	m_listCtrl->InsertColumn(2, _("Port"), wxLIST_FORMAT_LEFT, 50);

	if(!ReloadList())
	{
		Close(TRUE);
		return;
	}


	CenterOnScreen();
	ShowModal();
	
}

DlgManageRepInfo::~DlgManageRepInfo()
{
	if(m_imageListSmall) delete m_imageListSmall;
}


bool DlgManageRepInfo::ReloadList()
{
	DlgMessage dlg(this);

	m_reps.clear();

	dlg.wShow(_("Loading Repositories Info..."));
	if(!m_ClientPKI->GetRepositoriesList(m_reps))
	{
		dlg.wHide();
		HandleError(m_ClientPKI->GetError(), this);
		return false;
	}
	dlg.wHide();

	PrintList();

	return true;
}


void DlgManageRepInfo::OnModifyRep(wxCommandEvent& event)
{
	int SelectedItem;
	size_t Index;
	
	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	Index = (size_t)m_listCtrl->GetItemData(SelectedItem);

	DlgModifyRepInfo Dlg(this, m_reps[Index].get_address(), m_reps[Index].get_port());
	if(!Dlg.IsOK()) return;

	m_reps[Index].set_address(Dlg.GetAddress());
	m_reps[Index].set_port(Dlg.GetPort());

	PrintList();
}

void DlgManageRepInfo::OnOk(wxCommandEvent& event)
{
	if(DisplayMessage(this, _("Are you sure to want to modify the configuration ?"), wxYES_NO) == wxNO) return;

	DlgMessage dlg(this);
	dlg.wShow(_("Setting Repositories Info..."));
	if(!m_ClientPKI->SetRepositoriesList(m_reps))
	{
		dlg.wHide();
		HandleError(m_ClientPKI->GetError(), this);
		return;
	}
	dlg.wHide();
	
	Close(TRUE);
}

void DlgManageRepInfo::OnCancel(wxCommandEvent& event)
{
	Close(TRUE);
}

void DlgManageRepInfo::PrintList()
{
	size_t i;
	char tmpDatas[50];

	m_listCtrl->DeleteAllItems();
	
	for(i=0; i<m_reps.size(); i++)
	{
		m_listCtrl->InsertItem(i, m_reps[i].get_name().c_str(), 0);
		m_listCtrl->SetItemData(i, (long)i);
		
		m_listCtrl->SetItem(i, 1, m_reps[i].get_address().c_str());
		sprintf(tmpDatas, "%ld", m_reps[i].get_port());
		m_listCtrl->SetItem(i, 2, tmpDatas);
	}
}
