/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgManageGroups.cpp: implementation of the DlgManageGroups class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgMessage.h"
#include "DlgManageGroups.h"
#include "DlgAddGroup.h"
#include "dlgs_wdr.h"
#include "clintl.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgManageGroups, wxDialog)
    EVT_BUTTON(IDC_OK, DlgManageGroups::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgManageGroups::OnCancel)
    EVT_BUTTON(IDC_ADD, DlgManageGroups::OnAdd)
    EVT_BUTTON(IDC_DEL, DlgManageGroups::OnDel)
    EVT_BUTTON(IDC_DEL_GROUP, DlgManageGroups::OnDelGroup)
    EVT_BUTTON(IDC_ADD_GROUP, DlgManageGroups::OnAddGroup)
    EVT_BUTTON(IDC_REN_GROUP, DlgManageGroups::OnRenGroup)
    EVT_COMBOBOX(IDC_GROUP, DlgManageGroups::OnGroupsChanged)
END_EVENT_TABLE()


DlgManageGroups::DlgManageGroups(wxWindow * wParent, PkiClient * ClientPki):wxDialog(wParent, (wxWindowID)-1, _("Manage Groups"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION)
{
	m_ClientPKI = ClientPki;
	m_imageListSmall = NULL;

	DlgManageGroups_SetWindow(this);

	m_listAvailable = ((wxListCtrl *)FindWindow(IDC_AVAILABE));
	m_listUsers = ((wxListCtrl *)FindWindow(IDC_USERS));

	m_imageListSmall = new wxImageList(16, 16, TRUE);
	wxIcon ico;
	ico.CopyFromBitmap(Users_GetBitmap(IDB_USER_SMALL));
	m_imageListSmall->Add( ico );

	m_listAvailable->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);
	m_listUsers->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listAvailable->InsertColumn(0, _("User DN"), wxLIST_ALIGN_DEFAULT, 250);
	m_listUsers->InsertColumn(0, _("User DN"), wxLIST_ALIGN_DEFAULT, 250);

	if(!ReloadList())
	{
		Close(TRUE);
		return;
	}

	CenterOnScreen();
	ShowModal();		
}

DlgManageGroups::~DlgManageGroups()
{
	if(m_listAvailable) m_listAvailable->ClearAll();
	if(m_listUsers) m_listUsers->ClearAll();
	if(m_imageListSmall) delete m_imageListSmall;
}

void DlgManageGroups::OnOk(wxCommandEvent& event)
{
	if(DisplayMessage(this, _("Are you sure to want to modify the groups ?"), wxYES_NO) == wxNO) return;

	DlgMessage dlg(this);
	dlg.wShow(_("Modifying Groups..."));
	if(!m_ClientPKI->SetGroups(m_groups))
	{
		dlg.wHide();
		HandleError(m_ClientPKI->GetError(), this);
		return;
	}
	dlg.wHide();

	m_IsOK = true;
	Close(TRUE);
}

void DlgManageGroups::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}


void DlgManageGroups::OnAdd(wxCommandEvent &event)
{
	unsigned long serial;
	int SelectedItem;
	size_t Index;

	SelectedItem = ((wxComboBox *)FindWindow(IDC_GROUP))->GetSelection();
	if(SelectedItem == -1) return;
	Index = (size_t)((wxComboBox *)FindWindow(IDC_GROUP))->GetClientData(SelectedItem);

	

	
	SelectedItem = m_listAvailable->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	serial = (unsigned long)m_listAvailable->GetItemData(SelectedItem);

	m_groups[Index].get_usersSerial().push_back(serial);
	
	OnGroupsChanged(event);
}

void DlgManageGroups::OnDel(wxCommandEvent &event)
{
	size_t i;
	unsigned long serial;
	int SelectedItem;
	size_t Index;

	SelectedItem = ((wxComboBox *)FindWindow(IDC_GROUP))->GetSelection();
	if(SelectedItem == -1) return;
	Index = (size_t)((wxComboBox *)FindWindow(IDC_GROUP))->GetClientData(SelectedItem);

	SelectedItem = m_listUsers->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	serial = (unsigned long)m_listUsers->GetItemData(SelectedItem);


	for(i=0; i<m_groups[Index].get_usersSerial().size(); i++)
	{
		if(m_groups[Index].get_usersSerial()[i] == serial)
		{
			m_groups[Index].get_usersSerial().erase(m_groups[Index].get_usersSerial().begin() + i);
			break;
		}
	}
	OnGroupsChanged(event);
}

bool DlgManageGroups::IsOK()
{
	return m_IsOK;
}


void DlgManageGroups::OnGroupsChanged(wxCommandEvent &event)
{
	size_t i, j;
	int SelectedItem;
	size_t Index;
	wxListCtrl * Target;
	

	
 	SelectedItem = ((wxComboBox *)FindWindow(IDC_GROUP))->GetSelection();
	if(SelectedItem == -1) return;
	Index = (size_t)((wxComboBox *)FindWindow(IDC_GROUP))->GetClientData(SelectedItem);

	m_listAvailable->DeleteAllItems();
	m_listUsers->DeleteAllItems();


	for(i=0; i<m_users.size(); i++)
	{
		for(j=0; j<m_groups[Index].get_usersSerial().size(); j++)
		{
			if(m_groups[Index].get_usersSerial()[j] == m_users[i].get_userCert().GetSerial())
				break;
		}
		if(j == m_groups[Index].get_usersSerial().size())
			Target = m_listAvailable;
		else
			Target = m_listUsers;

		j = Target->GetItemCount();
		Target->InsertItem(j, m_users[i].get_userCert().GetStringName(), 0);
		Target->SetItemData(j, m_users[i].get_userCert().GetSerial());
	}
}


bool DlgManageGroups::ReloadList()
{
	DlgMessage dlg(this);
	dlg.wShow(_("Loading Groups..."));
	m_groups.clear();
	m_users.clear();

	if(!m_ClientPKI->GetGroups(m_groups))
	{
		dlg.wHide();
		HandleError(m_ClientPKI->GetError(), this);
		return false;
	}
	if(!m_ClientPKI->EnumUsersCert(m_users))
	{
		dlg.wHide();
		HandleError(m_ClientPKI->GetError(), this);
		return false;
	}
	dlg.wHide();
		

	size_t i;

	m_listAvailable->DeleteAllItems();
	m_listUsers->DeleteAllItems();
	((wxComboBox *)FindWindow(IDC_GROUP))->Clear();

	if(!m_groups.size())
	{
		((wxComboBox *)FindWindow(IDC_GROUP))->Enable(FALSE);
		((wxButton *)FindWindow(IDC_DEL_GROUP))->Enable(FALSE);
		((wxButton *)FindWindow(IDC_REN_GROUP))->Enable(FALSE);
		m_listAvailable->Enable(FALSE);
		m_listUsers->Enable(FALSE);
		((wxButton *)FindWindow(IDC_ADD))->Enable(FALSE);
		((wxButton *)FindWindow(IDC_DEL))->Enable(FALSE);
	}
	else
	{
		((wxComboBox *)FindWindow(IDC_GROUP))->Clear();

		((wxComboBox *)FindWindow(IDC_GROUP))->Enable(TRUE);
		((wxButton *)FindWindow(IDC_DEL_GROUP))->Enable(TRUE);
		((wxButton *)FindWindow(IDC_REN_GROUP))->Enable(TRUE);
		m_listAvailable->Enable(TRUE);
		m_listUsers->Enable(TRUE);
		((wxButton *)FindWindow(IDC_ADD))->Enable(TRUE);
		((wxButton *)FindWindow(IDC_DEL))->Enable(TRUE);

		for(i=0; i<m_groups.size(); i++)
		{
			((wxComboBox *)FindWindow(IDC_GROUP))->Append(m_groups[i].get_name().c_str(), (void*)i);
		}
		((wxComboBox *)FindWindow(IDC_GROUP))->SetSelection(0);
		wxCommandEvent event;
		OnGroupsChanged(event);
	}
	return true;
}

void DlgManageGroups::OnDelGroup(wxCommandEvent& event)
{
	if(DisplayMessage(this, _("Are you sure to want to delete this group ?"), wxYES_NO) == wxNO) return;

	int SelectedItem;
	size_t Index;
	
	SelectedItem = ((wxComboBox *)FindWindow(IDC_GROUP))->GetSelection();
	if(SelectedItem == -1) return;
	Index = (size_t)((wxComboBox *)FindWindow(IDC_GROUP))->GetClientData(SelectedItem);

	DlgMessage dlg(this);
	dlg.wShow(_("Deleting Group..."));
	if(!m_ClientPKI->DelGroup(m_groups[Index].get_serial()))
	{
		dlg.wHide();
		HandleError(m_ClientPKI->GetError(), this);
		return;
	}
	dlg.wHide();

	ReloadList();
}

void DlgManageGroups::OnAddGroup(wxCommandEvent& event)
{
	DlgAddGroup Dlg(this, UsersGroup::EmptyInstance, m_ClientPKI);
	if(Dlg.IsOK())
		ReloadList();
}

void DlgManageGroups::OnRenGroup(wxCommandEvent& event)
{
	int SelectedItem;
	size_t Index;
	
	SelectedItem = ((wxComboBox *)FindWindow(IDC_GROUP))->GetSelection();
	if(SelectedItem == -1) return;
	Index = (size_t)((wxComboBox *)FindWindow(IDC_GROUP))->GetClientData(SelectedItem);


	DlgAddGroup Dlg(this, m_groups[Index], m_ClientPKI);
	if(Dlg.IsOK())
	{
		ReloadList();
	}
}

