/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgEeAdmin.cpp: implementation of the DlgEeAdmin class.
//
//////////////////////////////////////////////////////////////////////

#ifdef _WIN32
#pragma warning(disable:4786)
#endif

#include "DlgSendMail.h"
#include "DlgCertProperties.h"
#include "DlgP7bProperties.h"
#include "DlgEeAdmin.h"
#include "DlgRequestCert.h"
#include "DlgImportP12.h"
#include "DlgGetNewPassword.h"
#include "dlgs_wdr.h"
#include "clintl.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////



BEGIN_EVENT_TABLE(DlgEeAdminListCtrl, wxListCtrl)
    EVT_LIST_ITEM_RIGHT_CLICK(IDC_LIST_PROFILES, DlgEeAdminListCtrl::OnItemRightClick)
    EVT_LIST_ITEM_SELECTED(IDC_LIST_PROFILES, DlgEeAdminListCtrl::OnItemClick)
    EVT_MOUSE_EVENTS(DlgEeAdminListCtrl::OnMouseEvent)
END_EVENT_TABLE()


DlgEeAdmin * m_DlgEeAdminParent;


#ifdef _WIN32

wxBitmap DlgEeAdminListCtrlhPic = Backgrounds_GetBitmap(0);

long DlgEeAdminListCtrloldProc;
int DlgEeAdminListCtrlcenterX;
int DlgEeAdminListCtrlcenterY;
bool DlgEeAdminListCtrlinProc = false;

LRESULT CALLBACK DlgEeAdminListCtrllstvProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	RECT rRect;
	PAINTSTRUCT ps;
	HDC hDC;
	HDC hDCParent;
	HBITMAP bmp;
	HBITMAP bmpOld;
				
	switch (message) 
	{
		case WM_PAINT:
			GetClientRect(hwnd,&rRect);

			if(DlgEeAdminListCtrlinProc)
			{
				DlgEeAdminListCtrlinProc = false;
				InvalidateRect(hwnd, &rRect, TRUE);
				return TRUE;
			}
			DlgEeAdminListCtrlinProc = true;


			CallWindowProcA((WNDPROC)DlgEeAdminListCtrloldProc, hwnd, message, wParam, lParam);		

			BeginPaint(hwnd, &ps);
			
			hDC=GetDC(hwnd);
			hDCParent=CreateCompatibleDC(hDC);
			bmp = (HBITMAP)DlgEeAdminListCtrlhPic.GetHBITMAP();
			
			
			bmpOld = (HBITMAP)SelectObject(hDCParent, bmp);
			
			
			DlgEeAdminListCtrlcenterX = ((rRect.right - rRect.left) - DlgEeAdminListCtrlhPic.GetWidth()) / 2;
			DlgEeAdminListCtrlcenterY = ((rRect.bottom - rRect.top) - DlgEeAdminListCtrlhPic.GetHeight())  / 2;
			
			
			BitBlt(hDC,DlgEeAdminListCtrlcenterX, DlgEeAdminListCtrlcenterY, DlgEeAdminListCtrlhPic.GetWidth(),DlgEeAdminListCtrlhPic.GetHeight(), hDCParent, 0, 0,SRCAND );
			
			ReleaseDC(hwnd,hDC);
			SelectObject(hDCParent, bmpOld);
			DeleteDC(hDCParent);

			EndPaint(hwnd, &ps);
			return TRUE;
			
		default:
			return CallWindowProcA((WNDPROC)DlgEeAdminListCtrloldProc, hwnd, message, wParam, lParam);
	}
	return FALSE;
}

#endif

DlgEeAdminListCtrl::DlgEeAdminListCtrl(wxWindow *parent, const wxWindowID id, const wxPoint& pos,	const wxSize& size, long style):wxListCtrl(parent, id, pos, size, style)
{
	#ifdef _WIN32
		DlgEeAdminListCtrloldProc = SetWindowLong((HWND)GetHWND(), GWL_WNDPROC, (long)DlgEeAdminListCtrllstvProc);
	#endif
}

DlgEeAdminListCtrl::~DlgEeAdminListCtrl()
{
}

void DlgEeAdminListCtrl::OnItemRightClick(wxListEvent& event)
{
	m_DlgEeAdminParent->OnItemRightClick(event);
}

void DlgEeAdminListCtrl::OnItemClick(wxListEvent& event)
{
	m_DlgEeAdminParent->OnItemClick(event);
}

void DlgEeAdminListCtrl::OnMouseEvent(wxMouseEvent & event)
{
	m_DlgEeAdminParent->OnMouseEvent(event);
}



BEGIN_EVENT_TABLE(DlgEeAdmin, wxFrame)
	EVT_MENU(IDM_QUIT, DlgGUI::OnQuit)
    EVT_MENU(IDM_RELOAD, DlgEeAdmin::OnReload)
    EVT_MENU(IDM_SHOW_LOGS, DlgGUI::OnShowLogs)
    EVT_MENU(IDM_RECONNECT, DlgGUI::OnReconnect)
    EVT_MENU(IDM_SHOW_SSL_CERT, DlgGUI::ShowSSL_Certificate)
    EVT_MENU(IDM_SHOW_ENTITY_CERT, DlgGUI::ShowEntity_Certificate)
    EVT_MENU(IDM_ABOUT, DlgGUI::OnAbout)
    EVT_MENU(IDC_SEND_ADMIN_MAIL, DlgEeAdmin::OnSendAdminMail)
    EVT_MENU(IDC_SHOW_PREV, DlgEeAdmin::OnShowPrevEntries)
    EVT_MENU(IDC_REFRESH, DlgEeAdmin::OnRefreshEntries)
    EVT_TEXT_ENTER(IDC_DN_FILTER, DlgEeAdmin::OnRefreshEntries)
    EVT_COMBOBOX(IDC_FILTER_STATUS, DlgEeAdmin::OnRefreshEntries)
    EVT_MENU(IDC_SHOW_NEXT, DlgEeAdmin::OnShowNextEntries)
    EVT_MENU(IDM_CERT_PROPERTIES, DlgEeAdmin::OnCertProperties)
    EVT_MENU(IDM_P7B_PROPERTIES, DlgEeAdmin::OnP7bProperties)
    EVT_MENU(IDM_SAVE_P12, DlgEeAdmin::OnSavePKCS12)
    EVT_MENU(IDM_DELETE_P12, DlgEeAdmin::OnDeletePKCS12)
    EVT_MENU(IDM_IMPORT_P12, DlgEeAdmin::OnImportP12)
    EVT_MENU(IDM_IMPORT_SC, DlgEeAdmin::OnImportCert)
    EVT_MENU(IDM_CHANGE_PWD, DlgEeAdmin::OnChangeProfilePwd)
END_EVENT_TABLE()


DlgEeAdmin::DlgEeAdmin(wxWindow * wParent, char * EntityName, char * UserName, char * Password, PkiClient * ClientPki):DlgGUI(wParent, ClientPki, EntityName, UserName, Password)
{
	m_DlgEeAdminParent = this;
	CurrentPosition = 0;
	my_acl = NULL;
	LastSelectedEntry = -1;


    wxToolBar * toolBar = new wxToolBar(this, -1);

	wxString mTitle;
	mTitle.sprintf("EE Admin (%s/%s) [%s:%d]", UserName, EntityName, ClientPki->GetRemoteServer().c_str(), ClientPki->GetRemotePort());
	SetTitle(mTitle);

	DlgEeAdmin_SetWindow(this);
	SetMenuBar(DlgEeAdmin_GetMenu());

	toolBar->SetToolBitmapSize(wxSize(32,32));
	DlgEeAdmin_SetToolbar(toolBar);
    SetToolBar(toolBar);


	CenterOnScreen();

	m_imageListSmall = new wxImageList(16, 16, TRUE);

	
	m_listCtrl = (DlgEeAdminListCtrl *)FindWindow(IDC_LIST_PROFILES);
	if(!m_listCtrl) return;

	wxIcon ico;
	
	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_EMPTY_PROFILE));
	EmptyProfileIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_PLUS_PROFILE));
	PlusProfileIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_MINUS_PROFILE));
	MinusProfileIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_ACT_MID));
	ActMidConnectorIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_ACT_END));
	ActEndConnectorIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_WAI_MID));
	WaitMidConnectorIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_WAI_END));
	WaitEndConnectorIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_REV_MID));
	RevMidConnectorIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_REV_END));
	RevEndConnectorIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_SUSP_MID));
	SuspMidConnectorIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_SUSP_END));
	SuspEndConnectorIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_WAI_PROFILE));
	WaitingProfileIconId = m_imageListSmall->Add( ico );
	
	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_ERR_MID));
	ErrMidConnectorIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_ERR_END));
	ErrEndConnectorIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_WAI_REV_MID));
	WaitRevMidConnectorIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_WAI_REV_END));
	WaitRevEndConnectorIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_WAI_SUSP_MID));
	WaitSuspMidConnectorIconId = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(DlgEeAdmin_GetBitmap(IDB_WAI_SUSP_END));
	WaitSuspEndConnectorIconId = m_imageListSmall->Add( ico );

	m_listCtrl->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listCtrl->InsertColumn(m_listCtrl->GetColumnCount(), _("DN"), wxLIST_ALIGN_DEFAULT, 385);
	m_listCtrl->InsertColumn(m_listCtrl->GetColumnCount(), _("ID"), wxLIST_ALIGN_DEFAULT, 60);

	((wxTextCtrl *)FindWindow(IDC_INFO))->SetBackgroundColour(GetBackgroundColour());

	lastItem = -1;

	((wxTextCtrl *)FindWindow(IDC_INFO))->SetBackgroundColour(GetBackgroundColour());

	if(!ReloadConf())
	{
		Close(TRUE);
		return;
	}

	((wxComboBox *)FindWindow(IDC_FILTER_STATUS))->Append(
					_("All"), (void*)0);
	((wxComboBox *)FindWindow(IDC_FILTER_STATUS))->Append(
					_("Not yet validated by RA"), 
					(void*)ENUM_EE_USERS_NOT_RA_VALIDATED);
	((wxComboBox *)FindWindow(IDC_FILTER_STATUS))->Append(
					_("Not yet activated by User"), 
					(void*)ENUM_EE_USERS_NOT_ACTIVE);
	((wxComboBox *)FindWindow(IDC_FILTER_STATUS))->Append(
					_("Valid Users"), 
					(void*)ENUM_EE_USERS_VALID);
	((wxComboBox *)FindWindow(IDC_FILTER_STATUS))->SetSelection(0);
}

DlgEeAdmin::~DlgEeAdmin()
{
	if(m_listCtrl) m_listCtrl->ClearAll();
	if(m_imageListSmall) delete m_imageListSmall;
	if(my_acl) ASN1_BIT_STRING_free(my_acl);
}


void DlgEeAdmin::OnReload(wxCommandEvent& event)
{
	ReloadConf();
}


void DlgEeAdmin::OnItemClick(wxListEvent &event)
{
}

void DlgEeAdmin::OnItemRightClick(wxListEvent &event)
{
	wxMenu * menu=NULL;
	NewpkiEeUser * User;
	NewpkiProfileDatasCert * Cert;
	
	
	wxMenuBar * menu_b = DlgEeAdmin_GetPopup();
	if(!menu_b) return;

	if( (User = GetSelectedUser()) )
	{
		// Click on a profile
		menu = menu_b->GetMenu(0);
		if(menu)
		{
		}
	}
	else if( (Cert = GetSelectedCert()) )
	{
		// Click on a certificate
		menu = menu_b->GetMenu(1);
		if(menu)
		{
			menu->Enable(IDM_IMPORT_SC, false);
			menu->Enable(IDM_IMPORT_P12, false);
			switch(Cert->get_state())
			{
				case NEWPKI_PROFILE_CERT_STATE_ERROR:
				case NEWPKI_PROFILE_CERT_STATE_WAITING:
				case NEWPKI_PROFILE_CERT_STATE_WAITING_REV:
				case NEWPKI_PROFILE_CERT_STATE_REVOKED:
				case NEWPKI_PROFILE_CERT_STATE_WAITING_SUSP:
				case NEWPKI_PROFILE_CERT_STATE_WAITING_UNSUSP:
					menu->Enable(IDM_CERT_PROPERTIES, false);
					menu->Enable(IDM_P7B_PROPERTIES, false);
					
					menu->Enable(IDM_SAVE_P12, false);
					menu->Enable(IDM_DELETE_P12, false);
					break;
				case NEWPKI_PROFILE_CERT_STATE_SUSPENDED:
					menu->Enable(IDM_CERT_PROPERTIES, false);
					menu->Enable(IDM_P7B_PROPERTIES, false);
					
					menu->Enable(IDM_SAVE_P12, false);
					menu->Enable(IDM_DELETE_P12, false);
					break;
				case NEWPKI_PROFILE_CERT_STATE_ACTIVE:
					if(!Cert->get_p7b())
						menu->Enable(IDM_P7B_PROPERTIES, false);
					switch(Cert->get_type())
					{
						case NEWPKI_PROFILE_CERT_TYPE_PKCS10:
							menu->Enable(IDM_SAVE_P12, false);
							menu->Enable(IDM_DELETE_P12, false);
							break;
							
						case NEWPKI_PROFILE_CERT_TYPE_PKCS12:
							if(Cert->get_p12())
							{
								menu->Enable(IDM_SAVE_P12, true);
								menu->Enable(IDM_DELETE_P12, true);
#ifdef _WIN32
								menu->Enable(IDM_IMPORT_P12, true);
#endif
							}
							else
							{
								menu->Enable(IDM_SAVE_P12, false);
								menu->Enable(IDM_DELETE_P12, false);
							}
							break;
							
						case NEWPKI_PROFILE_CERT_TYPE_SC:
							menu->Enable(IDM_SAVE_P12, false);
							menu->Enable(IDM_DELETE_P12, false);
#ifdef _WIN32
							menu->Enable(IDM_IMPORT_SC, true);
#endif
							break;
					}
					break;
			}
		}
	}

	if(menu)
		m_listCtrl->PopupMenu(menu, event.GetPoint().x, event.GetPoint().y);
	delete menu_b;
}


bool DlgEeAdmin::ReloadConf()
{
	wxMenuBar * menubar;
	wxString strLng;

	m_DlgMsg->wShow(_("Loading Configuration..."));

	if(my_acl)
	{
		ASN1_BIT_STRING_free(my_acl);
		my_acl = NULL;
	}

	m_EntityConf.Clear();
	if(!m_ClientPki->GetLocalConf(m_EntityConf))
	{
		m_DlgMsg->wHide();
		HandleError(m_ClientPki->GetError(), this);
		return false;
	}

	if(!m_ClientPki->GetMyACL(&my_acl))
	{
		m_DlgMsg->wHide();
		HandleError(m_ClientPki->GetError(), this);
		return false;
	}

	menubar = GetMenuBar();

	if(ASN1_BIT_STRING_get_bit(my_acl, ACL_TYPE_RA_MANAGE_PROFILES))
	{
		LoadUSERS(((wxSpinCtrl*)FindWindow(IDC_NUM_ENTRIES))->GetValue());
	}
	
	if(!ASN1_BIT_STRING_get_bit(my_acl, ACL_TYPE_VIEW_LOGS))
	{
		menubar->GetMenu(1)->Enable(IDM_SHOW_LOGS, false);
	}
	else
	{
		menubar->GetMenu(1)->Enable(IDM_SHOW_LOGS, true);
	}
	
	if(!ASN1_BIT_STRING_get_bit(my_acl, ACL_TYPE_SEND_ADMIN_MAIL))
	{
		GetToolBar()->EnableTool( IDC_SEND_ADMIN_MAIL, FALSE );
	}
	else
	{
		GetToolBar()->EnableTool( IDC_SEND_ADMIN_MAIL, TRUE );
	}
	m_DlgMsg->wHide();
	
	return true;
}

void DlgEeAdmin::OnSendAdminMail(wxCommandEvent &event)
{
	DlgSendMail Dlg(this, m_ClientPki);
}


void DlgEeAdmin::ShowNextEntries(int NumEntries)
{
	CurrentPosition = CurrentPosition + NumEntries;
	LoadUSERS(NumEntries);
	if(!m_listCtrl->GetItemCount())
		ShowPrevEntries(NumEntries);
	else
		listStatus.clear();
}

void DlgEeAdmin::ShowPrevEntries(int NumEntries)
{
	CurrentPosition = CurrentPosition - NumEntries;
	if(CurrentPosition < 0) CurrentPosition = 0;
	LoadUSERS(NumEntries);
	listStatus.clear();
}

void DlgEeAdmin::RefreshDisplay(int NumEntries)
{
	LoadUSERS(NumEntries);
}

bool DlgEeAdmin::LoadUSERS(int NumEntries)
{
	int SelectedItem;
	int state;
	mString filter;

	lastItem = -1;
	
	m_DlgMsg->wShow(_("Loading User(s) List..."));
	wxString Page;
	Page.sprintf("%ld", (CurrentPosition / NumEntries) + 1);
	((wxStaticText *)FindWindow(IDC_PAGE))->SetLabel(Page);
	
	((wxTextCtrl *)FindWindow(IDC_INFO))->SetValue("");


	SelectedItem = ((wxComboBox *)FindWindow(IDC_FILTER_STATUS))->GetSelection();
	if(SelectedItem == -1)
		state = 0;
	else
		state = (int)((wxComboBox *)FindWindow(IDC_FILTER_STATUS))->GetClientData(SelectedItem);

	filter = ((wxTextCtrl *)FindWindow(IDC_DN_FILTER))->GetValue().c_str();

	m_listCtrl->DeleteAllItems();
	m_users.clear();
	if(!m_ClientPki->EnumEeUsers(CurrentPosition, NumEntries, state, filter, m_users))
	{
		m_DlgMsg->wHide();
		HandleError(m_ClientPki->GetError(), this);
		return false;
	}

	PrintUSERS();
	m_DlgMsg->wHide();
	return true;
}

void DlgEeAdmin::OnShowNextEntries(wxCommandEvent &event)
{
	ShowNextEntries(((wxSpinCtrl*)FindWindow(IDC_NUM_ENTRIES))->GetValue());
}

void DlgEeAdmin::OnShowPrevEntries(wxCommandEvent &event)
{
	ShowPrevEntries(((wxSpinCtrl*)FindWindow(IDC_NUM_ENTRIES))->GetValue());
}

void DlgEeAdmin::OnRefreshEntries(wxCommandEvent &event)
{
	RefreshDisplay(((wxSpinCtrl*)FindWindow(IDC_NUM_ENTRIES))->GetValue());
}

void DlgEeAdmin::PrintUSERS()
{
	size_t i;
	mString tmpDatas;
	int IconId;
	HashTable_Dn Dn;
	int item;
	
	for(i=0; i<m_users.size(); i++)
	{
		if(m_users[i].get_certs().size())		
			IconId = PlusProfileIconId;
		else
			IconId = EmptyProfileIconId;


		if(!Dn.From_X509_NAME(m_users[i].get_dn()))
		{
			tmpDatas = _("Unknown");
		}
		else
		{
			tmpDatas = FormatDN(Dn, true);
			if(!tmpDatas.size())
				tmpDatas = _("Unknown");
		}

		item = m_listCtrl->GetItemCount();
		m_listCtrl->InsertItem(item , tmpDatas.c_str(), IconId);
		m_listCtrl->SetItemData(item, (long)&m_users[i]);

		tmpDatas = m_users[i].get_id();
		m_listCtrl->SetItem(item, 1, tmpDatas.c_str());

		switch(listStatus[tmpDatas.c_ulng()]) {
			case PROFILE_STATUS_UNKNOWN:
				listStatus[tmpDatas.c_ulng()] = PROFILE_STATUS_CLOSED;
				break;
			case PROFILE_STATUS_CLOSED:
				break;
			case PROFILE_STATUS_OPENED:
				DrawOpenProfile(item, &m_users[i]);
				break;
		}
	}
}

void DlgEeAdmin::MouseDown(long item)
{
	wxListItem info;
	NewpkiEeUser * User;
	
	info.m_mask = wxLIST_MASK_IMAGE ;
	info.m_itemId = item;
	if (!m_listCtrl->GetItem(info))
	{
		return;
	}
	
	if( (User = GetSelectedUser(item)) )
	{
		if(User->get_certs().size())
		{
			if(info.m_image == PlusProfileIconId)
			{
				DrawOpenProfile(item, User);
			}
			else if(info.m_image == MinusProfileIconId)
			{
				DrawCloseProfile(item, User);
			}
		}
	}
}

void DlgEeAdmin::MouseMove(long item)
{
	wxListItem info;
	NewpkiEeUser * User;
	NewpkiProfileDatasCert * currCert;
	mString strInfo;
	
	if(lastItem == item)
		return;

	lastItem = item;

	if( (User = GetSelectedUser(item)) )
	{
		strInfo += _("Email Address: ");
		strInfo += User->get_email();
		strInfo += "\n";

		strInfo += _("RA Validated: ");
		if(User->get_raValidated())
			strInfo += _("Yes");
		else
			strInfo += _("No");
		strInfo += "\n";

		strInfo += _("Activated: ");
		if(User->get_activated())
			strInfo += _("Yes");
		else
		{
			strInfo += _("No");
		}
		strInfo += "\n";
	}
	else if( (currCert = GetSelectedCert(item)) )
	{
		strInfo.sprintf(_("Id: %ld"), currCert->get_id());

		strInfo += _("\nState: ");
		strInfo += GetCertificateStatusString(currCert->get_state());

		strInfo += _("\nType: ");
		strInfo += GetCertificateTypeString(currCert->get_type());
		
		strInfo += _("\nCA: ");
		strInfo += currCert->get_caName();
		strInfo += "\n";

		strInfo += "\n";
		strInfo += currCert->get_error();
	}
	else
	{
		strInfo = "";
	}
	
	((wxTextCtrl *)FindWindow(IDC_INFO))->SetValue(strInfo.c_str());
}

void DlgEeAdmin::OnMouseEvent(wxMouseEvent &event)
{
	int flags;
	long item = m_listCtrl->HitTest(event.GetPosition(), flags);
	if (item > -1)
	{
		if(event.LeftDown())
		{
			MouseDown(item);
		}
		else if(event.Moving())
		{
			MouseMove(item);
		}
	}
	event.Skip();
}

void DlgEeAdmin::OnCertProperties(wxCommandEvent &event)
{
	NewpkiProfileDatasCert * Cert;
	
	Cert = GetSelectedCert();
	if(Cert && Cert->get_cert())
	{
		DlgCertProperties Dlg(this, Cert->get_cert());
	}
}

void DlgEeAdmin::OnP7bProperties(wxCommandEvent &event)
{
	NewpkiProfileDatasCert * Cert;
	
	Cert = GetSelectedCert();
	if(Cert && Cert->get_p7b())
	{
		DlgP7bProperties Dlg(this, Cert->get_p7b());
	}
}

void DlgEeAdmin::DrawOpenProfile(long item, NewpkiEeUser * User)
{
	bool LastOne;
	size_t i;
	int IconId;
	mString Id;
	char IsError = false;

	for(i=0; i<User->get_certs().size(); i++)
	{
		IsError = false;

		if((i+1) == User->get_certs().size())
			LastOne = true;
		else
			LastOne = false;

		switch(User->get_certs()[i].get_state())
		{
			case NEWPKI_PROFILE_CERT_STATE_REVOKED:
				if(LastOne)
					IconId = RevEndConnectorIconId;
				else
					IconId = RevMidConnectorIconId;
				break;

			case NEWPKI_PROFILE_CERT_STATE_SUSPENDED:
				if(LastOne)
					IconId = SuspEndConnectorIconId;
				else
					IconId = SuspMidConnectorIconId;
				break;

			case NEWPKI_PROFILE_CERT_STATE_ACTIVE:
				if(LastOne)
					IconId = ActEndConnectorIconId;
				else
					IconId = ActMidConnectorIconId;
				break;

			case NEWPKI_PROFILE_CERT_STATE_WAITING:
				if(LastOne)
					IconId = WaitEndConnectorIconId;
				else
					IconId = WaitMidConnectorIconId;
				break;

			case NEWPKI_PROFILE_CERT_STATE_ERROR:
				if(LastOne)
					IconId = ErrEndConnectorIconId;
				else
					IconId = ErrMidConnectorIconId;
				break;
			case NEWPKI_PROFILE_CERT_STATE_WAITING_REV:
				if(LastOne)
					IconId = WaitRevEndConnectorIconId;
				else
					IconId = WaitRevMidConnectorIconId;
				break;
			case NEWPKI_PROFILE_CERT_STATE_WAITING_SUSP:
			case NEWPKI_PROFILE_CERT_STATE_WAITING_UNSUSP:
				if(LastOne)
					IconId = WaitSuspEndConnectorIconId;
				else
					IconId = WaitSuspMidConnectorIconId;
				break;
			default:
				if(LastOne)
					IconId = ActEndConnectorIconId;
				else
					IconId = ActMidConnectorIconId;
				break;
		}

		if(!IsError)
		{
			if(User->get_certs()[i].get_error().size())
				IsError = true;
		}

		m_listCtrl->InsertItem(item + i + 1, User->get_certs()[i].get_caName().c_str(), IconId);
		m_listCtrl->SetItemData(item + i + 1, (long)&User->get_certs()[i]);
		Id.sprintf("%ld", User->get_certs()[i].get_id());
		m_listCtrl->SetItem(item + i + 1, 1, Id.c_str());
		if(IsError)
			m_listCtrl->SetItemTextColour(item + i + 1, *wxRED);

	}

	m_listCtrl->SetItemImage(item, MinusProfileIconId, MinusProfileIconId);
	listStatus[User->get_id()] = PROFILE_STATUS_OPENED;
}

void DlgEeAdmin::DrawCloseProfile(long item, NewpkiEeUser * User)
{
	int i;
	i = User->get_certs().size();
	while(i)
	{
		m_listCtrl->DeleteItem(item + 1);
		i--;
	}
	m_listCtrl->SetItemImage(item, PlusProfileIconId, PlusProfileIconId);
	listStatus[User->get_id()] = PROFILE_STATUS_CLOSED;
}



NewpkiProfileDatasCert * DlgEeAdmin::GetSelectedCert(long Item)
{
	wxListItem info;

	if(Item == -1)
	{
		Item = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
		if(Item == -1)
			return NULL;
	}
	
	info.m_mask = wxLIST_MASK_IMAGE ;
	info.m_itemId = Item;
	if(!m_listCtrl->GetItem(info))
		return NULL;

	if(!IS_CERT_ICON(info.m_image))
		return NULL;
	
	return (NewpkiProfileDatasCert *)m_listCtrl->GetItemData(Item);
}

NewpkiEeUser * DlgEeAdmin::GetSelectedUser(long Item)
{
	wxListItem info;

	if(Item == -1)
	{
		Item = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
		if(Item == -1)
			return NULL;
	}
	
	info.m_mask = wxLIST_MASK_IMAGE ;
	info.m_itemId = Item;
	if(!m_listCtrl->GetItem(info))
		return NULL;

	if(!IS_PROFILE_ICON(info.m_image))
		return NULL;
	
	return (NewpkiEeUser *)m_listCtrl->GetItemData(Item);
}

void DlgEeAdmin::OnSavePKCS12(wxCommandEvent& event)
{
	NewpkiProfileDatasCert * Cert;

	Cert = GetSelectedCert();
	if(!Cert || !Cert->get_p12())
		return;

	SavePKCS12(Cert->get_p12());
}


void DlgEeAdmin::OnDeletePKCS12(wxCommandEvent &event)
{
	NewpkiProfileDatasCert * Cert;

	Cert = GetSelectedCert();
	if(!Cert)
		return;

	m_DlgMsg->wShow(_("Deleting PKCS#12..."));

	if(!m_ClientPki->DeletePkcs12(Cert->get_id()))
	{
		m_DlgMsg->wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}
	m_DlgMsg->wHide();

	RefreshDisplay(((wxSpinCtrl*)FindWindow(IDC_NUM_ENTRIES))->GetValue());
}

void DlgEeAdmin::OnImportCert(wxCommandEvent &event)
{
#ifdef _WIN32
	NewpkiProfileDatasCert * Cert;
	PkiEnroll Enroll;

	Cert = GetSelectedCert();
	if(!Cert || !Cert->get_cert())
		return;

	m_DlgMsg->wShow(_("Importing Certificate..."));
	if(!Enroll.ImportCert(Cert->get_cert().GetCertPEM().c_str()))
	{
		HandleErrorResult(NULL, this, Enroll.GetEnrollLastError());
		m_DlgMsg->wHide();
		return;
	}
	m_DlgMsg->wHide();

	DisplayMessage(this, _("Importation was successful"), wxOK);
#endif
}

void DlgEeAdmin::OnImportP12(wxCommandEvent &event)
{
#ifdef _WIN32
	NewpkiProfileDatasCert * Cert;

	Cert = GetSelectedCert();
	if(!Cert || !Cert->get_cert())
		return;

	DlgImportP12 dlg(this, Cert->get_p12());
#endif
}

void DlgEeAdmin::OnChangeProfilePwd(wxCommandEvent &event)
{
	wxString uid;
	NewpkiEeUser * User;

	
	User = GetSelectedUser();
	if(!User)
		return;

	DlgGetNewPassword dlg(this);
	if(!dlg.IsOK())
		return;
	
	m_DlgMsg->wShow(_("Changing User's Password..."));

	if(!m_ClientPki->WebUserChangePassword(User->get_id(), "", dlg.GetPassword()))
	{
		m_DlgMsg->wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}
	m_DlgMsg->wHide();
}

