/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgCreateRootCA.cpp: implementation of the DlgCreateRootCA class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgMessage.h"
#include "DlgManageExt.h"

#include "DlgCreateRootCA.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgCreateRootCA, wxDialog)
    EVT_BUTTON(IDC_OK, DlgCreateRootCA::OnOk)
    EVT_BUTTON(IDC_CHANGE_EXTS, DlgCreateRootCA::OnManageExts)
    EVT_BUTTON(IDC_CANCEL, DlgCreateRootCA::OnCancel)
    EVT_RADIOBUTTON(IDC_KEY_SERVER_ROOT, DlgCreateRootCA::OnServerKeyROOT)
    EVT_RADIOBUTTON(IDC_KEY_ENGINE_ROOT, DlgCreateRootCA::OnEngineKeyROOT)
END_EVENT_TABLE()


DlgCreateRootCA::DlgCreateRootCA(wxWindow * wParent, PkiClient * ClientPki):wxDialog(wParent, (wxWindowID)-1, _("Initialize as ROOT CA"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION)
{
	ExtensionValue extValue;

	// Create default extension for a root ca
	extValue.set_name("basicConstraints");
	extValue.set_value("critical, CA:TRUE");
	ca_create.get_extensions().push_back(extValue);

	extValue.set_name("nsComment");
	extValue.set_value("NewPKI Generated CA Certificate");
	ca_create.get_extensions().push_back(extValue);

	extValue.set_name("subjectKeyIdentifier");
	extValue.set_value("hash");
	ca_create.get_extensions().push_back(extValue);

	extValue.set_name("authorityKeyIdentifier");
	extValue.set_value("keyid,issuer:always");
	ca_create.get_extensions().push_back(extValue);

	extValue.set_name("nsCertType");
	extValue.set_value("sslCA, emailCA, objCA");
	ca_create.get_extensions().push_back(extValue);

	extValue.set_name("keyUsage");
	extValue.set_value("keyCertSign, cRLSign, digitalSignature, nonRepudiation, keyEncipherment");
	ca_create.get_extensions().push_back(extValue);




	m_ClientPki = ClientPki;
	m_IsOK = false;
	DlgCreateRootCA_SetWindow(this);


	((wxComboBox *)FindWindow(IDC_LIST_LEN_ROOT))->Append("8192 bits", (void*)8192);
	((wxComboBox *)FindWindow(IDC_LIST_LEN_ROOT))->Append("4096 bits", (void*)4096);
	((wxComboBox *)FindWindow(IDC_LIST_LEN_ROOT))->Append("2048 bits", (void*)2048);
	((wxComboBox *)FindWindow(IDC_LIST_LEN_ROOT))->Append("1024 bits", (void*)1024);
	((wxComboBox *)FindWindow(IDC_LIST_LEN_ROOT))->Append("512 bits", (void*)512);
	((wxComboBox *)FindWindow(IDC_LIST_LEN_ROOT))->SetSelection(3);

	wxComboBox * Country;

	Country = (wxComboBox *)FindWindow(IDC_C);

	Country->Append("AD", (void*)NULL);
	Country->Append("AE", (void*)NULL);
	Country->Append("AF", (void*)NULL);
	Country->Append("AG", (void*)NULL);
	Country->Append("AI", (void*)NULL);
	Country->Append("AL", (void*)NULL);
	Country->Append("AM", (void*)NULL);
	Country->Append("AN", (void*)NULL);
	Country->Append("AO", (void*)NULL);
	Country->Append("AQ", (void*)NULL);
	Country->Append("AR", (void*)NULL);
	Country->Append("AS", (void*)NULL);
	Country->Append("AT", (void*)NULL);
	Country->Append("AU", (void*)NULL);
	Country->Append("AW", (void*)NULL);
	Country->Append("AZ", (void*)NULL);
	Country->Append("BA", (void*)NULL);
	Country->Append("BB", (void*)NULL);
	Country->Append("BD", (void*)NULL);
	Country->Append("BE", (void*)NULL);
	Country->Append("BF", (void*)NULL);
	Country->Append("BG", (void*)NULL);
	Country->Append("BH", (void*)NULL);
	Country->Append("BI", (void*)NULL);
	Country->Append("BJ", (void*)NULL);
	Country->Append("BM", (void*)NULL);
	Country->Append("BN", (void*)NULL);
	Country->Append("BO", (void*)NULL);
	Country->Append("BR", (void*)NULL);
	Country->Append("BS", (void*)NULL);
	Country->Append("BT", (void*)NULL);
	Country->Append("BV", (void*)NULL);
	Country->Append("BW", (void*)NULL);
	Country->Append("BY", (void*)NULL);
	Country->Append("BZ", (void*)NULL);
	Country->Append("CA", (void*)NULL);
	Country->Append("CC", (void*)NULL);
	Country->Append("CD", (void*)NULL);
	Country->Append("CF", (void*)NULL);
	Country->Append("CG", (void*)NULL);
	Country->Append("CH", (void*)NULL);
	Country->Append("CI", (void*)NULL);
	Country->Append("CK", (void*)NULL);
	Country->Append("CL", (void*)NULL);
	Country->Append("CM", (void*)NULL);
	Country->Append("CN", (void*)NULL);
	Country->Append("CO", (void*)NULL);
	Country->Append("CR", (void*)NULL);
	Country->Append("CU", (void*)NULL);
	Country->Append("CV", (void*)NULL);
	Country->Append("CX", (void*)NULL);
	Country->Append("CY", (void*)NULL);
	Country->Append("CZ", (void*)NULL);
	Country->Append("DE", (void*)NULL);
	Country->Append("DJ", (void*)NULL);
	Country->Append("DK", (void*)NULL);
	Country->Append("DM", (void*)NULL);
	Country->Append("DO", (void*)NULL);
	Country->Append("DZ", (void*)NULL);
	Country->Append("EC", (void*)NULL);
	Country->Append("EE", (void*)NULL);
	Country->Append("EG", (void*)NULL);
	Country->Append("EH", (void*)NULL);
	Country->Append("ER", (void*)NULL);
	Country->Append("ES", (void*)NULL);
	Country->Append("ET", (void*)NULL);
	Country->Append("FI", (void*)NULL);
	Country->Append("FJ", (void*)NULL);
	Country->Append("FK", (void*)NULL);
	Country->Append("FM", (void*)NULL);
	Country->Append("FO", (void*)NULL);
	Country->Append("FR", (void*)NULL);
	Country->Append("GA", (void*)NULL);
	Country->Append("GB", (void*)NULL);
	Country->Append("GD", (void*)NULL);
	Country->Append("GE", (void*)NULL);
	Country->Append("GF", (void*)NULL);
	Country->Append("GH", (void*)NULL);
	Country->Append("GI", (void*)NULL);
	Country->Append("GL", (void*)NULL);
	Country->Append("GM", (void*)NULL);
	Country->Append("GN", (void*)NULL);
	Country->Append("GP", (void*)NULL);
	Country->Append("GQ", (void*)NULL);
	Country->Append("GR", (void*)NULL);
	Country->Append("GS", (void*)NULL);
	Country->Append("GT", (void*)NULL);
	Country->Append("GU", (void*)NULL);
	Country->Append("GW", (void*)NULL);
	Country->Append("GY", (void*)NULL);
	Country->Append("HK", (void*)NULL);
	Country->Append("HM", (void*)NULL);
	Country->Append("HN", (void*)NULL);
	Country->Append("HR", (void*)NULL);
	Country->Append("HT", (void*)NULL);
	Country->Append("HU", (void*)NULL);
	Country->Append("ID", (void*)NULL);
	Country->Append("IE", (void*)NULL);
	Country->Append("IL", (void*)NULL);
	Country->Append("IN", (void*)NULL);
	Country->Append("IO", (void*)NULL);
	Country->Append("IQ", (void*)NULL);
	Country->Append("IR", (void*)NULL);
	Country->Append("IS", (void*)NULL);
	Country->Append("IT", (void*)NULL);
	Country->Append("JM", (void*)NULL);
	Country->Append("JO", (void*)NULL);
	Country->Append("JP", (void*)NULL);
	Country->Append("KE", (void*)NULL);
	Country->Append("KG", (void*)NULL);
	Country->Append("KH", (void*)NULL);
	Country->Append("KI", (void*)NULL);
	Country->Append("KM", (void*)NULL);
	Country->Append("KN", (void*)NULL);
	Country->Append("KP", (void*)NULL);
	Country->Append("KR", (void*)NULL);
	Country->Append("KW", (void*)NULL);
	Country->Append("KY", (void*)NULL);
	Country->Append("KZ", (void*)NULL);
	Country->Append("LA", (void*)NULL);
	Country->Append("LB", (void*)NULL);
	Country->Append("LC", (void*)NULL);
	Country->Append("LI", (void*)NULL);
	Country->Append("LK", (void*)NULL);
	Country->Append("LR", (void*)NULL);
	Country->Append("LS", (void*)NULL);
	Country->Append("LT", (void*)NULL);
	Country->Append("LU", (void*)NULL);
	Country->Append("LV", (void*)NULL);
	Country->Append("LY", (void*)NULL);
	Country->Append("MA", (void*)NULL);
	Country->Append("MC", (void*)NULL);
	Country->Append("MD", (void*)NULL);
	Country->Append("MG", (void*)NULL);
	Country->Append("MH", (void*)NULL);
	Country->Append("MK", (void*)NULL);
	Country->Append("ML", (void*)NULL);
	Country->Append("MM", (void*)NULL);
	Country->Append("MN", (void*)NULL);
	Country->Append("MO", (void*)NULL);
	Country->Append("MP", (void*)NULL);
	Country->Append("MQ", (void*)NULL);
	Country->Append("MR", (void*)NULL);
	Country->Append("MS", (void*)NULL);
	Country->Append("MT", (void*)NULL);
	Country->Append("MU", (void*)NULL);
	Country->Append("MV", (void*)NULL);
	Country->Append("MW", (void*)NULL);
	Country->Append("MX", (void*)NULL);
	Country->Append("MY", (void*)NULL);
	Country->Append("MZ", (void*)NULL);
	Country->Append("NA", (void*)NULL);
	Country->Append("NC", (void*)NULL);
	Country->Append("NE", (void*)NULL);
	Country->Append("NF", (void*)NULL);
	Country->Append("NG", (void*)NULL);
	Country->Append("NI", (void*)NULL);
	Country->Append("NL", (void*)NULL);
	Country->Append("NO", (void*)NULL);
	Country->Append("NP", (void*)NULL);
	Country->Append("NR", (void*)NULL);
	Country->Append("NU", (void*)NULL);
	Country->Append("NZ", (void*)NULL);
	Country->Append("OM", (void*)NULL);
	Country->Append("PA", (void*)NULL);
	Country->Append("PE", (void*)NULL);
	Country->Append("PF", (void*)NULL);
	Country->Append("PG", (void*)NULL);
	Country->Append("PH", (void*)NULL);
	Country->Append("PK", (void*)NULL);
	Country->Append("PL", (void*)NULL);
	Country->Append("PM", (void*)NULL);
	Country->Append("PN", (void*)NULL);
	Country->Append("PR", (void*)NULL);
	Country->Append("PS", (void*)NULL);
	Country->Append("PT", (void*)NULL);
	Country->Append("PW", (void*)NULL);
	Country->Append("PY", (void*)NULL);
	Country->Append("QA", (void*)NULL);
	Country->Append("RE", (void*)NULL);
	Country->Append("RO", (void*)NULL);
	Country->Append("RU", (void*)NULL);
	Country->Append("RW", (void*)NULL);
	Country->Append("SA", (void*)NULL);
	Country->Append("SB", (void*)NULL);
	Country->Append("SC", (void*)NULL);
	Country->Append("SD", (void*)NULL);
	Country->Append("SE", (void*)NULL);
	Country->Append("SG", (void*)NULL);
	Country->Append("SH", (void*)NULL);
	Country->Append("SI", (void*)NULL);
	Country->Append("SJ", (void*)NULL);
	Country->Append("SK", (void*)NULL);
	Country->Append("SL", (void*)NULL);
	Country->Append("SM", (void*)NULL);
	Country->Append("SN", (void*)NULL);
	Country->Append("SO", (void*)NULL);
	Country->Append("SR", (void*)NULL);
	Country->Append("ST", (void*)NULL);
	Country->Append("SV", (void*)NULL);
	Country->Append("SY", (void*)NULL);
	Country->Append("SZ", (void*)NULL);
	Country->Append("TC", (void*)NULL);
	Country->Append("TD", (void*)NULL);
	Country->Append("TF", (void*)NULL);
	Country->Append("TG", (void*)NULL);
	Country->Append("TH", (void*)NULL);
	Country->Append("TJ", (void*)NULL);
	Country->Append("TK", (void*)NULL);
	Country->Append("TM", (void*)NULL);
	Country->Append("TN", (void*)NULL);
	Country->Append("TO", (void*)NULL);
	Country->Append("TP", (void*)NULL);
	Country->Append("TR", (void*)NULL);
	Country->Append("TT", (void*)NULL);
	Country->Append("TV", (void*)NULL);
	Country->Append("TW", (void*)NULL);
	Country->Append("TZ", (void*)NULL);
	Country->Append("UA", (void*)NULL);
	Country->Append("UG", (void*)NULL);
	Country->Append("UM", (void*)NULL);
	Country->Append("US", (void*)NULL);
	Country->Append("UY", (void*)NULL);
	Country->Append("UZ", (void*)NULL);
	Country->Append("VA", (void*)NULL);
	Country->Append("VC", (void*)NULL);
	Country->Append("VE", (void*)NULL);
	Country->Append("VG", (void*)NULL);
	Country->Append("VI", (void*)NULL);
	Country->Append("VN", (void*)NULL);
	Country->Append("VU", (void*)NULL);
	Country->Append("WF", (void*)NULL);
	Country->Append("WS", (void*)NULL);
	Country->Append("YE", (void*)NULL);
	Country->Append("YT", (void*)NULL);
	Country->Append("YU", (void*)NULL);
	Country->Append("ZA", (void*)NULL);
	Country->Append("ZM", (void*)NULL);
	Country->Append("ZW", (void*)NULL);
	Country->SetSelection(0);

	wxCommandEvent event2;
	OnServerKeyROOT(event2);

	CenterOnScreen();
	ShowModal();
}

DlgCreateRootCA::~DlgCreateRootCA()
{
}

void DlgCreateRootCA::OnOk(wxCommandEvent& event)
{
	mString m_KeyId;
	wxString strDays;
	int Days;
	int RsaLen;
	int nItem;
	DlgMessage Msg(this);
	
	if(DisplayMessage(this, _("Are you sure, you want to sign this request ?"), wxYES_NO) == wxNO) return;
	
	//Load DN
	if(!SetX509_NAME(ca_create.get_dn()))
	{
		return;
	}

	//Loading validity len
	strDays = ((wxTextCtrl *)FindWindow(IDC_DAYS))->GetValue();
	if(!strDays.Len())
	{
		return;
	}
	sscanf(strDays.GetData(), "%d", &Days);
	if(Days <= 0)
	{
		return;
	}
	ca_create.set_validity(Days);

	
	//Loading PKI Entity Key
	if( ((wxRadioButton *)FindWindow(IDC_KEY_ENGINE_ROOT))->GetValue() )
	{
		if( !((wxTextCtrl *)FindWindow(IDC_KEY_ID_ROOT))->GetValue().Len() )
		{
			return;
		}
		if(!ca_create.get_privkey().set_type(GEN_PRIVATE_KEY_TYPE_ENGINE))
		{
			HandleErrorResult(NULL, this, 0);
			return;
		}

		m_KeyId = ENGINE_HEAD;
		m_KeyId += ((wxTextCtrl *)FindWindow(IDC_KEY_ID_ROOT))->GetValue();
		
		ca_create.get_privkey().set_keyid(m_KeyId);
	}
	else
	{
		if(!ca_create.get_privkey().set_type(GEN_PRIVATE_KEY_TYPE_KEYLEN))
		{
			HandleErrorResult(NULL, this, 0);
			return;
		}

		nItem = ((wxComboBox *)FindWindow(IDC_LIST_LEN_ROOT))->GetSelection();
		RsaLen = (long)((wxComboBox *)FindWindow(IDC_LIST_LEN_ROOT))->GetClientData(nItem);

		ca_create.get_privkey().set_keylen(RsaLen);
	}


	//Send the request
	Msg.wShow(_("Creating New CA..."));
	if(!m_ClientPki->CreateCaRoot(ca_create))
	{
		Msg.wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}
	Msg.wHide();

	
	m_IsOK = true;
	Close(TRUE);
}

void DlgCreateRootCA::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}


bool DlgCreateRootCA::IsOK()
{
	return m_IsOK;
}


bool DlgCreateRootCA::SetX509_NAME(X509_NAME *name)
{
	wxString tmpValue;
	HashTable_Dn Dn;
	Dn.Clear();

	tmpValue = ((wxTextCtrl *)FindWindow(IDC_OU))->GetValue();
	if(!tmpValue.Len())
	{
		return false;
	}
	Dn.Add("organizationalUnitName", (char*)tmpValue.GetData());

	tmpValue = ((wxTextCtrl *)FindWindow(IDC_CN))->GetValue();
	if(!tmpValue.Len())
	{
		return false;
	}
	Dn.Add("commonName", (char*)tmpValue.GetData());

	tmpValue = ((wxTextCtrl *)FindWindow(IDC_EMAIL))->GetValue();
	if(!tmpValue.Len())
	{
		return false;
	}
	Dn.Add("emailAddress", (char*)tmpValue.GetData());

	tmpValue = ((wxTextCtrl *)FindWindow(IDC_O))->GetValue();
	if(!tmpValue.Len())
	{
		return false;
	}
	Dn.Add("organizationName", (char*)tmpValue.GetData());

	tmpValue = ((wxComboBox *)FindWindow(IDC_C))->GetValue();
	if(!tmpValue.Len())
	{
		return false;
	}
	Dn.Add("countryName", (char*)tmpValue.GetData());

	tmpValue = ((wxTextCtrl *)FindWindow(IDC_ST))->GetValue();
	if(!tmpValue.Len())
	{
		return false;
	}
	Dn.Add("stateOrProvinceName", (char*)tmpValue.GetData());

	tmpValue = ((wxTextCtrl *)FindWindow(IDC_L))->GetValue();
	if(!tmpValue.Len())
	{
		return false;
	}
	Dn.Add("localityName", (char*)tmpValue.GetData());

	if(!Dn.EntriesCount()) return false;

	if(name) Dn.To_X509_NAME(name);

	return true;
}

void DlgCreateRootCA::OnServerKeyROOT(wxCommandEvent &event)
{
	((wxStaticText *)FindWindow(IDC_LBL_KEYLEN_ROOT))->Enable(TRUE);
	((wxComboBox *)FindWindow(IDC_LIST_LEN_ROOT))->Enable(TRUE);

	((wxStaticText *)FindWindow(IDC_LBL_KEYID_ROOT))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_KEY_ID_ROOT))->Enable(FALSE);
}

void DlgCreateRootCA::OnEngineKeyROOT(wxCommandEvent &event)
{
	((wxStaticText *)FindWindow(IDC_LBL_KEYLEN_ROOT))->Enable(FALSE);
	((wxComboBox *)FindWindow(IDC_LIST_LEN_ROOT))->Enable(FALSE);

	((wxStaticText *)FindWindow(IDC_LBL_KEYID_ROOT))->Enable(TRUE);
	((wxTextCtrl *)FindWindow(IDC_KEY_ID_ROOT))->Enable(TRUE);
}

void DlgCreateRootCA::OnManageExts(wxCommandEvent &event)
{
	HashTable_String Exts;
	if(!Exts.From_EXTENSION_VALUE(ca_create.get_extensions()))
	{
		return;
	}

	DlgManageExt Dlg(this, &Exts);
	if(!Dlg.IsOK()) return;

	if(!Exts.To_EXTENSION_VALUE(ca_create.get_extensions()))
	{
		return;
	}
}

