/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: memory.h,v 1.17 2009-08-01 09:23:55 anton Exp $ */

/////////////////////////////////////////////////////////////////////////////////////////
// Memory management ////////////////////////////////////////////////////////////////////
#if defined(DEBUG) && defined(MEMORY_DEBUG)
void *aMalloc(const char *file, unsigned line, size_t size);
void aFree(const char *file, unsigned line, void *ptr);

#define aMalloc(size)	aMalloc(__FILE__, __LINE__, size)
#define aFree(ptr)	aFree(__FILE__, __LINE__, ptr)

#else
void *aMalloc(size_t size);
void aFree(void *ptr);
#endif

unsigned long long aGetBytesAllocated();
unsigned long aGetTimesAllocated();
unsigned long aGetTimesFreed();
unsigned aGetTimesFreedNull();

void aMemoryDebugInit();
void aMemoryDebugRelease();
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
