// $ANTLR 2.7.5 (20050720): "csharpgrammar.g" -> "CSharpParser.cs"$

    using System.Collections;
    using Nemerle.Collections;

namespace Nemerle.CSharp
{
	// Generate the header common to all output files.
	using System;
	
	using TokenBuffer              = antlr.TokenBuffer;
	using TokenStreamException     = antlr.TokenStreamException;
	using TokenStreamIOException   = antlr.TokenStreamIOException;
	using ANTLRException           = antlr.ANTLRException;
	using LLkParser = antlr.LLkParser;
	using Token                    = antlr.Token;
	using IToken                   = antlr.IToken;
	using TokenStream              = antlr.TokenStream;
	using RecognitionException     = antlr.RecognitionException;
	using NoViableAltException     = antlr.NoViableAltException;
	using MismatchedTokenException = antlr.MismatchedTokenException;
	using SemanticException        = antlr.SemanticException;
	using ParserSharedInputState   = antlr.ParserSharedInputState;
	using BitSet                   = antlr.collections.impl.BitSet;
	
	public 	class CSharpParser : antlr.LLkParser
	{
		public const int EOF = 1;
		public const int NULL_TREE_LOOKAHEAD = 3;
		public const int INTEGER_LITERAL = 4;
		public const int HEXADECIMAL_INTEGER_LITERAL = 5;
		public const int REAL_LITERAL = 6;
		public const int CHARACTER_LITERAL = 7;
		public const int NULL = 8;
		public const int TRUE = 9;
		public const int FALSE = 10;
		public const int REGULAR_STRING_LITERAL = 11;
		public const int VERBATIM_STRING_LITERAL = 12;
		public const int IDENTIFIER = 13;
		public const int DOT = 14;
		public const int OBJECT = 15;
		public const int STRING = 16;
		public const int BOOL = 17;
		public const int DECIMAL = 18;
		public const int CHAR = 19;
		public const int INT = 20;
		public const int LONG = 21;
		public const int SBYTE = 22;
		public const int BYTE = 23;
		public const int SHORT = 24;
		public const int UINT = 25;
		public const int ULONG = 26;
		public const int USHORT = 27;
		public const int FLOAT = 28;
		public const int DOUBLE = 29;
		public const int LTHAN = 30;
		public const int COMMA = 31;
		public const int GTHAN = 32;
		public const int SR = 33;
		public const int LBRACK = 34;
		public const int RBRACK = 35;
		public const int REF = 36;
		public const int OUT = 37;
		public const int DEC = 38;
		public const int INC = 39;
		public const int DELEGATE = 40;
		public const int LPAREN = 41;
		public const int RPAREN = 42;
		public const int NEW = 43;
		public const int THIS = 44;
		public const int BASE = 45;
		public const int TYPEOF = 46;
		public const int VOID = 47;
		public const int CHECKED = 48;
		public const int UNCHECKED = 49;
		public const int PLUS = 50;
		public const int MINUS = 51;
		public const int LNOT = 52;
		public const int BNOT = 53;
		public const int STAR = 54;
		public const int DIV = 55;
		public const int MOD = 56;
		public const int SL = 57;
		public const int IS = 58;
		public const int AS = 59;
		public const int LE = 60;
		public const int GE = 61;
		public const int EQUAL = 62;
		public const int NOT_EQUAL = 63;
		public const int BAND = 64;
		public const int BXOR = 65;
		public const int BOR = 66;
		public const int LAND = 67;
		public const int LOR = 68;
		public const int QUESTION = 69;
		public const int COLON = 70;
		public const int ASSIGN = 71;
		public const int PLUS_ASN = 72;
		public const int MINUS_ASN = 73;
		public const int STAR_ASN = 74;
		public const int DIV_ASN = 75;
		public const int MOD_ASN = 76;
		public const int BAND_ASN = 77;
		public const int BOR_ASN = 78;
		public const int BXOR_ASN = 79;
		public const int SL_ASN = 80;
		public const int SR_ASN = 81;
		public const int CONST = 82;
		public const int YIELD = 83;
		public const int RETURN = 84;
		public const int SEMI = 85;
		public const int DEFAULT = 86;
		public const int LBRACE = 87;
		public const int RBRACE = 88;
		public const int IF = 89;
		public const int ELSE = 90;
		public const int SWITCH = 91;
		public const int CASE = 92;
		public const int WHILE = 93;
		public const int DO = 94;
		public const int FOR = 95;
		public const int FOREACH = 96;
		public const int IN = 97;
		public const int BREAK = 98;
		public const int CONTINUE = 99;
		public const int GOTO = 100;
		public const int THROW = 101;
		public const int TRY = 102;
		public const int CATCH = 103;
		public const int FINALLY = 104;
		public const int LOCK = 105;
		public const int USING = 106;
		public const int NAMESPACE = 107;
		public const int ENUM = 108;
		public const int STRUCT = 109;
		public const int INTERFACE = 110;
		public const int CLASS = 111;
		public const int PUBLIC = 112;
		public const int PROTECTED = 113;
		public const int INTERNAL = 114;
		public const int PRIVATE = 115;
		public const int SEALED = 116;
		public const int ABSTRACT = 117;
		public const int STATIC = 118;
		public const int PARTIAL = 119;
		public const int READONLY = 120;
		public const int VOLATILE = 121;
		public const int WHERE = 122;
		public const int VIRTUAL = 123;
		public const int OVERRIDE = 124;
		public const int EXTERN = 125;
		public const int PARAMS = 126;
		public const int EVENT = 127;
		public const int OPERATOR = 128;
		public const int IMPLICIT = 129;
		public const int EXPLICIT = 130;
		public const int SIZEOF = 131;
		public const int STACKALLOC = 132;
		public const int FIXED = 133;
		public const int UNSAFE = 134;
		public const int NEW_LINE = 135;
		public const int WHITESPACE = 136;
		public const int NEW_LINE_CHARACTER = 137;
		public const int NOT_NEW_LINE = 138;
		public const int SINGLE_LINE_COMMENT = 139;
		public const int DELIMITED_COMMENT = 140;
		public const int UNICODE_ESCAPE_SEQUENCE = 141;
		public const int IDENTIFIER_START_CHARACTER = 142;
		public const int IDENTIFIER_PART_CHARACTER = 143;
		public const int DECIMAL_DIGIT = 144;
		public const int HEX_DIGIT = 145;
		public const int INTEGER_TYPE_SUFFIX = 146;
		public const int NUMERIC_LITERAL = 147;
		public const int EXPONENT_PART = 148;
		public const int SIGN = 149;
		public const int CHARACTER = 150;
		public const int SIMPLE_CHARACTER = 151;
		public const int SIMPLE_ESCAPE_SEQUENCE = 152;
		public const int HEXADECIMAL_ESCAPE_SEQUENCE = 153;
		public const int REGULAR_STRING_LITERAL_CHARACTER = 154;
		public const int SINGLE_REGULAR_STRING_LITERAL_CHARCACTER = 155;
		public const int HASH = 156;
		public const int QUOTE = 157;
		public const int PP_DIRECTIVE = 158;
		public const int PP_WHITESPACE = 159;
		public const int PP_NEW_LINE = 160;
		public const int PP_EXPRESSION = 161;
		public const int PP_OR_EXPRESSION = 162;
		public const int PP_AND_EXPRESSION = 163;
		public const int PP_EQUALITY_EXPRESSION = 164;
		public const int EQUALITY_OP = 165;
		public const int PP_UNARY_EXPRESSION = 166;
		public const int PP_PRIMARY_EXPRESSION = 167;
		public const int PP_CONDITIONAL = 168;
		public const int PP_IF_SECTION = 169;
		public const int PP_ELIF_SECTION = 170;
		public const int PP_ELSE_SECTION = 171;
		public const int PP_ENDIF = 172;
		public const int PP_DECLARATION = 173;
		public const int CONDITIONAL_SYMBOL = 174;
		public const int PP_LINE = 175;
		public const int LINE_INDICATOR = 176;
		public const int FILE_NAME = 177;
		public const int FILE_NAME_CHARACTER = 178;
		public const int PP_DIAGNOSTIC = 179;
		public const int PP_START_REGION = 180;
		public const int PP_END_REGION = 181;
		public const int PP_MESSAGE = 182;
		
		
    public override void reportError (RecognitionException ex)
    {
	Message.Error (ex.Message, ex.line, ex.column);
    }
		
		protected void initialize()
		{
			tokenNames = tokenNames_;
		}
		
		
		protected CSharpParser(TokenBuffer tokenBuf, int k) : base(tokenBuf, k)
		{
			initialize();
		}
		
		public CSharpParser(TokenBuffer tokenBuf) : this(tokenBuf,2)
		{
		}
		
		protected CSharpParser(TokenStream lexer, int k) : base(lexer,k)
		{
			initialize();
		}
		
		public CSharpParser(TokenStream lexer) : this(lexer,2)
		{
		}
		
		public CSharpParser(ParserSharedInputState state) : base(state,2)
		{
			initialize();
		}
		
	public string  literal() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  il = null;
		IToken  hil = null;
		IToken  rl = null;
		IToken  chl = null;
		IToken  n = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case TRUE:
			case FALSE:
			{
				return_string=boolean_literal();
				break;
			}
			case INTEGER_LITERAL:
			{
				il = LT(1);
				match(INTEGER_LITERAL);
				if (0==inputState.guessing)
				{
					return_string = il.getText();
				}
				break;
			}
			case HEXADECIMAL_INTEGER_LITERAL:
			{
				hil = LT(1);
				match(HEXADECIMAL_INTEGER_LITERAL);
				if (0==inputState.guessing)
				{
					return_string = hil.getText();
				}
				break;
			}
			case REAL_LITERAL:
			{
				rl = LT(1);
				match(REAL_LITERAL);
				if (0==inputState.guessing)
				{
					return_string = rl.getText();
				}
				break;
			}
			case CHARACTER_LITERAL:
			{
				chl = LT(1);
				match(CHARACTER_LITERAL);
				if (0==inputState.guessing)
				{
					return_string = chl.getText();
				}
				break;
			}
			case REGULAR_STRING_LITERAL:
			case VERBATIM_STRING_LITERAL:
			{
				return_string=string_literal();
				break;
			}
			case NULL:
			{
				n = LT(1);
				match(NULL);
				if (0==inputState.guessing)
				{
					return_string = n.getText();
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  boolean_literal() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  t = null;
		IToken  f = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case TRUE:
			{
				t = LT(1);
				match(TRUE);
				if (0==inputState.guessing)
				{
					return_string = t.getText();
				}
				break;
			}
			case FALSE:
			{
				f = LT(1);
				match(FALSE);
				if (0==inputState.guessing)
				{
					return_string = f.getText();
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  string_literal() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  rsl = null;
		IToken  vsl = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case REGULAR_STRING_LITERAL:
			{
				rsl = LT(1);
				match(REGULAR_STRING_LITERAL);
				if (0==inputState.guessing)
				{
					return_string = rsl.getText();
				}
				break;
			}
			case VERBATIM_STRING_LITERAL:
			{
				vsl = LT(1);
				match(VERBATIM_STRING_LITERAL);
				if (0==inputState.guessing)
				{
					return_string = vsl.getText();
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string []  namespace_name() //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		
		return_strings = new string[]{"",""};
		
		
		try {      // for error handling
			return_strings=namespace_or_type_name();
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_1_);
			}
			else
			{
				throw ex;
			}
		}
		return return_strings;
	}
	
	public string []  namespace_or_type_name() //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		IToken  id1 = null;
		IToken  id2 = null;
		
		return_strings = new string[]{"",""};;
		
		
		try {      // for error handling
			id1 = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				return_strings[0] = ExtendedToken.getWhitespaces (id1);
				return_strings[1] = ExtendedToken.getTextOnly (id1);
			}
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==DOT) && (LA(2)==IDENTIFIER))
					{
						match(DOT);
						id2 = LT(1);
						match(IDENTIFIER);
						if (0==inputState.guessing)
						{
							return_strings[0] += ExtendedToken.getWhitespaces (id2);
							return_strings[1] += ("." + ExtendedToken.getTextOnly (id2));
						}
					}
					else
					{
						goto _loop8_breakloop;
					}
					
				}
_loop8_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_2_);
			}
			else
			{
				throw ex;
			}
		}
		return return_strings;
	}
	
	public string []  type_name() //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		
		return_strings = new string[]{"",""};;
		
		
		try {      // for error handling
			return_strings=namespace_or_type_name();
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_2_);
			}
			else
			{
				throw ex;
			}
		}
		return return_strings;
	}
	
	public string []  type() //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		
		return_strings = new string[]{"",""};
		
		
		try {      // for error handling
			return_strings=maybe_generic_type(true);
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_2_);
			}
			else
			{
				throw ex;
			}
		}
		return return_strings;
	}
	
	public string []  maybe_generic_type(
		bool can_generic
	) //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		IToken  o = null;
		IToken  s = null;
		
		return_strings = new string[]{"",""};
		
		
		try {      // for error handling
			bool synPredMatched12 = false;
			if (((tokenSet_3_.member(LA(1))) && (LA(2)==DOT||LA(2)==LBRACK)))
			{
				int _m12 = mark();
				synPredMatched12 = true;
				inputState.guessing++;
				try {
					{
						array_type();
					}
				}
				catch (RecognitionException)
				{
					synPredMatched12 = false;
				}
				rewind(_m12);
				inputState.guessing--;
			}
			if ( synPredMatched12 )
			{
				return_strings=array_type();
			}
			else {
				bool synPredMatched14 = false;
				if (((LA(1)==IDENTIFIER) && (LA(2)==DOT||LA(2)==LTHAN)))
				{
					int _m14 = mark();
					synPredMatched14 = true;
					inputState.guessing++;
					try {
						{
							if (!( can_generic ))
							  throw new SemanticException(" can_generic ");
							generic_type();
						}
					}
					catch (RecognitionException)
					{
						synPredMatched14 = false;
					}
					rewind(_m14);
					inputState.guessing--;
				}
				if ( synPredMatched14 )
				{
					return_strings=generic_type();
				}
				else if ((LA(1)==OBJECT) && (tokenSet_2_.member(LA(2)))) {
					o = LT(1);
					match(OBJECT);
					if (0==inputState.guessing)
					{
						return_strings[0] = ExtendedToken.getWhitespaces (o);
						return_strings[1] = ExtendedToken.getTextOnly (o);
					}
				}
				else if ((LA(1)==STRING) && (tokenSet_2_.member(LA(2)))) {
					s = LT(1);
					match(STRING);
					if (0==inputState.guessing)
					{
						return_strings[0] = ExtendedToken.getWhitespaces (s);
						return_strings[1] = ExtendedToken.getTextOnly (s);
					}
				}
				else if ((LA(1)==IDENTIFIER) && (tokenSet_2_.member(LA(2)))) {
					return_strings=type_name();
				}
				else if (((LA(1) >= BOOL && LA(1) <= DOUBLE)) && (tokenSet_2_.member(LA(2)))) {
					return_strings=simple_type();
				}
				else
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
			}
			catch (RecognitionException ex)
			{
				if (0 == inputState.guessing)
				{
					reportError(ex);
					recover(ex,tokenSet_2_);
				}
				else
				{
					throw ex;
				}
			}
			return return_strings;
		}
		
	public string []  array_type() //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		
		string [] rank = new string[] {"",""};
		return_strings = new string[] {"",""};
		string [] nat  = new string[] {"",""};
		string end = "";
		
		
		try {      // for error handling
			nat=non_array_type();
			rank=rank_specifier();
			if (0==inputState.guessing)
			{
				return_strings[1] = " array [" + rank[0];
				if(rank[1] != "1")
				return_strings[1] += (rank[1] + ",");
				return_strings[0] = nat[0];
				end = "]";
				
			}
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==LBRACK) && (LA(2)==COMMA||LA(2)==RBRACK))
					{
						rank=rank_specifier();
						if (0==inputState.guessing)
						{
							return_strings[1] += " array [" + rank[0];
							if(rank[1] != "1")
							return_strings[1] += (rank[1] + ",");
							end += "]";
						}
					}
					else
					{
						goto _loop23_breakloop;
					}
					
				}
_loop23_breakloop:				;
			}    // ( ... )*
			if (0==inputState.guessing)
			{
				return_strings[1] += nat[1];
				return_strings[1] += end;
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_2_);
			}
			else
			{
				throw ex;
			}
		}
		return return_strings;
	}
	
	public string []  generic_type() //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		IToken  d = null;
		
		return_strings = new string[] {"",""};
		string [] nat  = new string[] {"",""};
		string parms  = "";
		
		
		try {      // for error handling
			nat=type_name();
			parms=generic_parameters();
			if (0==inputState.guessing)
			{
				return_strings[1] = nat[1] + parms;
				return_strings[0] = nat[0];
				
			}
			{
				if ((LA(1)==DOT) && (LA(2)==IDENTIFIER))
				{
					d = LT(1);
					match(DOT);
					nat=generic_type();
					if (0==inputState.guessing)
					{
						return_strings [1] += d.getText () + nat [0] + nat [1];
						
					}
				}
				else if ((tokenSet_2_.member(LA(1))) && (tokenSet_4_.member(LA(2)))) {
				}
				else
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_2_);
			}
			else
			{
				throw ex;
			}
		}
		return return_strings;
	}
	
	public string []  simple_type() //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		IToken  b = null;
		
		return_strings = new string[]{"",""};
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case DECIMAL:
			case CHAR:
			case INT:
			case LONG:
			case SBYTE:
			case BYTE:
			case SHORT:
			case UINT:
			case ULONG:
			case USHORT:
			case FLOAT:
			case DOUBLE:
			{
				return_strings=numeric_type();
				break;
			}
			case BOOL:
			{
				b = LT(1);
				match(BOOL);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (b);
					return_strings[1] = ExtendedToken.getTextOnly (b);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_2_);
			}
			else
			{
				throw ex;
			}
		}
		return return_strings;
	}
	
	public string  generic_parameters() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  lb = null;
		IToken  c = null;
		IToken  rb = null;
		IToken  rb1 = null;
		
		return_string = "";
		string [] ty = new string[] {"",""};
		
		
		try {      // for error handling
			lb = LT(1);
			match(LTHAN);
			if (0==inputState.guessing)
			{
				return_string = ExtendedToken.getWhitespaces (lb) + "[";
			}
			{
				if ((tokenSet_3_.member(LA(1))) && (tokenSet_2_.member(LA(2))))
				{
					ty=type();
					if (0==inputState.guessing)
					{
						return_string += ty [0] + ty [1];
					}
				}
				else if ((tokenSet_2_.member(LA(1))) && (tokenSet_4_.member(LA(2)))) {
				}
				else
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				
			}
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA) && (tokenSet_3_.member(LA(2))))
					{
						c = LT(1);
						match(COMMA);
						ty=type();
						if (0==inputState.guessing)
						{
							return_string += c.getText () + ty [0] + ty [1];
						}
					}
					else
					{
						goto _loop27_breakloop;
					}
					
				}
_loop27_breakloop:				;
			}    // ( ... )*
			{
				if ((LA(1)==GTHAN) && (tokenSet_2_.member(LA(2))))
				{
					rb = LT(1);
					match(GTHAN);
					if (0==inputState.guessing)
					{
						return_string += ExtendedToken.getWhitespaces (rb) + "]";
					}
				}
				else if ((LA(1)==SR) && (tokenSet_2_.member(LA(2)))) {
					rb1 = LT(1);
					match(SR);
					if (0==inputState.guessing)
					{
						return_string += ExtendedToken.getWhitespaces (rb1) + "]]";
					}
				}
				else if ((tokenSet_2_.member(LA(1))) && (tokenSet_4_.member(LA(2)))) {
				}
				else
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_2_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string []  numeric_type() //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		IToken  d = null;
		
		return_strings = new string[]{"",""};
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case CHAR:
			case INT:
			case LONG:
			case SBYTE:
			case BYTE:
			case SHORT:
			case UINT:
			case ULONG:
			case USHORT:
			{
				return_strings=integral_type();
				break;
			}
			case FLOAT:
			case DOUBLE:
			{
				return_strings=floating_point_type();
				break;
			}
			case DECIMAL:
			{
				d = LT(1);
				match(DECIMAL);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (d);
					return_strings[1] = ExtendedToken.getTextOnly (d);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_2_);
			}
			else
			{
				throw ex;
			}
		}
		return return_strings;
	}
	
	public string []  integral_type() //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		IToken  i1 = null;
		IToken  i2 = null;
		IToken  i3 = null;
		IToken  i4 = null;
		IToken  i5 = null;
		IToken  i6 = null;
		IToken  i7 = null;
		IToken  i8 = null;
		IToken  i9 = null;
		
		return_strings = new string []{"",""};
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case CHAR:
			{
				i1 = LT(1);
				match(CHAR);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (i1);
					return_strings[1] = ExtendedToken.getTextOnly (i1);
				}
				break;
			}
			case INT:
			{
				i2 = LT(1);
				match(INT);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (i2);
					return_strings[1] = ExtendedToken.getTextOnly (i2);
				}
				break;
			}
			case LONG:
			{
				i3 = LT(1);
				match(LONG);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (i3);
					return_strings[1] = ExtendedToken.getTextOnly (i3);
				}
				break;
			}
			case SBYTE:
			{
				i4 = LT(1);
				match(SBYTE);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (i4);
					return_strings[1] = ExtendedToken.getTextOnly (i4);
				}
				break;
			}
			case BYTE:
			{
				i5 = LT(1);
				match(BYTE);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (i5);
					return_strings[1] = ExtendedToken.getTextOnly (i5);
				}
				break;
			}
			case SHORT:
			{
				i6 = LT(1);
				match(SHORT);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (i6);
					return_strings[1] = ExtendedToken.getTextOnly (i6);
				}
				break;
			}
			case UINT:
			{
				i7 = LT(1);
				match(UINT);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (i7);
					return_strings[1] = ExtendedToken.getTextOnly (i7);
				}
				break;
			}
			case ULONG:
			{
				i8 = LT(1);
				match(ULONG);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (i8);
					return_strings[1] = ExtendedToken.getTextOnly (i8);
				}
				break;
			}
			case USHORT:
			{
				i9 = LT(1);
				match(USHORT);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (i9);
					return_strings[1] = ExtendedToken.getTextOnly (i9);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_2_);
			}
			else
			{
				throw ex;
			}
		}
		return return_strings;
	}
	
	public string []  floating_point_type() //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		IToken  f = null;
		IToken  d = null;
		
		return_strings = new string[]{"",""};
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case FLOAT:
			{
				f = LT(1);
				match(FLOAT);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (f);
					return_strings[1] = ExtendedToken.getTextOnly (f);
				}
				break;
			}
			case DOUBLE:
			{
				d = LT(1);
				match(DOUBLE);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (d);
					return_strings[1] = ExtendedToken.getTextOnly (d);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_2_);
			}
			else
			{
				throw ex;
			}
		}
		return return_strings;
	}
	
	public string []  non_array_type() //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		IToken  o = null;
		IToken  s = null;
		
		return_strings = new string[] {"",""};
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case OBJECT:
			{
				o = LT(1);
				match(OBJECT);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (o);
					return_strings[1] = ExtendedToken.getTextOnly (o);
				}
				break;
			}
			case STRING:
			{
				s = LT(1);
				match(STRING);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (s);
					return_strings[1] = ExtendedToken.getTextOnly (s);
				}
				break;
			}
			case IDENTIFIER:
			{
				return_strings=type_name();
				break;
			}
			case BOOL:
			case DECIMAL:
			case CHAR:
			case INT:
			case LONG:
			case SBYTE:
			case BYTE:
			case SHORT:
			case UINT:
			case ULONG:
			case USHORT:
			case FLOAT:
			case DOUBLE:
			{
				return_strings=simple_type();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_5_);
			}
			else
			{
				throw ex;
			}
		}
		return return_strings;
	}
	
	public string []  rank_specifier() //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		IToken  lb = null;
		IToken  c = null;
		IToken  rb = null;
		
		return_strings = new string[] {"",""};
		int rank = 1;
		
		
		try {      // for error handling
			lb = LT(1);
			match(LBRACK);
			if (0==inputState.guessing)
			{
				return_strings[0] = ExtendedToken.getWhitespaces (lb);
			}
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA))
					{
						c = LT(1);
						match(COMMA);
						if (0==inputState.guessing)
						{
							rank += 1;
						}
						if (0==inputState.guessing)
						{
							return_strings[0] = ExtendedToken.getWhitespaces (c);
						}
					}
					else
					{
						goto _loop35_breakloop;
					}
					
				}
_loop35_breakloop:				;
			}    // ( ... )*
			rb = LT(1);
			match(RBRACK);
			if (0==inputState.guessing)
			{
				return_strings[0] = ExtendedToken.getWhitespaces (rb);
				return_strings[1] = rank.ToString ();   
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_2_);
			}
			else
			{
				throw ex;
			}
		}
		return return_strings;
	}
	
	public string  argument_list2() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  c = null;
		
		string ar = "";
		return_string = "";
		
		
		try {      // for error handling
			return_string=argument();
			{ // ( ... )+
				int _cnt31=0;
				for (;;)
				{
					if ((LA(1)==COMMA))
					{
						c = LT(1);
						match(COMMA);
						ar=argument();
						if (0==inputState.guessing)
						{
							
							return_string += (c.getText () + ar);
							
						}
					}
					else
					{
						if (_cnt31 >= 1) { goto _loop31_breakloop; } else { throw new NoViableAltException(LT(1), getFilename());; }
					}
					
					_cnt31++;
				}
_loop31_breakloop:				;
			}    // ( ... )+
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_6_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  argument() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  r = null;
		IToken  o = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case INTEGER_LITERAL:
			case HEXADECIMAL_INTEGER_LITERAL:
			case REAL_LITERAL:
			case CHARACTER_LITERAL:
			case NULL:
			case TRUE:
			case FALSE:
			case REGULAR_STRING_LITERAL:
			case VERBATIM_STRING_LITERAL:
			case IDENTIFIER:
			case OBJECT:
			case STRING:
			case DECIMAL:
			case CHAR:
			case INT:
			case LONG:
			case SBYTE:
			case BYTE:
			case SHORT:
			case UINT:
			case ULONG:
			case USHORT:
			case FLOAT:
			case DOUBLE:
			case DEC:
			case INC:
			case DELEGATE:
			case LPAREN:
			case NEW:
			case THIS:
			case BASE:
			case TYPEOF:
			case CHECKED:
			case UNCHECKED:
			case PLUS:
			case MINUS:
			case LNOT:
			case BNOT:
			case STAR:
			case DEFAULT:
			{
				return_string=expression();
				break;
			}
			case REF:
			{
				r = LT(1);
				match(REF);
				return_string=variable_reference();
				if (0==inputState.guessing)
				{
					return_string = r.getText () + return_string ;
				}
				break;
			}
			case OUT:
			{
				o = LT(1);
				match(OUT);
				return_string=variable_reference();
				if (0==inputState.guessing)
				{
					return_string = o.getText () + return_string ;
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_7_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  variable_reference() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		return_string = "";
		
		
		try {      // for error handling
			return_string=expression();
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_7_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		return_string = "";
		
		
		try {      // for error handling
			bool synPredMatched148 = false;
			if (((tokenSet_8_.member(LA(1))) && (tokenSet_9_.member(LA(2)))))
			{
				int _m148 = mark();
				synPredMatched148 = true;
				inputState.guessing++;
				try {
					{
						conditional_expression();
					}
				}
				catch (RecognitionException)
				{
					synPredMatched148 = false;
				}
				rewind(_m148);
				inputState.guessing--;
			}
			if ( synPredMatched148 )
			{
				return_string=conditional_expression();
			}
			else if ((tokenSet_8_.member(LA(1))) && (tokenSet_10_.member(LA(2)))) {
				return_string=assignment(true);
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_11_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  argument_list() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  c = null;
		
		string ar = "";
		return_string = "";
		
		
		try {      // for error handling
			return_string=argument();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA))
					{
						c = LT(1);
						match(COMMA);
						ar=argument();
						if (0==inputState.guessing)
						{
							
							return_string += (c.getText () + ar);
							
						}
					}
					else
					{
						goto _loop39_breakloop;
					}
					
				}
_loop39_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_12_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  primary_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		string sope = "";
		string soace = "";
		return_string = "";
		
		
		try {      // for error handling
			bool synPredMatched43 = false;
			if (((LA(1)==NEW) && (tokenSet_3_.member(LA(2)))))
			{
				int _m43 = mark();
				synPredMatched43 = true;
				inputState.guessing++;
				try {
					{
						array_creation_expression();
					}
				}
				catch (RecognitionException)
				{
					synPredMatched43 = false;
				}
				rewind(_m43);
				inputState.guessing--;
			}
			if ( synPredMatched43 )
			{
				return_string=array_creation_expression();
				{    // ( ... )*
					for (;;)
					{
						if ((tokenSet_13_.member(LA(1))))
						{
							soace=suffix_of_array_creation_expression();
							if (0==inputState.guessing)
							{
								return_string += soace;
							}
						}
						else
						{
							goto _loop45_breakloop;
						}
						
					}
_loop45_breakloop:					;
				}    // ( ... )*
			}
			else if ((tokenSet_14_.member(LA(1))) && (tokenSet_15_.member(LA(2)))) {
				return_string=primary_no_array_creation_expression();
				{    // ( ... )*
					for (;;)
					{
						if ((tokenSet_16_.member(LA(1))))
						{
							sope=suffix_of_primary_expression();
							if (0==inputState.guessing)
							{
								return_string += sope;
							}
						}
						else
						{
							goto _loop47_breakloop;
						}
						
					}
_loop47_breakloop:					;
				}    // ( ... )*
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_17_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  array_creation_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  n1 = null;
		IToken  n2 = null;
		IToken  lb = null;
		IToken  rb = null;
		
		string ai = "";
		string el = "";
		return_string = "";
		string [] tp = new string[]{"",""};
		string [] rank = new string[]{"",""};
		
		
		try {      // for error handling
			bool synPredMatched84 = false;
			if (((LA(1)==NEW) && (tokenSet_3_.member(LA(2)))))
			{
				int _m84 = mark();
				synPredMatched84 = true;
				inputState.guessing++;
				try {
					{
						match(NEW);
						array_type();
						array_initializer();
					}
				}
				catch (RecognitionException)
				{
					synPredMatched84 = false;
				}
				rewind(_m84);
				inputState.guessing--;
			}
			if ( synPredMatched84 )
			{
				n1 = LT(1);
				match(NEW);
				tp=array_type();
				return_string=array_initializer();
				if (0==inputState.guessing)
				{
					
					return_string = ExtendedToken.getWhitespaces (n1) + tp[0] +
					return_string; 
					
				}
			}
			else if ((LA(1)==NEW) && (tokenSet_3_.member(LA(2)))) {
				n2 = LT(1);
				match(NEW);
				tp=non_array_type();
				lb = LT(1);
				match(LBRACK);
				el=expression_list();
				rb = LT(1);
				match(RBRACK);
				{    // ( ... )*
					for (;;)
					{
						if ((LA(1)==LBRACK))
						{
							rank=rank_specifier();
							if (0==inputState.guessing)
							{
								
								return_string +=  rank[0];
								
							}
						}
						else
						{
							goto _loop86_breakloop;
						}
						
					}
_loop86_breakloop:					;
				}    // ( ... )*
				{
					if ((tokenSet_18_.member(LA(1))) && (tokenSet_19_.member(LA(2))))
					{
						if (0==inputState.guessing)
						{
							
							return_string = ExtendedToken.getWhitespaces (n2) + tp[0]; 
							return_string = ExtendedToken.getWhitespaces (lb) + 
							" array(" + el + ExtendedToken.getWhitespaces (rb) + ")";
							
						}
					}
					else if ((tokenSet_20_.member(LA(1))) && (tokenSet_19_.member(LA(2)))) {
						{
							switch ( LA(1) )
							{
							case LBRACE:
							{
								ai=array_initializer();
								break;
							}
							case EOF:
							case DOT:
							case LTHAN:
							case COMMA:
							case GTHAN:
							case SR:
							case RBRACK:
							case DEC:
							case INC:
							case LPAREN:
							case RPAREN:
							case PLUS:
							case MINUS:
							case STAR:
							case DIV:
							case MOD:
							case SL:
							case IS:
							case AS:
							case LE:
							case GE:
							case EQUAL:
							case NOT_EQUAL:
							case BAND:
							case BXOR:
							case BOR:
							case LAND:
							case LOR:
							case QUESTION:
							case COLON:
							case ASSIGN:
							case PLUS_ASN:
							case MINUS_ASN:
							case STAR_ASN:
							case DIV_ASN:
							case MOD_ASN:
							case BAND_ASN:
							case BOR_ASN:
							case BXOR_ASN:
							case SL_ASN:
							case SR_ASN:
							case SEMI:
							case RBRACE:
							{
								break;
							}
							default:
							{
								throw new NoViableAltException(LT(1), getFilename());
							}
							 }
						}
						if (0==inputState.guessing)
						{
							
							return_string +=  ai;
							
						}
					}
					else
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					
				}
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_18_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  suffix_of_array_creation_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  d = null;
		IToken  i = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case DOT:
			{
				return_string=member_access_end();
				break;
			}
			case DEC:
			{
				d = LT(1);
				match(DEC);
				if (0==inputState.guessing)
				{
					return_string = d.getText ();
				}
				break;
			}
			case INC:
			{
				i = LT(1);
				match(INC);
				if (0==inputState.guessing)
				{
					return_string = i.getText ();
				}
				break;
			}
			case LPAREN:
			{
				return_string=invocation_expression_end();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  primary_no_array_creation_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  id = null;
		
		string pt = "";
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case INTEGER_LITERAL:
			case HEXADECIMAL_INTEGER_LITERAL:
			case REAL_LITERAL:
			case CHARACTER_LITERAL:
			case NULL:
			case TRUE:
			case FALSE:
			case REGULAR_STRING_LITERAL:
			case VERBATIM_STRING_LITERAL:
			{
				return_string=literal();
				break;
			}
			case IDENTIFIER:
			{
				return_string=simple_name();
				break;
			}
			case LPAREN:
			{
				return_string=parenthesized_expression();
				break;
			}
			case THIS:
			{
				return_string=this_access();
				break;
			}
			case BASE:
			{
				return_string=base_access();
				break;
			}
			case OBJECT:
			case STRING:
			case DECIMAL:
			case CHAR:
			case INT:
			case LONG:
			case SBYTE:
			case BYTE:
			case SHORT:
			case UINT:
			case ULONG:
			case USHORT:
			case FLOAT:
			case DOUBLE:
			{
				pt=predefined_type();
				match(DOT);
				id = LT(1);
				match(IDENTIFIER);
				if (0==inputState.guessing)
				{
					return_string = pt + "." + id.getText ();
				}
				break;
			}
			case TYPEOF:
			{
				return_string=typeof_expression();
				break;
			}
			case DEFAULT:
			{
				return_string=default_value();
				break;
			}
			case CHECKED:
			{
				return_string=checked_expression();
				break;
			}
			case UNCHECKED:
			{
				return_string=unchecked_expression();
				break;
			}
			case DELEGATE:
			{
				return_string=anonymous_method_expression();
				break;
			}
			default:
				bool synPredMatched52 = false;
				if (((LA(1)==NEW) && (tokenSet_3_.member(LA(2)))))
				{
					int _m52 = mark();
					synPredMatched52 = true;
					inputState.guessing++;
					try {
						{
							object_creation_expression();
						}
					}
					catch (RecognitionException)
					{
						synPredMatched52 = false;
					}
					rewind(_m52);
					inputState.guessing--;
				}
				if ( synPredMatched52 )
				{
					return_string=object_creation_expression();
				}
				else if ((LA(1)==NEW) && (tokenSet_3_.member(LA(2)))) {
					return_string=delegate_creation_expression();
				}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			break; }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  suffix_of_primary_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case DOT:
			case DEC:
			case INC:
			case LPAREN:
			{
				return_string=suffix_of_array_creation_expression();
				break;
			}
			case LBRACK:
			{
				return_string=element_access_end();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  member_access_end() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  id = null;
		
		return_string = "";
		
		
		try {      // for error handling
			match(DOT);
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				return_string = "." + id.getText ();
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  invocation_expression_end() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  lp2 = null;
		IToken  rp2 = null;
		
		string al = "";
		return_string = "";
		string parms = "";
		string exp = "";
		
		
		try {      // for error handling
			lp2 = LT(1);
			match(LPAREN);
			{
				switch ( LA(1) )
				{
				case INTEGER_LITERAL:
				case HEXADECIMAL_INTEGER_LITERAL:
				case REAL_LITERAL:
				case CHARACTER_LITERAL:
				case NULL:
				case TRUE:
				case FALSE:
				case REGULAR_STRING_LITERAL:
				case VERBATIM_STRING_LITERAL:
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case REF:
				case OUT:
				case DEC:
				case INC:
				case DELEGATE:
				case LPAREN:
				case NEW:
				case THIS:
				case BASE:
				case TYPEOF:
				case CHECKED:
				case UNCHECKED:
				case PLUS:
				case MINUS:
				case LNOT:
				case BNOT:
				case STAR:
				case DEFAULT:
				{
					al=argument_list();
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			rp2 = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				return_string = lp2.getText () + al + rp2.getText ();
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  element_access_end() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  lb = null;
		IToken  rb = null;
		
		string el = "";
		return_string = "";
		
		
		try {      // for error handling
			lb = LT(1);
			match(LBRACK);
			el=expression_list();
			rb = LT(1);
			match(RBRACK);
			if (0==inputState.guessing)
			{
				return_string = lb.getText () + el + rb.getText ();
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  simple_name() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  id = null;
		
		return_string = "";
		
		
		try {      // for error handling
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				return_string = id.getText();
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  parenthesized_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  lp = null;
		IToken  rp = null;
		
		string exp = "";
		return_string = "";
		
		
		try {      // for error handling
			lp = LT(1);
			match(LPAREN);
			exp=expression();
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				
				return_string = lp.getText () + exp + rp.getText ();
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  this_access() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  t = null;
		
		return_string = "";
		
		
		try {      // for error handling
			t = LT(1);
			match(THIS);
			if (0==inputState.guessing)
			{
				return_string = t.getText ();
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  base_access() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  b1 = null;
		IToken  id = null;
		IToken  b2 = null;
		IToken  lb = null;
		IToken  rb = null;
		
		string el = "";
		return_string = "";
		
		
		try {      // for error handling
			bool synPredMatched81 = false;
			if (((LA(1)==BASE) && (LA(2)==DOT)))
			{
				int _m81 = mark();
				synPredMatched81 = true;
				inputState.guessing++;
				try {
					{
						match(BASE);
						match(DOT);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched81 = false;
				}
				rewind(_m81);
				inputState.guessing--;
			}
			if ( synPredMatched81 )
			{
				b1 = LT(1);
				match(BASE);
				match(DOT);
				id = LT(1);
				match(IDENTIFIER);
				if (0==inputState.guessing)
				{
					
					return_string = b1.getText () + "." + id.getText ();
					
				}
			}
			else if ((LA(1)==BASE) && (LA(2)==LBRACK)) {
				b2 = LT(1);
				match(BASE);
				lb = LT(1);
				match(LBRACK);
				el=expression_list();
				rb = LT(1);
				match(RBRACK);
				if (0==inputState.guessing)
				{
					
					return_string = b2.getText () + lb.getText () + el + rb.getText ();
					
				}
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  predefined_type() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  pt1 = null;
		IToken  pt2 = null;
		IToken  pt3 = null;
		IToken  pt4 = null;
		IToken  pt5 = null;
		IToken  pt6 = null;
		IToken  pt7 = null;
		IToken  pt8 = null;
		IToken  pt9 = null;
		IToken  pt10 = null;
		IToken  pt11 = null;
		IToken  pt12 = null;
		IToken  pt13 = null;
		IToken  pt14 = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case BYTE:
			{
				pt1 = LT(1);
				match(BYTE);
				if (0==inputState.guessing)
				{
					return_string = pt1.getText();
				}
				break;
			}
			case CHAR:
			{
				pt2 = LT(1);
				match(CHAR);
				if (0==inputState.guessing)
				{
					return_string = pt2.getText();
				}
				break;
			}
			case DECIMAL:
			{
				pt3 = LT(1);
				match(DECIMAL);
				if (0==inputState.guessing)
				{
					return_string = pt3.getText();
				}
				break;
			}
			case DOUBLE:
			{
				pt4 = LT(1);
				match(DOUBLE);
				if (0==inputState.guessing)
				{
					return_string = pt4.getText();
				}
				break;
			}
			case FLOAT:
			{
				pt5 = LT(1);
				match(FLOAT);
				if (0==inputState.guessing)
				{
					return_string = pt5.getText();
				}
				break;
			}
			case INT:
			{
				pt6 = LT(1);
				match(INT);
				if (0==inputState.guessing)
				{
					return_string = pt6.getText();
				}
				break;
			}
			case LONG:
			{
				pt7 = LT(1);
				match(LONG);
				if (0==inputState.guessing)
				{
					return_string = pt7.getText();
				}
				break;
			}
			case OBJECT:
			{
				pt8 = LT(1);
				match(OBJECT);
				if (0==inputState.guessing)
				{
					return_string = pt8.getText();
				}
				break;
			}
			case SBYTE:
			{
				pt9 = LT(1);
				match(SBYTE);
				if (0==inputState.guessing)
				{
					return_string = pt9.getText();
				}
				break;
			}
			case SHORT:
			{
				pt10 = LT(1);
				match(SHORT);
				if (0==inputState.guessing)
				{
					return_string = pt10.getText();
				}
				break;
			}
			case STRING:
			{
				pt11 = LT(1);
				match(STRING);
				if (0==inputState.guessing)
				{
					return_string = pt11.getText();
				}
				break;
			}
			case UINT:
			{
				pt12 = LT(1);
				match(UINT);
				if (0==inputState.guessing)
				{
					return_string = pt12.getText();
				}
				break;
			}
			case ULONG:
			{
				pt13 = LT(1);
				match(ULONG);
				if (0==inputState.guessing)
				{
					return_string = pt13.getText();
				}
				break;
			}
			case USHORT:
			{
				pt14 = LT(1);
				match(USHORT);
				if (0==inputState.guessing)
				{
					return_string = pt14.getText();
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_21_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  object_creation_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  n = null;
		IToken  lp = null;
		IToken  rp = null;
		
		string [] tp = new string[]{"",""};
		string al = "";
		return_string = "";
		string parms = "";
		
		
		try {      // for error handling
			n = LT(1);
			match(NEW);
			tp=maybe_generic_type(false);
			{
				switch ( LA(1) )
				{
				case LTHAN:
				{
					generic_parameters();
					if (0==inputState.guessing)
					{
						return_string = ExtendedToken.getWhitespaces (n) + tp[0]+tp[1];
					}
					break;
				}
				case LPAREN:
				{
					lp = LT(1);
					match(LPAREN);
					{
						switch ( LA(1) )
						{
						case INTEGER_LITERAL:
						case HEXADECIMAL_INTEGER_LITERAL:
						case REAL_LITERAL:
						case CHARACTER_LITERAL:
						case NULL:
						case TRUE:
						case FALSE:
						case REGULAR_STRING_LITERAL:
						case VERBATIM_STRING_LITERAL:
						case IDENTIFIER:
						case OBJECT:
						case STRING:
						case DECIMAL:
						case CHAR:
						case INT:
						case LONG:
						case SBYTE:
						case BYTE:
						case SHORT:
						case UINT:
						case ULONG:
						case USHORT:
						case FLOAT:
						case DOUBLE:
						case REF:
						case OUT:
						case DEC:
						case INC:
						case DELEGATE:
						case LPAREN:
						case NEW:
						case THIS:
						case BASE:
						case TYPEOF:
						case CHECKED:
						case UNCHECKED:
						case PLUS:
						case MINUS:
						case LNOT:
						case BNOT:
						case STAR:
						case DEFAULT:
						{
							al=argument_list();
							break;
						}
						case RPAREN:
						{
							break;
						}
						default:
						{
							throw new NoViableAltException(LT(1), getFilename());
						}
						 }
					}
					rp = LT(1);
					match(RPAREN);
					if (0==inputState.guessing)
					{
						
								return_string = ExtendedToken.getWhitespaces (n) + tp[0]+tp[1];
								return_string += lp.getText () + al + rp.getText ();
							
					}
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  delegate_creation_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  n = null;
		IToken  lp = null;
		IToken  rp = null;
		
		string [] tp = new string[]{"",""};
		string al = "";
		return_string = "";
		string parms = null;
		
		
		try {      // for error handling
			n = LT(1);
			match(NEW);
			tp=maybe_generic_type(false);
			{
				switch ( LA(1) )
				{
				case LTHAN:
				{
					generic_parameters();
					break;
				}
				case LPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			lp = LT(1);
			match(LPAREN);
			{
				switch ( LA(1) )
				{
				case INTEGER_LITERAL:
				case HEXADECIMAL_INTEGER_LITERAL:
				case REAL_LITERAL:
				case CHARACTER_LITERAL:
				case NULL:
				case TRUE:
				case FALSE:
				case REGULAR_STRING_LITERAL:
				case VERBATIM_STRING_LITERAL:
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case REF:
				case OUT:
				case DEC:
				case INC:
				case DELEGATE:
				case LPAREN:
				case NEW:
				case THIS:
				case BASE:
				case TYPEOF:
				case CHECKED:
				case UNCHECKED:
				case PLUS:
				case MINUS:
				case LNOT:
				case BNOT:
				case STAR:
				case DEFAULT:
				{
					al=argument_list();
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				
				return_string = ExtendedToken.getWhitespaces (n) + tp[0]+tp[1];
				if (parms != null)
				return_string += "." + parms;
				return_string += lp.getText () + al + rp.getText ();
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  typeof_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  t = null;
		IToken  lp = null;
		IToken  v = null;
		IToken  rp = null;
		
		string [] tp = new string[]{"",""};
		return_string = "";
		
		
		try {      // for error handling
			t = LT(1);
			match(TYPEOF);
			lp = LT(1);
			match(LPAREN);
			{
				switch ( LA(1) )
				{
				case VOID:
				{
					v = LT(1);
					match(VOID);
					if (0==inputState.guessing)
					{
						tp[0] = v.getText ();
					}
					break;
				}
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				{
					tp=type();
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				
				return_string = t.getText () + lp.getText () + tp[0]+tp[1] + rp.getText ();
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  default_value() //throws RecognitionException, TokenStreamException
{
		string t;
		
		IToken  lp = null;
		IToken  rp = null;
		
		t = null;
		string [] ty = new string[] { "", ""}; 
		
		
		try {      // for error handling
			match(DEFAULT);
			lp = LT(1);
			match(LPAREN);
			ty=type();
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				t = "Nemerle.Extensions.DefaultValue" + lp.getText () + ty[0] + ty[1] + rp.getText ();
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public string  checked_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  c = null;
		IToken  lp = null;
		IToken  rp = null;
		
		string exp = "";
		return_string = "";
		
		
		try {      // for error handling
			c = LT(1);
			match(CHECKED);
			lp = LT(1);
			match(LPAREN);
			exp=expression();
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				
				return_string = c.getText () + lp.getText () + exp + rp.getText ();
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  unchecked_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  u = null;
		IToken  lp = null;
		IToken  rp = null;
		
		string exp = "";
		return_string = "";
		
		
		try {      // for error handling
			u = LT(1);
			match(UNCHECKED);
			lp = LT(1);
			match(LPAREN);
			exp=expression();
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				
				return_string = u.getText () + lp.getText () + exp + rp.getText ();
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  anonymous_method_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  d = null;
		
		return_string = "";
		StatementTree t = new StatementTree ();
		string ams = "()";
		
		
		try {      // for error handling
			d = LT(1);
			match(DELEGATE);
			{
				switch ( LA(1) )
				{
				case LPAREN:
				{
					ams=anonymous_method_signature();
					break;
				}
				case LBRACE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			t=block();
			if (0==inputState.guessing)
			{
				
				return_string = ExtendedToken.getWhitespaces (d) + "fun" + ams + t.ToString ();
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_0_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  anonymous_method_signature() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  lp = null;
		IToken  rp = null;
		
		return_string = "";
		string ampl = "";
		
		
		try {      // for error handling
			lp = LT(1);
			match(LPAREN);
			{
				switch ( LA(1) )
				{
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case REF:
				case OUT:
				{
					ampl=anonymous_method_parameter_list();
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				
				return_string = lp.getText () + ampl + rp.getText ();
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_22_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public StatementTree  block() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  lb = null;
		IToken  rb = null;
		
		t = new StatementTree();
		StatementTree temp = new StatementTree ();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			lb = LT(1);
			match(LBRACE);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(lb));
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_23_.member(LA(1))))
					{
						temp=statement();
						if (0==inputState.guessing)
						{
							a.Add (temp);
						}
					}
					else
					{
						goto _loop167_breakloop;
					}
					
				}
_loop167_breakloop:				;
			}    // ( ... )*
			if (0==inputState.guessing)
			{
				StatementTree last = (StatementTree) Nemerle.Core.Option.UnSome (a.First ());
				string plain = last.PlainString;
				if (plain != null) {
				plain = plain.Trim ();
				if (plain.StartsWith ("def ") || plain.StartsWith ("mutable "))
				a.Add (new StatementTree (" ();"));
				}
				
			}
			rb = LT(1);
			match(RBRACE);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(rb));
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree ("BLOCK",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_24_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public string  anonymous_method_parameter_list() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  c = null;
		
		return_string = "";
		string ampl = "";
		
		
		try {      // for error handling
			return_string=anonymous_method_parameter();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA))
					{
						c = LT(1);
						match(COMMA);
						ampl=anonymous_method_parameter();
						if (0==inputState.guessing)
						{
							
							return_string += c.getText () + ampl;
							
						}
					}
					else
					{
						goto _loop59_breakloop;
					}
					
				}
_loop59_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_12_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  anonymous_method_parameter() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  id = null;
		
		return_string = "";
		string p = "";
		string [] t = new string[]{"",""};
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case REF:
				case OUT:
				{
					p=parameter_modifier();
					break;
				}
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			t=type();
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				
				return_string = id.getText () + " : " + p + t[0]+t[1];
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_25_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  parameter_modifier() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  r = null;
		IToken  o = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case REF:
			{
				r = LT(1);
				match(REF);
				if (0==inputState.guessing)
				{
					return_string = r.getText();
				}
				break;
			}
			case OUT:
			{
				o = LT(1);
				match(OUT);
				if (0==inputState.guessing)
				{
					return_string = o.getText();
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_3_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  expression_list() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  c = null;
		
		string exp = "";
		return_string = "";
		
		
		try {      // for error handling
			return_string=expression();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA))
					{
						c = LT(1);
						match(COMMA);
						exp=expression();
						if (0==inputState.guessing)
						{
							return_string += (c.getText () + exp);
						}
					}
					else
					{
						goto _loop77_breakloop;
					}
					
				}
_loop77_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_26_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  array_initializer() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  lb1 = null;
		IToken  c = null;
		IToken  rb1 = null;
		IToken  lb2 = null;
		IToken  rb2 = null;
		
		return_string = "";
		string temp = "";
		
		
		try {      // for error handling
			bool synPredMatched503 = false;
			if (((LA(1)==LBRACE) && (tokenSet_27_.member(LA(2)))))
			{
				int _m503 = mark();
				synPredMatched503 = true;
				inputState.guessing++;
				try {
					{
						match(LBRACE);
						variable_initializer_list();
						match(COMMA);
						match(RBRACE);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched503 = false;
				}
				rewind(_m503);
				inputState.guessing--;
			}
			if ( synPredMatched503 )
			{
				lb1 = LT(1);
				match(LBRACE);
				temp=variable_initializer_list();
				c = LT(1);
				match(COMMA);
				rb1 = LT(1);
				match(RBRACE);
				if (0==inputState.guessing)
				{
					
					return_string = ExtendedToken.getWhitespaces (lb1) + " array" + "[" + temp + ExtendedToken.getWhitespaces(c) + 
					ExtendedToken.getWhitespaces(rb1) + "]";
					
				}
			}
			else if ((LA(1)==LBRACE) && (tokenSet_28_.member(LA(2)))) {
				lb2 = LT(1);
				match(LBRACE);
				{
					switch ( LA(1) )
					{
					case INTEGER_LITERAL:
					case HEXADECIMAL_INTEGER_LITERAL:
					case REAL_LITERAL:
					case CHARACTER_LITERAL:
					case NULL:
					case TRUE:
					case FALSE:
					case REGULAR_STRING_LITERAL:
					case VERBATIM_STRING_LITERAL:
					case IDENTIFIER:
					case OBJECT:
					case STRING:
					case DECIMAL:
					case CHAR:
					case INT:
					case LONG:
					case SBYTE:
					case BYTE:
					case SHORT:
					case UINT:
					case ULONG:
					case USHORT:
					case FLOAT:
					case DOUBLE:
					case DEC:
					case INC:
					case DELEGATE:
					case LPAREN:
					case NEW:
					case THIS:
					case BASE:
					case TYPEOF:
					case CHECKED:
					case UNCHECKED:
					case PLUS:
					case MINUS:
					case LNOT:
					case BNOT:
					case STAR:
					case DEFAULT:
					case LBRACE:
					{
						temp=variable_initializer_list();
						break;
					}
					case RBRACE:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					 }
				}
				rb2 = LT(1);
				match(RBRACE);
				if (0==inputState.guessing)
				{
					
					return_string = ExtendedToken.getWhitespaces (lb2) + " array" + "[" + temp +
					ExtendedToken.getWhitespaces(rb2) + "]";;
					
				}
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_18_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  unary_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  p = null;
		IToken  m = null;
		IToken  l = null;
		IToken  b = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case PLUS:
			{
				p = LT(1);
				match(PLUS);
				return_string=unary_expression();
				if (0==inputState.guessing)
				{
					return_string = p.getText () + return_string ;
				}
				break;
			}
			case MINUS:
			{
				m = LT(1);
				match(MINUS);
				return_string=unary_expression();
				if (0==inputState.guessing)
				{
					return_string = m.getText () + return_string ;
				}
				break;
			}
			case LNOT:
			{
				l = LT(1);
				match(LNOT);
				return_string=unary_expression();
				if (0==inputState.guessing)
				{
					return_string = l.getText () + return_string ;
				}
				break;
			}
			case BNOT:
			{
				b = LT(1);
				match(BNOT);
				return_string=unary_expression();
				if (0==inputState.guessing)
				{
					return_string = b.getText () + return_string ;
				}
				break;
			}
			case STAR:
			{
				match(STAR);
				return_string=unary_expression();
				break;
			}
			case INC:
			{
				return_string=pre_increment_expression(true);
				break;
			}
			case DEC:
			{
				return_string=pre_decrement_expression(true);
				break;
			}
			default:
				bool synPredMatched95 = false;
				if (((LA(1)==LPAREN) && (tokenSet_3_.member(LA(2)))))
				{
					int _m95 = mark();
					synPredMatched95 = true;
					inputState.guessing++;
					try {
						{
							cast_expression();
						}
					}
					catch (RecognitionException)
					{
						synPredMatched95 = false;
					}
					rewind(_m95);
					inputState.guessing--;
				}
				if ( synPredMatched95 )
				{
					return_string=cast_expression();
				}
				else if ((tokenSet_14_.member(LA(1))) && (tokenSet_15_.member(LA(2)))) {
					return_string=primary_expression();
				}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			break; }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_17_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  cast_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  lp = null;
		IToken  rp = null;
		
		string [] t = new string[]{"",""};
		return_string = "";
		
		
		try {      // for error handling
			lp = LT(1);
			match(LPAREN);
			t=type();
			rp = LT(1);
			match(RPAREN);
			return_string=unary_expression();
			if (0==inputState.guessing)
			{
				return_string = lp.getText () + return_string + " :> " + t[0]+t[1] + rp.getText ()  ;
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_17_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  pre_increment_expression(
		bool in_expr
	) //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  i = null;
		
		return_string = "";
		
		
		try {      // for error handling
			i = LT(1);
			match(INC);
			return_string=unary_expression();
			if (0==inputState.guessing)
			{
				if (in_expr)
				return_string = ExtendedToken.getWhitespaces(i) + "({ def _tmp = " + return_string 
				+ "; " + ExtendedToken.getTextOnly (i) + return_string + "; _tmp })";
				else 
				return_string = i.getText () + return_string ;  
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_17_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  pre_decrement_expression(
		bool in_expr
	) //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  d = null;
		
		return_string = "";
		
		
		try {      // for error handling
			d = LT(1);
			match(DEC);
			return_string=unary_expression();
			if (0==inputState.guessing)
			{
				if (in_expr)
				return_string = ExtendedToken.getWhitespaces(d) + "({ def _tmp = " + return_string 
				+ "; " + ExtendedToken.getTextOnly (d) + return_string + "; _tmp })";
				else 
				return_string = d.getText () + return_string ;  
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_17_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  multiplicative_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		string mop = "";
		string ue = "";
		return_string = "";
		
		
		try {      // for error handling
			return_string=unary_expression();
			{    // ( ... )*
				for (;;)
				{
					if (((LA(1) >= STAR && LA(1) <= MOD)))
					{
						mop=multiplicative_op();
						ue=unary_expression();
						if (0==inputState.guessing)
						{
							
							return_string += (mop + ue);
							
						}
					}
					else
					{
						goto _loop101_breakloop;
					}
					
				}
_loop101_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_29_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  multiplicative_op() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  s = null;
		IToken  d = null;
		IToken  m = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case STAR:
			{
				s = LT(1);
				match(STAR);
				if (0==inputState.guessing)
				{
					return_string = s.getText () ;
				}
				break;
			}
			case DIV:
			{
				d = LT(1);
				match(DIV);
				if (0==inputState.guessing)
				{
					return_string = d.getText () ;
				}
				break;
			}
			case MOD:
			{
				m = LT(1);
				match(MOD);
				if (0==inputState.guessing)
				{
					return_string = m.getText () ;
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_8_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  additive_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		string aop = "";
		string me = "";
		return_string = "";
		
		
		try {      // for error handling
			return_string=multiplicative_expression();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==PLUS||LA(1)==MINUS))
					{
						aop=additive_op();
						me=multiplicative_expression();
						if (0==inputState.guessing)
						{
							
							return_string += (aop + me);
							
						}
					}
					else
					{
						goto _loop105_breakloop;
					}
					
				}
_loop105_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_30_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  additive_op() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  p = null;
		IToken  m = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case PLUS:
			{
				p = LT(1);
				match(PLUS);
				if (0==inputState.guessing)
				{
					return_string = p.getText () ;
				}
				break;
			}
			case MINUS:
			{
				m = LT(1);
				match(MINUS);
				if (0==inputState.guessing)
				{
					return_string = m.getText () ;
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_8_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  shift_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		string sop = "";
		string ae = "";
		return_string = "";
		
		
		try {      // for error handling
			return_string=additive_expression();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==SR||LA(1)==SL))
					{
						sop=shift_op();
						ae=additive_expression();
						if (0==inputState.guessing)
						{
							
							return_string += (sop + ae);
							
						}
					}
					else
					{
						goto _loop109_breakloop;
					}
					
				}
_loop109_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_31_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  shift_op() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  sl = null;
		IToken  sr = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case SL:
			{
				sl = LT(1);
				match(SL);
				if (0==inputState.guessing)
				{
					return_string = sl.getText () ;
				}
				break;
			}
			case SR:
			{
				sr = LT(1);
				match(SR);
				if (0==inputState.guessing)
				{
					return_string = sr.getText () ;
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_8_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  relational_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  tis = null;
		
		string rop = "";
		string [] se = new string[]{"",""};
		string s = "";
		return_string = "";
		
		
		try {      // for error handling
			bool synPredMatched113 = false;
			if (((tokenSet_8_.member(LA(1))) && (tokenSet_32_.member(LA(2)))))
			{
				int _m113 = mark();
				synPredMatched113 = true;
				inputState.guessing++;
				try {
					{
						shift_expression();
						relational_op();
					}
				}
				catch (RecognitionException)
				{
					synPredMatched113 = false;
				}
				rewind(_m113);
				inputState.guessing--;
			}
			if ( synPredMatched113 )
			{
				return_string=shift_expression();
				{ // ( ... )+
					int _cnt115=0;
					for (;;)
					{
						if ((tokenSet_33_.member(LA(1))))
						{
							rop=relational_op();
							s=shift_expression();
							if (0==inputState.guessing)
							{
								
								return_string += (rop + s);
								
							}
						}
						else
						{
							if (_cnt115 >= 1) { goto _loop115_breakloop; } else { throw new NoViableAltException(LT(1), getFilename());; }
						}
						
						_cnt115++;
					}
_loop115_breakloop:					;
				}    // ( ... )+
			}
			else {
				bool synPredMatched117 = false;
				if (((tokenSet_8_.member(LA(1))) && (tokenSet_34_.member(LA(2)))))
				{
					int _m117 = mark();
					synPredMatched117 = true;
					inputState.guessing++;
					try {
						{
							shift_expression();
							match(IS);
						}
					}
					catch (RecognitionException)
					{
						synPredMatched117 = false;
					}
					rewind(_m117);
					inputState.guessing--;
				}
				if ( synPredMatched117 )
				{
					return_string=shift_expression();
					{ // ( ... )+
						int _cnt119=0;
						for (;;)
						{
							if ((LA(1)==IS))
							{
								tis = LT(1);
								match(IS);
								se=type();
								if (0==inputState.guessing)
								{
									
									return_string += (tis.getText () + se[0]+se[1]);
									
								}
							}
							else
							{
								if (_cnt119 >= 1) { goto _loop119_breakloop; } else { throw new NoViableAltException(LT(1), getFilename());; }
							}
							
							_cnt119++;
						}
_loop119_breakloop:						;
					}    // ( ... )+
				}
				else {
					bool synPredMatched121 = false;
					if (((tokenSet_8_.member(LA(1))) && (tokenSet_35_.member(LA(2)))))
					{
						int _m121 = mark();
						synPredMatched121 = true;
						inputState.guessing++;
						try {
							{
								shift_expression();
								match(AS);
							}
						}
						catch (RecognitionException)
						{
							synPredMatched121 = false;
						}
						rewind(_m121);
						inputState.guessing--;
					}
					if ( synPredMatched121 )
					{
						return_string=shift_expression();
						{
							match(AS);
							se=type();
							if (0==inputState.guessing)
							{
								
								return_string = "(match (" + return_string + ") { _tmp is " + se[0] + se[1] + " => _tmp | _ => null })";
								
							}
						}
					}
					else if ((tokenSet_8_.member(LA(1))) && (tokenSet_36_.member(LA(2)))) {
						return_string=shift_expression();
					}
					else
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}}
				}
				catch (RecognitionException ex)
				{
					if (0 == inputState.guessing)
					{
						reportError(ex);
						recover(ex,tokenSet_37_);
					}
					else
					{
						throw ex;
					}
				}
				return return_string;
			}
			
	public string  relational_op() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  lt = null;
		IToken  gt = null;
		IToken  le = null;
		IToken  ge = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case LTHAN:
			{
				lt = LT(1);
				match(LTHAN);
				if (0==inputState.guessing)
				{
					return_string = lt.getText () ;
				}
				break;
			}
			case GTHAN:
			{
				gt = LT(1);
				match(GTHAN);
				if (0==inputState.guessing)
				{
					return_string = gt.getText () ;
				}
				break;
			}
			case LE:
			{
				le = LT(1);
				match(LE);
				if (0==inputState.guessing)
				{
					return_string = le.getText () ;
				}
				break;
			}
			case GE:
			{
				ge = LT(1);
				match(GE);
				if (0==inputState.guessing)
				{
					return_string = ge.getText () ;
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_8_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  equality_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		string eop = "";
		string re = "";
		return_string = "";
		
		
		try {      // for error handling
			return_string=relational_expression();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==EQUAL||LA(1)==NOT_EQUAL))
					{
						eop=equality_op();
						re=relational_expression();
						if (0==inputState.guessing)
						{
							
							return_string += (eop + re);
							
						}
					}
					else
					{
						goto _loop126_breakloop;
					}
					
				}
_loop126_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_38_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  equality_op() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  e = null;
		IToken  n = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case EQUAL:
			{
				e = LT(1);
				match(EQUAL);
				if (0==inputState.guessing)
				{
					return_string = e.getText () ;
				}
				break;
			}
			case NOT_EQUAL:
			{
				n = LT(1);
				match(NOT_EQUAL);
				if (0==inputState.guessing)
				{
					return_string = n.getText () ;
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_8_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  and_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  b = null;
		
		string ee = "";
		return_string = "";
		
		
		try {      // for error handling
			return_string=equality_expression();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==BAND))
					{
						b = LT(1);
						match(BAND);
						ee=equality_expression();
						if (0==inputState.guessing)
						{
							
								        ExtendedToken.prefix_text("%",b);
							return_string += (b.getText () + ee);
							
						}
					}
					else
					{
						goto _loop130_breakloop;
					}
					
				}
_loop130_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_39_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  exclusive_or_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  b = null;
		
		string ae = "";
		return_string = "";
		
		
		try {      // for error handling
			return_string=and_expression();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==BXOR))
					{
						b = LT(1);
						match(BXOR);
						ae=and_expression();
						if (0==inputState.guessing)
						{
							
								    	ExtendedToken.prefix_text("%",b);
							return_string += (b.getText () + ae);
							
						}
					}
					else
					{
						goto _loop133_breakloop;
					}
					
				}
_loop133_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_40_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  inclusive_or_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  b = null;
		
		string eoe = "";
		return_string = "";
		
		
		try {      // for error handling
			return_string=exclusive_or_expression();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==BOR))
					{
						b = LT(1);
						match(BOR);
						eoe=exclusive_or_expression();
						if (0==inputState.guessing)
						{
							
								        ExtendedToken.prefix_text("%",b);
							return_string += (b.getText () + eoe);
							
						}
					}
					else
					{
						goto _loop136_breakloop;
					}
					
				}
_loop136_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_41_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  conditional_and_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  l = null;
		
		string ioe = "";
		return_string = "";
		
		
		try {      // for error handling
			return_string=inclusive_or_expression();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==LAND))
					{
						l = LT(1);
						match(LAND);
						ioe=inclusive_or_expression();
						if (0==inputState.guessing)
						{
							
							return_string += (l.getText () + ioe);
							
						}
					}
					else
					{
						goto _loop139_breakloop;
					}
					
				}
_loop139_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_42_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  conditional_or_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  l = null;
		
		string cae = "";
		return_string = "";
		
		
		try {      // for error handling
			return_string=conditional_and_expression();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==LOR))
					{
						l = LT(1);
						match(LOR);
						cae=conditional_and_expression();
						if (0==inputState.guessing)
						{
							
							return_string += (l.getText () + cae);
							
						}
					}
					else
					{
						goto _loop142_breakloop;
					}
					
				}
_loop142_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_43_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  conditional_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  q = null;
		IToken  c = null;
		
		return_string = "";
		string e1="", e2="";
		
		
		try {      // for error handling
			return_string=conditional_or_expression();
			{
				switch ( LA(1) )
				{
				case QUESTION:
				{
					q = LT(1);
					match(QUESTION);
					e1=expression();
					c = LT(1);
					match(COLON);
					e2=expression();
					if (0==inputState.guessing)
					{
						return_string = ExtendedToken.getWhitespaces (q) + "if (" + return_string + ")" + e1 + 
						ExtendedToken.getWhitespaces (c) + "else " + e2;
					}
					break;
				}
				case EOF:
				case COMMA:
				case RBRACK:
				case RPAREN:
				case COLON:
				case SEMI:
				case RBRACE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_11_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  assignment_operator() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  a1 = null;
		IToken  a2 = null;
		IToken  a3 = null;
		IToken  a4 = null;
		IToken  a5 = null;
		IToken  a6 = null;
		IToken  a7 = null;
		IToken  a8 = null;
		IToken  a9 = null;
		IToken  a10 = null;
		IToken  a11 = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case ASSIGN:
			{
				a1 = LT(1);
				match(ASSIGN);
				if (0==inputState.guessing)
				{
					return_string = a1.getText () ;
				}
				break;
			}
			case PLUS_ASN:
			{
				a2 = LT(1);
				match(PLUS_ASN);
				if (0==inputState.guessing)
				{
					return_string = a2.getText () ;
				}
				break;
			}
			case MINUS_ASN:
			{
				a3 = LT(1);
				match(MINUS_ASN);
				if (0==inputState.guessing)
				{
					return_string = a3.getText () ;
				}
				break;
			}
			case STAR_ASN:
			{
				a4 = LT(1);
				match(STAR_ASN);
				if (0==inputState.guessing)
				{
					return_string = a4.getText () ;
				}
				break;
			}
			case DIV_ASN:
			{
				a5 = LT(1);
				match(DIV_ASN);
				if (0==inputState.guessing)
				{
					return_string = a5.getText () ;
				}
				break;
			}
			case MOD_ASN:
			{
				a6 = LT(1);
				match(MOD_ASN);
				if (0==inputState.guessing)
				{
					return_string = a6.getText () ;
				}
				break;
			}
			case BAND_ASN:
			{
				a7 = LT(1);
				match(BAND_ASN);
				if (0==inputState.guessing)
				{
					return_string = a7.getText () ;
				}
				break;
			}
			case BOR_ASN:
			{
				a8 = LT(1);
				match(BOR_ASN);
				if (0==inputState.guessing)
				{
					return_string = a8.getText () ;
				}
				break;
			}
			case BXOR_ASN:
			{
				a9 = LT(1);
				match(BXOR_ASN);
				if (0==inputState.guessing)
				{
					return_string = a9.getText () ;
				}
				break;
			}
			case SL_ASN:
			{
				a10 = LT(1);
				match(SL_ASN);
				if (0==inputState.guessing)
				{
					return_string = a10.getText () ;
				}
				break;
			}
			case SR_ASN:
			{
				a11 = LT(1);
				match(SR_ASN);
				if (0==inputState.guessing)
				{
					return_string = a11.getText () ;
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_8_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  assignment(
		bool in_expr
	) //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		string assig = "";
		string temp = "";
		return_string = "";
		
		
		try {      // for error handling
			return_string=unary_expression();
			assig=assignment_operator();
			temp=expression();
			if (0==inputState.guessing)
			{
				if (in_expr)
				return_string = "({ " + return_string + assig + temp + "; " + return_string + " })";
				else 
				return_string += assig + temp;  
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_11_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  constant_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		return_string = "";
		
		
		try {      // for error handling
			return_string=expression();
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_44_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  boolean_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		return_string = "";
		
		
		try {      // for error handling
			return_string=expression();
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_45_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public StatementTree  statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  i = null;
		IToken  c = null;
		
		t = new StatementTree();
		StatementTree st = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			bool synPredMatched153 = false;
			if (((LA(1)==IDENTIFIER) && (LA(2)==COLON)))
			{
				int _m153 = mark();
				synPredMatched153 = true;
				inputState.guessing++;
				try {
					{
						match(IDENTIFIER);
						match(COLON);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched153 = false;
				}
				rewind(_m153);
				inputState.guessing--;
			}
			if ( synPredMatched153 )
			{
				i = LT(1);
				match(IDENTIFIER);
				if (0==inputState.guessing)
				{
					
						    a.Add (new StatementTree(i));
						    Gotos.AddLabel (i);
						
				}
				c = LT(1);
				match(COLON);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(c));
				}
				st=statement();
				if (0==inputState.guessing)
				{
					a.Add (st);
				}
				if (0==inputState.guessing)
				{
					t = new StatementTree ("LABEL",a);
				}
			}
			else {
				bool synPredMatched155 = false;
				if (((tokenSet_46_.member(LA(1))) && (tokenSet_47_.member(LA(2)))))
				{
					int _m155 = mark();
					synPredMatched155 = true;
					inputState.guessing++;
					try {
						{
							match(CONST);
						}
					}
					catch (RecognitionException)
					{
						synPredMatched155 = false;
					}
					rewind(_m155);
					inputState.guessing--;
				}
				if ( synPredMatched155 )
				{
					t=declaration_statement();
				}
				else {
					bool synPredMatched157 = false;
					if (((tokenSet_46_.member(LA(1))) && (tokenSet_47_.member(LA(2)))))
					{
						int _m157 = mark();
						synPredMatched157 = true;
						inputState.guessing++;
						try {
							{
								type();
								match(IDENTIFIER);
							}
						}
						catch (RecognitionException)
						{
							synPredMatched157 = false;
						}
						rewind(_m157);
						inputState.guessing--;
					}
					if ( synPredMatched157 )
					{
						t=declaration_statement();
					}
					else if ((tokenSet_48_.member(LA(1))) && (tokenSet_49_.member(LA(2)))) {
						t=embedded_statement();
					}
					else
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}}
				}
				catch (RecognitionException ex)
				{
					if (0 == inputState.guessing)
					{
						reportError(ex);
						recover(ex,tokenSet_50_);
					}
					else
					{
						throw ex;
					}
				}
				return t;
			}
			
	public StatementTree  declaration_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  s1 = null;
		IToken  s2 = null;
		
		t = new StatementTree();
		string temp = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case IDENTIFIER:
			case OBJECT:
			case STRING:
			case BOOL:
			case DECIMAL:
			case CHAR:
			case INT:
			case LONG:
			case SBYTE:
			case BYTE:
			case SHORT:
			case UINT:
			case ULONG:
			case USHORT:
			case FLOAT:
			case DOUBLE:
			{
				temp=local_variable_declaration();
				s1 = LT(1);
				match(SEMI);
				if (0==inputState.guessing)
				{
					
					t = new StatementTree (temp + ExtendedToken.getWhitespaces (s1));
					
				}
				break;
			}
			case CONST:
			{
				temp=local_constant_declaration();
				s2 = LT(1);
				match(SEMI);
				if (0==inputState.guessing)
				{
					
					t = new StatementTree (temp + ExtendedToken.getWhitespaces (s2));
					
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_50_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  embedded_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  y = null;
		IToken  r = null;
		IToken  s = null;
		IToken  y1 = null;
		
		t = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		string exp;
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case LBRACE:
			{
				t=block();
				break;
			}
			case SEMI:
			{
				t=empty_statement();
				break;
			}
			case IF:
			case SWITCH:
			{
				t=selection_statement();
				break;
			}
			case WHILE:
			case DO:
			case FOR:
			case FOREACH:
			{
				t=iteration_statement();
				break;
			}
			case RETURN:
			case BREAK:
			case CONTINUE:
			case GOTO:
			case THROW:
			{
				t=jump_statement();
				break;
			}
			case TRY:
			{
				t=try_statement();
				break;
			}
			case LOCK:
			{
				t=lock_statement();
				break;
			}
			case USING:
			{
				t=using_statement();
				break;
			}
			default:
				bool synPredMatched160 = false;
				if (((LA(1)==CHECKED) && (LA(2)==LBRACE)))
				{
					int _m160 = mark();
					synPredMatched160 = true;
					inputState.guessing++;
					try {
						{
							match(CHECKED);
							block();
						}
					}
					catch (RecognitionException)
					{
						synPredMatched160 = false;
					}
					rewind(_m160);
					inputState.guessing--;
				}
				if ( synPredMatched160 )
				{
					t=checked_statement();
				}
				else if ((LA(1)==YIELD) && (LA(2)==RETURN)) {
					y = LT(1);
					match(YIELD);
					r = LT(1);
					match(RETURN);
					if (0==inputState.guessing)
					{
						a.Add (new StatementTree(y));
					}
					exp=expression();
					s = LT(1);
					match(SEMI);
					if (0==inputState.guessing)
					{
						
						a.Add (new StatementTree(exp));
						a.Add (new StatementTree(s));
						t = new StatementTree ("YIELD", a);
						
					}
				}
				else if ((LA(1)==YIELD) && (tokenSet_51_.member(LA(2)))) {
					y1 = LT(1);
					match(YIELD);
					if (0==inputState.guessing)
					{
						Message.Warning ("'yield break' is not supported in nemerle yet" , y1);
					}
					t=jump_statement();
				}
				else {
					bool synPredMatched162 = false;
					if (((LA(1)==UNCHECKED) && (LA(2)==LBRACE)))
					{
						int _m162 = mark();
						synPredMatched162 = true;
						inputState.guessing++;
						try {
							{
								match(UNCHECKED);
								block();
							}
						}
						catch (RecognitionException)
						{
							synPredMatched162 = false;
						}
						rewind(_m162);
						inputState.guessing--;
					}
					if ( synPredMatched162 )
					{
						t=unchecked_statement();
					}
					else if ((tokenSet_8_.member(LA(1))) && (tokenSet_52_.member(LA(2)))) {
						t=expression_statement();
					}
				else
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}break; }
			}
			catch (RecognitionException ex)
			{
				if (0 == inputState.guessing)
				{
					reportError(ex);
					recover(ex,tokenSet_53_);
				}
				else
				{
					throw ex;
				}
			}
			return t;
		}
		
	public StatementTree  empty_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  s = null;
		
		t = new StatementTree();
		StatementTree st = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			s = LT(1);
			match(SEMI);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(ExtendedToken.getWhitespaces(s) + "();"));
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree ("EMPTY",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  checked_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  c = null;
		
		t = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			c = LT(1);
			match(CHECKED);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(c));
			}
			t=block();
			if (0==inputState.guessing)
			{
				a.Add (t);
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("CHECKED",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  selection_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		
		t = new StatementTree();
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case IF:
			{
				t=if_statement();
				break;
			}
			case SWITCH:
			{
				t=switch_statement();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  iteration_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		
		t = new StatementTree();
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case WHILE:
			{
				t=while_statement();
				break;
			}
			case DO:
			{
				t=do_statement();
				break;
			}
			case FOR:
			{
				t=for_statement();
				break;
			}
			case FOREACH:
			{
				t=foreach_statement();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  jump_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		
		t = new StatementTree();
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case BREAK:
			{
				t=break_statement();
				break;
			}
			case CONTINUE:
			{
				t=continue_statement();
				break;
			}
			case GOTO:
			{
				t=goto_statement();
				break;
			}
			case RETURN:
			{
				t=return_statement();
				break;
			}
			case THROW:
			{
				t=throw_statement();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  try_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  tr = null;
		
		t = new StatementTree();
		StatementTree temp = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			tr = LT(1);
			match(TRY);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(tr));
			}
			temp=block();
			if (0==inputState.guessing)
			{
				a.Add (temp);
			}
			{
				switch ( LA(1) )
				{
				case CATCH:
				{
					temp=catch_clauses();
					if (0==inputState.guessing)
					{
						
						a.Add (temp);
						
					}
					{
						switch ( LA(1) )
						{
						case FINALLY:
						{
							temp=finally_clause();
							if (0==inputState.guessing)
							{
								a.Add (temp);
							}
							break;
						}
						case INTEGER_LITERAL:
						case HEXADECIMAL_INTEGER_LITERAL:
						case REAL_LITERAL:
						case CHARACTER_LITERAL:
						case NULL:
						case TRUE:
						case FALSE:
						case REGULAR_STRING_LITERAL:
						case VERBATIM_STRING_LITERAL:
						case IDENTIFIER:
						case OBJECT:
						case STRING:
						case BOOL:
						case DECIMAL:
						case CHAR:
						case INT:
						case LONG:
						case SBYTE:
						case BYTE:
						case SHORT:
						case UINT:
						case ULONG:
						case USHORT:
						case FLOAT:
						case DOUBLE:
						case DEC:
						case INC:
						case DELEGATE:
						case LPAREN:
						case NEW:
						case THIS:
						case BASE:
						case TYPEOF:
						case CHECKED:
						case UNCHECKED:
						case PLUS:
						case MINUS:
						case LNOT:
						case BNOT:
						case STAR:
						case CONST:
						case YIELD:
						case RETURN:
						case SEMI:
						case DEFAULT:
						case LBRACE:
						case RBRACE:
						case IF:
						case ELSE:
						case SWITCH:
						case CASE:
						case WHILE:
						case DO:
						case FOR:
						case FOREACH:
						case BREAK:
						case CONTINUE:
						case GOTO:
						case THROW:
						case TRY:
						case LOCK:
						case USING:
						{
							break;
						}
						default:
						{
							throw new NoViableAltException(LT(1), getFilename());
						}
						 }
					}
					break;
				}
				case FINALLY:
				{
					temp=finally_clause();
					if (0==inputState.guessing)
					{
						a.Add (temp);
					}
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("TRY",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  unchecked_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  u = null;
		
		t = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			u = LT(1);
			match(UNCHECKED);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(u));
			}
			t=block();
			if (0==inputState.guessing)
			{
				a.Add (t);
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("UNCHECKED",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  expression_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  s = null;
		
		t = new StatementTree();
		string temp = "";
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			temp=statement_expression();
			s = LT(1);
			match(SEMI);
			if (0==inputState.guessing)
			{
				
				a.Add ( new StatementTree (temp) );
				a.Add ( new StatementTree (s) );
				t = new StatementTree ("EXPRESSION_STATEMENT",a) ;
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  lock_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  l = null;
		IToken  lp = null;
		IToken  rp = null;
		
		t = new StatementTree();
		string e = "";
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			l = LT(1);
			match(LOCK);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(l));
			}
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(lp));
			}
			e=expression();
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(e));
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(rp));
			}
			t=embedded_statement();
			if (0==inputState.guessing)
			{
				a.Add (t);
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("LOCK",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  using_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  u = null;
		IToken  lp = null;
		IToken  rp = null;
		
		t = new StatementTree() ;    
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			u = LT(1);
			match(USING);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(u));
			}
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(lp));
			}
			t=resource_acquisition();
			if (0==inputState.guessing)
			{
				a.Add (t);
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(rp));
			}
			t=embedded_statement();
			if (0==inputState.guessing)
			{
				a.Add (t);
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("USING_STATEMENT",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public string  local_variable_declaration() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  c = null;
		
		string [] t = new string[]{"",""};
		string temp = "";
		return_string = "";
		
		
		try {      // for error handling
			t=type();
			return_string=local_variable_declarator(t);
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA))
					{
						c = LT(1);
						match(COMMA);
						temp=local_variable_declarator(t);
						if (0==inputState.guessing)
						{
							return_string += (temp + ExtendedToken.getWhitespaces (c));
						}
					}
					else
					{
						goto _loop171_breakloop;
					}
					
				}
_loop171_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_45_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  local_constant_declaration() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  c = null;
		IToken  cm = null;
		
		return_string = "";
		string temp = "";
		
		
		try {      // for error handling
			c = LT(1);
			match(CONST);
			type();
			return_string=local_constant_declarator(ExtendedToken.getWhitespaces (c),"");
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA))
					{
						cm = LT(1);
						match(COMMA);
						temp=local_constant_declarator(ExtendedToken.getWhitespaces (c),ExtendedToken.getWhitespaces (cm));
						if (0==inputState.guessing)
						{
							return_string += temp;
						}
					}
					else
					{
						goto _loop180_breakloop;
					}
					
				}
_loop180_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_1_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  local_variable_declarator(
		string [] t
	) //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  id0 = null;
		IToken  a0 = null;
		IToken  nu = null;
		IToken  id1 = null;
		IToken  a = null;
		IToken  id2 = null;
		
		string lvi = "";
		return_string = "";
		
		
		try {      // for error handling
			bool synPredMatched174 = false;
			if (((LA(1)==IDENTIFIER) && (LA(2)==ASSIGN)))
			{
				int _m174 = mark();
				synPredMatched174 = true;
				inputState.guessing++;
				try {
					{
						match(IDENTIFIER);
						match(ASSIGN);
						match(NULL);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched174 = false;
				}
				rewind(_m174);
				inputState.guessing--;
			}
			if ( synPredMatched174 )
			{
				id0 = LT(1);
				match(IDENTIFIER);
				a0 = LT(1);
				match(ASSIGN);
				nu = LT(1);
				match(NULL);
				if (0==inputState.guessing)
				{
					
					return_string = t[0] + "mutable " + id0.getText () + a0.getText () + nu.getText () +
					" : " + t[1] + ";";
					
				}
			}
			else {
				bool synPredMatched176 = false;
				if (((LA(1)==IDENTIFIER) && (LA(2)==ASSIGN)))
				{
					int _m176 = mark();
					synPredMatched176 = true;
					inputState.guessing++;
					try {
						{
							match(IDENTIFIER);
							match(ASSIGN);
						}
					}
					catch (RecognitionException)
					{
						synPredMatched176 = false;
					}
					rewind(_m176);
					inputState.guessing--;
				}
				if ( synPredMatched176 )
				{
					id1 = LT(1);
					match(IDENTIFIER);
					a = LT(1);
					match(ASSIGN);
					lvi=local_variable_initializer();
					if (0==inputState.guessing)
					{
						
						return_string = t[0] + "mutable " + id1.getText () + a.getText () + lvi + ";";
						
					}
				}
				else if ((LA(1)==IDENTIFIER) && (LA(2)==COMMA||LA(2)==RPAREN||LA(2)==SEMI)) {
					id2 = LT(1);
					match(IDENTIFIER);
					if (0==inputState.guessing)
					{
						
							    switch (t[1])
							    {		    
							        case "int" :
								   return_string = t[0] + "mutable " + id2.getText () + " = 0;";
								    break;
								case "float" :
								case "double" :
								case "uint" :	    
								case "long" :
								case "ulong" :
								case "short" :
								case "ushort" :
								case "decimal":
								case "byte" : 
								case "sbyte" : 		    		    
								    return_string = t[0] + "mutable " + id2.getText () + " = 0 : " + t[1] + ";";
								    break;		    
								case "char" :
								    return_string = t[0] + "mutable " + id2.getText () + " = '\0';";
								    break;
								default:
								if (Options.NemerlishDefaultValue)
								    return_string = t[0] + "mutable " + id2.getText () + " = null;";
								else
								    return_string = t[0] + "mutable " + id2.getText () + " = " + "Nemerle.Extensions.DefaultValue (" + t[1] + ");";
								    break;
							    }	    
						
					}
				}
				else
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
			}
			catch (RecognitionException ex)
			{
				if (0 == inputState.guessing)
				{
					reportError(ex);
					recover(ex,tokenSet_54_);
				}
				else
				{
					throw ex;
				}
			}
			return return_string;
		}
		
	public string  local_variable_initializer() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case INTEGER_LITERAL:
			case HEXADECIMAL_INTEGER_LITERAL:
			case REAL_LITERAL:
			case CHARACTER_LITERAL:
			case NULL:
			case TRUE:
			case FALSE:
			case REGULAR_STRING_LITERAL:
			case VERBATIM_STRING_LITERAL:
			case IDENTIFIER:
			case OBJECT:
			case STRING:
			case DECIMAL:
			case CHAR:
			case INT:
			case LONG:
			case SBYTE:
			case BYTE:
			case SHORT:
			case UINT:
			case ULONG:
			case USHORT:
			case FLOAT:
			case DOUBLE:
			case DEC:
			case INC:
			case DELEGATE:
			case LPAREN:
			case NEW:
			case THIS:
			case BASE:
			case TYPEOF:
			case CHECKED:
			case UNCHECKED:
			case PLUS:
			case MINUS:
			case LNOT:
			case BNOT:
			case STAR:
			case DEFAULT:
			{
				return_string=expression();
				break;
			}
			case LBRACE:
			{
				return_string=array_initializer();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_54_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  local_constant_declarator(
		string c1,string c2
	) //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  id = null;
		IToken  a = null;
		
		return_string = "";
		string ce = "";
		
		
		try {      // for error handling
			id = LT(1);
			match(IDENTIFIER);
			a = LT(1);
			match(ASSIGN);
			ce=constant_expression();
			if (0==inputState.guessing)
			{
				
				return_string = c1 + "def " + c2 + id.getText () + a.getText () + ce + ";";
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_55_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  statement_expression() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		return_string = "";
		
		
		try {      // for error handling
			bool synPredMatched185 = false;
			if (((tokenSet_8_.member(LA(1))) && (tokenSet_10_.member(LA(2)))))
			{
				int _m185 = mark();
				synPredMatched185 = true;
				inputState.guessing++;
				try {
					{
						assignment(false);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched185 = false;
				}
				rewind(_m185);
				inputState.guessing--;
			}
			if ( synPredMatched185 )
			{
				return_string=assignment(false);
			}
			else if ((tokenSet_14_.member(LA(1))) && (tokenSet_56_.member(LA(2)))) {
				return_string=primary_expression();
			}
			else if ((LA(1)==INC) && (tokenSet_8_.member(LA(2)))) {
				return_string=pre_increment_expression(false);
			}
			else if ((LA(1)==DEC) && (tokenSet_8_.member(LA(2)))) {
				return_string=pre_decrement_expression(false);
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_54_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public StatementTree  if_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  i1 = null;
		IToken  lp1 = null;
		IToken  rp1 = null;
		IToken  e = null;
		IToken  i2 = null;
		IToken  lp2 = null;
		IToken  rp2 = null;
		
		t = new StatementTree();
		StatementTree t1 = new StatementTree();
		StatementTree t2; 
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		string be = "";
		
		
		try {      // for error handling
			bool synPredMatched190 = false;
			if (((LA(1)==IF) && (LA(2)==LPAREN)))
			{
				int _m190 = mark();
				synPredMatched190 = true;
				inputState.guessing++;
				try {
					{
						match(IF);
						match(LPAREN);
						boolean_expression();
						match(RPAREN);
						embedded_statement();
						match(ELSE);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched190 = false;
				}
				rewind(_m190);
				inputState.guessing--;
			}
			if ( synPredMatched190 )
			{
				i1 = LT(1);
				match(IF);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(i1));
				}
				lp1 = LT(1);
				match(LPAREN);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(lp1));
				}
				be=boolean_expression();
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(be));
				}
				rp1 = LT(1);
				match(RPAREN);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(rp1));
				}
				t1=embedded_statement();
				if (0==inputState.guessing)
				{
					a.Add (t1);
				}
				e = LT(1);
				match(ELSE);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(e));t2 = new StatementTree();
				}
				t2=embedded_statement();
				if (0==inputState.guessing)
				{
					a.Add (t2);
				}
				if (0==inputState.guessing)
				{
					t = new StatementTree("IF",a);
				}
			}
			else if ((LA(1)==IF) && (LA(2)==LPAREN)) {
				i2 = LT(1);
				match(IF);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree( new ExtendedToken(ExtendedToken.getWhitespaces (i2), "when")));
				}
				lp2 = LT(1);
				match(LPAREN);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(lp2));
				}
				be=boolean_expression();
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(be));
				}
				rp2 = LT(1);
				match(RPAREN);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(rp2));
				}
				t1=embedded_statement();
				if (0==inputState.guessing)
				{
					a.Add (t1);
				}
				if (0==inputState.guessing)
				{
					t = new StatementTree("WHEN",a);
				}
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  switch_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  s = null;
		IToken  lp = null;
		IToken  rp = null;
		
		t = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		string exp = "";
		
		
		try {      // for error handling
			s = LT(1);
			match(SWITCH);
			lp = LT(1);
			match(LPAREN);
			exp=expression();
			rp = LT(1);
			match(RPAREN);
			t=switch_block();
			if (0==inputState.guessing)
			{
				
					    a.Add (new StatementTree(s));
					    a.Add (new StatementTree(lp));
					    a.Add (new StatementTree(exp));
					    a.Add (new StatementTree(rp));
					    a.Add (t);
					    t = new StatementTree("SWITCH",a);
					
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  switch_block() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  lb = null;
		IToken  rb = null;
		
		t = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			lb = LT(1);
			match(LBRACE);
			if (0==inputState.guessing)
			{
				a.Add(new StatementTree(lb));
			}
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==DEFAULT||LA(1)==CASE))
					{
						t=switch_section();
						if (0==inputState.guessing)
						{
							a.Add(t);
						}
					}
					else
					{
						goto _loop194_breakloop;
					}
					
				}
_loop194_breakloop:				;
			}    // ( ... )*
			rb = LT(1);
			match(RBRACE);
			if (0==inputState.guessing)
			{
				a.Add(new StatementTree(rb));
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("SWITCH_BLOCK",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  switch_section() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		
		t = new StatementTree();
		StatementTree t1 = new StatementTree ();
		StatementTree t2 = new StatementTree ();
		LinkedList<StatementTree> a1 = new LinkedList<StatementTree> ();
		LinkedList<StatementTree> a2 = new LinkedList<StatementTree> ();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			{ // ( ... )+
				int _cnt197=0;
				for (;;)
				{
					if ((LA(1)==DEFAULT||LA(1)==CASE) && (tokenSet_57_.member(LA(2))))
					{
						t=switch_label();
						if (0==inputState.guessing)
						{
							a1.Add(t);
						}
					}
					else
					{
						if (_cnt197 >= 1) { goto _loop197_breakloop; } else { throw new NoViableAltException(LT(1), getFilename());; }
					}
					
					_cnt197++;
				}
_loop197_breakloop:				;
			}    // ( ... )+
			{ // ( ... )+
				int _cnt199=0;
				for (;;)
				{
					if (((tokenSet_23_.member(LA(1))) && (tokenSet_58_.member(LA(2))))&&(LA(1)!=DEFAULT))
					{
						t=statement();
						if (0==inputState.guessing)
						{
							a2.Add(t);
						}
					}
					else
					{
						if (_cnt199 >= 1) { goto _loop199_breakloop; } else { throw new NoViableAltException(LT(1), getFilename());; }
					}
					
					_cnt199++;
				}
_loop199_breakloop:				;
			}    // ( ... )+
			if (0==inputState.guessing)
			{
				
					    t1 = new StatementTree("SWITCH_SECTION_LABELS",a1);
					    t2 = new StatementTree("SWITCH_SECTION_STATEMENTS",a2);	
					    a.Add(t1);
					    a.Add(t2);
					    t = new StatementTree("SWITCH_SECTION",a);
					
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_59_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  switch_label() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  c = null;
		IToken  cl1 = null;
		IToken  d = null;
		IToken  cl2 = null;
		
		t = new StatementTree ();    
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		string ce = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case CASE:
			{
				c = LT(1);
				match(CASE);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(c));
				}
				ce=constant_expression();
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(ce));
				}
				cl1 = LT(1);
				match(COLON);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(cl1));
				}
				if (0==inputState.guessing)
				{
					t = new StatementTree("SWITCH_LABEL",a);
				}
				break;
			}
			case DEFAULT:
			{
				d = LT(1);
				match(DEFAULT);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(d));
				}
				cl2 = LT(1);
				match(COLON);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(cl2));
				}
				if (0==inputState.guessing)
				{
					t = new StatementTree("SWITCH_DEFAULT",a);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_60_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  while_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  w = null;
		IToken  lp = null;
		IToken  rp = null;
		
		t = new StatementTree();
		StatementTree t1 = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		string be = "";
		
		
		try {      // for error handling
			w = LT(1);
			match(WHILE);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(w));
			}
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(lp));
			}
			be=boolean_expression();
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(be));
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(rp));
			}
			t1=embedded_statement();
			if (0==inputState.guessing)
			{
				a.Add (t1);
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("WHILE",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  do_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  d = null;
		IToken  w = null;
		IToken  lp = null;
		IToken  rp = null;
		IToken  s = null;
		
		t = new StatementTree();
		StatementTree t1 = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		string be = "";
		
		
		try {      // for error handling
			d = LT(1);
			match(DO);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(d));
			}
			t1=embedded_statement();
			if (0==inputState.guessing)
			{
				a.Add (t1);
			}
			w = LT(1);
			match(WHILE);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(w));
			}
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(lp));
			}
			be=boolean_expression();
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(be));
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(rp));
			}
			s = LT(1);
			match(SEMI);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(s));
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("DO",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  for_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  f = null;
		IToken  lp = null;
		IToken  s1 = null;
		IToken  s2 = null;
		IToken  rp = null;
		
		t = new StatementTree();
		StatementTree temp = new StatementTree();
		string finit = "";
		string fcond = "";
		string fiter = "";
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			f = LT(1);
			match(FOR);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(f));
			}
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(lp));
			}
			{
				switch ( LA(1) )
				{
				case INTEGER_LITERAL:
				case HEXADECIMAL_INTEGER_LITERAL:
				case REAL_LITERAL:
				case CHARACTER_LITERAL:
				case NULL:
				case TRUE:
				case FALSE:
				case REGULAR_STRING_LITERAL:
				case VERBATIM_STRING_LITERAL:
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case DEC:
				case INC:
				case DELEGATE:
				case LPAREN:
				case NEW:
				case THIS:
				case BASE:
				case TYPEOF:
				case CHECKED:
				case UNCHECKED:
				case PLUS:
				case MINUS:
				case LNOT:
				case BNOT:
				case STAR:
				case DEFAULT:
				{
					finit=for_initializer();
					break;
				}
				case SEMI:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(finit));
			}
			s1 = LT(1);
			match(SEMI);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(s1));
			}
			{
				switch ( LA(1) )
				{
				case INTEGER_LITERAL:
				case HEXADECIMAL_INTEGER_LITERAL:
				case REAL_LITERAL:
				case CHARACTER_LITERAL:
				case NULL:
				case TRUE:
				case FALSE:
				case REGULAR_STRING_LITERAL:
				case VERBATIM_STRING_LITERAL:
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case DEC:
				case INC:
				case DELEGATE:
				case LPAREN:
				case NEW:
				case THIS:
				case BASE:
				case TYPEOF:
				case CHECKED:
				case UNCHECKED:
				case PLUS:
				case MINUS:
				case LNOT:
				case BNOT:
				case STAR:
				case DEFAULT:
				{
					fcond=for_condition();
					break;
				}
				case SEMI:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(fcond));
			}
			s2 = LT(1);
			match(SEMI);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(s2));
			}
			{
				switch ( LA(1) )
				{
				case INTEGER_LITERAL:
				case HEXADECIMAL_INTEGER_LITERAL:
				case REAL_LITERAL:
				case CHARACTER_LITERAL:
				case NULL:
				case TRUE:
				case FALSE:
				case REGULAR_STRING_LITERAL:
				case VERBATIM_STRING_LITERAL:
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case DEC:
				case INC:
				case DELEGATE:
				case LPAREN:
				case NEW:
				case THIS:
				case BASE:
				case TYPEOF:
				case CHECKED:
				case UNCHECKED:
				case PLUS:
				case MINUS:
				case LNOT:
				case BNOT:
				case STAR:
				case DEFAULT:
				{
					fiter=for_iterator();
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(fiter));
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(rp));
			}
			temp=embedded_statement();
			if (0==inputState.guessing)
			{
				a.Add (temp);
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("FOR",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  foreach_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  f = null;
		IToken  l = null;
		IToken  id = null;
		IToken  i = null;
		IToken  rp = null;
		
		t = new StatementTree();
		StatementTree es = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		string [] tp = new string[]{"",""};
		string e = "";
		
		
		try {      // for error handling
			f = LT(1);
			match(FOREACH);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(f));
			}
			l = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(l));
			}
			tp=type();
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(id));
			}
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(" :> "));
			}
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(tp[0]+tp[1]));
			}
			i = LT(1);
			match(IN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(i));
			}
			e=expression();
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(e));
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(rp));
			}
			es=embedded_statement();
			if (0==inputState.guessing)
			{
				a.Add (es);
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("FOREACH",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public string  for_initializer() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		return_string = "";
		
		
		try {      // for error handling
			bool synPredMatched210 = false;
			if (((tokenSet_3_.member(LA(1))) && (tokenSet_61_.member(LA(2)))))
			{
				int _m210 = mark();
				synPredMatched210 = true;
				inputState.guessing++;
				try {
					{
						type();
					}
				}
				catch (RecognitionException)
				{
					synPredMatched210 = false;
				}
				rewind(_m210);
				inputState.guessing--;
			}
			if ( synPredMatched210 )
			{
				return_string=local_variable_declaration();
				if (0==inputState.guessing)
				{
					
						   if(return_string.EndsWith(";"))
						   {
						       return_string = return_string.Substring(0,return_string.Length - 1 );
						   }
						
				}
			}
			else if ((tokenSet_8_.member(LA(1))) && (tokenSet_62_.member(LA(2)))) {
				return_string=statement_expression_list();
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_1_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  for_condition() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		return_string = "";
		
		
		try {      // for error handling
			return_string=boolean_expression();
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_1_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  for_iterator() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		return_string = "";
		
		
		try {      // for error handling
			return_string=statement_expression_list();
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_12_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  statement_expression_list() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  c = null;
		
		string se = "";
		return_string = "";
		bool in_loop = false;
		
		
		try {      // for error handling
			return_string=statement_expression();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA))
					{
						c = LT(1);
						match(COMMA);
						if (0==inputState.guessing)
						{
							in_loop = true;
						}
						se=statement_expression();
						if (0==inputState.guessing)
						{
							
							return_string += (ExtendedToken.getWhitespaces (c) + ";" + se);
							
						}
					}
					else
					{
						goto _loop215_breakloop;
					}
					
				}
_loop215_breakloop:				;
			}    // ( ... )*
			if (0==inputState.guessing)
			{
				if(in_loop)
				{
				return_string = "{" + return_string; 
				return_string += "}" ; 
				}
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_45_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public StatementTree  break_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  b = null;
		IToken  s = null;
		
		t = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			b = LT(1);
			match(BREAK);
			s = LT(1);
			match(SEMI);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(b));
			}
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(s));
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("BREAK",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  continue_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  c = null;
		IToken  s = null;
		
		t = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			c = LT(1);
			match(CONTINUE);
			s = LT(1);
			match(SEMI);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(c));
			}
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(s));
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("CONTINUE",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  goto_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  g = null;
		IToken  i = null;
		IToken  s = null;
		
		t = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			bool synPredMatched222 = false;
			if (((LA(1)==GOTO) && (LA(2)==IDENTIFIER)))
			{
				int _m222 = mark();
				synPredMatched222 = true;
				inputState.guessing++;
				try {
					{
						match(GOTO);
						match(IDENTIFIER);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched222 = false;
				}
				rewind(_m222);
				inputState.guessing--;
			}
			if ( synPredMatched222 )
			{
				g = LT(1);
				match(GOTO);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(g));
				}
				i = LT(1);
				match(IDENTIFIER);
				if (0==inputState.guessing)
				{
					
						    a.Add (new StatementTree(i));
						    Gotos.AddGoto (i);
						
				}
				s = LT(1);
				match(SEMI);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(s));
				}
				if (0==inputState.guessing)
				{
					t = new StatementTree("GOTO",a);
				}
			}
			else {
				bool synPredMatched224 = false;
				if (((LA(1)==GOTO) && (LA(2)==CASE)))
				{
					int _m224 = mark();
					synPredMatched224 = true;
					inputState.guessing++;
					try {
						{
							match(GOTO);
							match(CASE);
						}
					}
					catch (RecognitionException)
					{
						synPredMatched224 = false;
					}
					rewind(_m224);
					inputState.guessing--;
				}
				if ( synPredMatched224 )
				{
					match(GOTO);
					match(CASE);
					constant_expression();
					match(SEMI);
				}
				else if ((LA(1)==GOTO) && (LA(2)==DEFAULT)) {
					match(GOTO);
					match(DEFAULT);
					match(SEMI);
				}
				else
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
			}
			catch (RecognitionException ex)
			{
				if (0 == inputState.guessing)
				{
					reportError(ex);
					recover(ex,tokenSet_53_);
				}
				else
				{
					throw ex;
				}
			}
			return t;
		}
		
	public StatementTree  return_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  r = null;
		IToken  s = null;
		
		t = new StatementTree();
		string exp = "";
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			r = LT(1);
			match(RETURN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(r));
			}
			{
				switch ( LA(1) )
				{
				case INTEGER_LITERAL:
				case HEXADECIMAL_INTEGER_LITERAL:
				case REAL_LITERAL:
				case CHARACTER_LITERAL:
				case NULL:
				case TRUE:
				case FALSE:
				case REGULAR_STRING_LITERAL:
				case VERBATIM_STRING_LITERAL:
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case DEC:
				case INC:
				case DELEGATE:
				case LPAREN:
				case NEW:
				case THIS:
				case BASE:
				case TYPEOF:
				case CHECKED:
				case UNCHECKED:
				case PLUS:
				case MINUS:
				case LNOT:
				case BNOT:
				case STAR:
				case DEFAULT:
				{
					exp=expression();
					if (0==inputState.guessing)
					{
						a.Add (new StatementTree(exp));
					}
					break;
				}
				case SEMI:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			s = LT(1);
			match(SEMI);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(s));
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("RETURN",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  throw_statement() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  th = null;
		IToken  s = null;
		
		t = new StatementTree();
		string e = "";
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			th = LT(1);
			match(THROW);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(th));
			}
			{
				switch ( LA(1) )
				{
				case INTEGER_LITERAL:
				case HEXADECIMAL_INTEGER_LITERAL:
				case REAL_LITERAL:
				case CHARACTER_LITERAL:
				case NULL:
				case TRUE:
				case FALSE:
				case REGULAR_STRING_LITERAL:
				case VERBATIM_STRING_LITERAL:
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case DEC:
				case INC:
				case DELEGATE:
				case LPAREN:
				case NEW:
				case THIS:
				case BASE:
				case TYPEOF:
				case CHECKED:
				case UNCHECKED:
				case PLUS:
				case MINUS:
				case LNOT:
				case BNOT:
				case STAR:
				case DEFAULT:
				{
					e=expression();
					break;
				}
				case SEMI:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(e));
			}
			s = LT(1);
			match(SEMI);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(s));
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("THROW",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  catch_clauses() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		
		t = new StatementTree();
		StatementTree temp = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			bool synPredMatched234 = false;
			if (((LA(1)==CATCH) && (LA(2)==LPAREN)))
			{
				int _m234 = mark();
				synPredMatched234 = true;
				inputState.guessing++;
				try {
					{
						specific_catch_clause();
					}
				}
				catch (RecognitionException)
				{
					synPredMatched234 = false;
				}
				rewind(_m234);
				inputState.guessing--;
			}
			if ( synPredMatched234 )
			{
				{ // ( ... )+
					int _cnt236=0;
					for (;;)
					{
						if ((LA(1)==CATCH) && (LA(2)==LPAREN))
						{
							temp=specific_catch_clause();
							if (0==inputState.guessing)
							{
								a.Add (temp);
							}
						}
						else
						{
							if (_cnt236 >= 1) { goto _loop236_breakloop; } else { throw new NoViableAltException(LT(1), getFilename());; }
						}
						
						_cnt236++;
					}
_loop236_breakloop:					;
				}    // ( ... )+
				{
					switch ( LA(1) )
					{
					case CATCH:
					{
						temp=general_catch_clause();
						if (0==inputState.guessing)
						{
							a.Add (temp);
						}
						break;
					}
					case INTEGER_LITERAL:
					case HEXADECIMAL_INTEGER_LITERAL:
					case REAL_LITERAL:
					case CHARACTER_LITERAL:
					case NULL:
					case TRUE:
					case FALSE:
					case REGULAR_STRING_LITERAL:
					case VERBATIM_STRING_LITERAL:
					case IDENTIFIER:
					case OBJECT:
					case STRING:
					case BOOL:
					case DECIMAL:
					case CHAR:
					case INT:
					case LONG:
					case SBYTE:
					case BYTE:
					case SHORT:
					case UINT:
					case ULONG:
					case USHORT:
					case FLOAT:
					case DOUBLE:
					case DEC:
					case INC:
					case DELEGATE:
					case LPAREN:
					case NEW:
					case THIS:
					case BASE:
					case TYPEOF:
					case CHECKED:
					case UNCHECKED:
					case PLUS:
					case MINUS:
					case LNOT:
					case BNOT:
					case STAR:
					case CONST:
					case YIELD:
					case RETURN:
					case SEMI:
					case DEFAULT:
					case LBRACE:
					case RBRACE:
					case IF:
					case ELSE:
					case SWITCH:
					case CASE:
					case WHILE:
					case DO:
					case FOR:
					case FOREACH:
					case BREAK:
					case CONTINUE:
					case GOTO:
					case THROW:
					case TRY:
					case FINALLY:
					case LOCK:
					case USING:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					 }
				}
				if (0==inputState.guessing)
				{
					t = new StatementTree("CATCH_CLAUSES",a);
				}
			}
			else if ((LA(1)==CATCH) && (LA(2)==LBRACE)) {
				temp=general_catch_clause();
				if (0==inputState.guessing)
				{
					a.Add (temp);
				}
				if (0==inputState.guessing)
				{
					t = new StatementTree("CATCH_CLAUSES",a);
				}
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_63_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  finally_clause() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  f = null;
		
		t = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			f = LT(1);
			match(FINALLY);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(f));
			}
			t=block();
			if (0==inputState.guessing)
			{
				a.Add (t);
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("FINALLY",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_53_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  specific_catch_clause() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  c = null;
		IToken  lp = null;
		IToken  s = null;
		IToken  o = null;
		IToken  id = null;
		IToken  rp = null;
		
		t = new StatementTree();
		string [] tp = new string[]{"",""};
		string catched_type = "";
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			c = LT(1);
			match(CATCH);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(c));
			}
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(lp));
			}
			{
				switch ( LA(1) )
				{
				case STRING:
				{
					s = LT(1);
					match(STRING);
					if (0==inputState.guessing)
					{
						catched_type = s.getText ();
					}
					break;
				}
				case OBJECT:
				{
					o = LT(1);
					match(OBJECT);
					if (0==inputState.guessing)
					{
						catched_type = o.getText ();
					}
					break;
				}
				case IDENTIFIER:
				{
					tp=type_name();
					if (0==inputState.guessing)
					{
						catched_type = tp[0] + tp[1];
					}
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(catched_type));
			}
			{
				switch ( LA(1) )
				{
				case IDENTIFIER:
				{
					id = LT(1);
					match(IDENTIFIER);
					if (0==inputState.guessing)
					{
						
								    a.Add (new StatementTree(id));
								
					}
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(rp));
			}
			t=block();
			if (0==inputState.guessing)
			{
				a.Add (t);
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("SPECIFIC_CATCH",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_64_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  general_catch_clause() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		IToken  c = null;
		
		t = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			c = LT(1);
			match(CATCH);
			if (0==inputState.guessing)
			{
				a.Add (new StatementTree(c));
			}
			t=block();
			if (0==inputState.guessing)
			{
				a.Add (t);
			}
			if (0==inputState.guessing)
			{
				t = new StatementTree("GENERAL_CATCH",a);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_63_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public StatementTree  resource_acquisition() //throws RecognitionException, TokenStreamException
{
		StatementTree t;
		
		
		t = new StatementTree() ;
		string e = "";
		
		
		try {      // for error handling
			bool synPredMatched249 = false;
			if (((tokenSet_3_.member(LA(1))) && (tokenSet_61_.member(LA(2)))))
			{
				int _m249 = mark();
				synPredMatched249 = true;
				inputState.guessing++;
				try {
					{
						type();
					}
				}
				catch (RecognitionException)
				{
					synPredMatched249 = false;
				}
				rewind(_m249);
				inputState.guessing--;
			}
			if ( synPredMatched249 )
			{
				e=local_variable_declaration();
				if (0==inputState.guessing)
				{
					if(e.EndsWith(";"))
						    {
							e = e.Substring(0,e.Length - 1 );
						    }
						    t = new StatementTree(e);
						
				}
			}
			else if ((tokenSet_8_.member(LA(1))) && (tokenSet_65_.member(LA(2)))) {
				e=expression();
				if (0==inputState.guessing)
				{
					t = new StatementTree(e);
				}
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_12_);
			}
			else
			{
				throw ex;
			}
		}
		return t;
	}
	
	public void compilation_unit() //throws RecognitionException, TokenStreamException
{
		
		
		try {      // for error handling
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==USING))
					{
						using_directive();
					}
					else if ((LA(1)==LBRACK) && (LA(2)==IDENTIFIER)) {
						{
							global_attributes();
						}
					}
					else if ((tokenSet_66_.member(LA(1))) && (tokenSet_67_.member(LA(2)))) {
						namespace_member_declaration();
					}
					else
					{
						goto _loop253_breakloop;
					}
					
				}
_loop253_breakloop:				;
			}    // ( ... )*
			if (0==inputState.guessing)
			{
				
				Emit.EmitString ("\n");
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_6_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void using_directive() //throws RecognitionException, TokenStreamException
{
		
		IToken  u1 = null;
		IToken  id = null;
		IToken  a = null;
		IToken  s1 = null;
		IToken  u2 = null;
		IToken  s2 = null;
		
		string [] nn = new string[]{"",""};
		
		
		try {      // for error handling
			bool synPredMatched266 = false;
			if (((LA(1)==USING) && (LA(2)==IDENTIFIER)))
			{
				int _m266 = mark();
				synPredMatched266 = true;
				inputState.guessing++;
				try {
					{
						match(USING);
						match(IDENTIFIER);
						match(ASSIGN);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched266 = false;
				}
				rewind(_m266);
				inputState.guessing--;
			}
			if ( synPredMatched266 )
			{
				u1 = LT(1);
				match(USING);
				id = LT(1);
				match(IDENTIFIER);
				a = LT(1);
				match(ASSIGN);
				if (0==inputState.guessing)
				{
					
					Emit.EmitToken (u1);
					Emit.EmitToken (id);
					Emit.EmitToken (a);
					
				}
				nn=namespace_or_type_name();
				{
					switch ( LA(1) )
					{
					case LTHAN:
					{
						generic_parameters();
						break;
					}
					case SEMI:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					 }
				}
				s1 = LT(1);
				match(SEMI);
				if (0==inputState.guessing)
				{
					
					Emit.EmitString (nn[0]+nn[1]);
					Emit.EmitToken (s1);
					
				}
			}
			else if ((LA(1)==USING) && (LA(2)==IDENTIFIER)) {
				u2 = LT(1);
				match(USING);
				if (0==inputState.guessing)
				{
					
					Emit.EmitToken (u2);
					
				}
				nn=namespace_name();
				s2 = LT(1);
				match(SEMI);
				if (0==inputState.guessing)
				{
					
					Emit.EmitString (nn[0]+nn[1]);
					Emit.EmitToken (s2);
					
				}
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_68_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void global_attributes() //throws RecognitionException, TokenStreamException
{
		
		
		try {      // for error handling
			{ // ( ... )+
				int _cnt593=0;
				for (;;)
				{
					if ((LA(1)==LBRACK) && (LA(2)==IDENTIFIER))
					{
						global_attribute_section();
					}
					else
					{
						if (_cnt593 >= 1) { goto _loop593_breakloop; } else { throw new NoViableAltException(LT(1), getFilename());; }
					}
					
					_cnt593++;
				}
_loop593_breakloop:				;
			}    // ( ... )+
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_69_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void namespace_member_declaration() //throws RecognitionException, TokenStreamException
{
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case NAMESPACE:
			{
				namespace_declaration();
				break;
			}
			case LBRACK:
			case DELEGATE:
			case NEW:
			case ENUM:
			case STRUCT:
			case INTERFACE:
			case CLASS:
			case PUBLIC:
			case PROTECTED:
			case INTERNAL:
			case PRIVATE:
			case SEALED:
			case ABSTRACT:
			case STATIC:
			case PARTIAL:
			{
				type_declaration();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_68_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void namespace_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  ns = null;
		IToken  s = null;
		
		string semi = "";
		string qi;
		
		
		try {      // for error handling
			ns = LT(1);
			match(NAMESPACE);
			qi=qualified_identifier();
			if (0==inputState.guessing)
			{
				
				Emit.EmitToken (ns);
				Emit.EmitString (qi);
				
			}
			namespace_body();
			{
				switch ( LA(1) )
				{
				case SEMI:
				{
					s = LT(1);
					match(SEMI);
					if (0==inputState.guessing)
					{
						semi = s.getText();
					}
					break;
				}
				case EOF:
				case LBRACK:
				case DELEGATE:
				case NEW:
				case RBRACE:
				case USING:
				case NAMESPACE:
				case ENUM:
				case STRUCT:
				case INTERFACE:
				case CLASS:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				case SEALED:
				case ABSTRACT:
				case STATIC:
				case PARTIAL:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			if (0==inputState.guessing)
			{
				
				Emit.EmitString (semi);
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_68_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public string  qualified_identifier() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  id1 = null;
		IToken  id2 = null;
		
		return_string = "";
		
		
		try {      // for error handling
			id1 = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				return_string = id1.getText();
			}
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==DOT))
					{
						match(DOT);
						id2 = LT(1);
						match(IDENTIFIER);
						if (0==inputState.guessing)
						{
							return_string += ("." + id2.getText());
						}
					}
					else
					{
						goto _loop258_breakloop;
					}
					
				}
_loop258_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_22_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public void namespace_body() //throws RecognitionException, TokenStreamException
{
		
		IToken  lb = null;
		IToken  rb = null;
		
		try {      // for error handling
			lb = LT(1);
			match(LBRACE);
			if (0==inputState.guessing)
			{
				
				Emit.EmitToken (lb);
				
			}
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==USING))
					{
						using_directive();
					}
					else
					{
						goto _loop261_breakloop;
					}
					
				}
_loop261_breakloop:				;
			}    // ( ... )*
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_66_.member(LA(1))))
					{
						namespace_member_declaration();
					}
					else
					{
						goto _loop263_breakloop;
					}
					
				}
_loop263_breakloop:				;
			}    // ( ... )*
			rb = LT(1);
			match(RBRACE);
			if (0==inputState.guessing)
			{
				
				Emit.EmitToken (rb);
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_70_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void type_declaration() //throws RecognitionException, TokenStreamException
{
		
		
		try {      // for error handling
			bool synPredMatched274 = false;
			if (((tokenSet_71_.member(LA(1))) && (tokenSet_72_.member(LA(2)))))
			{
				int _m274 = mark();
				synPredMatched274 = true;
				inputState.guessing++;
				try {
					{
						{
							switch ( LA(1) )
							{
							case LBRACK:
							{
								attributes();
								break;
							}
							case NEW:
							case ENUM:
							case PUBLIC:
							case PROTECTED:
							case INTERNAL:
							case PRIVATE:
							{
								break;
							}
							default:
							{
								throw new NoViableAltException(LT(1), getFilename());
							}
							 }
						}
						{    // ( ... )*
							for (;;)
							{
								if ((tokenSet_73_.member(LA(1))))
								{
									enum_modifier();
								}
								else
								{
									goto _loop273_breakloop;
								}
								
							}
_loop273_breakloop:							;
						}    // ( ... )*
						match(ENUM);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched274 = false;
				}
				rewind(_m274);
				inputState.guessing--;
			}
			if ( synPredMatched274 )
			{
				enum_declaration();
			}
			else {
				bool synPredMatched279 = false;
				if (((tokenSet_74_.member(LA(1))) && (tokenSet_75_.member(LA(2)))))
				{
					int _m279 = mark();
					synPredMatched279 = true;
					inputState.guessing++;
					try {
						{
							{
								switch ( LA(1) )
								{
								case LBRACK:
								{
									attributes();
									break;
								}
								case NEW:
								case STRUCT:
								case PUBLIC:
								case PROTECTED:
								case INTERNAL:
								case PRIVATE:
								case PARTIAL:
								{
									break;
								}
								default:
								{
									throw new NoViableAltException(LT(1), getFilename());
								}
								 }
							}
							{    // ( ... )*
								for (;;)
								{
									if ((tokenSet_76_.member(LA(1))))
									{
										struct_modifier();
									}
									else
									{
										goto _loop278_breakloop;
									}
									
								}
_loop278_breakloop:								;
							}    // ( ... )*
							match(STRUCT);
						}
					}
					catch (RecognitionException)
					{
						synPredMatched279 = false;
					}
					rewind(_m279);
					inputState.guessing--;
				}
				if ( synPredMatched279 )
				{
					struct_declaration();
				}
				else {
					bool synPredMatched284 = false;
					if (((tokenSet_77_.member(LA(1))) && (tokenSet_78_.member(LA(2)))))
					{
						int _m284 = mark();
						synPredMatched284 = true;
						inputState.guessing++;
						try {
							{
								{
									switch ( LA(1) )
									{
									case LBRACK:
									{
										attributes();
										break;
									}
									case NEW:
									case INTERFACE:
									case PUBLIC:
									case PROTECTED:
									case INTERNAL:
									case PRIVATE:
									case PARTIAL:
									{
										break;
									}
									default:
									{
										throw new NoViableAltException(LT(1), getFilename());
									}
									 }
								}
								{    // ( ... )*
									for (;;)
									{
										if ((tokenSet_76_.member(LA(1))))
										{
											interface_modifier();
										}
										else
										{
											goto _loop283_breakloop;
										}
										
									}
_loop283_breakloop:									;
								}    // ( ... )*
								match(INTERFACE);
							}
						}
						catch (RecognitionException)
						{
							synPredMatched284 = false;
						}
						rewind(_m284);
						inputState.guessing--;
					}
					if ( synPredMatched284 )
					{
						interface_declaration();
					}
					else {
						bool synPredMatched289 = false;
						if (((tokenSet_79_.member(LA(1))) && (tokenSet_80_.member(LA(2)))))
						{
							int _m289 = mark();
							synPredMatched289 = true;
							inputState.guessing++;
							try {
								{
									{
										switch ( LA(1) )
										{
										case LBRACK:
										{
											attributes();
											break;
										}
										case NEW:
										case CLASS:
										case PUBLIC:
										case PROTECTED:
										case INTERNAL:
										case PRIVATE:
										case SEALED:
										case ABSTRACT:
										case STATIC:
										case PARTIAL:
										{
											break;
										}
										default:
										{
											throw new NoViableAltException(LT(1), getFilename());
										}
										 }
									}
									{    // ( ... )*
										for (;;)
										{
											if ((tokenSet_81_.member(LA(1))))
											{
												class_modifier();
											}
											else
											{
												goto _loop288_breakloop;
											}
											
										}
_loop288_breakloop:										;
									}    // ( ... )*
									match(CLASS);
									match(IDENTIFIER);
								}
							}
							catch (RecognitionException)
							{
								synPredMatched289 = false;
							}
							rewind(_m289);
							inputState.guessing--;
						}
						if ( synPredMatched289 )
						{
							class_declaration();
						}
						else if ((tokenSet_82_.member(LA(1))) && (tokenSet_83_.member(LA(2)))) {
							delegate_declaration();
						}
						else
						{
							throw new NoViableAltException(LT(1), getFilename());
						}
						}}}
					}
					catch (RecognitionException ex)
					{
						if (0 == inputState.guessing)
						{
							reportError(ex);
							recover(ex,tokenSet_84_);
						}
						else
						{
							throw ex;
						}
					}
				}
				
	public void attributes() //throws RecognitionException, TokenStreamException
{
		
		
		try {      // for error handling
			{ // ( ... )+
				int _cnt600=0;
				for (;;)
				{
					if ((LA(1)==LBRACK))
					{
						attribute_section();
					}
					else
					{
						if (_cnt600 >= 1) { goto _loop600_breakloop; } else { throw new NoViableAltException(LT(1), getFilename());; }
					}
					
					_cnt600++;
				}
_loop600_breakloop:				;
			}    // ( ... )+
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_85_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void enum_modifier() //throws RecognitionException, TokenStreamException
{
		
		IToken  em1 = null;
		IToken  em2 = null;
		IToken  em3 = null;
		IToken  em4 = null;
		IToken  em5 = null;
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case NEW:
			{
				em1 = LT(1);
				match(NEW);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(em1);
				}
				break;
			}
			case PUBLIC:
			{
				em2 = LT(1);
				match(PUBLIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(em2);
				}
				break;
			}
			case PROTECTED:
			{
				em3 = LT(1);
				match(PROTECTED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(em3);
				}
				break;
			}
			case INTERNAL:
			{
				em4 = LT(1);
				match(INTERNAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(em4);
				}
				break;
			}
			case PRIVATE:
			{
				em5 = LT(1);
				match(PRIVATE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(em5);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_86_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void enum_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  e = null;
		IToken  id = null;
		IToken  s = null;
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case NEW:
				case ENUM:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_73_.member(LA(1))))
					{
						enum_modifier();
					}
					else
					{
						goto _loop568_breakloop;
					}
					
				}
_loop568_breakloop:				;
			}    // ( ... )*
			e = LT(1);
			match(ENUM);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(e);
			}
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(id);
			}
			{
				switch ( LA(1) )
				{
				case COLON:
				{
					enum_base();
					break;
				}
				case LBRACE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			enum_body();
			{
				switch ( LA(1) )
				{
				case SEMI:
				{
					s = LT(1);
					match(SEMI);
					if (0==inputState.guessing)
					{
						Emit.EmitToken(s);
					}
					break;
				}
				case EOF:
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case LBRACK:
				case DELEGATE:
				case NEW:
				case VOID:
				case BNOT:
				case CONST:
				case RBRACE:
				case USING:
				case NAMESPACE:
				case ENUM:
				case STRUCT:
				case INTERFACE:
				case CLASS:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				case SEALED:
				case ABSTRACT:
				case STATIC:
				case PARTIAL:
				case READONLY:
				case VOLATILE:
				case VIRTUAL:
				case OVERRIDE:
				case EXTERN:
				case EVENT:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_84_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void struct_modifier() //throws RecognitionException, TokenStreamException
{
		
		IToken  sm1 = null;
		IToken  sm2 = null;
		IToken  sm3 = null;
		IToken  sm4 = null;
		IToken  sm5 = null;
		IToken  sm6 = null;
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case NEW:
			{
				sm1 = LT(1);
				match(NEW);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(sm1);
				}
				break;
			}
			case PUBLIC:
			{
				sm2 = LT(1);
				match(PUBLIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(sm2);
				}
				break;
			}
			case PROTECTED:
			{
				sm3 = LT(1);
				match(PROTECTED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(sm3);
				}
				break;
			}
			case INTERNAL:
			{
				sm4 = LT(1);
				match(INTERNAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(sm4);
				}
				break;
			}
			case PRIVATE:
			{
				sm5 = LT(1);
				match(PRIVATE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(sm5);
				}
				break;
			}
			case PARTIAL:
			{
				sm6 = LT(1);
				match(PARTIAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(sm6);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_87_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void struct_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  s = null;
		IToken  id = null;
		IToken  sm = null;
		string parms = "";
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case NEW:
				case STRUCT:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				case PARTIAL:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_76_.member(LA(1))))
					{
						struct_modifier();
					}
					else
					{
						goto _loop470_breakloop;
					}
					
				}
_loop470_breakloop:				;
			}    // ( ... )*
			s = LT(1);
			match(STRUCT);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(s);
			}
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(id);
			}
			{
				switch ( LA(1) )
				{
				case LTHAN:
				{
					parms=generic_parameters();
					if (0==inputState.guessing)
					{
						Emit.EmitString (parms);
					}
					break;
				}
				case COLON:
				case LBRACE:
				case WHERE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{
				switch ( LA(1) )
				{
				case COLON:
				{
					struct_interfaces();
					break;
				}
				case LBRACE:
				case WHERE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{
				switch ( LA(1) )
				{
				case WHERE:
				{
					parms=where_constraints();
					if (0==inputState.guessing)
					{
						Emit.EmitString (parms);
					}
					break;
				}
				case LBRACE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			struct_body();
			{
				switch ( LA(1) )
				{
				case SEMI:
				{
					sm = LT(1);
					match(SEMI);
					if (0==inputState.guessing)
					{
						Emit.EmitToken (sm);
					}
					break;
				}
				case EOF:
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case LBRACK:
				case DELEGATE:
				case NEW:
				case VOID:
				case BNOT:
				case CONST:
				case RBRACE:
				case USING:
				case NAMESPACE:
				case ENUM:
				case STRUCT:
				case INTERFACE:
				case CLASS:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				case SEALED:
				case ABSTRACT:
				case STATIC:
				case PARTIAL:
				case READONLY:
				case VOLATILE:
				case VIRTUAL:
				case OVERRIDE:
				case EXTERN:
				case EVENT:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_84_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void interface_modifier() //throws RecognitionException, TokenStreamException
{
		
		IToken  im1 = null;
		IToken  im2 = null;
		IToken  im3 = null;
		IToken  im4 = null;
		IToken  im5 = null;
		IToken  im6 = null;
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case NEW:
			{
				im1 = LT(1);
				match(NEW);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(im1);
				}
				break;
			}
			case PUBLIC:
			{
				im2 = LT(1);
				match(PUBLIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(im2);
				}
				break;
			}
			case PROTECTED:
			{
				im3 = LT(1);
				match(PROTECTED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(im3);
				}
				break;
			}
			case INTERNAL:
			{
				im4 = LT(1);
				match(INTERNAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(im4);
				}
				break;
			}
			case PRIVATE:
			{
				im5 = LT(1);
				match(PRIVATE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(im5);
				}
				break;
			}
			case PARTIAL:
			{
				im6 = LT(1);
				match(PARTIAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(im6);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_88_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void interface_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  i = null;
		IToken  id = null;
		IToken  s = null;
		string parms = "";
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case NEW:
				case INTERFACE:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				case PARTIAL:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_76_.member(LA(1))))
					{
						interface_modifier();
					}
					else
					{
						goto _loop511_breakloop;
					}
					
				}
_loop511_breakloop:				;
			}    // ( ... )*
			i = LT(1);
			match(INTERFACE);
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				
				Emit.EmitToken (i);
				Emit.EmitToken (id);
				
			}
			{
				switch ( LA(1) )
				{
				case LTHAN:
				{
					parms=generic_parameters();
					if (0==inputState.guessing)
					{
						Emit.EmitString (parms);
					}
					break;
				}
				case COLON:
				case LBRACE:
				case WHERE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{
				switch ( LA(1) )
				{
				case COLON:
				{
					interface_base();
					break;
				}
				case LBRACE:
				case WHERE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{
				switch ( LA(1) )
				{
				case WHERE:
				{
					parms=where_constraints();
					if (0==inputState.guessing)
					{
						Emit.EmitString (parms);
					}
					break;
				}
				case LBRACE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			interface_body();
			{
				switch ( LA(1) )
				{
				case SEMI:
				{
					s = LT(1);
					match(SEMI);
					if (0==inputState.guessing)
					{
						Emit.EmitToken (s);
					}
					break;
				}
				case EOF:
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case LBRACK:
				case DELEGATE:
				case NEW:
				case VOID:
				case BNOT:
				case CONST:
				case RBRACE:
				case USING:
				case NAMESPACE:
				case ENUM:
				case STRUCT:
				case INTERFACE:
				case CLASS:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				case SEALED:
				case ABSTRACT:
				case STATIC:
				case PARTIAL:
				case READONLY:
				case VOLATILE:
				case VIRTUAL:
				case OVERRIDE:
				case EXTERN:
				case EVENT:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_84_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void class_modifier() //throws RecognitionException, TokenStreamException
{
		
		IToken  cm1 = null;
		IToken  cm2 = null;
		IToken  cm3 = null;
		IToken  cm4 = null;
		IToken  cm5 = null;
		IToken  cm6 = null;
		IToken  cm7 = null;
		IToken  cm8 = null;
		IToken  cm9 = null;
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case NEW:
			{
				cm1 = LT(1);
				match(NEW);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(cm1);
				}
				break;
			}
			case PUBLIC:
			{
				cm2 = LT(1);
				match(PUBLIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(cm2);
				}
				break;
			}
			case PROTECTED:
			{
				cm3 = LT(1);
				match(PROTECTED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(cm3);
				}
				break;
			}
			case INTERNAL:
			{
				cm4 = LT(1);
				match(INTERNAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(cm4);
				}
				break;
			}
			case PRIVATE:
			{
				cm5 = LT(1);
				match(PRIVATE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(cm5);
				}
				break;
			}
			case SEALED:
			{
				cm6 = LT(1);
				match(SEALED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(cm6);
				}
				break;
			}
			case ABSTRACT:
			{
				cm7 = LT(1);
				match(ABSTRACT);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(cm7);
				}
				break;
			}
			case STATIC:
			{
				cm8 = LT(1);
				match(STATIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(cm8);
				}
				break;
			}
			case PARTIAL:
			{
				cm9 = LT(1);
				match(PARTIAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(cm9);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_89_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void class_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  c = null;
		IToken  id = null;
		IToken  s = null;
		
		string semi = "";
		string parms = "";
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case NEW:
				case CLASS:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				case SEALED:
				case ABSTRACT:
				case STATIC:
				case PARTIAL:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_81_.member(LA(1))))
					{
						class_modifier();
					}
					else
					{
						goto _loop293_breakloop;
					}
					
				}
_loop293_breakloop:				;
			}    // ( ... )*
			c = LT(1);
			match(CLASS);
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				
				Emit.EmitToken (c);
				Emit.EmitToken (id);
				
			}
			{
				switch ( LA(1) )
				{
				case LTHAN:
				{
					parms=generic_parameters();
					if (0==inputState.guessing)
					{
						Emit.EmitString (parms);
					}
					break;
				}
				case COLON:
				case LBRACE:
				case WHERE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{
				switch ( LA(1) )
				{
				case COLON:
				{
					class_base();
					break;
				}
				case LBRACE:
				case WHERE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{
				switch ( LA(1) )
				{
				case WHERE:
				{
					parms=where_constraints();
					if (0==inputState.guessing)
					{
						Emit.EmitString (parms);
					}
					break;
				}
				case LBRACE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			class_body();
			{
				switch ( LA(1) )
				{
				case SEMI:
				{
					s = LT(1);
					match(SEMI);
					if (0==inputState.guessing)
					{
						semi = s.getText();
					}
					break;
				}
				case EOF:
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case LBRACK:
				case DELEGATE:
				case NEW:
				case VOID:
				case BNOT:
				case CONST:
				case RBRACE:
				case USING:
				case NAMESPACE:
				case ENUM:
				case STRUCT:
				case INTERFACE:
				case CLASS:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				case SEALED:
				case ABSTRACT:
				case STATIC:
				case PARTIAL:
				case READONLY:
				case VOLATILE:
				case VIRTUAL:
				case OVERRIDE:
				case EXTERN:
				case EVENT:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			if (0==inputState.guessing)
			{
				
				Emit.EmitString (semi);
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_84_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void delegate_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  d = null;
		IToken  id = null;
		IToken  lp = null;
		IToken  rp = null;
		IToken  s = null;
		
		string rt = "";
		string parms = "";
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case DELEGATE:
				case NEW:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_73_.member(LA(1))))
					{
						delegate_modifier();
					}
					else
					{
						goto _loop586_breakloop;
					}
					
				}
_loop586_breakloop:				;
			}    // ( ... )*
			d = LT(1);
			match(DELEGATE);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(d);
			}
			rt=return_type();
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(id);
			}
			{
				switch ( LA(1) )
				{
				case LTHAN:
				{
					parms=generic_parameters();
					if (0==inputState.guessing)
					{
						Emit.EmitString (parms);
					}
					break;
				}
				case LPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(lp);
			}
			{
				switch ( LA(1) )
				{
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case LBRACK:
				case REF:
				case OUT:
				case PARAMS:
				{
					formal_parameter_list();
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(rp);
			}
			if (0==inputState.guessing)
			{
				Emit.EmitString(" : " + rt);
			}
			{
				switch ( LA(1) )
				{
				case WHERE:
				{
					parms=where_constraints();
					if (0==inputState.guessing)
					{
						Emit.EmitString (parms);
					}
					break;
				}
				case SEMI:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			s = LT(1);
			match(SEMI);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(s);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_84_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void class_base() //throws RecognitionException, TokenStreamException
{
		
		IToken  cl = null;
		IToken  cm = null;
		
		string [] t1 = new string[]{"",""};
		
		
		try {      // for error handling
			cl = LT(1);
			match(COLON);
			if (0==inputState.guessing)
			{
				
				Emit.EmitToken (cl);
				
			}
			t1=type();
			if (0==inputState.guessing)
			{
				
				Emit.EmitString (t1[0]+t1[1]);
				
			}
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA))
					{
						cm = LT(1);
						match(COMMA);
						if (0==inputState.guessing)
						{
							Emit.EmitToken (cm);
						}
						t1=type();
						if (0==inputState.guessing)
						{
							Emit.EmitString (t1[0]+t1[1]);
						}
					}
					else
					{
						goto _loop301_breakloop;
					}
					
				}
_loop301_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_90_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public string  where_constraints() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  w = null;
		IToken  i1 = null;
		IToken  c1 = null;
		IToken  com = null;
		
		return_string = "";
		string[] ty = new string[] {"", ""};
		
		
		try {      // for error handling
			{ // ( ... )+
				int _cnt350=0;
				for (;;)
				{
					if ((LA(1)==WHERE))
					{
						w = LT(1);
						match(WHERE);
						if (0==inputState.guessing)
						{
							return_string += w.getText ();
						}
						i1 = LT(1);
						match(IDENTIFIER);
						c1 = LT(1);
						match(COLON);
						ty=type();
						if (0==inputState.guessing)
						{
							return_string += i1.getText () + c1.getText () + ty [0] + ty[1];
						}
						{    // ( ... )*
							for (;;)
							{
								if ((LA(1)==COMMA))
								{
									com = LT(1);
									match(COMMA);
									ty=type();
									if (0==inputState.guessing)
									{
										return_string += com.getText () + ty [0] + ty[1];
									}
								}
								else
								{
									goto _loop349_breakloop;
								}
								
							}
_loop349_breakloop:							;
						}    // ( ... )*
					}
					else
					{
						if (_cnt350 >= 1) { goto _loop350_breakloop; } else { throw new NoViableAltException(LT(1), getFilename());; }
					}
					
					_cnt350++;
				}
_loop350_breakloop:				;
			}    // ( ... )+
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_91_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public void class_body() //throws RecognitionException, TokenStreamException
{
		
		IToken  lb = null;
		IToken  rb = null;
		
		try {      // for error handling
			lb = LT(1);
			match(LBRACE);
			if (0==inputState.guessing)
			{
				
				Emit.EmitToken (lb);
				
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_92_.member(LA(1))))
					{
						class_member_declaration();
					}
					else
					{
						goto _loop304_breakloop;
					}
					
				}
_loop304_breakloop:				;
			}    // ( ... )*
			rb = LT(1);
			match(RBRACE);
			if (0==inputState.guessing)
			{
				
				Emit.EmitToken (rb);
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_93_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void class_member_declaration() //throws RecognitionException, TokenStreamException
{
		
		
		try {      // for error handling
			bool synPredMatched307 = false;
			if (((tokenSet_94_.member(LA(1))) && (tokenSet_95_.member(LA(2)))))
			{
				int _m307 = mark();
				synPredMatched307 = true;
				inputState.guessing++;
				try {
					{
						constant_declaration();
					}
				}
				catch (RecognitionException)
				{
					synPredMatched307 = false;
				}
				rewind(_m307);
				inputState.guessing--;
			}
			if ( synPredMatched307 )
			{
				constant_declaration();
			}
			else {
				bool synPredMatched309 = false;
				if (((tokenSet_96_.member(LA(1))) && (tokenSet_97_.member(LA(2)))))
				{
					int _m309 = mark();
					synPredMatched309 = true;
					inputState.guessing++;
					try {
						{
							field_declaration();
						}
					}
					catch (RecognitionException)
					{
						synPredMatched309 = false;
					}
					rewind(_m309);
					inputState.guessing--;
				}
				if ( synPredMatched309 )
				{
					field_declaration();
				}
				else {
					bool synPredMatched311 = false;
					if (((tokenSet_98_.member(LA(1))) && (tokenSet_99_.member(LA(2)))))
					{
						int _m311 = mark();
						synPredMatched311 = true;
						inputState.guessing++;
						try {
							{
								method_declaration();
							}
						}
						catch (RecognitionException)
						{
							synPredMatched311 = false;
						}
						rewind(_m311);
						inputState.guessing--;
					}
					if ( synPredMatched311 )
					{
						method_declaration();
					}
					else {
						bool synPredMatched313 = false;
						if (((tokenSet_100_.member(LA(1))) && (tokenSet_101_.member(LA(2)))))
						{
							int _m313 = mark();
							synPredMatched313 = true;
							inputState.guessing++;
							try {
								{
									property_declaration();
								}
							}
							catch (RecognitionException)
							{
								synPredMatched313 = false;
							}
							rewind(_m313);
							inputState.guessing--;
						}
						if ( synPredMatched313 )
						{
							property_declaration();
						}
						else {
							bool synPredMatched315 = false;
							if (((tokenSet_102_.member(LA(1))) && (tokenSet_103_.member(LA(2)))))
							{
								int _m315 = mark();
								synPredMatched315 = true;
								inputState.guessing++;
								try {
									{
										event_declaration();
									}
								}
								catch (RecognitionException)
								{
									synPredMatched315 = false;
								}
								rewind(_m315);
								inputState.guessing--;
							}
							if ( synPredMatched315 )
							{
								event_declaration();
							}
							else {
								bool synPredMatched317 = false;
								if (((tokenSet_100_.member(LA(1))) && (tokenSet_104_.member(LA(2)))))
								{
									int _m317 = mark();
									synPredMatched317 = true;
									inputState.guessing++;
									try {
										{
											indexer_declaration();
										}
									}
									catch (RecognitionException)
									{
										synPredMatched317 = false;
									}
									rewind(_m317);
									inputState.guessing--;
								}
								if ( synPredMatched317 )
								{
									indexer_declaration();
								}
								else {
									bool synPredMatched319 = false;
									if (((tokenSet_105_.member(LA(1))) && (tokenSet_106_.member(LA(2)))))
									{
										int _m319 = mark();
										synPredMatched319 = true;
										inputState.guessing++;
										try {
											{
												operator_declaration();
											}
										}
										catch (RecognitionException)
										{
											synPredMatched319 = false;
										}
										rewind(_m319);
										inputState.guessing--;
									}
									if ( synPredMatched319 )
									{
										operator_declaration();
									}
									else {
										bool synPredMatched321 = false;
										if (((tokenSet_107_.member(LA(1))) && (tokenSet_108_.member(LA(2)))))
										{
											int _m321 = mark();
											synPredMatched321 = true;
											inputState.guessing++;
											try {
												{
													constructor_declaration();
												}
											}
											catch (RecognitionException)
											{
												synPredMatched321 = false;
											}
											rewind(_m321);
											inputState.guessing--;
										}
										if ( synPredMatched321 )
										{
											constructor_declaration();
										}
										else {
											bool synPredMatched323 = false;
											if (((LA(1)==LBRACK||LA(1)==BNOT||LA(1)==EXTERN) && (LA(2)==IDENTIFIER||LA(2)==BNOT||LA(2)==RETURN)))
											{
												int _m323 = mark();
												synPredMatched323 = true;
												inputState.guessing++;
												try {
													{
														destructor_declaration();
													}
												}
												catch (RecognitionException)
												{
													synPredMatched323 = false;
												}
												rewind(_m323);
												inputState.guessing--;
											}
											if ( synPredMatched323 )
											{
												destructor_declaration();
											}
											else {
												bool synPredMatched325 = false;
												if (((LA(1)==LBRACK||LA(1)==STATIC||LA(1)==EXTERN) && (tokenSet_109_.member(LA(2)))))
												{
													int _m325 = mark();
													synPredMatched325 = true;
													inputState.guessing++;
													try {
														{
															static_constructor_declaration();
														}
													}
													catch (RecognitionException)
													{
														synPredMatched325 = false;
													}
													rewind(_m325);
													inputState.guessing--;
												}
												if ( synPredMatched325 )
												{
													static_constructor_declaration();
												}
												else if ((tokenSet_110_.member(LA(1))) && (tokenSet_67_.member(LA(2)))) {
													type_declaration();
												}
												else
												{
													throw new NoViableAltException(LT(1), getFilename());
												}
												}}}}}}}}}
											}
											catch (RecognitionException ex)
											{
												if (0 == inputState.guessing)
												{
													reportError(ex);
													recover(ex,tokenSet_111_);
												}
												else
												{
													throw ex;
												}
											}
										}
										
	public void constant_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  c1 = null;
		IToken  c2 = null;
		IToken  s = null;
		
		string [] t = new string[]{"",""};
		
		
		try {      // for error handling
			if (0==inputState.guessing)
			{
				Emit.BeginBuffer ();
			}
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case NEW:
				case CONST:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_73_.member(LA(1))))
					{
						constant_modifier();
					}
					else
					{
						goto _loop329_breakloop;
					}
					
				}
_loop329_breakloop:				;
			}    // ( ... )*
			if (0==inputState.guessing)
			{
				Emit.EndBuffer ();
			}
			c1 = LT(1);
			match(CONST);
			if (0==inputState.guessing)
			{
				Emit.EmitString (ExtendedToken.getWhitespaces(c1) + "static");
			}
			t=type();
			constant_declarator(false, "" ,t[0]+t[1]);
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA))
					{
						c2 = LT(1);
						match(COMMA);
						constant_declarator(true, Emit.Buffer +
                             ExtendedToken.getWhitespaces(c2) + "static",t[0]+t[1]);
					}
					else
					{
						goto _loop331_breakloop;
					}
					
				}
_loop331_breakloop:				;
			}    // ( ... )*
			s = LT(1);
			match(SEMI);
			if (0==inputState.guessing)
			{
				Emit.EmitString(ExtendedToken.getWhitespaces (s));
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void field_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  c = null;
		IToken  s = null;
		
		string [] t = new string[]{"",""};
		bool is_readonly = false;
		bool ret;
		
		
		try {      // for error handling
			if (0==inputState.guessing)
			{
				Emit.BeginBuffer ();
			}
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case NEW:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				case STATIC:
				case READONLY:
				case VOLATILE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_112_.member(LA(1))))
					{
						ret=field_modifier();
						if (0==inputState.guessing)
						{
							is_readonly = is_readonly || ret;
						}
					}
					else
					{
						goto _loop337_breakloop;
					}
					
				}
_loop337_breakloop:				;
			}    // ( ... )*
			t=type();
			if (0==inputState.guessing)
			{
				
				Emit.EmitString(t[0]);
				if (!is_readonly)
				{
				Emit.EmitString(" mutable ");                
				}   
				{ Emit.EndBuffer ();}
				
			}
			variable_declarator(false,""," " +t[1]);
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA))
					{
						c = LT(1);
						match(COMMA);
						variable_declarator(true,Emit.Buffer + ExtendedToken.getWhitespaces (c) ," " + t[1]);
					}
					else
					{
						goto _loop339_breakloop;
					}
					
				}
_loop339_breakloop:				;
			}    // ( ... )*
			s = LT(1);
			match(SEMI);
			if (0==inputState.guessing)
			{
				Emit.EmitString(ExtendedToken.getWhitespaces (s));
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void method_declaration() //throws RecognitionException, TokenStreamException
{
		
		
		string tp = "";
		
		
		try {      // for error handling
			tp=method_header();
			method_body(tp);
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void property_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  lb = null;
		IToken  rb = null;
		
		string [] t= new string[]{"",""};
		bool mod = false;
		string [] mem_name = null;
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case NEW:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				case SEALED:
				case ABSTRACT:
				case STATIC:
				case VIRTUAL:
				case OVERRIDE:
				case EXTERN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_113_.member(LA(1))))
					{
						property_modifier();
						if (0==inputState.guessing)
						{
							mod = true;
						}
					}
					else
					{
						goto _loop386_breakloop;
					}
					
				}
_loop386_breakloop:				;
			}    // ( ... )*
			t=type();
			if (0==inputState.guessing)
			{
				
				if(!mod)
				Emit.EmitString(t[0]);
				
			}
			mem_name=member_name();
			if (0==inputState.guessing)
			{
				Emit.EmitString (mem_name [0]);
				Emit.EmitString (mem_name [1]);
				
			}
			if (0==inputState.guessing)
			{
				
				if(mod)
				Emit.EmitString(" :" + t[0]+t[1]);
				else
				Emit.EmitString(" : " + t[1]);
				
			}
			if (0==inputState.guessing)
			{
				if (mem_name[2] != null) {
				Emit.EmitString (" implements ");
				Emit.EmitString (mem_name [2]);
				}
				
			}
			lb = LT(1);
			match(LBRACE);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (lb);
			}
			accessor_declarations(t[1]);
			rb = LT(1);
			match(RBRACE);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (rb);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public string  event_declaration() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  e1 = null;
		IToken  s = null;
		IToken  lb1 = null;
		IToken  rb1 = null;
		
		return_string = "";
		string rt = "";
		string [] mem_name = null;
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case NEW:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				case SEALED:
				case ABSTRACT:
				case STATIC:
				case VIRTUAL:
				case OVERRIDE:
				case EXTERN:
				case EVENT:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_113_.member(LA(1))))
					{
						event_modifier();
					}
					else
					{
						goto _loop405_breakloop;
					}
					
				}
_loop405_breakloop:				;
			}    // ( ... )*
			e1 = LT(1);
			match(EVENT);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (e1);
			}
			rt=return_type();
			mem_name=member_name();
			if (0==inputState.guessing)
			{
				Emit.EmitString (mem_name [0]);
				Emit.EmitString (mem_name [1]);
				Emit.EmitString(" : " + rt);
				
			}
			{
				switch ( LA(1) )
				{
				case SEMI:
				{
					{
						s = LT(1);
						match(SEMI);
						if (0==inputState.guessing)
						{
							Emit.EmitToken (s);
						}
					}
					break;
				}
				case LBRACE:
				{
					{
						lb1 = LT(1);
						match(LBRACE);
						if (0==inputState.guessing)
						{
							Emit.EmitToken (lb1);
						}
						event_accessor_declarations();
						rb1 = LT(1);
						match(RBRACE);
						if (0==inputState.guessing)
						{
							Emit.EmitToken (rb1);
						}
					}
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public void indexer_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  lb = null;
		IToken  rb = null;
		
		bool mod = false;
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case NEW:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				case SEALED:
				case ABSTRACT:
				case STATIC:
				case VIRTUAL:
				case OVERRIDE:
				case EXTERN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_113_.member(LA(1))))
					{
						indexer_modifier();
						if (0==inputState.guessing)
						{
							mod = true;
						}
					}
					else
					{
						goto _loop418_breakloop;
					}
					
				}
_loop418_breakloop:				;
			}    // ( ... )*
			indexer_declarator(mod);
			lb = LT(1);
			match(LBRACE);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (lb);
			}
			accessor_declarations("");
			rb = LT(1);
			match(RBRACE);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (rb);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void operator_declaration() //throws RecognitionException, TokenStreamException
{
		
		
		string ty = "";    
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case PUBLIC:
				case STATIC:
				case EXTERN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{ // ( ... )+
				int _cnt426=0;
				for (;;)
				{
					if ((LA(1)==PUBLIC||LA(1)==STATIC||LA(1)==EXTERN))
					{
						operator_modifier();
					}
					else
					{
						if (_cnt426 >= 1) { goto _loop426_breakloop; } else { throw new NoViableAltException(LT(1), getFilename());; }
					}
					
					_cnt426++;
				}
_loop426_breakloop:				;
			}    // ( ... )+
			ty=operator_declarator();
			operator_body(ty);
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void constructor_declaration() //throws RecognitionException, TokenStreamException
{
		
		
		string cd = "";    
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case IDENTIFIER:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				case EXTERN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_114_.member(LA(1))))
					{
						constructor_modifier();
					}
					else
					{
						goto _loop442_breakloop;
					}
					
				}
_loop442_breakloop:				;
			}    // ( ... )*
			cd=constructor_declarator();
			constructor_body(cd);
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void destructor_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  e = null;
		IToken  b = null;
		IToken  id = null;
		IToken  lp = null;
		IToken  rp = null;
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case BNOT:
				case EXTERN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{
				switch ( LA(1) )
				{
				case EXTERN:
				{
					e = LT(1);
					match(EXTERN);
					if (0==inputState.guessing)
					{
						Emit.EmitToken (e);
					}
					break;
				}
				case BNOT:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			b = LT(1);
			match(BNOT);
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				
				Emit.EmitString (ExtendedToken.getWhitespaces(b) + 
				"protected override Finalize ");
				
			}
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (lp);
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (rp);
			}
			destructor_body();
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void static_constructor_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  id = null;
		IToken  lp = null;
		IToken  rp = null;
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case STATIC:
				case EXTERN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			static_constructor_modifiers();
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				Emit.EmitString (ExtendedToken.getWhitespaces(id) + "this");
			}
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (lp);
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (rp);
			}
			static_constructor_body();
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void constant_modifier() //throws RecognitionException, TokenStreamException
{
		
		IToken  cm1 = null;
		IToken  cm2 = null;
		IToken  cm3 = null;
		IToken  cm4 = null;
		IToken  cm5 = null;
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case NEW:
			{
				cm1 = LT(1);
				match(NEW);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm1);
				}
				break;
			}
			case PUBLIC:
			{
				cm2 = LT(1);
				match(PUBLIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm2);
				}
				break;
			}
			case PROTECTED:
			{
				cm3 = LT(1);
				match(PROTECTED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm3);
				}
				break;
			}
			case INTERNAL:
			{
				cm4 = LT(1);
				match(INTERNAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm4);
				}
				break;
			}
			case PRIVATE:
			{
				cm5 = LT(1);
				match(PRIVATE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm5);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_115_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void constant_declarator(
		bool emit_prefix,string prefix,string t
	) //throws RecognitionException, TokenStreamException
{
		
		IToken  id = null;
		IToken  a = null;
		
		string ce = "";
		
		
		try {      // for error handling
			if (0==inputState.guessing)
			{
				
				if(emit_prefix)
				Emit.EmitString (prefix); 
				
			}
			id = LT(1);
			match(IDENTIFIER);
			a = LT(1);
			match(ASSIGN);
			if (0==inputState.guessing)
			{
				
				if(!prefix.EndsWith(" ") && !id.getText().StartsWith(" "))
				Emit.EmitString (" " + id.getText());
				else
				Emit.EmitToken (id);
				Emit.EmitString (" : ");
				Emit.EmitString (t);            
				Emit.EmitToken (a);
				
			}
			ce=constant_expression();
			if (0==inputState.guessing)
			{
				
				Emit.EmitString (ce);
				Emit.EmitString (";");
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_55_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public bool  field_modifier() //throws RecognitionException, TokenStreamException
{
		bool is_readonly;
		
		IToken  fm1 = null;
		IToken  fm2 = null;
		IToken  fm3 = null;
		IToken  fm4 = null;
		IToken  fm5 = null;
		IToken  fm6 = null;
		IToken  fm8 = null;
		
		is_readonly = false;
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case NEW:
			{
				fm1 = LT(1);
				match(NEW);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (fm1);
				}
				break;
			}
			case PUBLIC:
			{
				fm2 = LT(1);
				match(PUBLIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (fm2);
				}
				break;
			}
			case PROTECTED:
			{
				fm3 = LT(1);
				match(PROTECTED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (fm3);
				}
				break;
			}
			case INTERNAL:
			{
				fm4 = LT(1);
				match(INTERNAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (fm4);
				}
				break;
			}
			case PRIVATE:
			{
				fm5 = LT(1);
				match(PRIVATE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (fm5);
				}
				break;
			}
			case STATIC:
			{
				fm6 = LT(1);
				match(STATIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (fm6);
				}
				break;
			}
			case READONLY:
			{
				match(READONLY);
				if (0==inputState.guessing)
				{
					is_readonly = true;
				}
				break;
			}
			case VOLATILE:
			{
				fm8 = LT(1);
				match(VOLATILE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (fm8);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_116_);
			}
			else
			{
				throw ex;
			}
		}
		return is_readonly;
	}
	
	public void variable_declarator(
		bool emit_prefix,string prefix,string t
	) //throws RecognitionException, TokenStreamException
{
		
		IToken  id = null;
		IToken  a = null;
		
		string temp = "";
		
		
		try {      // for error handling
			if (0==inputState.guessing)
			{
				
				if(emit_prefix)
				Emit.EmitString(prefix);
				
			}
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				
				Emit.EmitToken (id);
				Emit.EmitString (" :");
				Emit.EmitString (t);
				
			}
			{
				switch ( LA(1) )
				{
				case ASSIGN:
				{
					a = LT(1);
					match(ASSIGN);
					if (0==inputState.guessing)
					{
						Emit.EmitToken (a);
					}
					temp=variable_initializer();
					if (0==inputState.guessing)
					{
						Emit.EmitString (temp);
					}
					break;
				}
				case COMMA:
				case SEMI:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			if (0==inputState.guessing)
			{
				Emit.EmitString (";");
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_55_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public string  variable_initializer() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case LBRACE:
			{
				return_string=array_initializer();
				break;
			}
			case INTEGER_LITERAL:
			case HEXADECIMAL_INTEGER_LITERAL:
			case REAL_LITERAL:
			case CHARACTER_LITERAL:
			case NULL:
			case TRUE:
			case FALSE:
			case REGULAR_STRING_LITERAL:
			case VERBATIM_STRING_LITERAL:
			case IDENTIFIER:
			case OBJECT:
			case STRING:
			case DECIMAL:
			case CHAR:
			case INT:
			case LONG:
			case SBYTE:
			case BYTE:
			case SHORT:
			case UINT:
			case ULONG:
			case USHORT:
			case FLOAT:
			case DOUBLE:
			case DEC:
			case INC:
			case DELEGATE:
			case LPAREN:
			case NEW:
			case THIS:
			case BASE:
			case TYPEOF:
			case CHECKED:
			case UNCHECKED:
			case PLUS:
			case MINUS:
			case LNOT:
			case BNOT:
			case STAR:
			case DEFAULT:
			{
				return_string=expression();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_117_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public string  method_header() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  lp = null;
		IToken  rp = null;
		
		string [] rt =  new string[]{"",""};
		bool mod = false;
		return_string = "";
		string [] mem_name = null;
		string parms;
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case NEW:
				case VOID:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				case SEALED:
				case ABSTRACT:
				case STATIC:
				case VIRTUAL:
				case OVERRIDE:
				case EXTERN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_113_.member(LA(1))))
					{
						method_modifier();
						if (0==inputState.guessing)
						{
							mod = true;
						}
					}
					else
					{
						goto _loop355_breakloop;
					}
					
				}
_loop355_breakloop:				;
			}    // ( ... )*
			rt=return_type_array();
			if (0==inputState.guessing)
			{
				
				if(!mod)
				Emit.EmitString(rt[0]);
				
			}
			mem_name=member_name();
			if (0==inputState.guessing)
			{
				Emit.EmitString (mem_name [0]);
				Emit.EmitString (mem_name [1]);
				
			}
			{
				switch ( LA(1) )
				{
				case LTHAN:
				{
					parms=generic_parameters();
					if (0==inputState.guessing)
					{
						Emit.EmitString (parms);
					}
					break;
				}
				case LPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (lp);
			}
			{
				switch ( LA(1) )
				{
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case LBRACK:
				case REF:
				case OUT:
				case PARAMS:
				{
					formal_parameter_list();
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				
				Emit.EmitToken (rp);
				Emit.EmitString (" : ");         
				if(mod)
				Emit.EmitString(rt[0]);
				Emit.EmitString (rt[1]);
					    return_string = rt[1];
				
			}
			{
				switch ( LA(1) )
				{
				case WHERE:
				{
					parms=where_constraints();
					if (0==inputState.guessing)
					{
						return_string += parms;
					}
					break;
				}
				case SEMI:
				case LBRACE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			if (0==inputState.guessing)
			{
				if (mem_name[2] != null) {
				Emit.EmitString (" implements ");
				Emit.EmitString (mem_name [2]);
				}
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_91_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public void method_body(
		string tp
	) //throws RecognitionException, TokenStreamException
{
		
		IToken  s = null;
		
		StatementTree t = new StatementTree ();
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case LBRACE:
			{
				t=block();
				if (0==inputState.guessing)
				{
						    
					Emit.EmitString ( t.ToString (tp) );
					
				}
				break;
			}
			case SEMI:
			{
				s = LT(1);
				match(SEMI);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (s);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void method_modifier() //throws RecognitionException, TokenStreamException
{
		
		IToken  cm1 = null;
		IToken  cm2 = null;
		IToken  cm3 = null;
		IToken  cm4 = null;
		IToken  cm5 = null;
		IToken  cm6 = null;
		IToken  cm7 = null;
		IToken  cm8 = null;
		IToken  cm9 = null;
		IToken  cm10 = null;
		IToken  cm11 = null;
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case NEW:
			{
				cm1 = LT(1);
				match(NEW);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm1);
				}
				break;
			}
			case PUBLIC:
			{
				cm2 = LT(1);
				match(PUBLIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm2);
				}
				break;
			}
			case PROTECTED:
			{
				cm3 = LT(1);
				match(PROTECTED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm3);
				}
				break;
			}
			case INTERNAL:
			{
				cm4 = LT(1);
				match(INTERNAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm4);
				}
				break;
			}
			case PRIVATE:
			{
				cm5 = LT(1);
				match(PRIVATE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm5);
				}
				break;
			}
			case STATIC:
			{
				cm6 = LT(1);
				match(STATIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm6);
				}
				break;
			}
			case VIRTUAL:
			{
				cm7 = LT(1);
				match(VIRTUAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm7);
				}
				break;
			}
			case SEALED:
			{
				cm8 = LT(1);
				match(SEALED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm8);
				}
				break;
			}
			case OVERRIDE:
			{
				cm9 = LT(1);
				match(OVERRIDE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm9);
				}
				break;
			}
			case ABSTRACT:
			{
				cm10 = LT(1);
				match(ABSTRACT);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm10);
				}
				break;
			}
			case EXTERN:
			{
				cm11 = LT(1);
				match(EXTERN);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm11);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_118_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public string []  return_type_array() //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		IToken  v = null;
		
		return_strings = new string[] {"",""};
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case IDENTIFIER:
			case OBJECT:
			case STRING:
			case BOOL:
			case DECIMAL:
			case CHAR:
			case INT:
			case LONG:
			case SBYTE:
			case BYTE:
			case SHORT:
			case UINT:
			case ULONG:
			case USHORT:
			case FLOAT:
			case DOUBLE:
			{
				return_strings=type();
				break;
			}
			case VOID:
			{
				v = LT(1);
				match(VOID);
				if (0==inputState.guessing)
				{
					return_strings[0] = ExtendedToken.getWhitespaces (v); 
					return_strings[1] = ExtendedToken.getTextOnly (v);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_3_);
			}
			else
			{
				throw ex;
			}
		}
		return return_strings;
	}
	
	public string []  member_name() //throws RecognitionException, TokenStreamException
{
		string [] return_strings;
		
		
		return_strings = new string [] {"", "", null};
		string [] mn = new string[]{"",""};
		
		
		try {      // for error handling
			mn=maybe_generic_type(true);
			if (0==inputState.guessing)
			{
				
				int dot = mn[1].LastIndexOf ('.');
				if (dot != -1) {
				return_strings [1] = mn[1].Replace ('.', '_');
				return_strings [2] = mn[1];
				}
				else return_strings [1] = mn[1];
				
				return_strings [0] = mn[0];
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_119_);
			}
			else
			{
				throw ex;
			}
		}
		return return_strings;
	}
	
	public void formal_parameter_list() //throws RecognitionException, TokenStreamException
{
		
		IToken  c1 = null;
		IToken  c3 = null;
		IToken  c2 = null;
		
		try {      // for error handling
			bool synPredMatched368 = false;
			if (((tokenSet_120_.member(LA(1))) && (tokenSet_121_.member(LA(2)))))
			{
				int _m368 = mark();
				synPredMatched368 = true;
				inputState.guessing++;
				try {
					{
						fixed_parameter();
						{    // ( ... )*
							for (;;)
							{
								if ((LA(1)==COMMA) && (tokenSet_120_.member(LA(2))))
								{
									match(COMMA);
									fixed_parameter();
								}
								else
								{
									goto _loop367_breakloop;
								}
								
							}
_loop367_breakloop:							;
						}    // ( ... )*
						match(COMMA);
						parameter_array();
					}
				}
				catch (RecognitionException)
				{
					synPredMatched368 = false;
				}
				rewind(_m368);
				inputState.guessing--;
			}
			if ( synPredMatched368 )
			{
				fixed_parameter();
				{    // ( ... )*
					for (;;)
					{
						if ((LA(1)==COMMA) && (tokenSet_120_.member(LA(2))))
						{
							c1 = LT(1);
							match(COMMA);
							if (0==inputState.guessing)
							{
								Emit.EmitToken (c1);
							}
							fixed_parameter();
						}
						else
						{
							goto _loop370_breakloop;
						}
						
					}
_loop370_breakloop:					;
				}    // ( ... )*
				c3 = LT(1);
				match(COMMA);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (c3);
				}
				parameter_array();
			}
			else {
				bool synPredMatched374 = false;
				if (((tokenSet_120_.member(LA(1))) && (tokenSet_121_.member(LA(2)))))
				{
					int _m374 = mark();
					synPredMatched374 = true;
					inputState.guessing++;
					try {
						{
							fixed_parameter();
							{    // ( ... )*
								for (;;)
								{
									if ((LA(1)==COMMA))
									{
										match(COMMA);
										fixed_parameter();
									}
									else
									{
										goto _loop373_breakloop;
									}
									
								}
_loop373_breakloop:								;
							}    // ( ... )*
						}
					}
					catch (RecognitionException)
					{
						synPredMatched374 = false;
					}
					rewind(_m374);
					inputState.guessing--;
				}
				if ( synPredMatched374 )
				{
					fixed_parameter();
					{    // ( ... )*
						for (;;)
						{
							if ((LA(1)==COMMA))
							{
								c2 = LT(1);
								match(COMMA);
								if (0==inputState.guessing)
								{
									Emit.EmitToken (c2);
								}
								fixed_parameter();
							}
							else
							{
								goto _loop376_breakloop;
							}
							
						}
_loop376_breakloop:						;
					}    // ( ... )*
				}
				else if ((LA(1)==LBRACK||LA(1)==PARAMS) && (tokenSet_122_.member(LA(2)))) {
					parameter_array();
				}
				else
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
			}
			catch (RecognitionException ex)
			{
				if (0 == inputState.guessing)
				{
					reportError(ex);
					recover(ex,tokenSet_123_);
				}
				else
				{
					throw ex;
				}
			}
		}
		
	public string  return_type() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  v = null;
		
		return_string = "";
		string [] temp = new string[] {"",""};
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case IDENTIFIER:
			case OBJECT:
			case STRING:
			case BOOL:
			case DECIMAL:
			case CHAR:
			case INT:
			case LONG:
			case SBYTE:
			case BYTE:
			case SHORT:
			case UINT:
			case ULONG:
			case USHORT:
			case FLOAT:
			case DOUBLE:
			{
				temp=type();
				if (0==inputState.guessing)
				{
					return_string = temp[0] + temp[1];
				}
				break;
			}
			case VOID:
			{
				v = LT(1);
				match(VOID);
				if (0==inputState.guessing)
				{
					return_string = v.getText();
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_3_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public void fixed_parameter() //throws RecognitionException, TokenStreamException
{
		
		IToken  id = null;
		
		string p = "";
		string [] t = new string[]{"",""};
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case REF:
				case OUT:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{
				switch ( LA(1) )
				{
				case REF:
				case OUT:
				{
					p=parameter_modifier();
					break;
				}
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			t=type();
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				
					    if ( Options.NemerlishFunctionParameters )
						Emit.EmitString ( id.getText () + " : " + p + t[0]+t[1] );
					    else
						Emit.EmitString ( "mutable " + id.getText () + " : " + p + t[0]+t[1] );
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_124_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void parameter_array() //throws RecognitionException, TokenStreamException
{
		
		IToken  p = null;
		IToken  i = null;
		
		string[] ty = null;
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case PARAMS:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			p = LT(1);
			match(PARAMS);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (p);
			}
			ty=array_type();
			i = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (i);
			}
			if (0==inputState.guessing)
			{
				Emit.EmitString (" :" + ty [0] + ty [1]);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_123_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void property_modifier() //throws RecognitionException, TokenStreamException
{
		
		IToken  cm1 = null;
		IToken  cm2 = null;
		IToken  cm3 = null;
		IToken  cm4 = null;
		IToken  cm5 = null;
		IToken  cm6 = null;
		IToken  cm7 = null;
		IToken  cm8 = null;
		IToken  cm9 = null;
		IToken  cm10 = null;
		IToken  cm11 = null;
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case NEW:
			{
				cm1 = LT(1);
				match(NEW);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm1);
				}
				break;
			}
			case PUBLIC:
			{
				cm2 = LT(1);
				match(PUBLIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm2);
				}
				break;
			}
			case PROTECTED:
			{
				cm3 = LT(1);
				match(PROTECTED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm3);
				}
				break;
			}
			case INTERNAL:
			{
				cm4 = LT(1);
				match(INTERNAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm4);
				}
				break;
			}
			case PRIVATE:
			{
				cm5 = LT(1);
				match(PRIVATE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm5);
				}
				break;
			}
			case STATIC:
			{
				cm6 = LT(1);
				match(STATIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm6);
				}
				break;
			}
			case VIRTUAL:
			{
				cm7 = LT(1);
				match(VIRTUAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm7);
				}
				break;
			}
			case SEALED:
			{
				cm8 = LT(1);
				match(SEALED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm8);
				}
				break;
			}
			case OVERRIDE:
			{
				cm9 = LT(1);
				match(OVERRIDE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm9);
				}
				break;
			}
			case ABSTRACT:
			{
				cm10 = LT(1);
				match(ABSTRACT);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm10);
				}
				break;
			}
			case EXTERN:
			{
				cm11 = LT(1);
				match(EXTERN);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm11);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_125_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void accessor_declarations(
		string tp
	) //throws RecognitionException, TokenStreamException
{
		
		
		try {      // for error handling
			bool synPredMatched390 = false;
			if (((tokenSet_126_.member(LA(1))) && (tokenSet_127_.member(LA(2)))))
			{
				int _m390 = mark();
				synPredMatched390 = true;
				inputState.guessing++;
				try {
					{
						get_accessor_declaration(tp);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched390 = false;
				}
				rewind(_m390);
				inputState.guessing--;
			}
			if ( synPredMatched390 )
			{
				get_accessor_declaration(tp);
				{
					switch ( LA(1) )
					{
					case IDENTIFIER:
					case LBRACK:
					case NEW:
					case PUBLIC:
					case PROTECTED:
					case INTERNAL:
					case PRIVATE:
					{
						set_accessor_declaration(tp);
						break;
					}
					case RBRACE:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					 }
				}
			}
			else if ((tokenSet_126_.member(LA(1))) && (tokenSet_127_.member(LA(2)))) {
				set_accessor_declaration(tp);
				{
					switch ( LA(1) )
					{
					case IDENTIFIER:
					case LBRACK:
					case NEW:
					case PUBLIC:
					case PROTECTED:
					case INTERNAL:
					case PRIVATE:
					{
						get_accessor_declaration(tp);
						break;
					}
					case RBRACE:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					 }
				}
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_128_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void get_accessor_declaration(
		string tp
	) //throws RecognitionException, TokenStreamException
{
		
		IToken  g = null;
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case IDENTIFIER:
				case NEW:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_73_.member(LA(1))))
					{
						constant_modifier();
					}
					else
					{
						goto _loop396_breakloop;
					}
					
				}
_loop396_breakloop:				;
			}    // ( ... )*
			g = LT(1);
			match(IDENTIFIER);
			if (!(ExtendedToken.getTextOnly(g)=="get" ))
			  throw new SemanticException("ExtendedToken.getTextOnly(g)==\"get\" ");
			if (0==inputState.guessing)
			{
				Emit.EmitToken(g);
			}
			accessor_body(tp);
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_129_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void set_accessor_declaration(
		string tp
	) //throws RecognitionException, TokenStreamException
{
		
		IToken  s = null;
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case IDENTIFIER:
				case NEW:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_73_.member(LA(1))))
					{
						constant_modifier();
					}
					else
					{
						goto _loop400_breakloop;
					}
					
				}
_loop400_breakloop:				;
			}    // ( ... )*
			s = LT(1);
			match(IDENTIFIER);
			if (!(ExtendedToken.getTextOnly(s)=="set" ))
			  throw new SemanticException("ExtendedToken.getTextOnly(s)==\"set\" ");
			if (0==inputState.guessing)
			{
				Emit.EmitToken(s);
			}
			accessor_body(tp);
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_129_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void accessor_body(
		string tp
	) //throws RecognitionException, TokenStreamException
{
		
		IToken  s = null;
		
		StatementTree t = new StatementTree ();
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case LBRACE:
			{
				t=block();
				if (0==inputState.guessing)
				{
					
					Emit.EmitString ( t.ToString (tp) );
					
				}
				break;
			}
			case SEMI:
			{
				s = LT(1);
				match(SEMI);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(s);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_129_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public string  event_modifier() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  cm1 = null;
		IToken  cm2 = null;
		IToken  cm3 = null;
		IToken  cm4 = null;
		IToken  cm5 = null;
		IToken  cm6 = null;
		IToken  cm7 = null;
		IToken  cm8 = null;
		IToken  cm9 = null;
		IToken  cm10 = null;
		IToken  cm11 = null;
		
		return_string = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case NEW:
			{
				cm1 = LT(1);
				match(NEW);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm1);
				}
				break;
			}
			case PUBLIC:
			{
				cm2 = LT(1);
				match(PUBLIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm2);
				}
				break;
			}
			case PROTECTED:
			{
				cm3 = LT(1);
				match(PROTECTED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm3);
				}
				break;
			}
			case INTERNAL:
			{
				cm4 = LT(1);
				match(INTERNAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm4);
				}
				break;
			}
			case PRIVATE:
			{
				cm5 = LT(1);
				match(PRIVATE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm5);
				}
				break;
			}
			case STATIC:
			{
				cm6 = LT(1);
				match(STATIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm6);
				}
				break;
			}
			case VIRTUAL:
			{
				cm7 = LT(1);
				match(VIRTUAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm7);
				}
				break;
			}
			case SEALED:
			{
				cm8 = LT(1);
				match(SEALED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm8);
				}
				break;
			}
			case OVERRIDE:
			{
				cm9 = LT(1);
				match(OVERRIDE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm9);
				}
				break;
			}
			case ABSTRACT:
			{
				cm10 = LT(1);
				match(ABSTRACT);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm10);
				}
				break;
			}
			case EXTERN:
			{
				cm11 = LT(1);
				match(EXTERN);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm11);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_130_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public void event_accessor_declarations() //throws RecognitionException, TokenStreamException
{
		
		
		string kind_of_first = "";
		
		
		try {      // for error handling
			kind_of_first=event_accessor_declaration("");
			event_accessor_declaration(kind_of_first);
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_128_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public string  event_accessor_declaration(
		string kind
	) //throws RecognitionException, TokenStreamException
{
		string result_kind;
		
		IToken  id = null;
		
		result_kind = "";
		StatementTree b = new StatementTree();
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case IDENTIFIER:
				case NEW:
				case PUBLIC:
				case PROTECTED:
				case INTERNAL:
				case PRIVATE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_73_.member(LA(1))))
					{
						constant_modifier();
					}
					else
					{
						goto _loop414_breakloop;
					}
					
				}
_loop414_breakloop:				;
			}    // ( ... )*
			id = LT(1);
			match(IDENTIFIER);
			if (!(id.getText()!=kind))
			  throw new SemanticException("id.getText()!=kind");
			if (0==inputState.guessing)
			{
				result_kind = id.getText (); Emit.EmitToken (id);
			}
			b=block();
			if (0==inputState.guessing)
			{
				Emit.EmitString ( b.ToString () );
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_129_);
			}
			else
			{
				throw ex;
			}
		}
		return result_kind;
	}
	
	public void indexer_modifier() //throws RecognitionException, TokenStreamException
{
		
		IToken  cm1 = null;
		IToken  cm2 = null;
		IToken  cm3 = null;
		IToken  cm4 = null;
		IToken  cm5 = null;
		IToken  cm6 = null;
		IToken  cm7 = null;
		IToken  cm8 = null;
		IToken  cm9 = null;
		IToken  cm10 = null;
		IToken  cm11 = null;
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case NEW:
			{
				cm1 = LT(1);
				match(NEW);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm1);
				}
				break;
			}
			case PUBLIC:
			{
				cm2 = LT(1);
				match(PUBLIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm2);
				}
				break;
			}
			case PROTECTED:
			{
				cm3 = LT(1);
				match(PROTECTED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm3);
				}
				break;
			}
			case INTERNAL:
			{
				cm4 = LT(1);
				match(INTERNAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm4);
				}
				break;
			}
			case PRIVATE:
			{
				cm5 = LT(1);
				match(PRIVATE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm5);
				}
				break;
			}
			case STATIC:
			{
				cm6 = LT(1);
				match(STATIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm6);
				}
				break;
			}
			case VIRTUAL:
			{
				cm7 = LT(1);
				match(VIRTUAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm7);
				}
				break;
			}
			case SEALED:
			{
				cm8 = LT(1);
				match(SEALED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm8);
				}
				break;
			}
			case OVERRIDE:
			{
				cm9 = LT(1);
				match(OVERRIDE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm9);
				}
				break;
			}
			case ABSTRACT:
			{
				cm10 = LT(1);
				match(ABSTRACT);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm10);
				}
				break;
			}
			case EXTERN:
			{
				cm11 = LT(1);
				match(EXTERN);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (cm11);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_125_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void indexer_declarator(
		bool mod
	) //throws RecognitionException, TokenStreamException
{
		
		IToken  t1 = null;
		IToken  lb1 = null;
		IToken  rb1 = null;
		IToken  d = null;
		IToken  t2 = null;
		IToken  lb2 = null;
		IToken  rb2 = null;
		
		string [] tp = new string[] {"",""};
		string [] tn = null;
		
		
		try {      // for error handling
			bool synPredMatched422 = false;
			if (((tokenSet_3_.member(LA(1))) && (tokenSet_131_.member(LA(2)))))
			{
				int _m422 = mark();
				synPredMatched422 = true;
				inputState.guessing++;
				try {
					{
						type();
						match(THIS);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched422 = false;
				}
				rewind(_m422);
				inputState.guessing--;
			}
			if ( synPredMatched422 )
			{
				tp=type();
				if (0==inputState.guessing)
				{
					
					if(!mod)
					Emit.EmitString(tp[0]);
					
				}
				t1 = LT(1);
				match(THIS);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getWhitespaces(t1) + "Item");
				}
				lb1 = LT(1);
				match(LBRACK);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (lb1);
				}
				formal_parameter_list();
				rb1 = LT(1);
				match(RBRACK);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (rb1);
				}
				if (0==inputState.guessing)
				{
					
					if(mod)
					Emit.EmitString (" :" + tp[0] + tp[1]);
					else
					Emit.EmitString (" : " + tp[1]);
					
				}
			}
			else if ((tokenSet_3_.member(LA(1))) && (tokenSet_47_.member(LA(2)))) {
				tp=type();
				if (0==inputState.guessing)
				{
					
					if(!mod)
					Emit.EmitString(tp[0]);
					
				}
				tn=maybe_generic_type(true);
				d = LT(1);
				match(DOT);
				t2 = LT(1);
				match(THIS);
				if (0==inputState.guessing)
				{
					
					Emit.EmitString (ExtendedToken.getWhitespaces(t2));
					Emit.EmitString (tn[1].Replace ('.', '_').Replace (' ', '_').
					Replace ('[', '_').Replace (']', '_'));
					Emit.EmitString ("Item");
					
				}
				lb2 = LT(1);
				match(LBRACK);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (lb2);
				}
				formal_parameter_list();
				rb2 = LT(1);
				match(RBRACK);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (rb2);
				}
				if (0==inputState.guessing)
				{
					
					if(mod)
					Emit.EmitString (" :" + tp[0] + tp[1]);
					else
					Emit.EmitString (" :" + tp[1]);
					
				}
				if (0==inputState.guessing)
				{
					Emit.EmitString (" implements ");
					Emit.EmitString (tn [0] + tn [1] + d.getText () + "Item");
				}
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_22_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void operator_modifier() //throws RecognitionException, TokenStreamException
{
		
		IToken  om1 = null;
		IToken  om2 = null;
		IToken  om3 = null;
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case PUBLIC:
			{
				om1 = LT(1);
				match(PUBLIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (om1);
				}
				break;
			}
			case STATIC:
			{
				om2 = LT(1);
				match(STATIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (om2);
				}
				break;
			}
			case EXTERN:
			{
				om3 = LT(1);
				match(EXTERN);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (om3);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_132_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public string  operator_declarator() //throws RecognitionException, TokenStreamException
{
		string ty;
		
		
		ty = "";
		
		
		try {      // for error handling
			bool synPredMatched430 = false;
			if (((tokenSet_3_.member(LA(1))) && (tokenSet_133_.member(LA(2)))))
			{
				int _m430 = mark();
				synPredMatched430 = true;
				inputState.guessing++;
				try {
					{
						type();
						match(OPERATOR);
						overloadable_unary_operator();
						match(LPAREN);
						type();
						match(IDENTIFIER);
						match(RPAREN);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched430 = false;
				}
				rewind(_m430);
				inputState.guessing--;
			}
			if ( synPredMatched430 )
			{
				ty=unary_operator_declarator();
			}
			else if ((tokenSet_3_.member(LA(1))) && (tokenSet_133_.member(LA(2)))) {
				ty=binary_operator_declarator();
			}
			else if ((LA(1)==IMPLICIT||LA(1)==EXPLICIT)) {
				ty=conversion_operator_declarator();
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_91_);
			}
			else
			{
				throw ex;
			}
		}
		return ty;
	}
	
	public void operator_body(
		string ty
	) //throws RecognitionException, TokenStreamException
{
		
		IToken  s = null;
		
		StatementTree t = new StatementTree();
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case LBRACE:
			{
				t=block();
				if (0==inputState.guessing)
				{
					Emit.EmitString ( t.ToString (ty) );
				}
				break;
			}
			case SEMI:
			{
				s = LT(1);
				match(SEMI);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (s);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void overloadable_unary_operator() //throws RecognitionException, TokenStreamException
{
		
		IToken  oun1 = null;
		IToken  oun2 = null;
		IToken  oun3 = null;
		IToken  oun5 = null;
		IToken  oun6 = null;
		IToken  oun7 = null;
		IToken  oun8 = null;
		IToken  oun9 = null;
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case PLUS:
			{
				oun1 = LT(1);
				match(PLUS);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (oun1));
				}
				break;
			}
			case MINUS:
			{
				oun2 = LT(1);
				match(MINUS);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (oun2));
				}
				break;
			}
			case LNOT:
			{
				oun3 = LT(1);
				match(LNOT);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (oun3));
				}
				break;
			}
			case INC:
			{
				oun5 = LT(1);
				match(INC);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (oun5));
				}
				break;
			}
			case DEC:
			{
				oun6 = LT(1);
				match(DEC);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (oun6));
				}
				break;
			}
			case TRUE:
			{
				oun7 = LT(1);
				match(TRUE);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (oun7));
				}
				break;
			}
			case FALSE:
			{
				oun8 = LT(1);
				match(FALSE);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (oun8));
				}
				break;
			}
			case BNOT:
			{
				oun9 = LT(1);
				match(BNOT);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (oun9));
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_134_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public string  unary_operator_declarator() //throws RecognitionException, TokenStreamException
{
		string tp;
		
		IToken  op = null;
		IToken  lp = null;
		IToken  id = null;
		IToken  rp = null;
		
		string [] tp1 = new string []{"",""};
		string [] tp2 = new string []{"",""};
		tp = "";
		
		
		try {      // for error handling
			tp1=type();
			if (0==inputState.guessing)
			{
				tp = tp1[1];
			}
			op = LT(1);
			match(OPERATOR);
			if (0==inputState.guessing)
			{
				Emit.EmitString (ExtendedToken.getWhitespaces (op) + "@");
			}
			overloadable_unary_operator();
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (lp);
			}
			tp2=type();
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (id);
			}
			if (0==inputState.guessing)
			{
				Emit.EmitString (" : " + tp2[0] + tp2[1]);
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (rp);
			}
			if (0==inputState.guessing)
			{
				Emit.EmitString (" : " + tp1[0] + tp1[1]);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_91_);
			}
			else
			{
				throw ex;
			}
		}
		return tp;
	}
	
	public string  binary_operator_declarator() //throws RecognitionException, TokenStreamException
{
		string tp;
		
		IToken  op = null;
		IToken  lp = null;
		IToken  id1 = null;
		IToken  cm = null;
		IToken  id2 = null;
		IToken  rp = null;
		
		string [] tp1 = new string []{"",""};
		string [] tp2 = new string []{"",""};
		string [] tp3 = new string []{"",""};
		tp = "";
		
		
		try {      // for error handling
			tp1=type();
			if (0==inputState.guessing)
			{
				tp = tp1[1];
			}
			op = LT(1);
			match(OPERATOR);
			if (0==inputState.guessing)
			{
				Emit.EmitString (ExtendedToken.getWhitespaces (op) + "@");
			}
			overloadable_binary_operator();
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (lp);
			}
			tp2=type();
			id1 = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (id1);
			}
			if (0==inputState.guessing)
			{
				Emit.EmitString (" : " + tp2[0] + tp2[1]);
			}
			cm = LT(1);
			match(COMMA);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (cm);
			}
			tp3=type();
			id2 = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (id2);
			}
			if (0==inputState.guessing)
			{
				Emit.EmitString (" : " + tp3[0] + tp3[1]);
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (rp);
			}
			if (0==inputState.guessing)
			{
				Emit.EmitString (" : " + tp1[0] + tp1[1]);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_91_);
			}
			else
			{
				throw ex;
			}
		}
		return tp;
	}
	
	public string  conversion_operator_declarator() //throws RecognitionException, TokenStreamException
{
		string tp;
		
		IToken  i = null;
		IToken  lp = null;
		IToken  id = null;
		IToken  rp = null;
		IToken  e = null;
		IToken  lp1 = null;
		IToken  id1 = null;
		IToken  rp1 = null;
		
		string [] ty = null;
		string [] pty = null;
		tp = "";
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case IMPLICIT:
			{
				i = LT(1);
				match(IMPLICIT);
				match(OPERATOR);
				ty=type();
				if (0==inputState.guessing)
				{
					tp = ty[1];
				}
				lp = LT(1);
				match(LPAREN);
				pty=type();
				id = LT(1);
				match(IDENTIFIER);
				rp = LT(1);
				match(RPAREN);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getWhitespaces (i));
					Emit.EmitString ("@:");
					Emit.EmitToken (lp);
					Emit.EmitToken (id);
					Emit.EmitString (" : " + pty [0] + pty [1]);
					Emit.EmitToken (rp);
					Emit.EmitString (" : " + ty [0] + ty [1]);
					
				}
				break;
			}
			case EXPLICIT:
			{
				e = LT(1);
				match(EXPLICIT);
				match(OPERATOR);
				ty=type();
				lp1 = LT(1);
				match(LPAREN);
				pty=type();
				id1 = LT(1);
				match(IDENTIFIER);
				rp1 = LT(1);
				match(RPAREN);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getWhitespaces (e));
					Emit.EmitString ("@:>");
					Emit.EmitToken (lp1);
					Emit.EmitToken (id1);
					Emit.EmitString (" : " + pty [0] + pty [1]);
					Emit.EmitToken (rp1);
					Emit.EmitString (" : " + ty [0] + ty [1]);
					
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_91_);
			}
			else
			{
				throw ex;
			}
		}
		return tp;
	}
	
	public void overloadable_binary_operator() //throws RecognitionException, TokenStreamException
{
		
		IToken  obn1 = null;
		IToken  obn2 = null;
		IToken  obn3 = null;
		IToken  obn4 = null;
		IToken  obn5 = null;
		IToken  obn6 = null;
		IToken  obn7 = null;
		IToken  obn8 = null;
		IToken  obn9 = null;
		IToken  obn10 = null;
		IToken  obn11 = null;
		IToken  obn12 = null;
		IToken  obn13 = null;
		IToken  obn14 = null;
		IToken  obn15 = null;
		IToken  obn16 = null;
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case PLUS:
			{
				obn1 = LT(1);
				match(PLUS);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn1));
				}
				break;
			}
			case MINUS:
			{
				obn2 = LT(1);
				match(MINUS);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn2));
				}
				break;
			}
			case STAR:
			{
				obn3 = LT(1);
				match(STAR);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn3));
				}
				break;
			}
			case DIV:
			{
				obn4 = LT(1);
				match(DIV);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn4));
				}
				break;
			}
			case MOD:
			{
				obn5 = LT(1);
				match(MOD);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn5));
				}
				break;
			}
			case BAND:
			{
				obn6 = LT(1);
				match(BAND);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn6));
				}
				break;
			}
			case BOR:
			{
				obn7 = LT(1);
				match(BOR);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn7));
				}
				break;
			}
			case BXOR:
			{
				obn8 = LT(1);
				match(BXOR);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn8));
				}
				break;
			}
			case SL:
			{
				obn9 = LT(1);
				match(SL);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn9));
				}
				break;
			}
			case SR:
			{
				obn10 = LT(1);
				match(SR);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn10));
				}
				break;
			}
			case EQUAL:
			{
				obn11 = LT(1);
				match(EQUAL);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn11));
				}
				break;
			}
			case NOT_EQUAL:
			{
				obn12 = LT(1);
				match(NOT_EQUAL);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn12));
				}
				break;
			}
			case GTHAN:
			{
				obn13 = LT(1);
				match(GTHAN);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn13));
				}
				break;
			}
			case LTHAN:
			{
				obn14 = LT(1);
				match(LTHAN);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn14));
				}
				break;
			}
			case LE:
			{
				obn15 = LT(1);
				match(LE);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn15));
				}
				break;
			}
			case GE:
			{
				obn16 = LT(1);
				match(GE);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getTextOnly (obn16));
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_134_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void constructor_modifier() //throws RecognitionException, TokenStreamException
{
		
		IToken  cm1 = null;
		IToken  cm2 = null;
		IToken  cm3 = null;
		IToken  cm4 = null;
		IToken  cm5 = null;
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case PUBLIC:
			{
				cm1 = LT(1);
				match(PUBLIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(cm1);
				}
				break;
			}
			case PROTECTED:
			{
				cm2 = LT(1);
				match(PROTECTED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(cm2);
				}
				break;
			}
			case INTERNAL:
			{
				cm3 = LT(1);
				match(INTERNAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(cm3);
				}
				break;
			}
			case PRIVATE:
			{
				cm4 = LT(1);
				match(PRIVATE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(cm4);
				}
				break;
			}
			case EXTERN:
			{
				cm5 = LT(1);
				match(EXTERN);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(cm5);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_135_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public string  constructor_declarator() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  id = null;
		IToken  lp = null;
		IToken  rp = null;
		
		return_string ="";
		
		
		try {      // for error handling
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				
				Emit.EmitString ( ExtendedToken.getWhitespaces (id) + "this");           
				
			}
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(lp);
			}
			{
				switch ( LA(1) )
				{
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case LBRACK:
				case REF:
				case OUT:
				case PARAMS:
				{
					formal_parameter_list();
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(rp);
			}
			{
				switch ( LA(1) )
				{
				case COLON:
				{
					return_string=constructor_initializer();
					break;
				}
				case SEMI:
				case LBRACE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_91_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public void constructor_body(
		string ctor_initializer
	) //throws RecognitionException, TokenStreamException
{
		
		IToken  lb = null;
		IToken  rb = null;
		IToken  s = null;
		
		StatementTree t = new StatementTree();
		LinkedList<StatementTree> a = new LinkedList<StatementTree> ();
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case LBRACE:
			{
				lb = LT(1);
				match(LBRACE);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(lb));
				}
				if (0==inputState.guessing)
				{
					
					if(ctor_initializer != "")
					a.Add (new StatementTree(ctor_initializer + ";"));
					
				}
				{    // ( ... )*
					for (;;)
					{
						if ((tokenSet_23_.member(LA(1))))
						{
							t=statement();
							if (0==inputState.guessing)
							{
								a.Add (t);
							}
						}
						else
						{
							goto _loop454_breakloop;
						}
						
					}
_loop454_breakloop:					;
				}    // ( ... )*
				rb = LT(1);
				match(RBRACE);
				if (0==inputState.guessing)
				{
					a.Add (new StatementTree(rb));
				}
				if (0==inputState.guessing)
				{
					
					t = new StatementTree("BLOCK",a);
					Emit.EmitString( t.ToString ("void"));
					
				}
				break;
			}
			case SEMI:
			{
				s = LT(1);
				match(SEMI);
				if (0==inputState.guessing)
				{
					
					if(ctor_initializer != "")
					Emit.EmitString( ExtendedToken.getWhitespaces (s) + "{ " + ctor_initializer + " }");
					else
					Emit.EmitToken (s);
					
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public string  constructor_initializer() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  c1 = null;
		IToken  b = null;
		IToken  lp1 = null;
		IToken  rp1 = null;
		IToken  c2 = null;
		IToken  t = null;
		IToken  lp2 = null;
		IToken  rp2 = null;
		
		string al = "";
		return_string ="";
		
		
		try {      // for error handling
			bool synPredMatched449 = false;
			if (((LA(1)==COLON) && (LA(2)==BASE)))
			{
				int _m449 = mark();
				synPredMatched449 = true;
				inputState.guessing++;
				try {
					{
						match(COLON);
						match(BASE);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched449 = false;
				}
				rewind(_m449);
				inputState.guessing--;
			}
			if ( synPredMatched449 )
			{
				c1 = LT(1);
				match(COLON);
				b = LT(1);
				match(BASE);
				lp1 = LT(1);
				match(LPAREN);
				{
					switch ( LA(1) )
					{
					case INTEGER_LITERAL:
					case HEXADECIMAL_INTEGER_LITERAL:
					case REAL_LITERAL:
					case CHARACTER_LITERAL:
					case NULL:
					case TRUE:
					case FALSE:
					case REGULAR_STRING_LITERAL:
					case VERBATIM_STRING_LITERAL:
					case IDENTIFIER:
					case OBJECT:
					case STRING:
					case DECIMAL:
					case CHAR:
					case INT:
					case LONG:
					case SBYTE:
					case BYTE:
					case SHORT:
					case UINT:
					case ULONG:
					case USHORT:
					case FLOAT:
					case DOUBLE:
					case REF:
					case OUT:
					case DEC:
					case INC:
					case DELEGATE:
					case LPAREN:
					case NEW:
					case THIS:
					case BASE:
					case TYPEOF:
					case CHECKED:
					case UNCHECKED:
					case PLUS:
					case MINUS:
					case LNOT:
					case BNOT:
					case STAR:
					case DEFAULT:
					{
						al=argument_list();
						break;
					}
					case RPAREN:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					 }
				}
				rp1 = LT(1);
				match(RPAREN);
				if (0==inputState.guessing)
				{
					
					return_string = ExtendedToken.getWhitespaces (c1) + b.getText () + lp1.getText () + al + rp1.getText();
					
				}
			}
			else if ((LA(1)==COLON) && (LA(2)==THIS)) {
				c2 = LT(1);
				match(COLON);
				t = LT(1);
				match(THIS);
				lp2 = LT(1);
				match(LPAREN);
				{
					switch ( LA(1) )
					{
					case INTEGER_LITERAL:
					case HEXADECIMAL_INTEGER_LITERAL:
					case REAL_LITERAL:
					case CHARACTER_LITERAL:
					case NULL:
					case TRUE:
					case FALSE:
					case REGULAR_STRING_LITERAL:
					case VERBATIM_STRING_LITERAL:
					case IDENTIFIER:
					case OBJECT:
					case STRING:
					case DECIMAL:
					case CHAR:
					case INT:
					case LONG:
					case SBYTE:
					case BYTE:
					case SHORT:
					case UINT:
					case ULONG:
					case USHORT:
					case FLOAT:
					case DOUBLE:
					case REF:
					case OUT:
					case DEC:
					case INC:
					case DELEGATE:
					case LPAREN:
					case NEW:
					case THIS:
					case BASE:
					case TYPEOF:
					case CHECKED:
					case UNCHECKED:
					case PLUS:
					case MINUS:
					case LNOT:
					case BNOT:
					case STAR:
					case DEFAULT:
					{
						al=argument_list();
						break;
					}
					case RPAREN:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					 }
				}
				rp2 = LT(1);
				match(RPAREN);
				if (0==inputState.guessing)
				{
					
					return_string = ExtendedToken.getWhitespaces (c2) + t.getText () + lp2.getText () + al + rp2.getText();
					
				}
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_91_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public void static_constructor_modifiers() //throws RecognitionException, TokenStreamException
{
		
		IToken  s1 = null;
		IToken  e1 = null;
		IToken  e2 = null;
		IToken  s2 = null;
		
		try {      // for error handling
			bool synPredMatched459 = false;
			if (((LA(1)==STATIC) && (LA(2)==IDENTIFIER||LA(2)==EXTERN)))
			{
				int _m459 = mark();
				synPredMatched459 = true;
				inputState.guessing++;
				try {
					{
						match(STATIC);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched459 = false;
				}
				rewind(_m459);
				inputState.guessing--;
			}
			if ( synPredMatched459 )
			{
				s1 = LT(1);
				match(STATIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (s1);
				}
				{
					switch ( LA(1) )
					{
					case EXTERN:
					{
						e1 = LT(1);
						match(EXTERN);
						if (0==inputState.guessing)
						{
							Emit.EmitToken (e1);
						}
						break;
					}
					case IDENTIFIER:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					 }
				}
			}
			else if ((LA(1)==STATIC||LA(1)==EXTERN) && (LA(2)==IDENTIFIER||LA(2)==STATIC)) {
				{
					switch ( LA(1) )
					{
					case EXTERN:
					{
						e2 = LT(1);
						match(EXTERN);
						if (0==inputState.guessing)
						{
							Emit.EmitToken (e2);
						}
						break;
					}
					case STATIC:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					 }
				}
				s2 = LT(1);
				match(STATIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (s2);
				}
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_136_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void static_constructor_body() //throws RecognitionException, TokenStreamException
{
		
		IToken  s = null;
		
		StatementTree t = new StatementTree();
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case LBRACE:
			{
				t=block();
				if (0==inputState.guessing)
				{
					Emit.EmitString ( t.ToString ("void") );
				}
				break;
			}
			case SEMI:
			{
				s = LT(1);
				match(SEMI);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (s);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void destructor_body() //throws RecognitionException, TokenStreamException
{
		
		IToken  s = null;
		
		StatementTree t = new StatementTree();
		
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case LBRACE:
			{
				t=block();
				if (0==inputState.guessing)
				{
					
					Emit.EmitString ( " : void " );
					Emit.EmitString ( t.ToString () );
					
				}
				break;
			}
			case SEMI:
			{
				s = LT(1);
				match(SEMI);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (s);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_111_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void struct_interfaces() //throws RecognitionException, TokenStreamException
{
		
		IToken  c1 = null;
		IToken  cm = null;
		
		string [] tp = new string []{"",""};
		
		
		try {      // for error handling
			c1 = LT(1);
			match(COLON);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(c1);
			}
			tp=type();
			if (0==inputState.guessing)
			{
				Emit.EmitString(tp[0]+tp[1]);
			}
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA))
					{
						cm = LT(1);
						match(COMMA);
						tp=type_name();
						if (0==inputState.guessing)
						{
							Emit.EmitToken(cm);
							Emit.EmitString(tp[0]+tp[1]);
						}
					}
					else
					{
						goto _loop478_breakloop;
					}
					
				}
_loop478_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_90_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void struct_body() //throws RecognitionException, TokenStreamException
{
		
		IToken  lb = null;
		IToken  rb = null;
		
		try {      // for error handling
			lb = LT(1);
			match(LBRACE);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(lb);
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_137_.member(LA(1))))
					{
						struct_member_declaration();
					}
					else
					{
						goto _loop481_breakloop;
					}
					
				}
_loop481_breakloop:				;
			}    // ( ... )*
			rb = LT(1);
			match(RBRACE);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(rb);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_93_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void struct_member_declaration() //throws RecognitionException, TokenStreamException
{
		
		
		try {      // for error handling
			bool synPredMatched484 = false;
			if (((tokenSet_94_.member(LA(1))) && (tokenSet_95_.member(LA(2)))))
			{
				int _m484 = mark();
				synPredMatched484 = true;
				inputState.guessing++;
				try {
					{
						constant_declaration();
					}
				}
				catch (RecognitionException)
				{
					synPredMatched484 = false;
				}
				rewind(_m484);
				inputState.guessing--;
			}
			if ( synPredMatched484 )
			{
				constant_declaration();
			}
			else {
				bool synPredMatched486 = false;
				if (((tokenSet_96_.member(LA(1))) && (tokenSet_97_.member(LA(2)))))
				{
					int _m486 = mark();
					synPredMatched486 = true;
					inputState.guessing++;
					try {
						{
							field_declaration();
						}
					}
					catch (RecognitionException)
					{
						synPredMatched486 = false;
					}
					rewind(_m486);
					inputState.guessing--;
				}
				if ( synPredMatched486 )
				{
					field_declaration();
				}
				else {
					bool synPredMatched488 = false;
					if (((tokenSet_98_.member(LA(1))) && (tokenSet_99_.member(LA(2)))))
					{
						int _m488 = mark();
						synPredMatched488 = true;
						inputState.guessing++;
						try {
							{
								method_declaration();
							}
						}
						catch (RecognitionException)
						{
							synPredMatched488 = false;
						}
						rewind(_m488);
						inputState.guessing--;
					}
					if ( synPredMatched488 )
					{
						method_declaration();
					}
					else {
						bool synPredMatched490 = false;
						if (((tokenSet_100_.member(LA(1))) && (tokenSet_101_.member(LA(2)))))
						{
							int _m490 = mark();
							synPredMatched490 = true;
							inputState.guessing++;
							try {
								{
									property_declaration();
								}
							}
							catch (RecognitionException)
							{
								synPredMatched490 = false;
							}
							rewind(_m490);
							inputState.guessing--;
						}
						if ( synPredMatched490 )
						{
							property_declaration();
						}
						else {
							bool synPredMatched492 = false;
							if (((tokenSet_102_.member(LA(1))) && (tokenSet_103_.member(LA(2)))))
							{
								int _m492 = mark();
								synPredMatched492 = true;
								inputState.guessing++;
								try {
									{
										event_declaration();
									}
								}
								catch (RecognitionException)
								{
									synPredMatched492 = false;
								}
								rewind(_m492);
								inputState.guessing--;
							}
							if ( synPredMatched492 )
							{
								event_declaration();
							}
							else {
								bool synPredMatched494 = false;
								if (((tokenSet_100_.member(LA(1))) && (tokenSet_104_.member(LA(2)))))
								{
									int _m494 = mark();
									synPredMatched494 = true;
									inputState.guessing++;
									try {
										{
											indexer_declaration();
										}
									}
									catch (RecognitionException)
									{
										synPredMatched494 = false;
									}
									rewind(_m494);
									inputState.guessing--;
								}
								if ( synPredMatched494 )
								{
									indexer_declaration();
								}
								else {
									bool synPredMatched496 = false;
									if (((tokenSet_105_.member(LA(1))) && (tokenSet_106_.member(LA(2)))))
									{
										int _m496 = mark();
										synPredMatched496 = true;
										inputState.guessing++;
										try {
											{
												operator_declaration();
											}
										}
										catch (RecognitionException)
										{
											synPredMatched496 = false;
										}
										rewind(_m496);
										inputState.guessing--;
									}
									if ( synPredMatched496 )
									{
										operator_declaration();
									}
									else {
										bool synPredMatched498 = false;
										if (((tokenSet_107_.member(LA(1))) && (tokenSet_108_.member(LA(2)))))
										{
											int _m498 = mark();
											synPredMatched498 = true;
											inputState.guessing++;
											try {
												{
													constructor_declaration();
												}
											}
											catch (RecognitionException)
											{
												synPredMatched498 = false;
											}
											rewind(_m498);
											inputState.guessing--;
										}
										if ( synPredMatched498 )
										{
											constructor_declaration();
										}
										else {
											bool synPredMatched500 = false;
											if (((LA(1)==LBRACK||LA(1)==STATIC||LA(1)==EXTERN) && (tokenSet_109_.member(LA(2)))))
											{
												int _m500 = mark();
												synPredMatched500 = true;
												inputState.guessing++;
												try {
													{
														static_constructor_declaration();
													}
												}
												catch (RecognitionException)
												{
													synPredMatched500 = false;
												}
												rewind(_m500);
												inputState.guessing--;
											}
											if ( synPredMatched500 )
											{
												static_constructor_declaration();
											}
											else if ((tokenSet_110_.member(LA(1))) && (tokenSet_67_.member(LA(2)))) {
												type_declaration();
											}
											else
											{
												throw new NoViableAltException(LT(1), getFilename());
											}
											}}}}}}}}
										}
										catch (RecognitionException ex)
										{
											if (0 == inputState.guessing)
											{
												reportError(ex);
												recover(ex,tokenSet_138_);
											}
											else
											{
												throw ex;
											}
										}
									}
									
	public string  variable_initializer_list() //throws RecognitionException, TokenStreamException
{
		string return_string;
		
		IToken  c = null;
		
		return_string = "";
		string temp = "";
		
		
		try {      // for error handling
			return_string=variable_initializer();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA) && (tokenSet_27_.member(LA(2))))
					{
						c = LT(1);
						match(COMMA);
						temp=variable_initializer();
						if (0==inputState.guessing)
						{
							
							return_string += (c.getText () + temp);
							
						}
					}
					else
					{
						goto _loop507_breakloop;
					}
					
				}
_loop507_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_139_);
			}
			else
			{
				throw ex;
			}
		}
		return return_string;
	}
	
	public void interface_base() //throws RecognitionException, TokenStreamException
{
		
		IToken  c1 = null;
		IToken  cm = null;
		
		string [] t1 = new string[]{"",""};
		string parms = "";
		
		
		try {      // for error handling
			c1 = LT(1);
			match(COLON);
			if (0==inputState.guessing)
			{
				
				Emit.EmitToken (c1);
				
			}
			t1=type_name();
			{
				switch ( LA(1) )
				{
				case LTHAN:
				{
					parms=generic_parameters();
					break;
				}
				case COMMA:
				case LBRACE:
				case WHERE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			if (0==inputState.guessing)
			{
				
				Emit.EmitString (t1[0]+t1[1] + parms);
					    parms = "";
				
			}
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA))
					{
						cm = LT(1);
						match(COMMA);
						if (0==inputState.guessing)
						{
							Emit.EmitToken (cm);
						}
						t1=type_name();
						{
							switch ( LA(1) )
							{
							case LTHAN:
							{
								parms=generic_parameters();
								break;
							}
							case COMMA:
							case LBRACE:
							case WHERE:
							{
								break;
							}
							default:
							{
								throw new NoViableAltException(LT(1), getFilename());
							}
							 }
						}
						if (0==inputState.guessing)
						{
							
									Emit.EmitString (t1[0]+t1[1] + parms);
									parms = "";
								
						}
					}
					else
					{
						goto _loop521_breakloop;
					}
					
				}
_loop521_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_90_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void interface_body() //throws RecognitionException, TokenStreamException
{
		
		IToken  lb = null;
		IToken  rb = null;
		
		try {      // for error handling
			lb = LT(1);
			match(LBRACE);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (lb);
			}
			{    // ( ... )*
				for (;;)
				{
					if ((tokenSet_140_.member(LA(1))))
					{
						interface_member_declaration();
					}
					else
					{
						goto _loop524_breakloop;
					}
					
				}
_loop524_breakloop:				;
			}    // ( ... )*
			rb = LT(1);
			match(RBRACE);
			if (0==inputState.guessing)
			{
				Emit.EmitToken (rb);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_93_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void interface_member_declaration() //throws RecognitionException, TokenStreamException
{
		
		
		try {      // for error handling
			bool synPredMatched530 = false;
			if (((tokenSet_141_.member(LA(1))) && (tokenSet_142_.member(LA(2)))))
			{
				int _m530 = mark();
				synPredMatched530 = true;
				inputState.guessing++;
				try {
					{
						{
							switch ( LA(1) )
							{
							case LBRACK:
							{
								attributes();
								break;
							}
							case IDENTIFIER:
							case OBJECT:
							case STRING:
							case BOOL:
							case DECIMAL:
							case CHAR:
							case INT:
							case LONG:
							case SBYTE:
							case BYTE:
							case SHORT:
							case UINT:
							case ULONG:
							case USHORT:
							case FLOAT:
							case DOUBLE:
							case NEW:
							case VOID:
							{
								break;
							}
							default:
							{
								throw new NoViableAltException(LT(1), getFilename());
							}
							 }
						}
						{
							switch ( LA(1) )
							{
							case NEW:
							{
								match(NEW);
								break;
							}
							case IDENTIFIER:
							case OBJECT:
							case STRING:
							case BOOL:
							case DECIMAL:
							case CHAR:
							case INT:
							case LONG:
							case SBYTE:
							case BYTE:
							case SHORT:
							case UINT:
							case ULONG:
							case USHORT:
							case FLOAT:
							case DOUBLE:
							case VOID:
							{
								break;
							}
							default:
							{
								throw new NoViableAltException(LT(1), getFilename());
							}
							 }
						}
						return_type();
						match(IDENTIFIER);
						{
							switch ( LA(1) )
							{
							case LTHAN:
							{
								match(LTHAN);
								break;
							}
							case LPAREN:
							{
								match(LPAREN);
								break;
							}
							default:
							{
								throw new NoViableAltException(LT(1), getFilename());
							}
							 }
						}
					}
				}
				catch (RecognitionException)
				{
					synPredMatched530 = false;
				}
				rewind(_m530);
				inputState.guessing--;
			}
			if ( synPredMatched530 )
			{
				interface_method_declaration();
			}
			else {
				bool synPredMatched534 = false;
				if (((tokenSet_143_.member(LA(1))) && (tokenSet_121_.member(LA(2)))))
				{
					int _m534 = mark();
					synPredMatched534 = true;
					inputState.guessing++;
					try {
						{
							{
								switch ( LA(1) )
								{
								case LBRACK:
								{
									attributes();
									break;
								}
								case IDENTIFIER:
								case OBJECT:
								case STRING:
								case BOOL:
								case DECIMAL:
								case CHAR:
								case INT:
								case LONG:
								case SBYTE:
								case BYTE:
								case SHORT:
								case UINT:
								case ULONG:
								case USHORT:
								case FLOAT:
								case DOUBLE:
								case NEW:
								{
									break;
								}
								default:
								{
									throw new NoViableAltException(LT(1), getFilename());
								}
								 }
							}
							{
								switch ( LA(1) )
								{
								case NEW:
								{
									match(NEW);
									break;
								}
								case IDENTIFIER:
								case OBJECT:
								case STRING:
								case BOOL:
								case DECIMAL:
								case CHAR:
								case INT:
								case LONG:
								case SBYTE:
								case BYTE:
								case SHORT:
								case UINT:
								case ULONG:
								case USHORT:
								case FLOAT:
								case DOUBLE:
								{
									break;
								}
								default:
								{
									throw new NoViableAltException(LT(1), getFilename());
								}
								 }
							}
							type();
							match(IDENTIFIER);
							match(LBRACE);
						}
					}
					catch (RecognitionException)
					{
						synPredMatched534 = false;
					}
					rewind(_m534);
					inputState.guessing--;
				}
				if ( synPredMatched534 )
				{
					interface_property_declaration();
				}
				else {
					bool synPredMatched538 = false;
					if (((LA(1)==LBRACK||LA(1)==NEW||LA(1)==EVENT) && (tokenSet_144_.member(LA(2)))))
					{
						int _m538 = mark();
						synPredMatched538 = true;
						inputState.guessing++;
						try {
							{
								{
									switch ( LA(1) )
									{
									case LBRACK:
									{
										attributes();
										break;
									}
									case NEW:
									case EVENT:
									{
										break;
									}
									default:
									{
										throw new NoViableAltException(LT(1), getFilename());
									}
									 }
								}
								{
									switch ( LA(1) )
									{
									case NEW:
									{
										match(NEW);
										break;
									}
									case EVENT:
									{
										break;
									}
									default:
									{
										throw new NoViableAltException(LT(1), getFilename());
									}
									 }
								}
								match(EVENT);
							}
						}
						catch (RecognitionException)
						{
							synPredMatched538 = false;
						}
						rewind(_m538);
						inputState.guessing--;
					}
					if ( synPredMatched538 )
					{
						interface_event_declaration();
					}
					else if ((tokenSet_143_.member(LA(1))) && (tokenSet_145_.member(LA(2)))) {
						interface_indexer_declaration();
					}
					else
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}}
				}
				catch (RecognitionException ex)
				{
					if (0 == inputState.guessing)
					{
						reportError(ex);
						recover(ex,tokenSet_146_);
					}
					else
					{
						throw ex;
					}
				}
			}
			
	public void interface_method_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  n = null;
		IToken  id = null;
		IToken  lp = null;
		IToken  rp = null;
		IToken  s = null;
		
		string [] tp = new string []{"",""};
		string parms; 
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case NEW:
				case VOID:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{
				switch ( LA(1) )
				{
				case NEW:
				{
					n = LT(1);
					match(NEW);
					if (0==inputState.guessing)
					{
						Emit.EmitToken(n);
					}
					break;
				}
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case VOID:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			tp=return_type_array();
			if (0==inputState.guessing)
			{
				Emit.EmitString(tp[0]);
			}
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(id);
			}
			{
				switch ( LA(1) )
				{
				case LTHAN:
				{
					parms=generic_parameters();
					if (0==inputState.guessing)
					{
						Emit.EmitString (parms);
					}
					break;
				}
				case LPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(lp);
			}
			{
				switch ( LA(1) )
				{
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case LBRACK:
				case REF:
				case OUT:
				case PARAMS:
				{
					formal_parameter_list();
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			rp = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(rp);
			}
			if (0==inputState.guessing)
			{
				Emit.EmitString(" : " + tp[1]);
			}
			{
				switch ( LA(1) )
				{
				case WHERE:
				{
					parms=where_constraints();
					if (0==inputState.guessing)
					{
						Emit.EmitString (parms);
					}
					break;
				}
				case SEMI:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			s = LT(1);
			match(SEMI);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(s);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_146_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void interface_property_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  n = null;
		IToken  id = null;
		IToken  lb = null;
		IToken  rb = null;
		
		string [] tp = new string []{"",""};
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case NEW:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{
				switch ( LA(1) )
				{
				case NEW:
				{
					n = LT(1);
					match(NEW);
					if (0==inputState.guessing)
					{
						Emit.EmitToken(n);
					}
					break;
				}
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			tp=type();
			if (0==inputState.guessing)
			{
				Emit.EmitString(tp[0]);
			}
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(id);
			}
			if (0==inputState.guessing)
			{
				Emit.EmitString(" : " + tp[1]);
			}
			lb = LT(1);
			match(LBRACE);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(lb);
			}
			interface_accessors();
			rb = LT(1);
			match(RBRACE);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(rb);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_146_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void interface_event_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  n = null;
		IToken  e = null;
		IToken  id = null;
		IToken  s = null;
		
		string [] tp = new string []{"",""};
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case NEW:
				case EVENT:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{
				switch ( LA(1) )
				{
				case NEW:
				{
					n = LT(1);
					match(NEW);
					if (0==inputState.guessing)
					{
						Emit.EmitToken(n);
					}
					break;
				}
				case EVENT:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			e = LT(1);
			match(EVENT);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(e);
			}
			tp=type();
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(id);
			}
			if (0==inputState.guessing)
			{
				Emit.EmitString(" : " + tp[0] + tp[1] );
			}
			s = LT(1);
			match(SEMI);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(s);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_146_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void interface_indexer_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  n = null;
		IToken  t = null;
		IToken  lb = null;
		IToken  rb = null;
		IToken  l = null;
		IToken  r = null;
		
		string [] tp = new string []{"",""};
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case NEW:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			{
				switch ( LA(1) )
				{
				case NEW:
				{
					n = LT(1);
					match(NEW);
					if (0==inputState.guessing)
					{
						Emit.EmitToken(n);
					}
					break;
				}
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case BOOL:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			tp=type();
			if (0==inputState.guessing)
			{
				Emit.EmitString(tp[0]);
			}
			t = LT(1);
			match(THIS);
			if (0==inputState.guessing)
			{
				Emit.EmitString(ExtendedToken.getWhitespaces (t) + "Item");
			}
			lb = LT(1);
			match(LBRACK);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(lb);
			}
			formal_parameter_list();
			rb = LT(1);
			match(RBRACK);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(rb);
			}
			if (0==inputState.guessing)
			{
				Emit.EmitString(" : " + tp[1]);
			}
			l = LT(1);
			match(LBRACE);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(l);
			}
			interface_accessors();
			r = LT(1);
			match(RBRACE);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(r);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_146_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void interface_accessors() //throws RecognitionException, TokenStreamException
{
		
		IToken  get1 = null;
		IToken  s11 = null;
		IToken  set1 = null;
		IToken  s21 = null;
		IToken  set3 = null;
		IToken  s3 = null;
		
		bool first_get = true;    
		
		
		try {      // for error handling
			bool synPredMatched552 = false;
			if (((LA(1)==IDENTIFIER||LA(1)==LBRACK) && (LA(2)==IDENTIFIER||LA(2)==RETURN||LA(2)==SEMI)))
			{
				int _m552 = mark();
				synPredMatched552 = true;
				inputState.guessing++;
				try {
					{
						{
							switch ( LA(1) )
							{
							case LBRACK:
							{
								attributes();
								break;
							}
							case IDENTIFIER:
							{
								break;
							}
							default:
							{
								throw new NoViableAltException(LT(1), getFilename());
							}
							 }
						}
						match(IDENTIFIER);
						match(SEMI);
						{
							switch ( LA(1) )
							{
							case LBRACK:
							{
								attributes();
								break;
							}
							case IDENTIFIER:
							{
								break;
							}
							default:
							{
								throw new NoViableAltException(LT(1), getFilename());
							}
							 }
						}
						match(IDENTIFIER);
						match(SEMI);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched552 = false;
				}
				rewind(_m552);
				inputState.guessing--;
			}
			if ( synPredMatched552 )
			{
				{
					switch ( LA(1) )
					{
					case LBRACK:
					{
						attributes();
						break;
					}
					case IDENTIFIER:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					 }
				}
				get1 = LT(1);
				match(IDENTIFIER);
				if (0==inputState.guessing)
				{
					
							    if(ExtendedToken.getTextOnly(get1)=="get")
								;
							    else if(ExtendedToken.getTextOnly(get1)=="set")
								first_get = false;
							    else
								throw new RecognitionException ("line " + get1.getLine () + ":" + get1.getColumn ()
								    + ": unexpected token: " + get1.ToString ());		    
							
							    Emit.EmitToken(get1);
							
				}
				s11 = LT(1);
				match(SEMI);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(s11);
				}
				{
					switch ( LA(1) )
					{
					case LBRACK:
					{
						attributes();
						break;
					}
					case IDENTIFIER:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					 }
				}
				set1 = LT(1);
				match(IDENTIFIER);
				if (0==inputState.guessing)
				{
					
							    if(first_get && ExtendedToken.getTextOnly(set1)=="set")
								;
							    else if(!first_get && ExtendedToken.getTextOnly(set1)=="get")
								;
							    else
								throw new RecognitionException (set1.ToString ());
							    		
							    Emit.EmitToken(set1);
							
				}
				s21 = LT(1);
				match(SEMI);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(s21);
				}
			}
			else {
				bool synPredMatched557 = false;
				if (((LA(1)==IDENTIFIER||LA(1)==LBRACK) && (LA(2)==IDENTIFIER||LA(2)==RETURN||LA(2)==SEMI)))
				{
					int _m557 = mark();
					synPredMatched557 = true;
					inputState.guessing++;
					try {
						{
							{
								switch ( LA(1) )
								{
								case LBRACK:
								{
									attributes();
									break;
								}
								case IDENTIFIER:
								{
									break;
								}
								default:
								{
									throw new NoViableAltException(LT(1), getFilename());
								}
								 }
							}
							match(IDENTIFIER);
						}
					}
					catch (RecognitionException)
					{
						synPredMatched557 = false;
					}
					rewind(_m557);
					inputState.guessing--;
				}
				if ( synPredMatched557 )
				{
					{
						switch ( LA(1) )
						{
						case LBRACK:
						{
							attributes();
							break;
						}
						case IDENTIFIER:
						{
							break;
						}
						default:
						{
							throw new NoViableAltException(LT(1), getFilename());
						}
						 }
					}
					set3 = LT(1);
					match(IDENTIFIER);
					if (0==inputState.guessing)
					{
						
								    if(ExtendedToken.getTextOnly(set3)=="set" || ExtendedToken.getTextOnly(set3)=="get")
									;
								    else
									throw new RecognitionException ("line " + get1.getLine () + ":" + get1.getColumn ()
									    + ": unexpected token: " + set3.ToString ());
								    
								    Emit.EmitToken(set3);
								
					}
					s3 = LT(1);
					match(SEMI);
					if (0==inputState.guessing)
					{
						Emit.EmitToken(s3);
					}
				}
				else
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				}
			}
			catch (RecognitionException ex)
			{
				if (0 == inputState.guessing)
				{
					reportError(ex);
					recover(ex,tokenSet_128_);
				}
				else
				{
					throw ex;
				}
			}
		}
		
	public void enum_base() //throws RecognitionException, TokenStreamException
{
		
		IToken  c = null;
		
		string [] tp = new string [] {"",""};
		
		
		try {      // for error handling
			c = LT(1);
			match(COLON);
			tp=integral_type();
			if (0==inputState.guessing)
			{
				
				Emit.EmitToken(c);
				Emit.EmitString(tp[0]+tp[1]);
				
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_22_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void enum_body() //throws RecognitionException, TokenStreamException
{
		
		IToken  lb1 = null;
		IToken  c = null;
		IToken  rb1 = null;
		IToken  lb2 = null;
		IToken  rb2 = null;
		
		try {      // for error handling
			bool synPredMatched574 = false;
			if (((LA(1)==LBRACE) && (LA(2)==IDENTIFIER||LA(2)==LBRACK)))
			{
				int _m574 = mark();
				synPredMatched574 = true;
				inputState.guessing++;
				try {
					{
						match(LBRACE);
						enum_member_declarations();
						match(COMMA);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched574 = false;
				}
				rewind(_m574);
				inputState.guessing--;
			}
			if ( synPredMatched574 )
			{
				lb1 = LT(1);
				match(LBRACE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(lb1);
				}
				enum_member_declarations();
				c = LT(1);
				match(COMMA);
				if (0==inputState.guessing)
				{
					Emit.EmitString (ExtendedToken.getWhitespaces (c));
				}
				rb1 = LT(1);
				match(RBRACE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(rb1);
				}
			}
			else if ((LA(1)==LBRACE) && (LA(2)==IDENTIFIER||LA(2)==LBRACK||LA(2)==RBRACE)) {
				lb2 = LT(1);
				match(LBRACE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(lb2);
				}
				{
					switch ( LA(1) )
					{
					case IDENTIFIER:
					case LBRACK:
					{
						enum_member_declarations();
						break;
					}
					case RBRACE:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					 }
				}
				rb2 = LT(1);
				match(RBRACE);
				if (0==inputState.guessing)
				{
					
					Emit.EmitToken(rb2);
					
				}
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_93_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void enum_member_declarations() //throws RecognitionException, TokenStreamException
{
		
		IToken  c = null;
		
		try {      // for error handling
			enum_member_declaration();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA) && (LA(2)==IDENTIFIER||LA(2)==LBRACK))
					{
						c = LT(1);
						match(COMMA);
						if (0==inputState.guessing)
						{
							Emit.EmitString (ExtendedToken.getWhitespaces (c));
						}
						enum_member_declaration();
					}
					else
					{
						goto _loop579_breakloop;
					}
					
				}
_loop579_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_139_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void enum_member_declaration() //throws RecognitionException, TokenStreamException
{
		
		IToken  id = null;
		IToken  a = null;
		
		string ce = "";
		
		
		try {      // for error handling
			{
				switch ( LA(1) )
				{
				case LBRACK:
				{
					attributes();
					break;
				}
				case IDENTIFIER:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			id = LT(1);
			match(IDENTIFIER);
			if (0==inputState.guessing)
			{
				Emit.EmitString (ExtendedToken.getWhitespaces (id) + "| " + ExtendedToken.getTextOnly (id)) ;
			}
			{
				switch ( LA(1) )
				{
				case ASSIGN:
				{
					a = LT(1);
					match(ASSIGN);
					ce=constant_expression();
					if (0==inputState.guessing)
					{
						
						Emit.EmitToken (a);
						Emit.EmitString (ce);
						
					}
					break;
				}
				case COMMA:
				case RBRACE:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_139_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void delegate_modifier() //throws RecognitionException, TokenStreamException
{
		
		IToken  dm1 = null;
		IToken  dm2 = null;
		IToken  dm3 = null;
		IToken  dm4 = null;
		IToken  dm5 = null;
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case NEW:
			{
				dm1 = LT(1);
				match(NEW);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(dm1);
				}
				break;
			}
			case PUBLIC:
			{
				dm2 = LT(1);
				match(PUBLIC);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(dm2);
				}
				break;
			}
			case PROTECTED:
			{
				dm3 = LT(1);
				match(PROTECTED);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(dm3);
				}
				break;
			}
			case INTERNAL:
			{
				dm4 = LT(1);
				match(INTERNAL);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(dm4);
				}
				break;
			}
			case PRIVATE:
			{
				dm5 = LT(1);
				match(PRIVATE);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(dm5);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_147_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void global_attribute_section() //throws RecognitionException, TokenStreamException
{
		
		IToken  lb = null;
		IToken  c = null;
		IToken  rb = null;
		
		try {      // for error handling
			lb = LT(1);
			match(LBRACK);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(lb);
			}
			{
				if ((LA(1)==IDENTIFIER) && (LA(2)==COLON))
				{
					global_attribute_target_specifier();
				}
				else if ((LA(1)==IDENTIFIER) && (tokenSet_148_.member(LA(2)))) {
				}
				else
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				
			}
			attribute_list();
			{
				switch ( LA(1) )
				{
				case COMMA:
				{
					c = LT(1);
					match(COMMA);
					if (0==inputState.guessing)
					{
						Emit.EmitString(ExtendedToken.getWhitespaces(c));
					}
					break;
				}
				case RBRACK:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			rb = LT(1);
			match(RBRACK);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(rb);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_69_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void global_attribute_target_specifier() //throws RecognitionException, TokenStreamException
{
		
		IToken  idgat = null;
		IToken  c = null;
		
		try {      // for error handling
			idgat = LT(1);
			match(IDENTIFIER);
			if (!( ExtendedToken.getTextOnly(idgat)=="assembly" || 
          ExtendedToken.getTextOnly(idgat)=="module" ))
			  throw new SemanticException(" ExtendedToken.getTextOnly(idgat)==\"assembly\" || \n          ExtendedToken.getTextOnly(idgat)==\"module\" ");
			if (0==inputState.guessing)
			{
				Emit.EmitToken(idgat);
			}
			c = LT(1);
			match(COLON);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(c);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_136_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void attribute_list() //throws RecognitionException, TokenStreamException
{
		
		IToken  c = null;
		
		try {      // for error handling
			attribute();
			{    // ( ... )*
				for (;;)
				{
					if ((LA(1)==COMMA) && (LA(2)==IDENTIFIER))
					{
						c = LT(1);
						match(COMMA);
						if (0==inputState.guessing)
						{
							Emit.EmitToken(c);
						}
						attribute();
					}
					else
					{
						goto _loop608_breakloop;
					}
					
				}
_loop608_breakloop:				;
			}    // ( ... )*
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_149_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void attribute_section() //throws RecognitionException, TokenStreamException
{
		
		IToken  lb = null;
		IToken  c = null;
		IToken  rb = null;
		
		try {      // for error handling
			lb = LT(1);
			match(LBRACK);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(lb);
			}
			{
				if ((LA(1)==IDENTIFIER||LA(1)==RETURN) && (LA(2)==COLON))
				{
					attribute_target_specifier();
				}
				else if ((LA(1)==IDENTIFIER) && (tokenSet_148_.member(LA(2)))) {
				}
				else
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				
			}
			attribute_list();
			{
				switch ( LA(1) )
				{
				case COMMA:
				{
					c = LT(1);
					match(COMMA);
					if (0==inputState.guessing)
					{
						Emit.EmitString(ExtendedToken.getWhitespaces(c));
					}
					break;
				}
				case RBRACK:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			rb = LT(1);
			match(RBRACK);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(rb);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_150_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void attribute_target_specifier() //throws RecognitionException, TokenStreamException
{
		
		IToken  c = null;
		
		try {      // for error handling
			attribute_target();
			c = LT(1);
			match(COLON);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(c);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_136_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void attribute_target() //throws RecognitionException, TokenStreamException
{
		
		IToken  idat = null;
		IToken  ret = null;
		
		try {      // for error handling
			switch ( LA(1) )
			{
			case IDENTIFIER:
			{
				idat = LT(1);
				match(IDENTIFIER);
				if (!(ExtendedToken.getTextOnly(idat)=="field"    || //FIELD
        ExtendedToken.getTextOnly(idat)=="event"    || //EVENT
        ExtendedToken.getTextOnly(idat)=="method"   || //METHOD
        ExtendedToken.getTextOnly(idat)=="param"    || //PARAM
        ExtendedToken.getTextOnly(idat)=="property" || //PROPERTY
	ExtendedToken.getTextOnly(idat)=="type" ))
				  throw new SemanticException("ExtendedToken.getTextOnly(idat)==\"field\"    || //FIELD\n        ExtendedToken.getTextOnly(idat)==\"event\"    || //EVENT\n        ExtendedToken.getTextOnly(idat)==\"method\"   || //METHOD\n        ExtendedToken.getTextOnly(idat)==\"param\"    || //PARAM\n        ExtendedToken.getTextOnly(idat)==\"property\" || //PROPERTY\n\tExtendedToken.getTextOnly(idat)==\"type\" ");
				if (0==inputState.guessing)
				{
					Emit.EmitToken(idat);
				}
				break;
			}
			case RETURN:
			{
				ret = LT(1);
				match(RETURN);
				if (0==inputState.guessing)
				{
					Emit.EmitToken (ret);
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			 }
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_151_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void attribute() //throws RecognitionException, TokenStreamException
{
		
		
		try {      // for error handling
			attribute_name();
			{
				switch ( LA(1) )
				{
				case LPAREN:
				{
					attribute_arguments();
					break;
				}
				case COMMA:
				case RBRACK:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_149_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void attribute_name() //throws RecognitionException, TokenStreamException
{
		
		
		string [] tp = new string[]{"",""};
		
		
		try {      // for error handling
			tp=type_name();
			if (0==inputState.guessing)
			{
				Emit.EmitString(tp[0] + tp[1]);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_152_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void attribute_arguments() //throws RecognitionException, TokenStreamException
{
		
		IToken  lp = null;
		IToken  rp3 = null;
		
		try {      // for error handling
			lp = LT(1);
			match(LPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(lp);
			}
			{
				switch ( LA(1) )
				{
				case INTEGER_LITERAL:
				case HEXADECIMAL_INTEGER_LITERAL:
				case REAL_LITERAL:
				case CHARACTER_LITERAL:
				case NULL:
				case TRUE:
				case FALSE:
				case REGULAR_STRING_LITERAL:
				case VERBATIM_STRING_LITERAL:
				case IDENTIFIER:
				case OBJECT:
				case STRING:
				case DECIMAL:
				case CHAR:
				case INT:
				case LONG:
				case SBYTE:
				case BYTE:
				case SHORT:
				case UINT:
				case ULONG:
				case USHORT:
				case FLOAT:
				case DOUBLE:
				case DEC:
				case INC:
				case DELEGATE:
				case LPAREN:
				case NEW:
				case THIS:
				case BASE:
				case TYPEOF:
				case CHECKED:
				case UNCHECKED:
				case PLUS:
				case MINUS:
				case LNOT:
				case BNOT:
				case STAR:
				case DEFAULT:
				{
					positional_argument_list();
					break;
				}
				case RPAREN:
				{
					break;
				}
				default:
				{
					throw new NoViableAltException(LT(1), getFilename());
				}
				 }
			}
			rp3 = LT(1);
			match(RPAREN);
			if (0==inputState.guessing)
			{
				Emit.EmitToken(rp3);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_149_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void positional_argument_list() //throws RecognitionException, TokenStreamException
{
		
		IToken  id1 = null;
		IToken  a1 = null;
		IToken  c = null;
		IToken  c1 = null;
		
		try {      // for error handling
			bool synPredMatched616 = false;
			if (((LA(1)==IDENTIFIER) && (LA(2)==ASSIGN)))
			{
				int _m616 = mark();
				synPredMatched616 = true;
				inputState.guessing++;
				try {
					{
						match(IDENTIFIER);
						match(ASSIGN);
					}
				}
				catch (RecognitionException)
				{
					synPredMatched616 = false;
				}
				rewind(_m616);
				inputState.guessing--;
			}
			if ( synPredMatched616 )
			{
				id1 = LT(1);
				match(IDENTIFIER);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(id1);
				}
				a1 = LT(1);
				match(ASSIGN);
				if (0==inputState.guessing)
				{
					Emit.EmitToken(a1);
				}
				attribute_argument_expression();
				{
					switch ( LA(1) )
					{
					case COMMA:
					{
						c = LT(1);
						match(COMMA);
						if (0==inputState.guessing)
						{
							Emit.EmitToken(c);
						}
						positional_argument_list();
						break;
					}
					case RPAREN:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					 }
				}
			}
			else if ((tokenSet_8_.member(LA(1))) && (tokenSet_153_.member(LA(2)))) {
				attribute_argument_expression();
				{
					switch ( LA(1) )
					{
					case COMMA:
					{
						c1 = LT(1);
						match(COMMA);
						if (0==inputState.guessing)
						{
							Emit.EmitToken(c1);
						}
						positional_argument_list();
						break;
					}
					case RPAREN:
					{
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					 }
				}
			}
			else
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_12_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	public void attribute_argument_expression() //throws RecognitionException, TokenStreamException
{
		
		
		string e = "";
		
		
		try {      // for error handling
			e=expression();
			if (0==inputState.guessing)
			{
				Emit.EmitString(e);
			}
		}
		catch (RecognitionException ex)
		{
			if (0 == inputState.guessing)
			{
				reportError(ex);
				recover(ex,tokenSet_25_);
			}
			else
			{
				throw ex;
			}
		}
	}
	
	private void initializeFactory()
	{
	}
	
	public static readonly string[] tokenNames_ = new string[] {
		@"""<0>""",
		@"""EOF""",
		@"""<2>""",
		@"""NULL_TREE_LOOKAHEAD""",
		@"""INTEGER_LITERAL""",
		@"""HEXADECIMAL_INTEGER_LITERAL""",
		@"""REAL_LITERAL""",
		@"""CHARACTER_LITERAL""",
		@"""null""",
		@"""true""",
		@"""false""",
		@"""REGULAR_STRING_LITERAL""",
		@"""VERBATIM_STRING_LITERAL""",
		@"""IDENTIFIER""",
		@"""DOT""",
		@"""object""",
		@"""string""",
		@"""bool""",
		@"""decimal""",
		@"""char""",
		@"""int""",
		@"""long""",
		@"""sbyte""",
		@"""byte""",
		@"""short""",
		@"""uint""",
		@"""ulong""",
		@"""ushort""",
		@"""float""",
		@"""double""",
		@"""LTHAN""",
		@"""COMMA""",
		@"""GTHAN""",
		@"""SR""",
		@"""LBRACK""",
		@"""RBRACK""",
		@"""ref""",
		@"""out""",
		@"""DEC""",
		@"""INC""",
		@"""delegate""",
		@"""LPAREN""",
		@"""RPAREN""",
		@"""new""",
		@"""this""",
		@"""base""",
		@"""typeof""",
		@"""void""",
		@"""checked""",
		@"""unchecked""",
		@"""PLUS""",
		@"""MINUS""",
		@"""LNOT""",
		@"""BNOT""",
		@"""STAR""",
		@"""DIV""",
		@"""MOD""",
		@"""SL""",
		@"""is""",
		@"""as""",
		@"""LE""",
		@"""GE""",
		@"""EQUAL""",
		@"""NOT_EQUAL""",
		@"""BAND""",
		@"""BXOR""",
		@"""BOR""",
		@"""LAND""",
		@"""LOR""",
		@"""QUESTION""",
		@"""COLON""",
		@"""ASSIGN""",
		@"""PLUS_ASN""",
		@"""MINUS_ASN""",
		@"""STAR_ASN""",
		@"""DIV_ASN""",
		@"""MOD_ASN""",
		@"""BAND_ASN""",
		@"""BOR_ASN""",
		@"""BXOR_ASN""",
		@"""SL_ASN""",
		@"""SR_ASN""",
		@"""const""",
		@"""yield""",
		@"""return""",
		@"""SEMI""",
		@"""default""",
		@"""LBRACE""",
		@"""RBRACE""",
		@"""if""",
		@"""else""",
		@"""switch""",
		@"""case""",
		@"""while""",
		@"""do""",
		@"""for""",
		@"""foreach""",
		@"""in""",
		@"""break""",
		@"""continue""",
		@"""goto""",
		@"""throw""",
		@"""try""",
		@"""catch""",
		@"""finally""",
		@"""lock""",
		@"""using""",
		@"""namespace""",
		@"""enum""",
		@"""struct""",
		@"""interface""",
		@"""class""",
		@"""public""",
		@"""protected""",
		@"""internal""",
		@"""private""",
		@"""sealed""",
		@"""abstract""",
		@"""static""",
		@"""partial""",
		@"""readonly""",
		@"""volatile""",
		@"""where""",
		@"""virtual""",
		@"""override""",
		@"""extern""",
		@"""params""",
		@"""event""",
		@"""operator""",
		@"""implicit""",
		@"""explicit""",
		@"""sizeof""",
		@"""stackalloc""",
		@"""fixed""",
		@"""unsafe""",
		@"""NEW_LINE""",
		@"""WHITESPACE""",
		@"""NEW_LINE_CHARACTER""",
		@"""NOT_NEW_LINE""",
		@"""SINGLE_LINE_COMMENT""",
		@"""DELIMITED_COMMENT""",
		@"""UNICODE_ESCAPE_SEQUENCE""",
		@"""IDENTIFIER_START_CHARACTER""",
		@"""IDENTIFIER_PART_CHARACTER""",
		@"""DECIMAL_DIGIT""",
		@"""HEX_DIGIT""",
		@"""INTEGER_TYPE_SUFFIX""",
		@"""NUMERIC_LITERAL""",
		@"""EXPONENT_PART""",
		@"""SIGN""",
		@"""CHARACTER""",
		@"""SIMPLE_CHARACTER""",
		@"""SIMPLE_ESCAPE_SEQUENCE""",
		@"""HEXADECIMAL_ESCAPE_SEQUENCE""",
		@"""REGULAR_STRING_LITERAL_CHARACTER""",
		@"""SINGLE_REGULAR_STRING_LITERAL_CHARCACTER""",
		@"""HASH""",
		@"""QUOTE""",
		@"""PP_DIRECTIVE""",
		@"""PP_WHITESPACE""",
		@"""PP_NEW_LINE""",
		@"""PP_EXPRESSION""",
		@"""PP_OR_EXPRESSION""",
		@"""PP_AND_EXPRESSION""",
		@"""PP_EQUALITY_EXPRESSION""",
		@"""EQUALITY_OP""",
		@"""PP_UNARY_EXPRESSION""",
		@"""PP_PRIMARY_EXPRESSION""",
		@"""PP_CONDITIONAL""",
		@"""PP_IF_SECTION""",
		@"""PP_ELIF_SECTION""",
		@"""PP_ELSE_SECTION""",
		@"""PP_ENDIF""",
		@"""PP_DECLARATION""",
		@"""CONDITIONAL_SYMBOL""",
		@"""PP_LINE""",
		@"""LINE_INDICATOR""",
		@"""FILE_NAME""",
		@"""FILE_NAME_CHARACTER""",
		@"""PP_DIAGNOSTIC""",
		@"""PP_START_REGION""",
		@"""PP_END_REGION""",
		@"""PP_MESSAGE"""
	};
	
	private static long[] mk_tokenSet_0_()
	{
		long[] data = { -14629209439715326L, 19136511L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_0_ = new BitSet(mk_tokenSet_0_());
	private static long[] mk_tokenSet_1_()
	{
		long[] data = { 0L, 2097152L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_1_ = new BitSet(mk_tokenSet_1_());
	private static long[] mk_tokenSet_2_()
	{
		long[] data = { -14611616179953662L, 288230376179236863L, 1L, 0L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_2_ = new BitSet(mk_tokenSet_2_());
	private static long[] mk_tokenSet_3_()
	{
		long[] data = { 1073717248L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_3_ = new BitSet(mk_tokenSet_3_());
	private static long[] mk_tokenSet_4_()
	{
		long[] data = { -14L, -1649267441665L, 1L, 0L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_4_ = new BitSet(mk_tokenSet_4_());
	private static long[] mk_tokenSet_5_()
	{
		long[] data = { 17179869184L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_5_ = new BitSet(mk_tokenSet_5_());
	private static long[] mk_tokenSet_6_()
	{
		long[] data = { 2L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_6_ = new BitSet(mk_tokenSet_6_());
	private static long[] mk_tokenSet_7_()
	{
		long[] data = { 4400193994754L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_7_ = new BitSet(mk_tokenSet_7_());
	private static long[] mk_tokenSet_8_()
	{
		long[] data = { 35883387679784944L, 4194304L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_8_ = new BitSet(mk_tokenSet_8_());
	private static long[] mk_tokenSet_9_()
	{
		long[] data = { -140943646785550L, 31457407L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_9_ = new BitSet(mk_tokenSet_9_());
	private static long[] mk_tokenSet_10_()
	{
		long[] data = { 35883404859801584L, 12844928L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_10_ = new BitSet(mk_tokenSet_10_());
	private static long[] mk_tokenSet_11_()
	{
		long[] data = { 4434553733122L, 18874432L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_11_ = new BitSet(mk_tokenSet_11_());
	private static long[] mk_tokenSet_12_()
	{
		long[] data = { 4398046511104L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_12_ = new BitSet(mk_tokenSet_12_());
	private static long[] mk_tokenSet_13_()
	{
		long[] data = { 3023656992768L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_13_ = new BitSet(mk_tokenSet_13_());
	private static long[] mk_tokenSet_14_()
	{
		long[] data = { 979665933942768L, 4194304L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_14_ = new BitSet(mk_tokenSet_14_());
	private static long[] mk_tokenSet_15_()
	{
		long[] data = { -140943646785550L, 31719423L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_15_ = new BitSet(mk_tokenSet_15_());
	private static long[] mk_tokenSet_16_()
	{
		long[] data = { 3040836861952L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_16_ = new BitSet(mk_tokenSet_16_());
	private static long[] mk_tokenSet_17_()
	{
		long[] data = { -14632250276577278L, 19136511L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_17_ = new BitSet(mk_tokenSet_17_());
	private static long[] mk_tokenSet_18_()
	{
		long[] data = { -14629226619584510L, 19136511L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_18_ = new BitSet(mk_tokenSet_18_());
	private static long[] mk_tokenSet_19_()
	{
		long[] data = { -14L, -4899918052436475905L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_19_ = new BitSet(mk_tokenSet_19_());
	private static long[] mk_tokenSet_20_()
	{
		long[] data = { -14629226619584510L, 27525119L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_20_ = new BitSet(mk_tokenSet_20_());
	private static long[] mk_tokenSet_21_()
	{
		long[] data = { 16384L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_21_ = new BitSet(mk_tokenSet_21_());
	private static long[] mk_tokenSet_22_()
	{
		long[] data = { 0L, 8388608L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_22_ = new BitSet(mk_tokenSet_22_());
	private static long[] mk_tokenSet_23_()
	{
		long[] data = { 35883387679916016L, 7137883062272L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_23_ = new BitSet(mk_tokenSet_23_());
	private static long[] mk_tokenSet_24_()
	{
		long[] data = { -206158430222L, -4899925199262056449L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_24_ = new BitSet(mk_tokenSet_24_());
	private static long[] mk_tokenSet_25_()
	{
		long[] data = { 4400193994752L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_25_ = new BitSet(mk_tokenSet_25_());
	private static long[] mk_tokenSet_26_()
	{
		long[] data = { 34359738368L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_26_ = new BitSet(mk_tokenSet_26_());
	private static long[] mk_tokenSet_27_()
	{
		long[] data = { 35883387679784944L, 12582912L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_27_ = new BitSet(mk_tokenSet_27_());
	private static long[] mk_tokenSet_28_()
	{
		long[] data = { 35883387679784944L, 29360128L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_28_ = new BitSet(mk_tokenSet_28_());
	private static long[] mk_tokenSet_29_()
	{
		long[] data = { -140733039842951166L, 18874495L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_29_ = new BitSet(mk_tokenSet_29_());
	private static long[] mk_tokenSet_30_()
	{
		long[] data = { -144110739563479038L, 18874495L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_30_ = new BitSet(mk_tokenSet_30_());
	private static long[] mk_tokenSet_31_()
	{
		long[] data = { -288225936229269502L, 18874495L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_31_ = new BitSet(mk_tokenSet_31_());
	private static long[] mk_tokenSet_32_()
	{
		long[] data = { 3746849511771734000L, 12582912L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_32_ = new BitSet(mk_tokenSet_32_());
	private static long[] mk_tokenSet_33_()
	{
		long[] data = { 3458764519189250048L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_33_ = new BitSet(mk_tokenSet_33_());
	private static long[] mk_tokenSet_34_()
	{
		long[] data = { 576315368734195696L, 12582912L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_34_ = new BitSet(mk_tokenSet_34_());
	private static long[] mk_tokenSet_35_()
	{
		long[] data = { 864545744885907440L, 12582912L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_35_ = new BitSet(mk_tokenSet_35_());
	private static long[] mk_tokenSet_36_()
	{
		long[] data = { -4323596591291170830L, 31457407L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_36_ = new BitSet(mk_tokenSet_36_());
	private static long[] mk_tokenSet_37_()
	{
		long[] data = { -4611681583873654782L, 18874495L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_37_ = new BitSet(mk_tokenSet_37_());
	private static long[] mk_tokenSet_38_()
	{
		long[] data = { 4434553733122L, 18874495L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_38_ = new BitSet(mk_tokenSet_38_());
	private static long[] mk_tokenSet_39_()
	{
		long[] data = { 4434553733122L, 18874494L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_39_ = new BitSet(mk_tokenSet_39_());
	private static long[] mk_tokenSet_40_()
	{
		long[] data = { 4434553733122L, 18874492L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_40_ = new BitSet(mk_tokenSet_40_());
	private static long[] mk_tokenSet_41_()
	{
		long[] data = { 4434553733122L, 18874488L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_41_ = new BitSet(mk_tokenSet_41_());
	private static long[] mk_tokenSet_42_()
	{
		long[] data = { 4434553733122L, 18874480L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_42_ = new BitSet(mk_tokenSet_42_());
	private static long[] mk_tokenSet_43_()
	{
		long[] data = { 4434553733122L, 18874464L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_43_ = new BitSet(mk_tokenSet_43_());
	private static long[] mk_tokenSet_44_()
	{
		long[] data = { 2147483648L, 18874432L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_44_ = new BitSet(mk_tokenSet_44_());
	private static long[] mk_tokenSet_45_()
	{
		long[] data = { 4398046511104L, 2097152L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_45_ = new BitSet(mk_tokenSet_45_());
	private static long[] mk_tokenSet_46_()
	{
		long[] data = { 1073717248L, 262144L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_46_ = new BitSet(mk_tokenSet_46_());
	private static long[] mk_tokenSet_47_()
	{
		long[] data = { 19327344640L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_47_ = new BitSet(mk_tokenSet_47_());
	private static long[] mk_tokenSet_48_()
	{
		long[] data = { 35883387679784944L, 7137882800128L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_48_ = new BitSet(mk_tokenSet_48_());
	private static long[] mk_tokenSet_49_()
	{
		long[] data = { 35883404859801584L, 7138168536960L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_49_ = new BitSet(mk_tokenSet_49_());
	private static long[] mk_tokenSet_50_()
	{
		long[] data = { 35883387679916016L, 7138168274944L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_50_ = new BitSet(mk_tokenSet_50_());
	private static long[] mk_tokenSet_51_()
	{
		long[] data = { 0L, 257699086336L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_51_ = new BitSet(mk_tokenSet_51_());
	private static long[] mk_tokenSet_52_()
	{
		long[] data = { 35883404859801584L, 14942080L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_52_ = new BitSet(mk_tokenSet_52_());
	private static long[] mk_tokenSet_53_()
	{
		long[] data = { 35883387679916016L, 7138235383808L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_53_ = new BitSet(mk_tokenSet_53_());
	private static long[] mk_tokenSet_54_()
	{
		long[] data = { 4400193994752L, 2097152L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_54_ = new BitSet(mk_tokenSet_54_());
	private static long[] mk_tokenSet_55_()
	{
		long[] data = { 2147483648L, 2097152L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_55_ = new BitSet(mk_tokenSet_55_());
	private static long[] mk_tokenSet_56_()
	{
		long[] data = { 35887805053796336L, 14680064L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_56_ = new BitSet(mk_tokenSet_56_());
	private static long[] mk_tokenSet_57_()
	{
		long[] data = { 35883387679784944L, 4194368L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_57_ = new BitSet(mk_tokenSet_57_());
	private static long[] mk_tokenSet_58_()
	{
		long[] data = { 35883405933543408L, 7138168537024L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_58_ = new BitSet(mk_tokenSet_58_());
	private static long[] mk_tokenSet_59_()
	{
		long[] data = { 0L, 289406976L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_59_ = new BitSet(mk_tokenSet_59_());
	private static long[] mk_tokenSet_60_()
	{
		long[] data = { 35883387679916016L, 7138151497728L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_60_ = new BitSet(mk_tokenSet_60_());
	private static long[] mk_tokenSet_61_()
	{
		long[] data = { 18253635584L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_61_ = new BitSet(mk_tokenSet_61_());
	private static long[] mk_tokenSet_62_()
	{
		long[] data = { 35883407007285232L, 14942080L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_62_ = new BitSet(mk_tokenSet_62_());
	private static long[] mk_tokenSet_63_()
	{
		long[] data = { 35883387679916016L, 8237747011584L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_63_ = new BitSet(mk_tokenSet_63_());
	private static long[] mk_tokenSet_64_()
	{
		long[] data = { 35883387679916016L, 8787502825472L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_64_ = new BitSet(mk_tokenSet_64_());
	private static long[] mk_tokenSet_65_()
	{
		long[] data = { -140980154007568L, 12844991L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_65_ = new BitSet(mk_tokenSet_65_());
	private static long[] mk_tokenSet_66_()
	{
		long[] data = { 9912784519168L, 72048797944905728L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_66_ = new BitSet(mk_tokenSet_66_());
	private static long[] mk_tokenSet_67_()
	{
		long[] data = { 150634166722560L, 72040001852932096L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_67_ = new BitSet(mk_tokenSet_67_());
	private static long[] mk_tokenSet_68_()
	{
		long[] data = { 9912784519170L, 72053196008194048L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_68_ = new BitSet(mk_tokenSet_68_());
	private static long[] mk_tokenSet_69_()
	{
		long[] data = { 9912784519170L, 72053195991416832L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_69_ = new BitSet(mk_tokenSet_69_());
	private static long[] mk_tokenSet_70_()
	{
		long[] data = { 9912784519170L, 72053196010291200L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_70_ = new BitSet(mk_tokenSet_70_());
	private static long[] mk_tokenSet_71_()
	{
		long[] data = { 8813272891392L, 4239716836704256L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_71_ = new BitSet(mk_tokenSet_71_());
	private static long[] mk_tokenSet_72_()
	{
		long[] data = { 8796093030400L, 4239716837752832L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_72_ = new BitSet(mk_tokenSet_72_());
	private static long[] mk_tokenSet_73_()
	{
		long[] data = { 8796093022208L, 4222124650659840L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_73_ = new BitSet(mk_tokenSet_73_());
	private static long[] mk_tokenSet_74_()
	{
		long[] data = { 8813272891392L, 40286106041712640L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_74_ = new BitSet(mk_tokenSet_74_());
	private static long[] mk_tokenSet_75_()
	{
		long[] data = { 8796093030400L, 40286106042761216L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_75_ = new BitSet(mk_tokenSet_75_());
	private static long[] mk_tokenSet_76_()
	{
		long[] data = { 8796093022208L, 40250921669623808L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_76_ = new BitSet(mk_tokenSet_76_());
	private static long[] mk_tokenSet_77_()
	{
		long[] data = { 8813272891392L, 40321290413801472L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_77_ = new BitSet(mk_tokenSet_77_());
	private static long[] mk_tokenSet_78_()
	{
		long[] data = { 8796093030400L, 40321290414850048L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_78_ = new BitSet(mk_tokenSet_78_());
	private static long[] mk_tokenSet_79_()
	{
		long[] data = { 8813272891392L, 71916856549572608L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_79_ = new BitSet(mk_tokenSet_79_());
	private static long[] mk_tokenSet_80_()
	{
		long[] data = { 8796093030400L, 71916856550621184L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_80_ = new BitSet(mk_tokenSet_80_());
	private static long[] mk_tokenSet_81_()
	{
		long[] data = { 8796093022208L, 71776119061217280L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_81_ = new BitSet(mk_tokenSet_81_());
	private static long[] mk_tokenSet_82_()
	{
		long[] data = { 9912784519168L, 4222124650659840L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_82_ = new BitSet(mk_tokenSet_82_());
	private static long[] mk_tokenSet_83_()
	{
		long[] data = { 150634166722560L, 4222124651708416L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_83_ = new BitSet(mk_tokenSet_83_());
	private static long[] mk_tokenSet_84_()
	{
		long[] data = { 9157850601332738L, -4899920792608571392L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_84_ = new BitSet(mk_tokenSet_84_());
	private static long[] mk_tokenSet_85_()
	{
		long[] data = { 9158039579893760L, -288247968337494016L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_85_ = new BitSet(mk_tokenSet_85_());
	private static long[] mk_tokenSet_86_()
	{
		long[] data = { 8796093022208L, 4239716836704256L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_86_ = new BitSet(mk_tokenSet_86_());
	private static long[] mk_tokenSet_87_()
	{
		long[] data = { 8796093022208L, 40286106041712640L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_87_ = new BitSet(mk_tokenSet_87_());
	private static long[] mk_tokenSet_88_()
	{
		long[] data = { 8796093022208L, 40321290413801472L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_88_ = new BitSet(mk_tokenSet_88_());
	private static long[] mk_tokenSet_89_()
	{
		long[] data = { 8796093022208L, 71916856549572608L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_89_ = new BitSet(mk_tokenSet_89_());
	private static long[] mk_tokenSet_90_()
	{
		long[] data = { 0L, 288230376160100352L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_90_ = new BitSet(mk_tokenSet_90_());
	private static long[] mk_tokenSet_91_()
	{
		long[] data = { 0L, 10485760L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_91_ = new BitSet(mk_tokenSet_91_());
	private static long[] mk_tokenSet_92_()
	{
		long[] data = { 9157850601332736L, -4899933986764881920L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_92_ = new BitSet(mk_tokenSet_92_());
	private static long[] mk_tokenSet_93_()
	{
		long[] data = { 9157850601332738L, -4899920792606474240L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_93_ = new BitSet(mk_tokenSet_93_());
	private static long[] mk_tokenSet_94_()
	{
		long[] data = { 8813272891392L, 4222124650921984L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_94_ = new BitSet(mk_tokenSet_94_());
	private static long[] mk_tokenSet_95_()
	{
		long[] data = { 8797166739456L, 4222124651970560L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_95_ = new BitSet(mk_tokenSet_95_());
	private static long[] mk_tokenSet_96_()
	{
		long[] data = { 8814346608640L, 238409305273925632L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_96_ = new BitSet(mk_tokenSet_96_());
	private static long[] mk_tokenSet_97_()
	{
		long[] data = { 8815420366848L, 238409305274974208L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_97_ = new BitSet(mk_tokenSet_97_());
	private static long[] mk_tokenSet_98_()
	{
		long[] data = { 149551834963968L, 4070972588166217728L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_98_ = new BitSet(mk_tokenSet_98_());
	private static long[] mk_tokenSet_99_()
	{
		long[] data = { 149552908722176L, 4070972588167266304L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_99_ = new BitSet(mk_tokenSet_99_());
	private static long[] mk_tokenSet_100_()
	{
		long[] data = { 8814346608640L, 4070972588166217728L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_100_ = new BitSet(mk_tokenSet_100_());
	private static long[] mk_tokenSet_101_()
	{
		long[] data = { 8815420366848L, 4070972588167266304L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_101_ = new BitSet(mk_tokenSet_101_());
	private static long[] mk_tokenSet_102_()
	{
		long[] data = { 8813272891392L, -5152399448688558080L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_102_ = new BitSet(mk_tokenSet_102_());
	private static long[] mk_tokenSet_103_()
	{
		long[] data = { 149534655094784L, -5152399448687509504L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_103_ = new BitSet(mk_tokenSet_103_());
	private static long[] mk_tokenSet_104_()
	{
		long[] data = { 26407606411264L, 4070972588167266304L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_104_ = new BitSet(mk_tokenSet_104_());
	private static long[] mk_tokenSet_105_()
	{
		long[] data = { 17179869184L, 2324138882699886592L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_105_ = new BitSet(mk_tokenSet_105_());
	private static long[] mk_tokenSet_106_()
	{
		long[] data = { 1073717248L, 2324138882700935168L, 6L, 0L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_106_ = new BitSet(mk_tokenSet_106_());
	private static long[] mk_tokenSet_107_()
	{
		long[] data = { 17179877376L, 2310065133864353792L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_107_ = new BitSet(mk_tokenSet_107_());
	private static long[] mk_tokenSet_108_()
	{
		long[] data = { 2199023263744L, 2310065133865402368L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_108_ = new BitSet(mk_tokenSet_108_());
	private static long[] mk_tokenSet_109_()
	{
		long[] data = { 8192L, 2323857407724224512L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_109_ = new BitSet(mk_tokenSet_109_());
	private static long[] mk_tokenSet_110_()
	{
		long[] data = { 9912784519168L, 72040001851883520L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_110_ = new BitSet(mk_tokenSet_110_());
	private static long[] mk_tokenSet_111_()
	{
		long[] data = { 9157850601332736L, -4899933986748104704L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_111_ = new BitSet(mk_tokenSet_111_());
	private static long[] mk_tokenSet_112_()
	{
		long[] data = { 8796093022208L, 238409305273925632L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_112_ = new BitSet(mk_tokenSet_112_());
	private static long[] mk_tokenSet_113_()
	{
		long[] data = { 8796093022208L, 4070972588166217728L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_113_ = new BitSet(mk_tokenSet_113_());
	private static long[] mk_tokenSet_114_()
	{
		long[] data = { 0L, 2310065133864353792L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_114_ = new BitSet(mk_tokenSet_114_());
	private static long[] mk_tokenSet_115_()
	{
		long[] data = { 8796093030400L, 4222124650921984L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_115_ = new BitSet(mk_tokenSet_115_());
	private static long[] mk_tokenSet_116_()
	{
		long[] data = { 8797166739456L, 238409305273925632L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_116_ = new BitSet(mk_tokenSet_116_());
	private static long[] mk_tokenSet_117_()
	{
		long[] data = { 2147483648L, 18874368L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_117_ = new BitSet(mk_tokenSet_117_());
	private static long[] mk_tokenSet_118_()
	{
		long[] data = { 149534655094784L, 4070972588166217728L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_118_ = new BitSet(mk_tokenSet_118_());
	private static long[] mk_tokenSet_119_()
	{
		long[] data = { 2200096997376L, 10485760L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_119_ = new BitSet(mk_tokenSet_119_());
	private static long[] mk_tokenSet_120_()
	{
		long[] data = { 224412016640L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_120_ = new BitSet(mk_tokenSet_120_());
	private static long[] mk_tokenSet_121_()
	{
		long[] data = { 19327344640L, 1048576L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_121_ = new BitSet(mk_tokenSet_121_());
	private static long[] mk_tokenSet_122_()
	{
		long[] data = { 1073717248L, 1048576L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_122_ = new BitSet(mk_tokenSet_122_());
	private static long[] mk_tokenSet_123_()
	{
		long[] data = { 4432406249472L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_123_ = new BitSet(mk_tokenSet_123_());
	private static long[] mk_tokenSet_124_()
	{
		long[] data = { 4434553733120L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_124_ = new BitSet(mk_tokenSet_124_());
	private static long[] mk_tokenSet_125_()
	{
		long[] data = { 8797166739456L, 4070972588166217728L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_125_ = new BitSet(mk_tokenSet_125_());
	private static long[] mk_tokenSet_126_()
	{
		long[] data = { 8813272899584L, 4222124650659840L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_126_ = new BitSet(mk_tokenSet_126_());
	private static long[] mk_tokenSet_127_()
	{
		long[] data = { 8796093030400L, 4222124662194176L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_127_ = new BitSet(mk_tokenSet_127_());
	private static long[] mk_tokenSet_128_()
	{
		long[] data = { 0L, 16777216L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_128_ = new BitSet(mk_tokenSet_128_());
	private static long[] mk_tokenSet_129_()
	{
		long[] data = { 8813272899584L, 4222124667437056L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_129_ = new BitSet(mk_tokenSet_129_());
	private static long[] mk_tokenSet_130_()
	{
		long[] data = { 8796093022208L, -5152399448688558080L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_130_ = new BitSet(mk_tokenSet_130_());
	private static long[] mk_tokenSet_131_()
	{
		long[] data = { 17610439671808L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_131_ = new BitSet(mk_tokenSet_131_());
	private static long[] mk_tokenSet_132_()
	{
		long[] data = { 1073717248L, 2324138882699886592L, 6L, 0L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_132_ = new BitSet(mk_tokenSet_132_());
	private static long[] mk_tokenSet_133_()
	{
		long[] data = { 18253627392L, 0L, 1L, 0L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_133_ = new BitSet(mk_tokenSet_133_());
	private static long[] mk_tokenSet_134_()
	{
		long[] data = { 2199023255552L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_134_ = new BitSet(mk_tokenSet_134_());
	private static long[] mk_tokenSet_135_()
	{
		long[] data = { 8192L, 2310065133864353792L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_135_ = new BitSet(mk_tokenSet_135_());
	private static long[] mk_tokenSet_136_()
	{
		long[] data = { 8192L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_136_ = new BitSet(mk_tokenSet_136_());
	private static long[] mk_tokenSet_137_()
	{
		long[] data = { 150651346591744L, -4899933986764881920L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_137_ = new BitSet(mk_tokenSet_137_());
	private static long[] mk_tokenSet_138_()
	{
		long[] data = { 150651346591744L, -4899933986748104704L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_138_ = new BitSet(mk_tokenSet_138_());
	private static long[] mk_tokenSet_139_()
	{
		long[] data = { 2147483648L, 16777216L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_139_ = new BitSet(mk_tokenSet_139_());
	private static long[] mk_tokenSet_140_()
	{
		long[] data = { 149551834963968L, -9223372036854775808L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_140_ = new BitSet(mk_tokenSet_140_());
	private static long[] mk_tokenSet_141_()
	{
		long[] data = { 149551834963968L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_141_ = new BitSet(mk_tokenSet_141_());
	private static long[] mk_tokenSet_142_()
	{
		long[] data = { 140756815699968L, 1048576L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_142_ = new BitSet(mk_tokenSet_142_());
	private static long[] mk_tokenSet_143_()
	{
		long[] data = { 8814346608640L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_143_ = new BitSet(mk_tokenSet_143_());
	private static long[] mk_tokenSet_144_()
	{
		long[] data = { 1073717248L, -9223372036853727232L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_144_ = new BitSet(mk_tokenSet_144_());
	private static long[] mk_tokenSet_145_()
	{
		long[] data = { 17611513389056L, 1048576L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_145_ = new BitSet(mk_tokenSet_145_());
	private static long[] mk_tokenSet_146_()
	{
		long[] data = { 149551834963968L, -9223372036837998592L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_146_ = new BitSet(mk_tokenSet_146_());
	private static long[] mk_tokenSet_147_()
	{
		long[] data = { 9895604649984L, 4222124650659840L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_147_ = new BitSet(mk_tokenSet_147_());
	private static long[] mk_tokenSet_148_()
	{
		long[] data = { 2235530493952L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_148_ = new BitSet(mk_tokenSet_148_());
	private static long[] mk_tokenSet_149_()
	{
		long[] data = { 36507222016L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_149_ = new BitSet(mk_tokenSet_149_());
	private static long[] mk_tokenSet_150_()
	{
		long[] data = { 9158056759762944L, -288247968337494016L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_150_ = new BitSet(mk_tokenSet_150_());
	private static long[] mk_tokenSet_151_()
	{
		long[] data = { 0L, 64L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_151_ = new BitSet(mk_tokenSet_151_());
	private static long[] mk_tokenSet_152_()
	{
		long[] data = { 2235530477568L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_152_ = new BitSet(mk_tokenSet_152_());
	private static long[] mk_tokenSet_153_()
	{
		long[] data = { -140978006523920L, 12844991L, 0L, 0L};
		return data;
	}
	public static readonly BitSet tokenSet_153_ = new BitSet(mk_tokenSet_153_());
	
}
}
