using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;

module Calc
{
  public class CMainForm : Form
  {
     mutable comma : bool;
     
     mainMenu1 : MainMenu;
     menuItem1 : MenuItem;
     menuItem2 : MenuItem;
     TWrite : TextBox ;
     BSeven : Button;
     BEight : Button;
     BNine : Button;
     BFour : Button;
     BFive : Button;
     BSix : Button;
     BOne : Button;
     BTwo : Button;
     BThree : Button;
     BZero : Button;
     BChangeSign : Button;
     BStop : Button;
     button5 : Button;
     button6 : Button;
     button7 : Button;
     button8 : Button;
     button14 : Button;
     button15 : Button;
     button16 : Button;
     button17 : Button;
     button18 : Button;
     button19 : Button;
     button20 : Button;
     BDel : Button;
     Bsin : Button;
     Bcos : Button;
     Btg : Button;
     Bctg : Button;
     Bpi : Button;
     B_e : Button;
     Bby : Button;
     Bpr : Button;
     Bminus : Button;
     Bplus : Button;
     Bis : Button;
     label1 : Label ;





     public this() 
     {
        //
        // zmienne kalkulatora
        //
        mutable current = 0.0;
        mutable buff = 0.0;
        mutable operation = 0;
        mutable mem = 0.0;
        mutable comma = false;

        //
        //kontrolki
        //
        this.mainMenu1 = System.Windows.Forms.MainMenu();
        this.menuItem1 = System.Windows.Forms.MenuItem();
        this.menuItem2 = System.Windows.Forms.MenuItem();
        this.TWrite = System.Windows.Forms.TextBox();
        this.BSeven = System.Windows.Forms.Button();
        this.BEight = System.Windows.Forms.Button();
        this.BNine = System.Windows.Forms.Button();
        this.BFour = System.Windows.Forms.Button();
        this.BFive = System.Windows.Forms.Button();
        this.BSix = System.Windows.Forms.Button();
        this.BOne = System.Windows.Forms.Button();
        this.BTwo = System.Windows.Forms.Button();
        this.BThree = System.Windows.Forms.Button();
        this.BZero = System.Windows.Forms.Button();
        this.BChangeSign = System.Windows.Forms.Button();
        this.BStop = System.Windows.Forms.Button();
        this.Bby = System.Windows.Forms.Button();
        this.Bpr = System.Windows.Forms.Button();
        this.Bminus = System.Windows.Forms.Button();
        this.Bplus = System.Windows.Forms.Button();
        this.button5 = System.Windows.Forms.Button();
        this.button6 = System.Windows.Forms.Button();
        this.button7 = System.Windows.Forms.Button();
        this.button8 = System.Windows.Forms.Button();
        this.Bsin = System.Windows.Forms.Button();
        this.Bcos = System.Windows.Forms.Button();
        this.Btg = System.Windows.Forms.Button();
        this.Bctg = System.Windows.Forms.Button();
        this.button14 = System.Windows.Forms.Button();
        this.button15 = System.Windows.Forms.Button();
        this.button16 = System.Windows.Forms.Button();
        this.button17 = System.Windows.Forms.Button();
        this.button18 = System.Windows.Forms.Button();
        this.button19 = System.Windows.Forms.Button();
        this.button20 = System.Windows.Forms.Button();
        this.Bpi = System.Windows.Forms.Button();
        this.B_e = System.Windows.Forms.Button();
        this.Bis = System.Windows.Forms.Button();
        this.BDel = System.Windows.Forms.Button();
        this.label1 = System.Windows.Forms.Label();

        // 
        // mainMenu1
        // menu programu
        //

        ignore (this.mainMenu1.MenuItems.Add(0,this.menuItem1));
        ignore (this.mainMenu1.MenuItems.Add(1,this.menuItem2));
        // 
        // menuItem1
        // 
        this.menuItem1.Index = 0;
        this.menuItem1.Text = "Close";
        this.menuItem1.Click += fun (_) {this.Close(); };
        // 
        // menuItem2
        // 
        this.menuItem2.Index = 1;
        this.menuItem2.Text = "Clear";
        this.menuItem2.Click += fun (_) {current = 0.0; TWrite.Text ="0"; mem = 0.0; };



        // 
        // TWrite
        // Wyswietlana liczbe
        // 

        this.TWrite.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
        this.TWrite.Location = System.Drawing.Point(0, 0);
        this.TWrite.Name = "TWrite";
        this.TWrite.ReadOnly = true;
        this.TWrite.Size = System.Drawing.Size(168, 20);
        this.TWrite.TabIndex = 0;
        this.TWrite.Text = "0";
        this.TWrite.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;


        // 
        // Przycisk 7
        // 

        this.BSeven.Location = System.Drawing.Point(0, 24);
        this.BSeven.Name = "BSeven";
        this.BSeven.Size = System.Drawing.Size(32, 24);
        this.BSeven.TabIndex = 1;
        this.BSeven.Text = "7";
        this.BSeven.Click += (fun (_, _) { ChangeCurrent("7"); });

        // 
        // Przycisk 8
        // 

        this.BEight.Location = System.Drawing.Point(32, 24);
        this.BEight.Name = "BEight";
        this.BEight.Size =  System.Drawing.Size(32, 24);
        this.BEight.TabIndex = 2;
        this.BEight.Text = "8";
        this.BEight.Click += (fun (_, _) { ChangeCurrent("8"); });

        // 
        // Przycisk 9
        // 

        this.BNine.Location = System.Drawing.Point(64, 24);
        this.BNine.Name = "BNine";
        this.BNine.Size = System.Drawing.Size(32, 24);
        this.BNine.TabIndex = 3;
        this.BNine.Text = "9";
        this.BNine.Click += (fun (_, _) { ChangeCurrent("9"); });

        // 
        // Przycisk 4
        // 

        this.BFour.Location = System.Drawing.Point(0, 48);
        this.BFour.Name = "BFour";
        this.BFour.Size = System.Drawing.Size(32, 24);
        this.BFour.TabIndex = 4;
        this.BFour.Text = "4";
        this.BFour.Click += (fun (_, _) { ChangeCurrent("4");  });

        // 
        // Przycisk 5
        // 

        this.BFive.Location = System.Drawing.Point(32, 48);
        this.BFive.Name = "BFive";
        this.BFive.Size =  System.Drawing.Size(32, 24);
        this.BFive.TabIndex = 5;
        this.BFive.Text = "5";
        this.BFive.Click += (fun (_, _) { ChangeCurrent("5"); });

        // 
        // Przycisk 6
        // 

        this.BSix.Location = System.Drawing.Point(64, 48);
        this.BSix.Name = "BSix";
        this.BSix.Size = System.Drawing.Size(32, 24);
        this.BSix.TabIndex = 6;
        this.BSix.Text = "6";
        this.BSix.Click += (fun (_, _) { ChangeCurrent("6"); });


        // 
        // Przycisk 1
        // 

        this.BOne.Location = System.Drawing.Point(0, 72);
        this.BOne.Name = "BOne";
        this.BOne.Size = System.Drawing.Size(32, 24);
        this.BOne.TabIndex = 7;
        this.BOne.Text = "1";
        this.BOne.Click += (fun (_, _) { ChangeCurrent("1"); });

        // 
        // Przycisk 2
        // 

        this.BTwo.Location = System.Drawing.Point(32, 72);
        this.BTwo.Name = "BTwo";
        this.BTwo.Size = System.Drawing.Size(32, 24);
        this.BTwo.TabIndex = 8;
        this.BTwo.Text = "2";
        this.BTwo.Click  += (fun (_, _) { ChangeCurrent("2"); });

        // 
        // Przycisk 3
        // 

        this.BThree.Location = System.Drawing.Point(64, 72);
        this.BThree.Name = "BThree";
        this.BThree.Size = System.Drawing.Size(32, 24);
        this.BThree.TabIndex = 9;
        this.BThree.Text = "3";
        this.BThree.Click += (fun (_, _) { ChangeCurrent("3"); });

        // 
        // Przycisk 0
        // 

        this.BZero.Location = System.Drawing.Point(0, 96);
        this.BZero.Name = "BZero";
        this.BZero.Size = System.Drawing.Size(32, 24);
        this.BZero.TabIndex = 10;
        this.BZero.Text = "0";
        this.BZero.Click += (fun (_, _) { ChangeCurrent("0"); });

        // 
        // Przycisk =
        // 

        this.Bis.Location = System.Drawing.Point(128, 96);
        this.Bis.Name = "Bis";
        this.Bis.Size = System.Drawing.Size(32, 24);
        this.Bis.TabIndex = 35;
        this.Bis.Text = "=";
        this.Bis.Click += (fun (_, _) {  
          current = convert_to_double(TWrite.Text);
          current = Dsolve(buff,operation,current);
          TWrite.Text = current.ToString();
          buff = 0.0;
        });

        // 
        // BChangeSign
        // zmiana znaku liczby
        // 

        this.BChangeSign.Location = System.Drawing.Point(32, 96);
        this.BChangeSign.Name = "BChangeSign";
        this.BChangeSign.Size = System.Drawing.Size(32, 24);
        this.BChangeSign.TabIndex = 11;
        this.BChangeSign.Text = "+/-";
        this.BChangeSign.Click += (fun (_, _) { 
          current = convert_to_double(TWrite.Text); 
          current =(current * (-1.0)); 
          TWrite.Text = current.ToString(); 
        }); 


        // 
        // BStop - przecinek
        // 

        this.BStop.Location = System.Drawing.Point(64, 96);
        this.BStop.Name = "BStop";
        this.BStop.Size = System.Drawing.Size(32, 24);
        this.BStop.TabIndex = 12;
        this.BStop.Text = ",";
        this.BStop.Click += (fun (_, _) { when (comma != true) { ChangeCurrent(","); comma = true; } });

        // 
        // Bby - mnozenie
        // 

        this.Bby.Location = System.Drawing.Point(96, 24);
        this.Bby.Name = "Bby";
        this.Bby.Size = System.Drawing.Size(32, 24);
        this.Bby.TabIndex = 13;
        this.Bby.Text = "*";
        this.Bby.Click += (fun (_, _) {
          current = convert_to_double(TWrite.Text);
          current = Dsolve(buff,operation,current);
          buff = current;
          current = 0.0;
          TWrite.Text = "0";
          operation = 1;
        });

        // 
        // Bpr - dzielenie
        // 

        this.Bpr.Location = System.Drawing.Point(96, 48);
        this.Bpr.Name = "Bpr";
        this.Bpr.Size = System.Drawing.Size(32, 24);
        this.Bpr.TabIndex = 14;
        this.Bpr.Text = "/";
        this.Bpr.Click += (fun (_, _) {
          current = convert_to_double(TWrite.Text);
          current = Dsolve(buff,operation,current);
          buff = current;
          current = 0.0;
          TWrite.Text = "0";
          operation = 2;
        });

        // 
        // Bminus
        // 

        this.Bminus.Location = System.Drawing.Point(96, 72);
        this.Bminus.Name = "Bminus";
        this.Bminus.Size = System.Drawing.Size(32, 24);
        this.Bminus.TabIndex = 15;
        this.Bminus.Text = "-";
        this.Bminus.Click += (fun (_, _) {
          current = convert_to_double(TWrite.Text);
          current = Dsolve(buff,operation,current);
          buff = current;
          current = 0.0;
          TWrite.Text = "0";
          operation = 4;
        });

        // 
        // Bplus
        // 

        this.Bplus.Location = System.Drawing.Point(96, 96);
        this.Bplus.Name = "Bplus";
        this.Bplus.Size = System.Drawing.Size(32, 24);
        this.Bplus.TabIndex = 16;
        this.Bplus.Text = "+";
        this.Bplus.Click += (fun (_, _) {
            current = convert_to_double(TWrite.Text);
          current = Dsolve(buff,operation,current);
          buff = current;
          current = 0.0;
          TWrite.Text = "0";
          operation = 3;
        });

        // 
        // button5 - pamiec (MC)
        // 

        this.button5.Location = System.Drawing.Point(168, 0);
        this.button5.Name = "button5";
        this.button5.Size = System.Drawing.Size(32, 24);
        this.button5.TabIndex = 17;
        this.button5.Text = "MC";
        this.button5.Click += fun (_) { mem = 0.0; };

        // 
        // button6 - pamiec (MR)
        // 

        this.button6.Location = System.Drawing.Point(200, 0);
        this.button6.Name = "button6";
        this.button6.Size = System.Drawing.Size(32, 24);
        this.button6.TabIndex = 18;
        this.button6.Text = "MR";
        this.button6.Click += fun (_) { current = mem; TWrite.Text = current.ToString(); };

        // 
        // button7 - pamiec (MS)
        // 

        this.button7.Location = System.Drawing.Point(232, 0);
        this.button7.Name = "button7";
        this.button7.Size = System.Drawing.Size(32, 24);
        this.button7.TabIndex = 19;
        this.button7.Text = "MS";
        this.button7.Click += fun (_) { current = convert_to_double(TWrite.Text); mem = current; };

        // 
        // button8 - pamiec (M+)
        // 

        this.button8.Location = System.Drawing.Point(264, 0);
        this.button8.Name = "button8";
        this.button8.Size = System.Drawing.Size(32, 24);
        this.button8.TabIndex = 20;
        this.button8.Text = "M+";
        this.button8.Click += fun (_) {
          current = convert_to_double(TWrite.Text);
          mem = current+mem;
        };

        // 
        // Bsin - sinus
        // 

        this.Bsin.Location = System.Drawing.Point(168, 24);
        this.Bsin.Name = "Bsin";
        this.Bsin.Size = System.Drawing.Size(32, 24);
        this.Bsin.TabIndex = 21;
        this.Bsin.Text = "sin";
        this.Bsin.Click  += fun (_) {
          current = convert_to_double(TWrite.Text);
          current = Math.Sin(current);
          TWrite.Text = current.ToString();
        };

        // 
        // Bcos - cosinus
        // 

        this.Bcos.Location = System.Drawing.Point(168, 48);
        this.Bcos.Name = "Bcos";
        this.Bcos.Size = System.Drawing.Size(32, 24);
        this.Bcos.TabIndex = 22;
        this.Bcos.Text = "cos";
        this.Bcos.Click += fun (_) {
          current = convert_to_double(TWrite.Text);
          current = Math.Cos(current);
          TWrite.Text = current.ToString();
        };

        // 
        // Btg - tangens
        // 

        this.Btg.Location = System.Drawing.Point(168, 72);
        this.Btg.Name = "Btg";
        this.Btg.Size = System.Drawing.Size(32, 24);
        this.Btg.TabIndex = 23;
        this.Btg.Text = "tg";
        this.Btg.Click  += fun (_) {
          current = convert_to_double(TWrite.Text);
          current = Math.Tan(current);
          TWrite.Text = current.ToString();
        };

        // 
        // Bctg - cosinush
        // 

        this.Bctg.Location = System.Drawing.Point(168, 96);
        this.Bctg.Name = "Bctg";
        this.Bctg.Size = System.Drawing.Size(32, 24);
        this.Bctg.TabIndex = 24;
        this.Bctg.Text = "cth";
        this.Bctg.Click  += fun (_) {
          current = convert_to_double(TWrite.Text);
          current = Math.Cosh(current);
          TWrite.Text = current.ToString();
        };


        // 
        // button14 = x^y
        // 

        this.button14.Location = System.Drawing.Point(200, 24);
        this.button14.Name = "button14";
        this.button14.Size = System.Drawing.Size(32, 24);
        this.button14.TabIndex = 26;
        this.button14.Text = "x^y";
        this.button14.Click += (fun (_, _) { 
          current = convert_to_double(TWrite.Text); 
          current = Dsolve(buff,operation,current); 
          buff = current; 
          current = 0.0; 
          TWrite.Text = "0"; 
          operation = 5; 
        });

        // 
        // button15 X*X
        // 

        this.button15.Location = System.Drawing.Point(200, 48);
        this.button15.Name = "button15";
        this.button15.Size = System.Drawing.Size(32, 24);
        this.button15.TabIndex = 27;
        this.button15.Text = "x^2";
        this.button15.Click += fun (_) {
           current = convert_to_double(TWrite.Text);
           current = Math.Pow(current,2.0);
           TWrite.Text = current.ToString()
         };

        // 
        // button16 x*x*x
        // 

        this.button16.Location = System.Drawing.Point(200, 72);
        this.button16.Name = "button16";
        this.button16.Size = System.Drawing.Size(32, 24);
        this.button16.TabIndex = 28;
        this.button16.Text = "x^3";
        this.button16.Click += fun (_) {
          current = convert_to_double(TWrite.Text);
          current = Math.Pow(current,3.0);
          TWrite.Text = current.ToString();
        };

        // 
        // button17 ln
        // 

        this.button17.Location = System.Drawing.Point(232, 24);
        this.button17.Name = "button17";
        this.button17.Size = System.Drawing.Size(32, 24);
        this.button17.TabIndex = 29;
        this.button17.Text = "ln";
        this.button17.Click += fun (_) {
          current = convert_to_double(TWrite.Text);
          current = Math.Log(current);
          TWrite.Text = current.ToString();
        };

        // 
        // button18
        // 

        this.button18.Location = System.Drawing.Point(232, 48);
        this.button18.Name = "button18";
        this.button18.Size = System.Drawing.Size(32, 24);
        this.button18.TabIndex = 30;
        this.button18.Text = "log";
        this.button18.Click += fun (_) {
          current = convert_to_double(TWrite.Text);
          current = Math.Log10(current);
          TWrite.Text = current.ToString();
        };

        // 
        // button19
        // 

        this.button19.Location = System.Drawing.Point(232, 72);
        this.button19.Name = "button19";
        this.button19.Size = System.Drawing.Size(32, 24);
        this.button19.TabIndex = 31;
        this.button19.Text = "1/x";
        this.button19.Click += fun (_) {
          current = convert_to_double(TWrite.Text);
          current = (System.Convert.ToDouble(1)/current);
          TWrite.Text = current.ToString();
        };

        // 
        // button20
        // 

        this.button20.Location = System.Drawing.Point(232, 96);
        this.button20.Name = "button20";
        this.button20.Size = System.Drawing.Size(32, 24);
        this.button20.TabIndex = 32;
        this.button20.Text = "x!";
        this.button20.Click += fun (_, _) { 
          current = Math.Floor(Math.Abs( convert_to_double(TWrite.Text)));
          mutable r=1.0;
          mutable i=1;
          for (i = 1; System.Convert.ToDouble(i) <= current;i = (i+1))
            r = r*System.Convert.ToDouble(i);
          current = r;
          TWrite.Text = current.ToString();
        };

        // 
        // Bpi
        // 

        this.Bpi.Location = System.Drawing.Point(264, 48);
        this.Bpi.Name = "Bpi";
        this.Bpi.Size = System.Drawing.Size(32, 24);
        this.Bpi.TabIndex = 33;
        this.Bpi.Text = "pi";
        this.Bpi.Click += fun (_) { current=Math.PI; TWrite.Text = current.ToString(); };

        // 
        // B_e
        // 

        this.B_e.Location = System.Drawing.Point(264, 24);
        this.B_e.Name = "B_e";
        this.B_e.Size = System.Drawing.Size(32, 24);
        this.B_e.TabIndex = 34;
        this.B_e.Text = "e";
        this.B_e.Click += fun (_) { current = Math.E; TWrite.Text = current.ToString(); };


        // 
        // BDel
        // 

        this.BDel.Location = System.Drawing.Point(128, 24);
        this.BDel.Name = "BDel";
        this.BDel.Size = System.Drawing.Size(32, 24);
        this.BDel.TabIndex = 41;
        this.BDel.Text = "Del";
        this.BDel.Click += fun (_) {   
          if (TWrite.Text.Length==1)
          {
            when (TWrite.Text[0].CompareTo('0') != 0)
            {
              TWrite.Text = "0";
            };
          } 
          else
          {
            when (TWrite.Text[TWrite.Text.Length-1].CompareTo(',') == 0)
            {
              comma = false;
            };
            TWrite.Text = TWrite.Text.Substring(0,TWrite.Text.Length-1);
          }; 
        };

        // 
        // label
        // 

        this.label1.Location = System.Drawing.Point(0, 120);
        this.label1.Name = "label1";
        this.label1.Size = System.Drawing.Size(216, 24);
        this.label1.TabIndex = 42;
        this.label1.Text = "Calculator Nemerle v. 1.01";

        // 
        // MainForm
        //

        this.AutoScaleBaseSize = System.Drawing.Size(5, 13);
        this.ClientSize = System.Drawing.Size(298, 139);
        this.Controls.Add(this.label1);
        this.Controls.Add(this.BDel);
        this.Controls.Add(this.Bis);
        this.Controls.Add(this.B_e);
        this.Controls.Add(this.Bpi);
        this.Controls.Add(this.button20);
        this.Controls.Add(this.button19);
        this.Controls.Add(this.button18);
        this.Controls.Add(this.button17);
        this.Controls.Add(this.button16);
        this.Controls.Add(this.button15);
        this.Controls.Add(this.button14);
        this.Controls.Add(this.Bctg);
        this.Controls.Add(this.Btg);
        this.Controls.Add(this.Bcos);
        this.Controls.Add(this.Bsin);
        this.Controls.Add(this.button8);
        this.Controls.Add(this.button7);
        this.Controls.Add(this.button6);
        this.Controls.Add(this.button5);
        this.Controls.Add(this.Bplus);
        this.Controls.Add(this.Bminus);
        this.Controls.Add(this.Bpr);
        this.Controls.Add(this.Bby);
        this.Controls.Add(this.BStop);
        this.Controls.Add(this.BChangeSign);
        this.Controls.Add(this.BZero);
        this.Controls.Add(this.BThree);
        this.Controls.Add(this.BTwo);
        this.Controls.Add(this.BOne);
        this.Controls.Add(this.BSix);
        this.Controls.Add(this.BFive);
        this.Controls.Add(this.BFour);
        this.Controls.Add(this.BNine);
        this.Controls.Add(this.BEight);
        this.Controls.Add(this.BSeven);
        this.Controls.Add(this.TWrite);
        this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
        this.MaximizeBox = false;
        this.Menu = this.mainMenu1;
        this.Name = "MainForm";
        this.Text = "Calculator";
    }


    Dsolve(a : double,q : int,b : double) : double
    {
      match (q)
      {
        | 1 =>  a * b;
        | 2 => 
          if (b != 0.0)
            {
              a/b;
            }
          else
            0.0;
              
        | 3 =>  a+b;
          
        | 4 => a-b;
        | 5 =>  Math.Pow(a,b);
        | _ => b;
      };

   }

   ChangeCurrent(x :string) :void
   {
      when (x == ".") {
        when (comma == false)
        {
           comma = true;
           TWrite.Text = TWrite.Text+".";
        };
      };
      when (x != "")  
      {
        TWrite.Text = TWrite.Text+x.ToString();
      };
 
      when (TWrite.Text[0].CompareTo('0') == 0)
        TWrite.Text = TWrite.Text.Substring(1,TWrite.Text.Length-1);
      when (TWrite.Text[0].CompareTo('.') == 0)
        TWrite.Text = "0" + TWrite.Text;

    }  

    convert_to_double(x : string) : double
    {
       mutable r = 0.0;
       mutable w_comma = true;
       mutable m = 1.0;
       mutable is_minus =0;
       mutable i = 0;
       mutable chr = 0.0;
       when (x[0].ToString() == "-")
         is_minus =1;
       mutable nc =0.0;

       for (i = 0+is_minus;x.Length>i;i=i +1)
       {
         match (x[i].ToString())
         {
            | "1" => nc = 1.0;
            | "2" => nc = 2.0;
            | "3" => nc = 3.0;
            | "4" => nc = 4.0;
            | "5" => nc = 5.0;
            | "6" => nc = 6.0;
            | "7" => nc = 7.0;
            | "8" => nc = 8.0;
            | "9" => nc = 9.0;
            | "0" => nc = 0.0;
            | "," => nc = 11.0;
            | _   => nc = 12.0;
         };
         //when (true) nc = 1.0;
         if (w_comma)
         {
           if (nc != 11.0)
           {
             chr = nc ;
             r = (r*10.0) + chr; 
           }
           else 
           {
             w_comma = false;
           }
         }
         else
         {
           chr = nc;
           r = r + (Math.Pow(0.1,m))*(chr);
           m = m+1.0;
         };
         when (w_comma)
         {
           comma = false;
         };
      };
      when (is_minus ==1)
      {
        r= r* (-1.0);
      };
      r
    }


    public static Main() : void
    {
       Application.Run( CMainForm())
    }
  }
}
