using System;
using System.Xml;
using System.IO;
using System.Text;
using System.Threading;
using System.Net.Sockets;
using Nemerle.Collections;

namespace Chat
{
    public class chatd
    {
        // CONSTRUCTOR
        public this(port : int)
        {
            this.mutex       = Mutex();
            this.users_table = Hashtable();
            this.port        = port
        }

        //PUBLIC METHODS

        public Run() : void
        {
            def server = open_connection();
            
            while(true)
            {
                def client = server.AcceptSocket();
                def handle_connection() : void
                {
                    def stream  = NetworkStream(client);
                    def request = receive(stream);
                    handle_Connect(request,stream);
                    add_to_lists(request);
                    mutable req = receive(stream);
                    try
                    {
                        while(handle_request(req))
                        {
                            req = receive(stream);
                        };
                    }
                    catch
                    {
                        | _ is XmlException => remove_from_lists(request);
                    }
                    //stream.Close()
                };
                def thread = Thread(ThreadStart(handle_connection));
                thread.Start()
            }
        }

        //PRIVATE METHODS

        private open_connection() : TcpListener
        {
            def server = TcpListener(port);
            server.Start();
            server
        }

        private add_to_lists(request : string) : void
        {
            def doc = XmlDocument();
            doc.LoadXml(request);
            def node = doc.SelectSingleNode("connect");
            foreach(s in users_table)
            {
                when(node.SelectSingleNode("login").InnerText != s.Key)
                {
                    ignore(mutex.WaitOne());
                    def add = AddUserToList(node.SelectSingleNode("login").InnerText);
                    add.Send(s.Value);
                    mutex.ReleaseMutex();
                }
            };
        }

        private remove_from_lists(request : string) : void
        {
            def doc = XmlDocument();
            doc.LoadXml(request);
            def node = doc.SelectSingleNode("connect");
            ignore(mutex.WaitOne());
            users_table.Remove(node.SelectSingleNode("login").InnerText);
            foreach(s in users_table)
            {
                def add = RemoveUserFromList(node.SelectSingleNode("login").InnerText);
                add.Send(s.Value);
            };
            mutex.ReleaseMutex();
        }
        
        private handle_request(request : string) : bool
        {
            def doc  = XmlDocument();
            doc.LoadXml(request);
            def nodes = doc.SelectNodes("message");
            when(nodes.Count==1)
            {
                foreach(s in users_table)
                {
                    when(nodes[0].SelectSingleNode("login").InnerText != s.Key)
                    {
                        ignore(mutex.WaitOne());
                        def message = Message(nodes[0].SelectSingleNode("login").InnerText,nodes[0].SelectSingleNode("message").InnerText);
                        message.Send(s.Value);
                        mutex.ReleaseMutex();
                    }
                };
            };
            true
        }
        
        private handle_Connect(request : string, stream : NetworkStream) : void
        {
            def doc  = XmlDocument();
            doc.LoadXml(request);
            def user = doc.SelectSingleNode("connect/login").InnerText;
            when(!users_table.Contains(user))
            {
                ignore(mutex.WaitOne());
                users_table.Add(user,stream);
                mutex.ReleaseMutex();
            }
            // get user list
            def user_list = SendUserList(users_table);
            user_list.Send(stream);   
        }

         private receive(stream : NetworkStream) : string
         {
             def buffer = array (1024);
             mutable msg               = string.Empty;
             mutable numberOfBytesRead = 0;
             
             numberOfBytesRead = stream.Read(buffer, 0, buffer.Length);  
             msg = 
             String.Concat(msg, Encoding.ASCII.GetString(buffer, 0, numberOfBytesRead));
             while(stream.DataAvailable)
             {
                 numberOfBytesRead = stream.Read(buffer, 0, buffer.Length);  
                 msg = 
                 String.Concat(msg, Encoding.ASCII.GetString(buffer, 0, numberOfBytesRead));
             };
             msg
         }
        
        //PRIVATE FIELDS
        
        private mutex       : Mutex;
        private port        : int;
        private users_table : Hashtable [string, NetworkStream];
    }
}

    
