using System;
using System.Data;
using System.Drawing;
using System.Threading;
using System.Windows.Forms;

using POP3Client;

namespace EraSMSSender
{
  public class SMSEdit : TabPage
  {
    protected mutable phoneLabel : Label;
    protected mutable phoneBox   : TextBox;

    protected mutable smsLabel   : Label;
    protected mutable smsBox     : RichTextBox;

    protected mutable sendButton : Button;
    protected mutable database   : AccountDatabase;

    protected mutable sender     : Thread;

    public event ChangeStatus    : EventHandler;

    public this (database : AccountDatabase)
    {
      base ("Edycja SMS-a");
      
      this.database     = database;
      this.phoneLabel   = Label ();
      this.phoneBox     = TextBox ();
      this.smsLabel     = Label ();
      this.smsBox       = RichTextBox ();
      this.sendButton   = Button ();
      this.sender       = null;
      this.ChangeStatus = null;
      
      sendButton.Text   = "Wyslij";
      sendButton.Dock   = DockStyle.Bottom;
      sendButton.Click += EventHandler (send_click);

      Controls.Add (sendButton);

      phoneLabel.Text     = "Numer telefonu:";
      phoneLabel.Location = Point (10, 10);
      phoneLabel.Size     = Size (90, 15);

      phoneBox.Location = Point (100, 10);
      phoneBox.Size     = Size (ClientSize.Width - 110, 15);
      phoneBox.Anchor   = (15 :> AnchorStyles);

      smsLabel.Text     = "Tresc SMS:";
      smsLabel.Location = Point (10, 40);
      smsLabel.Size     = Size (90, 15);

      smsBox.Location = Point (100, 40);
      smsBox.Size     = Size (ClientSize.Width - 110, ClientSize.Height - 50 - sendButton.Height);
      smsBox.Anchor   = (15 :> AnchorStyles);
      
      smsBox.TextChanged += EventHandler (smsBox_textChanged);

      Controls.Add (phoneLabel);
      Controls.Add (phoneBox);
      Controls.Add (smsLabel);
      Controls.Add (smsBox);
    }


    private send_click (_sender : object, _ea : EventArgs) : void
    {
      this.sender = Thread (ThreadStart (sendSMS));

      this.sender.Start ();
      this.sender.Name = "Sending SMS...";
    }
    

    private sendSMS () : void
    {
      if (smsBox.Text.Length == 0 || phoneBox.Text.Length == 0)
      {
        ignore (MessageBox.Show ("Co i do kogo?"));
      }
      else
      {
        mutable toSend = smsBox.Text;
        mutable need   = toSend.Length / 124 + 1;
        mutable number = 1;
        mutable result = DialogResult.Yes;

        if (need > database.Engines)
        {
          ignore (MessageBox.Show ("Nie masz wystarczajacej liczby kredytow."));
        }
        else
        {
          Parent.Enabled = false;

          do
          {
            mutable engine = database.GetEngine ();
            mutable sms    = String.Empty;

            if (ChangeStatus != null) ChangeStatus ("Wysylam SMSa numer: " + number.ToString (), null) else {};
        
            try
            {
              try
              {
                sms = toSend.Substring (0, 124);
              }
              catch
              {
                | _e => sms = toSend;
              };

              engine.SendSMS (phoneBox.Text, sms);
              database.Sent = 1;
              number = number + 1;

              try
              {
                toSend = toSend.Substring (124);
              }
              catch
              {
                | _e => toSend = String.Empty;
              };

              smsBox.Text = toSend;
            }
            catch
            {
              | e => result = MessageBox.Show (this, e.Message + "\r\nKontynuowac?", "Blad", MessageBoxButtons.YesNo);
            }

          }
          while (toSend.Length > 0 && result == DialogResult.Yes);

          Parent.Enabled = true;
        }
      }
    }


    private smsBox_textChanged (_sender : object, _ea : EventArgs) : void
    {
      if (ChangeStatus != null) ChangeStatus ("Liczba wiadomosci: " + (smsBox.Text.Length / 124 + 1).ToString () +
                      ", Liczba kredytow: " + database.Engines.ToString (), null) else {};
    }


  }


  public class Configuration : TabPage
  {
    public this ()
    {
      base ("Konfiguracja");
    }
  }


  class ListViewItemWithStatus : ListViewItem
  {
    public this (itemTabs : array [string])
    {
      base (itemTabs);
    }


    public ChangeStatus (status : object, _e : EventArgs) : void
    {
      SubItems[3].Text = (status :> string);
    }
  }
  

  public class Account : TabPage
  {
    protected mutable database : AccountDatabase;
    
    protected mutable contextMenu     : ContextMenu;
    protected mutable newMenu         : MenuItem;
    protected mutable editMenu        : MenuItem;
    protected mutable removeMenu      : MenuItem;
    protected mutable recognitionMenu : MenuItem;
    protected mutable regetMenu       : MenuItem;
    protected mutable orderMenu       : MenuItem;

    protected mutable accountsList    : ListView;


    public this (database : AccountDatabase)
    {
      base ("Konta");
    
      this.contextMenu     = ContextMenu ();
      this.newMenu         = MenuItem ("&Dodaj");
      this.editMenu        = MenuItem ("&Zmien");
      this.removeMenu      = MenuItem ("&Usun");
      this.recognitionMenu = MenuItem ("&Rozpoznaj");
      this.regetMenu       = MenuItem ("&Pobierz");
      this.orderMenu       = MenuItem ("Z&amow");
      this.accountsList    = ListView ();
    
      this.database = database;
      this.database.Load ();

      accountsList.Dock          = DockStyle.Fill;
      accountsList.View          = View.Details;
      accountsList.FullRowSelect = true;

      ignore (accountsList.Columns.Add ("Login", 100, HorizontalAlignment.Left));
      ignore (accountsList.Columns.Add ("Serwer", 100, HorizontalAlignment.Left));
      ignore (accountsList.Columns.Add ("Haslo", 100, HorizontalAlignment.Left));
      ignore (accountsList.Columns.Add ("Status", 220, HorizontalAlignment.Left));

      accountsList.ContextMenu       = contextMenu;
      accountsList.ContextMenu.Popup += EventHandler (popupMenu);

      newMenu.Click         += EventHandler (addNewItem);
      editMenu.Click        += EventHandler (editItem);
      removeMenu.Click      += EventHandler (removeItem);
      recognitionMenu.Click += EventHandler (recognizeItem);
      regetMenu.Click       += EventHandler (regetItem);
      orderMenu.Click       += EventHandler (orderItem);

      foreach (item :> AccountItem in database)
      {
        mutable lvi = ListViewItemWithStatus (array [item.Mail, item.Server, "***", String.Empty]);

        item.ChangeStatus += EventHandler (lvi.ChangeStatus);
        ignore (accountsList.Items.Add (lvi));
      };
      
      Controls.Add (accountsList);
    }


    private addNewItem (_sender : object, _ea : EventArgs) : void
    {
      mutable account = AccountForm ();

      ignore (account.ShowDialog (this));

      if (account.Accepted)
      {
        mutable lvi  = ListViewItemWithStatus (array [account.Mail, account.Server, "***", String.Empty]);
        mutable item =  AccountItem (account.Mail, account.Password, account.Server);

        item.ChangeStatus += EventHandler (lvi.ChangeStatus);
        
        database.Add (item);
        
        ignore (accountsList.Items.Add (lvi));
      }
      else {};
    }


    private editItem (_sender : object, _ea : EventArgs) : void
    {
      mutable mail     = accountsList.SelectedItems[0].SubItems[0].Text;
      mutable server   = accountsList.SelectedItems[0].SubItems[1].Text;
      mutable password = database.Get (mail, server).Password;
      mutable account  = AccountForm (AccountItem (mail, password, server));

      ignore (account.ShowDialog (this));

      if (account.Accepted)
      {
        accountsList.SelectedItems[0].SubItems[0].Text = account.Mail;
        accountsList.SelectedItems[0].SubItems[1].Text = account.Server;

        database.Get (mail, server).Server                   = account.Server;
        database.Get (mail, account.Server).Mail             = account.Mail;
        database.Get (account.Mail, account.Server).Password = account.Password;
      }
      else {};
    }
    
    
    private removeItem (_sender : object, _ea : EventArgs) : void
    {
      foreach (selected :> ListViewItemWithStatus in accountsList.SelectedItems)
      {
        database.Remove (selected.SubItems[0].Text, selected.SubItems[1].Text);
        accountsList.Items.Remove (selected);
      }
    }


    private recognizeItem (_sender : object, _ea : EventArgs) : void
    {
      mutable recognitionForm = RecognitionForm (database.Get (accountsList.SelectedItems[0].SubItems[0].Text,
                              accountsList.SelectedItems[0].SubItems[1].Text));

      ignore (recognitionForm.ShowDialog (this));
    }


    private regetItem (_sender : object, _ea : EventArgs) : void
    {
      mutable selected = accountsList.SelectedItems.Count;

      for (mutable i = 0; i < selected; i = i + 1)
      {
        database.Get (accountsList.SelectedItems[i].SubItems[0].Text,
          accountsList.SelectedItems[i].SubItems[1].Text).Check ();
      }
    }


    private orderItem (_sender : object, _ea : EventArgs) : void
    {
      mutable selected = accountsList.SelectedItems.Count;

      for (mutable i = 0; i < selected; i = i + 1)
      {
        database.Get (accountsList.SelectedItems[i].SubItems[0].Text,
          accountsList.SelectedItems[i].SubItems[1].Text).Order ();
      }
    }

    private popupMenu (_sender : object, _ea : EventArgs) : void
    {
      mutable selected        = accountsList.SelectedItems.Count;
      mutable allDisconnected = true;

      contextMenu.MenuItems.Clear ();

      ignore (contextMenu.MenuItems.Add (newMenu));

      if (selected > 0)
      {
        if (selected == 1)
        {
          if (database.Get (accountsList.SelectedItems[0].SubItems[0].Text,
            accountsList.SelectedItems[0].SubItems[1].Text).Unrecognized > 0)
          {
            ignore (contextMenu.MenuItems.Add (recognitionMenu));
          }
          else {};

          if (database.Get (accountsList.SelectedItems[0].SubItems[0].Text,
            accountsList.SelectedItems[0].SubItems[1].Text).Connected == false)
          {
            ignore (contextMenu.MenuItems.Add (editMenu));
          }
          else {};
        }
        else {};

        for (mutable i = 0; i < selected; i = i + 1)
        {
          if (database.Get (accountsList.SelectedItems[i].SubItems[0].Text,
            accountsList.SelectedItems[i].SubItems[1].Text).Connected == true) allDisconnected = false
          else {};
        };
            
        if (allDisconnected)
        {
          ignore (contextMenu.MenuItems.Add (regetMenu));
          ignore (contextMenu.MenuItems.Add (orderMenu));
          ignore (contextMenu.MenuItems.Add (removeMenu));
        }
        else {};
      }
      else {};
    }


    protected override Dispose (_disposing : bool) : void
    {
      Console.WriteLine ("Saving...");
      database.Save ();
    }

  }
  
  public class RecognitionForm : Form
  {
    protected mutable position   : int;
    protected mutable begin      : int;
    protected mutable item       : AccountItem;

    protected mutable statusBar  : StatusBar;
    protected mutable pictureBox : PictureBox;
    protected mutable textBox    : TextBox;

    protected mutable okButton   : Button;
    protected mutable nextButton : Button;
    protected mutable prevButton : Button;
    

    public this (item : AccountItem)
    {
      Prepare (item, if (item.Get (0).Recognized) item.Next (0) else 0);
    }
    

    public this (item : AccountItem, position : int)
    {
      Prepare (item, position);
    }


    private Prepare (item : AccountItem, pos : int) : void
    {
      position   = pos;
      begin      = 0;
      statusBar  = StatusBar ();
      pictureBox = PictureBox ();
      textBox    = TextBox ();
      okButton   = Button ();
      nextButton = Button ();
      prevButton = Button ();

      mutable size  = item.Get (0).PasswordImage.Size;
      this.item     = item;
      this.position = position;
      this.begin    = position;

      Text            = "Rozpoznawanie hasel";
      ClientSize      = Size (20 + size.Width, 140 + size.Height);
      MinimizeBox     = false;
      MaximizeBox     = false;
//      FormBorderStyle = FormBorderStyle.FixedDialog ();

      pictureBox.Location = Point (10, 10);
      pictureBox.Size     = size;

      textBox.Location    = Point (10, 30 + size.Height);
      textBox.Size        = Size (size.Width, 20);

      prevButton.Location = Point (10, 60 + size.Height);
      prevButton.Size     = Size (ClientSize.Width / 2 - 15, 20);
      prevButton.Text     = "&Poprzednie";

      nextButton.Location = Point (ClientSize.Width / 2 + 5, 60 + size.Height);
      nextButton.Size     = prevButton.Size;
      nextButton.Text     = "&Nastepne";

      okButton.Location   = Point (10, 90 + size.Height);
      okButton.Size       = Size (size.Width, 20);
      okButton.Text       = "&Akceptuj";

      statusBar.Dock      = DockStyle.Bottom;

      nextButton.Click += EventHandler (nextButtonClick);
      prevButton.Click += EventHandler (prevButtonClick);
      okButton.Click   += EventHandler (okButtonClick);
      
      Controls.Add (pictureBox);
      Controls.Add (textBox);
      Controls.Add (prevButton);
      Controls.Add (nextButton);
      Controls.Add (okButton);
      Controls.Add (statusBar);

      ShowImage ();
    }


    private ShowImage () : void
    {
      prevButton.Enabled = item.Prev (position) != -1;
      nextButton.Enabled = item.Next (position) != -1;

      pictureBox.Image    = item.Get (position).PasswordImage;
      textBox.Text        = item.Get (position).RecognizedPassword;
    }


    private Actualize () : void
    {
      if (!item.Get (position).RecognizedPassword.Equals (textBox.Text))
      {
        item.Get (position).RecognizedPassword = textBox.Text;
        item.Actualize ();

//        item[position].Test ();
      }
      else {};
    }


    private Test () : void
    {
      mutable position = 1;

      for (mutable i = if (item.Get (0).Recognized) item.Next (0) else 0; i != -1; i = item.Next (i))
      {
        if (item.Get (i).RecognizedPassword.Length > 0)
        {
          statusBar.Text = "Sprawdzanie hasla numer " + position.ToString () + "...";
          ignore (item.Get (i).Test ());

          position = position + 1;
        }
        else {};
      };

      statusBar.Text = String.Empty;

      item.Actualize ();
      Close ();
    }
    
    private nextButtonClick (_sender : object, _ea : EventArgs) : void
    {
      Actualize ();
      
      if (item.Next (position) != -1)
      {
        position = item.Next (position);
        ShowImage ();
      }
      else {};
    }

    private prevButtonClick (_sender : object, _ea : EventArgs) : void
    {
      Actualize ();

      if (item.Prev (position) != -1)
      {
        position = item.Prev (position);
        ShowImage ();
      }
      else {};
    }

    private okButtonClick (_sender : object, _ea : EventArgs) : void
    {
      mutable thread = Thread (ThreadStart (Test));

      okButton.Enabled   = false;
      nextButton.Enabled = false;
      prevButton.Enabled = false;

      Actualize ();
      
      thread.Start ();
    }
  }
  

  public class AccountForm : Form
  {
    protected mutable mail     : string;
    protected mutable password : string;
    protected mutable server   : string;
    
    protected mutable accepted : bool;
    
    protected mutable addButton          : Button;
    protected mutable cancelButton       : Button;

    protected mutable mailLabel          : Label;
    protected mutable mailBox            : TextBox;

    protected mutable serverLabel        : Label;
    protected mutable serverBox          : TextBox;

    protected mutable passwordLabel      : Label;
    protected mutable passwordBox        : TextBox;
    protected mutable passwordConfirmBox : TextBox;
    

    private Prepare () : void
    {
      accepted           = false;
      addButton          = Button ();
      cancelButton       = Button ();
      mailLabel          = Label ();
      mailBox            = TextBox ();
      serverLabel        = Label ();
      serverBox          = TextBox ();
      passwordLabel      = Label ();
      passwordBox        = TextBox ();
      passwordConfirmBox = TextBox ();
      
      Text            = "Nowe konto pocztowe";
      ClientSize      = Size (250, 250);
      MinimizeBox     = false;
      MaximizeBox     = false;
//      FormBorderStyle = FormBorderStyle.FixedDialog;      

      mailLabel.Text     = "Login:";
      mailLabel.Location = Point (10, 10);
      mailLabel.Size     = Size (90, 15);

      serverLabel.Text     = "Serwer:";
      serverLabel.Location = Point (10, 50);
      serverLabel.Size     = Size (90, 15);

      passwordLabel.Text     = "Haslo:";
      passwordLabel.Location = Point (10, 90);
      passwordLabel.Size     = Size (90, 15);

      mailBox.Location = Point (100, 10);
      mailBox.Size     = Size (ClientSize.Width - 110, 15);

      serverBox.Location = Point (100, 50);
      serverBox.Size     = mailBox.Size;
      
      passwordBox.Location     = Point (100, 90);
      passwordBox.PasswordChar = '*';
      passwordBox.Size         = mailBox.Size;

      passwordConfirmBox.Location     = Point (100, 120);
      passwordConfirmBox.PasswordChar = '*';
      passwordConfirmBox.Size         = mailBox.Size;

      addButton.Text     = "Dodaj";
      addButton.Location = Point (ClientSize.Width / 3 - 30, ClientSize.Height - 30);
      addButton.Size     = Size (60, 25);

      cancelButton.Text     = "Anuluj";
      cancelButton.Location = Point (ClientSize.Width * 2 / 3 - 30, ClientSize.Height - 30);
      cancelButton.Size     = Size (60, 25);

      addButton.Click += EventHandler (add_Event);
      
      Controls.Add (mailLabel);
      Controls.Add (mailBox);
      Controls.Add (serverLabel);
      Controls.Add (serverBox);
      Controls.Add (passwordLabel);
      Controls.Add (passwordBox);
      Controls.Add (passwordConfirmBox);
      Controls.Add (addButton);
      Controls.Add (cancelButton);

      CancelButton = cancelButton;
    }

    public this ()
    {
      Prepare ();
    }

    public this (item : AccountItem)
    {
      Prepare ();
      
      mailBox.Text            = item.Mail;
      passwordBox.Text        = item.Password;
      passwordConfirmBox.Text = item.Password;
      serverBox.Text          = item.Server;
      addButton.Text          = "&Zmien";
    }


    private check () : bool
    {
      if (mailBox.Text.Length == 0 || mailBox.Text.IndexOfAny ("@".ToCharArray ()) >= 0)
      {
        ignore (MessageBox.Show ("Wprowadzony adres wydaje sie byc nieprawidlowy.", Text));
        false;
      }
      else
      {
        if (!passwordConfirmBox.Text.Equals (passwordBox.Text))
        {
          ignore (MessageBox.Show ("Wprowadzone hasla rozni sie.", Text));
          false;
        }
        else true;
      }

    }
    
    private add_Event (_sender : object, _ea : EventArgs) : void
    {
      if (check ())
      {
        accepted = true;
        mail     = mailBox.Text;
        password = passwordBox.Text;
        server   = serverBox.Text;

        Dispose ();
      }
      else {};
    }
    

    public Mail : string
    {
      get { mail }
    }


    public Password : string
    {
      get { password }
    }


    public Server : string
    {
      get { server }
    }


    public Accepted : bool
    {
      get { accepted }
    }
  }
  

  public class EraSMSSender : Form
  {
    protected mutable database  : AccountDatabase;
    protected mutable statusBar : StatusBar;

    protected mutable tabs          : TabControl;
    protected mutable smsEdit       : SMSEdit;
    protected mutable configuration : Configuration;
    protected mutable accounts      : Account;

    protected mutable version : string;

    public this ()
    {
      version       = "0.1";
      database      = AccountDatabase ();
      statusBar     = StatusBar ();
      tabs          = TabControl ();
      configuration = Configuration ();

      smsEdit       = SMSEdit (database);
      accounts      = Account (database);

      Text        = "Melon Era SMS Sender " + version;
      ClientSize  = Size (550, 350);
      MinimumSize = this.Size;

      statusBar.Dock = DockStyle.Bottom;

      smsEdit.ChangeStatus += EventHandler (Inform);

      Controls.Add (statusBar);

      //---
      
      tabs.SelectedIndex = 0;
      tabs.TabIndex      = 0;

      tabs.Anchor = (15 :> AnchorStyles);
      tabs.Size   = Size (Point (this.ClientSize.Width, this.ClientSize.Height - statusBar.Size.Height));

      tabs.TabPages.Add (smsEdit);
      tabs.TabPages.Add (accounts);
      tabs.TabPages.Add (configuration);

      Controls.Add (tabs);
    }


    private Inform (information : object, _e : EventArgs) : void
    {
      statusBar.Text = (information :> string);
    }
    

/*    private override Dispose (disposing : bool) : void
    {
      if (disposing == true)
      {
        {};
      }
      else {};
      
      (this :> Form).Dispose ();
    }
*/
  }
}
