using System;
using System.Collections.Specialized;

namespace POP3Client
{
  public class Encoder
  {
  /*
    private static FromBase64 (base64 : char) : byte
    {
      if (Char.IsUpper (base64)) (base64 :> byte) - (65 :> byte)
      else if (Char.IsLower (base64)) (base64 :> byte) - (71 :> byte)
      else if (Char.IsDigit (base64)) (base64 :> byte) + (4 :> byte)
      else if (base64 == '+') (62 :> byte)
      else if (base64 == '/') (63 :> byte)
      else (0 :> byte);
    }
    */

    public static FromBase64 (base64 : string) : array [byte]
    {
      Convert.FromBase64String (base64);
    }

    public static FromQuotedPrintable (base64 : string) : array [byte]
    {
      mutable result   = array (base64.Length);
      mutable position = 0;

      for (mutable i = 0; i < base64.Length; i = i + 1)
      {
        if (base64[i] == '=')
        {
          mutable hex = String (array  [base64[i+1],base64[i+2]]);

          if (!hex.Equals ("\r\n"))
          {
            result[position] = Byte.Parse (hex, System.Globalization.NumberStyles.HexNumber);
            position         = position + 1;
            i                = i + 2;
          }
          else {};
        }
        else
        {
          result[position] = (base64[i] :> byte);
          position         = position + 1;
        };
      };

      mutable tmp = array (position);

      Array.Copy (result, tmp, position);

      tmp;
    }
  }
}
