using Nemerle.IO;

  interface IComparab ['a] {
    CompareTo (_ : 'a) : int;
  }


    variant Node ['a] where 'a : IComparab ['a] {
      | Red {
          key : 'a;
          lchild : Node ['a];
          rchild : Node ['a]; 
        }
      | Black {
          key : 'a;
          lchild : Node ['a];
          rchild : Node ['a]; 
        }
      | Leaf
    }
  
  class D ['a] : IComparab ['a] where 'a : IComparab ['a] {
    public CompareTo (_ : 'a) : int { 1 }
  }


class A : System.IComparable {
  public CompareTo (_ : object) : int {
    0
  }
}

class B : System.IComparable [B] {
  public CompareTo (_ : B) : int {
    0
  }
}


namespace SystemActionVsAction {
  using System;
  
  public variant Action {
    | B
    | C
  }
  
  public module M {
    public foo (x : Action) : void {
      _ = x is Action.B
    }
  }
}


class C {
  public this (_ : int) { }
}
class C ['a] {
  public mutable x : 'a;
}

def x = C(1);
def y = C();
y.x = "a";

printf ("x=%s y=%s y.x=%s\n", x.GetType ().Name, y.GetType ().Name, y.x);

/*
BEGIN-OUTPUT
x=C y=C`1 y.x=a
END-OUTPUT
*/
