
using Nemerle.IO;
variant X { | Y | Z }
type Q = X.Y;

public class Calculation
{
  public static constValue : decimal = .02M;

  public static TestDecimal () : void
  {
    mutable at33 = 0 :> decimal;
    at33 = 60000M - 38000M;
    at33 = constValue;
    print(at33.ToString (System.Globalization.CultureInfo.InvariantCulture) + "\n");
    print((1.0M :> int).ToString () + "\n");
  }
}

namespace Str {
   struct A {
     mutable x : int;

     public Ambient : int { get { x } set { x = value; } }
     public set_x (y : int) : void
     {
       x = y;
     }
     public qux () : void
     {
       set_x (42);
     }
   }

    public class ArrayTest
    {
        public static xain() : void
        {
            def materials = (array (1) : array [A]);
            System.Console.WriteLine(materials[0].Ambient);
            materials[0].Ambient = 255;
            System.Console.WriteLine(materials[0].Ambient);

            def mat = materials[0];
            System.Console.WriteLine(mat.Ambient);
            mat.Ambient = 133;
            System.Console.WriteLine(mat.Ambient);
            materials[0] = mat;
            System.Console.WriteLine(materials[0].Ambient);
            materials[0].qux ();
            System.Console.WriteLine(materials[0].Ambient);
        }
    }
}

namespace Bug509 {
  class B {
     x:array[2, int] * int;
  }
  
  class B2 {
    x:A*int;
  }

  enum A { }
}

module BasicValueTypesTest
{    
  TestFloat () : void
  {
    printf ("%lf\n", 0.0);
    printf ("%lf\n", 123.345);
    printf ("%lf\n", .345);
    printf ("%lf\n", 1e20);
    printf ("%lf", 12.34E-10 / 23.2 * 10242.3 + 5.4);
    if (-0.5 > -0.6)
      System.Console.WriteLine ("OK")
    else
      System.Console.WriteLine ("nie zdales numerkow");
    printf ("%lf\n", 1.5 + 0.5);
    if (0.3 - 0.2 == 0.1)
      System.Console.WriteLine (".NET nie zdal numerkow")
    else
      System.Console.WriteLine ("a jednak to prawda");

    def _ = 5 : object;
    def x = (4 * 1) :> double + 5.4;
    printf ("%lf\n", x);
    def x = 4 :> float + 5 :> float;
    printf ("%f\n", x);
  }

  TestDecimal () : void
  {
    def x = 1234567890123456789069m;

    System.Console.WriteLine ("{0}", x)
  }

  immut_x : int;
  this () { immut_x = 3 }

  TestOverflow () : void {
    def trycatch (f : void -> void) {
      try {
        f ();
      }
      catch {
        | _ is System.OverflowException => printf ("OverflowException\n")
      }
    }
    trycatch (fun () {
      def x = System.Int64.MinValue;
      _ = x - 1L;
    });
    
    trycatch (fun () {
      mutable x = System.Byte.MaxValue;
      ++x;
    });
    trycatch (fun () {
      mutable x = System.SByte.MaxValue;
      ++x;
    });
    trycatch (fun () {
      mutable x = System.Int16.MaxValue;
      ++x;
    });
    trycatch (fun () {
      mutable x = System.UInt16.MaxValue;
      ++x;
    });
    
    trycatch (fun () {
      mutable x = System.Byte.MinValue;
      --x;
      print ("Byte");
    });
    trycatch (fun () {
      mutable x = System.SByte.MinValue;
      --x;
      print ("SByte");
    });
    trycatch (fun () {
      mutable x = System.Int16.MinValue;
      --x;
      print ("Int16");
    });
    trycatch (fun () {
      mutable x = System.UInt16.MinValue;
      --x;
      print ("UInt16");
    });
  }

  TestInt () : void
  {
    mutable x = (123 : int);
    mutable y = (321 : System.Int32);
      
    y = x;    
      
    System.Console.WriteLine ("{0} {1} {2}",
                              int.Parse ("132"), System.Int32.Parse ("132"), y);
                                
    def t1 = 10 | 12;
    def t2 = 10 & 12;
    System.Console.WriteLine ("{0} {1}", t1, t2);
    assert (252b == System.Convert.ToByte (252));


    // LET'S ROCK WITH NUMBERS
    System.Console.WriteLine ("{0} {1} {2}",
                              254b, -23sb, 30000s);
    System.Console.WriteLine ("{0} {1} {2}",                                
                              60000us, 2000000000, 4000000000u);
                                
    System.Console.WriteLine ("{0} {1} {2}",
                              -30000s, -2000000000, 9223372036854775807l);
                                
    System.Console.WriteLine ("{0} {1} {2}",                                
                              -9223372036854775807l, 10223372036854780000ul,
                              435345ul);

    System.Console.WriteLine ("{0} {1} {2}",
                              -9223372036854775807l,
                              -2147483648, -9223372036854775808);

    System.Console.WriteLine ("{0} {1} {2}",
                              0b1110, 0xff00l, 0o777);
    System.Console.WriteLine ("{0} {1} {2}",
                              0b, 0xbub, 0o666);
    printf ("%ld\n", -1 :> long);

    def zero = int ();
    when (zero == 0)
      printf ("great\n")
  }
  
  TestChar () : void {
      _ = ( 0 :> char);
      _ = ( char.MinValue);
      _ = ( char.MaxValue :> char); // W: there is no check needed to cast char to char
  }

  public Main () : void
  {
    TestFloat ();
    TestDecimal ();
    TestInt ();
    TestOverflow ();
    Calculation.TestDecimal ();
    Str.ArrayTest.xain ();
    TestChar ();
  }
}

/*
BEGIN-OUTPUT
0
123.345
0.345
1E+20
5.40000054478441OK
2
a jednak to prawda
9.4
9
1234567890123456789069
132 132 123
14 8
254 -23 30000
60000 2000000000 4000000000
-30000 -2000000000 9223372036854775807
-9223372036854775807 10223372036854780000 435345
-9223372036854775807 -2147483648 -9223372036854775808
14 65280 511
0 11 438
-1
great
OverflowException
OverflowException
OverflowException
OverflowException
OverflowException
OverflowException
OverflowException
OverflowException
OverflowException
0.02
1
0
255
255
133
133
42
END-OUTPUT
*/
