using Nemerle.IO;
using Nemerle.Text;  // imports regexp syntax extension
using Nemerle.Extensions;
using Nemerle.Collections;

class ClassForColors {
  x : int = 66;
  public foo () : void {
      print ("----- Test colors and environments ------\n");
      print ("bla $x bla\n")
  }
}

variant A {
    | B
    | C
    | D
}

variant SimpleVariant {
  | Var1 { x : string; }
  | Var2 { x : string; }
}

namespace Bug507 {
  interface IMyEnu ['a] : System.Collections.Generic.ICollection ['a] { }

  class A {
    foo () : IMyEnu [string * string] { null }

    faa () : void {
      foreach (x in (foo () : System.Collections.Generic.ICollection [string * string])) {
        def (a, b) = x;
        _ = a + "" + b;
      }

      foreach (x in foo ()) {
        def (a, b) = x;
        _ = a + "" + b;
      }
    }
  }
}

module BasicMacrosTest
{
  silnia (n : int) : int
  {
    if (n > 0 && silnia (n-1) > 0 ) 
      n * silnia (n-1)
    else 
      n
  }

  TestRepeat () : void
  {
    print ("----- Test repeat ------\n");
    repeat (5) print ("a");
    repeat (-1) print ("zle");
    repeat (1) print ("\n");
  }

  TestLazyAndAndOrOr () : void
  {
    printf ("----- Lazy && and || -----\n");

    if (true || false) printf ("OK\n") else printf ("FAILED\n");
    if (true && false) printf ("FAILED\n") else printf ("OK\n");
    if (true && false && true) printf ("FAILED\n") else printf ("OK\n");
    if ((true && false) || true) printf ("OK\n") else printf ("FAILED\n");
    def b1 = ((true && false) || true) && false;
    if (b1 && true) printf ("FAILED\n") else printf ("OK\n");
    printf ("%d\n", silnia (5))
  }

  make (s : string) : void
  {
    regexp match (s) {
      | "a+.*" => printf ("a\n");
      | @"(?<num : int>\d+)-\w+" => printf ("%d\n", num + 3);
      | "(?<name>(Ala|Kasia))? ma kota" =>
        match (name) {
          | Some (n) => printf ("%s\n", n)
          | None => printf ("noname?\n")
        }
      | _ => printf ("default\n");
    }
  }

  TestRegexpMatch () : void 
  {
    printf ("----- Regexp match -----\n");    

    make ("aaaaa");
    make ("bbbbbla");
    make ("c");
    make ("23432-334");
    make ("22-");
    make (" ma kota");
    make ("Ala ma kota");
  }


  TestSelectFromTuple () : void
  {
    printf ("----- Select from tuple -----\n");
    
    def a = ("a","b","c","d","e","f","g");
    def b = SelectFromTuple (4, 7, a);
    printf ("%s\n", b);

    def decompose['a] (l : list ['a]) : 'a * 'a {
      (List.Head (l), List.Last (l))
    };
    def tp = TupleMap (decompose, ([3,2,7], ["gfd", "e3rr", "b2"]));
    def ((a,b), (c,d)) = tp;
    printf ("%d %d %s %s\n", a, b, c, d);

    def tup = (1, "aa", System.Text.StringBuilder ("bb"));
    PrintTuple (tup, 3);
    PrintTupleTyped (tup);
  }

  public class Disposable : System.IDisposable
  {
    public this() {}

    private Dispose() : void
      implements System.IDisposable.Dispose
    {
      System.Console.WriteLine ("Disposing.")
    }
  }
  
  class Disposer : System.IDisposable
  {
    str : string;

    public this (str : string, _ : Disposer)
    {
      this (str);
    }
    
    public this (str : string) 
    {
      printf ("I'm being created - %s\n", str);
      this.str = str;
    }
    
    public Dispose () : void 
    {
      printf ("I'm being disposed of - %s\n", this.str)
    }
  }

  TestUsing () : void
  { 
    printf("----- Test using -----\n");
    using (a = Disposer("one"), Disposer("two", a), c = Disposer("three")) {
      printf("Inside\n");
    };
    using(def x = Disposable()) {};

    def y = Disposable();
    using(y) {};
  }

  sealed class FE_NotDisposable
  {
    mutable first : bool = false;
    public MoveNext () : bool { if (first) false else { first = true; true } }
    public Current : int { get { 1 } }
  }

  class FE_Disposable : System.IDisposable
  {
    mutable first : bool = false;
    public Dispose () : void { }
    public MoveNext () : bool { if (first) false else { first = true; true } }
    public Current : int { get { 2 } }
  }
  
  class EWithNotDisposable {
    public GetEnumerator () : FE_NotDisposable { FE_NotDisposable () }
  }

  class EWithDisposable {
    public GetEnumerator () : FE_Disposable { FE_Disposable () }
  }

  class Enu : System.Collections.IEnumerable, System.Collections.IEnumerator {
    mutable first : bool = false;
    public MoveNext () : bool { if (first) false else { first = true; true } }
    public Current : int { get { 3 } }
    public Reset () : void { } 
    public bla () : Enu implements System.Collections.IEnumerable.GetEnumerator { this }
  }

  test_foreach () : void
  {
    foreach (x in EWithNotDisposable ()) { print ("$x ") }
    printf ("\n");
    foreach (x in EWithDisposable ()) { print ("$x ") }
    printf ("\n");

    foreach (x in Enu ()) { print ("$x ") }
    printf ("\n");

    foreach (x in [77, 88, 99]) { print ("$x ") }
    printf ("\n");

    foreach (x in ([0] : list [int].Cons)) { print ("$x ") }
    printf ("\n");

    def a = array .[3] [ [ [1, 2], [3, 4] ], [ [5, 6], [7, 8] ] ];
    foreach (x in a) { print ("$x ") };
    printf ("\n");

    try {
      def c = System.Collections.ArrayList ();
      def _ = c.Add ("bb");
      foreach (x :> int in c) {
        print (x.ToString ());
      }
    }
    catch {
      | _ is System.InvalidCastException => print ("invalid cast occured, ok!\n")
    }

    def a = [SimpleVariant.Var1 ("var1"), SimpleVariant.Var2 ("var2"),
             SimpleVariant.Var1 ("var1")];
    foreach (SimpleVariant.Var1 (str) in a) print (str);
    print ("\n");

    def bul = System.Text.StringBuilder ("");
    foreach (x in array [1,2,3]) {
      bul.Append (x.ToString()); // W: ignored
    }
    print (bul.ToString ());
    print ("\n");

    def objlist = ["3444", "44444"] : list [object];
    foreach (y :> string in objlist) {
      System.Console.WriteLine (y);
    }

    foreach (x in [A.B(), A.C(), A.D()]) {
      | A.B => Nemerle.IO.print ("B\n");
      | A.C => Nemerle.IO.print ("C\n");
      | A.D => Nemerle.IO.print ("D\n");
    }
    foreach ((x, y) in [(A.B(), A.C()), (A.D(), A.B())]) {
      | (A.B, A.C) => Nemerle.IO.print ("BC\n");
      | (A.D, A.B) => Nemerle.IO.print ("DB\n");
      | _ => Nemerle.IO.print ("other\n");
    }
  }

  TestFor () : void {
    printf ("----- Test for -----\n");

    for (mutable i = 0; i < 5; ++i) {
      mutable j = 1;
      while (j == 1) {
        printf("for %d\n", i);
        j = 0;
      }
    };
    for (mutable j = 3; j > 0; --j) {
      printf ("f %d\n", j);
    };
    
    mutable varia = false;
    for (;!varia;) { printf ("varia\n"); varia = true; }
  }


  TestForEach () : void
  {
    printf ("----- Test foreach -----\n");
    
    mutable i1 = 3;
    def loop () { printf ("I have colorful dreams!\n"); };
    
    while (i1 > 0) { printf ("%d\n", i1); --i1; loop (); };

    def arr = array (5);
    arr[3] = 4;
    foreach (i : int in arr) {
      printf ("%d", i + 1);
    };
    def f () { printf ("dd "); };
    def g () { printf ("gg\n"); };
    def arr = array [f, g];
    foreach (str : void -> void in arr) str ();

    test_foreach ();

    def foo (l) {
      foreach (elem in l)
        System.Console.WriteLine (elem);
    }
    foo ([1,2]);
  }

  TestCSharp3_0Lambda () : void {
    printf ("----- Test C# 3.0's lambda expression syntax -----\n");
    [1,2,4].Iter (x => System.Console.WriteLine (x));
    def add = (x,y) => x + y;
    System.Console.WriteLine (add (1,2));
    def add = (x : string, y) => x + y;
    System.Console.WriteLine (add ("1","2"));
    def one = x : string => x.Substring (1);
    System.Console.WriteLine (one ("aaa"));    
    def brace = x => { x + 1 };
    System.Console.WriteLine (brace (1));    
    def one = (x : int) => x + 1;
    System.Console.WriteLine (one(1));
    when ([2,4].ForAll (x => x % 2 == 0)) 
      System.Console.WriteLine ("All : even");
    def add : int -> int -> int = x => y => x + y;    
    def add_5 = add (5);
    System.Console.WriteLine (add_5 (2));    
  }
  

  Main () : void
  {
    TestLazyAndAndOrOr ();
    TestRegexpMatch ();
    TestSelectFromTuple ();
    TestUsing ();
    TestFor ();
    TestForEach ();
    TestRepeat ();
    ClassForColors ().foo ();
    TestCSharp3_0Lambda ();
  }
}

/*
BEGIN-OUTPUT
----- Lazy && and || -----
OK
OK
OK
OK
OK
120
----- Regexp match -----
a
default
default
23435
default
noname?
Ala
----- Select from tuple -----
d
3 7 gfd b2
1
aa
bb
1
aa
bb
----- Test using -----
I'm being created - one
I'm being created - two
I'm being created - three
Inside
I'm being disposed of - three
I'm being disposed of - two
I'm being disposed of - one
Disposing.
Disposing.
----- Test for -----
for 0
for 1
for 2
for 3
for 4
f 3
f 2
f 1
varia
----- Test foreach -----
3
I have colorful dreams!
2
I have colorful dreams!
1
I have colorful dreams!
11151dd gg
1 
2 
3 
77 88 99 
0 
1 2 3 4 5 6 7 8 
invalid cast occured, ok!
var1var1
123
3444
44444
B
C
D
BC
DB
1
2
----- Test repeat ------
aaaaa
----- Test colors and environments ------
bla 66 bla
----- Test C# 3.0's lambda expression syntax -----
1
2
4
3
12
aa
2
2
All : even
7
END-OUTPUT
*/
