//
// Test for bug reported on the list.  The bug was that the 
// compiler was generating copies of the static variable, before
// passing it.  A trick that we do for readonly variables
using System;

namespace BadRefTest
{

public class CtorInc
{
	static  mutable  x : int;
	static  mutable  y : int;

	static IncByRef( i : ref int) :  int {  ({ def _tmp = i; ++i; _tmp }); }

	public this() { _ = IncByRef(ref x); ++y; }

	public static Results( total : int) :  bool
	{
		Console.WriteLine("CtorInc test {0}: x == {1}, y == {2}",if (
				x == y && x == total) "passed"else  "failed", x, y);

		 x == y && x == total;
	}
}

public class Runner
{
	public static Main() :  int
	{
		mutable  i = 0;
		for (; i < 5; i++)
		{
			mutable  _t =  CtorInc(); ()
		}
		if ( CtorInc.Results(i)) 0 else  1;
	}

}
}
/*
BEGIN-OUTPUT
CtorInc test passed: x == 5, y == 5
END-OUTPUT
*/
