using Nemerle.Diagnostics;

namespace a {

variant A {
  | X1
  | X2
  | X3
  | X1a
  | X2a
  | X3a
  | X1b
  | X2b
  | X3b
  | X1c
  | X2c
  | X3c
  | X1ac
  | X2ac
  | X3ac
  | X1bc
  | X2bc
  | X3bc
}

module Test {
  test_it (max : int) : void
  {
    def ar = array [A.X1(), A.X2(), A.X3(), A.X1a(), A.X2a(), A.X3a(), A.X1b(), A.X2b(), A.X3b(), A.X1c(),
                    A.X2c(), A.X3c(), A.X1ac(), A.X2ac(), A.X3ac(), A.X1bc(), A.X2bc(), A.X3bc()];

    mutable res = 0;

    for (mutable i = 0; i < max; ++i) {
      def obj = ar [i % ar.Length];
      match (obj : A) {
        | X1 => res += 1
        | X2 => res += 12
        | X3 => res += 13
        | X1a => res += 14
        | X2a => res += 15
        | X3a => res += 16
        | X1b => res += 17
        | X2b => res += 18
        | X3b => res += 19
        | X1c => res += 10
        | X2c => res += 14
        | X3c => res += 13
        | X1ac => res += 133
        | X2ac => res += 12
        | X3ac => res += 123
        | X1bc => res += 124
        | X2bc => res += 156
        | X3bc => res += 153
      }
    }

    System.Console.WriteLine (res);
  }
  
  Main () : void {
    time test_it (10000000);
  }
}

}
