/* $Id: SeqFeatData.cpp 343384 2011-11-04 17:42:38Z kornbluh $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'seqfeat.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/seqfeat/SeqFeatData.hpp>
#include <objects/seqfeat/RNA_ref.hpp>
#include <objects/seqfeat/Imp_feat.hpp>
#include <objects/seq/Pubdesc.hpp>
#include <objects/general/User_object.hpp>

#include <algorithm>
#include <util/static_map.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::


struct SImportEntry {
    const char*            m_Name;
    CSeqFeatData::ESubtype m_Subtype;

    bool operator<(const SImportEntry& e) const {
        return strcmp(m_Name, e.m_Name) < 0;
    }
};

// NOTE: these must stay in ASCIIbetical order!
static const SImportEntry kImportTable[] = {
    { "-10_signal",          CSeqFeatData::eSubtype_10_signal },
    { "-35_signal",          CSeqFeatData::eSubtype_35_signal },
    { "3'UTR",               CSeqFeatData::eSubtype_3UTR },
    { "3'clip",              CSeqFeatData::eSubtype_3clip },
    { "5'UTR",               CSeqFeatData::eSubtype_5UTR },
    { "5'clip",              CSeqFeatData::eSubtype_5clip },
    { "CAAT_signal",         CSeqFeatData::eSubtype_CAAT_signal },
    { "C_region",            CSeqFeatData::eSubtype_C_region },
    { "D-loop",              CSeqFeatData::eSubtype_D_loop },
    { "D_segment",           CSeqFeatData::eSubtype_D_segment },
    { "GC_signal",           CSeqFeatData::eSubtype_GC_signal },
    { "Imp_CDS",             CSeqFeatData::eSubtype_Imp_CDS },
    { "J_segment",           CSeqFeatData::eSubtype_J_segment },
    { "LTR",                 CSeqFeatData::eSubtype_LTR },
    { "N_region",            CSeqFeatData::eSubtype_N_region },
    { "RBS",                 CSeqFeatData::eSubtype_RBS },
    { "STS",                 CSeqFeatData::eSubtype_STS },
    { "S_region",            CSeqFeatData::eSubtype_S_region },
    { "TATA_signal",         CSeqFeatData::eSubtype_TATA_signal },
    { "V_region",            CSeqFeatData::eSubtype_V_region },
    { "V_segment",           CSeqFeatData::eSubtype_V_segment },
    { "allele",              CSeqFeatData::eSubtype_allele },
    { "attenuator",          CSeqFeatData::eSubtype_attenuator },
    { "centromere",          CSeqFeatData::eSubtype_centromere },
    { "conflict",            CSeqFeatData::eSubtype_conflict },
    { "enhancer",            CSeqFeatData::eSubtype_enhancer },
    { "exon",                CSeqFeatData::eSubtype_exon },
    { "gap",                 CSeqFeatData::eSubtype_gap },
    { "iDNA",                CSeqFeatData::eSubtype_iDNA },
    { "import",              CSeqFeatData::eSubtype_imp },
    { "intron",              CSeqFeatData::eSubtype_intron },
    { "mat_peptide",         CSeqFeatData::eSubtype_mat_peptide },
    { "misc_RNA",            CSeqFeatData::eSubtype_misc_RNA },
    { "misc_binding",        CSeqFeatData::eSubtype_misc_binding },
    { "misc_difference",     CSeqFeatData::eSubtype_misc_difference },
    { "misc_feature",        CSeqFeatData::eSubtype_misc_feature },
    { "misc_recomb",         CSeqFeatData::eSubtype_misc_recomb },
    { "misc_signal",         CSeqFeatData::eSubtype_misc_signal },
    { "misc_structure",      CSeqFeatData::eSubtype_misc_structure },
    { "mobile_element",      CSeqFeatData::eSubtype_mobile_element },
    { "modified_base",       CSeqFeatData::eSubtype_modified_base },
    { "mutation",            CSeqFeatData::eSubtype_mutation },
    { "old_sequence",        CSeqFeatData::eSubtype_old_sequence },
    { "operon",              CSeqFeatData::eSubtype_operon },
    { "oriT",                CSeqFeatData::eSubtype_oriT },
    { "polyA_signal",        CSeqFeatData::eSubtype_polyA_signal },
    { "polyA_site",          CSeqFeatData::eSubtype_polyA_site },
    { "precursor_RNA",       CSeqFeatData::eSubtype_precursor_RNA },
    { "prim_transcript",     CSeqFeatData::eSubtype_prim_transcript },
    { "primer_bind",         CSeqFeatData::eSubtype_primer_bind },
    { "promoter",            CSeqFeatData::eSubtype_promoter },
    { "protein_bind",        CSeqFeatData::eSubtype_protein_bind },
    { "rep_origin",          CSeqFeatData::eSubtype_rep_origin },
    { "repeat_region",       CSeqFeatData::eSubtype_repeat_region },
    { "repeat_unit",         CSeqFeatData::eSubtype_repeat_unit },
    { "satellite",           CSeqFeatData::eSubtype_satellite },
    { "sig_peptide",         CSeqFeatData::eSubtype_sig_peptide },
    { "site_ref",            CSeqFeatData::eSubtype_site_ref },
    { "source",              CSeqFeatData::eSubtype_source },
    { "stem_loop",           CSeqFeatData::eSubtype_stem_loop },
    { "telomere",            CSeqFeatData::eSubtype_telomere },
    { "terminator",          CSeqFeatData::eSubtype_terminator },
    { "transit_peptide",     CSeqFeatData::eSubtype_transit_peptide },
    { "unsure",              CSeqFeatData::eSubtype_unsure },
    { "variation",           CSeqFeatData::eSubtype_variation },
    { "virion",              CSeqFeatData::eSubtype_virion }
};

static const SImportEntry* const kImportTableEnd
    = kImportTable + sizeof(kImportTable)/sizeof(SImportEntry);

// Feat info table
typedef pair<CSeqFeatData::E_Choice, CSeqFeatData::SFeatDataInfo> TInfoPair;

#define FEAT_INFO_PAIR(type, subtype, key_full, key_gb) \
    TInfoPair(CSeqFeatData::e_##type, CSeqFeatData::SFeatDataInfo( \
              CSeqFeatData::eSubtype_##subtype, key_full, key_gb))

static const TInfoPair kInfoPairs[] = {
    FEAT_INFO_PAIR(Gene, gene, "Gene", "gene"),
    FEAT_INFO_PAIR(Org, org, "Org", "source"),
    FEAT_INFO_PAIR(Cdregion, cdregion, "CDS", "CDS"),
    FEAT_INFO_PAIR(Pub, pub, "Cit", "misc_feature"),
    FEAT_INFO_PAIR(Seq, seq, "Xref", "misc_feature"),
    FEAT_INFO_PAIR(Region, region, "Region", "misc_feature"),
    FEAT_INFO_PAIR(Comment, comment, "Comment", "misc_feature"),
    FEAT_INFO_PAIR(Bond, bond, "Bond", "misc_feature"),
    FEAT_INFO_PAIR(Rsite, rsite, "Rsite", "misc_feature"),
    FEAT_INFO_PAIR(User, user, "User", "misc_feature"),
    FEAT_INFO_PAIR(Txinit, txinit, "TxInit", "promoter"),
    FEAT_INFO_PAIR(Num, num, "Num", "misc_feature"),
    FEAT_INFO_PAIR(Psec_str, psec_str, "SecStr", "SecStr"),
    FEAT_INFO_PAIR(Non_std_residue, non_std_residue, "NonStdRes", "misc_feature"),
    FEAT_INFO_PAIR(Het, het, "Het", "Het"),
    FEAT_INFO_PAIR(Biosrc, biosrc, "Src", "source"),
    FEAT_INFO_PAIR(Clone, clone, "CloneRef", "misc_feature"),
    FEAT_INFO_PAIR(Variation, variation_ref, "Variation", "variation")
};

typedef CStaticArrayMap<CSeqFeatData::E_Choice,
                        CSeqFeatData::SFeatDataInfo> TInfoMap;
DEFINE_STATIC_ARRAY_MAP(TInfoMap, sc_InfoPairs, kInfoPairs);


// e_Prot info table
typedef pair<CProt_ref::EProcessed, CSeqFeatData::SFeatDataInfo> TProtInfoPair;

#define PROT_INFO_PAIR(proc, subtype, key_full, key_gb) \
    TProtInfoPair(CProt_ref::eProcessed_##proc, CSeqFeatData::SFeatDataInfo( \
              CSeqFeatData::eSubtype_##subtype, key_full, key_gb))

static const TProtInfoPair kProtInfoPairs[] = {
    PROT_INFO_PAIR(preprotein, preprotein, "Prot", "proprotein"),
    PROT_INFO_PAIR(mature, mat_peptide_aa, "Prot", "mat_peptide"),
    PROT_INFO_PAIR(signal_peptide, sig_peptide_aa, "Prot", "sig_peptide"),
    PROT_INFO_PAIR(transit_peptide, transit_peptide_aa, "Prot", "transit_peptide")
};

typedef CStaticArrayMap<CProt_ref::EProcessed,
                        CSeqFeatData::SFeatDataInfo> TProtInfoMap;
DEFINE_STATIC_ARRAY_MAP(TProtInfoMap, sc_ProtInfoPairs, kProtInfoPairs);


// e_Site info table
typedef pair<CSeqFeatData::ESite, CSeqFeatData::SFeatDataInfo> TSiteInfoPair;

#define SITE_INFO_PAIR(site, subtype, key_full, key_gb) \
    TSiteInfoPair(CSeqFeatData::eSite_##site, CSeqFeatData::SFeatDataInfo( \
              CSeqFeatData::eSubtype_##subtype, key_full, key_gb))

static const TSiteInfoPair kSiteInfoPairs[] = {
    SITE_INFO_PAIR(binding, site, "Site", "misc_binding"),
    SITE_INFO_PAIR(metal_binding, site, "Site", "misc_binding"),
    SITE_INFO_PAIR(lipid_binding, site, "Site", "misc_binding"),
    SITE_INFO_PAIR(np_binding, site, "Site", "protein_bind"),
    SITE_INFO_PAIR(dna_binding, site, "Site", "primer_bind"),
    SITE_INFO_PAIR(signal_peptide, site, "Site", "sig_peptide"),
    SITE_INFO_PAIR(transit_peptide, site, "Site", "transit_peptide")
};

typedef CStaticArrayMap<CSeqFeatData::ESite,
                        CSeqFeatData::SFeatDataInfo> TSiteInfoMap;
DEFINE_STATIC_ARRAY_MAP(TSiteInfoMap, sc_SiteInfoPairs, kSiteInfoPairs);


// e_Rna info table
typedef pair<CRNA_ref::EType, CSeqFeatData::SFeatDataInfo> TRnaInfoPair;

#define RNA_INFO_PAIR(rna, subtype, key_full, key_gb) \
    TRnaInfoPair(CRNA_ref::eType_##rna, CSeqFeatData::SFeatDataInfo( \
              CSeqFeatData::eSubtype_##subtype, key_full, key_gb))

static const TRnaInfoPair kRnaInfoPairs[] = {
    RNA_INFO_PAIR(premsg, preRNA, "precursor_RNA", "precursor_RNA"),
    RNA_INFO_PAIR(mRNA, mRNA, "mRNA", "mRNA"),
    RNA_INFO_PAIR(tRNA, tRNA, "tRNA", "tRNA"),
    RNA_INFO_PAIR(rRNA, rRNA, "rRNA", "rRNA"),
    RNA_INFO_PAIR(snRNA, snRNA, "snRNA", "snRNA"),
    RNA_INFO_PAIR(scRNA, scRNA, "scRNA", "scRNA"),
    RNA_INFO_PAIR(snoRNA, snoRNA, "snoRNA", "snoRNA"),
    RNA_INFO_PAIR(ncRNA, ncRNA, "ncRNA", "ncRNA"),
    RNA_INFO_PAIR(tmRNA, tmRNA, "tmRNA", "tmRNA")
};

typedef CStaticArrayMap<CRNA_ref::EType,
                        CSeqFeatData::SFeatDataInfo> TRnaInfoMap;
DEFINE_STATIC_ARRAY_MAP(TRnaInfoMap, sc_RnaInfoPairs, kRnaInfoPairs);


void CSeqFeatData::x_InitFeatDataInfo(void) const
{
    m_FeatDataInfo.m_Key_gb = "misc_feature"; // ???
    m_FeatDataInfo.m_Key_full = "???";
    switch (Which()) {
    case e_Prot:
        {
            TProtInfoMap::const_iterator it =
                sc_ProtInfoPairs.find(GetProt().GetProcessed());
            if (it != sc_ProtInfoPairs.end()) {
                m_FeatDataInfo = it->second;
            }
            else {
                m_FeatDataInfo.m_Subtype = eSubtype_prot;
                m_FeatDataInfo.m_Key_full = "Prot";
                m_FeatDataInfo.m_Key_gb = "Protein";
            }
            break;
        }
    case e_Site: // Is this correct, or are these encoded as Imp?
        {
            TSiteInfoMap::const_iterator it = sc_SiteInfoPairs.find(GetSite());
            if (it != sc_SiteInfoPairs.end()) {
                m_FeatDataInfo = it->second;
            }
            else {
                m_FeatDataInfo.m_Subtype = eSubtype_site;
                m_FeatDataInfo.m_Key_full = "Site";
                m_FeatDataInfo.m_Key_gb = "misc_feature";
            }
            break;
        }
    case e_Rna:
        {
            CRNA_ref_Base::TType rna_type = GetRna().GetType();
            TRnaInfoMap::const_iterator it =
                sc_RnaInfoPairs.find(rna_type);
            if (it != sc_RnaInfoPairs.end()) {
                m_FeatDataInfo = it->second;
            }
            else {
                bool can_get_name = (GetRna().CanGetExt()
                                    &&  GetRna().GetExt().IsName());
                const string& ext_name = (can_get_name
                                        ? GetRna().GetExt().GetName()
                                        : kEmptyStr);
                if (ext_name == "ncRNA") {
                    m_FeatDataInfo.m_Subtype = eSubtype_ncRNA;
                    m_FeatDataInfo.m_Key_full = ext_name;
                } else if (ext_name == "tmRNA") {
                    m_FeatDataInfo.m_Subtype = eSubtype_tmRNA;
                    m_FeatDataInfo.m_Key_full = ext_name;
                } else {
                    m_FeatDataInfo.m_Subtype = eSubtype_otherRNA;
                    bool other = GetRna().GetType() == CRNA_ref::eType_other;
                    m_FeatDataInfo.m_Key_full = other ? "RNA" : "misc_RNA";
                }
                m_FeatDataInfo.m_Key_gb = "misc_RNA";
            }
            break;
        }
    case e_Imp:
    {
        const string& key    = GetImp().GetKey();
        SImportEntry  key2   = { key.c_str(), eSubtype_imp };
        const SImportEntry* result = lower_bound(kImportTable,
                                                 kImportTableEnd,
                                                 key2);
        if ( result == kImportTableEnd ||
             strcmp(key2.m_Name, result->m_Name) ) {
            m_FeatDataInfo.m_Subtype = eSubtype_imp;
        } else {
            m_FeatDataInfo.m_Subtype = result->m_Subtype;
        }
        m_FeatDataInfo.m_Key_gb = key; // "Imp"?;
        m_FeatDataInfo.m_Key_full = key;
        break;
    }
    default:
        {
            TInfoMap::const_iterator it = sc_InfoPairs.find(Which());
            if (it != sc_InfoPairs.end()) {
                m_FeatDataInfo = it->second;
            }
            else {
                m_FeatDataInfo.m_Subtype = eSubtype_bad;
                m_FeatDataInfo.m_Key_full = "???";
                m_FeatDataInfo.m_Key_gb = "misc_feature"; // ???
            }
        }
    }
}


// destructor
CSeqFeatData::~CSeqFeatData(void)
{
}


// ASCII representation of subtype (GenBank feature key, e.g.)
string CSeqFeatData::GetKey(EVocabulary vocab) const
{
    if (m_FeatDataInfo.m_Subtype == eSubtype_any) {
        x_InitFeatDataInfo();
    }
    return (vocab == eVocabulary_genbank) ?
        m_FeatDataInfo.m_Key_gb : m_FeatDataInfo.m_Key_full;
}


CSeqFeatData::ESubtype CSeqFeatData::GetSubtype(void) const
{
    if (m_FeatDataInfo.m_Subtype == eSubtype_any) { // unknown
        x_InitFeatDataInfo();
    }
    return m_FeatDataInfo.m_Subtype;
}


void CSeqFeatData::Assign(const CSerialObject& source,
                          ESerialRecursionMode how)
{
    InvalidateCache();
    Tparent::Assign(source, how);
}


void CSeqFeatData::PostRead(void) const
{
    InvalidateCache();
}


DEFINE_STATIC_MUTEX(sx_InitTablesMutex);


typedef vector<CSeqFeatData::E_Choice> TSubtypesTable;
static AutoPtr<TSubtypesTable> sx_SubtypesTable;

typedef map<CSeqFeatData::ESubtype, CSeqFeatData::TQualifiers> TFeatQuals;
// these maps contain sorted vectors for faster lookup
static AutoPtr<TFeatQuals> sx_LegalQuals;
static AutoPtr<TFeatQuals> sx_MandatoryQuals;
static AutoPtr<CSeqFeatData::TQualifiers> sx_EmptyQuals;


CSeqFeatData::E_Choice CSeqFeatData::GetTypeFromSubtype(ESubtype subtype)
{
    if ( !sx_SubtypesTable ) {
        s_InitSubtypesTable();
    }
    return (*sx_SubtypesTable)[subtype];
}

bool CSeqFeatData::IsLegalQualifier(ESubtype subtype, EQualifier qual)
{
    if ( !sx_LegalQuals ) {
        s_InitLegalQuals();  // does nothing if already intialized
    }
    TFeatQuals::const_iterator iter = sx_LegalQuals->find(subtype);
    if ( iter == sx_LegalQuals->end() ) {
        return false;
    }
    const TQualifiers& legal = iter->second;
    return binary_search(legal.begin(), legal.end(), qual);
}


const CSeqFeatData::TQualifiers& CSeqFeatData::GetLegalQualifiers(ESubtype subtype)
{
    if ( !sx_LegalQuals ) {
        s_InitLegalQuals();  // does nothing if already intialized
    }
    TFeatQuals::const_iterator iter = sx_LegalQuals->find(subtype);
    if ( iter == sx_LegalQuals->end() ) {
        return *sx_EmptyQuals;
    }
    return iter->second;
}


const CSeqFeatData::TQualifiers& CSeqFeatData::GetMandatoryQualifiers(ESubtype subtype)
{
    if ( !sx_MandatoryQuals ) {
        s_InitMandatoryQuals();  // does nothing if already intialized
    }
    TFeatQuals::const_iterator iter = sx_MandatoryQuals->find(subtype);
    if ( iter == sx_MandatoryQuals->end() ) {
        return *sx_EmptyQuals;
    }
    return iter->second;
}


#ifdef _DEBUG
struct SSubtypeInfo {
    CSeqFeatData::E_Choice m_Type;
    CSeqFeatData::ESubtype m_Subtype;
    int m_Value;
    const char* m_Name;
};
#define SUBTYPE_INFO(type, subtype, value)  \
    { CSeqFeatData::type, CSeqFeatData::subtype, value, #subtype }
static const SSubtypeInfo s_subtype_info[] = {
    SUBTYPE_INFO(           e_not_set,                   eSubtype_bad,   0),
    SUBTYPE_INFO(              e_Gene,                  eSubtype_gene,   1),
    SUBTYPE_INFO(               e_Org,                   eSubtype_org,   2),
    SUBTYPE_INFO(          e_Cdregion,              eSubtype_cdregion,   3),
    SUBTYPE_INFO(              e_Prot,                  eSubtype_prot,   4),
    SUBTYPE_INFO(              e_Prot,            eSubtype_preprotein,   5),
    SUBTYPE_INFO(              e_Prot,        eSubtype_mat_peptide_aa,   6),
    SUBTYPE_INFO(              e_Prot,        eSubtype_sig_peptide_aa,   7),
    SUBTYPE_INFO(              e_Prot,    eSubtype_transit_peptide_aa,   8),
    SUBTYPE_INFO(               e_Rna,                eSubtype_preRNA,   9),
    SUBTYPE_INFO(               e_Rna,                  eSubtype_mRNA,  10),
    SUBTYPE_INFO(               e_Rna,                  eSubtype_tRNA,  11),
    SUBTYPE_INFO(               e_Rna,                  eSubtype_rRNA,  12),
    SUBTYPE_INFO(               e_Rna,                 eSubtype_snRNA,  13),
    SUBTYPE_INFO(               e_Rna,                 eSubtype_scRNA,  14),
    SUBTYPE_INFO(               e_Rna,                eSubtype_snoRNA,  15),
    SUBTYPE_INFO(               e_Rna,              eSubtype_otherRNA,  16),
    SUBTYPE_INFO(               e_Pub,                   eSubtype_pub,  17),
    SUBTYPE_INFO(               e_Seq,                   eSubtype_seq,  18),
    SUBTYPE_INFO(               e_Imp,                   eSubtype_imp,  19),
    SUBTYPE_INFO(               e_Imp,                eSubtype_allele,  20),
    SUBTYPE_INFO(               e_Imp,            eSubtype_attenuator,  21),
    SUBTYPE_INFO(               e_Imp,              eSubtype_C_region,  22),
    SUBTYPE_INFO(               e_Imp,           eSubtype_CAAT_signal,  23),
    SUBTYPE_INFO(               e_Imp,               eSubtype_Imp_CDS,  24),
    SUBTYPE_INFO(               e_Imp,              eSubtype_conflict,  25),
    SUBTYPE_INFO(               e_Imp,                eSubtype_D_loop,  26),
    SUBTYPE_INFO(               e_Imp,             eSubtype_D_segment,  27),
    SUBTYPE_INFO(               e_Imp,              eSubtype_enhancer,  28),
    SUBTYPE_INFO(               e_Imp,                  eSubtype_exon,  29),
    SUBTYPE_INFO(               e_Imp,             eSubtype_EC_number,  30),
    SUBTYPE_INFO(               e_Imp,             eSubtype_GC_signal,  31),
    SUBTYPE_INFO(               e_Imp,                  eSubtype_iDNA,  32),
    SUBTYPE_INFO(               e_Imp,                eSubtype_intron,  33),
    SUBTYPE_INFO(               e_Imp,             eSubtype_J_segment,  34),
    SUBTYPE_INFO(               e_Imp,                   eSubtype_LTR,  35),
    SUBTYPE_INFO(               e_Imp,           eSubtype_mat_peptide,  36),
    SUBTYPE_INFO(               e_Imp,          eSubtype_misc_binding,  37),
    SUBTYPE_INFO(               e_Imp,       eSubtype_misc_difference,  38),
    SUBTYPE_INFO(               e_Imp,          eSubtype_misc_feature,  39),
    SUBTYPE_INFO(               e_Imp,           eSubtype_misc_recomb,  40),
    SUBTYPE_INFO(               e_Imp,              eSubtype_misc_RNA,  41),
    SUBTYPE_INFO(               e_Imp,           eSubtype_misc_signal,  42),
    SUBTYPE_INFO(               e_Imp,        eSubtype_misc_structure,  43),
    SUBTYPE_INFO(               e_Imp,         eSubtype_modified_base,  44),
    SUBTYPE_INFO(               e_Imp,              eSubtype_mutation,  45),
    SUBTYPE_INFO(               e_Imp,              eSubtype_N_region,  46),
    SUBTYPE_INFO(               e_Imp,          eSubtype_old_sequence,  47),
    SUBTYPE_INFO(               e_Imp,          eSubtype_polyA_signal,  48),
    SUBTYPE_INFO(               e_Imp,            eSubtype_polyA_site,  49),
    SUBTYPE_INFO(               e_Imp,         eSubtype_precursor_RNA,  50),
    SUBTYPE_INFO(               e_Imp,       eSubtype_prim_transcript,  51),
    SUBTYPE_INFO(               e_Imp,           eSubtype_primer_bind,  52),
    SUBTYPE_INFO(               e_Imp,              eSubtype_promoter,  53),
    SUBTYPE_INFO(               e_Imp,          eSubtype_protein_bind,  54),
    SUBTYPE_INFO(               e_Imp,                   eSubtype_RBS,  55),
    SUBTYPE_INFO(               e_Imp,         eSubtype_repeat_region,  56),
    SUBTYPE_INFO(               e_Imp,           eSubtype_repeat_unit,  57),
    SUBTYPE_INFO(               e_Imp,            eSubtype_rep_origin,  58),
    SUBTYPE_INFO(               e_Imp,              eSubtype_S_region,  59),
    SUBTYPE_INFO(               e_Imp,             eSubtype_satellite,  60),
    SUBTYPE_INFO(               e_Imp,           eSubtype_sig_peptide,  61),
    SUBTYPE_INFO(               e_Imp,                eSubtype_source,  62),
    SUBTYPE_INFO(               e_Imp,             eSubtype_stem_loop,  63),
    SUBTYPE_INFO(               e_Imp,                   eSubtype_STS,  64),
    SUBTYPE_INFO(               e_Imp,           eSubtype_TATA_signal,  65),
    SUBTYPE_INFO(               e_Imp,            eSubtype_terminator,  66),
    SUBTYPE_INFO(               e_Imp,       eSubtype_transit_peptide,  67),
    SUBTYPE_INFO(               e_Imp,                eSubtype_unsure,  68),
    SUBTYPE_INFO(               e_Imp,              eSubtype_V_region,  69),
    SUBTYPE_INFO(               e_Imp,             eSubtype_V_segment,  70),
    SUBTYPE_INFO(               e_Imp,             eSubtype_variation,  71),
    SUBTYPE_INFO(               e_Imp,                eSubtype_virion,  72),
    SUBTYPE_INFO(               e_Imp,                 eSubtype_3clip,  73),
    SUBTYPE_INFO(               e_Imp,                  eSubtype_3UTR,  74),
    SUBTYPE_INFO(               e_Imp,                 eSubtype_5clip,  75),
    SUBTYPE_INFO(               e_Imp,                  eSubtype_5UTR,  76),
    SUBTYPE_INFO(               e_Imp,             eSubtype_10_signal,  77),
    SUBTYPE_INFO(               e_Imp,             eSubtype_35_signal,  78),
    SUBTYPE_INFO(               e_Imp,                   eSubtype_gap,  79),
    SUBTYPE_INFO(               e_Imp,                eSubtype_operon,  80),
    SUBTYPE_INFO(               e_Imp,                  eSubtype_oriT,  81),
    SUBTYPE_INFO(               e_Imp,              eSubtype_site_ref,  82),
    SUBTYPE_INFO(            e_Region,                eSubtype_region,  83),
    SUBTYPE_INFO(           e_Comment,               eSubtype_comment,  84),
    SUBTYPE_INFO(              e_Bond,                  eSubtype_bond,  85),
    SUBTYPE_INFO(              e_Site,                  eSubtype_site,  86),
    SUBTYPE_INFO(             e_Rsite,                 eSubtype_rsite,  87),
    SUBTYPE_INFO(              e_User,                  eSubtype_user,  88),
    SUBTYPE_INFO(            e_Txinit,                eSubtype_txinit,  89),
    SUBTYPE_INFO(               e_Num,                   eSubtype_num,  90),
    SUBTYPE_INFO(          e_Psec_str,              eSubtype_psec_str,  91),
    SUBTYPE_INFO(   e_Non_std_residue,       eSubtype_non_std_residue,  92),
    SUBTYPE_INFO(               e_Het,                   eSubtype_het,  93),
    SUBTYPE_INFO(            e_Biosrc,                eSubtype_biosrc,  94),
    SUBTYPE_INFO(               e_Rna,                 eSubtype_ncRNA,  95),
    SUBTYPE_INFO(               e_Rna,                 eSubtype_tmRNA,  96),
    SUBTYPE_INFO(             e_Clone,                 eSubtype_clone,  97),
    SUBTYPE_INFO(         e_Variation,         eSubtype_variation_ref,  98),
    SUBTYPE_INFO(               e_Imp,        eSubtype_mobile_element,  99),
    SUBTYPE_INFO(               e_Imp,            eSubtype_centromere, 100),
    SUBTYPE_INFO(               e_Imp,              eSubtype_telomere, 101),
    SUBTYPE_INFO(           e_not_set,                   eSubtype_max, 102),
    SUBTYPE_INFO(           e_not_set,                   eSubtype_any, 255)
};
static const size_t s_subtype_count =
    sizeof(s_subtype_info)/sizeof(s_subtype_info[0]);
#endif


void CSeqFeatData::s_InitSubtypesTable(void)
{
    if ( sx_SubtypesTable ) {
        return;
    }
    CMutexGuard guard(sx_InitTablesMutex);
    if ( sx_SubtypesTable ) {
        return;
    }
    AutoPtr<TSubtypesTable> ptr(new TSubtypesTable(eSubtype_any+1, e_not_set));
    TSubtypesTable& table = *ptr;

    table[eSubtype_gene] = e_Gene;
    table[eSubtype_org] = e_Org;
    table[eSubtype_cdregion] = e_Cdregion;
    table[eSubtype_pub] = e_Pub;
    table[eSubtype_seq] = e_Seq;
    table[eSubtype_region] = e_Region;
    table[eSubtype_comment] = e_Comment;
    table[eSubtype_bond] = e_Bond;
    table[eSubtype_site] = e_Site;
    table[eSubtype_rsite] = e_Rsite;
    table[eSubtype_user] = e_User;
    table[eSubtype_txinit] = e_Txinit;
    table[eSubtype_num] = e_Num;
    table[eSubtype_psec_str] = e_Psec_str;
    table[eSubtype_non_std_residue] = e_Non_std_residue;
    table[eSubtype_het] = e_Het;
    table[eSubtype_biosrc] = e_Biosrc;
    table[eSubtype_clone] = e_Clone;
    table[eSubtype_variation_ref] = e_Variation;
    for (int sub = eSubtype_prot; sub <= eSubtype_transit_peptide_aa; ++sub) {
        table[ESubtype(sub)] = e_Prot;
    }
    for (int sub = eSubtype_preRNA; sub <= eSubtype_otherRNA; ++sub) {
        table[ESubtype(sub)] = e_Rna;
    }
    table[eSubtype_ncRNA] = e_Rna;
    table[eSubtype_tmRNA] = e_Rna;
    for (int sub = eSubtype_imp; sub <= eSubtype_site_ref; ++sub) {
        table[ESubtype(sub)] = e_Imp;
    }
    for ( const SImportEntry* p = kImportTable; p != kImportTableEnd; ++p ) {
        table[p->m_Subtype] = e_Imp;
    }

    sx_SubtypesTable = ptr;

#ifdef _DEBUG
    if ( false ) { // print new definition of s_subtype_info[]
        NcbiCout << "static const SSubtypeInfo s_subtype_info[] = {\n";
        for ( size_t i = 0; i < s_subtype_count; ++i ) {
            const SSubtypeInfo& info = s_subtype_info[i];
            string type = SelectionName(GetTypeFromSubtype(info.m_Subtype));
            if ( type == "not set" ) {
                type = "not_set";
            }
            else {
                type[0] = toupper(type[0]);
                NStr::ReplaceInPlace(type, "-", "_");
            }
            type = "e_"+type;
            NcbiCout << "    SUBTYPE_INFO("
                     << setw(20) << type << ", "
                     << setw(30) << info.m_Name << ", "
                     << setw(3) << info.m_Subtype << ")";
            if ( i != s_subtype_count-1 ) NcbiCout << ",";
            NcbiCout << "\n";
        }
        NcbiCout << "};" << NcbiEndl;
    }
    // check if type/subtype values didn't change
    for ( size_t i = 0; i < s_subtype_count; ++i ) {
        const SSubtypeInfo& info = s_subtype_info[i];
        _ASSERT(info.m_Subtype == info.m_Value);
        _ASSERT(info.m_Type == GetTypeFromSubtype(info.m_Subtype));
    }
#endif    
}


void CSeqFeatData::s_InitLegalQuals(void)
{
    if ( sx_LegalQuals ) {
        return;
    }
    CMutexGuard guard(sx_InitTablesMutex);
    if ( sx_LegalQuals ) {
        return;
    }

    if ( !sx_EmptyQuals ) {
        sx_EmptyQuals.reset(new TQualifiers);
    }
    
    AutoPtr<TFeatQuals> ptr(new TFeatQuals);
    TFeatQuals& table = *ptr;

#define START_SUBTYPE(x) { \
    TQualifiers& quals = table[eSubtype_##x];
#define ADD_QUAL(y) quals.push_back(eQual_##y)
#define END_SUBTYPE }

START_SUBTYPE(gene)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(exception);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(nomenclature);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(phenotype);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(trans_splicing);
    ADD_QUAL(usedin);
END_SUBTYPE

//START_SUBTYPE(org)
//END_SUBTYPE

START_SUBTYPE(cdregion)
    ADD_QUAL(EC_number);
    ADD_QUAL(allele);
    ADD_QUAL(artificial_location);
    ADD_QUAL(citation);
    ADD_QUAL(coded_by);
    ADD_QUAL(codon);
    ADD_QUAL(codon_start);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(exception);
    ADD_QUAL(function);
    ADD_QUAL(gdb_xref);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(number);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(product);
    ADD_QUAL(protein_id);
    ADD_QUAL(pseudo);
    ADD_QUAL(ribosomal_slippage);
    ADD_QUAL(standard_name);
    ADD_QUAL(trans_splicing);
    ADD_QUAL(transl_except);
    ADD_QUAL(transl_table);
    ADD_QUAL(translation);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(prot)
    ADD_QUAL(EC_number);
    ADD_QUAL(UniProtKB_evidence);
    ADD_QUAL(allele);
    ADD_QUAL(calculated_mol_wt);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(derived_from);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(name);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(protein_id);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(preprotein)
    ADD_QUAL(EC_number);
    ADD_QUAL(allele);
    ADD_QUAL(calculated_mol_wt);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(name);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(protein_id);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(mat_peptide_aa)
    ADD_QUAL(EC_number);
    ADD_QUAL(allele);
    ADD_QUAL(calculated_mol_wt);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(derived_from);
    ADD_QUAL(exception);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(name);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(protein_id);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(sig_peptide_aa)
    ADD_QUAL(EC_number);
    ADD_QUAL(allele);
    ADD_QUAL(calculated_mol_wt);
    ADD_QUAL(citation);
    ADD_QUAL(derived_from);
    ADD_QUAL(db_xref);
    ADD_QUAL(exception);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(name);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(protein_id);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(transit_peptide_aa)
    ADD_QUAL(allele);
    ADD_QUAL(calculated_mol_wt);
    ADD_QUAL(citation);
    ADD_QUAL(derived_from);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(name);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(protein_id);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(preRNA)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(exception);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(trans_splicing);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(mRNA)
    ADD_QUAL(allele);
    ADD_QUAL(artificial_location);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(exception);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(trans_splicing);
    ADD_QUAL(transcript_id);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(tRNA)
    ADD_QUAL(allele);
    ADD_QUAL(anticodon);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(exception);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(trans_splicing);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(rRNA)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(exception);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(snRNA)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(exception);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(scRNA)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(exception);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(snoRNA)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(exception);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(ncRNA)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(exception);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(ncRNA_class);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(trans_splicing);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(tmRNA)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(exception);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(tag_peptide);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(otherRNA)  //  a.k.a. misc_RNA
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(exception);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(ncRNA_class);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(trans_splicing);
    ADD_QUAL(usedin);
END_SUBTYPE

//START_SUBTYPE(pub)
//END_SUBTYPE

//START_SUBTYPE(seq)
//END_SUBTYPE

//START_SUBTYPE(imp)
//END_SUBTYPE

//START_SUBTYPE(allele)
//END_SUBTYPE

START_SUBTYPE(attenuator)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(phenotype);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(C_region)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(exception);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(CAAT_signal)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(Imp_CDS)
    ADD_QUAL(EC_number);
    ADD_QUAL(allele);
    ADD_QUAL(artificial_location);
    ADD_QUAL(citation);
    ADD_QUAL(codon);
    ADD_QUAL(codon_start);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(exception);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(number);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(product);
    ADD_QUAL(protein_id);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(transl_except);
    ADD_QUAL(transl_table);
    ADD_QUAL(translation);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(conflict)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(compare);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(replace);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(D_loop)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(D_segment)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(enhancer)
    ADD_QUAL(allele);
    ADD_QUAL(bound_moiety);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(exon)
    ADD_QUAL(EC_number);
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(exception);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(number);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(GC_signal)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(iDNA)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(number);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(intron)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(cons_splice);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(number);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(J_segment)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(LTR)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(mat_peptide)
    ADD_QUAL(EC_number);
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(misc_binding)
    ADD_QUAL(allele);
    ADD_QUAL(bound_moiety);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(misc_difference)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(clone);
    ADD_QUAL(compare);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(phenotype);
    ADD_QUAL(replace);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(misc_feature)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(exception);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(number);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(phenotype);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(misc_recomb)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(misc_RNA)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(exception);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(product);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(misc_signal)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(phenotype);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(misc_structure)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(modified_base)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(frequency);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(mod_base);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(usedin);
END_SUBTYPE

//START_SUBTYPE(mutation)
//END_SUBTYPE

START_SUBTYPE(N_region)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(old_sequence)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(compare);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(replace);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(polyA_signal)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(polyA_site)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(precursor_RNA)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(derived_from);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(exception);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(product);
    ADD_QUAL(standard_name);
    ADD_QUAL(trans_splicing);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(prim_transcript)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(primer_bind)
    ADD_QUAL(PCR_conditions);
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(promoter)
    ADD_QUAL(allele);
    ADD_QUAL(bound_moiety);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(phenotype);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(protein_bind)
    ADD_QUAL(allele);
    ADD_QUAL(bound_moiety);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(RBS)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(repeat_region)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(insertion_seq);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(mobile_element);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(rpt_family);
    ADD_QUAL(rpt_type);
    ADD_QUAL(rpt_unit);
    ADD_QUAL(rpt_unit_range);
    ADD_QUAL(rpt_unit_seq);
    ADD_QUAL(satellite);
    ADD_QUAL(standard_name);
    ADD_QUAL(transposon);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(repeat_unit)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(rpt_family);
    ADD_QUAL(rpt_type);
    ADD_QUAL(rpt_unit);
    ADD_QUAL(rpt_unit_range);
    ADD_QUAL(rpt_unit_seq);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(rep_origin)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(direction);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(S_region)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(satellite)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(rpt_family);
    ADD_QUAL(rpt_type);
    ADD_QUAL(rpt_unit);
    ADD_QUAL(rpt_unit_range);
    ADD_QUAL(rpt_unit_seq);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(sig_peptide)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(source)
    ADD_QUAL(bio_material);
    ADD_QUAL(cell_line);
    ADD_QUAL(cell_type);
    ADD_QUAL(chloroplast);
    ADD_QUAL(chromoplast);
    ADD_QUAL(chromosome);
    ADD_QUAL(citation);
    ADD_QUAL(clone);
    ADD_QUAL(clone_lib);
    ADD_QUAL(collected_by);
    ADD_QUAL(collection_date);
    ADD_QUAL(country);
    ADD_QUAL(cultivar);
    ADD_QUAL(culture_collection);
    ADD_QUAL(cyanelle);
    ADD_QUAL(db_xref);
    ADD_QUAL(dev_stage);
    ADD_QUAL(ecotype);
    ADD_QUAL(environmental_sample);
    ADD_QUAL(focus);
    ADD_QUAL(frequency);
    ADD_QUAL(germline);
    ADD_QUAL(haplogroup);
    ADD_QUAL(haplotype);
    ADD_QUAL(host);
    ADD_QUAL(identified_by);
    ADD_QUAL(isolate);
    ADD_QUAL(isolation_source);
    ADD_QUAL(kinetoplast);
    ADD_QUAL(lab_host);
    ADD_QUAL(label);
    ADD_QUAL(lat_lon);
    ADD_QUAL(linkage_group);
    ADD_QUAL(macronuclear);
    ADD_QUAL(map);
    ADD_QUAL(mating_type);
    ADD_QUAL(metagenomic);
    ADD_QUAL(mitochondrion);
    ADD_QUAL(mol_type);
    ADD_QUAL(note);
    ADD_QUAL(organelle);
    ADD_QUAL(organism);
    ADD_QUAL(PCR_primers);
    ADD_QUAL(plasmid);
    ADD_QUAL(pop_variant);
    ADD_QUAL(proviral);
    ADD_QUAL(rearranged);
    ADD_QUAL(segment);
    ADD_QUAL(sequenced_mol);
    ADD_QUAL(serotype);
    ADD_QUAL(serovar);
    ADD_QUAL(sex);
    ADD_QUAL(specimen_voucher);
    ADD_QUAL(strain);
    ADD_QUAL(sub_clone);
    ADD_QUAL(sub_species);
    ADD_QUAL(sub_strain);
    ADD_QUAL(tissue_lib);
    ADD_QUAL(tissue_type);
    ADD_QUAL(transgenic);
    ADD_QUAL(transposon);
    ADD_QUAL(usedin);
    ADD_QUAL(variety);
    ADD_QUAL(virion);
    ADD_QUAL(whole_replicon);
END_SUBTYPE

START_SUBTYPE(stem_loop)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(STS)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(TATA_signal)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(terminator)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(operon);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(transit_peptide)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(unsure)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(compare);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(replace);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(V_region)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(V_segment)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(exception);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(variation)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(compare);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(frequency);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(phenotype);
    ADD_QUAL(product);
    ADD_QUAL(replace);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

//START_SUBTYPE(virion)

START_SUBTYPE(3clip)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(3UTR)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(standard_name);
    ADD_QUAL(trans_splicing);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(5clip)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(5UTR)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(standard_name);
    ADD_QUAL(trans_splicing);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(10_signal)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(35_signal)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(operon);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(gap)
    ADD_QUAL(estimated_length);
    ADD_QUAL(experiment);
    ADD_QUAL(inference);
    ADD_QUAL(map);
    ADD_QUAL(note);
END_SUBTYPE

START_SUBTYPE(operon)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(operon);
    ADD_QUAL(phenotype);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(oriT)
    ADD_QUAL(allele);
    ADD_QUAL(bound_moiety);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(direction);
    ADD_QUAL(experiment);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(rpt_type);
    ADD_QUAL(rpt_unit);
    ADD_QUAL(rpt_unit_range);
    ADD_QUAL(rpt_unit_seq);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

//START_SUBTYPE(site_ref)
//END_SUBTYPE

START_SUBTYPE(region)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(number);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(phenotype);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(region_name);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(comment)  // same as misc_feature
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(number);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(phenotype);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(bond)  // same as misc_feature
    ADD_QUAL(allele);
    ADD_QUAL(bond_type);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(number);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(phenotype);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(site)  //  same as misc_feature
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(number);
    ADD_QUAL(phenotype);
    ADD_QUAL(pseudo);
    ADD_QUAL(site_type);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

//START_SUBTYPE(rsite)
//END_SUBTYPE

//START_SUBTYPE(user)
//END_SUBTYPE

//START_SUBTYPE(txinit)
//END_SUBTYPE

//START_SUBTYPE(num)
//END_SUBTYPE

START_SUBTYPE(psec_str)  //  same as misc_feature???
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(number);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(phenotype);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(sec_str_type);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

//START_SUBTYPE(non_std_residue)
//END_SUBTYPE

START_SUBTYPE(het)  //  same as misc_feature
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(heterogen);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(number);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(phenotype);
    ADD_QUAL(product);
    ADD_QUAL(pseudo);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(mobile_element)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(evidence);
    ADD_QUAL(experiment);
    ADD_QUAL(function);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(insertion_seq);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(mobile_element_type);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(rpt_family);
    ADD_QUAL(rpt_type);
    ADD_QUAL(satellite);
    ADD_QUAL(standard_name);
    ADD_QUAL(transposon);
    ADD_QUAL(usedin);
END_SUBTYPE

//START_SUBTYPE(biosrc)
//END_SUBTYPE

//START_SUBTYPE(clone)
//END_SUBTYPE

START_SUBTYPE(variation_ref)
    ADD_QUAL(allele);
    ADD_QUAL(citation);
    ADD_QUAL(compare);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(frequency);
    ADD_QUAL(gene);
    ADD_QUAL(gene_synonym);
    ADD_QUAL(inference);
    ADD_QUAL(label);
    ADD_QUAL(locus_tag);
    ADD_QUAL(map);
    ADD_QUAL(note);
    ADD_QUAL(old_locus_tag);
    ADD_QUAL(phenotype);
    ADD_QUAL(product);
    ADD_QUAL(replace);
    ADD_QUAL(standard_name);
    ADD_QUAL(usedin);
END_SUBTYPE

START_SUBTYPE(centromere)
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(inference);
    ADD_QUAL(note);
    ADD_QUAL(standard_name);
END_SUBTYPE

START_SUBTYPE(telomere)
    ADD_QUAL(citation);
    ADD_QUAL(db_xref);
    ADD_QUAL(experiment);
    ADD_QUAL(inference);
    ADD_QUAL(note);
    ADD_QUAL(rpt_type);
    ADD_QUAL(rpt_unit_range);
    ADD_QUAL(rpt_unit_seq);
    ADD_QUAL(standard_name);
END_SUBTYPE

#undef START_SUBTYPE
#undef ADD_QUAL
#undef END_SUBTYPE

    // sort for binary_search
    NON_CONST_ITERATE ( TFeatQuals, iter, table ) {
        sort(iter->second.begin(), iter->second.end());
    }

    sx_LegalQuals = ptr;
}


void CSeqFeatData::s_InitMandatoryQuals(void)
{
    if ( sx_MandatoryQuals ) {
        return;
    }
    CMutexGuard guard(sx_InitTablesMutex);
    if ( sx_MandatoryQuals ) {
        return;
    }

    if ( !sx_EmptyQuals ) {
        sx_EmptyQuals.reset(new TQualifiers);
    }
    
    AutoPtr<TFeatQuals> ptr(new TFeatQuals);
    TFeatQuals& table = *ptr;

    table[eSubtype_conflict].push_back(eQual_citation);
    table[eSubtype_gap].push_back(eQual_estimated_length);
    table[eSubtype_misc_binding].push_back(eQual_bound_moiety);
    table[eSubtype_protein_bind].push_back(eQual_bound_moiety);
    table[eSubtype_modified_base].push_back(eQual_mod_base);
    table[eSubtype_old_sequence].push_back(eQual_citation);
    table[eSubtype_operon].push_back(eQual_operon);
    table[eSubtype_source].push_back(eQual_organism);
    table[eSubtype_ncRNA].push_back(eQual_ncRNA_class);

    // sort for binary_search
    NON_CONST_ITERATE ( TFeatQuals, iter, table ) {
        sort(iter->second.begin(), iter->second.end());
    }

    sx_MandatoryQuals = ptr;
}


typedef pair<CSeqFeatData::EQualifier, string> TQualPair;
static const TQualPair kQualPairs[] = {
    TQualPair(CSeqFeatData::eQual_bad, "bad"),
    TQualPair(CSeqFeatData::eQual_allele, "allele"),
    TQualPair(CSeqFeatData::eQual_anticodon, "anticodon"),
    TQualPair(CSeqFeatData::eQual_artificial_location, "artificial_location"),
    TQualPair(CSeqFeatData::eQual_bio_material, "bio_material"),
    TQualPair(CSeqFeatData::eQual_bond_type, "bond_type"),
    TQualPair(CSeqFeatData::eQual_bound_moiety, "bound_moiety"),
    TQualPair(CSeqFeatData::eQual_calculated_mol_wt, "calculated_mol_wt"),
    TQualPair(CSeqFeatData::eQual_cell_line, "cell_line"),
    TQualPair(CSeqFeatData::eQual_cell_type, "cell_type"),
    TQualPair(CSeqFeatData::eQual_chloroplast, "chloroplast"),
    TQualPair(CSeqFeatData::eQual_chromoplast, "chromoplast"),
    TQualPair(CSeqFeatData::eQual_chromosome, "chromosome"),
    TQualPair(CSeqFeatData::eQual_citation, "citation"),
    TQualPair(CSeqFeatData::eQual_clone, "clone"),
    TQualPair(CSeqFeatData::eQual_clone_lib, "clone_lib"),
    TQualPair(CSeqFeatData::eQual_coded_by, "coded_by"),
    TQualPair(CSeqFeatData::eQual_codon, "codon"),
    TQualPair(CSeqFeatData::eQual_codon_start, "codon_start"),
    TQualPair(CSeqFeatData::eQual_collected_by, "collected_by"),
    TQualPair(CSeqFeatData::eQual_collection_date, "collection_date"),
    TQualPair(CSeqFeatData::eQual_compare, "compare"),
    TQualPair(CSeqFeatData::eQual_cons_splice, "cons_splice"),
    TQualPair(CSeqFeatData::eQual_country, "country"),
    TQualPair(CSeqFeatData::eQual_cultivar, "cultivar"),
    TQualPair(CSeqFeatData::eQual_culture_collection, "culture_collection"),
    TQualPair(CSeqFeatData::eQual_cyanelle, "cyanelle"),
    TQualPair(CSeqFeatData::eQual_db_xref, "db_xref"),
    TQualPair(CSeqFeatData::eQual_dev_stage, "dev_stage"),
    TQualPair(CSeqFeatData::eQual_direction, "direction"),
    TQualPair(CSeqFeatData::eQual_EC_number, "EC_number"),
    TQualPair(CSeqFeatData::eQual_ecotype, "ecotype"),
    TQualPair(CSeqFeatData::eQual_environmental_sample, "environmental_sample"),
    TQualPair(CSeqFeatData::eQual_estimated_length, "estimated_length"),
    TQualPair(CSeqFeatData::eQual_evidence, "evidence"),
    TQualPair(CSeqFeatData::eQual_exception, "exception"),
    TQualPair(CSeqFeatData::eQual_experiment, "experiment"),
    TQualPair(CSeqFeatData::eQual_focus, "focus"),
    TQualPair(CSeqFeatData::eQual_frequency, "frequency"),
    TQualPair(CSeqFeatData::eQual_function, "function"),
    TQualPair(CSeqFeatData::eQual_gdb_xref, "gdb_xref"),
    TQualPair(CSeqFeatData::eQual_gene, "gene"),
    TQualPair(CSeqFeatData::eQual_gene_synonym, "gene_synonym"),
    TQualPair(CSeqFeatData::eQual_germline, "germline"),
    TQualPair(CSeqFeatData::eQual_haplogroup, "haplogroup"),
    TQualPair(CSeqFeatData::eQual_haplotype, "haplotype"),
    TQualPair(CSeqFeatData::eQual_host, "host"),
    TQualPair(CSeqFeatData::eQual_identified_by, "identified_by"),
    TQualPair(CSeqFeatData::eQual_inference, "inference"),
    TQualPair(CSeqFeatData::eQual_insertion_seq, "insertion_seq"),
    TQualPair(CSeqFeatData::eQual_isolate, "isolate"),
    TQualPair(CSeqFeatData::eQual_isolation_source, "isolation_source"),
    TQualPair(CSeqFeatData::eQual_kinetoplast, "kinetoplast"),
    TQualPair(CSeqFeatData::eQual_lab_host, "lab_host"),
    TQualPair(CSeqFeatData::eQual_label, "label"),
    TQualPair(CSeqFeatData::eQual_lat_lon, "lat_lon"),
    TQualPair(CSeqFeatData::eQual_locus_tag, "locus_tag"),
    TQualPair(CSeqFeatData::eQual_macronuclear, "macronuclear"),
    TQualPair(CSeqFeatData::eQual_map, "map"),
    TQualPair(CSeqFeatData::eQual_mating_type, "mating_type"),
    TQualPair(CSeqFeatData::eQual_metagenomic, "metagenomic"),
    TQualPair(CSeqFeatData::eQual_mitochondrion, "mitochondrion"),
    TQualPair(CSeqFeatData::eQual_mobile_element, "mobile_element"),
    TQualPair(CSeqFeatData::eQual_mobile_element_type, "mobile_element_type"),
    TQualPair(CSeqFeatData::eQual_mod_base, "mod_base"),
    TQualPair(CSeqFeatData::eQual_mol_type, "mol_type"),
    TQualPair(CSeqFeatData::eQual_name, "name"),
    TQualPair(CSeqFeatData::eQual_ncRNA_class, "ncRNA_class"),
    TQualPair(CSeqFeatData::eQual_note, "note"),
    TQualPair(CSeqFeatData::eQual_number, "number"),
    TQualPair(CSeqFeatData::eQual_old_locus_tag, "old_locus_tag"),
    TQualPair(CSeqFeatData::eQual_operon, "operon"),
    TQualPair(CSeqFeatData::eQual_organelle, "organelle"),
    TQualPair(CSeqFeatData::eQual_organism, "organism"),
    TQualPair(CSeqFeatData::eQual_partial, "partial"),
    TQualPair(CSeqFeatData::eQual_PCR_conditions, "PCR_conditions"),
    TQualPair(CSeqFeatData::eQual_PCR_primers, "PCR_primers"),
    TQualPair(CSeqFeatData::eQual_phenotype, "phenotype"),
    TQualPair(CSeqFeatData::eQual_plasmid, "plasmid"),
    TQualPair(CSeqFeatData::eQual_pop_variant, "pop_variant"),
    TQualPair(CSeqFeatData::eQual_product, "product"),
    TQualPair(CSeqFeatData::eQual_protein_id, "protein_id"),
    TQualPair(CSeqFeatData::eQual_proviral, "proviral"),
    TQualPair(CSeqFeatData::eQual_pseudo, "pseudo"),
    TQualPair(CSeqFeatData::eQual_rearranged, "rearranged"),
    TQualPair(CSeqFeatData::eQual_region_name, "region_name"),
    TQualPair(CSeqFeatData::eQual_replace, "replace"),
    TQualPair(CSeqFeatData::eQual_ribosomal_slippage, "ribosomal_slippage"),
    TQualPair(CSeqFeatData::eQual_rpt_family, "rpt_family"),
    TQualPair(CSeqFeatData::eQual_rpt_type, "rpt_type"),
    TQualPair(CSeqFeatData::eQual_rpt_unit, "rpt_unit"),
    TQualPair(CSeqFeatData::eQual_rpt_unit_range, "rpt_unit_range" ),
    TQualPair(CSeqFeatData::eQual_rpt_unit_seq, "rpt_unit_seq" ),
    TQualPair(CSeqFeatData::eQual_satellite, "satellite"),
    TQualPair(CSeqFeatData::eQual_segment, "segment"),
    TQualPair(CSeqFeatData::eQual_sequenced_mol, "sequenced_mol"),
    TQualPair(CSeqFeatData::eQual_serotype, "serotype"),
    TQualPair(CSeqFeatData::eQual_serovar, "serovar"),
    TQualPair(CSeqFeatData::eQual_sex, "sex"),
    TQualPair(CSeqFeatData::eQual_site_type, "site_type"),
    TQualPair(CSeqFeatData::eQual_specimen_voucher, "specimen_voucher"),
    TQualPair(CSeqFeatData::eQual_standard_name, "standard_name"),
    TQualPair(CSeqFeatData::eQual_strain, "strain"),
    TQualPair(CSeqFeatData::eQual_sub_clone, "sub_clone"),
    TQualPair(CSeqFeatData::eQual_sub_species, "sub_species"),
    TQualPair(CSeqFeatData::eQual_sub_strain, "sub_strain"),
    TQualPair(CSeqFeatData::eQual_tag_peptide, "tag_peptide"),
    TQualPair(CSeqFeatData::eQual_tissue_lib, "tissue_lib"),
    TQualPair(CSeqFeatData::eQual_tissue_type, "tissue_type"),
    TQualPair(CSeqFeatData::eQual_trans_splicing, "trans_splicing"),
    TQualPair(CSeqFeatData::eQual_transcript_id, "transcript_id"),
    TQualPair(CSeqFeatData::eQual_transgenic, "transgenic"),
    TQualPair(CSeqFeatData::eQual_translation, "translation"),
    TQualPair(CSeqFeatData::eQual_transl_except, "transl_except"),
    TQualPair(CSeqFeatData::eQual_transl_table, "transl_table"),
    TQualPair(CSeqFeatData::eQual_transposon, "transposon"),
    TQualPair(CSeqFeatData::eQual_UniProtKB_evidence, "UniProtKB_evidence"),
    TQualPair(CSeqFeatData::eQual_usedin, "usedin"),
    TQualPair(CSeqFeatData::eQual_variety, "variety"),
    TQualPair(CSeqFeatData::eQual_virion, "virion")
};

typedef CStaticArrayMap<CSeqFeatData::EQualifier, string> TQualsMap;
DEFINE_STATIC_ARRAY_MAP(TQualsMap, sc_QualPairs, kQualPairs);

const string& CSeqFeatData::GetQualifierAsString(EQualifier qual)
{
    TQualsMap::const_iterator iter = sc_QualPairs.find(qual);
    return (iter != sc_QualPairs.end()) ? iter->second : kEmptyStr;
}


CSeqFeatData::EQualifier CSeqFeatData::GetQualifierType(const string& qual)
{
    CSeqFeatData::EQualifier type = CSeqFeatData::eQual_bad;;

    TQualsMap::const_iterator iter = sc_QualPairs.begin();
    while (iter != sc_QualPairs.end() && !NStr::Equal(qual, iter->second)) {
        ++iter;
    }
    if (iter != sc_QualPairs.end()) {
        type = iter->first;
    } else if (NStr::EqualNocase(qual, "specific_host")) {
        type = CSeqFeatData::eQual_host;
    }

    return type;
}


/////////////////// end of CSeqFeatData methods


const CFeatList* CSeqFeatData::GetFeatList()
{
    static auto_ptr<CFeatList> theFeatList;

    if ( !theFeatList.get() ) {
        DEFINE_STATIC_MUTEX(s_Mutex);
        CMutexGuard LOCK(s_Mutex);
        if ( !theFeatList.get() ) {
            theFeatList.reset(new CFeatList());
        }
    }
    return theFeatList.get();
}

const CBondList* CSeqFeatData::GetBondList()
{
    static auto_ptr<CBondList> theBondList;

    if ( !theBondList.get() ) {
        DEFINE_STATIC_MUTEX(s_Mutex);
        CMutexGuard LOCK(s_Mutex);
        if ( !theBondList.get() ) {
            theBondList.reset(new CBondList());
        }
    }
    return theBondList.get();
}


const CSiteList* CSeqFeatData::GetSiteList()
{
    static auto_ptr<CSiteList> theSiteList;

    if ( !theSiteList.get() ) {
        DEFINE_STATIC_MUTEX(s_Mutex);
        CMutexGuard LOCK(s_Mutex);
        if ( !theSiteList.get() ) {
            theSiteList.reset(new CSiteList());
        }
    }
    return theSiteList.get();
}


//////////////////////////////////////////////////////////////////////////////

static CFeatListItem sc_ConfigItemInit[] = {
    CFeatListItem( CSeqFeatData::e_not_set,  CSeqFeatData::eSubtype_any,   "All",  "Master" ),
    CFeatListItem( CSeqFeatData::e_Gene,     CSeqFeatData::eSubtype_gene,  "Gene", "Gene" ),
    CFeatListItem( CSeqFeatData::e_Org,      CSeqFeatData::eSubtype_org,   "Org",  "Org" ),
    CFeatListItem( CSeqFeatData::e_Cdregion, CSeqFeatData::eSubtype_cdregion,  "CDS",  "CDS" ),

    CFeatListItem( CSeqFeatData::e_Prot,     CSeqFeatData::eSubtype_any,   "Protein, All",  "Prot Master" ),
    CFeatListItem( CSeqFeatData::e_Prot,     CSeqFeatData::eSubtype_prot,  "Protein", "Prot" ),
    CFeatListItem( CSeqFeatData::e_Prot,     CSeqFeatData::eSubtype_preprotein,    "PreProtein", "PreProtein" ),
    CFeatListItem( CSeqFeatData::e_Prot,     CSeqFeatData::eSubtype_mat_peptide_aa,    "Mature Peptide AA", "Mat-Peptide AA" ),
    CFeatListItem( CSeqFeatData::e_Prot,     CSeqFeatData::eSubtype_sig_peptide_aa,    "Signal Peptide AA", "Sig-Peptide AA" ),
    CFeatListItem( CSeqFeatData::e_Prot,     CSeqFeatData::eSubtype_transit_peptide_aa,    "Transit Peptide AA", "Transit-Peptide AA" ),

    CFeatListItem( CSeqFeatData::e_Rna,     CSeqFeatData::eSubtype_any,   "RNA, All" , "RNA Master" ),
    CFeatListItem( CSeqFeatData::e_Rna,     CSeqFeatData::eSubtype_preRNA,  "precursor_RNA",   "precursor_RNA" ),
    CFeatListItem( CSeqFeatData::e_Rna,     CSeqFeatData::eSubtype_mRNA,  "mRNA", "mRNA" ),
    CFeatListItem( CSeqFeatData::e_Rna,     CSeqFeatData::eSubtype_tRNA,  "tRNA", "tRNA" ),
    CFeatListItem( CSeqFeatData::e_Rna,     CSeqFeatData::eSubtype_rRNA,  "rRNA", "rRNA" ),
    CFeatListItem( CSeqFeatData::e_Rna,     CSeqFeatData::eSubtype_snRNA,  "snRNA", "snRNA" ),
    CFeatListItem( CSeqFeatData::e_Rna,     CSeqFeatData::eSubtype_scRNA,  "scRNA", "scRNA" ),
    CFeatListItem( CSeqFeatData::e_Rna,     CSeqFeatData::eSubtype_snoRNA,  "sno_RNA", "sno_RNA" ),
    CFeatListItem( CSeqFeatData::e_Rna,     CSeqFeatData::eSubtype_ncRNA,  "ncRNA", "ncRNA" ),
    CFeatListItem( CSeqFeatData::e_Rna,     CSeqFeatData::eSubtype_tmRNA,  "tmRNA", "tmRNA" ),
    CFeatListItem( CSeqFeatData::e_Rna,     CSeqFeatData::eSubtype_otherRNA,  "misc_RNA",  "misc_RNA" ),

    CFeatListItem( CSeqFeatData::e_Pub,     CSeqFeatData::eSubtype_pub,   "Pub", "Pub" ),
    CFeatListItem( CSeqFeatData::e_Seq,     CSeqFeatData::eSubtype_seq,   "Seq", "Seq" ),

    CFeatListItem( CSeqFeatData::e_Imp,      CSeqFeatData::eSubtype_any,   "Import All", "Import Master" ),

    CFeatListItem( CSeqFeatData::e_Region,   CSeqFeatData::eSubtype_region,    "region",     "region" ),
    CFeatListItem( CSeqFeatData::e_Comment,  CSeqFeatData::eSubtype_comment,    "comment",     "comment" ),
    CFeatListItem( CSeqFeatData::e_Bond,     CSeqFeatData::eSubtype_bond,    "bond",     "bond" ),
    CFeatListItem( CSeqFeatData::e_Site,     CSeqFeatData::eSubtype_site,    "site",     "site" ),
    CFeatListItem( CSeqFeatData::e_Rsite,    CSeqFeatData::eSubtype_rsite,    "rsite",     "rsite" ),
    CFeatListItem( CSeqFeatData::e_User,     CSeqFeatData::eSubtype_user,    "user",     "user" ),
    CFeatListItem( CSeqFeatData::e_Txinit,   CSeqFeatData::eSubtype_txinit,    "txinit",     "txinit" ),
    CFeatListItem( CSeqFeatData::e_Num,      CSeqFeatData::eSubtype_num,    "num",     "num" ),
    CFeatListItem( CSeqFeatData::e_Psec_str, CSeqFeatData::eSubtype_psec_str,    "psec_str",     "psec_str" ),
    CFeatListItem( CSeqFeatData::e_Non_std_residue,     CSeqFeatData::eSubtype_non_std_residue,    "non_std_residue",     "non_std_residue" ),
    CFeatListItem( CSeqFeatData::e_Het,      CSeqFeatData::eSubtype_het,    "het",     "het" ),
    CFeatListItem( CSeqFeatData::e_Biosrc,   CSeqFeatData::eSubtype_biosrc,    "biosrc",     "biosrc" ),
    CFeatListItem( CSeqFeatData::e_Clone,    CSeqFeatData::eSubtype_clone,     "clone",      "clone" ),
    CFeatListItem( CSeqFeatData::e_Variation, CSeqFeatData::eSubtype_variation_ref, "variation",  "variation" ),
};


/**
    CFeatListItem comparator
    to sort the set properly.
*/
bool CFeatListItem::operator<(const CFeatListItem& rhs) const
{
    if (m_Type == rhs.m_Type) {
        // the 'Any' subtype should sort lower than anything else in that type.
        if (m_Subtype == CSeqFeatData::eSubtype_any) {
            return rhs.m_Subtype != CSeqFeatData::eSubtype_any;
        }
        if ( rhs.m_Subtype == CSeqFeatData::eSubtype_any) {
            return false;
        }
        return m_Subtype < rhs.m_Subtype;
    }
    return m_Type < rhs.m_Type;
}


/*****
    CFeatList definitions.
*****/

CFeatList::CFeatList()
{
    x_Init();
}


CFeatList::~CFeatList()
{
}

bool CFeatList::TypeValid(int type, int subtype) const
{
    const_iterator ci_it = m_FeatTypes.find(CFeatListItem(type, subtype, "", ""));
    if (ci_it == m_FeatTypes.end()) {
        return false;
    }
    return true;
}


bool CFeatList::GetItem(int type, int subtype, CFeatListItem& config_item) const
{
    const_iterator ci_it = m_FeatTypes.find(CFeatListItem(type, subtype, "", ""));
    if (ci_it == m_FeatTypes.end()) {
        return false;
    }
    config_item = *ci_it;
    return true;
}


bool CFeatList::GetItemBySubtype(int subtype,  CFeatListItem& config_item) const
{
    TSubtypeMap::const_iterator fm_it = m_FeatTypeMap.find(subtype);
    if (fm_it == m_FeatTypeMap.end()) {
        return false;
    }
    config_item = fm_it->second;
    return true;
}


bool CFeatList::GetItemByDescription(const string& desc, CFeatListItem& config_item) const
{
    const_iterator ci_it = begin();
    for (; ci_it != end(); ++ci_it) {
        if (NStr::EqualNocase(ci_it->GetDescription(), desc)) {
            config_item = *ci_it;
            return true;
        }
    }
    return false;
}


bool CFeatList::GetTypeSubType(const string& desc, int& type, int& subtype) const
{
    CFeatListItem config_item;
    if ( GetItemByDescription(desc, config_item) ) {
        type = config_item.GetType();
        subtype = config_item.GetSubtype();
        return true;
    }
    return false;
}

bool CFeatList::GetItemByKey(const string& key, CFeatListItem& config_item) const
{
    const_iterator ci_it = begin();
    for (; ci_it != end(); ++ci_it) {
        if (ci_it->GetStoragekey() == key) {
            config_item = *ci_it;
            return true;
        }
    }
    return false;
}


string CFeatList::GetDescription(int type, int subtype) const
{
    CFeatListItem config_item;
    if (!GetItem(type, subtype, config_item)) {
        return kEmptyStr;
    }
    return config_item.GetDescription();
}


string CFeatList::GetStoragekey(int type, int subtype) const
{
    CFeatListItem config_item;
    if (!GetItem(type, subtype, config_item)) {
        return kEmptyStr;
    }
    return config_item.GetStoragekey();
}


string CFeatList::GetStoragekey(int subtype) const
{
    CFeatListItem config_item;
    if (!GetItemBySubtype(subtype, config_item)) {
        return kEmptyStr;
    }
    return config_item.GetStoragekey();
}


vector<string> CFeatList::GetStoragekeys(int subtype) const
{
    vector<string> keys;
    keys.push_back(GetStoragekey(CSeqFeatData::e_not_set, CSeqFeatData::eSubtype_any));
    if (subtype != CSeqFeatData::eSubtype_any) {
        CFeatListItem item;
        if (GetItemBySubtype(subtype, item)) {
            CFeatListItem sub_master_item;
            if (GetItem(item.GetType(), CSeqFeatData::eSubtype_any, sub_master_item)) {
                keys.push_back(sub_master_item.GetStoragekey());
            }
            keys.push_back(item.GetStoragekey());
        }
    }

    return keys;
}

void CFeatList::x_Init()
{
    size_t  config_item_size = sizeof(sc_ConfigItemInit)/sizeof(CFeatListItem);
    for (size_t i = 0; i < config_item_size; ++i ) {
        bool feat_items_init_no_dups =
           m_FeatTypes.insert(sc_ConfigItemInit[i]).second;
        _VERIFY(feat_items_init_no_dups);
    }
    
    for (const SImportEntry* iep = kImportTable; iep < kImportTableEnd; ++iep) {
        CFeatListItem item(CSeqFeatData::GetTypeFromSubtype(iep->m_Subtype), 
                           iep->m_Subtype, iep->m_Name, iep->m_Name);
        bool import_items_init_no_dups =
            m_FeatTypes.insert(item).second;
        _VERIFY(import_items_init_no_dups);
    }

    ITERATE(CFeatList, it, m_FeatTypes) {
        const CFeatListItem& item = *it;
        int subtype = item.GetSubtype();
        if (subtype != CSeqFeatData::eSubtype_any  ||  item.GetType() == CSeqFeatData::e_not_set) {
            // only enter the main Master item, no other master items.
            // else subtypes are not unique.
            m_FeatTypeMap[subtype] = item;
        }
    }
}


/// return a list of all the feature descriptions for a menu or other control.
void CFeatList::GetDescriptions(vector<string> &descs, bool hierarchical) const
{
    descs.clear();


    ITERATE (TFeatTypeContainer, iter, m_FeatTypes) {
        string  this_desc = iter->GetDescription();

        if (hierarchical) {
            string parent_desc;
            if (iter->GetSubtype() != CSeqFeatData::eSubtype_any) {
                parent_desc = GetDescription(iter->GetType(), CSeqFeatData::eSubtype_any);
            } else if (iter->GetType() != CSeqFeatData::e_not_set) {
                parent_desc = this_desc;
            }

            if ( ! parent_desc.empty()) {
                this_desc = parent_desc + "/" + this_desc;
            }
        }

        descs.push_back(this_desc);
    }
}

string x_SpaceToDash(string str1)
{
    string::size_type pos = 0;
    while ((pos = NStr::Find(str1, " ", pos)) != NCBI_NS_STD::string::npos) {
        str1[pos] = '-';
    }
    return str1;
}

/////////////////////////////////////////////////////////////////////////////

static const CBondList::TBondKey bond_key_to_subtype [] = {
    CBondList::TBondKey ( "disulfide",  CSeqFeatData::eBond_disulfide  ),
    CBondList::TBondKey ( "other",      CSeqFeatData::eBond_other      ),
    CBondList::TBondKey ( "thioether",  CSeqFeatData::eBond_thioether  ),
    CBondList::TBondKey ( "thiolester", CSeqFeatData::eBond_thiolester ),
    CBondList::TBondKey ( "xlink",      CSeqFeatData::eBond_xlink      )
};
DEFINE_CLASS_STATIC_ARRAY_MAP(CBondList::TBondMap, CBondList::sm_BondKeys, bond_key_to_subtype);

CBondList::CBondList()
{
}


CBondList::~CBondList()
{
}


bool CBondList::IsBondName(string str) const
{
    const_iterator ci_it = sm_BondKeys.find (x_SpaceToDash(str).c_str());
    if (ci_it != sm_BondKeys.end ()) {
        return true;
    } else {
        return false;
    }
}


bool CBondList::IsBondName (string str, CSeqFeatData::EBond& bond_type) const
{
    const_iterator ci_it = sm_BondKeys.find (x_SpaceToDash(str).c_str());
    if (ci_it != sm_BondKeys.end ()) {
        bond_type = ci_it->second;
        return true;
    } else {
        return false;
    }
}


CSeqFeatData::EBond CBondList::GetBondType(string str) const
{
    const_iterator ci_it = sm_BondKeys.find (x_SpaceToDash(str).c_str());
    if (ci_it == sm_BondKeys.end()) {
        NCBI_THROW(CException, eUnknown, "Not a valid bond type!");
    } else {
        return ci_it->second;
    }
}
/////////////////////////////////////////////////////////////////////////////

static const CSiteList::TSiteKey site_key_to_subtype [] = {
    CSiteList::TSiteKey ( "acetylation",                 CSeqFeatData::eSite_acetylation                 ),
    CSiteList::TSiteKey ( "active",                      CSeqFeatData::eSite_active                      ),
    CSiteList::TSiteKey ( "amidation",                   CSeqFeatData::eSite_amidation                   ),
    CSiteList::TSiteKey ( "binding",                     CSeqFeatData::eSite_binding                     ),
    CSiteList::TSiteKey ( "blocked",                     CSeqFeatData::eSite_blocked                     ),
    CSiteList::TSiteKey ( "cleavage",                    CSeqFeatData::eSite_cleavage                    ),
    CSiteList::TSiteKey ( "DNA binding",                 CSeqFeatData::eSite_dna_binding                 ),
    CSiteList::TSiteKey ( "gamma carboxyglutamic acid",  CSeqFeatData::eSite_gamma_carboxyglutamic_acid  ),
    CSiteList::TSiteKey ( "glycosylation",               CSeqFeatData::eSite_glycosylation               ),
    CSiteList::TSiteKey ( "hydroxylation",               CSeqFeatData::eSite_hydroxylation               ),
    CSiteList::TSiteKey ( "inhibit",                     CSeqFeatData::eSite_inhibit                     ),
    CSiteList::TSiteKey ( "lipid binding",               CSeqFeatData::eSite_lipid_binding               ),
    CSiteList::TSiteKey ( "metal binding",               CSeqFeatData::eSite_metal_binding               ),
    CSiteList::TSiteKey ( "methylation",                 CSeqFeatData::eSite_methylation                 ),
    CSiteList::TSiteKey ( "modified",                    CSeqFeatData::eSite_modified                    ),
    CSiteList::TSiteKey ( "mutagenized",                 CSeqFeatData::eSite_mutagenized                 ),
    CSiteList::TSiteKey ( "myristoylation",              CSeqFeatData::eSite_myristoylation              ),
    CSiteList::TSiteKey ( "nitrosylation",               CSeqFeatData::eSite_nitrosylation               ),
    CSiteList::TSiteKey ( "np binding",                  CSeqFeatData::eSite_np_binding                  ),
    CSiteList::TSiteKey ( "other",                       CSeqFeatData::eSite_other                       ),
    CSiteList::TSiteKey ( "oxidative deamination",       CSeqFeatData::eSite_oxidative_deamination       ),
    CSiteList::TSiteKey ( "phosphorylation",             CSeqFeatData::eSite_phosphorylation             ),
    CSiteList::TSiteKey ( "pyrrolidone carboxylic acid", CSeqFeatData::eSite_pyrrolidone_carboxylic_acid ),
    CSiteList::TSiteKey ( "signal peptide",              CSeqFeatData::eSite_signal_peptide              ),
    CSiteList::TSiteKey ( "sulfatation",                 CSeqFeatData::eSite_sulfatation                 ),
    CSiteList::TSiteKey ( "transit peptide",             CSeqFeatData::eSite_transit_peptide             ),
    CSiteList::TSiteKey ( "transmembrane region",        CSeqFeatData::eSite_transmembrane_region        ),
    CSiteList::TSiteKey ( "unclassified",                CSeqFeatData::eSite_other                       ),
};

DEFINE_CLASS_STATIC_ARRAY_MAP(CSiteList::TSiteMap, CSiteList::sm_SiteKeys, site_key_to_subtype);

CSiteList::CSiteList()
{
}


CSiteList::~CSiteList()
{
}


bool CSiteList::IsSiteName(string str) const
{
    const_iterator ci_it = sm_SiteKeys.find (x_SpaceToDash(str).c_str());
    if (ci_it != sm_SiteKeys.end ()) {
        return true;
    } else {
        return false;
    }
}


bool CSiteList::IsSiteName (string str, CSeqFeatData::ESite& site_type) const
{
    const_iterator ci_it = sm_SiteKeys.find (x_SpaceToDash(str).c_str());
    if (ci_it != sm_SiteKeys.end ()) {
        site_type = ci_it->second;
        return true;
    } else {
        return false;
    }
}


CSeqFeatData::ESite CSiteList::GetSiteType(string str) const
{
    const_iterator ci_it = sm_SiteKeys.find (x_SpaceToDash(str).c_str());
    if (ci_it == sm_SiteKeys.end()) {
        NCBI_THROW(CException, eUnknown, "Not a valid site type!");
    } else {
        return ci_it->second;
    }
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 61, chars: 1894, CRC32: 86fb976 */
