/*
 * Decompiled with CFR 0.152.
 */
package ptbgui;

import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class ArgsParser {
    private final String m_Undef = new String("UNDEFINED");
    private int m_nCmd = 0;
    private String m_Ptb;
    private String m_Root;
    private String m_Subtree;
    private String m_BuildRoot;
    private String m_BuildRootToSolution;
    private String m_SolutionPath;
    private String m_SolutionFile;
    private String m_SolutionFileExt;
    private String m_extroot;
    private String m_projtag;
    private String m_ide;
    private String m_arch;
    private String m_logfile;
    private String m_conffile;
    private String m_Unknown = new String();
    private boolean m_dll = false;
    public boolean m_nobuildptb = false;
    public boolean m_ext = false;
    public boolean m_nws = false;
    public boolean m_i = false;
    public boolean m_dtdep = false;
    private boolean m_projtagFromLst;
    private String m_ArgsFile;

    public void init(String[] args) {
        this.m_projtagFromLst = false;
        this.m_nCmd = args.length;
        eArg dest = eArg.undefined;
        int iPositional = 0;
        for (int i = 0; i < args.length; ++i) {
            if (i == 0) {
                this.m_Ptb = ArgsParser.toCanonicalPath(args[i]);
                ++iPositional;
                continue;
            }
            if (args[i].length() > 0 && args[i].charAt(0) == '-') {
                dest = this.toEnum(args[i]);
                switch (dest) {
                    case dll: {
                        this.m_dll = true;
                        break;
                    }
                    case nobuildptb: {
                        this.m_nobuildptb = true;
                        break;
                    }
                    case ext: {
                        this.m_ext = true;
                        break;
                    }
                    case nws: {
                        this.m_nws = true;
                        break;
                    }
                    case undefined: {
                        this.m_Unknown.concat(args[i]);
                        break;
                    }
                    case cfg: {
                        --this.m_nCmd;
                        break;
                    }
                    case i: {
                        this.m_i = true;
                        break;
                    }
                    case dtdep: {
                        this.m_dtdep = true;
                    }
                }
                continue;
            }
            if (dest != eArg.undefined) {
                switch (dest) {
                    case extroot: {
                        this.m_extroot = ArgsParser.toCanonicalPath(args[i]);
                        break;
                    }
                    case projtag: {
                        this.m_projtag = args[i];
                        break;
                    }
                    case ide: {
                        this.m_ide = args[i];
                        break;
                    }
                    case arch: {
                        this.m_arch = args[i];
                        break;
                    }
                    case logfile: {
                        this.m_logfile = ArgsParser.toCanonicalPath(args[i]);
                        break;
                    }
                    case conffile: {
                        this.m_conffile = ArgsParser.toCanonicalPath(args[i]);
                        break;
                    }
                    case args: {
                        this.m_ArgsFile = ArgsParser.toCanonicalPath(args[i]);
                    }
                }
                dest = eArg.undefined;
                continue;
            }
            switch (iPositional) {
                case 1: {
                    this.m_Root = ArgsParser.toCanonicalPath(args[i]);
                    break;
                }
                case 2: {
                    this.m_Subtree = args[i];
                    break;
                }
                case 3: {
                    this.parseSolutionPath(ArgsParser.toCanonicalPath(args[i]));
                }
            }
            ++iPositional;
        }
    }

    private void parseSolutionPath(String solution) {
        File f = new File(solution);
        this.m_SolutionPath = f.getParent();
        this.m_SolutionFile = f.getName();
        this.m_SolutionFileExt = "";
        if (this.m_SolutionFile.endsWith(".sln")) {
            this.m_SolutionFileExt = ".sln";
            this.m_SolutionFile = this.m_SolutionFile.replaceFirst("[.]sln$", "");
        }
        if (f.getParentFile().getName().equals("build")) {
            String t = f.getParentFile().getParentFile().getName();
            if (t.equals("static") || t.equals("dll") || t.equals("user")) {
                this.m_BuildRoot = f.getParentFile().getParentFile().getParent();
                this.m_BuildRootToSolution = t + File.separator + "build";
            }
        } else if (f.getParentFile().getName().equals("static")) {
            this.m_BuildRoot = f.getParentFile().getParent();
            this.m_BuildRootToSolution = "static";
        } else if (f.getParentFile().getName().equals("dll")) {
            this.m_BuildRoot = f.getParentFile().getParent();
            this.m_BuildRootToSolution = "dll";
        }
        if (this.m_BuildRoot == null) {
            this.m_BuildRoot = this.m_SolutionPath;
            this.m_BuildRootToSolution = ".";
        }
    }

    public String[] createCommandline() {
        String l;
        Vector<String> vcmd = new Vector<String>();
        vcmd.add(this.m_Ptb);
        if (this.m_ArgsFile != null && this.m_ArgsFile.length() != 0) {
            vcmd.add("-args");
            vcmd.add(this.m_ArgsFile);
            if (this.m_i) {
                vcmd.add("-" + eArg.i.toString());
            }
            if (this.m_dtdep) {
                vcmd.add("-" + eArg.dtdep.toString());
            }
            if (this.m_logfile != null && this.m_logfile.length() != 0) {
                vcmd.add("-" + eArg.logfile.toString());
                l = this.getSolution();
                if (!l.equals(this.m_Undef)) {
                    vcmd.add(l + "_configuration_log.txt");
                } else {
                    vcmd.add(this.m_logfile);
                }
            }
        } else {
            if (this.m_nobuildptb) {
                vcmd.add("-" + eArg.nobuildptb.toString());
            }
            if (this.m_dll) {
                vcmd.add("-" + eArg.dll.toString());
            }
            if (this.m_i) {
                vcmd.add("-" + eArg.i.toString());
            }
            if (this.m_dtdep) {
                vcmd.add("-" + eArg.dtdep.toString());
            }
            if (this.m_nws) {
                vcmd.add("-" + eArg.nws.toString());
            }
            if (this.m_ext) {
                vcmd.add("-" + eArg.ext.toString());
            }
            if (this.m_ext && this.m_extroot != null && this.m_extroot.length() != 0) {
                vcmd.add("-" + eArg.extroot.toString());
                vcmd.add(this.m_extroot);
            }
            if (this.m_projtag != null && this.m_projtag.length() != 0) {
                vcmd.add("-" + eArg.projtag.toString());
                vcmd.add(this.m_projtag);
            } else if (this.m_projtagFromLst) {
                vcmd.add("-" + eArg.projtag.toString());
                vcmd.add("\"\"");
            }
            if (this.m_ide != null && this.m_ide.length() != 0) {
                vcmd.add("-" + eArg.ide.toString());
                vcmd.add(this.m_ide);
            }
            if (this.m_arch != null && this.m_arch.length() != 0) {
                vcmd.add("-" + eArg.arch.toString());
                vcmd.add(this.m_arch);
            }
            if (this.m_logfile != null && this.m_logfile.length() != 0) {
                vcmd.add("-" + eArg.logfile.toString());
                l = this.getSolution();
                if (!l.equals(this.m_Undef)) {
                    vcmd.add(l + "_configuration_log.txt");
                } else {
                    vcmd.add(this.m_logfile);
                }
            }
            if (this.m_conffile != null && this.m_conffile.length() != 0) {
                vcmd.add("-" + eArg.conffile.toString());
                vcmd.add(this.m_conffile);
            }
        }
        vcmd.add(this.m_Root);
        if (this.m_Subtree.length() > 0) {
            vcmd.add(this.m_Subtree);
        } else {
            vcmd.add("\"\"");
        }
        vcmd.add(this.getSolution());
        String[] cmd = new String[vcmd.size()];
        for (int i = 0; i < vcmd.size(); ++i) {
            cmd[i] = ((String)vcmd.get(i)).toString();
        }
        return cmd;
    }

    public static String toCanonicalPath(String path) {
        File f0 = new File(path);
        if (!f0.isAbsolute()) {
            path = System.getProperty("user.dir") + File.separator + path;
        }
        File f = new File(path);
        path = f.getAbsolutePath();
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public static boolean existsPath(String path) {
        if (path != null) {
            File f = new File(path);
            return f.exists();
        }
        return false;
    }

    public String getPtb() {
        return this.m_Ptb != null && this.m_Ptb.length() > 0 ? this.m_Ptb : this.m_Undef;
    }

    public void setPtb(String ptb) {
        this.m_Ptb = ptb.trim();
    }

    public String getRoot() {
        return this.m_Root != null && this.m_Root.length() > 0 ? this.m_Root : this.m_Undef;
    }

    public void setRoot(String root) {
        this.m_Root = root.trim();
    }

    public String getSubtree() {
        return this.m_Subtree != null && this.m_Subtree.length() > 0 ? this.m_Subtree : this.m_Undef;
    }

    public void setSubtree(String subtree) {
        this.m_Subtree = subtree.trim();
    }

    public String getBuildRoot() {
        return this.m_BuildRoot != null ? this.m_BuildRoot : this.m_Undef;
    }

    public boolean getDll() {
        return this.m_dll;
    }

    public void setDll(boolean dll, boolean adjustpath) {
        if (this.m_dll != dll) {
            if (adjustpath) {
                if (this.m_dll) {
                    if (!this.m_BuildRoot.equals(this.m_SolutionPath)) {
                        this.m_BuildRootToSolution = this.m_BuildRootToSolution.replaceFirst("^dll", "static");
                    }
                    this.m_SolutionFile = this.m_SolutionFile.replaceFirst("_dll$", "");
                } else {
                    if (!this.m_BuildRoot.equals(this.m_SolutionPath)) {
                        this.m_BuildRootToSolution = this.m_BuildRootToSolution.replaceFirst("^static", "dll");
                    }
                    this.m_SolutionFile = this.m_SolutionFile + "_dll";
                }
            }
            this.m_dll = dll;
        }
    }

    public String getSolution() {
        try {
            if (!this.m_BuildRoot.equals(this.m_SolutionPath)) {
                return this.m_BuildRoot + File.separator + this.m_BuildRootToSolution + File.separator + this.m_SolutionFile + this.m_SolutionFileExt;
            }
            return this.m_SolutionPath + File.separator + this.m_SolutionFile + this.m_SolutionFileExt;
        }
        catch (Exception exception) {
            return this.m_Undef;
        }
    }

    public String getSolutionFile() {
        return this.m_SolutionFile != null && this.m_SolutionFile.length() > 0 ? this.m_SolutionFile : this.m_Undef;
    }

    public void setSolutionFile(String solution) {
        this.m_SolutionFile = solution.trim();
    }

    public String getExtRoot() {
        return this.m_extroot != null ? this.m_extroot : "";
    }

    public void setExtRoot(String exroot) {
        this.m_extroot = exroot.trim();
    }

    public String getProjTag() {
        return this.m_projtag != null && this.m_projtag.length() != 0 ? this.m_projtag : "*";
    }

    public void setProjTag(String tag) {
        String t = tag.trim();
        this.m_projtag = t.equals("*") ? "" : tag;
    }

    public void setProjTagFromLst(String tag) {
        String t = tag.trim();
        this.m_projtag = t.equals("*") ? "" : tag;
        this.m_projtagFromLst = true;
    }

    public String getIde() {
        return this.m_ide != null ? this.m_ide : "";
    }

    public String getArch() {
        return this.m_arch != null ? this.m_arch : "";
    }

    public void setArch(String arch) {
        this.m_arch = arch.trim();
    }

    public void setArgsFile(String args) {
        String t;
        this.m_ArgsFile = args == null ? "" : (ArgsParser.existsPath(t = args.trim()) ? t : "");
    }

    public String getArgsFile() {
        return this.m_ArgsFile != null && ArgsParser.existsPath(this.m_ArgsFile) ? this.m_ArgsFile : "";
    }

    private eArg toEnum(String a) {
        eArg t = eArg.undefined;
        try {
            t = eArg.valueOf(a.replace('-', ' ').trim());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum eArg {
        undefined,
        dll,
        nobuildptb,
        ext,
        nws,
        extroot,
        projtag,
        ide,
        arch,
        logfile,
        conffile,
        cfg,
        i,
        dtdep,
        args;

    }
}

