# This module finds Xscreensaver library on your system
# Author: Park "segfault" Joon-Kyu
#
# XSS_FOUND            - system has Xscreensaver development files
# XSS_INCLUDE_DIR      - the include dir
# XSS_LIBRARY          - the Xss library

include(UsePkgConfig)

pkgconfig(scrnsaverproto, _XssIncludeDir, _XssLinkDir, _XssLDFlags, _XssCFlags)

find_path(XSS_INCLUDE_DIR X11/extensions/scrnsaver.h PATHS ${_XssIncludeDir})
find_library(XSS_LIBRARY NAMES Xss PATHS ${_XssLinkDir})

if(XSS_INCLUDE_DIR AND XSS_LIBRARIES)
	message(STATUS "Found Xss: ${XSS_LIBRARIES}")
	set(XSS_FOUND TRUE)
else(XSS_INCLUDE_DIR AND XSS_LIBRARIES)
	set(XSS_FOUND FALSE)
endif(XSS_INCLUDE_DIR AND XSS_LIBRARIES)
