/*
 * NASPRO - The NASPRO Architecture for Sound Processing
 * Core library
 *
 * Copyright (C) 2007-2011 NASPRO core development team
 *
 * See the COPYING file for license conditions.
 */

#include "internal.h"

const char *
nacore_env_get(const char *name)
{
	const char *ret;

	ret = getenv(name);
	if (ret == NULL)
		errno = ENOENT;

	return ret;
}

void
nacore_env_free(const char *value)
{
}

_NACORE_DEF nacore_list
nacore_env_path_prefixes_split(const char *path)
{
	nacore_list ret;
	nacore_list_elem elem;
	const char *s;
	char z;

	ret = nacore_string_split(path, ":", NULL, NULL);
	if (ret == NULL)
		return NULL;

	z = 0;
	elem = nacore_list_get_head(ret);
	s = nacore_list_elem_get_value(ret, elem);
	if (*s == '\0')
	  {
		if (nacore_list_elem_set_value(ret, elem, NULL, NULL, NULL, ".")
		    != 0)
		  {
			nacore_list_free(ret, NULL, NULL);
			return NULL;
		  }

		if (nacore_list_get_n_elems(ret) == 1)
			return ret;

		z = 1;
	  }

	elem = nacore_list_get_tail(ret);
	s = nacore_list_elem_get_value(ret, elem);
	if (*s == '\0')
	  {
		if (z)
		  {
			free(nacore_list_pop(ret, elem));
			return ret;
		  }

		if (nacore_list_elem_set_value(ret, elem, NULL, NULL, NULL, ".")
		    != 0)
		  {
			nacore_list_free(ret, NULL, NULL);
			return NULL;
		  }
	  }

	return ret;
}
