#include <qfiledialog.h>
#include <qradiobutton.h>
#include <qfile.h>
#include <qmessagebox.h>
#include <qapplication.h>
#include <qlistview.h>
#include <qdatetime.h>
#include "script.h"
#include "include/sql.h"
#include "include/xchecklistitem.h"
#include "mainwindow.h"
#include "loglistviewitem.h"

void Script::slot_fire()
{
	if(database->currentText().isEmpty() == FALSE)
		mysql_select_db(mysql, database->currentText().latin1());

	QListViewItemIterator z(this);

	for(; z.current(); z++)
	{
		if(((XCheckListItem *)z.current())->isOn() == FALSE)
			continue;

		if(z.current()->itemAbove())
			z.current()->itemAbove()->setText(0, "");

		z.current()->setText(0, ">>");	
		
		ensureItemVisible(z.current());
		qApp->processEvents();	

		if(SQL::sql_query(z.current()->text(1).local8Bit().data()))
			z.current()->setText(2, QString::fromLocal8Bit(mysql_error(mysql)));
		else
			z.current()->setText(2, "No error...");
	}

	emit signal_schema();
}

void Script::slot_script()
{
	QString script = QFileDialog::getOpenFileName(QString::null, "*.sql", this);

	if(script.isEmpty())
		return;

	QFile sql(script);

	if(sql.open(IO_ReadOnly) == FALSE)
	{
		QMessageBox::critical(this, tr("MySQL Navigator"), tr("Script file open failed."));
		return;
	}
	
	clear();

	char *z1= new char[sql.size() + 1];
	memset(z1, 0, sql.size() + 1);
	sql.readBlock(z1, sql.size());
	sql.close();

	unsigned int s;

	QString z = SQL::strip_comment(QString(z1).latin1());
	QList<QString> query = SQL::split_sql(z);
	query.setAutoDelete(TRUE);

	XCheckListItem *value;
	XCheckListItem *a = NULL;

	for(s = 0; s < query.count(); s++)
	{
		if((*query.at(s)).stripWhiteSpace().isEmpty())
			continue;

		value = new XCheckListItem(this, "", QCheckListItem::CheckBox);
		value->setText(1, QString::fromLocal8Bit((*query.at(s)).simplifyWhiteSpace()));
		value->data = QString::fromLocal8Bit((*query.at(s)));


		value->setOn(TRUE);

		//value->slot_row_height(value);

		value->moveItem(a);

		a = value;
	}

	delete []z1;

	flag = FALSE;

	((QMainWindow *)parentWidget())->statusBar()->message(tr(" Queries: ") + QString::number(childCount()));
}

void Script::slot_close()
{
	parentWidget()->close();
}

void Script::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), "This is Script"); 
}

void Script::slot_clear()
{
	clear();
	((QMainWindow *)parentWidget())->statusBar()->message(tr(" Queries: ") + QString::number(childCount()));
}

void Script::slot_database()
{
	MYSQL_RES *result;
	MYSQL_ROW row;

	database->clear();

	database->insertItem("");

	result = mysql_list_dbs(mysql,NULL);

	if(result == NULL)
	{
		return;
	}

	while((row = mysql_fetch_row(result)))
	{
		database->insertItem(row[0]);
	}

	mysql_free_result(result);
}

void Script::slot_select_all()
{
	QListViewItemIterator z(this);
	for(; z.current(); z++)
		((XCheckListItem *)z.current())->setOn(TRUE);
}

void Script::slot_select_none()
{
	QListViewItemIterator z(this);
	for(; z.current(); z++)
		((XCheckListItem *)z.current())->setOn(FALSE);
}

void Script::slot_clicked(int z)
{
	if(z != 0)
		return;

	QListViewItemIterator s(this);
	for(; s.current(); s++)
	{
		if(flag)
			((QCheckListItem *)s.current())->setOn(TRUE);
		else
			((QCheckListItem *)s.current())->setOn(FALSE);
	}

	if(flag)
		flag = FALSE;
	else
		flag = TRUE;
}
