/*
 * muscleTool help functions file.
 *
 * MUSCLE SmartCard Development ( http://www.linuxnet.com )
 *
 * Copyright (C) 2004
 *  Toni Andjelkovic <toni@soth.at>
 *  Ludovic Rousseau <ludovic.rousseau@free.fr>
 *
 * $Id: help.c,v 1.1.1.2 2009-11-13 13:13:11 rousseau Exp $
 */

#include <stdio.h>
#include <string.h>

#include "help.h"

static const char *help_txt[] = {
	"",
	"Object related functions:",
	"----------------------------------------------------",
	"     create        Create an object",
	"     delete        Delete an object",
	"     write         Write from file to object",
	"     read          Read from object to file",
	"     list          List objects on token",
#ifdef VERSION2
	"     moveobject    Moves an object",
	"     changeacl     Change ACL of object",
#endif
	"",
	"PIN related functions:",
	"----------------------------------------------------",
	"     verify        Verify a pin",
	"     makepin       Create a pin",
	"     changepin     Change a pin",
	"     unblock       Unblock a pin",
	"     listpins      List the pins",
#ifdef VERSION2
	"     deleteid      Deletes an ID",
#endif
	"",
	"Key related functions:",
	"----------------------------------------------------",
	"     listkeys      List the keys",
	"     exportkey     Export a key",
	"     importkey     Import a key",
	"     genkeys       Generate keys",
#ifdef VERSION2
	"     deletekey     Deletes a key",
	"     movekey       Moves a key",
	"     changekeyacl  Change ACL of key",
#endif
	"     crypt         Perform a cipher operation on user input",
	"     filecrypt     Perform a cipher operation on a file",
	"",
	"General functions:",
	"----------------------------------------------------",
	"     format        Format a token",
	"     tokens        List available tokens",
	"     connect       Connect to a token",
	"     resume        Get the token capabilities",
	"     release       Release a token",
	"     status        Get the token status",
#ifdef VERSION2
	"     setstatus     Set token state",
#endif
	"     challenge     Get a random number",
	"     logout        Log out AUT",
	"     version       Print the program version",
	"     help          Show this help text",
	"     exit          Exit the program",
	"",
	"Strings are quoted with \"\":",
	"",
	"\tverify 0 \"foo bar\"",
	"",
	"Use help [name] to get help about a muscleTool function:",
	"",
	"\thelp crypt",
	"",
	NULL
};

static const char *help_help_txt[] = {
	"Show help about muscleTool functions.",
	"Usage: help [name]",
	"Arguments:",
	"    name        function name",
	NULL
};

static const char *help_create_txt[] = {
	"Create an object.",
	"Usage: create id size",
	"Arguments:",
	"    id          object id (string)",
	"    size        object size (num)",
	NULL
};

static const char *help_delete_txt[] = {
	"Delete an object.",
	"Usage: delete id",
	"Arguments:",
	"    id          object id (string)",
	NULL,
};

static const char *help_move_txt[] = {
	"Move an object.",
	"Usage: move oldid newid",
	"Arguments:",
	"    oldid       object id (string)",
	"    newid       object id (string)",
	NULL,
};

static const char *help_changeacl_txt[] = {
	"Changes the ACL of an object.",
	"Usage: changeacl id",
	"Arguments:",
	"       id       object id (string)",
	NULL,
};

static const char *help_write_txt[] = {
	"Write from file to object.",
	"Usage: write file id",
	"Arguments:",
	"    file        file path (string)",
	"    id          object id (string)",
	NULL
};

static const char *help_read_txt[] = {
	"Read from object to file.",
	"Usage: read id file",
	"Arguments:",
	"    id          object id (string)",
	"    file        file path (string)",
	NULL
};

static const char *help_list_txt[] = {
	"List objects on token.",
	"Usage: list",
	NULL
};

static const char *help_verify_txt[] = {
	"Verify a PIN.",
	"Usage: verify pin value",
	"Arguments:",
	"    pin         pin number (num)",
	"    value       pin value (string)",
	NULL
};

static const char *help_makepin_txt[] = {
	"Create a PIN.",
	"Usage: makepin pin value unblk",
	"Arguments:",
	"    pin         pin number (num)",
	"    value       pin value (string)",
	"    unblk       pin unblock code (string)",
	NULL
};

static const char *help_changepin_txt[] = {
	"Change a PIN.",
	"Usage: changepin pin ovalue nvalue",
	"Arguments:",
	"    pin         pin number (num)",
	"    ovalue      old pin value (string)",
	"    nvalue      new pin value (string)",
	NULL
};

static const char *help_unblock_txt[] = {
	"Unblock a PIN.",
	"Usage: unblock pin unblk",
	"Arguments:",
	"    pin         pin number (num)",
	"    unblk       pin unblock code (string)",
	NULL
};

static const char *help_listpins_txt[] = {
	"List PINs.",
	"Usage: listpins",
	NULL
};

static const char *help_listkeys_txt[] = {
	"List the keys.",
	"Usage: listkeys",
	NULL
};

static const char *help_changekeyacl_txt[] = {
	"Changes the ACL of a key.",
	"Usage: changekeyacl keynum",
	"Arguments:",
	"    keynum      key number (num)",
	NULL,
};

static const char *help_exportkey_txt[] = {
	"Export a key.",
	"Usage: exportkey keynum path",
	"Arguments:",
	"    keynum      key number (num)",
	"    path        path to local file (string)",
	NULL
};

static const char *help_movekey_txt[] = {
	"Move a key.",
	"Usage: movekey oldkeynum newkeynum",
	"Arguments:",
	"    oldkeynum      old key number (num)",
	"    newkeynum      new key number (num)",
	NULL
};

static const char *help_importkey_txt[] = {
	"Import a key.",
	"Usage: importkey pin path",
	"Arguments:",
	"    pin         pin number (num)",
	"    path        path to local file (string)",
	NULL
};

static const char *help_genkeys_txt[] = {
	"Generate keys.",
	"Usage: genkeys algorithm keysize ",
	"Arguments:",
	"    algorithm   algorithm des, tdes, tdes3, ecfp, ecf2m, aes, rsa, dsa or rsacrt (string)",
	"    keysize     size of key (num)",
	NULL
};

static const char *help_crypt_txt[] = {
	"Perform a cipher operation on user supplied text.",
	"Usage: crypt keynum",
	"Arguments:",
	"    keynum      key number (num)",
	NULL
};

static const char *help_filecrypt_txt[] = {
	"Perform a cipher operation on a file.",
	"Usage: crypt keynum infilename outfilename",
	"Arguments:",
	"    keynum      key number (num)",
	"    filename    infilename (str)",
	"    filename    outfilename (str)",
	NULL
};

static const char *help_format_txt[] = {
	"Format a token.",
	"Usage: format number",
	"Arguments:",
	"    number      token number (num)",
	NULL
};

static const char *help_tokens_txt[] = {
	"List available tokens.",
	"Usage: tokens",
	NULL
};

static const char *help_connect_txt[] = {
	"Connect to a token.",
	"Usage: connect number",
	"Arguments:",
	"    number      token number (num)",
	NULL
};

static const char *help_deletekey_txt[] = {
	"Delete a key.",
	"Usage: deletekey keynum",
	"Arguments:",
	"    keynum     key number (num)",
	NULL
};

static const char *help_deleteid_txt[] = {
	"Delete an ID (PIN or strong identity).",
	"Usage: deleteid ID",
	"Arguments:",
	"    ID        ID number (num)",
	NULL
};

static const char *help_resume_txt[] = {
	"Get the token capabilities.",
	"",
	"Resume related functions:",
	"----------------------------------------------------",
	"     crypt         List available crypto algorithms",
	"     rsa           List RSA capabilities",
	"     dsa           List DSA capabilities",
	"     des           List DES capabilities",
#ifdef VERSION2
	"     aes           List AES capabilities",
	"     ec            List Elliptic Curve capabilities",
#endif
	"     3des          List 3DES capabilities",
	"     3des3         List 3DES3 capabilities",
	"     keys          List key capabilities",
	"     pins          List PIN capabilities",
	"     objects       List object capabilities",
	NULL
};

static const char *help_resume_crypt_txt[] = {
	"List available crypto algorithms.",
	"Usage: resume crypt",
	NULL
};

static const char *help_resume_rsa_txt[] = {
	"List RSA capabilities.",
	"Usage: resume rsa",
	NULL
};

static const char *help_resume_dsa_txt[] = {
	"List DSA capabilities.",
	"Usage: resume dsa",
	NULL
};

static const char *help_resume_des_txt[] = {
	"List DES capabilities.",
	"Usage: resume des",
	NULL
};

static const char *help_resume_aes_txt[] = {
	"List AES capabilities.",
	"Usage: resume aes",
	NULL
};

static const char *help_resume_ec_txt[] = {
	"List Elliptic Curve capabilities.",
	"Usage: resume ec",
	NULL
};

static const char *help_resume_3des_txt[] = {
	"List 3DES capabilities.",
	"Usage: resume 3des",
	NULL
};

static const char *help_resume_3des3_txt[] = {
	"List 3DES3 capabilities.",
	"Usage: resume 3des3",
	NULL
};

static const char *help_resume_keys_txt[] = {
	"List key capabilities.",
	"Usage: resume keys",
	NULL
};

static const char *help_resume_pins_txt[] = {
	"List PIN capabilities.",
	"Usage: resume pins",
	NULL
};

static const char *help_resume_objects_txt[] = {
	"List object capabilities.",
	"Usage: resume objects",
	NULL
};

static const char *help_release_txt[] = {
	"Release a token.",
	"Usage: release",
	NULL
};

static const char *help_status_txt[] = {
	"Get the token status.",
	"Usage: status",
	NULL
};

static const char *help_setstatus_txt[] = {
	"Set a token state.",
	"Usage: setstatus",
	NULL
};

static const char *help_challenge_txt[] = {
	"Get a random number.",
	"Usage: challenge len",
	"Arguments:",
	"    len         challenge length (num)",
	NULL
};

static const char *help_logout_txt[] = {
	"Log out AUT.",
	"Usage: logout",
	NULL
};

static const char *help_version_txt[] = {
	"Print the program version.",
	"Usage: version",
	NULL
};

static const char *help_exit_txt[] = {
	"Exit the program.",
	"Usage: exit",
	NULL
};

static void print(const char *text[])
{
	int i;

	for (i = 0; text[i]; i++)
		printf("%s\n", text[i]);
}

void help(void)
{
	print(help_txt);
}

void help_help(void)
{
	print(help_help_txt);
}

void help_create(void)
{
	print(help_create_txt);
}

void help_delete(void)
{
	print(help_delete_txt);
}

void help_move(void)
{
	print(help_move_txt);
}

void help_movekey(void)
{
	print(help_movekey_txt);
}

void help_deletekey(void) {
	print(help_deletekey_txt);
}

void help_write(void)
{
	print(help_write_txt);
}

void help_read(void)
{
	print(help_read_txt);
}

void help_changeacl(void)
{
	print(help_changeacl_txt);
}

void help_list(void)
{
	print(help_list_txt);
}

void help_deleteid(void)
{
	print(help_deleteid_txt);
}

void help_verify(void)
{
	print(help_verify_txt);
}

void help_makepin(void)
{
	print(help_makepin_txt);
}

void help_changepin(void)
{
	print(help_changepin_txt);
}

void help_unblock(void)
{
	print(help_unblock_txt);
}

void help_listpins(void)
{
	print(help_listpins_txt);
}

void help_listkeys(void)
{
	print(help_listkeys_txt);
}

void help_changekeyacl(void)
{
	print(help_changekeyacl_txt);
}

void help_exportkey(void)
{
	print(help_exportkey_txt);
}

void help_importkey(void)
{
	print(help_importkey_txt);
}

void help_genkeys(void)
{
	print(help_genkeys_txt);
}

void help_crypt(void)
{
	print(help_crypt_txt);
}

void help_filecrypt(void)
{
	print(help_filecrypt_txt);
}

void help_format(void)
{
	print(help_format_txt);
}

void help_tokens(void)
{
	print(help_tokens_txt);
}

void help_connect(void)
{
	print(help_connect_txt);
}

void help_resume(void)
{
	print(help_resume_txt);
}

void help_resume_crypt(void)
{
	print(help_resume_crypt_txt);
}

void help_resume_rsa(void)
{
	print(help_resume_rsa_txt);
}

void help_resume_dsa(void)
{
	print(help_resume_dsa_txt);
}

void help_resume_des(void)
{
	print(help_resume_des_txt);
}

void help_resume_3des(void)
{
	print(help_resume_3des_txt);
}

void help_resume_3des3(void)
{
	print(help_resume_3des3_txt);
}

void help_resume_aes(void)
{
	print(help_resume_aes_txt);
}
void help_resume_ec(void)
{
	print(help_resume_ec_txt);
}

void help_resume_keys(void)
{
	print(help_resume_keys_txt);
}


void help_resume_pins(void)
{
	print(help_resume_pins_txt);
}

void help_resume_objects(void)
{
	print(help_resume_objects_txt);
}

void help_release(void)
{
	print(help_release_txt);
}

void help_status(void)
{
	print(help_status_txt);
}

void help_setstatus(void)
{
	print(help_setstatus_txt);
}

void help_challenge(void)
{
	print(help_challenge_txt);
}

void help_logout(void)
{
	print(help_logout_txt);
}

void help_version(void)
{
	print(help_version_txt);
}

void help_exit(void)
{
	print(help_exit_txt);
}

