/*
 *  getgroupcommand.cpp
 *  Mothur
 *
 *  Created by Thomas Ryabin on 2/2/09.
 *  Copyright 2009 Schloss Lab UMASS Amherst. All rights reserved.
 *
 */

#include "getgroupcommand.h"

//**********************************************************************************************************************
vector<string> GetgroupCommand::setParameters(){	
	try {
		CommandParameter pshared("shared", "InputTypes", "", "current", "none", "none", "none",false,true); parameters.push_back(pshared);
		CommandParameter pinputdir("inputdir", "String", "", "", "", "", "",false,false); parameters.push_back(pinputdir);
		CommandParameter poutputdir("outputdir", "String", "", "", "", "", "",false,false); parameters.push_back(poutputdir);
		
		vector<string> myArray;
		for (int i = 0; i < parameters.size(); i++) {	myArray.push_back(parameters[i].name);		}
		return myArray;
	}
	catch(exception& e) {
		m->errorOut(e, "GetgroupCommand", "setParameters");
		exit(1);
	}
}
//**********************************************************************************************************************
string GetgroupCommand::getHelpString(){	
	try {
		string helpString = "";
		helpString += "The get.group command parameter is shared and it's required if you have no valid current file.\n";
		//m->mothurOut("The get.group command outputs a .bootGroups file to you can use in addition to the tree file generated by the bootstrap.shared command to run the consensus command.\n");
		helpString += "You may not use any parameters with the get.group command.\n";
		helpString += "The get.group command should be in the following format: \n";
		helpString += "get.group()\n";
		helpString += "Example get.group().\n";
		return helpString;
	}
	catch(exception& e) {
		m->errorOut(e, "GetgroupCommand", "getHelpString");
		exit(1);
	}
}
//**********************************************************************************************************************
GetgroupCommand::GetgroupCommand(){	
	try {
		abort = true; calledHelp = true; 
		setParameters();
		vector<string> tempOutNames;
		outputTypes["bootgroup"] = tempOutNames;
	}
	catch(exception& e) {
		m->errorOut(e, "GetgroupCommand", "GetgroupCommand");
		exit(1);
	}
}
//**********************************************************************************************************************
GetgroupCommand::GetgroupCommand(string option)  {
	try {
		abort = false; calledHelp = false;   
		
		//allow user to run help
		if(option == "help") { help(); abort = true; calledHelp = true; }
		else if(option == "citation") { citation(); abort = true; calledHelp = true;}
		
		else {
			vector<string> myArray = setParameters();
			
			OptionParser parser(option);
			map<string,string> parameters = parser.getParameters();
			map<string,string>::iterator it;
			
			ValidParameters validParameter;
			//check to make sure all parameters are valid for command
			for (it = parameters.begin(); it != parameters.end(); it++) { 
				if (validParameter.isValidParameter(it->first, myArray, it->second) != true) {  abort = true;  }
			}
			
			//initialize outputTypes
			vector<string> tempOutNames;
			outputTypes["bootgroup"] = tempOutNames;
			
			//if the user changes the input directory command factory will send this info to us in the output parameter 
			string inputDir = validParameter.validFile(parameters, "inputdir", false);		
			if (inputDir == "not found"){	inputDir = "";		}
			else {
				string path;
				it = parameters.find("shared");
				//user has given a template file
				if(it != parameters.end()){ 
					path = m->hasPath(it->second);
					//if the user has not given a path then, add inputdir. else leave path alone.
					if (path == "") {	parameters["shared"] = inputDir + it->second;		}
				}
			}
			
			//get shared file
			sharedfile = validParameter.validFile(parameters, "shared", true);
			if (sharedfile == "not open") { sharedfile = ""; abort = true; }	
			else if (sharedfile == "not found") { 
				//if there is a current shared file, use it
				sharedfile = m->getSharedFile(); 
				if (sharedfile != "") { m->mothurOut("Using " + sharedfile + " as input file for the shared parameter."); m->mothurOutEndLine(); }
				else { 	m->mothurOut("You have no current sharedfile and the shared parameter is required."); m->mothurOutEndLine(); abort = true; }
			}else { m->setSharedFile(sharedfile); }
			
			
			//if the user changes the output directory command factory will send this info to us in the output parameter 
			outputDir = validParameter.validFile(parameters, "outputdir", false);		if (outputDir == "not found"){	outputDir = m->hasPath(sharedfile);		}
		}
	}
	catch(exception& e) {
		m->errorOut(e, "GetgroupCommand", "GetgroupCommand");
		exit(1);
	}
}
//**********************************************************************************************************************

int GetgroupCommand::execute(){
	try {
	
		if (abort == true) { if (calledHelp) { return 0; }  return 2;	}
		
		//open shared file
		m->openInputFile(sharedfile, in);
			
		//open output file
		outputFile = outputDir + m->getRootName(m->getSimpleName(sharedfile)) + "bootGroups";
		m->openOutputFile(outputFile, out);
			
		int num, inputData, count;
		count = 0;  
		string holdLabel, nextLabel, groupN, label;
		
		//read in first row since you know there is at least 1 group.
		in >> label >> groupN >> num;
		holdLabel = label;
		
		//output first group
		m->mothurOut(groupN); m->mothurOutEndLine();
		out << groupN << '\t' << groupN << endl;	
			
		//get rest of line
		for(int i=0;i<num;i++){
			in >> inputData;
		}
		
		if (m->control_pressed) { outputTypes.clear(); in.close();  out.close(); m->mothurRemove(outputFile);   return 0; }

		if (in.eof() != true) { in >> nextLabel; }
		
		//read the rest of the groups info in
		while ((nextLabel == holdLabel) && (in.eof() != true)) {
			if (m->control_pressed) {  outputTypes.clear(); in.close();  out.close(); m->mothurRemove(outputFile);   return 0; }
			
			in >> groupN >> num;
			count++;
			
			//output next group
			m->mothurOut(groupN); m->mothurOutEndLine();
			out << groupN << '\t' << groupN << endl;				
			
			//fill vector.  
			for(int i=0;i<num;i++){
				in >> inputData;
			}
			
			if (in.eof() != true) { in >> nextLabel; }
		}
		
		in.close();
		out.close();
		
		if (m->control_pressed) {  m->mothurRemove(outputFile);   return 0; }
		
		m->mothurOutEndLine();
		m->mothurOut("Output File Name: "); m->mothurOutEndLine();
		m->mothurOut(outputFile); m->mothurOutEndLine();	outputNames.push_back(outputFile); outputTypes["bootgroup"].push_back(outputFile);
		m->mothurOutEndLine();
		
		return 0;	
	}

	catch(exception& e) {
		m->errorOut(e, "GetgroupCommand", "execute");
		exit(1);
	}
}


