// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Copyright (c) 2007 Novell, Inc. (http://www.novell.com)
//
// Authors:
//	Chris Toshok (toshok@ximian.com)
//

using System;
using System.ComponentModel;
using System.Windows.Markup;

namespace System.Windows.Input {

	[ValueSerializer (typeof (KeyValueSerializer))]
	[TypeConverter (typeof (KeyConverter))]
	public enum Key
	{
		None,
		Cancel,
		Back,
		Tab,
		LineFeed,
		Clear,
		Return,
		Enter = Return,
		Pause,
		CapsLock,
		Capital = CapsLock,
		HangulMode,
		KanaMode = HangulMode,
		JunjaMode,
		FinalMode,
		KanjiMode,
		HanjaMode = KanjiMode,
		Escape,
		ImeConvert,
		ImeNonConvert,
		ImeAccept,
		ImeModeChange,
		Space,
		PageUp,
		Prior = PageUp,
		PageDown,
		Next = PageDown,
		End,
		Home,
		Left,
		Up,
		Right,
		Down,
		Select,
		Print,
		Execute,
		PrintScreen,
		Snapshot = PrintScreen,
		Insert,
		Delete,
		Help,
		D0,
		D1,
		D2,
		D3,
		D4,
		D5,
		D6,
		D7,
		D8,
		D9,
		A,
		B,
		C,
		D,
		E,
		F,
		G,
		H,
		I,
		J,
		K,
		L,
		M,
		N,
		O,
		P,
		Q,
		R,
		S,
		T,
		U,
		V,
		W,
		X,
		Y,
		Z,
		LWin,
		RWin,
		Apps,
		Sleep,
		NumPad0,
		NumPad1,
		NumPad2,
		NumPad3,
		NumPad4,
		NumPad5,
		NumPad6,
		NumPad7,
		NumPad8,
		NumPad9,
		Multiply,
		Add,
		Separator,
		Subtract,
		Decimal,
		Divide,
		F1,
		F2,
		F3,
		F4,
		F5,
		F6,
		F7,
		F8,
		F9,
		F10,
		F11,
		F12,
		F13,
		F14,
		F15,
		F16,
		F17,
		F18,
		F19,
		F20,
		F21,
		F22,
		F23,
		F24,
		NumLock,
		Scroll,
		LeftShift,
		RightShift,
		LeftCtrl,
		RightCtrl,
		LeftAlt,
		RightAlt,
		BrowserBack,
		BrowserForward,
		BrowserRefresh,
		BrowserStop,
		BrowserSearch,
		BrowserFavorites,
		BrowserHome,
		VolumeMute,
		VolumeDown,
		VolumeUp,
		MediaNextTrack,
		MediaPreviousTrack,
		MediaStop,
		MediaPlayPause,
		LaunchMail,
		SelectMedia,
		LaunchApplication1,
		LaunchApplication2,
		Oem1,
		OemSemicolon = Oem1,
		OemPlus,
		OemComma,
		OemMinus,
		OemPeriod,
		Oem2,
		OemQuestion = Oem2,
		Oem3,
		OemTilde = Oem3,
		AbntC1,
		AbntC2,
		Oem4,
		OemOpenBrackets = Oem4,
		Oem5,
		OemPipe = Oem5,
		Oem6,
		OemCloseBrackets = Oem6,
		Oem7,
		OemQuotes = Oem7,
		Oem8,
		Oem102,
		OemBackslash = Oem102,
		ImeProcessed,
		System,
		OemAttn,
		DbeAlphanumeric = OemAttn,
		OemFinish,
		DbeKatakana = OemFinish,
		OemCopy,
		DbeHiragana = OemCopy,
		OemAuto,
		DbeSbcsChar = OemAuto,
		OemEnlw,
		DbeDbcsChar = OemEnlw,
		OemBackTab,
		DbeRoman = OemBackTab,
		Attn,
		DbeNoRoman = Attn,
		CrSel,
		DbeEnterWordRegisterMode = CrSel,
		ExSel,
		DbeEnterImeConfigureMode = ExSel,
		EraseEof,
		DbeFlushString = EraseEof,
		Play,
		DbeCodeInput = Play,
		Zoom,
		DbeNoCodeInput = Zoom,
		NoName,
		DbeDetermineString = NoName,
		Pa1,
		DbeEnterDialogConversionMode = Pa1,
		OemClear
	}
}
