// Permission is hereby granted, free of charge, to any person obtaining 
// a copy of this software and associated documentation files (the 
// "Software"), to deal in the Software without restriction, including 
// without limitation the rights to use, copy, modify, merge, publish, 
// distribute, sublicense, and/or sell copies of the Software, and to 
// permit persons to whom the Software is furnished to do so, subject to 
// the following conditions: 
//  
// The above copyright notice and this permission notice shall be 
// included in all copies or substantial portions of the Software. 
//  
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION 
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
// 
// Copyright (c) 2008 Novell, Inc. (http://www.novell.com) 
// 
// Authors: 
//	Brad Taylor <brad@getcoded.net>
//

using System;
using Mono.Unix;
using System.ComponentModel;
using System.Windows.Forms;
using System.Windows.Automation;
using System.Windows.Automation.Provider;
using Mono.UIAutomation.Winforms.Behaviors.TabPage;
using AEIds = System.Windows.Automation.AutomationElementIdentifiers;

namespace Mono.UIAutomation.Winforms
{
	[MapsComponent (typeof (TabPage))]
	internal class TabPageProvider : PanelProvider
	{
		public TabPageProvider (TabPage control) : base (control)
		{
			this.tabPage = control;

			SetBehavior (SelectionItemPatternIdentifiers.Pattern,
				     new SelectionItemProviderBehavior (this));
		}
		
		protected override object GetProviderPropertyValue (int propertyId)
		{
			if (propertyId == AEIds.ControlTypeProperty.Id)
				return ControlType.TabItem.Id;
			else if (propertyId == AEIds.LocalizedControlTypeProperty.Id)
				return Catalog.GetString ("tab item");
			else if (propertyId == AEIds.BoundingRectangleProperty.Id)
				return Helper.GetControlScreenBounds (tabPage.TabBounds,
				                                      tabPage, false);

			return base.GetProviderPropertyValue (propertyId);
		}

		protected override bool IsComponentVisible (Component component)
		{
			// Hide the TabPage's children if it's not visible.
			// This is to sweep under the rug the fact that SWF
			// seems to keep a TabPages' children visible even if
			// the TabPage isn't.  This is to model Vista's
			// behavior.
			return Control.Visible;
		}

		internal TabControlProvider TabControlProvider {
			get { return (TabControlProvider) Navigate (NavigateDirection.Parent); }
		}

		internal bool IsSelected {
			get {
				if (TabControlProvider == null)
					return false;

				return TabControlProvider.IsItemSelected (this);
			}
		}
		
		private TabPage tabPage;
	}
}
