/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: mhash.h,v 1.18 2004/08/27 20:07:37 ostborn Exp $
*/

#ifndef _M_HASH_H_
#define _M_HASH_H_

#include "mlist.h"
#include "mdatatypes.h"


/**
 * substructure for the hash
 */
typedef struct {
	int size; /**< number of elements in the list */
	mlist *list;/**< the actual list **/
} mhash_data;

/**
 * the internal hash structure
 *
 */
typedef struct {
	unsigned int	size;/**< number of internaly used lists **/
	mhash_data	**data;/**< dynamic array of lists */
	int             resize_check;
} mhash;

mhash *mhash_init(int size);

/**
 * inserts a data element into a hash indexed via the key
 * which is part of the data-element
 *
 * if the same key is already in the list the append function of the
 * data-element is called. it depends on this function, what really happends
 * in this case.
 *
 * otherwise the element is just inserted in the hash
 *
 * the data element is inserted directly and is NOT copied.
 * you should not remove a inserted data-element !!
 *
 * @param h the hash
 * @param data the to be inserted element
 * @return hmm...
 */

int mhash_insert_sorted(mhash *h, mdata *data);

int mhash_free(mhash *h);

/**
 * count the elements of the hash
 *
 * @param h the hash
 * @return number of hash elements
 */
int mhash_count(mhash *h);

/**
 * transform a hash into a list
 *
 * @param h the to be transformed hash
 * @param l the resulting list
 */
int mhash_unfold(mhash *h, mlist *l );
int mhash_unfold_sorted_limited(mhash *h, mlist *l, int count );
int mhash_unfold_sorted_limited_vcount(mhash *h, mlist *l, int count );

/**
 * checks if a given key is found in the hash
 *
 * @param h the hash
 * @param str the key
 * @return 0 if key isn't found, != 0 otherwise
 */
int mhash_in_hash(mhash *h, const char *str);

/**
 * retreive the data from a hash for a given key
 *
 * @param h the hash
 * @param str the key
 * @return the corresponding data
 */
mdata *mhash_get_data(mhash *h, const char *str);

int mhash_insert_replace(mhash *h, mdata *data);

int mhash_analyse(mhash *h);

mdata **mhash_sorted_to_marray(const mhash *h, int sortby, int sortdir);
int mhash_get_value(mhash *h, const char *key);
long mhash_sumup(mhash *h);
double mhash_sumup_vcount(mhash *h);

int mhash_calc (mhash *h, const char *str);

#endif
