#include "KeyPressWidget.h"
#include "ControlMenu.h"

//----------------------------------------------------------------------
KeyPressWidget::KeyPressWidget(SDLKey key, PG_Widget *parent, const PG_Rect &r, const char *style)
  : PG_Label(parent, r, style)
{
  /*
  SDL_Color back = {255, 0, 0};
  SetBackgroundColor(back);
  */

  m_key = key;
  m_oldKey = key;
  m_focus = false;
  SetAlignment(PG_TA_CENTER);
  SetFontSize(15);
  SetText(SDL_GetKeyName(key));
  SetFontColor(0, 0xff, 0);
  
}

//----------------------------------------------------------------------
KeyPressWidget::~KeyPressWidget()
{
}

//----------------------------------------------------------------------
bool KeyPressWidget::eventKeyDown(const SDL_KeyboardEvent *key)
{
  if(!m_focus)
    return false;

  TranslateNumpadKeys((SDL_KeyboardEvent*)key);

  SDLKey oldKey = m_key;
  m_key = key->keysym.sym;
  
  if(!ControlMenu::getInstance()->checkKeys())
    m_key = oldKey;
  else
    SetText(SDL_GetKeyName(m_key));

  SetFontColor(0, 0xff, 0);
  ReleaseInputFocus();
  Redraw();

  m_focus = false;
  return true;
}

//----------------------------------------------------------------------
bool KeyPressWidget::eventMouseButtonDown(const SDL_MouseButtonEvent *mouse)
{
  m_focus = true;

  SetFontColor(0xff, 0, 0);
  SetInputFocus();
  Redraw();

  return true;
}

//----------------------------------------------------------------------
void KeyPressWidget::eventShow()
{
  SetFontColor(0, 0xff, 0);
  ReleaseInputFocus();
  m_focus = false;
}

//----------------------------------------------------------------------
void KeyPressWidget::revertKey()
{
  m_key = m_oldKey;
  SetText(SDL_GetKeyName(m_key));
}

//----------------------------------------------------------------------
void KeyPressWidget::saveKey()
{
  m_oldKey = m_key;
  SetText(SDL_GetKeyName(m_key));
}
