/* Copyright (C) 2000-2006 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#ifndef _UDM_SEARCH_TOOL_H
#define _UDM_SEARCH_TOOL_H

#define UDM_FAST_PRESORT_DOCS	300

extern void UdmURLDataSortBySite(UDM_URLDATALIST *L);
extern void UdmURLDataGroupBySite(UDM_URLDATALIST *L);
extern void UdmURLDataSortByPattern(UDM_URLDATALIST *D, const char *pattern);

extern void UdmURLScoreListSortByScore(UDM_URLSCORELIST *ScoreList);
extern void UdmURLScoreListSortByScoreThenURLTop(UDM_URLSCORELIST *ScoreList,
                                                 size_t topcount);
extern void UdmURLScoreListSortByScoreThenURL(UDM_URLSCORELIST *ScoreList);

extern void UdmGroupByURL2(UDM_AGENT *Agent,
                           UDM_DB *db,
                           UDM_RESULT *Res,
                           UDM_SECTIONLIST *CoordList,
                           UDM_URLSCORELIST *ScoreList);

extern int  UdmPrepare(UDM_AGENT *query,UDM_RESULT *res);
extern __C_LINK int __UDMCALL UdmParseQueryString(UDM_AGENT * Agent,UDM_VARLIST * vars, const char * query_string);

extern char *UdmHlConvert(UDM_WIDEWORDLIST *L,const char * src, UDM_CHARSET * lcs, UDM_CHARSET * bcs);
extern size_t UdmHlConvertExt(char *dst, size_t dstlen,
                              UDM_WIDEWORDLIST *L, UDM_CHARSET *wcs,
                              const char * src, size_t length,
                              UDM_CHARSET * lcs, UDM_CHARSET * bcs,
                              int hilight_stopwords);
extern size_t
UdmHlConvertExtWithConv(char *dst, size_t dstmaxlen,
                        UDM_WIDEWORDLIST *List,
                        const char *src, size_t srclen,
                        UDM_CONV *uni_wcs, UDM_CONV *lc_uni, UDM_CONV *uni_bc,
                        int hilight_stopwords);
                                                                                                
extern int  UdmConvert(UDM_ENV *Conf, UDM_RESULT *Res,UDM_CHARSET *lcs,UDM_CHARSET *bcs);
extern char* UdmRemoveHiLightDup(const char *s);

extern int UdmCatToTextBuf(UDM_CATEGORY *C, char *textbuf, size_t len);
extern int UdmCatFromTextBuf(UDM_CATEGORY *C, char *textbuf);

int   *UdmUniSegment(UDM_AGENT *Indexer, int *s, const char *lang, const char *seg);

int UdmResWordInfo(UDM_ENV *Env, UDM_RESULT *Res);

int UdmAllForms(UDM_AGENT *Indexer,
                UDM_WIDEWORDLIST *result,
                UDM_WIDEWORD *uword);

#endif
