      subroutine m_intv(idh,ierr)
C
C-----------------------------------------------------------------------
C
C     Sets up the variables to be fetched for a CWN
C
C     Called by m_ntppnt
C
C-----------------------------------------------------------------------
C
      implicit none
*
#include "mnpar.inc"
#include "mncwn.inc"
#include "mninf.inc"
#include "mndbg.inc"
#include "mnlun.inc"
#include "slate.inc"
*
      integer idh,ierr
*
      integer i,k,nsub,itype,isize,ielem,nwr4,nwr8,nwch,nnum
      integer ideft
      integer ioerr,lenc,lenb,lend,lnblnk,nfact
      character chtag*32,block*8
      character chdefb*8,chdesc*40
      logical  qcwntp,qget
*
      integer  icdeci
      logical  hntnew
      external hntnew,icdeci
*
      ierr = 0
*
      qcwntp = hntnew(idh)
      if(.not.qcwntp) then
          ierr = 1
          write(txterr,'('' Ntuple'',I7,'' is not a CWN'')'
     +     ,iostat=ioerr) idh
          call mn_err('M_INTV',txterr)
          goto 9000
      endif
*
*     Setup the list of variables to get
*
      call hbname(idh,' ',0,'$CLEAR')
      nwr4 = 1
      nwr8 = 1
      nwch = 1

*
*     Loop over all the variables and setup those I want
*
      do i=1,iabs(ndim)
          call hntvdef(idh,i,chdesc,chdefb,ideft)
          call hntvar(idh,i,chtag,block,nsub,itype,isize,ielem)
          lenc = lnblnk(chtag)
          lenb = lnblnk(block)
          lend = lnblnk(chdesc)
*
          ivsub(1,i) = nsub
          ivtype(i)  = itype
          ivsize(i)  = isize
          ivelem(i)  = ielem
          cvdesc(i)  = chdesc(:lend)
*
*         Get the subscript sizes
*
          nfact = 0
          if(nsub.gt.0) then
              call m_nsub(1,idh,nsub,block,chdesc,ielem
     +         ,ivsub(3,i),nfact,ierr)
              if(ierr.ne.0) goto 9000
          endif
          ivsub(2,i) = nfact
*
*         See if I want this variable
*
          if(nvcwn.eq.0) then
              qget = .true.
              k = i
          else
              qget = .false.
              do k=1,nvcwn
                  if(ivcwn(k).eq.i) then
*
*                     Check that the right number of subscripts has been given
*
                      nnum = iecwn(2,k)
                      if(nsub.gt.0 .and. nnum.lt.nsub+1) then
                          ierr = 2
                          write(txterr,'(''Wrong # subscripts''
     +                     ,'' given for '',a,'', '',a
     +                     ,''. Given:'',i3,'' Should be:'',i3)')
     +                     block(:lenb),chtag(:lenc),nnum-1,nsub
                          call mn_err('M_INTV',txterr)
                          goto 9000
                      endif
                      qget = .true.
                      goto 1100
                  endif
              enddo
          endif
*
 1100     continue
          if(qget) then
              chcwn(k)  = chtag(:lenc)
              chblk(k)  = block(:lenb)
              if(qdebug) write(6,'('' Init idh:'',I8
     +         ,'' tag,block:'',2(1x,a)
     +         ,'' sub,type,size,elem'',i2,3i4)')
     +         idh,chtag,block,nsub,itype,isize,ielem
*ICB              write(6,'('' HNTVDEF: type'',I4
*ICB     +         ,'', block,variable:'',2(1x,a))')
*ICB     +         ideft,chdefb(:lnblnk(chdefb)),chdesc(:lnblnk(chdesc))
          endif
*
*         Real*4, Integer*4 or Unsigned Integer*4
*
          if((isize.eq.4 .and.
     +        (itype.eq.1 .or. itype.eq.2 .or. itype.eq.3)) .or.
     +       itype.eq.4) then
              if(nwr4+ielem.gt.mcr4mx) goto 8000
              if(qget) call hbname(idh,block(:lenb),ar4(nwr4)
     +         ,'$SET:'//chtag(:lenc))
              ivposn(i) = nwr4
              nwr4 = nwr4 + ielem
*
*         Real*8, Integer*8 or Unsigned Integer*8
*
          elseif(isize.eq.8 .and.
     +           (itype.eq.1 .or. itype.eq.2 .or. itype.eq.3)) then
              if(nwr8+ielem.gt.mcr8mx) goto 8000
              if(qget) call hbname(idh,block(:lenb),zr8(nwr8)
     +         ,'$SET:'//chtag(:lenc))
              ivposn(i) = nwr8
              nwr8 = nwr8 + ielem
*
*         Character
*
          elseif(itype.eq.5) then
              if(nwch+ielem.gt.mcchmx) goto 8000
              if(qget) call hbnamc(idh,block(:lenb),cch(nwch)
     +         ,'$SET:'//chtag(:lenc))
              ivposn(i) = nwch
              nwch = nwch + ielem*isize/4
          endif
      enddo
*
      nwr4sv = nwr4 - 1
      nwr8sv = nwr8 - 1
      nwchsv = nwch - 1
      goto 9000
*
 8000 continue
      ierr = 3
      write(txterr
     + ,'(''CWN id:'',i8,'' - too many variables'')') idh
      call m_emsg('M_INTV',txterr)
      write(txterr
     + ,'(''Limits are Real:'',i6,'', Dble:'',i6,'', Char:'',i6)')
     + mcr4mx,mcr8mx,mcchmx
      call m_emsg('M_INTV',txterr)
      write(txterr
     + ,'(''You want   Real:'',i6,'', Dble:'',i6,'', Char:'',i6)')
     + nwr4,nwr8,nwch
      call mn_err('M_INTV',txterr)
      goto 9000
*
 9000 continue
      END
