; $Id: quant.scm,v 1.4 2008/01/25 13:30:24 logik Exp $

(add-var-name "x" "y" "z" (py "alpha"))
(add-predconst-name "P" (make-arity))
(add-predconst-name "Qpredconst" (make-arity (py "alpha")))
(add-predconst-name "Rpredconst" (make-arity (py "alpha") (py "alpha")))

(add-token
 "Q"
 'predconst-name
 (string-and-arity-to-predconst-parse-function
  "Qpredconst" (make-arity (make-tvar -1 "alpha"))))

(add-token
 "R"
 'pred-infix
 (lambda (x y)
   ((string-and-arity-to-predconst-parse-function
     "Rpredconst" (make-arity (make-tvar -1 "alpha") (make-tvar -1 "alpha")))
    (- 1) x y)))

(add-predconst-display "Qpredconst" 'predconst-name "Q")
(add-predconst-display "Rpredconst" 'pred-infix "R")

(formula-to-string (pf "Q x"))
(formula-to-string (pf "x R y"))

; (load"~/minlog/lib/nat.scm")
; (formula-to-string (pf "Q nat"))

(formula-to-string (pf "Q17 x"))

(define all-imp (pf "(all x.Q1 x -> Q2 x) -> all x Q1 x -> all x Q2 x"))
(set-goal all-imp)
(assume 1 2 "x")
(use 1)
(use 2)
(dnp)

(define all-imp (pf "(all x.Q1 x -> Q2 x) -> all x Q1 x -> all x Q2 x"))
(set-goal all-imp)
(search)
(dnp)

(define all-and1 (pf "(all x.Q1 x & Q2 x) -> all x Q1 x & all x Q2 x"))
(set-goal all-and1)
(assume 1)
(split)
(assume "x")
(use 1)
(assume "x")
(use 1)
(dnp)

(set-goal all-and1)
(search)
(dnp)

(define all-and2 (pf " all x Q1 x & all x Q2 x -> all x.Q1 x & Q2 x"))
(set-goal all-and2)
(assume 1 "x")
(split)
(use 1)
(use 1)
(dnp)

(set-goal all-and2)
(search)
(dnp)

(define all-exca  (pf "all x Q x -> (all x.Q x -> F) -> F"))
(set-goal all-exca)
(assume 1 2)
(use 2 (pt "x"))
(use 1)
(dnp)

(set-goal all-exca)
(search)
(dnp)

(add-global-assumption "Symm" (pf "all x,y.x R y -> y R x"))
(add-global-assumption "Trans" (pf "all x,y,z.x R y -> y R z -> x R z"))

(set-goal (pf "all x,y.x R y -> x R x"))
(assume "x" "y" 1)
(use "Trans" (pt "y"))
(use 1)
(use "Symm")
(use 1)

(set-goal (pf "all x,y.x R y -> x R x"))
(search 1 '("Symm" 1) '("Trans" 1))
(dnp)

; Now we treat somewhat systematically how in classical logic one can
; deal with quantifiers in implications.  - Below we shall do the same
; for the constructive existential quantifier.

; qf1m is obtained from the formula (all x Q x -> P) -> ex x.Q x -> P
; by translating `ex' into `not all not' and adding stability of Q:

(define qf1m (pf "(all x.((Q x -> F) -> F) -> Q x) 
               -> (all x Q x -> P) 
               -> (all x.(Q x -> P) -> F)
               -> F"))
(set-goal qf1m)
(assume 1 2 3)
(use 3 (pt "x"))
(assume 4)
(use 2)
(assume "x1")
(use 1)
(assume 5)
(use 3 (pt "x1"))
(assume 6)
(use 2)
(assume "x2")
(use 1)
(assume 7)
(use 5)
(use 6)

(set-goal qf1m)
(search)
(dnp)

(define qf2 (pf "(P -> all y Q y) -> all y. P -> Q y"))
(set-goal qf2)
(assume 1 "y" 2)
(use 1)
(use 2)

(set-goal qf2)
(search)
(dnp)

; qf3 is obtained from the formula (ex x Q x -> P) -> all x.Q x -> P
; by translating `ex' into `not all not':

(define qf3 (pf "(((all x.Q x -> F) -> F) -> P) -> all x.Q x -> P"))
(set-goal qf3)
(assume 1 "x" 2)
(use 1)
(assume 3)
(use 3 (pt "x"))
(use 2)

(set-goal qf3)
(search)
(dnp)

; qf4m is obtained from the formula (P -> ex y Q y) -> ex y.P -> Q y
; by translating `ex' into `not all not' and adding ef-falso for Q:

(define qf4m (pf "(all y.F -> Q y)
               -> (P -> (all y.Q y -> F) -> F)
               -> (all y.(P -> Q y) -> F) 
               -> F"))
(set-goal qf4m)
(assume 1 2 3)
(use 3 (pt "y"))
(assume 4)
(use 1)
(use 2)
(use 4)
(assume "y1" 5)
(use 3 (pt "y1"))
(assume 6)
(use 5)

(set-goal qf4m)
(search)
(dnp)

; qf5m is obtained from the formula (ex x.Q x -> P) -> all x Q x -> P
; by translating `ex' into `not all not' and adding stability of P:

(define qf5m (pf "(((P -> F) -> F) -> P)
               -> ((all x.(Q x -> P) -> F) -> F)
               -> all x Q x
               -> P"))
(set-goal qf5m)
(assume 1 2 3)
(use 1)
(assume 4)
(use 2)
(assume "x" 5)
(use 4)
(use 5)
(use 3)

(set-goal qf5m)
(search)
(dnp)

(define qf6 (pf "(all y. P -> Q y) -> P -> all y Q y"))
(set-goal qf6)
(assume 1 2 "y")
(use 1)
(use 2)

(set-goal qf6)
(search)
(dnp)

; qf7m is obtained from the formula (all x.Q x -> P) -> ex x Q x -> P
; by translating `ex' into `not all not' and adding stability of P:

(define qf7m (pf "(((P -> F) -> F) -> P)
               -> (all x.Q x -> P) 
               -> ((all x.Q x -> F) -> F) 
               -> P"))
(set-goal qf7m)
(assume 1 2 3)
(use 1)
(assume 4)
(use 3)
(assume "x" 5)
(use 4)
(use 2 (pt "x"))
(use 5)

(set-goal qf7m)
(search)
(dnp)

; qf8 is obtained from the formula (ex y.P -> Q y) -> P -> ex y Q y
; by translating `ex' into `not all not':

(define qf8 (pf "((all y.(P -> Q y) -> F) -> F)
              -> P 
              -> (all y.Q y -> F)
              -> F"))
(set-goal qf8)
(assume 1 2 3)
(use 1)
(assume "y" 4)
(use 3 (pt "y"))
(use 4)
(use 2)

(set-goal qf8)
(search)
(dnp)

; Some more examples involving classical existence

(define drinker (pf "(all y.((Q y -> F) -> F) -> Q y) ->
                     exca x.Q x -> all y Q y"))
(set-goal drinker)
(search)
(dnp)


; Now we treat the constructive existential quantifier

(define ex-and1 (pf "(ex x.Q1 x & Q2 x) -> ex x Q1 x & ex x Q2 x"))
(set-goal ex-and1)
(assume 1)
(split)
(ex-elim 1)
(assume "x" 2)
(ex-intro (pt "x"))
(use 2)
(ex-elim 1)
(assume "x" 2)
(ex-intro (pt "x"))
(use 2)

(set-goal ex-and1)
(search)
(dnp)

; Normalized extracted term:
(dnet) ;"[x0]x0@x0"

(define ex-and2 (pf "ex x Q x & P -> ex x.Q x & P"))
(set-goal ex-and2)
(assume 1)
(inst-with 1 'left)
(ex-elim 2)
(assume "x" 3)
(ex-intro (pt "x"))
(split)
(use 3)
(use 1)

(set-goal ex-and2)
(search)
(dnp)

(dnet) ;"[x0]x0"

(define all-ex  (pf "all x Q x -> ex x Q x"))
(set-goal all-ex)
(assume 1)
(ex-intro (pt "x"))
(use 1)

(set-goal all-ex)
(search)
(dnp)
(dnet) ;"x"


; qf1 is the formula (all x Q x -> P) -> ex x.Q x -> P
; It is not provable in minimal logic.

; (define qf2 (pf "(P -> all y Q y) -> all y. P -> Q y")) see above

(define qf3 (pf "(ex x Q x -> P) -> all x.Q x -> P"))
(set-goal qf3)
(assume 1 "x" 2)
(use 1)
(ex-intro (pt "x"))
(use 2)

(set-goal qf3)
(search)
(dnp)

; qf4 is the formula (P -> ex y Q y) -> ex y.P -> Q y
; It is not provable in minimal logic.

(define qf5 (pf "(ex x.Q x -> P) -> all x Q x -> P"))
(set-goal qf5)
(assume 1 2)
(ex-elim 1)
(assume "x" 3)
(use 3)
(use 2)

(set-goal qf5)
(assume 1 2)
(ex-elim 1)
(search)
(dnp)

; (define qf6 (pf "(all y. P -> Q y) -> P -> all y Q y")) see above

(define qf7 (pf "(all x.Q x -> P) -> ex x Q x -> P"))
(set-goal qf7)
(assume 1 2)
(ex-elim 2)
(use 1)

(set-goal qf7)
(assume 1 2)
(ex-elim 2)
(search)

(define qf8 (pf "(ex y.P -> Q y) -> P -> ex y Q y"))
(set-goal qf8)
(assume 1 2)
(ex-elim 1)
(assume "x" 3)
(ex-intro (pt "x"))
(use 3)
(use 2)

(set-goal qf8)
(search)
(dnp)
(dnet) ;"[x0]x0"

;Local Variables:
;mode: scheme
;End:
