.TH "{ImportDsc}" "1" "December 2009" "{ImportDsc} {Version}" "User Commands"

.SH NAME

{ImportDsc} \- Import exiting package into Mercurial repository.

.SH SYNOPSIS

\fB{ImportDsc}\fR [\fIoption\fR] ... \fIdscfile\fR

.SH DESCRIPTION

Import an existing source package into a Mercurial repository.  The
diffs and upstream sources are extracted from the contents of the .dsc
file.  \fB{ImportOrig}\fR(1) is called to import the upstream source
into the upstream branch, which is then merged into the default branch,
and the diffs are applied to the default branch.  It is possible to use
\fB{ImportDsc}\fR multiple times to import several versions, but the
versions must be imported sequentially starting with the earliest
version.

.SH OPTIONS

.HP
\fB\-\-version\fR, \fB\-V\fR
.IP
Output version and exit.
.HP
\fB\-\-verbose\fR, \fB\-v\fR
.IP
Increase verbosity level.  Can be used several times.

.SH EXAMPLES

.HP
\fB{ImportDsc}\fR ../mypack_1.2-3.dsc
.IP
Import package mypack version 1.2-3 into the repository in the current
directory.  After the import, the repository will have the tags
mypack_1.2 and mypack_1.2-3.

.SH AUTHOR

Jens Peter Secher <jpsecher@gmail.com>

.SH THANKS

The ideas for this package originates from John Goerzen's
\fBhg-buildpackage\fR.

.SH SEE ALSO

\fB{ImportOrig}\fR(1),
\fB{BuildPackage}\fR(1),
\fB{TagVersion}\fR(1),
\fB{PristineTar}\fR(1),
\fB{Port}\fR(1).
