/*
 * medussa - a distributed cracking system
 * Copyright (C) 1999 Kostas Evangelinos <kos@bastard.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
/*
 * $Id: array.c,v 1.5 1999/12/20 19:46:35 kos Exp $
 *
 */

#include <stdlib.h>
#include <strings.h>
#include <assert.h>
#include <stdio.h>
#include "array.h"
#include "xmalloc.h"

array *
array_init(int size) {
  array *l;

  l = (array *)xcalloc(1, sizeof(array));
  l->allocelem = ARRAY_CHUNK;
  l->nelem = 0;
  l->sizelem = size;
  l->data = xcalloc(l->allocelem, l->sizelem);
  
  return l;
}

int
array_zero(array *l) {
  
  l->nelem = 0;
  return 0;
}

array *
array_init_hint(array *l, int size, int hint) {
  l->allocelem = hint;
  l->nelem = 0;
  l->sizelem = size;
  l->data = xcalloc(l->allocelem, l->sizelem);
  return l;
}

int 
array_add(array *l, void *data) {
  void *new;  

  /* If we hit the ceiling, do stuff */
  if(array_nelems(l) == l->allocelem) {
    new = xrealloc(l->data, (l->allocelem + ARRAY_CHUNK) * l->sizelem);
    l->data = new;
    l->allocelem += ARRAY_CHUNK;
  }

  memcpy(l->data + (l->nelem*l->sizelem), data, l->sizelem);
  l->nelem++;
  return 0;
}

int
array_nuke(array *l) {

  if(!(l->data))
    return 1;

  xfree(l->data);
  return 0;
}

void *
array_get(array *l, int which) {
  
  if(which >= l->nelem || which < 0)
    return NULL;
  return l->data + (which * l->sizelem);
}

int
array_delete(array *l, int which) {
  void *p;

  if(which > l->nelem)
    return 1;
  p = array_get(l, which);
  memcpy(p, p+l->sizelem, (l->nelem*l->sizelem)-((which+1)*l->sizelem));
  l->nelem--;
  return 0;
}

#ifdef ARRAY_DEBUG
int
main(int argc, char **argv) {
  array *l;
  int i;
  char elem[256];

  l = array_init(256);
  strcpy(elem, "element 1");
  assert(array_add(l, (char *)elem) == 0);
  strcpy(elem, "element 2");
  assert(array_add(l, (char *)elem) == 0);
  strcpy(elem, "element 3");
  assert(array_add(l, (char *)elem) == 0);
  strcpy(elem, "element 4");
  assert(array_add(l, (char *)elem) == 0);
  
  for(i=0; i<array_nelems(l); i++) 
    printf("%s\n", (char *)array_get(l, i));
  array_delete(l, 2);
  for(i=0; i<array_nelems(l); i++) 
    printf("%s\n", (char *)array_get(l, i));
  
  array_nuke(l);
  exit(0);
}
#endif
