<?php
/** Arabic (العربية)
 *
 * @addtogroup Language
 *
 * @author Meno25
 * @author Mido
 * @author Alnokta
 * @author Gharbeia
 * @author Nike
 * @author Mimouni
 * @author Tarawneh
 * @author Agurzil
 * @author Chaos
 * @author Siebrand
 * @author לערי ריינהארט
 * @author SPQRobin
 * @author OsamaK
 */

$linkPrefixExtension = true;
$fallback8bitEncoding = 'windows-1256';

$rtl = true;
$defaultUserOptionOverrides = array(
	# Swap sidebar to right side by default
	'quickbar' => 2,
	# Underlines seriously harm legibility. Force off:
	'underline' => 0,
);

/**
 * A list of date format preference keys which can be selected in user 
 * preferences. New preference keys can be added, provided they are supported
 * by the language class's timeanddate(). Only the 5 keys listed below are 
 * supported by the wikitext converter (DateFormatter.php).
 *
 * The special key "default" is an alias for either dmy or mdy depending on 
 * $wgAmericanDates
 */
$datePreferences = array(
	'default',
	'mdy',
	'dmy',
	'ymd',
	'ISO 8601',
);

/**
 * The date format to use for generated dates in the user interface.
 * This may be one of the above date preferences, or the special value 
 * "dmy or mdy", which uses mdy if $wgAmericanDates is true, and dmy 
 * if $wgAmericanDates is false.
 */
$defaultDateFormat = 'dmy or mdy';

/**
 * Associative array mapping old numeric date formats, which may still be 
 * stored in user preferences, to the new string formats.
 */
$datePreferenceMigrationMap = array(
	'default',
	'mdy',
	'dmy',
	'ymd'
);

/**
 * These are formats for dates generated by MediaWiki (as opposed to the wikitext
 * DateFormatter). Documentation for the format string can be found in 
 * Language.php, search for sprintfDate. 
 *
 * This array is automatically inherited by all subclasses. Individual keys can be
 * overridden.
 */
$dateFormats = array(
	'mdy time' => 'H:i',
	'mdy date' => 'xg j، Y', # Arabic comma
	'mdy both' => 'H:i، xg j، Y', # Arabic comma

	'dmy time' => 'H:i',
	'dmy date' => 'j xg Y',
	'dmy both' => 'H:i، j xg Y', # Arabic comma

	'ymd time' => 'H:i',
	'ymd date' => 'Y xg j',
	'ymd both' => 'H:i، Y xg j', # Arabic comma

	'ISO 8601 time' => 'xnH:xni:xns',
	'ISO 8601 date' => 'xnY-xnm-xnd',
	'ISO 8601 both' => 'xnY-xnm-xnd"T"xnH:xni:xns',
);

$namespaceNames = array(
	NS_MEDIA          => 'ميديا',
	NS_SPECIAL        => 'خاص',
	NS_MAIN           => '',
	NS_TALK           => 'نقاش',
	NS_USER           => 'مستخدم',
	NS_USER_TALK      => 'نقاش_المستخدم',
	# NS_PROJECT set by \$wgMetaNamespace
	NS_PROJECT_TALK   => 'نقاش_$1',
	NS_IMAGE          => 'صورة',
	NS_IMAGE_TALK     => 'نقاش_الصورة',
	NS_MEDIAWIKI      => 'ميدياويكي',
	NS_MEDIAWIKI_TALK => 'نقاش_ميدياويكي',
	NS_TEMPLATE       => 'قالب',
	NS_TEMPLATE_TALK  => 'نقاش_القالب',
	NS_HELP           => 'مساعدة',
	NS_HELP_TALK      => 'نقاش_المساعدة',
	NS_CATEGORY       => 'تصنيف',
	NS_CATEGORY_TALK  => 'نقاش_التصنيف',
);

$namespaceAliases = array(
	'ملف'             => NS_MEDIA,
	'نقاش_قالب'       => NS_TEMPLATE_TALK,
);

$magicWords = array(
	'redirect'            => array( '0', '#تحويل', '#REDIRECT' ),
	'notoc'               => array( '0', '__لافهرس__', '__NOTOC__' ),
	'nogallery'           => array( '0', '__لامعرض__', '__NOGALLERY__' ),
	'forcetoc'            => array( '0', '__لصق_فهرس__', '__FORCETOC__' ),
	'toc'                 => array( '0', '__فهرس__', '__TOC__' ),
	'noeditsection'       => array( '0', '__لاتحريرقسم__', '__NOEDITSECTION__' ),
	'currentmonth'        => array( '1', 'شهر_حالي', 'شهر', 'CURRENTMONTH' ),
	'currentmonthname'    => array( '1', 'اسم_الشهر_الحالي', 'اسم_شهر_حالي', 'اسم_شهر', 'CURRENTMONTHNAME' ),
	'currentmonthnamegen' => array( '1', 'اسم_الشهر_الحالي_المولد', 'اسم_شهر_حالي_مولد', 'CURRENTMONTHNAMEGEN' ),
	'currentmonthabbrev'  => array( '1', 'اختصار_الشهر_الحالي', 'اختصار_شهر_حالي', 'CURRENTMONTHABBREV' ),
	'currentday'          => array( '1', 'يوم_حالي', 'يوم', 'CURRENTDAY' ),
	'currentday2'         => array( '1', 'يوم_حالي2', 'يوم2', 'CURRENTDAY2' ),
	'currentdayname'      => array( '1', 'اسم_اليوم_الحالي', 'اسم_يوم_حالي', 'اسم_يوم', 'CURRENTDAYNAME' ),
	'currentyear'         => array( '1', 'عام_حالي', 'عام', 'CURRENTYEAR' ),
	'currenttime'         => array( '1', 'وقت_حالي', 'وقت', 'CURRENTTIME' ),
	'currenthour'         => array( '1', 'ساعة_حالية', 'ساعة', 'CURRENTHOUR' ),
	'localmonth'          => array( '1', 'شهر_محلي', 'LOCALMONTH' ),
	'localmonthname'      => array( '1', 'اسم_الشهر_المحلي', 'اسم_شهر_محلي', 'LOCALMONTHNAME' ),
	'localmonthnamegen'   => array( '1', 'اسم_الشهر_المحلي_المولد', 'اسم_شهر_محلي_مولد', 'LOCALMONTHNAMEGEN' ),
	'localmonthabbrev'    => array( '1', 'اختصار_الشهر_المحلي', 'اختصار_شهر_محلي', 'LOCALMONTHABBREV' ),
	'localday'            => array( '1', 'يوم_محلي', 'LOCALDAY' ),
	'localday2'           => array( '1', 'يوم_محلي2', 'LOCALDAY2' ),
	'localdayname'        => array( '1', 'اسم_اليوم_المحلي', 'اسم_يوم_محلي', 'LOCALDAYNAME' ),
	'localyear'           => array( '1', 'عام_محلي', 'LOCALYEAR' ),
	'localtime'           => array( '1', 'وقت_محلي', 'LOCALTIME' ),
	'localhour'           => array( '1', 'ساعة_محلية', 'LOCALHOUR' ),
	'numberofpages'       => array( '1', 'عدد_الصفحات', 'عدد_صفحات', 'NUMBEROFPAGES' ),
	'numberofarticles'    => array( '1', 'عدد_المقالات', 'عدد_مقالات', 'NUMBEROFARTICLES' ),
	'numberoffiles'       => array( '1', 'عدد_الملفات', 'عدد_ملفات', 'NUMBEROFFILES' ),
	'numberofusers'       => array( '1', 'عدد_المستخدمين', 'عدد_مستخدمين', 'NUMBEROFUSERS' ),
	'numberofedits'       => array( '1', 'عدد_التعديلات', 'عدد_تعديلات', 'NUMBEROFEDITS' ),
	'pagename'            => array( '1', 'اسم_الصفحة', 'اسم_صفحة', 'PAGENAME' ),
	'pagenamee'           => array( '1', 'عنوان_الصفحة', 'عنوان_صفحة', 'PAGENAMEE' ),
	'namespace'           => array( '1', 'نطاق', 'NAMESPACE' ),
	'namespacee'          => array( '1', 'عنوان_نطاق', 'NAMESPACEE' ),
	'talkspace'           => array( '1', 'نطاق_النقاش', 'نطاق_نقاش', 'TALKSPACE' ),
	'talkspacee'          => array( '1', 'عنوان_النقاش', 'عنوان_نقاش', 'TALKSPACEE' ),
	'subjectspace'        => array( '1', 'نطاق_الموضوع', 'نطاق_المقالة', 'SUBJECTSPACE', 'ARTICLESPACE' ),
	'subjectspacee'       => array( '1', 'عنوان_نطاق_الموضوع', 'عنوان_نطاق_المقالة SUBJECTSPACEE', 'ARTICLESPACEE' ),
	'fullpagename'        => array( '1', 'اسم_الصفحة_الكامل', 'اسم_صفحة_كامل', 'اسم_كامل', 'FULLPAGENAME' ),
	'fullpagenamee'       => array( '1', 'عنوان_الصفحة_الكامل', 'عنوان_صفحة_كامل', 'عنوان_كامل', 'FULLPAGENAMEE' ),
	'subpagename'         => array( '1', 'اسم_الصفحة_الفرعي', 'اسم_صفحة_فرعي', 'SUBPAGENAME' ),
	'subpagenamee'        => array( '1', 'عنوان_الصفحة_الفرعي', 'عنوان_صفحة_فرعي', 'SUBPAGENAMEE' ),
	'basepagename'        => array( '1', 'اسم_الصفحة_الأساسي', 'اسم_صفحة_أساسي', 'BASEPAGENAME' ),
	'basepagenamee'       => array( '1', 'عنوان_الصفحة_الأساسي', 'عنوان_صفحة_أساسي', 'BASEPAGENAMEE' ),
	'talkpagename'        => array( '1', 'اسم_صفحة_النقاش', 'اسم_صفحة_نقاش', 'TALKPAGENAME' ),
	'talkpagenamee'       => array( '1', 'عنوان_صفحة_النقاش', 'عنوان_صفحة_نقاش', 'TALKPAGENAMEE' ),
	'subjectpagename'     => array( '1', 'اسم_صفحة_الموضوع', 'اسم_صفحة_المقالة', 'SUBJECTPAGENAME', 'ARTICLEPAGENAME' ),
	'subjectpagenamee'    => array( '1', 'عنوان_صفحة_الموضوع', 'عنوان_صفحة_المقالة SUBJECTPAGENAMEE', 'ARTICLEPAGENAMEE' ),
	'msg'                 => array( '0', 'رسالة:', 'MSG:' ),
	'subst'               => array( '0', 'نسخ:', 'إحلال:', 'SUBST:' ),
	'msgnw'               => array( '0', 'مصدر:', 'مصدر_قالب:', 'MSGNW:' ),
	'img_thumbnail'       => array( '1', 'تصغير', 'thumbnail', 'thumb' ),
	'img_manualthumb'     => array( '1', 'تصغير=$1', 'thumbnail=$1', 'thumb=$1' ),
	'img_right'           => array( '1', 'يمين', 'right' ),
	'img_left'            => array( '1', 'يسار', 'left' ),
	'img_none'            => array( '1', 'بدون', 'بلا', 'none' ),
	'img_width'           => array( '1', '$1بك', '$1px' ),
	'img_center'          => array( '1', 'مركز', 'center', 'centre' ),
	'img_framed'          => array( '1', 'إطار', 'framed', 'enframed', 'frame' ),
	'img_frameless'       => array( '1', 'لاإطار', 'frameless' ),
	'img_page'            => array( '1', 'صفحة=$1', 'صفحة $1', 'page=$1', 'page $1' ),
	'img_upright'         => array( '1', 'معدول', 'معدول=$1', 'معدول $1', 'upright', 'upright=$1', 'upright $1' ),
	'img_border'          => array( '1', 'حد', 'حدود', 'border' ),
	'img_baseline'        => array( '1', 'خط_أساسي', 'baseline' ),
	'img_sub'             => array( '1', 'فرعي', 'sub' ),
	'img_super'           => array( '1', 'سوبر', 'سب', 'super', 'sup' ),
	'img_top'             => array( '1', 'أعلى', 'top' ),
	'img_text_top'        => array( '1', 'نص_أعلى', 'text-top' ),
	'img_middle'          => array( '1', 'وسط', 'middle' ),
	'img_bottom'          => array( '1', 'أسفل', 'bottom' ),
	'img_text_bottom'     => array( '1', 'نص_أسفل', 'text-bottom' ),
	'int'                 => array( '0', 'محتوى:', 'INT:' ),
	'sitename'            => array( '1', 'اسم_الموقع', 'اسم_موقع', 'SITENAME' ),
	'ns'                  => array( '0', 'نط:', 'NS:' ),
	'localurl'            => array( '0', 'مسار_محلي:', 'LOCALURL:' ),
	'localurle'           => array( '0', 'عنوان_المسار_المحلي:', 'عنوان_مسار_محلي:', 'LOCALURLE:' ),
	'server'              => array( '0', 'خادم', 'SERVER' ),
	'servername'          => array( '0', 'اسم_الخادم', 'اسم_خادم', 'SERVERNAME' ),
	'scriptpath'          => array( '0', 'مسار_السكريبت', 'مسار_سكريبت', 'SCRIPTPATH' ),
	'grammar'             => array( '0', 'قواعد_اللغة:', 'قواعد_لغة: GRAMMAR:' ),
	'notitleconvert'      => array( '0', '__لاتحويل_عنوان__', '__لاتع__', '__NOTITLECONVERT__', '__NOTC__' ),
	'nocontentconvert'    => array( '0', '__لاتحويل_محتوى__', '__لاتم__', '__NOCONTENTCONVERT__', '__NOCC__' ),
	'currentweek'         => array( '1', 'أسبوع_حالي', 'أسبوع', 'CURRENTWEEK' ),
	'currentdow'          => array( '1', 'يوم_حالي_مأ', 'CURRENTDOW' ),
	'localweek'           => array( '1', 'أسبوع_محلي', 'LOCALWEEK' ),
	'localdow'            => array( '1', 'يوم_محلي_مأ', 'LOCALDOW' ),
	'revisionid'          => array( '1', 'رقم_النسخة', 'رقم_نسخة', 'REVISIONID' ),
	'revisionday'         => array( '1', 'يوم_النسخة', 'يوم_نسخة', 'REVISIONDAY' ),
	'revisionday2'        => array( '1', 'يوم_النسخة2', 'يوم_نسخة2', 'REVISIONDAY2' ),
	'revisionmonth'       => array( '1', 'شهر_النسخة', 'شهر_نسخة', 'REVISIONMONTH' ),
	'revisionyear'        => array( '1', 'عام_النسخة', 'عام_نسخة', 'REVISIONYEAR' ),
	'revisiontimestamp'   => array( '1', 'طابع_وقت_النسخة', 'طابع_وقت_نسخة', 'REVISIONTIMESTAMP' ),
	'plural'              => array( '0', 'جمع:', 'PLURAL:' ),
	'fullurl'             => array( '0', 'عنوان_كامل:', 'FULLURL:' ),
	'fullurle'            => array( '0', 'مسار_كامل:', 'FULLURLE:' ),
	'lcfirst'             => array( '0', 'عنوان_كبير:', 'LCFIRST:' ),
	'ucfirst'             => array( '0', 'عنوان_صغير:', 'UCFIRST:' ),
	'lc'                  => array( '0', 'صغير:', 'LC:' ),
	'uc'                  => array( '0', 'كبير:', 'UC:' ),
	'raw'                 => array( '0', 'خام:', 'RAW:' ),
	'displaytitle'        => array( '1', 'عرض_العنوان', 'عرض_عنوان', 'DISPLAYTITLE' ),
	'rawsuffix'           => array( '1', 'أر', 'آر', 'R' ),
	'newsectionlink'      => array( '1', '__وصلة_قسم_جديد__', '__NEWSECTIONLINK__' ),
	'currentversion'      => array( '1', 'إصدار_حالي', 'CURRENTVERSION' ),
	'urlencode'           => array( '0', 'كود_المسار:', 'كود_مسار:', 'URLENCODE:' ),
	'anchorencode'        => array( '0', 'كود_الأنكور', 'كود_أنكور', 'ANCHORENCODE' ),
	'currenttimestamp'    => array( '1', 'طابع_الوقت_الحالي', 'طابع_وقت_حالي', 'CURRENTTIMESTAMP' ),
	'localtimestamp'      => array( '1', 'طابع_الوقت_المحلي', 'طابع_وقت_محلي', 'LOCALTIMESTAMP' ),
	'directionmark'       => array( '1', 'علامة_الاتجاه', 'علامة_اتجاه', 'DIRECTIONMARK', 'DIRMARK' ),
	'language'            => array( '0', '#لغة:', '#LANGUAGE:' ),
	'contentlanguage'     => array( '1', 'لغة_المحتوى', 'لغة_محتوى', 'CONTENTLANGUAGE', 'CONTENTLANG' ),
	'pagesinnamespace'    => array( '1', 'صفحات_في_نطاق:', 'صفحات_في_نط:', 'PAGESINNAMESPACE:', 'PAGESINNS:' ),
	'numberofadmins'      => array( '1', 'عدد_الإداريين', 'عدد_إداريين', 'NUMBEROFADMINS' ),
	'formatnum'           => array( '0', 'صيغة_رقم', 'FORMATNUM' ),
	'padleft'             => array( '0', 'باد_يسار', 'PADLEFT' ),
	'padright'            => array( '0', 'باد_يمين', 'PADRIGHT' ),
	'special'             => array( '0', 'خاص', 'special' ),
	'defaultsort'         => array( '1', 'ترتيب_قياسي:', 'ترتيب_افتراضي:', 'مفتاح_ترتيب_قياسي:', 'مفتاح_ترتيب_افتراضي:', 'ترتيب_تصنيف_قياسي:', 'ترتيب_تصنيف_افتراضي:', 'DEFAULTSORT:', 'DEFAULTSORTKEY:', 'DEFAULTCATEGORYSORT:' ),
	'filepath'            => array( '0', 'مسار_الملف:', 'مسار_ملف:', 'FILEPATH:' ),
	'tag'                 => array( '0', 'وسم', 'tag' ),
);

$skinNames = array(
	'standard'    => 'كلاسيك',
	'nostalgia'   => 'نوستالجيا',
	'cologneblue' => 'كولون بلو',
	'monobook'    => 'مونوبوك',
	'myskin'      => 'واجهتي',
	'chick'       => 'تشيك',
	'simple'      => 'سيمبل',
	'modern'      => 'مودرن',
);

$digitTransformTable = array(
	'0' => '٠', # &#x0660;
	'1' => '١', # &#x0661;
	'2' => '٢', # &#x0662;
	'3' => '٣', # &#x0663;
	'4' => '٤', # &#x0664;
	'5' => '٥', # &#x0665;
	'6' => '٦', # &#x0666;
	'7' => '٧', # &#x0667;
	'8' => '٨', # &#x0668;
	'9' => '٩', # &#x0669;
	'.' => '٫', # &#x066b; wrong table ?
	',' => '٬', # &#x066c;
);

$specialPageAliases = array(
	'DoubleRedirects'           => array( 'تحويلات_مزدوجة' ),
	'BrokenRedirects'           => array( 'تحويلات_مكسورة' ),
	'Disambiguations'           => array( 'توضيحات' ),
	'Userlogin'                 => array( 'دخول_المستخدم' ),
	'Userlogout'                => array( 'خروج_المستخدم' ),
	'CreateAccount'             => array( 'إنشاء_حساب' ),
	'Preferences'               => array( 'تفضيلات' ),
	'Watchlist'                 => array( 'قائمة_المراقبة' ),
	'Recentchanges'             => array( 'أحدث_التغييرات' ),
	'Upload'                    => array( 'رفع' ),
	'Imagelist'                 => array( 'قائمة_الصور' ),
	'Newimages'                 => array( 'صور_جديدة' ),
	'Listusers'                 => array( 'عرض_المستخدمين', 'قائمة_المستخدمين' ),
	'Statistics'                => array( 'إحصاءات' ),
	'Randompage'                => array( 'عشوائي', 'صفحة_عشوائية' ),
	'Lonelypages'               => array( 'صفحات_وحيدة', 'صفحات_يتيمة' ),
	'Uncategorizedpages'        => array( 'صفحات_غير_مصنفة' ),
	'Uncategorizedcategories'   => array( 'تصنيفات_غير_مصنفة' ),
	'Uncategorizedimages'       => array( 'صور_غير_مصنفة' ),
	'Uncategorizedtemplates'    => array( 'قوالب_غير_مصنفة' ),
	'Unusedcategories'          => array( 'تصنيفات_غير_مستخدمة' ),
	'Unusedimages'              => array( 'صور_غير_مستخدمة' ),
	'Wantedpages'               => array( 'صفحات_مطلوبة', 'وصلات_مكسورة' ),
	'Wantedcategories'          => array( 'تصنيفات_مطلوبة' ),
	'Mostlinked'                => array( 'الأكثر_وصلا' ),
	'Mostlinkedcategories'      => array( 'أكثر_التصنيفات_وصلا' ),
	'Mostlinkedtemplates'       => array( 'أكثر_القوالب_وصلا' ),
	'Mostcategories'            => array( 'أكثر_الصفحات_تصنيفا' ),
	'Mostimages'                => array( 'أكثر_الصور_وصلا' ),
	'Mostrevisions'             => array( 'الأكثر_تعديلا' ),
	'Fewestrevisions'           => array( 'الأقل_تعديلا' ),
	'Shortpages'                => array( 'صفحات_قصيرة' ),
	'Longpages'                 => array( 'صفحات_طويلة' ),
	'Newpages'                  => array( 'صفحات_جديدة' ),
	'Ancientpages'              => array( 'صفحات_قديمة' ),
	'Deadendpages'              => array( 'صفحات_نهاية_مسدودة' ),
	'Protectedpages'            => array( 'صفحات_محمية' ),
	'Protectedtitles'           => array( 'عناوين_محمية' ),
	'Allpages'                  => array( 'كل_الصفحات' ),
	'Prefixindex'               => array( 'فهرس_بادئة' ),
	'Ipblocklist'               => array( 'قائمة_منع_أيبي' ),
	'Specialpages'              => array( 'صفحات_خاصة' ),
	'Contributions'             => array( 'مساهمات' ),
	'Emailuser'                 => array( 'مراسلة_المستخدم' ),
	'Confirmemail'              => array( 'تأكيد_البريد' ),
	'Whatlinkshere'             => array( 'ماذا_يصل_هنا' ),
	'Recentchangeslinked'       => array( 'أحدث_التغييرات_الموصولة' ),
	'Movepage'                  => array( 'نقل_صفحة' ),
	'Blockme'                   => array( 'منعي' ),
	'Booksources'               => array( 'مصادر_كتاب' ),
	'Categories'                => array( 'تصنيفات' ),
	'Export'                    => array( 'تصدير' ),
	'Version'                   => array( 'إصدار' ),
	'Allmessages'               => array( 'كل_الرسائل' ),
	'Log'                       => array( 'سجل', 'سجلات' ),
	'Blockip'                   => array( 'منع_أيبي' ),
	'Undelete'                  => array( 'استرجاع' ),
	'Import'                    => array( 'استيراد' ),
	'Lockdb'                    => array( 'غلق_قب' ),
	'Unlockdb'                  => array( 'فتح_قب' ),
	'Userrights'                => array( 'صلاحيات_المستخدم' ),
	'MIMEsearch'                => array( 'بحث_ميم' ),
	'Unwatchedpages'            => array( 'صفحات_غير_مراقبة' ),
	'Listredirects'             => array( 'عرض_التحويلات' ),
	'Revisiondelete'            => array( 'حذف_نسخة' ),
	'Unusedtemplates'           => array( 'قوالب_غير_مستخدمة' ),
	'Randomredirect'            => array( 'تحويلة_عشوائية' ),
	'Mypage'                    => array( 'صفحتي' ),
	'Mytalk'                    => array( 'نقاشي' ),
	'Mycontributions'           => array( 'مساهماتي' ),
	'Listadmins'                => array( 'عرض_الإداريين' ),
	'Listbots'                  => array( 'عرض_البوتات' ),
	'Popularpages'              => array( 'صفحات_مشهورة' ),
	'Search'                    => array( 'بحث' ),
	'Resetpass'                 => array( 'ضبط_كلمة_السر' ),
	'Withoutinterwiki'          => array( 'بدون_إنترويكي' ),
	'MergeHistory'              => array( 'دمج_التاريخ' ),
	'Filepath'                  => array( 'مسار_ملف' ),
);

$messages = array(
# User preference toggles
'tog-underline'               => 'ضع خطا تحت الوصلات:',
'tog-highlightbroken'         => 'أظهر الوصلات المكسورة <a href="" class="new">بهذا الشكل</a> (البديل: بهذا الشكل<a href="" class="internal">؟</a>).',
'tog-justify'                 => 'اجعل عرض الأسطر في الفقرات متساو',
'tog-hideminor'               => 'خبئ التعديلات الطفيفة في أحدث التغييرات',
'tog-extendwatchlist'         => 'مدد قائمة المراقبة لعرض كل التغييرات المطبقة',
'tog-usenewrc'                => 'شكل متقدم من أحدث التغييرات (جافا سكريبت)',
'tog-numberheadings'          => 'رقم العناوين تلقائيا',
'tog-showtoolbar'             => 'اعرض شريط التحرير (جافا سكريبت)',
'tog-editondblclick'          => 'عدل الصفحات عند الضغط المزدوج (جافا سكريبت)',
'tog-editsection'             => 'فعل تعديل الأقسام عن طريق وصلات [تحرير]',
'tog-editsectiononrightclick' => 'فعل تعديل الأقسام بواسطة كبسة الفأرة اليمين على عناوين الأقسام (جافاسكريبت)',
'tog-showtoc'                 => 'اعرض فهرس المحتويات (للصفحات التي تحتوي على أكثر من 3 عناوين)',
'tog-rememberpassword'        => 'تذكر دخولي على هذا الحاسوب',
'tog-editwidth'               => 'صندوق التحرير يأخذ كامل العرض',
'tog-watchcreations'          => 'أضف الصفحات التي أنشئها إلى قائمة مراقبتي',
'tog-watchdefault'            => 'أضف الصفحات التي أحررها إلى قائمة مراقبتي',
'tog-watchmoves'              => 'أضف الصفحات التي أنقلها إلى قائمة مراقبتي',
'tog-watchdeletion'           => 'أضف الصفحات التي أحذفها إلى قائمة مراقبتي',
'tog-minordefault'            => 'علم كل التعديلات كطفيفة افتراضيا',
'tog-previewontop'            => 'أظهر العرض المسبق قبل صندوق التحرير',
'tog-previewonfirst'          => 'أظهر العرض المسبق عند أول تعديل',
'tog-nocache'                 => 'عطل تخبئة الصفحة',
'tog-enotifwatchlistpages'    => 'أرسل لي رسالة إلكترونية عندما يتم تغيير صفحة أراقبها',
'tog-enotifusertalkpages'     => 'أرسل لي رسالة إلكترونية عندما يتم تغيير صفحة نقاشي',
'tog-enotifminoredits'        => 'أرسل لي رسالة إلكترونية للتعديلات الطفيفة للصفحات أيضا',
'tog-enotifrevealaddr'        => 'أظهر عنوان بريدي الإلكتروني في رسائل الإخطار',
'tog-shownumberswatching'     => 'اعرض عدد المستخدمين المراقبين',
'tog-fancysig'                => 'توقيعات خام (بدون وصلة أوتوماتيكية)',
'tog-externaleditor'          => 'استخدم محرر خارجي افتراضيا',
'tog-externaldiff'            => 'استخدم فرقا خارجيا افتراضيا',
'tog-showjumplinks'           => 'فعل وصلات "اذهب إلى".',
'tog-uselivepreview'          => 'استخدم الاستعراض السريع (جافاسكريبت) (تجريبي)',
'tog-forceeditsummary'        => 'نبهني عند إدخال ملخص تعديل فارغا',
'tog-watchlisthideown'        => 'أخف تعديلاتي من قائمة المراقبة',
'tog-watchlisthidebots'       => 'أخف تعديلات البوت من قائمة المراقبة',
'tog-watchlisthideminor'      => 'أخف التعديلات الطفيفة من قائمة المراقبة',
'tog-nolangconversion'        => 'عطل تحويل اللهجات',
'tog-ccmeonemails'            => 'أرسل لي نسخا من رسائل البريد الإلكتروني التي أرسلها للمستخدمين الآخرين',
'tog-diffonly'                => 'لا تعرض محتوى الصفحة أسفل الفروقات',

'underline-always'  => 'دائما',
'underline-never'   => 'أبدا',
'underline-default' => 'تبعا لإعدادات المتصفح',

'skinpreview' => '(عرض)',

# Dates
'sunday'        => 'الأحد',
'monday'        => 'الإثنين',
'tuesday'       => 'الثلاثاء',
'wednesday'     => 'الأربعاء',
'thursday'      => 'الخميس',
'friday'        => 'الجمعة',
'saturday'      => 'السبت',
'sun'           => 'أحد',
'mon'           => 'إثنين',
'tue'           => 'ثلاثاء',
'wed'           => 'أربعاء',
'thu'           => 'خميس',
'fri'           => 'جمعة',
'sat'           => 'سبت',
'january'       => 'يناير',
'february'      => 'فبراير',
'march'         => 'مارس',
'april'         => 'أبريل',
'may_long'      => 'مايو',
'june'          => 'يونيو',
'july'          => 'يوليو',
'august'        => 'أغسطس',
'september'     => 'سبتمبر',
'october'       => 'أكتوبر',
'november'      => 'نوفمبر',
'december'      => 'ديسمبر',
'january-gen'   => 'يناير',
'february-gen'  => 'فبراير',
'march-gen'     => 'مارس',
'april-gen'     => 'أبريل',
'may-gen'       => 'مايو',
'june-gen'      => 'يونيو',
'july-gen'      => 'يوليو',
'august-gen'    => 'أغسطس',
'september-gen' => 'سبتمبر',
'october-gen'   => 'أكتوبر',
'november-gen'  => 'نوفمبر',
'december-gen'  => 'ديسمبر',
'jan'           => 'يناير',
'feb'           => 'فبراير',
'mar'           => 'مارس',
'apr'           => 'أبريل',
'may'           => 'مايو',
'jun'           => 'يونيو',
'jul'           => 'يوليو',
'aug'           => 'أغسطس',
'sep'           => 'سبتمبر',
'oct'           => 'أكتوبر',
'nov'           => 'نوفمبر',
'dec'           => 'ديسمبر',

# Bits of text used by many pages
'categories'            => 'تصنيفات',
'pagecategories'        => '{{PLURAL:$1|تصنيف|تصنيفات}}',
'category_header'       => 'الصفحات في التصنيف "$1"',
'subcategories'         => 'التصنيفات الفرعية',
'category-media-header' => 'ملفات الميديا في التصنيف "$1"',
'category-empty'        => "''هذا التصنيف لا يحتوي حاليا على مقالات أو ملفات ميديا.''",

'mainpagetext'      => "<big>'''تم تثبيت ميدياويكي بنجاح.'''</big>",
'mainpagedocfooter' => 'استشر [http://meta.wikimedia.org/wiki/Help:Contents دليل المستخدم] لمعلومات حول استخدام برنامج الويكي.

== البداية ==

* [http://www.mediawiki.org/wiki/Manual:Configuration_settings قائمة إعدادات الضبط]
* [http://www.mediawiki.org/wiki/Manual:FAQ أسئلة متكررة حول ميدياويكي]
* [http://lists.wikimedia.org/mailman/listinfo/mediawiki-announce القائمة البريدية الخاصة بإصدار ميدياويكي]',

'about'          => 'حول',
'article'        => 'صفحة محتوى',
'newwindow'      => '(تفتح في نافذة جديدة)',
'cancel'         => 'إلغاء',
'qbfind'         => 'إيجاد',
'qbbrowse'       => 'تصفح',
'qbedit'         => 'عدل',
'qbpageoptions'  => 'هذه الصفحة',
'qbpageinfo'     => 'سياق النص',
'qbmyoptions'    => 'صفحاتي',
'qbspecialpages' => 'الصفحات الخاصة',
'moredotdotdot'  => 'المزيد...',
'mypage'         => 'صفحتي',
'mytalk'         => 'نقاشي',
'anontalk'       => 'النقاش لعنوان الأيبي هذا',
'navigation'     => 'إبحار',
'and'            => 'و',

# Metadata in edit box
'metadata_help' => 'بيانات ميتا:',

'errorpagetitle'    => 'خطأ',
'returnto'          => 'ارجع إلى $1.',
'tagline'           => 'من {{SITENAME}}',
'help'              => 'مساعدة',
'search'            => 'بحث',
'searchbutton'      => 'بحث',
'go'                => 'اذهب',
'searcharticle'     => 'اذهب',
'history'           => 'تاريخ الصفحة',
'history_short'     => 'تاريخ',
'updatedmarker'     => 'تم تحديثها منذ زيارتي الأخيرة',
'info_short'        => 'معلومات',
'printableversion'  => 'نسخة للطباعة',
'permalink'         => 'وصلة دائمة',
'print'             => 'طباعة',
'edit'              => 'عدل',
'editthispage'      => 'عدل هذه الصفحة',
'delete'            => 'حذف',
'deletethispage'    => 'احذف هذه الصفحة',
'undelete_short'    => 'استرجاع {{PLURAL:$1|تعديل واحد|تعديلان|$1 تعديلات|$1 تعديل|$1 تعديلا}}',
'protect'           => 'حماية',
'protect_change'    => 'غير الحماية',
'protectthispage'   => 'احم هذه الصفحة',
'unprotect'         => 'أزل الحماية',
'unprotectthispage' => 'أزل حماية هذه الصفحة',
'newpage'           => 'صفحة جديدة',
'talkpage'          => 'ناقش هذه الصفحة',
'talkpagelinktext'  => 'نقاش',
'specialpage'       => 'صفحة خاصة',
'personaltools'     => 'أدوات شخصية',
'postcomment'       => 'أرسل تعليقا',
'articlepage'       => 'عرض صفحة المحتوى',
'talk'              => 'نقاش',
'views'             => 'معاينة',
'toolbox'           => 'صندوق الأدوات',
'userpage'          => 'عرض صفحة المستخدم',
'projectpage'       => 'عرض صفحة المشروع',
'imagepage'         => 'عرض صفحة الميديا',
'mediawikipage'     => 'عرض صفحة الرسالة',
'templatepage'      => 'عرض صفحة القالب',
'viewhelppage'      => 'عرض صفحة المساعدة',
'categorypage'      => 'عرض صفحة التصنيف',
'viewtalkpage'      => 'عرض النقاش',
'otherlanguages'    => 'بلغات أخرى',
'redirectedfrom'    => '(تم التحويل من $1)',
'redirectpagesub'   => 'صفحة تحويل',
'lastmodifiedat'    => 'آخر تعديل لهذه الصفحة كان في $2، $1.', # $1 date, $2 time
'viewcount'         => 'تم عرض هذه الصفحة {{PLURAL:$1|مرة واحدة|مرتان|$1 مرات|$1 مرة}}.',
'protectedpage'     => 'صفحة محمية',
'jumpto'            => 'اذهب إلى:',
'jumptonavigation'  => 'إبحار',
'jumptosearch'      => 'بحث',

# All link text and link target definitions of links into project namespace that get used by other message strings, with the exception of user group pages (see grouppage) and the disambiguation template definition (see disambiguations).
'aboutsite'         => 'حول {{SITENAME}}',
'aboutpage'         => 'Project:حول',
'bugreports'        => 'بلاغ الأخطاء',
'bugreportspage'    => 'Project:بلاغ أخطاء',
'copyright'         => 'المحتوى متوفر تحت $1.',
'copyrightpagename' => 'حقوق النسخ في {{SITENAME}}',
'copyrightpage'     => '{{ns:project}}:حقوق النسخ',
'currentevents'     => 'الأحداث الجارية',
'currentevents-url' => 'Project:الأحداث الجارية',
'disclaimers'       => 'عدم مسؤولية',
'disclaimerpage'    => 'Project:عدم مسؤولية عام',
'edithelp'          => 'مساعدة التحرير',
'edithelppage'      => 'Help:تحرير',
'faq'               => 'الأسئلة الأكثر تكرارا',
'faqpage'           => 'Project:أسئلة متكررة',
'helppage'          => 'Help:محتويات',
'mainpage'          => 'الصفحة الرئيسية',
'policy-url'        => 'Project:سياسة',
'portal'            => 'بوابة المجتمع',
'portal-url'        => 'Project:بوابة المجتمع',
'privacy'           => 'سياسة الخصوصية',
'privacypage'       => 'Project:سياسة الخصوصية',
'sitesupport'       => 'التبرعات',
'sitesupport-url'   => 'Project:دعم الموقع',

'badaccess'        => 'خطأ في السماح',
'badaccess-group0' => 'ليس من المسموح لك تنفيذ الفعل الذي طلبته.',
'badaccess-group1' => 'الفعل الذي طلبته مقصور على المستخدمين في المجموعة $1.',
'badaccess-group2' => 'الفعل الذي طلبته مقصور على المستخدمين في إحدى المجموعتين $1.',
'badaccess-groups' => 'الفعل الذي طلبته مقصور على المستخدمين في إحدى المجموعات $1.',

'versionrequired'     => 'يلزم الإصدار $1 من ميدياويكي',
'versionrequiredtext' => 'يلزم الإصدار $1 من ميدياويكي لاستعمال هذه الصفحة. انظر [[Special:Version|صفحة الإصدار]]',

'ok'                      => 'موافق',
'retrievedfrom'           => 'تم الاسترجاع من "$1"',
'youhavenewmessages'      => 'توجد لديك $1 ($2).',
'newmessageslink'         => 'رسائل جديدة',
'newmessagesdifflink'     => 'آخر تغيير',
'youhavenewmessagesmulti' => 'لديك رسائل جديدة على $1',
'editsection'             => 'تحرير',
'editold'                 => 'تحرير',
'editsectionhint'         => 'تحرير القسم: $1',
'toc'                     => 'محتويات',
'showtoc'                 => 'عرض',
'hidetoc'                 => 'إخفاء',
'thisisdeleted'           => 'عرض أو استرجاع $1؟',
'viewdeleted'             => 'عرض $1؟',
'restorelink'             => '{{PLURAL:$1|تعديل واحد محذوف|تعديلان محذوفان|$1 تعديلات محذوفة|$1 تعديل محذوف|$1 تعديلا محذوفا}}',
'feedlinks'               => 'تلقيم:',
'feed-invalid'            => 'نوع اشتراك التليقم غير صحيح.',
'feed-unavailable'        => 'التلقيمات غير متوفرة في {{SITENAME}}',
'site-rss-feed'           => '$1 تلقيم أر‌إس‌إس',
'site-atom-feed'          => '$1 تلقيم أتوم',
'page-rss-feed'           => '"$1" تلقيم أر‌إس‌إس',
'page-atom-feed'          => '"$1" تلقيم أتوم',
'feed-atom'               => 'أتوم',
'feed-rss'                => 'أر إس إس',
'red-link-title'          => '$1 (لم تتم كتابتها بعد)',

# Short words for each namespace, by default used in the namespace tab in monobook
'nstab-main'      => 'صفحة',
'nstab-user'      => 'صفحة مستخدم',
'nstab-media'     => 'صفحة ميديا',
'nstab-special'   => 'خاص',
'nstab-project'   => 'صفحة مشروع',
'nstab-image'     => 'ملف',
'nstab-mediawiki' => 'رسالة',
'nstab-template'  => 'قالب',
'nstab-help'      => 'صفحة مساعدة',
'nstab-category'  => 'تصنيف',

# Main script and global functions
'nosuchaction'      => 'لا يوجد فعل كهذا',
'nosuchactiontext'  => 'الأمر في المسار لم يتم التعرف عليه بواسطة الويكي',
'nosuchspecialpage' => 'لا توجد صفحة خاصة بهذا الاسم',
'nospecialpagetext' => "<big>'''لقد طلبت صفحة خاصة غير صحيحة.'''</big>

قائمة بالصفحات الخاصة الصحيحة يمكن إيجادها في [[Special:Specialpages]].",

# General errors
'error'                => 'خطأ',
'databaseerror'        => 'خطأ في قاعدة البيانات',
'dberrortext'          => 'حدث خطأ في صيغة الاستعلام.
ربما يكون هذا عيب بالبرنامج.
آخر استعلام طُلب من قاعدة البيانات كان:
<blockquote><tt>$1</tt></blockquote>
من داخل الدالة "<tt>$2</tt>".
MySQL أرجعت الخطأ "<tt>$3: $4</tt>".',
'dberrortextcl'        => 'حدث خطأ في صيغة الاستعلام.
آخر استعلام طُلب من قاعدة البيانات كان:
"$1"
من داخل الدالة "$2".
MySQL أرجعت الخطأ "$3: $4"',
'noconnect'            => 'عذرا! تعاني الويكي من بعض المشاكل التقنية، ولا يمكن الاتصال بخادم قاعدة البيانات. <br />
$1',
'nodb'                 => 'لم يتمكن من اختيار قاعدة البيانات $1',
'cachederror'          => 'هذه نسخة مخبأة من الصفحة المطلوبة، وقد لا تكون محدثة.',
'laggedslavemode'      => 'تحذير: الصفحة قد لا تحتوي على أحدث التحديثات.',
'readonly'             => 'قاعدة البيانات مغلقة',
'enterlockreason'      => 'أدخل سببا للغلق، متضمنا تقديرا لوقت رفع الغلق',
'readonlytext'         => 'قاعدة البيانات مغلقة حاليا أمام المدخلات الجديدة والتعديلات الأخرى، السبب غالبا ما يكون الصيانة، وستعود قاعدة البيانات للوضع الطبيعي قريبا.

الإداري الذي أغلق قاعدة البيانات أعطى التفسير التالي:
$1',
'missingarticle'       => 'لم تعثر قاعدة البيانات على نص الصفحة المفترض، باسم "$1".

عادة ما يكون السبب في ذلك اتباع وصلة فرق قديمة أو وصلة لتاريخ صفحة محذوفة.

لو كانت هذه ليست الحالة، فمن الممكن أن تكون قد عثرت على خطأ في البرنامج. من فضلك أبلغ هذا لأحد الإداريين، مع ذكر الوصلة.',
'readonly_lag'         => 'تم إغلاق قاعدة البيانات تلقائيا حتى تستطيع الخوادم التابعة ملاحقة الخادم الرئيسي',
'internalerror'        => 'خطأ داخلي',
'internalerror_info'   => 'خطأ داخلي: $1',
'filecopyerror'        => 'لم يمكن نسخ الملف "$1" إلى "$2".',
'filerenameerror'      => 'لم يمكن إعادة تسمية الملف "$1" إلى "$2".',
'filedeleteerror'      => 'لم يمكن حذف الملف "$1".',
'directorycreateerror' => 'لم يمكن إنشاء المجلد "$1".',
'filenotfound'         => 'لم يمكن إيجاد الملف "$1".',
'fileexistserror'      => 'غير قادر على الكتابة للملف "$1": الملف موجود',
'unexpected'           => 'قيمة غير متوقعة: "$1"="$2".',
'formerror'            => 'خطأ: لم يمكن تنفيذ الاستمارة',
'badarticleerror'      => 'لا يمكن إجراء هذا الفعل على هذه الصفحة.',
'cannotdelete'         => 'لم يمكن حذف الصفحة أو الملف المحدد. (ربما يكون قد تم حذفه بواسطة شخص آخر. )',
'badtitle'             => 'عنوان سيء',
'badtitletext'         => 'عنوان الصفحة المطلوب إما غير صحيح أو فارغ، و ربما الوصلة بين اللغات أو بين المشاريع خاطئة. ومن الممكن وجود رموز لا تصلح للاستخدام في العناوين.',
'perfdisabled'         => 'عذرا! هذه الخاصية معطلة حاليا لأنها تبطئ قاعدة البيانات إلى حد أنه لا أحد يستطيع استخدام الويكي.',
'perfcached'           => 'البيانات التالية مخبأة وقد لا تكون محدثة.',
'perfcachedts'         => 'البيانات التالية مخبأة، آخر تحديث لها كان في $1.',
'querypage-no-updates' => 'التحديثات لهذه الصفحة معطلة حاليا. البيانات هنا لن يتم تحديثها حاليا.',
'wrong_wfQuery_params' => 'محددات خاطئة في wfQuery()<br />
الدالة: $1<br />
الاستعلام: $2',
'viewsource'           => 'عرض المصدر',
'viewsourcefor'        => 'ل $1',
'actionthrottled'      => 'لا يمكن عمل المزيد من هذا الفعل',
'actionthrottledtext'  => 'كإجراء ضد السبام، أنت ممنوع من إجراء هذا الفعل عدد كبير من المرات في فترة زمنية قصيرة، ولقد تجاوزت هذا الحد. من فضلك حاول مرة ثانية خلال عدة دقائق.',
'protectedpagetext'    => 'تمت حماية هذه الصفحة لمنع التعديل.',
'viewsourcetext'       => 'يمكنك رؤية ونسخ مصدر هذه الصفحة:',
'protectedinterface'   => 'هذه الصفحة توفر نص الواجهة للبرنامج، وهي مقفلة لمنع التخريب.',
'editinginterface'     => "'''تحذير''': أنت تقوم بتحرير صفحة تستخدم في الواجهة النصية للبرنامج. التغييرات لهذه الصفحة سوف تؤثر على مظهر واجهة المستخدم للمستخدمين الآخرين. للترجمات، من فضلك استخدم [http://translatewiki.net/wiki/Main_Page?setlang=ar بيتاويكي]، مشروع ترجمة الميدياويكي.",
'sqlhidden'            => '(استعلام إس‌كيو‌إل مخفي)',
'cascadeprotected'     => 'تمت حماية هذه الصفحة من التعديل، بسبب كونها مدمجة في {{PLURAL:$1|صفحة|صفحات}} التالية، والتي تم استعمال خاصية "حماية الصفحات المدمجة" بها:
$2',
'namespaceprotected'   => "لا تمتلك الصلاحية لتعديل الصفحات في نطاق '''$1'''.",
'customcssjsprotected' => 'لا تمتلك الصلاحية لتعديل هذه الصفحة، لأنها تحتوي على الإعدادات الشخصية لمستخدم آخر.',
'ns-specialprotected'  => 'الصفحات في النطاق {{ns:special}} لا يمكن تعديلها.',
'titleprotected'       => 'هذا العنوان تمت حمايته من الإنشاء بواسطة [[User:$1|$1]]. السبب المعطى هو <i>$2</i>.',

# Login and logout pages
'logouttitle'                => 'خروج المستخدم',
'logouttext'                 => '<strong>أنت الآن غير مسجل الدخول للنظام.</strong><br />
تستطيع المتابعة باستعمال {{SITENAME}} كمجهول، أو الدخول مرة أخرى بنفس الاسم أو باسم آخر. من الممكن أن ترى بعض الصفحات في كما وأنك مسجل في النظام، وذلك بسبب استعمال الصفحات المخبأة في المتصفح لديك.',
'welcomecreation'            => '== مرحبا يا $1! ==

تم إنشاء حسابك. لا تنس أن تغير تفضيلاتك في {{SITENAME}}.',
'loginpagetitle'             => 'دخول المستخدم',
'yourname'                   => 'اسم المستخدم:',
'yourpassword'               => 'كلمة السر:',
'yourpasswordagain'          => 'أعد كتابة كلمة السر:',
'remembermypassword'         => 'تذكر دخولي على هذا الحاسوب',
'yourdomainname'             => 'نطاقك:',
'externaldberror'            => 'هناك إما خطأ في دخول قاعدة البيانات الخارجية أو أنه غير مسموح لك بتحديث حسابك الخارجي.',
'loginproblem'               => '<b>حدثت مشكلة أثناء الدخول.</b><br />يرجى المحاولة مرى أخرى!',
'login'                      => 'دخول',
'loginprompt'                => 'يجب أن تكون الكوكيز لديك مفعلة لتتمكن من الدخول إلى {{SITENAME}}.',
'userlogin'                  => 'دخول / إنشاء حساب',
'logout'                     => 'خروج',
'userlogout'                 => 'خروج',
'notloggedin'                => 'غير مسجل',
'nologin'                    => 'لم تشترك بعد؟ $1.',
'nologinlink'                => 'قم بإنشاء حساب',
'createaccount'              => 'أنشئ حسابا',
'gotaccount'                 => 'تمتلك حسابا بالفعل؟ $1.',
'gotaccountlink'             => 'دخول',
'createaccountmail'          => 'بواسطة البريد الإلكتروني',
'badretype'                  => 'كلمات السر التي أدخلتها لا تتطابق.',
'userexists'                 => 'اسم المستخدم الذي أدخلته مستعمل بالفعل. من فضلك اختر اسما مختلفا.',
'youremail'                  => 'البريد الإلكتروني:',
'username'                   => 'اسم المستخدم:',
'uid'                        => 'رقم المستخدم:',
'yourrealname'               => 'الاسم الحقيقي:',
'yourlanguage'               => 'اللغة:',
'yourvariant'                => 'اللهجة:',
'yournick'                   => 'اللقب:',
'badsig'                     => 'توقيع خام غير صحيح؛ تحقق من وسوم الHTML.',
'badsiglength'               => 'التوقيع طويل جدا؛ يجب أن يكون أقل من $1 حرف.',
'email'                      => 'البريد الإلكتروني',
'prefs-help-realname'        => 'الاسم الحقيقي اختياري ولو اخترت أن تعرض اسمك هنا فسيستخدم في الإشارة إلى مساهماتك.',
'loginerror'                 => 'خطأ في الدخول',
'prefs-help-email'           => 'البريد الإلكتروني هو مدخل اختياري يمكّن الآخرين من الاتصال بك عن طريق صفحتك أو صفحة نقاشك من دون معرفة هويتك.',
'prefs-help-email-required'  => 'عنوان البريد الإلكتروني مطلوب.',
'nocookiesnew'               => 'تم إنشاء حساب المستخدم، و لكنك لست مسجل الدخول بعد. يستخدم {{SITENAME}} كوكيز لتسجيل الدخول. لديك الكوكيز معطلة. من فضلك فعلها، ثم أدخل باسم الحساب و كلمة السر الجديدتين.',
'nocookieslogin'             => '{{SITENAME}} يستخدم الكوكيز لتسجيل الدخول؛ لديك الكوكيز معطلة؛ من فضلك فعلها ثم حاول مرة أخرى.',
'noname'                     => 'لم تحدد اسم مستخدم صحيح.',
'loginsuccesstitle'          => 'تم الدخول بشكل صحيح',
'loginsuccess'               => "'''لقد قمت بتسجيل الدخول ل{{SITENAME}} باسم \"\$1\".'''",
'nosuchuser'                 => 'لا يوجد مستخدم بالاسم "$1".
تأكد من إملاء الاسم، أو قم بإنشاء حساب جديد.',
'nosuchusershort'            => 'لا يوجد مستخدم باسم <nowiki>$1</nowiki>". تأكد من إملاء الاسم.',
'nouserspecified'            => 'يجب عليك تحديد اسم مستخدم.',
'wrongpassword'              => 'كلمة السر التي أدخلتها غير صحيحة. من فضلك حاول مرة أخرى.',
'wrongpasswordempty'         => 'كلمة السر المدخلة كانت فارغة. من فضلك حاول مرة أخرى.',
'passwordtooshort'           => 'كلمة السر التي اخترتها غير صحيحة أو قصيرة جدا. يجب ألا يقل طول الكلمة عن $1 حرف وأن تكون مختلفة عن اسم المستخدم الخاص بك.',
'mailmypassword'             => 'أرسل لي كلمة السر عبر البريد الإلكتروني.',
'passwordremindertitle'      => 'كلمة سر مؤقتة جديدة ل {{SITENAME}}',
'passwordremindertext'       => 'لقد طلب شخص ما (غالبا أنت، من عنوان الأيبي $1) أن نرسل لك كلمة سر جديدة لـ{{SITENAME}} ($4).

كلمة السر للمستخدم "$2" الآن هي "$3". 
عليك أن تقوم بالدخول إلى الموقع وتغيير كلمة السر خاصتك الآن.

إذا لم تكن أنت من قام بطلب كلمة السر أو أنك تذكرت كلمة السر السابقة ولا ترغب بتغييرها فبإمكانك أن تتجاهل هذه الرسالة وأن تستمر في استخدام كلمة السر السابقة خاصتك.',
'noemail'                    => 'لا يوجد عنوان بريد إلكتروني مسجل للمستخدم "$1".',
'passwordsent'               => 'تم إرسال كلمة سر جديدة إلى عنوان البريد الإلكتروني المسجل للمستخدم "$1".
من فضلك حاول تسجيل الدخول مرة ثانية بعد استلامها.',
'blocked-mailpassword'       => 'تم منع عنوان الأيبي الخاص بك من التحرير، ولمنع التخريب لا يمكنك أن تستخدم خاصية استرجاع كلمة السر.',
'eauthentsent'               => 'تم إرسال رسالة تأكيد إلكترونية إلى العنوان المسمى. حتى ترسل أي رسالة أخرى لذلك الحساب عليك أن تتبع التعليمات الواردة في الرسالة لتأكيد أن هذا الحساب هو لك بالفعل.',
'throttled-mailpassword'     => 'تم بالفعل إرسال تذكير بكلمة السر، في خلال الـ$1 ساعة الماضية.
لمنع التخريب، تذكير واحد فقط سيتم إرساله كل
$1 ساعة.',
'mailerror'                  => 'خطأ أثناء إرسال البريد: $1',
'acct_creation_throttle_hit' => 'عذرا، لقد قمت بإنشاء $1 حساب. لا يمكنك عمل المزيد.',
'emailauthenticated'         => 'تم تأكيد بريدك الإلكتروني في $1.',
'emailnotauthenticated'      => 'لم يتم التحقق من بريدك الإلكتروني. لن يتم إرسال رسائل لأي من الميزات التالية.',
'noemailprefs'               => 'يجب تحديد عنوان بريد إلكتروني لتفعيل هذه الخصائص.',
'emailconfirmlink'           => 'أكد عنوان بريدك الإلكتروني',
'invalidemailaddress'        => 'لا يمكن قبول عنوان البريد الإلكتروني الذي زودته حيث يبدو خاطئا. من فضلك ضع عنوانا مضبوطا أو أفرغ هذا الحقل.',
'accountcreated'             => 'تم إنشاء الحساب',
'accountcreatedtext'         => 'تم إنشاء الحساب الخاص ب$1.',
'createaccount-title'        => 'إنشاء حساب في {{SITENAME}}',
'createaccount-text'         => 'شخص ما أنشأ حسابا لعنوان بريدك الإلكتروني في {{SITENAME}} ($4) بالاسم "$2"، كلمة السر "$3". ينبغي عليك تسجيل الدخول وتغيير كلمة السر الخاصة بك الآن.

يمكنك تجاهل هذه الرسالة، لو تم إنشاء هذا الحساب بالخطأ.',
'loginlanguagelabel'         => 'اللغة: $1',

# Password reset dialog
'resetpass'               => 'أعد ضبط كلمة سر الحساب',
'resetpass_announce'      => 'تم تسجيل دخولك بكلمة سر مؤقتة. للدخول بشكل نهائي، يجب عليك ضبط كلمة سر جديدة هنا:',
'resetpass_text'          => '<!-- أضف نصا هنا -->',
'resetpass_header'        => 'أعد ضبط كلمة السر',
'resetpass_submit'        => 'ضبط كلمة السر والدخول',
'resetpass_success'       => 'تم تغيير كلمة السر الخاصة بك بنجاح! يتم تسجيل دخولك الآن...',
'resetpass_bad_temporary' => 'كلمة السر المؤقتة خاطئة. ربما تم تغيير كلمة السر فعليا بنجاح أو ربما قمت بطلب كلمة سر مؤقتة جديدة.',
'resetpass_forbidden'     => 'لا يمكن تغيير كلمات السر في {{SITENAME}}',
'resetpass_missing'       => 'لم يتم استقبال بيانات.',

# Edit page toolbar
'bold_sample'     => 'نص عريض',
'bold_tip'        => 'نص عريض',
'italic_sample'   => 'نص مائل',
'italic_tip'      => 'نص مائل',
'link_sample'     => 'عنوان وصلة',
'link_tip'        => 'وصلة داخلية',
'extlink_sample'  => 'http://www.example.com عنوان الوصلة',
'extlink_tip'     => 'وصلة خارجية (تذكر إضافة http:// قبل عنوان الوصلة)',
'headline_sample' => 'نص عنوان رئيسي',
'headline_tip'    => 'عنوان من المستوى الثاني',
'math_sample'     => 'أدخل الصيغة هنا',
'math_tip'        => 'صيغة رياضية (لا تك)',
'nowiki_sample'   => 'أدخل النص غير المنسق هنا',
'nowiki_tip'      => 'أهمل تهيئة الويكي',
'image_tip'       => 'ملف مدرج',
'media_tip'       => 'وصلة ملف',
'sig_tip'         => 'توقيعك مع الساعة والتاريخ',
'hr_tip'          => 'خط أفقي (تجنب الاستخدام بكثرة)',

# Edit pages
'summary'                   => 'ملخص',
'subject'                   => 'موضوع/عنوان',
'minoredit'                 => 'هذا تعديل طفيف',
'watchthis'                 => 'راقب هذه الصفحة',
'savearticle'               => 'احفظ الصفحة',
'preview'                   => 'عرض مسبق',
'showpreview'               => 'عرض التعديلات',
'showlivepreview'           => 'عرض مباشر',
'showdiff'                  => 'عرض التغييرات',
'anoneditwarning'           => "'''تحذير:''' لم تقم بالدخول؛ سيتم تسجيل عنوان الأيبي الخاص بك في تاريخ هذه الصفحة.",
'missingsummary'            => "'''تنبيه:''' لم تقم بكتابة ملخص للتعديل. إذا قمت بضغط حفظ الصفحة مرة أخرى فيتم حفظ تعديلك بدون ملخص.",
'missingcommenttext'        => 'من فضلك أدخل تعليقا في الأسفل.',
'missingcommentheader'      => "'''تنبيه:''' لم تقم بوضع موضوع/عنوان لهذا التعليق، إذا قمت بالضغط على حفظ الصفحة مجددا، سيتم حفظ تعليقك بدون عنوان.",
'summary-preview'           => 'عرض مسبق للملخص',
'subject-preview'           => 'عرض مسبق للموضوع/العنوان',
'blockedtitle'              => 'المستخدم ممنوع',
'blockedtext'               => "<big>'''اسم المستخدم أو عنوان الأيبي الخاص بك تم منعه.'''</big>

سبب المنع هو: ''$2''. وقام بالمنع $1.

* بداية المنع: $8
* انتهاء المنع: $6
* الممنوع المقصود: $7

من الممكن التواصل مع $1 للنقاش حول المنع، أو مع أحد [[{{MediaWiki:Grouppage-sysop}}|الإداريين]] حول ذلك>
تذكر أنه لا يمكن لك استعمال خاصية إرسال رسائل إلكترونية للمستخدمين إلا إذا كنت قد وضعت عنوان بريدي صحيح في صفحة [[Special:Preferences|التفضيلات]] الخاصة بك.
عنوان الأيبي الخاص بك حاليا هو $3 وكود المنع هو #$5. يرجى إضافة أيهما أو كلاهما في أي رسالة للتساؤل حول المنع.",
'autoblockedtext'           => 'عنوان الأيبي الخاص بك تم منعه تلقائيا لأنه تم استخدامه بواسطة مستخدم آخر، و الذي تم منعه بواسطة $1.
السبب الممنوح هو التالي:

:\'\'$2\'\'

* بداية المنع: $8
* انتهاء المنع: $6

يمكنك أن تتصل ب $1 أو أحد
[[{{MediaWiki:Grouppage-sysop}}|الإداريين]] الآخرين لمناقشة المنع.

لاحظ أنه لا يمكنك استخدام خاصية "إرسال رسالة لهذا المستخدم" إلا لو كان لديك عنوان بريد إلكتروني صحيح مسجل في [[Special:Preferences|تفضيلاتك]].

رقم منعك هو $5. من فضلك اذكر هذا الرقم في أي استفسار.',
'blockednoreason'           => 'لا سبب معطى',
'blockedoriginalsource'     => "مصدر '''$1''' معروض بالأسفل:",
'blockededitsource'         => "نص '''تعديلاتك''' في '''$1''' معروض بالأسفل:",
'whitelistedittitle'        => 'تسجيل الدخول مطلوب للتحرير',
'whitelistedittext'         => 'يجب عليك $1 لتتمكن من تعديل الصفحات.',
'whitelistreadtitle'        => 'تسجيل الدخول مطلوب للقراءة',
'whitelistreadtext'         => 'يجب عليك [[Special:Userlogin|تسجيل الدخول]] لتقرأ الصفحات.',
'whitelistacctitle'         => 'لا يسمح لك بإنشاء اشتراك',
'whitelistacctext'          => 'حتى يسمح لك بإنشاء حسابات في {{SITENAME}} يجب عليك [[Special:Userlogin|تسجيل الدخول]] وأن تمتلك الصلاحيات المناسبة.',
'confirmedittitle'          => 'تأكيد البريد الإلكتروني مطلوب لبدء التعديل',
'confirmedittext'           => 'يجب عليك تأكيد بريدك الإلكتروني قبل التعديل. من فضلك اكتب وأكد بريدك الإلكتروني من خلال [[Special:Preferences|تفضيلاتك]]',
'nosuchsectiontitle'        => 'لا يوجد قسم كهذا',
'nosuchsectiontext'         => 'لقد حاولت تحرير قسم غير موجود. وحيث أنه لا يوجد القسم $1، فلا يوجد مكان لحفظ تعديلك.',
'loginreqtitle'             => 'تسجيل الدخول مطلوب',
'loginreqlink'              => 'دخول',
'loginreqpagetext'          => 'يجب عليك $1 لتشاهد صفحات أخرى.',
'accmailtitle'              => 'تم إرسال كلمة السر.',
'accmailtext'               => "تم إرسال كلمة السر الخاصة بـ '$1' إلى العنوان $2.",
'newarticle'                => '(جديد)',
'newarticletext'            => "لقد تبعت وصلة لصفحة لم يتم إنشائها بعد.
لإنشاء هذه الصفحة ابدأ الكتابة في الصندوق بالأسفل.
(انظر في [[{{MediaWiki:Helppage}}|صفحة المساعدة]] للمزيد من المعلومات)
إذا كانت زيارتك لهذه الصفحة بالخطأ، اضغط على زر ''رجوع'' في متصفح الإنترنت لديك.",
'anontalkpagetext'          => "----''هذه صفحة نقاش لمستخدم مجهول لم يقم بإنشاء حساب بعد أو لا يستعمل ذلك الحساب. لذا فيجب علينا استعمال رقم الأيبي للتعرف عليه/عليها. مثل هذا العنوان يمكن أن يشترك فيه عدة مستخدمين. لو كنت مستخدما مجهولا وتشعر بأن تعليقات لا تخصك تم توجيهها إليك، من فضلك [[Special:Userlogin|أنشيء حسابا أو سجل الدخول]] لتجنب الارتباك المستقبلي مع مستخدمين مجهولين آخرين.''",
'noarticletext'             => 'لا يوجد حاليا أي نص في هذه الصفحة، يمكنك [[Special:Search/{{PAGENAME}}|البحث عن عنوان هذه الصفحة]] في الصفحات الأخرى أو [{{fullurl:{{FULLPAGENAME}}|action=edit}} تعديل هذه الصفحة].',
'userpage-userdoesnotexist' => 'حساب المستخدم "$1" غير مسجل. من فضلك تأكد أنك تريد إنشاء/تعديل هذه الصفحة.',
'clearyourcache'            => "ملاحظة: قم بإعادة تحميل الصفحة لرؤية التغييرات. إذا لم تظهر التغييرات بعد إعادة التحميل، قد يكون متصفح الإنترنت الذي تستخدمه يقوم بعرض نسخة مخزنة سابقا. لتجنب عرض هذه النسخة، قد يلزم أن تقوم بأحد هذه الخطوات:
* في متصفح '''موزيلا''' أو '''فايرفوكس''' أو '''سفاري''' اضغظ على ''مفتاح Shift'' أثناء قيامك بضغط زر إعادة التحميل (''Refresh'') أو اضغط ''Ctrl-Shift-R'' (''Cmd-Shift-R'' في حاسب أبل).
* في متصفح '''إنترنت إكسبلورر''' اضغط على مفتاح ''Ctrl'' أثناء قيامك بالنقر على زر إعادة التحميل (''Refresh'') أو اضغط ''Ctrl-F5''.
* في متصفح''' كونكيرر''' (Konqueror) انقر على زر إعادة التحميل (''Reload'') أو اضغط على مفتاح '''F5'''.
* في متصفح '''أوبرا''' (Opera) قد يكون من الضروري مسح المحتويات المخزنة عن طريق قائمة التفضيلات (''Tools→Preferences'').",
'usercssjsyoucanpreview'    => "<strong>ملاحظة:</strong> استعمل زر 'عرض مسبق' لتجربة النمط (CSS) أو الجافا سكريبت الجديد قبل حفظ الصفحة.",
'usercsspreview'            => "'''تذكر أنك تقوم بعرض الأنماط المتراصة (CSS) فقط وأنك لم تقم بحفظها بعد!'''",
'userjspreview'             => "'''تذكر أنك فقط تجرب/تعرض الجافا سكريبت الخاص بك، لم يتم الحفظ بعد!'''",
'userinvalidcssjstitle'     => "'''تحذير:''' لا توجد واجهة  \"\$1\". تذكر أن ملفات ال.css و ال.js تستخدم حروف صغيرة في العنوان ، كمثال {{ns:user}}:Foo/monobook.css و ليس {{ns:user}}:Foo/Monobook.css.",
'updated'                   => '(محدثة)',
'note'                      => '<strong>ملاحظة:</strong>',
'previewnote'               => '<strong>تذكر، هذا فقط عرض مسبق للصفحة، ولم يتم حفظه بعد</strong>!',
'previewconflict'           => 'هذا العرض يوضح النص الموجود في صندوق التحرير العلوي والذي سيظهر إذا اخترت الحفظ.',
'session_fail_preview'      => '<strong>عذرا! لم نتمكن من حفظ التعديلات التي قمت بها نتيجة لضياع بيانات هذه الجلسة. الرجاء المحاولة مرة أخرى. في حال استمرار المشكلة حاول أن تقوم بالخروج ومن ثم الدخول مرة أخرى.</strong>',
'session_fail_preview_html' => "<strong>عذرا! لم نستطع معالجة تعديلك بسبب فقدان بيانات الجلسة.</strong>

''لأن {{SITENAME}} بها HTML الخام مفعلة، العرض المسبق مخفي كاحتياط ضد هجمات الجافا سكريبت.''

<strong>إذا كانت هذه محاولة تعديل صادقة، من فضلك حاول مرة أخرى. إذا كانت مازالت لا تعمل، حاول تسجيل الخروج ثم تسجيل الدخول مجددا.</strong>",
'token_suffix_mismatch'     => '<strong>تعديلك تم رفضه لأن عميلك أخطأ في علامات الترقيم 
في نص التعديل. التعديل تم رفضه لمنع فساد نص المقالة. 
هذا يحدث أحيانا عندما تستخدم خدمة بروكسي مجهولة معيبة أساسها الويب.</strong>',
'editing'                   => 'تحرير $1',
'editinguser'               => "تغيير صلاحيات المستخدم للمستخدم '''[[User:$1|$1]]''' ([[User talk:$1|{{int:talkpagelinktext}}]] | [[Special:Contributions/$1|{{int:contribslink}}]])",
'editingsection'            => 'تحرير $1 (قسم)',
'editingcomment'            => 'تحرير $1 (تعليق)',
'editconflict'              => 'تضارب في التحرير: $1',
'explainconflict'           => 'لقد عدل شخص آخر هذه الصفحة بعد أن بدأت أنت بتحريرها.
صندوق النصوص العلوي يحتوي على النص الموجود حاليا في الصفحة.
والتغييرات التي قمت أنت بها موجودة في الصندوق في أسفل الصفحة.
يجب أن تقوم بدمج تغييراتك في النص الموجود حاليا.
<b>فقط</b> ما هو موجود في الصندوق العلوي هو ما سيتم حفظه عند الضغط على زر "حفظ الصفحة".
<br />',
'yourtext'                  => 'نصك',
'storedversion'             => 'النسخة المخزنة',
'nonunicodebrowser'         => '<strong>تحذير: متصفحك لا يتوافق مع الترميز الموحد. تمت معالجة هذا لكي تتمكن من تحرير الصفحات بأمان: الحروف التي ليست ASCII سوف تظهر في صندوق التحرير كأكواد سداسي عشرية.</strong>',
'editingold'                => '<strong> تحذير: أنت تقوم الآن بتحرير نسخة قديمة من هذه الصفحة.
إذا قمت بحفظها، ستفقد كافة التغييرات التي حدثت بعد هذه النسخة. </strong>',
'yourdiff'                  => 'الفروق',
'copyrightwarning'          => 'من فضلك لاحظ أن جميع المساهمات ل {{SITENAME}} خاضعة وصادرة تحت ترخيص $2 (انظر في $1 للمزيد من التفاصيل)
إذا لم ترد أن تخضع كتابتك للتعديل والتوزيع الحر، لا تضعها هنا<br />. كما أنك تتعهد بأنك قمت بكتابة ما هو موجود بنفسك، أو قمت بنسخها من مصدر يخضع ضمن الملكية العامة، أو مصدر حر آخر. <strong>لا ترسل أي عمل ذي حقوق محفوظة بدون الإذن من صاحب الحق</strong>.',
'copyrightwarning2'         => 'من فضلك لاحظ أن حميع المشاركات في {{SITENAME}} يمكن أن تعدل أو تتغير أو تحذف من قبل المشاركين الآخرين. إذا لم تكن ترغب أن تعدل مشاركاتك بهذا الشكل، لا تضعها هنا.<br />
انت أيضا تقر أنك كتبت هذا بنفسك، أو نسختها من مصدر لا يخضع لحقوق النشر أو يسمح بالنقل بشكلا ما (انظر $1 للتفاصيل).
<strong>لا تضف أي نص ذي حقوق محفوظة!</strong>',
'longpagewarning'           => '<strong>تحذير: هذه الصفحة حجمها $1 كيلوبايت، بعض المتصفحات قد تواجه مشاكل عند محاولة تحرير صفحات يزيد حجمها عن 32 كيلوبايت. يرجى تقسيم الصفحة إلى أقسام أصغر حجما  إن أمكن.</strong>',
'longpageerror'             => '<strong>خطأ: النص الذي أدخلته حجمه $1 كيلوبايت 
، وهذا أكبر من الحد الأقصى وهو $2 كيلوبايت. لا يمكن حفظه.</strong>',
'readonlywarning'           => '<strong>تحذير: لقد أغلقت قاعدة البيانات للصيانة، لذلك لن تتمكن من حفظ التعديلات التي قمت بها حاليا. إذا رغبت بإمكانك أن تنسخ النص الذي تعمل عليه وتحفظه في ملف نصي إلى وقت لاحق.</strong>',
'protectedpagewarning'      => '<strong>تحذير: تمت حماية هذه الصفحة حتى يمكن للمستخدمين ذوي الصلاحيات الإدارية فقط تعديلها.</strong>',
'semiprotectedpagewarning'  => "'''ملاحظة:''' تمت حماية هذه الصفحة بحيث يمكن للمستخدمين المسجلين فقط تعديلها.",
'cascadeprotectedwarning'   => '<strong>تحذير: تمت حماية هذه الصفحة بحيث يستطيع المستخدمون ذوو الصلاحيات الإدارية فقط تعديلها، وذلك لكونها مدمجة في {{PLURAL:$1|الصفحة|الصفحات}} التالية والتي تمت حمايتها بخاصية "حماية الصفحات المدمجة":</strong>',
'titleprotectedwarning'     => '<strong>تحذير:  تمت حماية هذه الصفحة حتى يستطيع بعض المستخدمين فقط إنشاءها.</strong>',
'templatesused'             => 'القوالب المستخدمة في هذه الصفحة:',
'templatesusedpreview'      => 'القوالب المستخدمة في هذا العرض المسبق:',
'templatesusedsection'      => 'القوالب المستخدمة في هذا القسم:',
'template-protected'        => '(حماية كاملة)',
'template-semiprotected'    => '(حماية جزئية)',
'edittools'                 => '<!-- النص هنا سيظهر تحت صندوق التحرير واستمارة رفع الصور. -->',
'nocreatetitle'             => 'تم تحديد إنشاء الصفحات',
'nocreatetext'              => 'قام {{SITENAME}} بتحديد القدرة على إنشاء صفحات جديدة.
يمكنك العودة وتحرير صفحة موجودة بالفعل، أو [[Special:Userlogin|الدخول أو تسجيل حساب]].',
'nocreate-loggedin'         => 'لا تمتلك الصلاحية لإنشاء صفحات جديدة في {{SITENAME}}.',
'permissionserrors'         => 'أخطاء السماحات',
'permissionserrorstext'     => 'لا تمتلك الصلاحية لفعل هذا، {{PLURAL:$1|للسبب التالي|للأسباب التالية}}:',
'recreate-deleted-warn'     => "'''تحذير: أنت تقوم بإعادة إنشاء صفحة سبق حذفها.'''

يجب عليك التيقن من أن الاستمرار بتحرير هذه الصفحة ملائم.
سجل الحذف لهذه الصفحة معروض هنا:",

# "Undo" feature
'undo-success' => 'يمكن استرجاع التعديل. من فضلك تحقق من المقارنة بالأسفل للتأكد من أن هذا هو ما تريد أن تفعله، وبعد ذلك احفظ التغييرات بالأسفل للانتهاء من استرجاع التعديل.',
'undo-failure' => 'لم يمكن استرجاع التعديل بسبب تعديلات متعارضة تمت على الصفحة.',
'undo-summary' => 'الرجوع عن التعديل $1 بواسطة [[Special:Contributions/$2|$2]] ([[User talk:$2|نقاش]])',

# Account creation failure
'cantcreateaccounttitle' => 'لا يمكن إنشاء حساب',
'cantcreateaccount-text' => "إنشاء الحسابات من عنوان الأيبي هذا (<b>$1</b>) تم منعه بواسطة [[User:$3|$3]].

السبب المعطى بواسطة $3 هو ''$2''",

# History pages
'viewpagelogs'        => 'عرض السجلات لهذه الصفحة',
'nohistory'           => 'لا يوجد تاريخ للتعديلات لهذه الصفحة.',
'revnotfound'         => 'النسخة غير موجودة',
'revnotfoundtext'     => 'لم يتم العثور على النسخة القديمة من الصفحة التي طلبتها. من فضلك تأكد من المسار الذي دخلت به إلى هذه الصفحة.',
'loadhist'            => 'تحميل تاريخ الصفحة',
'currentrev'          => 'المراجعة الحالية',
'revisionasof'        => 'مراجعة $1',
'revision-info'       => 'مراجعة $1 بواسطة $2',
'previousrevision'    => '←مراجعة أقدم',
'nextrevision'        => 'مراجعة أحدث→',
'currentrevisionlink' => 'المراجعة الحالية',
'cur'                 => 'الحالي',
'next'                => 'التالي',
'last'                => 'السابق',
'orig'                => 'الأصلي',
'page_first'          => 'الأولى',
'page_last'           => 'الأخيرة',
'histlegend'          => 'اختيار الفرق: علم على صناديق النسخ للمقارنة و اضغط قارن بين النسخ المختارة أو الزر بالأسفل.<br />
مفتاح: (الحالي) = الفرق مع النسخة الحالية
(السابق) = الفرق مع النسخة السابقة، ط = تغيير طفيف',
'deletedrev'          => '[محذوفة]',
'histfirst'           => 'أول',
'histlast'            => 'آخر',
'historysize'         => '({{PLURAL:$1|1 بايت|$1 بايت}})',
'historyempty'        => '(فارغ)',

# Revision feed
'history-feed-title'          => 'تاريخ التعديل',
'history-feed-description'    => 'تاريخ التعديل لهذه الصفحة في الويكي',
'history-feed-item-nocomment' => '$1 في $2', # user at time
'history-feed-empty'          => 'الصفحة المطلوبة غير موجودة. من المحتمل أن تكون هذه الصفحة قد حذفت أو نقلت. حاول [[Special:Search|البحث في الويكي]] عن صفحات جديدة ذات صلة.',

# Revision deletion
'rev-deleted-comment'         => '(تم مسح تعليق)',
'rev-deleted-user'            => '(اسم المستخدم أزيل)',
'rev-deleted-event'           => '(المدخلة أزيلت)',
'rev-deleted-text-permission' => '<div class="mw-warning plainlinks">
مراجعة الصفحة هذه أزيلت من الأرشيفات العامة.
ربما تكون هناك تفاصيل في [{{fullurl:Special:Log/delete|page={{FULLPAGENAMEE}}}} سجل الحذف].
</div>',
'rev-deleted-text-view'       => '<div class="mw-warning plainlinks">
تم مسح هذا التعديل من الأرشيف العام.
بإمكانك رؤية هذا التعديل لكونك إداريا على هذا الموقع.
من الممكن أن يكون هناك تفاصيل حول هذا في [{{fullurl:Special:Log/delete|page={{FULLPAGENAMEE}}}} سجل الحذف].
</div>',
'rev-delundel'                => 'عرض/إخفاء',
'revisiondelete'              => 'احذف/استرجع المراجعات',
'revdelete-nooldid-title'     => 'لا توجد نسخة مختارة',
'revdelete-nooldid-text'      => 'لم تقم بتحديد نسخة أو نسخ معينة لعمل هذه الوظيفة عليها.',
'revdelete-selected'          => "{{PLURAL:$2|النسخة المختارة|النسختان المختارتان|النسخ المختارة}} من '''$1:'''",
'logdelete-selected'          => "{{PLURAL:$2|الحدث المختار|الحدثان المختاران|الأحداث المختارة}} من السجل لـ '''$1:'''",
'revdelete-text'              => 'النسخ والأحداث المحذوفة ستظل تظهر في تاريخ الصفحة والسجلات،
لكن أجزاء من محتواهم لن يكون مسموحا للعامة برؤيتها.

الإداريون الآخرون في {{SITENAME}}سيظل بإمكانهم رؤية المحتوى المخفي ويمكنهم استرجاعه مجددا من خلال هذه الواجهة نفسها، مالم يتم وضع قيود إضافية.',
'revdelete-legend'            => 'وضع ضوابط:',
'revdelete-hide-text'         => 'إخفاء نص النسخة',
'revdelete-hide-name'         => 'إخفاء الإجراء والهدف منه',
'revdelete-hide-comment'      => 'إخفاء تعليق التعديل',
'revdelete-hide-user'         => 'إخفاء اسم/عنوان المستخدم',
'revdelete-hide-restricted'   => 'تطبيق هذه الضوابط على الإداريين بجانب الآخرين',
'revdelete-suppress'          => 'إخفاء البيانات عن الإداريين بجانب الآخرين',
'revdelete-hide-image'        => 'إخفاء محتوى الملف',
'revdelete-unsuppress'        => 'إزالة الضوابط من النسخ المسترجعة',
'revdelete-log'               => 'تعليق السجل:',
'revdelete-submit'            => 'طبق على النسخة المختارة',
'revdelete-logentry'          => 'تغيير مرئية تعديلات في [[$1]]',
'logdelete-logentry'          => 'تغيير مرئية أحداث في [[$1]]',
'revdelete-logaction'         => 'تم ضبط {{PLURAL:$1|تعديل|تعديلان|$1 تعديلات|$1 تعديل|$1 تعديلا}} للوضع $2',
'logdelete-logaction'         => 'تم ضبط {{PLURAL:$1|حدث|حدثين|$1 أحداث|$1 حدث|$1 حدثا}} بخصوص [[$3]] للوضع $2',
'revdelete-success'           => 'تم ضبط مرئية التعديلات بنجاح.',
'logdelete-success'           => 'تم ضبط مرئية الأحداث بنجاح.',

# Oversight log
'oversightlog'    => 'سجل الأوفرسايت',
'overlogpagetext' => 'بالأسفل قائمة بأحدث عمليات الحذف والمنع المتضمنة محتويات تم إخفائها عن الإداريين. انظر [[Special:Ipblocklist|قائمة منع عناوين الأيبي]] لترى حالات المنع والطرد الحالية.',

# History merging
'mergehistory'                     => 'دمج تواريخ الصفحة',
'mergehistory-header'              => "هذه الصفحة تسمح لك بدمج نسخ تاريخ صفحة ما إلى صفحة أخرى.
تأكد من أن هذا التغيير سيحافظ على استمرار تاريخ الصفحة.

'''على الأقل النسخة الحالية من الصفحة المصدر يجب أن تبقى.'''",
'mergehistory-box'                 => 'دمج نسخ الصفحتين:',
'mergehistory-from'                => 'الصفحة المصدر:',
'mergehistory-into'                => 'الصفحة الهدف:',
'mergehistory-list'                => 'تاريخ التعديل القابل للدمج',
'mergehistory-merge'               => 'النسخ التالية من [[:$1|$1]] يمكن دمجها إلى [[:$2|$2]]. استخدم عامود الصناديق لدمج النسخ التي تم إنشاؤها في وقبل الوقت المحدد. لاحظ أن استخدام 
وصلات التصفح سيعيد ضبط هذا العامود.',
'mergehistory-go'                  => 'عرض التعديلات القابلة للدمج',
'mergehistory-submit'              => 'دمج النسخ',
'mergehistory-empty'               => 'لا توجد نسخ يمكن دمجها',
'mergehistory-success'             => '$3 نسخة من [[:$1|$1]] تم دمجها بنجاح إلى [[:$2|$2]].',
'mergehistory-fail'                => 'غير قادر على عمل دمج التاريخ، من فضلك أعد التحقق من محددات الصفحة والزمن.',
'mergehistory-no-source'           => 'الصفحة المصدر $1 غير موجودة.',
'mergehistory-no-destination'      => 'الصفحة الهدف $1 غير موجودة.',
'mergehistory-invalid-source'      => 'الصفحة المصدر يجب أن تكون عنوانا صحيحا.',
'mergehistory-invalid-destination' => 'الصفحة الهدف يجب أن تكون عنوانا صحيحا.',

# Merge log
'mergelog'           => 'سجل الدمج',
'pagemerge-logentry' => 'دمج [[$1]] إلى [[$2]] (النسخ حتى $3)',
'revertmerge'        => 'استرجاع الدمج',
'mergelogpagetext'   => 'بالأسفل قائمة بأحدث عمليات الدمج لتاريخ صفحة ما إلى أخرى.',

# Diffs
'history-title'           => 'تاريخ مراجعة "$1"',
'difference'              => '(الفرق بين المراجعات)',
'lineno'                  => 'سطر $1:',
'compareselectedversions' => 'قارن بين النسختين المختارتين',
'editundo'                => 'رجوع',
'diff-multi'              => '({{PLURAL:$1|نسخة واحدة متوسطة|$1 نسخة متوسطة}} غير معروضة.)',

# Search results
'searchresults'         => 'نتائج البحث',
'searchresulttext'      => 'للمزيد من المعلومات حول البحث في {{SITENAME}}، انظر [[{{MediaWiki:Helppage}}|{{int:help}}]].',
'searchsubtitle'        => "لصيغة البحث '''[[:$1]]'''",
'searchsubtitleinvalid' => "لصيغة البحث '''$1'''",
'noexactmatch'          => "'''لا توجد صفحة بالاسم \"\$1\"'''. يمكنك [[:\$1|إنشاء هذه الصفحة]].",
'noexactmatch-nocreate' => "'''لا توجد صفحة بالاسم \"\$1\".'''",
'toomanymatches'        => 'وجدت مطابقات كثيرة، جرب استعلام مختلف من فضلك',
'titlematches'          => 'عنوان الصفحة يطابق',
'notitlematches'        => 'لم يتم إيجاد أي عنوان مطابق',
'textmatches'           => 'نص الصفحة يطابق',
'notextmatches'         => 'لم يتم إيجاد أي نص مطابق',
'prevn'                 => '$1 السابقة',
'nextn'                 => '$1 التالية',
'viewprevnext'          => 'عرض ($1) ($2) ($3).',
'showingresults'        => "القائمة التالية تعرض {{PLURAL:$1|'''1''' نتيجة|'''$1''' نتيجة}} بدءا من رقم '''$2'''.",
'showingresultsnum'     => "معروض بالأسفل {{PLURAL:$3|'''نتيجة واحدة'''|'''$3''' نتيجة}} بدءا من رقم'''$2'''.",
'nonefound'             => "'''ملاحظة:''' عمليات البحث غير الناجحة تكون عادة نتيجة للبحث عن كلمات شائعة مثل \"من\" و \"يمتلك\" والتي لا يتم فهرستها، وقد تنتج أيضا من استعمال أكثر من كلمة في البحث (فقط الصفحات التي تحتوي على جميع هذه الكلمات سوف تظهر في نتيجة البحث).",
'powersearch'           => 'بحث',
'powersearchtext'       => 'ابحث في النطاقات:<br />$1<br />$2 عرض التحويلات<br />ابحث عن $3 $9',
'searchdisabled'        => 'البحث في {{SITENAME}} معطل. يمكنك البحث من خلال جوجل في الوقت الحالي. لاحظ أن فهارسه لمحتوى {{SITENAME}} ربما تكون غير محدثة.',

# Preferences page
'preferences'              => 'تفضيلات',
'mypreferences'            => 'تفضيلاتي',
'prefs-edits'              => 'عدد التعديلات:',
'prefsnologin'             => 'غير مسجل',
'prefsnologintext'         => 'يجب أن تكون [[Special:Userlogin|مسجلا]] حتى تتمكن من تعديل تفضيلات المستخدم.',
'prefsreset'               => 'أعيدت التفضيلات إلى الإعداد الافتراضي المخزن.',
'qbsettings'               => 'لوح سريع',
'qbsettings-none'          => 'بلا تحديد',
'qbsettings-fixedleft'     => 'مثبت لليسار',
'qbsettings-fixedright'    => 'مثبت لليمين',
'qbsettings-floatingleft'  => 'حر لليسار',
'qbsettings-floatingright' => 'حر لليمين',
'changepassword'           => 'غير كلمة السر',
'skin'                     => 'واجهة',
'math'                     => 'رياضيات',
'dateformat'               => 'صيغة التاريخ',
'datedefault'              => 'لا تفضيل',
'datetime'                 => 'وقت وتاريخ',
'math_failure'             => 'خطأ رياضيات',
'math_unknown_error'       => 'خطأ غير معروف',
'math_unknown_function'    => 'وظيفة غير معروفة',
'math_lexing_error'        => 'خطأ في الصيغة',
'math_syntax_error'        => 'خطأ بالصيغة',
'math_image_error'         => 'فشل التحويل لPNG ، تحقق من تثبيت كل من Latex و dvips و gs و convert.',
'math_bad_tmpdir'          => 'لا يمكن الكتابة إلى أو إنشاء مجلد الرياضيات المؤقت',
'math_bad_output'          => 'لا يمكن الكتابة إلى أو إنشاء مجلد الخروج للرياضيات',
'math_notexvc'             => 'مفقود texvc executable؛ من فضلك انظر math/README to configure.',
'prefs-personal'           => 'ملف المستخدم',
'prefs-rc'                 => 'أحدث التغييرات',
'prefs-watchlist'          => 'قائمة المراقبة',
'prefs-watchlist-days'     => 'عدد الأيام للعرض في قائمة المراقبة:',
'prefs-watchlist-edits'    => 'عدد التعديلات التي تعرض في قائمة المراقبة الموسعة:',
'prefs-misc'               => 'متفرقات',
'saveprefs'                => 'حفظ',
'resetprefs'               => 'أعد الضبط',
'oldpassword'              => 'كلمة السر القديمة:',
'newpassword'              => 'كلمة السر الجديدة:',
'retypenew'                => 'أعد كتابة كلمة السر الجديدة:',
'textboxsize'              => 'أبعاد صندوق النصوص',
'rows'                     => 'صفوف:',
'columns'                  => 'أعمدة:',
'searchresultshead'        => 'بحث',
'resultsperpage'           => 'عدد النتائج في الصفحة:',
'contextlines'             => 'عدد الأسطر في كل نتيجة:',
'contextchars'             => 'عدد الأحرف في كل سطر',
'stub-threshold'           => 'الحد لتنسيق <a href="#" class="stub">وصلة البذرة</a>:',
'recentchangesdays'        => 'عدد الأيام المعروضة في أحدث التغييرات:',
'recentchangescount'       => 'عدد التعديلات المعروضة في أحدث التغييرات:',
'savedprefs'               => 'تم حفظ تفضيلاتك.',
'timezonelegend'           => 'المنطقة الزمنية',
'timezonetext'             => 'عدد الساعات بين توقيتك المحلي وتوقيت الخادم (UTC).',
'localtime'                => 'الوقت المحلي',
'timezoneoffset'           => 'الفرق¹',
'servertime'               => 'وقت الخادم',
'guesstimezone'            => 'أدخل التوقيت من المتصفح',
'allowemail'               => 'السماح بتلقي البريد الإلكتروني من المستخدمين الآخرين',
'defaultns'                => 'ابحث في هذه النطاقات افتراضيا:',
'default'                  => 'افتراضي',
'files'                    => 'ملفات',

# User rights
'userrights-lookup-user'           => 'إدارة مجموعات المستخدم',
'userrights-user-editname'         => 'أدخل اسم مستخدم:',
'editusergroup'                    => 'تعديل مجموعات المستخدم',
'userrights-editusergroup'         => 'تعديل مجموعات المستخدم',
'saveusergroups'                   => 'حفظ مجموعات المستخدم',
'userrights-groupsmember'          => 'عضو في:',
'userrights-groupsremovable'       => 'المجموعات للإزالة:',
'userrights-groupsavailable'       => 'المجموعات المتوفرة:',
'userrights-groupshelp'            => 'قم باختيار المجموعات التي تريد المستخدم أن يضاف إليها أو تتم إزالته منها.
المجموعات غير المختارة ستترك كما هي. يمكنك إزالة مجموعة بالضغط على كنترل + ضغطة فأرة يسرى.',
'userrights-reason'                => 'سبب التغيير:',
'userrights-available-none'        => 'لا يمكنك تعديل مجموعات المستخدم.',
'userrights-available-add'         => 'يمكنك إضافة المستخدمين إلى {{PLURAL:$2|هذه المجموعة|هذه المجموعات}}: $1.',
'userrights-available-remove'      => 'يمكنك إزالة المستخدمين من {{PLURAL:$2|هذه المجموعة|هذه المجموعات}}: $1.',
'userrights-available-add-self'    => 'يمكنك إضافة نفسك إلى {{PLURAL:$2|هذه المجموعة|هذه المجموعات}}: $1.',
'userrights-available-remove-self' => 'يمكنك إزالة نفسك من {{PLURAL:$2|هذه المجموعة|هذه المجموعات}}: $1.',
'userrights-no-interwiki'          => 'أنت لا تمتلك الصلاحية لتعديل صلاحيات المستخدمين على الويكيات الأخرى.',
'userrights-nodatabase'            => 'قاعدة البيانات $1 غير موجودة أو ليست محلية.',
'userrights-nologin'               => 'يجب عليك [[Special:Userlogin|تسجيل الدخول]] بحساب إداري لتعديل صلاحيات المستخدم.',
'userrights-notallowed'            => 'حسابك لا يمتلك السماح لتعديل صلاحيات المستخدم.',

# Groups
'group'               => 'المجموعة:',
'group-autoconfirmed' => 'مستخدمون مؤكدون تلقائيا',
'group-bot'           => 'بوتات',
'group-sysop'         => 'إداريين',
'group-bureaucrat'    => 'بيروقراطيون',
'group-all'           => '(الكل)',

'group-autoconfirmed-member' => 'مستخدم مؤكد تلقائيا',
'group-bot-member'           => 'بوت',
'group-sysop-member'         => 'مدير نظام',
'group-bureaucrat-member'    => 'بيروقراط',

'grouppage-autoconfirmed' => '{{ns:project}}:مستخدمون مؤكدون تلقائيا',
'grouppage-bot'           => '{{ns:project}}:بوتات',
'grouppage-sysop'         => '{{ns:project}}:إداريون',
'grouppage-bureaucrat'    => '{{ns:project}}:بيروقراطيون',

# User rights log
'rightslog'      => 'سجل صلاحيات المستخدمين',
'rightslogtext'  => 'هذا سجل بالتغييرات في صلاحيات المستخدمين.',
'rightslogentry' => 'غير صلاحيات $1 من $2 إلى $3',
'rightsnone'     => '(لا شيء)',

# Recent changes
'nchanges'                          => '{{PLURAL:$1|تغيير|تغييران|$1 تغييرات|$1 تغيير|$1 تغييرا}}',
'recentchanges'                     => 'أحدث التغييرات',
'recentchangestext'                 => 'تابع آخر التغييرات في الويكي من هذه الصفحة.',
'recentchanges-feed-description'    => 'تابع أحدث التغييرات لهذه الويكي عبر هذه التلقيمة.',
'rcnote'                            => "بالأسفل {{PLURAL:$1|'''1''' تغيير|آخر '''$1''' تغيير}} في آخر {{PLURAL:$2|يوم|'''$2''' يوم}}، بدءا من $3.",
'rcnotefrom'                        => 'في الأسفل التغييرات منذ <b>$2</b> (ولغاية <b>$1</b>).',
'rclistfrom'                        => 'أظهر التغييرات بدءا من $1',
'rcshowhideminor'                   => '$1 التعديلات الطفيفة',
'rcshowhidebots'                    => '$1 البوتات',
'rcshowhideliu'                     => '$1 المستخدمين المسجلين',
'rcshowhideanons'                   => '$1 المستخدمين المجهولين',
'rcshowhidepatr'                    => '$1 التعديلات المراجعة',
'rcshowhidemine'                    => '$1 تعديلاتي',
'rclinks'                           => 'أظهر آخر $1 تعديل في آخر $2 يوم، $3',
'diff'                              => 'فرق',
'hist'                              => 'تاريخ',
'hide'                              => 'إخفاء',
'show'                              => 'عرض',
'minoreditletter'                   => 'ط',
'newpageletter'                     => 'ج',
'boteditletter'                     => 'ب',
'sectionlink'                       => '←',
'number_of_watching_users_pageview' => '[$1 {{PLURAL:$1|مستخدم مراقب|مستخدم مراقب}}]',
'rc_categories'                     => 'حصر لتصنيفات (مفرقة برمز "|")',
'rc_categories_any'                 => 'أي',
'newsectionsummary'                 => '/* $1 */ قسم جديد',

# Recent changes linked
'recentchangeslinked'          => 'تغييرات ذات علاقة',
'recentchangeslinked-title'    => 'التغييرات المرتبطة ب$1',
'recentchangeslinked-noresult' => 'لم تحدث تعديلات في الصفحات التي لها وصلات هنا خلال الفترة المحددة.',
'recentchangeslinked-summary'  => "هذه الصفحة الخاصة تعرض آخر التغييرات في الصفحات الموصولة. الصفحات في قائمة مراقبتك معروضة '''بخط عريض'''.",

# Upload
'upload'                      => 'رفع ملف',
'uploadbtn'                   => 'رفع الملف',
'reupload'                    => 'أعد الرفع',
'reuploaddesc'                => 'الرجوع لصفحة الرفع.',
'uploadnologin'               => 'لم تقم بتسجيل الدخول',
'uploadnologintext'           => 'يجب أن تكون [[Special:Userlogin|مسجلا الدخول]] لتتمكن من رفع الملفات.',
'upload_directory_read_only'  => 'لا يمكن الكتابة على مجلد الرفع ($1) بواسطة خادم الشبكة.',
'uploaderror'                 => 'خطأ في الرفع',
'uploadtext'                  => "استخدم الاستمارة بالأسفل لرفع الملفات.
لعرض أو البحث في الملفات المرفوعة سابقا، راجع [[Special:Imagelist|قائمة الملفات المرفوعة]]، عمليات الرفع والحذف موجودة في [[Special:Log/upload|سجل الرفع]].

لإدراج صورة في صفحة، استخدم الوصلات في الصيغ التالية:
*'''<nowiki>[[{{ns:image}}:File.jpg]]</nowiki>'''،
*'''<nowiki>[[{{ns:image}}:File.png|نص بديل]]</nowiki>''' أو
*'''<nowiki>[[{{ns:media}}:File.ogg]]</nowiki>''' للوصل للملف مباشرة.",
'upload-permitted'            => 'أنواع الملفات المسموحة: $1.',
'upload-preferred'            => 'أنواع الملفات المفضلة: $1.',
'upload-prohibited'           => 'أنواع الملفات الممنوعة: $1.',
'uploadlog'                   => 'سجل الرفع',
'uploadlogpage'               => 'سجل الرفع',
'uploadlogpagetext'           => 'في الأسفل قائمة بأحدث عمليات رفع الملفات.',
'filename'                    => 'اسم الملف',
'filedesc'                    => 'ملخص',
'fileuploadsummary'           => 'ملخص:',
'filestatus'                  => 'حالة الترخيص',
'filesource'                  => 'مصدر',
'uploadedfiles'               => 'الملفات المرفوعة',
'ignorewarning'               => 'تجاهل هذا التحذير واحفظ الملف على أية حال.',
'ignorewarnings'              => 'أهمل أية تحذيرات',
'minlength1'                  => 'أسماء الملفات يجب أن تتكون من حرف واحد على الأقل.',
'illegalfilename'             => 'يحتوي اسم الملف $1 على رموز غير مقبولة. أعد تسمية الملف من فضلك و قم برفعه مرة أخرى.',
'badfilename'                 => 'تم تغيير اسم الملف إلى "$1".',
'filetype-badmime'            => 'من غير المسموح به رفع ملفات من النوع "$1".',
'filetype-unwanted-type'      => "'''\".\$1\"''' نوع ملف غير مرغوب فيه.  أنواع الملفات المفضلة هي \$2.",
'filetype-banned-type'        => "'''\".\$1\"''' ليس نوع ملف مسموحا به.  أنواع الملفات المسموح بها هي \$2.",
'filetype-missing'            => 'الملف بدون امتداد (مثل ".jpg").',
'large-file'                  => 'ينصح ألا تكون الملفات أكبر من $1؛ هذا الملف حجمه $2.',
'largefileserver'             => 'حجم هذا الملف أكبر من المسموح به على هذا الخادم.',
'emptyfile'                   => 'يبدو أن الملف الذي رفعته فارغ. قد يكون سبب ذلك خطأ في كتابة الاسم. من فضلك تأكد من أنك تريد فعلا رفع هذا الملف.',
'fileexists'                  => 'هناك ملف موجود يحمل نفس هذا الاسم الرجاء التأكد من هذا الملف باتباع الوصلة التالية <strong><tt>$1</tt></strong> قبل القيام بتغييره.',
'filepageexists'              => 'صفحة (ليست ملفا) بهذا الاسم موجودة بالفعل، من فضلك تحقق من <strong><tt>$1</tt></strong> لو كنت غير متأكد من أنك تريد تغييرها.',
'fileexists-extension'        => 'يوجد ملف باسم مشابه:<br />
اسم الملف المراد رفعه: <strong><tt>$1</tt></strong><br />
اسم الملف الموجود بالفعل: <strong><tt>$2</tt></strong><br />
الاختلاف الوحيد بينهما هو حالة أحرف الامتداد من حيث الكبر أو الصغر. افحص الملفين من أجل التحقق من عدم تطابقهما من فضلك.',
'fileexists-thumb'            => "<center>'''الصورة الموجودة'''</center>",
'fileexists-thumbnail-yes'    => 'يبدو أن الملف مصغرا لحجم أعلى <i>(تصغير)</i>. افحص الملف <strong><tt>$1</tt></strong> من فضلك.<br />
إن كان هو نفس الملف بالحجم الأصلي فلا داعي لرفع تصغير إضافي.',
'file-thumbnail-no'           => 'يبدأ الملف بـ <strong><tt>$1</tt></strong>. يبدو أن الملف مصغرا لحجم أعلى <i>(تصغير)</i>.
إذا كانت لديك الصورة في درجة دقة كاملة قم برفعها، أو قم بتغيير اسم الملف من فضلك.',
'fileexists-forbidden'        => 'هناك ملف بنفس الاسم حاليا؛ من فضلك تراجع وأعطه اسما جديدا. [[صورة:$1|تصغير|وسط|$1]]',
'fileexists-shared-forbidden' => 'يوجد ملف بنفس الاسم في مستودع الملفات المشترك، من فضلك ارجع و ارفع هذا الملف تحت اسم جديد. [[صورة:$1|تصغير|وسط|$1]]',
'successfulupload'            => 'تم رفع الملف بنجاح',
'uploadwarning'               => 'تحذير رفع الملفات',
'savefile'                    => 'حفظ الملف',
'uploadedimage'               => 'رفع "[[$1]]"',
'overwroteimage'              => 'رفع نسخة جديدة من "[[$1]]"',
'uploaddisabled'              => 'تم إيقاف خاصية رفع الملفات.',
'uploaddisabledtext'          => 'رفع الملفات معطل في {{SITENAME}}.',
'uploadscripted'              => 'هذا الملف  يضم كود HTML أو كود آخر يمكن أن يؤول بطريقة خاطئة بواسطة متصفح ويب.',
'uploadcorrupt'               => 'هذا الملف فاسد أو له امتداد خاطيء. من فضلك تأكد من الملف وأعد الرفع مرة أخرى.',
'uploadvirus'                 => 'الملف يحتوي على فيروس! التفاصيل: $1',
'sourcefilename'              => 'اسم الملف المصدر',
'destfilename'                => 'تخرين الملف باسم',
'watchthisupload'             => 'راقب هذه الصفحة',
'filewasdeleted'              => 'تم رفع ثم حذف ملف بهذا الاسم من قبل. من الأفضل مراجعة $1 قبل رفعه مرة أخرى.',
'upload-wasdeleted'           => "'''تحذير: أنت تقوم برفع ملف تم حذفه في السابق.'''

يجب عليك التيقن من أن الاستمرار برفع هذا الملف ملائم.
سجل الحذف لهذا الملف معروض هنا:",
'filename-bad-prefix'         => 'اسم الملف الذي ترفعه يبدأ ب<strong>"$1"</strong>، وهو اسم غير وصفي عادة يوضع تلقائيا من الكاميرات الرقمية. من فضلك اختر اسما أكثر وصفا لملفك.',
'filename-prefix-blacklist'   => ' #<!-- leave this line exactly as it is --> <pre>
# الصيغة كالتالي: 
#   * كل شيء من علامة "#" إلى آخر السطر هو تعليق
#   * كل سطر غير فارغ هو بادئة لأسماء الملفات النمطية التي توضع تلقائيا من قبل الكاميرات الرقمية
CIMG # Casio
DSC_ # Nikon
DSCF # Fuji
DSCN # Nikon
DUW # some mobil phones
IMG # generic
JD # Jenoptik
MGP # Pentax
PICT # misc.
 #</pre> <!-- leave this line exactly as it is -->',

'upload-proto-error'      => 'بروتوكول غير صحيح',
'upload-proto-error-text' => 'الرفع عن بعد يتطلب مسارا يبدأ بـ <code>http://</code> أو <code>ftp://</code>.',
'upload-file-error'       => 'خطأ داخلي',
'upload-file-error-text'  => 'حدث خطأ داخلي عند محاولة عمل ملف مؤقت على الخادم. من فضلك اتصل بإداري نظام.',
'upload-misc-error'       => 'خطأ غير معروف في الرفع',
'upload-misc-error-text'  => 'حدث خطأ غير معروف أثناء عملية الرفع. من فضلك تاكد أن المسار صحيح ومن الممكن الدخول عليه ثم حاول مرة أخرى. إذا استمرت المشكلة في الحدوث، اتصل بإداري نظام.',

# Some likely curl errors. More could be added from <http://curl.haxx.se/libcurl/c/libcurl-errors.html>
'upload-curl-error6'       => 'لم يتمكن من الوصول للمسار',
'upload-curl-error6-text'  => 'لم يمكن الوصول إلى المسار الذي حددته. من فضلك راجع صحة المسار مرة أخرى وأن الموقع يعمل.',
'upload-curl-error28'      => 'انتهاء مهلة الرفع',
'upload-curl-error28-text' => 'أخذ الموقع وقتا طويلا للاستجابة. من فضلك تأكد أن الموقع يعمل، وانتظر فترة قصيرة ثم حاول مرة أخرى. ربما تريد المحاولة في وقت أقل ازدحاما.',

'license'            => 'ترخيص',
'nolicense'          => 'غير محدد',
'license-nopreview'  => '(العرض المسبق غير متوفر)',
'upload_source_url'  => '(عنوان ويب صحيح، يمكن الوصول إليه)',
'upload_source_file' => ' (ملف على حاسوبك)',

# Image list
'imagelist'                 => 'قائمة الملفات',
'imagelisttext'             => 'فيما يلي قائمة تحوي $1 {{PLURAL:$1|ملف|ملفات}} مرتبة $2.',
'getimagelist'              => 'جاري إحضار قائمة الملفات',
'ilsubmit'                  => 'بحث',
'showlast'                  => 'عرض آخر $1 ملف بترتيب $2.',
'byname'                    => 'حسب الاسم',
'bydate'                    => 'حسب التاريخ',
'bysize'                    => 'حسب الحجم',
'imgdelete'                 => 'حذف',
'imgdesc'                   => 'وصف',
'imgfile'                   => 'ملف',
'filehist'                  => 'تاريخ الملف',
'filehist-help'             => 'اضغط على وقت/زمن لرؤية الملف كما بدا في هذا الزمن.',
'filehist-deleteall'        => 'احذف الكل',
'filehist-deleteone'        => 'احذف هذا',
'filehist-revert'           => 'استرجع',
'filehist-current'          => 'حالي',
'filehist-datetime'         => 'وقت/زمن',
'filehist-user'             => 'مستخدم',
'filehist-dimensions'       => 'أبعاد',
'filehist-filesize'         => 'حجم الملف',
'filehist-comment'          => 'تعليق',
'imagelinks'                => 'وصلات',
'linkstoimage'              => 'الصفحات التالية تحتوي على وصلة لهذا الملف:',
'nolinkstoimage'            => 'لا توجد صفحات تصل لهذا الملف.',
'sharedupload'              => 'هذا الملف تم رفعه للتشارك بين المشاريع ويمكن استخدامه في المشاريع الأخرى.',
'shareduploadwiki'          => 'من فضلك انظر $1 لمزيد من المعلومات.',
'shareduploadwiki-desc'     => 'الوصف على $1 هناك معروض بالأسفل.',
'shareduploadwiki-linktext' => 'صفحة وصف الملف',
'noimage'                   => 'لا يوجد ملف بهذا الاسم، بإمكانك أن تقوم بـ$1.',
'noimage-linktext'          => 'رفعه',
'uploadnewversion-linktext' => 'ارفع نسخة جديدة من هذا الملف',
'imagelist_date'            => 'تاريخ',
'imagelist_name'            => 'اسم',
'imagelist_user'            => 'مستخدم',
'imagelist_size'            => 'حجم',
'imagelist_description'     => 'وصف',
'imagelist_search_for'      => 'ابحث عن اسم الميديا:',

# File reversion
'filerevert'                => 'استرجع $1',
'filerevert-legend'         => 'استرجع الملف',
'filerevert-intro'          => '<span class="plainlinks">أنت تسترجع \'\'\'[[Media:$1|$1]]\'\'\' [$4 لنسخة بتاريخ $2، $3].</span>',
'filerevert-comment'        => 'تعليق:',
'filerevert-defaultcomment' => 'استرجع للنسخة بتاريخ $1، $2',
'filerevert-submit'         => 'استرجع',
'filerevert-success'        => '<span class="plainlinks">\'\'\'[[Media:$1|$1]]\'\'\' تم استرجاعها [$4 لنسخة بتاريخ $2، $3].</span>',
'filerevert-badversion'     => 'لا توجد نسخة محلية سابقة لهذا الملف بالتاريخ المعطى.',

# File deletion
'filedelete'                  => 'احذف $1',
'filedelete-legend'           => 'احذف الملف',
'filedelete-intro'            => "أنت تحذف '''[[Media:$1|$1]]'''.",
'filedelete-intro-old'        => '<span class="plainlinks">أنت تحذف نسخة \'\'\'[[Media:$1|$1]]\'\'\' بتاريخ [$4 $3، $2].</span>',
'filedelete-comment'          => 'تعليق:',
'filedelete-submit'           => 'حذف',
'filedelete-success'          => "'''$1''' تم حذفه.",
'filedelete-success-old'      => '<span class="plainlinks">نسخة \'\'\'[[Media:$1|$1]]\'\'\' بتاريخ $3، $2 تم حذفها.</span>',
'filedelete-nofile'           => "'''$1''' غير موجود في {{SITENAME}}.",
'filedelete-nofile-old'       => "لا توجد نسخة مؤرشفة من '''$1''' بالعناصر المحددة.",
'filedelete-iscurrent'        => 'أنت تحاول حذف أحدث نسخة من هذا الملف. من فضلك استرجع لنسخة أقدم أولا.',
'filedelete-otherreason'      => 'سبب إضافي/آخر:',
'filedelete-reason-otherlist' => 'سبب آخر',
'filedelete-reason-dropdown'  => '*أسباب الحذف الشائعة
** خرق حقوق النشر
** ملف مكرر',

# MIME search
'mimesearch'         => 'بحث MIME',
'mimesearch-summary' => 'تعمل هذه الصفحة على عرض وتصفية الملفات بناء على نوعها. المدخل: نوع المحتوى/النوع الفرعي، كمثال
<tt>image/jpeg</tt>.',
'mimetype'           => 'نوع الملف:',
'download'           => 'تحميل',

# Unwatched pages
'unwatchedpages' => 'صفحات غير مراقبة',

# List redirects
'listredirects' => 'عرض التحويلات',

# Unused templates
'unusedtemplates'     => 'قوالب غير مستعملة',
'unusedtemplatestext' => 'تحتوي هذه الصفحة على قائمة بالصفحات من نطاق قالب غير المستعملة في صفحات أخرى. تذكر بأن تتحقق من عدم وجود وصلات أخرى لهذه القوالب قبل حذفها.',
'unusedtemplateswlh'  => 'وصلات أخرى',

# Random page
'randompage'         => 'صفحة عشوائية',
'randompage-nopages' => 'لا توجد صفحات في هذا النطاق.',

# Random redirect
'randomredirect'         => 'تحويلة عشوائية',
'randomredirect-nopages' => 'لا توجد تحويلات في هذا النطاق.',

# Statistics
'statistics'             => 'إحصاءات',
'sitestats'              => 'إحصاءات {{SITENAME}}',
'userstats'              => 'إحصاءات المستخدم',
'sitestatstext'          => "توجد {{PLURAL:\$1|'''1''' صفحة|'''\$1''' صفحة كلية}} في قاعدة البيانات.
هذا يشمل \"النقاش\" صفحات، الصفحات حول {{SITENAME}}، الصغرى \"البذور\"
صفحات، التحويلات، و غيرها التي غالبا لا تتأهل كصفحات محتوى.
باستثناء هؤلاء، توجد {{PLURAL:\$2|'''1''' صفحة| '''\$2''' صفحة}} تعتبر على الأرجح
{{PLURAL:\$2|صفحة|صفحة}} محتوى معتبرة.

'''\$8''' {{PLURAL:\$8|ملف|ملف}} تم رفعه.

هناك كإجمالي '''\$3''' {{PLURAL:\$3|عرض صفحة|عرض صفحة}}، و '''\$4''' {{PLURAL:\$4|تعديل صفحة|تعديل صفحة}}
منذ تنصيب {{SITENAME}}.
هذا يعني '''\$5''' تعديل متوسط لكل صفحة، و '''\$6''' عرض لكل تعديل.

طول [http://meta.wikimedia.org/wiki/Help:Job_queue طابور الشغل] هو '''\$7'''.",
'userstatstext'          => "هناك {{PLURAL:$1|مستخدم مسجل وحيد|مستخدمين مسجلين|$3 مستخدمين مسجلين|$3 مستخدم مسجل|$3 مستخدما مسجلا}}، منهم
'''$2''' (أو '''$4%''') {{PLURAL:$2|لديه|لديهما|لديهم}} صلاحيات $5.",
'statistics-mostpopular' => 'أكثر الصفحات مشاهدة',

'disambiguations'      => 'صفحات التوضيح',
'disambiguationspage'  => 'Template:توضيح',
'disambiguations-text' => "الصفحات التالية تصل إلى '''صفحة توضيح'''. ينبغي في المقابل أن تصل إلى الضفحة الملائمة. <br />تعامل الصفحة كصفحة توضيح إذا كان بها قالب موجود في [[MediaWiki:disambiguationspage|صفحة الميدياويكي هذه]]",

'doubleredirects'     => 'تحويلات مزدوجة',
'doubleredirectstext' => "كل سطر في القائمة التالية يحتوي على وصلات للتحويلة الأولى والثانية بالإضافة إلى أول سطر من نص التحويلة الثانية والذي عادة ما يشير إلى المقالة ''المفترض'' أن يتم التحويل إليها مباشرة من التحويلة الأولى أيضا.",

'brokenredirects'        => 'تحويلات مكسورة',
'brokenredirectstext'    => 'الوصلات التالية تشير لصفحات غير موجودة:',
'brokenredirects-edit'   => '(تحرير)',
'brokenredirects-delete' => '(حذف)',

'withoutinterwiki'        => 'صفحات بدون وصلات لغات أخرى',
'withoutinterwiki-header' => 'الصفحات التالية لا تصل إلى نسخ بلغات أخرى:',
'withoutinterwiki-submit' => 'عرض',

'fewestrevisions' => 'المقالات ذات أقل تعديل',

# Miscellaneous special pages
'nbytes'                  => '$1 {{PLURAL:$1|بايت|بايت}}',
'ncategories'             => '$1 {{PLURAL:$1|تصنيف واحد|تصنيفان|تصنيفات|تصنيف|تصنيفا}}',
'nlinks'                  => '{{PLURAL:$1|وصلة واحدة|وصلتان|$1 وصلات|$1 وصلة}}',
'nmembers'                => '{{PLURAL:$1|عضو واحد|عضوان|$1 أعضاء|$1 عضو|$1 عضوا}}',
'nrevisions'              => '{{PLURAL:$1|تعديل وحيد|تعديلان|$1 تعديلات|$1 تعديل|$1 تعديلا}}',
'nviews'                  => '{{PLURAL:$1|مشاهدة واحدة|مشاهدتان|$1 مشاهدات|$1 مشاهدة}}',
'specialpage-empty'       => 'لا توجد نتائج لهذا التقرير.',
'lonelypages'             => 'صفحات يتيمة',
'lonelypagestext'         => 'الصفحات التالية غير موصولة من الصفحات الأخرى في {{SITENAME}}.',
'uncategorizedpages'      => 'صفحات غير مصنفة',
'uncategorizedcategories' => 'تصنيفات غير مصنفة',
'uncategorizedimages'     => 'ملفات غير مصنفة',
'uncategorizedtemplates'  => 'قوالب غير مصنفة',
'unusedcategories'        => 'تصنيفات غير مستعملة',
'unusedimages'            => 'صور غير مستعملة',
'popularpages'            => 'صفحات مشهورة',
'wantedcategories'        => 'تصنيفات مطلوبة',
'wantedpages'             => 'صفحات مطلوبة',
'mostlinked'              => 'أكثر الصفحات المرتبطة بصفحات أخرى',
'mostlinkedcategories'    => 'أكثر التصنيفات ارتباطا',
'mostlinkedtemplates'     => 'أكثر القوالب وصلا',
'mostcategories'          => 'أكثر الصفحات تصنيفا',
'mostimages'              => 'أكثر الملفات ارتباطا',
'mostrevisions'           => 'أكثر المقالات تعديلا',
'allpages'                => 'كل الصفحات',
'prefixindex'             => 'فهرس بادئة',
'shortpages'              => 'صفحات قصيرة',
'longpages'               => 'صفحات طويلة',
'deadendpages'            => 'صفحات نهاية مسدودة',
'deadendpagestext'        => 'الصفحات التالية لا تصل إلى صفحات أخرى في {{SITENAME}}.',
'protectedpages'          => 'صفحات محمية',
'protectedpagestext'      => 'الصفحات التالية محمية من النقل أو التعديل',
'protectedpagesempty'     => 'لا توجد صفحات محمية حاليا بهذه المحددات.',
'protectedtitles'         => 'عناوين محمية',
'protectedtitlestext'     => 'العناوين التالية محمية ضد الإنشاء',
'protectedtitlesempty'    => 'لا توجد عناوين محمية حاليا بهذه المحددات.',
'listusers'               => 'قائمة الأعضاء',
'specialpages'            => 'الصفحات الخاصة',
'spheading'               => 'الصفحات الخاصة لكل المستخدمين',
'restrictedpheading'      => 'صفحات خاصة للمخولين فقط',
'newpages'                => 'صفحات جديدة',
'newpages-username'       => 'اسم المستخدم:',
'ancientpages'            => 'أقدم الصفحات',
'intl'                    => 'وصلات بين اللغات',
'move'                    => 'نقل',
'movethispage'            => 'انقل هذه الصفحة',
'unusedimagestext'        => '<p>من فضلك لاحظ أن المواقع الأخرى ربما تصل إلى ملف بالمسار المباشر، ولذا ربما يكون معروضا هنا بالرغم من كونه مستخدما.</p>',
'unusedcategoriestext'    => 'التصنيفات التالية موجودة على الرغم من أنها لا تحتوي على أية مقالات أو تصنيفات أخرى.',
'notargettitle'           => 'لا هدف',
'notargettext'            => 'لم تحدد الصفحة او المستخدم المستهدف
لعمل هذه الخاصية.',
'pager-newer-n'           => '{{PLURAL:$1|أجدد 1|أجدد $1}}',
'pager-older-n'           => '{{PLURAL:$1|أقدم 1|أقدم $1}}',

# Book sources
'booksources'               => 'مصادر كتاب',
'booksources-search-legend' => 'البحث عن مصادر الكتب',
'booksources-isbn'          => 'ردمك:',
'booksources-go'            => 'اذهب',
'booksources-text'          => 'توجد أدناه قائمة بوصلات لمواقع أخرى تبيع الكتب الجديدة والمستعملة، أيضا يمكنك أن تحصل على معلومات إضافية عن الكتب التي تبحث عنها من هناك:',

'categoriespagetext' => 'التصنيفات التالية موجودة في الويكي.',
'data'               => 'بيانات',
'userrights'         => 'إدارة صلاحيات المستخدم',
'groups'             => 'مجموعات المستخدم',
'isbn'               => 'ردمك',
'alphaindexline'     => '$1 إلى $2',
'version'            => 'إصدار',

# Special:Log
'specialloguserlabel'  => 'المستخدم:',
'speciallogtitlelabel' => 'العنوان:',
'log'                  => 'سجلات',
'all-logs-page'        => 'كل السجلات',
'log-search-legend'    => 'ابحث عن سجلات',
'log-search-submit'    => 'اذهب',
'alllogstext'          => 'عرض شامل لكل السجلات المتوفرة في {{SITENAME}}. باستطاعتك جعل القائمة أكثر تحديدا وذلك باختيار نوع العملية، أو اسم المستخدم، أو الصفحات المتأثرة.',
'logempty'             => 'لا توجد مدخلات مطابقة في السجل.',
'log-title-wildcard'   => 'البحث عن عناوين تبدأ بهذا النص',

# Special:Allpages
'nextpage'          => 'الصفحة التالية ($1)',
'prevpage'          => 'الصفحة السابقة ($1)',
'allpagesfrom'      => 'عرض الصفحات بدءا من:',
'allarticles'       => 'كل المقالات',
'allinnamespace'    => 'كل الصفحات (في نطاق $1)',
'allnotinnamespace' => 'كل الصفحات (ليست في نطاق $1)',
'allpagesprev'      => 'السابق',
'allpagesnext'      => 'التالي',
'allpagessubmit'    => 'اذهب',
'allpagesprefix'    => 'عرض الصفحات التي تبدأ بـ:',
'allpagesbadtitle'  => 'العنوان المقترح للصفحة غير مقبول أو يضم لغات أخرى أو سابقة إنترويكي. يمكن أن يتضمن حروفا لا يمكن استعمالها للعناوين.',
'allpages-bad-ns'   => '{{SITENAME}} لا يوجد بها نطاق "$1".',

# Special:Listusers
'listusersfrom'      => 'عرض المستخدمين بدءا من:',
'listusers-submit'   => 'عرض',
'listusers-noresult' => 'لم يتم إيجاد مستخدم.',

# E-mail user
'mailnologin'     => 'لا يوجد عنوان للإرسال',
'mailnologintext' => 'يجب أن تقوم [[Special:Userlogin|بتسجيل الدخول]] وإدخال بريد إلكتروني صالح في صفحة [[Special:Preferences|التفضيلات]] لتتمكن من إرسال الرسائل لمستخدمين آخرين.',
'emailuser'       => 'إرسال رسالة لهذا المستخدم',
'emailpage'       => 'إرسال رسالة للمستخدم',
'emailpagetext'   => 'لو أن هذا المستخدم قد قام بإدخال عنوان بريدي صحيح في تفضيلاته،
فسيتم إرسال رسالة واحدة له بالنموذج أدناه.
العنوان الذي قمت أنت بإدخاله لك في تفضيلات المستخدم،
سيظهر في مكان المرسل في الرسالة التي سترسل له، ليتمكن من الرد عليك.',
'usermailererror' => 'جسم البريد أرجع خطأ:',
'defemailsubject' => 'رسالة من {{SITENAME}}',
'noemailtitle'    => 'لا يوجد عنوان بريد إلكتروني',
'noemailtext'     => 'لم يحدد هذا المستخدم عنوان بريد إلكتروني صحيح،
أو طلب عدم استلام الرسائل من المستخدمين الآخرين.',
'emailfrom'       => 'من',
'emailto'         => 'إلى',
'emailsubject'    => 'الموضوع',
'emailmessage'    => 'الرسالة',
'emailsend'       => 'إرسال',
'emailccme'       => 'أرسل لي بنسخة من رسالتي.',
'emailccsubject'  => 'نسخة من رسالتك إلى $1: $2',
'emailsent'       => 'تم إرسال البريد الإلكتروني',
'emailsenttext'   => 'تم إرسال رسالتك الإلكترونية.',

# Watchlist
'watchlist'            => 'قائمة مراقبتي',
'mywatchlist'          => 'قائمة مراقبتي',
'watchlistfor'         => "(ل '''$1''')",
'nowatchlist'          => 'لا توجد عناوين في قائمة مراقبتك.',
'watchlistanontext'    => 'الرجاء $1 لعرض أو تعديل الصفحات في قائمة مراقبتك.',
'watchnologin'         => 'غير مسجل',
'watchnologintext'     => 'يجب أن تكون [[Special:Userlogin|مسجلا الدخول]] لتعدل قائمة مراقبتك.',
'addedwatch'           => 'تمت الإضافة لقائمة المراقبة',
'addedwatchtext'       => 'تمت إضافة الصفحة  "$1" إلى [[Special:Watchlist|قائمة المراقبة]] خاصتك. سيتم وضع التغييرات القادمة على هذه الصفحة، وصفحة النقاش الخاصة بها سيتم وضعها هناك. وسيتم اظهار اسم الصفحة بخط <b>عريض</b> في صفحة [[Special:Recentchanges|أحدث التغييرات]] لتسهيل تحديدها واكتشافها.

إذا كنت تريد إزالة الصفحة من قائمة المراقبة لديك، اضغط على "توقف عن المراقبة" بالأعلى.',
'removedwatch'         => 'تمت الإزالة من قائمة المراقبة',
'removedwatchtext'     => 'تمت إزالة الصفحة "[[:$1]]" من قائمة مراقبتك.',
'watch'                => 'مراقبة',
'watchthispage'        => 'راقب هذه الصفحة',
'unwatch'              => 'إيقاف المراقبة',
'unwatchthispage'      => 'توقف عن المراقبة',
'notanarticle'         => 'ليست صفحة محتوى',
'watchnochange'        => 'لم يتم تعديل أي صفحة في قائمة مراقبتك خلال الفترة المحددة.',
'watchlist-details'    => '{{PLURAL:$1|$1 صفحة|$1 صفحة}} مراقبة بدون عد صفحات النقاش.',
'wlheader-enotif'      => '* خاصية الإعلام بالبريد الإلكتروني مفعلة.',
'wlheader-showupdated' => "* الصفحات التي تم تحريرها بعد زيارتك لها لآخر مرة معروضة بالخط '''العريض'''",
'watchmethod-recent'   => 'فحص التعديلات الأخيرة للصفحات المراقبة',
'watchmethod-list'     => 'إظهار التحريرات في الصفحات المراقبة',
'watchlistcontains'    => 'تحتوي قائمة مراقبتك على $1 {{PLURAL:$1|صفحة|صفحات}}.',
'iteminvalidname'      => "مشكلة في المدخل '$1'، اسم غير صحيح...",
'wlnote'               => "بالأسفل {{PLURAL:$1|آخر تغيير|آخر '''$1''' تغيير}} في آخر {{PLURAL:$2|ساعة|'''$2''' ساعة}}.",
'wlshowlast'           => 'عرض آخر $1 ساعات $2 أيام $3',
'watchlist-show-bots'  => 'عرض تعديلات البوتات',
'watchlist-hide-bots'  => 'إخفاء تعديلات البوت',
'watchlist-show-own'   => 'عرض تعديلاتي',
'watchlist-hide-own'   => 'إخفاء تعديلاتي',
'watchlist-show-minor' => 'عرض التعديلات الطفيفة',
'watchlist-hide-minor' => 'إخفاء التعديلات الطفيفة',

# Displayed when you click the "watch" button and it's in the process of watching
'watching'   => 'مراقبة...',
'unwatching' => 'إزالة المراقبة...',

'enotif_mailer'                => 'نظام {{SITENAME}} البريدي للملاحظات',
'enotif_reset'                 => 'اعتبر كل الصفحات تم زيارتها',
'enotif_newpagetext'           => 'هذه صفحة جديدة.',
'enotif_impersonal_salutation' => '{{SITENAME}} مستخدم',
'changed'                      => 'تم التغيير',
'created'                      => 'أنشأ',
'enotif_subject'               => 'صفحة {{SITENAME}} $PAGETITLE تم $CHANGEDORCREATED بواسطة $PAGEEDITOR',
'enotif_lastvisited'           => 'انظر $1 لمراجعة كل التغييرات منذ زيارتك الأخيرة.',
'enotif_lastdiff'              => 'انظر $1 لرؤية هذا التغيير.',
'enotif_anon_editor'           => 'مستخدم مجهول $1',
'enotif_body'                  => 'عزيزي $WATCHINGUSERNAME،

إن صفحة $PAGETITLE في {{SITENAME}} قد تغيرت إلى $CHANGEDORCREATED من قبل $PAGEEDITOR، لرؤية النسخة الحالية من الصفحة انظر هنا: $PAGETITLE_URL.

$NEWPAGE

ملخص التحرير: $PAGESUMMARY $PAGEMINOREDIT

اتصل بالمستخدم المحرر:
بريد إلكتروني: $PAGEEDITOR_EMAIL
صفحة المستخدم: $PAGEEDITOR_WIKI

لن يكون هنالك أي إخطارات أخرى عن أية تغييرات تتم في المستقبل إلا إذا زرت هذه الصفحة. يمكنك أيضا أن تعيد تصفير عداد الإخطارات لجميع الصفحات التي تراقبها في قائمة مراقبتك.

رسالة إرشادية من {{SITENAME}}

--
لتغيير قائمة مراقبتك اذهب إلى:
{{fullurl:{{ns:special}}:Watchlist/edit}}

للاقتراحات والحصول على مساعدة إضافية:
{{fullurl:{{MediaWiki:Helppage}}}}',

# Delete/protect/revert
'deletepage'                  => 'احذف الصفحة',
'confirm'                     => 'تأكيد',
'excontent'                   => "المحتوى كان: '$1'",
'excontentauthor'             => "المحتوى كان: '$1' (والمساهم الوحيد كان '[[Special:Contributions/$2|$2]]')",
'exbeforeblank'               => "المحتوى قبل الإفراغ كان: '$1'",
'exblank'                     => 'الصفحة كانت فارغة',
'delete-confirm'              => 'حذف "$1"',
'delete-legend'               => 'حذف',
'historywarning'              => 'تحذير: الصفحة التي توشك على حذفها لديها تاريخ:',
'confirmdeletetext'           => 'أنت على وشك أن تقوم بحذف صفحة أو صورة بالإضافة إلى جميع التعديلات عليها بشكل دائم من قاعدة البيانات. الرجاء التأكد من عزمك على الحذف وبأنك مدرك لنتائج هذه العملية. عمليات الحذف يجب أن تتم بناء على [[{{MediaWiki:Policy-url}}|القواعد المتفق عليها]].',
'actioncomplete'              => 'انتهاء العملية',
'deletedtext'                 => '"<nowiki>$1</nowiki>" تم حذفها.
انظر في $2 لسجل آخر عمليات الحذف.',
'deletedarticle'              => 'حذف "[[$1]]"',
'dellogpage'                  => 'سجل الحذف',
'dellogpagetext'              => 'بالأسفل قائمة بأحدث عمليات الحذف.',
'deletionlog'                 => 'سجل الحذف',
'reverted'                    => 'استرجع لنسخة أقدم',
'deletecomment'               => 'سبب الحذف:',
'deleteotherreason'           => 'سبب آخر/إضافي:',
'deletereasonotherlist'       => 'سبب آخر',
'deletereason-dropdown'       => '*أسباب الحذف الشائعة
** طلب المؤلف
** خرق لحقوق التأليف والنشر
** تخريب',
'delete-toobig'               => 'هذه الصفحة لها تاريخ تعديلات كبير، أكثر من $1 نسخة. حذف مثل هذه الصفحات تم منعه لمنع حدوث اضطراب فجائي في {{SITENAME}}.',
'delete-warning-toobig'       => 'هذه الصفحة لها تاريخ تعديلات كبير، أكثر من $1 نسخة. حذفها قد يؤدي إلى اضطراب عمليات قاعدة البيانات في {{SITENAME}}؛ تقدم مع الحذر.',
'rollback'                    => 'استرجاع التعديلات',
'rollback_short'              => 'استرجاع',
'rollbacklink'                => 'استرجاع',
'rollbackfailed'              => 'لم ينجح الاسترجاع',
'cantrollback'                => 'لم يمكن استرجاع التعديل؛ آخر مساهم هو المستخدم الوحيد الذي عدل هذه الصفحة.',
'alreadyrolled'               => 'لم ينجح استرجاع آخر تعديل لصفحة [[$1]] من قبل [[User:$2|$2]] ([[User talk:$2|نقاش]]) لأن هنالك من قام بتعديل أو استرجاع هذه الصفحة من قبل.

آخر تعديل كان بواسطة [[User:$3|$3]] ([[User talk:$3|نقاش]]).',
'editcomment'                 => 'تعليق التعديل كان: "<i>$1</i>".', # only shown if there is an edit comment
'revertpage'                  => 'استرجع تعديلات [[Special:Contributions/$2|$2]] ([[User talk:$2|نقاش]])؛ استرجع حتى تعديل [[User:$1|$1]]', # Additional available: $3: revid of the revision reverted to, $4: timestamp of the revision reverted to, $5: revid of the revision reverted from, $6: timestamp of the revision reverted from
'rollback-success'            => 'استرجع تعديلات $1؛ استرجع حتى آخر نسخة بواسطة $2.',
'sessionfailure'              => 'يبدو أنه هناك مشكلة في هذه الجلسة الخاصة بك؛ لذلك فقد ألغيت هذه العملية كإجراء احترازي ضد الاختراق. الرجاء الضغط على مفتاح "العودة" (Back) للرجوع للصفحة التي جئت منها ثم قم بإعادة تحميلها قبل المحاولة مرة أخرى.',
'protectlogpage'              => 'سجل الحماية',
'protectlogtext'              => 'بالأسفل قائمة بالصفحات التي تمت حمايتها أو إزالة الحماية عنها. للمزيد من المعلومات انظر [[Special:Protected page|قائمة الصفحات المحمية]].',
'protectedarticle'            => 'حمى "[[$1]]"',
'modifiedarticleprotection'   => 'غير مستوى الحماية ل‍ "[[$1]]"',
'unprotectedarticle'          => 'أزال حماية [[$1]]',
'protectsub'                  => '(ضبط مستوى الحماية ل‍ "$1")',
'confirmprotect'              => 'تأكيد الحماية',
'protectcomment'              => 'تعليق:',
'protectexpiry'               => 'تنتهي في:',
'protect_expiry_invalid'      => 'وقت الانتهاء غير صحيح.',
'protect_expiry_old'          => 'وقت انتهاء المنع يقع في الماضي.',
'unprotectsub'                => '(إزالة حماية "$1")',
'protect-unchain'             => 'فصل سماح النقل',
'protect-text'                => 'يمكنك هنا أن تعرض و تغير مستوى الحماية للصفحة <strong><nowiki>$1</nowiki></strong>.',
'protect-locked-blocked'      => 'لا يمكنك تغيير مستويات الحماية وأنت ممنوع.
الإعدادات الحالية للصفحة <strong>$1</strong> هي:',
'protect-locked-dblock'       => 'لا يمكن تغيير مستويات الحماية بسبب غلق قاعدة البيانات حاليا.
الإعدادات الحالية للصفحة <strong>$1</strong> هي:',
'protect-locked-access'       => 'لا يملك حسابك هذا صلاحية تغيير مستوى حماية الصفحة.
الإعدادات الحالية للصفحة <strong>$1</strong> هي:',
'protect-cascadeon'           => 'هذه الصفحة محمية لكونها مضمنة في {{PLURAL:$1|الصفحة|الصفحات}} التالية، والتي بها خيار حماية الصفحات المدمجة فعال. يمكنك تغيير مستوى حماية هذه الصفحة بدون التأثير على حماية الصفحات المدمجة الأخرى.',
'protect-default'             => '(افتراضي)',
'protect-fallback'            => 'يتطلب السماح "$1"',
'protect-level-autoconfirmed' => 'منع المستخدمين غير المسجلين',
'protect-level-sysop'         => 'مدراء النظام فقط',
'protect-summary-cascade'     => 'مضمنة',
'protect-expiring'            => 'تنتهي في $1 (UTC)',
'protect-cascade'             => 'احم الصفحات المضمنة في هذه الصفحة (حماية مضمنة)',
'protect-cantedit'            => 'لا يمكنك تغيير مستويات الحماية لهذه الصفحة، لأنك لا تمتلك الصلاحية لتعديلها.',
'restriction-type'            => 'سماح:',
'restriction-level'           => 'مستوى الضوابط:',
'minimum-size'                => 'الحجم الأدنى',
'maximum-size'                => 'الحجم الأقصى',
'pagesize'                    => '(بايت)',

# Restrictions (nouns)
'restriction-edit'   => 'تعديل',
'restriction-move'   => 'نقل',
'restriction-create' => 'إنشاء',

# Restriction levels
'restriction-level-sysop'         => 'حماية كاملة',
'restriction-level-autoconfirmed' => 'حماية جزئية',
'restriction-level-all'           => 'أي مستوى',

# Undelete
'undelete'                     => 'عرض الصفحات المحذوفة',
'undeletepage'                 => 'عرض واسترجاع الصفحات المحذوفة',
'viewdeletedpage'              => 'عرض الصفحات المحذوفة',
'undeletepagetext'             => 'تم حذف الصفحات التالية ولكنها مازالت في الأرشيف ويمكن استرجاعها. يمكن تنظيف الأرشيف بشكل دوري.',
'undeleteextrahelp'            => "لاسترجاع الصفحة كاملة، اترك جميع الصناديق فارغة
و اضغط '''''استرجاع'''''. للاسترجاع بشكل انتقائي، ضع علامة في الصناديق أمام التعديلات التي تريد استرجاعها، و اضغط '''''استرجاع'''''. الضغط على '''''إلغاء''''' سيؤدي إلى إفراغ التعليق و حذف جميع العلامات من الصناديق.",
'undeleterevisions'            => '$1 {{PLURAL:$1|نسخة|نسخة}} تم أرشفتها',
'undeletehistory'              => 'لو استرجعت الصفحة، كل النسخ سيتم استرجاعها إلى التاريخ.
لو كان قد تم إنشاء صفحة جديدة بالاسم نفسه بعد الحذف، النسخ المسترجعة ستظهر في التاريخ السابق. أيضا لاحظ أن الضوابط على نسخ الملف ستضيع مع الاسترجاع',
'undeleterevdel'               => 'الاسترجاع لن يتم إذا كان سينتج عنه أن تكون النسخة أعلى الصفحة محذوفة جزئيا. في مثل هذه الحالات، يجب عليك إظهار أحدث النسخ المحذوفة. نسخ الملفات
التي لا تمتلك الصلاحية لرؤيتها لن يتم استرجاعها.',
'undeletehistorynoadmin'       => 'لقد تم حذف هذه الصفحة للأسباب المدرجة في الأسفل. إلى جانب أسباب الحذف يمكن رؤية المستخدمين الذين قاموا بالتعديل على هذه الصفحة قبل حذفها. بإمكان الإداريين فقط رؤية المحتويات الأصلية للمقال والتعديلات عليها.',
'undelete-revision'            => 'النسخة المحذوفة ل$1 (بتاريخ $2) بواسطة $3:',
'undeleterevision-missing'     => 'نسخة غير صحيحة أو مفقودة. ربما لديك وصلة سيئة، أو ربما النسخة تم استرجاعها أو إزالتها من الأرشيف.',
'undelete-nodiff'              => 'لم يتم العثور على نسخة سابقة.',
'undeletebtn'                  => 'استرجاع',
'undeletelink'                 => 'استرجاع',
'undeletereset'                => 'إلغاء',
'undeletecomment'              => 'تعليق:',
'undeletedarticle'             => 'استرجع "[[$1]]"',
'undeletedrevisions'           => 'تم استرجاع {{PLURAL:$1|تعديل واحد|تعديلان|$1 تعديلات|$1 تعديل|$1 تعديلا}}',
'undeletedrevisions-files'     => '{{PLURAL:$1|1 نسخة|$1 نسخة}} و {{PLURAL:$2|1 ملف|$2 ملف}} تم استرجاعها',
'undeletedfiles'               => '{{PLURAL:$1|ملف|ملفات}} $1 تم استرجاع',
'cannotundelete'               => 'فشل الاسترجاع؛ ربما قام شخص آخر باسترجاع الصفحة بالفعل.',
'undeletedpage'                => "<big>'''تم استرجاع $1'''</big>

راجع [[Special:Log/delete|سجل الحدف]] لمعاينة عمليات الحذف و الاسترجاعات الحديثة.",
'undelete-header'              => 'انظر الصفحات المحذوفة حديثا في [[Special:Log/delete|سجل الحذف]].',
'undelete-search-box'          => 'ابحث في الصفحات المحذوفة',
'undelete-search-prefix'       => 'عرض الصفحات التي تبدأ بـ:',
'undelete-search-submit'       => 'ابحث',
'undelete-no-results'          => 'لم يتم العثور على صفحات مطابقة في أرشيف المحذوفات.',
'undelete-filename-mismatch'   => 'لم يمكن استرجاع نسخة الملف بتاريخ $1: اسم الملف لا يطابق',
'undelete-bad-store-key'       => 'لم يمكن استرجاع نسخة الملف بتاريخ $1: الملف كان مفقودا قبل الحذف',
'undelete-cleanup-error'       => 'خطأ حذف ملف أرشيف غير مستخدم "$1".',
'undelete-missing-filearchive' => 'غير قادر على استرجاع ملف الأرشيف رقم $1 لأنه ليس في قاعدة البيانات. ربما يكون قد تم استرجاعه.',
'undelete-error-short'         => 'خطأ استرجاع ملف: $1',
'undelete-error-long'          => 'حدثت أخطاء أثناء استرجاع الملف:

$1',

# Namespace form on various pages
'namespace'      => 'النطاق:',
'invert'         => 'عكس الاختيار',
'blanknamespace' => '(رئيسي)',

# Contributions
'contributions' => 'مساهمات المستخدم',
'mycontris'     => 'مساهماتي',
'contribsub2'   => 'للمستخدم $1 ($2)',
'nocontribs'    => 'لم يتم العثور على تغييرات تطابق هذه المحددات.',
'ucnote'        => 'في الأسفل ستجد آخر <b>$1</b> تعديل لهذا المستخدم في <b>$2</b> أيام.',
'uclinks'       => 'عرض آخر $1 تعديل؛ عرض آخر $2 يوم.',
'uctop'         => '(أعلى)',
'month'         => 'من شهر (وأقدم):',
'year'          => 'من سنة (وأقدم):',

'sp-contributions-newbies'     => 'عرض مساهمات الحسابات الجديدة فقط',
'sp-contributions-newbies-sub' => 'للحسابات الجديدة',
'sp-contributions-blocklog'    => 'سجل المنع',
'sp-contributions-search'      => 'بحث عن مساهمات',
'sp-contributions-username'    => 'عنوان أيبي أو اسم مستخدم:',
'sp-contributions-submit'      => 'بحث',

'sp-newimages-showfrom' => 'أظهر الملفات الجديدة بدءا من $1',

# What links here
'whatlinkshere'       => 'ماذا يصل هنا',
'whatlinkshere-title' => 'الصفحات التي تصل إلى $1',
'whatlinkshere-page'  => 'الصفحة:',
'linklistsub'         => '(قائمة الوصلات)',
'linkshere'           => "الصفحات التالية تحتوي على وصلة إلى '''[[:$1]]''':",
'nolinkshere'         => "لا توجد صفحات تصل إلى '''[[:$1]]'''.",
'nolinkshere-ns'      => "لا تصل أي صفحة إلى '''[[:$1]]''' في النطاق المختار.",
'isredirect'          => 'صفحة تحويل',
'istemplate'          => 'مضمن',
'whatlinkshere-prev'  => '{{PLURAL:$1|السابق|الـ $1 السابقة}}',
'whatlinkshere-next'  => '{{PLURAL:$1|القادمة|الـ $1 القادمة}}',
'whatlinkshere-links' => '← وصلات',

# Block/unblock
'blockip'                     => 'منع مستخدم',
'blockiptext'                 => 'استخدم الاستمارة أدناه لمنع عنوان أيبي
أو مستخدم مسجل من الكتابة.
يجب أن يتم هذا فقط لمنع التخريب ومتوافقا مع
[[{{MediaWiki:Policy-url}}|السياسة]] المتبعة هنا.
قم بذكر السبب أدناه (كمثال، اذكر بعض الصفحات التي قام بتخريبها تحديدا).',
'ipaddress'                   => 'عنوان الأيبي:',
'ipadressorusername'          => 'عنوان الأيبي أو اسم المستخدم:',
'ipbexpiry'                   => 'مدة المنع:',
'ipbreason'                   => 'السبب:',
'ipbreasonotherlist'          => 'سبب آخر',
'ipbreason-dropdown'          => '*أسباب المنع الشائعة
** كتابة معلومات زائفة
** إزالة المحتوى من الصفحات
** سخام وصلات لمواقع خارجية
** كتابة كلام لا معنى له في الصفحات
** سلوك عدواني
** إساءة استخدام حسابات متعددة
** اسم مستخدم غير مقبول',
'ipbanononly'                 => 'منع المستخدمين المجهولين فقط',
'ipbcreateaccount'            => 'منع إنشاء الحسابات',
'ipbemailban'                 => 'منع المستخدم من إرسال بريد إلكتروني',
'ipbenableautoblock'          => 'تلقائيا امنع آخر عنوان أيبي تم استعماله بواسطة هذا المستخدم، وأي عناوين أيبي أخرى يحاول التحرير من خلالها',
'ipbsubmit'                   => 'امنع هذا المستخدم',
'ipbother'                    => 'وقت آخر:',
'ipboptions'                  => 'ربع ساعة:15 minutes,ساعة واحدة:1 hour,ساعتين:2 hours,يوم:1 day,ثلاثة أيام:3 days,أسبوع:1 week,أسبوعان:2 weeks,شهر:1 month,ثلاثة شهور:3 months,ستة شهور:6 months,عام واحد:1 year,دائم:infinite', # display1:time1,display2:time2,...
'ipbotheroption'              => 'غير ذلك',
'ipbotherreason'              => 'سبب إضافي:',
'ipbhidename'                 => 'إخفاء اسم/عنوان المستخدم من سجل المنع وقائمة المنع الحالي وقائمة المستخدمين',
'badipaddress'                => 'عنوان أيبي غير صحيح',
'blockipsuccesssub'           => 'تم المنع بنجاح',
'blockipsuccesstext'          => 'تم منع [[Special:Contributions/$1|$1]].
<br />انظر [[Special:Ipblocklist|قائمة منع الأيبي]] لمراجعة حالات المنع.',
'ipb-edit-dropdown'           => 'تعديل أسباب المنع',
'ipb-unblock-addr'            => 'رفع منع $1',
'ipb-unblock'                 => 'رفع المنع عن مستخدم أو عنوان أيبي',
'ipb-blocklist-addr'          => 'عرض المنع الحالي لـ $1',
'ipb-blocklist'               => 'عرض حالات المنع الحالية',
'unblockip'                   => 'رفع منع مستخدم',
'unblockiptext'               => 'استخدم الحقل أدناه لاسترجاع صلاحية الكتابة
الخاصة بعنوان أيبي أو مستخدم تم سحبها منه مسبقا.',
'ipusubmit'                   => 'رفع منع هذا العنوان',
'unblocked'                   => 'تم  رفع منع [[مستخدم:$1|$1]]',
'unblocked-id'                => 'منع $1 تم رفعه',
'ipblocklist'                 => 'قائمة عناوين الأيبي وأسماء المستخدمين الممنوعة',
'ipblocklist-legend'          => 'أوجد مستخدما ممنوعا',
'ipblocklist-username'        => 'اسم المستخدم أو عنوان الأيبي:',
'ipblocklist-submit'          => 'بحث',
'blocklistline'               => '$1, $2 منع $3 ($4)',
'infiniteblock'               => 'غير محدد',
'expiringblock'               => 'ينتهي في $1',
'anononlyblock'               => 'مجهول فقط',
'noautoblockblock'            => 'المنع التلقائي معطل',
'createaccountblock'          => 'إنشاء الحسابات ممنوع.',
'emailblock'                  => 'البريد الإلكتروني ممنوع',
'ipblocklist-empty'           => 'قائمة المنع فارغة.',
'ipblocklist-no-results'      => 'عنوان الأيبي أو اسم المستخدم المطلوب غير ممنوع.',
'blocklink'                   => 'منع',
'unblocklink'                 => 'رفع المنع',
'contribslink'                => 'مساهمات',
'autoblocker'                 => 'تم منعك تلقائيا لأن الأيبي الخاص بك تم استخدامه مؤخرا بواسطة "[[User:$1|$1]]". السبب المعطى لمنع $1 هو: "$2"',
'blocklogpage'                => 'سجل المنع',
'blocklogentry'               => 'منع "[[$1]]" لفترة زمنية مدتها $2 $3',
'blocklogtext'                => 'هذا سجل بعمليات المنع ورفع المنع. عناوين الأيبي الممنوعة تلقائيا ليست معروضة. انظر [[Special:Ipblocklist|عناوين الأيبي الممنوعة]] لرؤية عمليات المنع المفعلة حاليا.',
'unblocklogentry'             => 'رفع منع $1',
'block-log-flags-anononly'    => 'المستخدمون المجهولون فقط',
'block-log-flags-nocreate'    => 'إنشاء الحسابات ممنوع',
'block-log-flags-noautoblock' => 'المنع التلقائي معطل',
'block-log-flags-noemail'     => 'البريد الإلكتروني ممنوع',
'range_block_disabled'        => 'إمكانية الإداري لمنع نطاق معطلة.',
'ipb_expiry_invalid'          => 'تاريخ الانتهاء غير صحيح.',
'ipb_already_blocked'         => 'سبق منع "$1"',
'ipb_cant_unblock'            => 'خطأ: لم يتم إيجاد الممنوع $1. ربما تم رفع منعه بالفعل.',
'ipb_blocked_as_range'        => 'خطأ: الأيبي $1 ليس ممنوعا مباشرة ولا يمكن رفع المنع عنه. لكنه، على أية حال، ممنوع كجزء من النطاق $2، والذي يمكن رفع المنع عنه.',
'ip_range_invalid'            => 'نطاق عناوين الأيبي المدخل غير صحيح.',
'blockme'                     => 'منعي',
'proxyblocker'                => 'مانع البروكسي',
'proxyblocker-disabled'       => 'هذه الخاصية معطلة.',
'proxyblockreason'            => 'تم منع عنوان الأيبي الخاص بك لكونه بروكسي مفتوح. قم بمراسلة مزود خدمة الإنترنت الخاص بك أو الدعم الفني وأعلمهم بهذه المشكلة الأمنية.',
'proxyblocksuccess'           => 'تم.',
'sorbs'                       => 'دي إن إس بي إل',
'sorbsreason'                 => 'عنوان الأيبي الخاص بك موجود كبروكسي مفتوح في DNSBL المستخدم بواسطة {{SITENAME}}.',
'sorbs_create_account_reason' => 'عنوان الأيبي الخاص بك موجود كبروكسي مفتوح في DNSBL المستخدم بواسطة {{SITENAME}}. لا يمكنك إنشاء حساب.',

# Developer tools
'lockdb'              => 'أقفل قاعدة البيانات',
'unlockdb'            => 'افتح قاعدة البيانات',
'lockdbtext'          => 'إغلاق قاعدة البيانات سوف يمنع جميع المستخدمين من تحرير الصفحات وتغيير التفضيلات الخاصة بهم وتعديل قائمة المراقبة وغير ذلك من الأمور المتطلبة التعديل على قاعدة البيانات. الرجاء التأكد من أن هذا حقا ما ترغب القيام به، ومن أنك سوف تقوم بإزالة الغلق بعد الانتهاء من الصيانة.',
'unlockdbtext'        => 'فتح قاعدة البيانات سيسترجع قدرة كل المستخدمين على تحرير الصفحات، تغيير تفضيلاتهم
، تعديل قوائم المراقبة الخاصة بهم، و
أشياء أخرى تحتاج التغيير في قاعدة البيانات.
من فضلك أكد أن هذا هو ما تريده.',
'lockconfirm'         => 'نعم، أنا متأكد أني أريد قفل قاعدة البيانات.',
'unlockconfirm'       => 'نعم، أريد فعلا فتح قاعدة البيانات.',
'lockbtn'             => 'أقفل قاعدة البيانات',
'unlockbtn'           => 'فتح قاعدة البيانات',
'locknoconfirm'       => 'لم تقم باختيار خانة التأكيد.',
'lockdbsuccesssub'    => 'نجح إقفال قاعدة البيانات',
'unlockdbsuccesssub'  => 'تم إزالة قفل قاعدة البيانات',
'lockdbsuccesstext'   => 'لقد أغلقت قاعدة البيانات.
<br />تذكر أن [[Special:Unlockdb|تزيل الغلق]] بعد اكتمال أعمال الصيانة.',
'unlockdbsuccesstext' => 'تم إعادة فتح قاعدة البيانات',
'lockfilenotwritable' => 'ملف غلق قاعدة البيانات لا يمكن الكتابة عليه. لغلق قاعدة البيانات أو إزالة الغلق يجب أن يكون هذا الملف قابلا للكتابة من قبل الخادم.',
'databasenotlocked'   => 'قاعدة البيانات ليست مغلقة.',

# Move page
'movepage'                => 'نقل صفحة',
'movepagetext'            => "باستعمال النموذج أدناه بإمكانك أن تغير اسم الصفحة، وأن تنقل تاريخها للاسم الجديد.
سيتم إنشاء تحويلة من العنوان القديم للصفحة بالعنوان الجديد. لكن، لن يتم تغيير الوصلات في الصفحات التي تتصل بهذه الصفحة، لذا عليك التأكد من عدم وجود وصلات مقطوعة، أو وصلات متتالية، للتأكد من أن المقالات تتصل مع بعضها بشكل مناسب.

يرجى الملاحظة أنه '''لن يتم''' نقل الصفحة إذا وجدت صفحة بالاسم الجديد، إلا إذا كانت صفحة فارغة، أو صفحة تحويل، ولا تاريخ لها. وهذا يعني أنك لا تستطيع وضع صفحة مكان صفحة، كما أنه من الممكن ارجاع الصفحة لمكانها في حال تم النقل بشكل خاطئ.

<b>تحذير!</b> قد يكون لنقل الصفحة آثار كبيرة، وتغييرات غير متوقع بالنسبة للصفحات المشهورة. يرجى فهم وإدارك عواقب نقل الصفحات قبل القيام به.",
'movepagetalktext'        => 'صفحة النقاش المرفقة بالمقالة سيتم نقلها كذلك، إذا وجدت. ولكن لا يتم نقل صفحة النقاش في الحالات التالية:
* نقل الصفحة عبر نطاقات  مختلفة.
* يوجد صفحة نقاش غير فارغة تحت العنوان الجديد للمقالة.
* قمت بإزالة اختيار نقل صفحة النقاش في الأسفل.

وفي الحالات أعلاه، يجب عليك نقل أو دمج محتويات صفحة النقاش يدويا، إذا رغب في ذلك.',
'movearticle'             => 'انقل الصفحة:',
'movenologin'             => 'غير مسجل',
'movenologintext'         => 'يجب أن تكون مستخدما مسجلا وأن تقوم [[Special:Userlogin|بالدخول]] لكي تنقل صفحة.',
'movenotallowed'          => 'لا تمتلك الصلاحية لنقل الصفحات في {{SITENAME}}.',
'newtitle'                => 'إلى العنوان الجديد:',
'move-watch'              => 'راقب هذه الصفحة',
'movepagebtn'             => 'نقل الصفحة',
'pagemovedsub'            => 'نقلت بنجاح',
'movepage-moved'          => '<big>\'\'\'"$1" نقلت إلى "$2"\'\'\'</big>', # The two titles are passed in plain text as $3 and $4 to allow additional goodies in the message.
'articleexists'           => 'توجد صفحة بهذا الاسم،
أو أن الاسم الذي تم اختياره غير صالح.
يرجى اختيار اسم آخر.',
'cantmove-titleprotected' => 'أنت لا يمكنك نقل صفحة إلى هذا الموقع، لأن العنوان الجديد تمت حمايته ضد الإنشاء',
'talkexists'              => "'''نقلت الصفحة بنجاح، ولكن لم تنقل صفحة النقاش المرافقة لوجود صفحة نقاش مسبقا تحت العنوان الجديد. يرجى نقل محتويات صفحة النقاش يدويا، ودمجها مع المحتويات السابقة.'''",
'movedto'                 => 'تم نقلها إلى',
'movetalk'                => 'انقل صفحة النقاش.',
'talkpagemoved'           => 'تم نقل صفحة النقاش أيضا.',
'talkpagenotmoved'        => '<strong>لم</strong> يتم نقل صفحة النقاش.',
'1movedto2'               => '[[$1]] تم نقلها إلى [[$2]]',
'1movedto2_redir'         => '[[$1]] تم نقلها إلى [[$2]] فوق التحويلة',
'movelogpage'             => 'سجل النقل',
'movelogpagetext'         => 'بالأسفل قائمة بالصفحات التي تم نقلها.',
'movereason'              => 'السبب:',
'revertmove'              => 'استرجاع',
'delete_and_move'         => 'حذف ونقل',
'delete_and_move_text'    => '==يستلزم الحذف==

هناك صفحة تحت الاسم "[[$1]]" الذي طلبت أن تنقل إليه هذه الصفحة. هل تريد حذفها لإفساح المجال للنقل؟',
'delete_and_move_confirm' => 'نعم، احذف الصفحة',
'delete_and_move_reason'  => 'تم الحذف لإفساح مجال للنقل',
'selfmove'                => 'لا يوجد اختلاف في عنوان المصدر و الهدف؛ لا يمكن نقل الصفحة على نفسها.',
'immobile_namespace'      => 'لا يمكن النقل إلى العنوان المراد؛ النطاق غير مسموح بالنقل إليه.',

# Export
'export'            => 'تصدير صفحات',
'exporttext'        => 'يمكنك تصدير النص وتاريخ تعديلات صفحة أو مجموعة صفحات خاصة في صيغة إكس إم إل. وذلك بقصد استيرادها في ويكي آخر يستعمل ميدياويكي بواسطة الصفحة [[Special:Import|صفحة الاستيراد]].

لتصدير صفحات، اكتب العناوين في الصندوق أسفله، عنوان واحد في كل السطر، مع اختيار ما إذا كنت ترغب في النسخة الحالية بالإضافة إلى النسخ القديمة كاملة أو مع معلومات تاريخ الصفحة عنها أو فقط النسخة الحالية مع معلومات عن التعديل الأخير.

في الحالة الأخيرة يمكنك استخدام وصلة مباشرة، كمثال [[{{ns:special}}:Export/{{Mediawiki:mainpage}}]] للصفحة {{Mediawiki:mainpage}}.',
'exportcuronly'     => 'ضمن النسخة الحالية فقط، وليس تاريخ الصفحة بأكمله',
'exportnohistory'   => "----
ملاحظة:''' تم توقيف التصدير الكامل لتاريخ الصفحة بهذه الترسيمة لأسباب تحسينية'''",
'export-submit'     => 'تصدير',
'export-addcattext' => 'إضافة صفحات من تصنيف:',
'export-addcat'     => 'إضافة',
'export-download'   => 'اعرض الحفظ كملف',
'export-templates'  => 'ضمن القوالب',

# Namespace 8 related
'allmessages'               => 'رسائل النظام',
'allmessagesname'           => 'الاسم',
'allmessagesdefault'        => 'النص الافتراضي',
'allmessagescurrent'        => 'النص الحالي',
'allmessagestext'           => 'هذه قائمة برسائل النظام المتوفرة في نطاق ميدياويكي.',
'allmessagesnotsupportedDB' => "لا يمكن استخدام '''{{ns:special}}:Allmessages''' لأن المتغير '''\$wgUseDatabaseMessages''' غير مشغل.",
'allmessagesfilter'         => 'بحث باسم الرسالة:',
'allmessagesmodified'       => 'اعرض المتغير فقط',

# Thumbnails
'thumbnail-more'           => 'تكبير',
'filemissing'              => 'الملف مفقود',
'thumbnail_error'          => 'خطأ في إنشاء صورة مصغرة: $1',
'djvu_page_error'          => 'صفحة DjVu خارج النطاق',
'djvu_no_xml'              => 'لا يمكن جلب XML لملف DjVu',
'thumbnail_invalid_params' => 'محددات التصغير غير صحيحة',
'thumbnail_dest_directory' => 'غير قادر على إنشاء المجلد الهدف',

# Special:Import
'import'                     => 'استيراد صفحات',
'importinterwiki'            => 'استيراد ترانسويكي',
'import-interwiki-text'      => 'اختر الويكي و عنوان الصفحة المطلوب استيرادها.
تواريخ التعديلات و أسماء المحررين سيتم الحفاظ عليها.
كل عمليات الاستيراد عبر مواقع الويكي يتم تسجيلها في [[Special:Log/import|سجل الاستيراد]].',
'import-interwiki-history'   => 'انسخ كل نسخ التاريخ لهذه الصفحة',
'import-interwiki-submit'    => 'استيراد',
'import-interwiki-namespace' => 'انقل الصفحات إلى النطاق:',
'importtext'                 => 'من فضلك صدّر الملف من الويكي المصدر عن طريق Special:Export، احفظها على جهازك ثم ارفعها هنا.',
'importstart'                => 'استيراد صفحات...',
'import-revision-count'      => '{{PLURAL:$1|نسخة واحدة|نسخة}} $1',
'importnopages'              => 'لا صفحات للاستيراد',
'importfailed'               => 'فشل استيراد: $1',
'importunknownsource'        => 'نوع مجهول لمصدر الاستيراد',
'importcantopen'             => 'لم يمكن فتح ملف الاستيراد',
'importbadinterwiki'         => 'وصلة إنترويكي خاطئة',
'importnotext'               => 'فارغ أو لا نص',
'importsuccess'              => 'الاستيراد انتهى!',
'importhistoryconflict'      => 'هناك تاريخ تعديلات يتعارض مع تاريخ هذه الصفحة (ربما تكون قد استوردت الصفحة من قبل)',
'importnosources'            => 'لم يتم تحديد مصادر للاستيراد الويكي و الاستيراد المباشر عن طريق الرفع غير فعال.',
'importnofile'               => 'لم يتم رفع ملف استيراد.',
'importuploaderrorsize'      => 'رفع ملف الاستيراد فشل. الملف أكبر من حجم الرفع المسموح.',
'importuploaderrorpartial'   => 'رفع ملف الاستيراد فشل. الملف تم رفعه جزئيا.',
'importuploaderrortemp'      => 'رفع ملف الاستيراد فشل. هناك مجلد مؤقت مفقود.',
'import-parse-failure'       => 'فشل بارس استيراد XML',
'import-noarticle'           => 'لا صفحة للاستيراد!',
'import-nonewrevisions'      => 'كل النسخ تم استيرادها من قبل.',
'xml-error-string'           => '$1 عند السطر $2، العمود $3 (بايت $4): $5',

# Import log
'importlogpage'                    => 'سجل الاستيراد',
'importlogpagetext'                => 'استيرادات إدارية (للإداريين فقط) لصفحات من مواقع ويكي أخرى.',
'import-logentry-upload'           => 'استورد [[$1]] بواسطة رفع ملف',
'import-logentry-upload-detail'    => '$1 {{PLURAL:$1|تعديل واحد|تعديل}}',
'import-logentry-interwiki'        => 'استيراد ويكي $1',
'import-logentry-interwiki-detail' => '$1 {{PLURAL:$1|تعديل واحد|تعديل}} من $2',

# Tooltip help for the actions
'tooltip-pt-userpage'             => 'صفحتي الخاصة',
'tooltip-pt-anonuserpage'         => 'صفحة المستخدم للأيبي الذي تقوم بالتحرير من خلاله',
'tooltip-pt-mytalk'               => 'صفحة نقاشي',
'tooltip-pt-anontalk'             => 'نقاش حول التعديلات من عنوان الأيبي هذا',
'tooltip-pt-preferences'          => 'تفضيلاتي',
'tooltip-pt-watchlist'            => 'قائمة بالصفحات التي تقوم بمراقبة التغييرات التي تحدث فيها',
'tooltip-pt-mycontris'            => 'قائمة مساهماتي',
'tooltip-pt-login'                => 'من المفضل أن تقوم بتسجيل الدخول، هذا ليس إلزاميا.',
'tooltip-pt-anonlogin'            => 'من المفضل أن تقوم بتسجيل الدخول، هذا ليس إلزاميا.',
'tooltip-pt-logout'               => 'خروج',
'tooltip-ca-talk'                 => 'نقاش حول صفحة المحتوى',
'tooltip-ca-edit'                 => 'بإمكانك تعديل هذه الصفحة، برجاء استعمال زر عرض مسبق قبل الحفظ',
'tooltip-ca-addsection'           => 'أضف تعليقا إلى هذا النقاش.',
'tooltip-ca-viewsource'           => 'هذه الصفحة محمية. يمكنك رؤية مصدرها.',
'tooltip-ca-history'              => 'النسخ السابقة من هذه الصفحة',
'tooltip-ca-protect'              => 'احم هذه الصفحة',
'tooltip-ca-delete'               => 'احذف هذه الصفحة',
'tooltip-ca-undelete'             => 'استرجاع التعديلات التي تمت على هذه الصفحة قبل حذفها',
'tooltip-ca-move'                 => 'انقل هذه الصفحة',
'tooltip-ca-watch'                => 'أضف هذه الصفحة إلى قائمة مراقبتك',
'tooltip-ca-unwatch'              => 'أزل هذه الصفحة من قائمة مراقبتك',
'tooltip-search'                  => 'ابحث في {{SITENAME}}',
'tooltip-search-go'               => 'اذهب إلى صفحة بنفس هذا الاسم إن وجدت',
'tooltip-search-fulltext'         => 'ابحث في الصفحات عن هذا النص',
'tooltip-p-logo'                  => 'الصفحة الرئيسية',
'tooltip-n-mainpage'              => 'زيارة الصفحة الرئيسية',
'tooltip-n-portal'                => 'حول المشروع، ماذا يمكن أن تفعل، أين يمكن أن تجد ما تحتاجه',
'tooltip-n-currentevents'         => 'مطالعة سريعة لأهم الأحداث الجارية',
'tooltip-n-recentchanges'         => 'قائمة بأحدث التغييرات في الويكي.',
'tooltip-n-randompage'            => 'حمل صفحة عشوائية',
'tooltip-n-help'                  => 'تحتاج مساعدة؟ طالع هذه الصفحة!',
'tooltip-n-sitesupport'           => 'ادعمنا',
'tooltip-t-whatlinkshere'         => 'قائمة بكل الصفحات في الويكي التي تصل هنا',
'tooltip-t-recentchangeslinked'   => 'أحدث التغييرات في الصفحات الموجودة وصلاتها هنا.',
'tooltip-feed-rss'                => 'تلقيم أر إس إس لهذه الصفحة',
'tooltip-feed-atom'               => 'تلقيم أتوم لهذه الصفحة',
'tooltip-t-contributions'         => 'عرض قائمة مساهمات هذا المستخدم',
'tooltip-t-emailuser'             => 'أرسل رسالة لهذا المستخدم',
'tooltip-t-upload'                => 'رفع ملفات',
'tooltip-t-specialpages'          => 'قائمة بكل الصفحات الخاصة',
'tooltip-t-print'                 => 'نسخة للطباعة لهذه الصفحة',
'tooltip-t-permalink'             => 'وصلة دائمة لهذه النسخة من الصفحة',
'tooltip-ca-nstab-main'           => 'اعرض صفحة المحتوى',
'tooltip-ca-nstab-user'           => 'اعرض صفحة المستخدم',
'tooltip-ca-nstab-media'          => 'اعرض صفحة ملف الميديا',
'tooltip-ca-nstab-special'        => 'هذه صفحة خاصة، لا تستطيع أن تعدل الصفحة نفسها',
'tooltip-ca-nstab-project'        => 'اعرض صفحة المشروع',
'tooltip-ca-nstab-image'          => 'اعرض صفحة الملف',
'tooltip-ca-nstab-mediawiki'      => 'اعرض رسالة النظام',
'tooltip-ca-nstab-template'       => 'اعرض القالب',
'tooltip-ca-nstab-help'           => 'اعرض صفحة المساعدة',
'tooltip-ca-nstab-category'       => 'اعرض صفحة التصنيف',
'tooltip-minoredit'               => 'علم على هذا كتعديل طفيف',
'tooltip-save'                    => 'احفظ تغييراتك',
'tooltip-preview'                 => 'اعرض تغييراتك، من فضلك استخدم هذا قبل الحفظ!',
'tooltip-diff'                    => 'اعرض التغييرات التي قمت بها للنص.',
'tooltip-compareselectedversions' => 'شاهد الفروق بين النسختين المختارتين من هذه الصفحة.',
'tooltip-watch'                   => 'أضف هذه الصفحة إلى قائمة مراقبتك',
'tooltip-recreate'                => 'أعد إنشاء الصفحة رغم كونها حذفت',
'tooltip-upload'                  => 'ابدأ الرفع',

# Stylesheets
'common.css'   => '/** النظم المتراصة CSS الموضوعة هنا سيتم تطبيقها على كل الواجهات  */',
'monobook.css' => '/* الأنماط المتراصة CSS المعروضة هنا ستؤثر على مستخدمي واجهة المونوبوك */',

# Scripts
'common.js'   => '/* الجافاسكريبت الموضوع هنا سيتم تحميله لكل المستخدمين مع كل تحميل للصفحة. */',
'monobook.js' => '/* تم الاستغناء عنها؛ استخدم [[MediaWiki:common.js]] */',

# Metadata
'nodublincore'      => 'Dublin Core RDF metadata معطلة لهذا الخادم.',
'nocreativecommons' => 'Creative Commons RDF metadata معطلة لهذا الخادم.',
'notacceptable'     => 'لا يمكن لخادم الويكي تزويدك ببيانات بصيغة يستطيع عميلك قراءتها.',

# Attribution
'anonymous'        => 'مستخدم مجهول ل{{SITENAME}}',
'siteuser'         => 'مستخدم {{SITENAME}} $1',
'lastmodifiedatby' => 'آخر تعديل لهذه الصفحة كان في $2، $1 بواسطة $3.', # $1 date, $2 time, $3 user
'othercontribs'    => 'بناء على عمل $1.',
'others'           => 'أخرى',
'siteusers'        => '{{SITENAME}} مستخدم(و) $1',
'creditspage'      => 'حقوق الصفحة',
'nocredits'        => 'لا توجد معلومات حقوق متوفرة لهذه الصفحة.',

# Spam protection
'spamprotectiontitle'    => 'فلتر الحماية من السخام',
'spamprotectiontext'     => 'تم منع حفظ الصفحة عن طريق مانع السخام. من المحتمل أن يكون هذا بسبب وصلة خارجية.',
'spamprotectionmatch'    => 'النص التالي هو ما نشط مانع السخام الخاص بنا: $1',
'subcategorycount'       => 'يوجد {{PLURAL:$1|تصنيف فرعي واحد|تصنيفان فرعيان|$1 تصنيفات فرعية|$1 تصنيف فرعي|$1 تصنيفا فرعيا}} في هذا التصنيف.',
'categoryarticlecount'   => 'يوجد {{PLURAL:$1|مقال واحد|مقالان|$1 مقالات|$1 مقال|$1 مقالا}} في هذا التصنيف.',
'category-media-count'   => 'يوجد {{PLURAL:$1|ملف واحد|$1 ملفات}} في هذا التصنيف.',
'listingcontinuesabbrev' => 'متابعة',
'spambot_username'       => 'تنظيف سخام ميدياويكي',
'spam_reverting'         => 'استرجاع آخر نسخة ليس بها وصلات إلى $1',
'spam_blanking'          => 'كل النسخ احتوت على وصلات ل $1، إفراغ',

# Info page
'infosubtitle'   => 'المعلومات للصفحة',
'numedits'       => 'عدد التعديلات (صفحة): $1',
'numtalkedits'   => 'عدد التعديلات (صفحة نقاش): $1',
'numwatchers'    => 'عدد المراقبين: $1',
'numauthors'     => 'عدد المحررين (صفحة): $1',
'numtalkauthors' => 'عدد المحررين (صحفة نقاش): $1',

# Math options
'mw_math_png'    => 'دائما اعرض على هيئة PNG',
'mw_math_simple' => 'اعرض على هيئة HTML للصيغ البسيطة جدا، وإلا فاعرض بهئية PNG',
'mw_math_html'   => 'اعرض بصيغة HTML إن أمكن، وإلا فاعرض كهيئة PNG',
'mw_math_source' => 'اعرض على هيئة TeX (للمتصفحات النصية)',
'mw_math_modern' => 'مستحسن للمتصفحات الحديثة',
'mw_math_mathml' => 'اعرض بصيغة MathML إن أمكن (تحت التجريب)',

# Patrolling
'markaspatrolleddiff'                 => 'تمت مراجعتها',
'markaspatrolledtext'                 => 'هذه المقالة تمت مراجعتها',
'markedaspatrolled'                   => 'تمت مراجعتها',
'markedaspatrolledtext'               => 'تمت الإشارة إلى النسخة المختارة كمراجعة.',
'rcpatroldisabled'                    => 'مراجعة أحدث التغييرات معطلة',
'rcpatroldisabledtext'                => 'خاصية مراجعة أحدث التغييرات معطلة حاليا',
'markedaspatrollederror'              => 'لا يمكن التعليم بالمراجعة',
'markedaspatrollederrortext'          => 'يجب عليك اختيار النسخة التي تريد أن تشير أنها مراجعة',
'markedaspatrollederror-noautopatrol' => 'من غير المسموح لك التعليم على تغييراتك الشخصية كمراجعة.',

# Patrol log
'patrol-log-page' => 'سجل المراجعة',
'patrol-log-line' => 'علم على $1 من $2 كمراجعة $3',
'patrol-log-auto' => '(تلقائيا)',
'patrol-log-diff' => 'ن$1',

# Image deletion
'deletedrevision'                 => 'حذف النسخة القديمة $1',
'filedeleteerror-short'           => 'خطأ حذف الملف: $1',
'filedeleteerror-long'            => 'حدثت أخطاء أثناء حذف الملف:

$1',
'filedelete-missing'              => 'الملف "$1" لم يمكن حذفه، لأنه غير موجود.',
'filedelete-old-unregistered'     => 'نسخة الملف المحددة "$1" ليست في قاعدة البيانات.',
'filedelete-current-unregistered' => 'الملف المحدد "$1" ليس في قاعدة البيانات.',
'filedelete-archive-read-only'    => 'مجلد الأرشيف "$1" لا يمكن الكتابة عليه بواسطة خادم الويب.',

# Browsing diffs
'previousdiff' => '→ الفرق السابق',
'nextdiff'     => 'الفرق اللاحق ←',

# Media information
'mediawarning'         => "'''تحذير''': هذا الملف يحتوي على كود خبيث، يمكن عند تشغيله السيطرة على نظامك.<hr />",
'imagemaxsize'         => 'حدد الصور في صفحات وصف الملفات إلى:',
'thumbsize'            => 'حجم العرض المصغر:',
'widthheightpage'      => '$1×$2، $3 صفحات',
'file-info'            => '(حجم الملف: $1، نوع MIME: $2)',
'file-info-size'       => '($1 × $2 بكسل حجم الملف: $3، نوع MIME: $4)',
'file-nohires'         => '<small>لا توجد دقة أعلى متوفرة.</small>',
'svg-long-desc'        => '(ملف SVG، أساسا $1 × $2 بكسل، حجم الملف: $3)',
'show-big-image'       => 'الصورة بدقة كاملة',
'show-big-image-thumb' => '<small>حجم هذا العرض: $1 × $2 بكسل</small>',

# Special:Newimages
'newimages'    => 'معرض الصور الجديدة',
'showhidebots' => '($1 بوتات)',
'noimages'     => 'لا شيء للعرض.',

# Video information, used by Language::formatTimePeriod() to format lengths in the above messages
'video-dims'     => '$1، $2×$3',
'seconds-abbrev' => 'ث',
'minutes-abbrev' => 'ق',
'hours-abbrev'   => 'س',

# Bad image list
'bad_image_list' => 'الصيغة كالتالي:

فقط عناصر القائمة (السطور التي تبدأ ب *) يتم أخذها في الاعتبار. أول وصلة في السطر يجب أن تكون وصلة لملف سيىء.
أي وصلات تالية في نفس السطر سيتم اعتبارها استثناءات، بمعنى آخر مقالات حيث الملف يمكن أن يكون موجودا.',

# Metadata
'metadata'          => 'بيانات ميتا',
'metadata-help'     => 'هذا الملف يحتوي على معلومات إضافية، غالبا ما تكون أضيفت من قبل الكاميرا الرقمية أو الماسح الضوئي المستخدم في نقل الملف إلى الحاسوب. إذا كان الملف قد عدل عن حالته الأصلية، فبعض التفاصيل قد لا تعبر عن الملف المعدل.',
'metadata-expand'   => 'عرض التفاصيل الإضافية',
'metadata-collapse' => 'إخفاء التفاصيل الإضافية',
'metadata-fields'   => 'حقول معطيات الميتا EXIF الموجودة في هذه الرسالة سوف تعرض في صفحة الصورة عندما يكون جدول معطيات الميتا مضغوطا. الحقول الأخرى ستكون مخفية افتراضيا.
* make
* model
* datetimeoriginal
* exposuretime
* fnumber
* focallength', # Do not translate list items

# EXIF tags
'exif-imagewidth'                  => 'العرض',
'exif-imagelength'                 => 'الطول',
'exif-bitspersample'               => 'بت لكل مكون',
'exif-compression'                 => 'نظام الضغط',
'exif-photometricinterpretation'   => 'تركيب البكسل',
'exif-orientation'                 => 'التوجيه',
'exif-samplesperpixel'             => 'عدد المكونات',
'exif-planarconfiguration'         => 'ترتيب البيانات',
'exif-ycbcrsubsampling'            => 'نسبة العينة الفرعية لY إلى C',
'exif-ycbcrpositioning'            => 'وضع Y و C',
'exif-xresolution'                 => 'الدقة الأفقية',
'exif-yresolution'                 => 'الدقة الرأسية',
'exif-resolutionunit'              => 'وحدة تحليل X و Y',
'exif-stripoffsets'                => 'موقع بيانات الصورة',
'exif-rowsperstrip'                => 'عدد الصفوف لكل ستريب',
'exif-stripbytecounts'             => 'بايت لكل ستريب مضغوط',
'exif-jpeginterchangeformat'       => 'الحد ل JPEG SOI',
'exif-jpeginterchangeformatlength' => 'بايت من بيانات JPEG',
'exif-transferfunction'            => 'وظيفة النقل',
'exif-whitepoint'                  => 'ألوان النقطة البيضاء',
'exif-primarychromaticities'       => 'ألوان الأساسيات',
'exif-ycbcrcoefficients'           => 'معاملات مصفوفة تحويل فراغ اللون',
'exif-referenceblackwhite'         => 'زوج من قيم المرجع السوداء والبيضاء',
'exif-datetime'                    => 'تاريخ و وقت تغيير الملف',
'exif-imagedescription'            => 'عنوان الصورة',
'exif-make'                        => 'منتج آلة التصوير',
'exif-model'                       => 'نوع آلة التصوير',
'exif-software'                    => 'البرمجيات المستخدمة',
'exif-artist'                      => 'المؤلف',
'exif-copyright'                   => 'مالك الحقوق المحفوظة',
'exif-exifversion'                 => 'Exif نسخة',
'exif-flashpixversion'             => 'نسخة فلاش بكس المدعومة',
'exif-colorspace'                  => 'فرق اللون',
'exif-componentsconfiguration'     => 'معنى كل مكون',
'exif-compressedbitsperpixel'      => 'طور ضغط الصورة',
'exif-pixelydimension'             => 'عرض صورة صحيح',
'exif-pixelxdimension'             => 'ارتفاع صورة صحيح',
'exif-makernote'                   => 'ملاحظات الصانع',
'exif-usercomment'                 => 'تعليقات المستخدم',
'exif-relatedsoundfile'            => 'ملف صوتي مرتبط',
'exif-datetimeoriginal'            => 'تاريخ و وقت الإنتاج',
'exif-datetimedigitized'           => 'تاريخ و وقت التحويل الرقمي',
'exif-subsectime'                  => 'وقت تاريخ ثواني فرعية',
'exif-subsectimeoriginal'          => 'وقت تاريخ أصلي ثواني فرعية',
'exif-subsectimedigitized'         => 'وقت تاريخ رقمي ثواني فرعية',
'exif-exposuretime'                => 'مدة التعرض',
'exif-exposuretime-format'         => '$1 ثانية ($2)',
'exif-fnumber'                     => 'العدد البؤري',
'exif-fnumber-format'              => 'البعد البؤري/$1',
'exif-exposureprogram'             => 'برنامج التعرض',
'exif-spectralsensitivity'         => 'الحساسية الطيفية',
'exif-isospeedratings'             => 'تقييم سرعة أيزو',
'exif-oecf'                        => 'عامل التحويل الكهروضوئي',
'exif-shutterspeedvalue'           => 'سرعة الغالق',
'exif-aperturevalue'               => 'فتحة الغالق',
'exif-brightnessvalue'             => 'السطوع',
'exif-exposurebiasvalue'           => 'تعويض التعرض',
'exif-maxaperturevalue'            => 'أقصى غالق أرضي',
'exif-subjectdistance'             => 'مسافة الجسم',
'exif-meteringmode'                => 'طور القياس بالمتر',
'exif-lightsource'                 => 'مصدر الضوء',
'exif-flash'                       => 'فلاش',
'exif-focallength'                 => 'البعد البؤري للعدسة',
'exif-focallength-format'          => '$1 ملم',
'exif-subjectarea'                 => 'مساحة الجسم',
'exif-flashenergy'                 => 'طاقة الفلاش',
'exif-spatialfrequencyresponse'    => 'استجابة التردد الفراغي',
'exif-focalplanexresolution'       => 'تحليل المستوى البؤري X',
'exif-focalplaneyresolution'       => 'تحليل المستوى البؤري Y',
'exif-focalplaneresolutionunit'    => 'وحدة تحليل المستوى البؤري',
'exif-subjectlocation'             => 'موضع الجسم',
'exif-exposureindex'               => 'فهرس التعرض',
'exif-sensingmethod'               => 'وسيلة الاستشعار',
'exif-filesource'                  => 'مصدر الملف',
'exif-scenetype'                   => 'نوع المشهد',
'exif-cfapattern'                  => 'نمط سي إف إيه',
'exif-customrendered'              => 'معالجة الصورة حسب الطلب',
'exif-exposuremode'                => 'طور التعرض',
'exif-whitebalance'                => 'توازن الأبيض',
'exif-digitalzoomratio'            => 'نسبة الزوم الرقمية',
'exif-focallengthin35mmfilm'       => 'البعد البؤري في فيلم 35 مم',
'exif-scenecapturetype'            => 'نوع إمساك المشهد',
'exif-gaincontrol'                 => 'التحكم بالمشهد',
'exif-contrast'                    => 'التعارض',
'exif-saturation'                  => 'التشبع',
'exif-sharpness'                   => 'الحدة',
'exif-devicesettingdescription'    => 'وصف إعدادات الأداة',
'exif-subjectdistancerange'        => 'نطاق مسافة الجسم',
'exif-imageuniqueid'               => 'رقم الصورة الفريد',
'exif-gpsversionid'                => 'نسخة وسم GPS',
'exif-gpslatituderef'              => 'شمال أو جنوب خطوط العرض',
'exif-gpslatitude'                 => 'خط العرض',
'exif-gpslongituderef'             => 'شرق أو غرب خطوط الطول',
'exif-gpslongitude'                => 'خط الطول',
'exif-gpsaltituderef'              => 'مرجع الارتفاع',
'exif-gpsaltitude'                 => 'الارتفاع',
'exif-gpstimestamp'                => 'GPS وقت (ساعة ذرية)',
'exif-gpssatellites'               => 'الأقمار الصناعية المستخدمة في القياس',
'exif-gpsstatus'                   => 'حالة جهاز الاستقبال',
'exif-gpsmeasuremode'              => 'طور القياس',
'exif-gpsdop'                      => 'دقة القياس',
'exif-gpsspeedref'                 => 'وحدة السرعة',
'exif-gpsspeed'                    => 'سرعة مستقبل جي بي إس',
'exif-gpstrackref'                 => 'المرجع لاتجاه الحركة',
'exif-gpstrack'                    => 'اتجاه الحركة',
'exif-gpsimgdirectionref'          => 'المرجغ لاتجاه الصورة',
'exif-gpsimgdirection'             => 'اتجاه الصورة',
'exif-gpsmapdatum'                 => 'بيانات استطلاع الجيوديسيك المستخدمة',
'exif-gpsdestlatituderef'          => 'المرجع لخط عرض الوجهة',
'exif-gpsdestlatitude'             => 'خط عرض الوجهة',
'exif-gpsdestlongituderef'         => 'المرجع لخط طول الوجهة',
'exif-gpsdestlongitude'            => 'خط طول الوجهة',
'exif-gpsdestbearingref'           => 'المرجع لتحمل الوجهة',
'exif-gpsdestbearing'              => 'تحمل الوجهة',
'exif-gpsdestdistanceref'          => 'المرجع للمسافة للهدف',
'exif-gpsdestdistance'             => 'المسافة للهدف',
'exif-gpsprocessingmethod'         => 'اسم وسيلة معالجة جي بي إس',
'exif-gpsareainformation'          => 'اسم مساحة GPS',
'exif-gpsdatestamp'                => 'تاريخ GPS',
'exif-gpsdifferential'             => 'تصحيح GPS التفاضلي',

# EXIF attributes
'exif-compression-1' => 'غير مضغوط',
'exif-compression-6' => 'جيه بي إي جي',

'exif-photometricinterpretation-2' => 'آر جي بي',
'exif-photometricinterpretation-6' => 'واي سب سر',

'exif-unknowndate' => 'تاريخ غير معروف',

'exif-orientation-1' => 'وضعية طبيعية', # 0th row: top; 0th column: left
'exif-orientation-2' => 'دار عرضيا', # 0th row: top; 0th column: right
'exif-orientation-3' => 'دار 180°', # 0th row: bottom; 0th column: right
'exif-orientation-4' => 'دار أفقيا', # 0th row: bottom; 0th column: left
'exif-orientation-5' => 'دار 90° CCW و انزلق رأسيا', # 0th row: left; 0th column: top
'exif-orientation-6' => 'دار 90° CW', # 0th row: right; 0th column: top
'exif-orientation-7' => 'دار 90° CW و انزلق رأسيا', # 0th row: right; 0th column: bottom
'exif-orientation-8' => 'دار 90° عكس عقارب الساعة', # 0th row: left; 0th column: bottom

'exif-planarconfiguration-1' => 'صيغة تشنكي',
'exif-planarconfiguration-2' => 'الصيغة المستوية',

'exif-xyresolution-i' => '$1 نقطة لكل بوصة',
'exif-xyresolution-c' => '$1 دي بي سي',

'exif-colorspace-1'      => 'إس آر جي بي',
'exif-colorspace-ffff.h' => 'إف إف إف إف.إتش',

'exif-componentsconfiguration-0' => 'غير موجود',
'exif-componentsconfiguration-1' => 'واي',
'exif-componentsconfiguration-2' => 'سب',
'exif-componentsconfiguration-3' => 'سر',
'exif-componentsconfiguration-4' => 'آر',
'exif-componentsconfiguration-5' => 'جي',
'exif-componentsconfiguration-6' => 'بي',

'exif-exposureprogram-0' => 'غير معرف',
'exif-exposureprogram-1' => 'يدوي',
'exif-exposureprogram-2' => 'برنامج اعتيادي',
'exif-exposureprogram-3' => 'أولوية الغالق',
'exif-exposureprogram-4' => 'أولوية الإغلاق',
'exif-exposureprogram-5' => 'برنامج الصنع (يميل تجاه عمق الحقل)',
'exif-exposureprogram-6' => 'برنامج الفعل (يميل تجاه سرعة الغلق)',
'exif-exposureprogram-7' => 'طور البورتريه (لصور الإغلاق مع الخلفية بعيدا عن البؤرة)',
'exif-exposureprogram-8' => 'طور الأرضية (لصور الأرضية مع الخلفية في البؤرة)',

'exif-subjectdistance-value' => '$1 متر',

'exif-meteringmode-0'   => 'غير معروف',
'exif-meteringmode-1'   => 'متوسط',
'exif-meteringmode-2'   => 'متوسط موزون بالمركز',
'exif-meteringmode-3'   => 'بقعة',
'exif-meteringmode-4'   => 'مالتي سبوت',
'exif-meteringmode-5'   => 'نمط',
'exif-meteringmode-6'   => 'جزئي',
'exif-meteringmode-255' => 'غير ذلك',

'exif-lightsource-0'   => 'غير معروف',
'exif-lightsource-1'   => 'ضوء النهار',
'exif-lightsource-2'   => 'فلورسنت',
'exif-lightsource-3'   => 'تنجستين (ضوء مشع)',
'exif-lightsource-4'   => 'فلاش',
'exif-lightsource-9'   => 'جو صحو',
'exif-lightsource-10'  => 'جو ملبد بالغيوم',
'exif-lightsource-11'  => 'ظل',
'exif-lightsource-12'  => 'فلورسنت ضوء النهار (D 5700 – 7100K)',
'exif-lightsource-13'  => 'فلورسنت نهار أبيض (N 4600 – 5400K)',
'exif-lightsource-14'  => 'فلورسنت أبيض هادئ (W 3900 – 4500K)',
'exif-lightsource-15'  => 'فلورسنت أبيض (WW 3200 – 3700K)',
'exif-lightsource-17'  => 'ضوء قياسي A',
'exif-lightsource-18'  => 'ضوء قياسي B',
'exif-lightsource-19'  => 'ضوء قياسي C',
'exif-lightsource-20'  => 'دي55',
'exif-lightsource-21'  => 'دي65',
'exif-lightsource-22'  => 'دي75',
'exif-lightsource-23'  => 'دي50',
'exif-lightsource-24'  => 'تنجستين ستوديو أيزو',
'exif-lightsource-255' => 'مصدر ضوء آخر',

'exif-focalplaneresolutionunit-2' => 'بوصة',

'exif-sensingmethod-1' => 'غير معرف',
'exif-sensingmethod-2' => 'مستشعر لون المساحة من رقاقة واحدة',
'exif-sensingmethod-3' => 'مستشعر لون المساحة من رقاقتين',
'exif-sensingmethod-4' => 'مستشعر لون المساحة من ثلاث رقاقات',
'exif-sensingmethod-5' => 'مستشعر لون مساحة متتابع',
'exif-sensingmethod-7' => 'مستشعر خطي ثلاثي',
'exif-sensingmethod-8' => 'مستشعر لون خطي متتابع',

'exif-filesource-3' => 'دي إس سي',

'exif-scenetype-1' => 'صورة ملتقطة بشكل مباشر',

'exif-customrendered-0' => 'عملية طبيعية',
'exif-customrendered-1' => 'عملية حسب الطلب',

'exif-exposuremode-0' => 'تعرض تلقائي',
'exif-exposuremode-1' => 'تعرض يدوي',
'exif-exposuremode-2' => 'أوتو براكيت',

'exif-whitebalance-0' => 'توازن الأبيض تلقائي',
'exif-whitebalance-1' => 'توازن الأبيض يدوي',

'exif-scenecapturetype-0' => 'قياسي',
'exif-scenecapturetype-1' => 'أرضية',
'exif-scenecapturetype-2' => 'بورتريه',
'exif-scenecapturetype-3' => 'مشهد ليلي',

'exif-gaincontrol-0' => 'لا شيء',
'exif-gaincontrol-1' => 'تحكم أعلى منخفض',
'exif-gaincontrol-2' => 'تحكم أعلى مرتفع',
'exif-gaincontrol-3' => 'تحكم أسفل منخفض',
'exif-gaincontrol-4' => 'تحكم أسفل مرتفع',

'exif-contrast-0' => 'وضعية طبيعية',
'exif-contrast-1' => 'ناعم',
'exif-contrast-2' => 'قاسي',

'exif-saturation-0' => 'وضعية طبيعية',
'exif-saturation-1' => 'تشبع منخفض',
'exif-saturation-2' => 'تشبع عالي',

'exif-sharpness-0' => 'وضعية طبيعية',
'exif-sharpness-1' => 'ناعم',
'exif-sharpness-2' => 'قاسي',

'exif-subjectdistancerange-0' => 'غير معروف',
'exif-subjectdistancerange-1' => 'ماكرو',
'exif-subjectdistancerange-2' => 'رؤية قريبة',
'exif-subjectdistancerange-3' => 'رؤية بعيدة',

# Pseudotags used for GPSLatitudeRef and GPSDestLatitudeRef
'exif-gpslatitude-n' => 'دائرة العرض الشمالية',
'exif-gpslatitude-s' => 'دائرة العرض الجنوبية',

# Pseudotags used for GPSLongitudeRef and GPSDestLongitudeRef
'exif-gpslongitude-e' => 'خط الطول الشرقي',
'exif-gpslongitude-w' => 'خط الطول الغربي',

'exif-gpsstatus-a' => 'عملية القياس الحالية',
'exif-gpsstatus-v' => 'شمول القياس',

'exif-gpsmeasuremode-2' => 'عملية قياس ثنائية الأبعاد',
'exif-gpsmeasuremode-3' => 'عملية قياس ثلاثية الأبعاد',

# Pseudotags used for GPSSpeedRef and GPSDestDistanceRef
'exif-gpsspeed-k' => 'كيلومتر في الساعة',
'exif-gpsspeed-m' => 'ميل في الساعة',
'exif-gpsspeed-n' => 'عقد',

# Pseudotags used for GPSTrackRef, GPSImgDirectionRef and GPSDestBearingRef
'exif-gpsdirection-t' => 'الاتجاه الحقيقي',
'exif-gpsdirection-m' => 'الاتجاه المغناطيسي',

# External editor support
'edit-externally'      => 'عدل هذا الملف باستخدام تطبيق خارجي',
'edit-externally-help' => 'انظر [http://meta.wikimedia.org/wiki/Help:External_editors تعليمات الإعداد] لمزيد من المعلومات.',

# 'all' in various places, this might be different for inflected languages
'recentchangesall' => 'الكل',
'imagelistall'     => 'الكل',
'watchlistall2'    => 'الكل',
'namespacesall'    => 'الكل',
'monthsall'        => 'الكل',

# E-mail address confirmation
'confirmemail'            => 'أكد عنوان البريد الإلكتروني',
'confirmemail_noemail'    => 'ليس لديك عنوان بريد إلكتروني صحيح مسجل في [[Special:Preferences|تفضيلاتك]].',
'confirmemail_text'       => '{{SITENAME}} يتطلب تأكيد عنوانك الإلكتروني قبل استخدام خصائص البريد الإلكتروني. اضغط على زر التفعيل بالأسفل ليتم إرسال رسالة تأكيد لعنوانك. ستتضمن الرسالة رمز تفعيل؛ اضغط على الوصلة التي تحتوي الرمز لتأكيد أن عنوانك الإلكتروني صحيح.',
'confirmemail_pending'    => "<div class=\"error\">
'''تم إرسال كود التأكيد بالفعل من قبل إلى بريدك الإلكتروني، إذا كان حسابك قد تم عمله حالا، ربما يجب أن تنتظر بضع دقائق قبل طلبك لكود آخر.'''
</div>",
'confirmemail_send'       => 'أرسل رمز التفعيل',
'confirmemail_sent'       => 'تم إرسال رسالة التأكيد، شكرا لك.',
'confirmemail_oncreate'   => 'تم إرسال كود تأكيد لعنوان بريدك الإلكتروني.
لا يشترط أن تستخدم الكود للدخول للموسوعة باسمك، ولكن يجب أن تقوم بإدخاله قبل
استخدامك أيا من خواص البريد الإلكتروني المستخدمة هنا في الويكي.',
'confirmemail_sendfailed' => 'لم نستطع إرسال رسالة التأكيد. من فضلك، تأكد من بريدك الإلكتروني.

الخطأ الذي حدث: $1',
'confirmemail_invalid'    => 'رمز تفعيل خاطئ. ربما انتهت فترة صلاحيته.',
'confirmemail_needlogin'  => 'يجب عليك $1 لتأكيد البريد الإلكتروني الخاص بك.',
'confirmemail_success'    => 'تم تأكيد بريدك الإلكتروني، بإمكانك الآن الدخول و التمتع بالويكي.',
'confirmemail_loggedin'   => 'تم تأكيد بريدك الإلكتروني، شكرا لك.',
'confirmemail_error'      => 'ثمة شئ خطأ حدث عند محاولة حفظ تأكيدك.',
'confirmemail_subject'    => 'رسالة تأكيد البريد من {{SITENAME}}',
'confirmemail_body'       => 'شخصا ما، من المحتمل أن يكون أنت من العنوان $1، قام بتسجيل 
حساب بهذا العنوان الإلكتروني على {{SITENAME}}، الحساب هو:

"$2"

لتأكيد أن هذا الحساب يخصك حقا وتريد تفعيل خواص البريد الإلكتروني به على {{SITENAME}}، افتح هذه الوصلة بمتصفحك:

$3

لو لم يكن هذا * أنت * ، لا تضغط هذه الوصلة. رمز التفيعل سينتهي في $4.',

# Scary transclusion
'scarytranscludedisabled' => '[التضمين بالإنترويكي معطل]',
'scarytranscludefailed'   => '[البحث عن القالب فشل ل$1؛ عذرا]',
'scarytranscludetoolong'  => '[عنوان طويل للغاية؛ معذرة]',

# Trackbacks
'trackbackbox'      => '<div id="mw_trackbacks">
المتابعات الخاصة بهذه المقالة:<br />
$1
</div>',
'trackbackremove'   => ' ([$1 حذف])',
'trackbacklink'     => 'متابعة',
'trackbackdeleteok' => 'تم بنجاح إلغاء المتابعة.',

# Delete conflict
'deletedwhileediting' => 'تحذير: هذه الصفحة تم حذفها بعد أن بدأت أنت بتحريرها!',
'confirmrecreate'     => "لقد قام المستخدم [[مستخدم:$1|$1]] ([[نقاش المستخدم:$1|نقاش]]) بحذف هذه المقالة بعد أن بدأت بتحريرها للسبب التالي:
:''$2''
الرجاء التأكد من أنك تريد إعادة إنشاء هذه المقالة.",
'recreate'            => 'أعد الإنشاء',

'unit-pixel' => 'بك',

# HTML dump
'redirectingto' => 'جاري التحويل إلى [[$1]]...',

# action=purge
'confirm_purge'        => 'امسح كاش هذه الصفحة؟

$1',
'confirm_purge_button' => 'موافق',

# AJAX search
'searchcontaining' => "ابحث عن الصفحات المحتوية على ''$1''.",
'searchnamed'      => "ابحث عن الصفحات المعنونة ''$1''.",
'articletitles'    => "الصفحات التي تبدأ ب''$1''",
'hideresults'      => 'إخفاء النتائج',
'useajaxsearch'    => 'استخدم بحث أجاكس',

# Separators for various lists
'semicolon-separator' => '؛',
'comma-separator'     => '،',

# Multipage image navigation
'imgmultipageprev' => '← الصفحة السابقة',
'imgmultipagenext' => 'الصفحة التالية →',
'imgmultigo'       => 'اذهب!',
'imgmultigotopre'  => 'اذهب إلى صفحة',

# Table pager
'ascending_abbrev'         => 'تصاعدي',
'descending_abbrev'        => 'تنازلي',
'table_pager_next'         => 'الصفحة التالية',
'table_pager_prev'         => 'الصفحة السابقة',
'table_pager_first'        => 'الصفحة الأولى',
'table_pager_last'         => 'الصفحة الأخيرة',
'table_pager_limit'        => 'اعرض $1 عنصر في الصفحة',
'table_pager_limit_submit' => 'اذهب',
'table_pager_empty'        => 'لا نتائج',

# Auto-summaries
'autosumm-blank'   => 'إزالة كل المحتوى من الصفحة',
'autosumm-replace' => "استبدال الصفحة ب'$1'",
'autoredircomment' => 'تحويل إلى [[$1]]',
'autosumm-new'     => 'صفحة جديدة: $1',

# Size units
'size-bytes'     => '$1 بايت',
'size-kilobytes' => '$1 كيلوبايت',
'size-megabytes' => '$1 ميجابايت',
'size-gigabytes' => '$1 جيجابايت',

# Live preview
'livepreview-loading' => 'جاري التحميل…',
'livepreview-ready'   => 'جاري التحميل… جاهز!',
'livepreview-failed'  => 'فشل العرض المباشر!
حاول تجربة العرض العادي.',
'livepreview-error'   => 'لم ينجح الاتصال: $1 "$2"
حاول تجربة العرض العادي.',

# Friendlier slave lag warnings
'lag-warn-normal' => 'التغييرات الأحدث من $1 ثانية قد لا تظهر في هذه القائمة.',
'lag-warn-high'   => 'نتيجة لوجود تأخر كبير في تحديث قاعدة بيانات الخادم، التغييرات أحدث من $1 ثانية
ربما لا تكون ظاهرة في هذه القائمة.',

# Watchlist editor
'watchlistedit-numitems'       => 'قائمة مراقبتك تحتوي على {{PLURAL:$1|عنوان واحد|$1 عنوان}}، بدون احتساب صفحات النقاش.',
'watchlistedit-noitems'        => 'قائمة مراقبتك لا تحتوي على أية عناوين.',
'watchlistedit-normal-title'   => 'تعديل قائمة المراقبة',
'watchlistedit-normal-legend'  => 'أزل عناوين من قائمة المراقبة',
'watchlistedit-normal-explain' => 'العناوين في قائمة مراقبتك معروضة بالأسفل. لإزالة عنوان، اضغط على
	الصندوق بجواره، واضغط إزالة العناوين. يمكنك أيضا [[Special:Watchlist/raw|تعديل القائمة الخام]].',
'watchlistedit-normal-submit'  => 'إزالة العناوين',
'watchlistedit-normal-done'    => '{{PLURAL:$1|عنوان واحد|$1 عنوان}} تمت إزالته من قائمة مراقبتك:',
'watchlistedit-raw-title'      => 'عدل قائمة المراقبة الخام',
'watchlistedit-raw-legend'     => 'عدل قائمة المراقبة',
'watchlistedit-raw-explain'    => 'العناوين في قائمة مراقبتك معروضة بالأسفل، ويمكن تعديلها عن طريق الإضافة والإزالة من القائمة؛ عنوان واحد لكل سطر. عند الانتهاء، اضغط تحديث قائمة المراقبة.
	يمكنك أيضا [[Special:Watchlist/edit|استخدام المحرر القياسي]].',
'watchlistedit-raw-titles'     => 'العناوين:',
'watchlistedit-raw-submit'     => 'تحديث قائمة المراقبة',
'watchlistedit-raw-done'       => 'قائمة مراقبتك تم تحديثها.',
'watchlistedit-raw-added'      => '{{PLURAL:$1|عنوان واحد|$1 عنوان}} تم إضافتها:',
'watchlistedit-raw-removed'    => '{{PLURAL:$1|عنوان واحد|$1 عنوان}} تمت إزالته:',

# Watchlist editing tools
'watchlisttools-view' => 'عرض التغييرات المرتبطة',
'watchlisttools-edit' => 'عرض وتعديل قائمة المراقبة',
'watchlisttools-raw'  => 'عدل قائمة المراقبة الخام',

# Iranian month names
'iranian-calendar-m1'  => 'فروردین',
'iranian-calendar-m2'  => 'اردیبهشت',
'iranian-calendar-m3'  => 'خرداد',
'iranian-calendar-m4'  => 'تیر',
'iranian-calendar-m5'  => 'امرداد',
'iranian-calendar-m6'  => 'شهریور',
'iranian-calendar-m7'  => 'مهر',
'iranian-calendar-m8'  => 'آبان',
'iranian-calendar-m9'  => 'آذر',
'iranian-calendar-m10' => 'دی',
'iranian-calendar-m11' => 'بهمن',
'iranian-calendar-m12' => 'اسفند',

# Hebrew month names
'hebrew-calendar-m1'      => 'تيشري',
'hebrew-calendar-m2'      => 'تيشفان',
'hebrew-calendar-m3'      => 'كيسليف',
'hebrew-calendar-m4'      => 'تيفيت',
'hebrew-calendar-m5'      => 'شيفات',
'hebrew-calendar-m6'      => 'أدار',
'hebrew-calendar-m6a'     => 'أدار الأول',
'hebrew-calendar-m6b'     => 'أدار الثاني',
'hebrew-calendar-m7'      => 'نيزان',
'hebrew-calendar-m8'      => 'أيار',
'hebrew-calendar-m9'      => 'سيفان',
'hebrew-calendar-m10'     => 'تموز',
'hebrew-calendar-m11'     => 'آف',
'hebrew-calendar-m12'     => 'أيلول',
'hebrew-calendar-m1-gen'  => 'تيشري',
'hebrew-calendar-m2-gen'  => 'تيشفان',
'hebrew-calendar-m3-gen'  => 'كيسليف',
'hebrew-calendar-m4-gen'  => 'تيفيت',
'hebrew-calendar-m5-gen'  => 'شيفات',
'hebrew-calendar-m6-gen'  => 'أدار',
'hebrew-calendar-m6a-gen' => 'أدار الأول',
'hebrew-calendar-m6b-gen' => 'أدار الثاني',
'hebrew-calendar-m7-gen'  => 'نيزان',
'hebrew-calendar-m8-gen'  => 'أيار',
'hebrew-calendar-m9-gen'  => 'سيفان',
'hebrew-calendar-m10-gen' => 'تموز',
'hebrew-calendar-m11-gen' => 'آف',
'hebrew-calendar-m12-gen' => 'أيلول',

# Core parser functions
'unknown_extension_tag' => 'وسم امتداد غير معروف "$1"',

# Special:Version
'version-extensions'               => 'الامتدادات المنصبة',
'version-specialpages'             => 'صفحات خاصة',
'version-parserhooks'              => 'هوكات البارسر',
'version-variables'                => 'المتغيرات',
'version-other'                    => 'أخرى',
'version-mediahandlers'            => 'متحكمات الميديا',
'version-hooks'                    => 'الهوكات',
'version-extension-functions'      => 'وظائف الامتداد',
'version-parser-extensiontags'     => 'وسوم امتداد البارسر',
'version-parser-function-hooks'    => 'هوكات دالة البارسر',
'version-skin-extension-functions' => 'وظائف امتداد الواجهة',
'version-hook-name'                => 'اسم الهوك',
'version-hook-subscribedby'        => 'يستخدم بواسطة',
'version-version'                  => 'إصدار',
'version-license'                  => 'الرخصة',
'version-software'                 => 'البرنامج المنصب',
'version-software-product'         => 'المنتج',
'version-software-version'         => 'النسخة',

# Special:Filepath
'filepath'         => 'مسار ملف',
'filepath-page'    => 'الملف:',
'filepath-submit'  => 'المسار',
'filepath-summary' => 'هذه الصفحة الخاصة تعرض المسار الكامل لملف. ستعرض الصور بأقصى دقة، ستعمل أنواع الملفات الأخرى بالبرنامج المخصص لهم مباشرة؛ أدخل اسم الملف بدون البادئة "{{ns:image}}:"',

);
