/*
 *    Copyright (C) 2010
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.update;

import javax.swing.JOptionPane;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;

/**
 *
 * @author emil
 */
public class CheckUpdate implements Runnable {

    private Daten daten;
    private boolean suchen = false;
    private boolean filmeLaden = false;

    public CheckUpdate(Daten ddaten) {
        daten = ddaten;
    }

    @Override
    public synchronized void run() {
        if (daten.system[Konstanten.SYSTEM_UPDATE_SUCHEN_NR].equals("")) {
            //Feld ist noch leer und es wurde noch nichts eingestellt
            int answer = JOptionPane.showConfirmDialog(null, "Online nach neuen Programmversionen suchen?", "Update suchen",
                    JOptionPane.YES_NO_OPTION);
            if (answer == JOptionPane.YES_OPTION) {
                daten.system[Konstanten.SYSTEM_UPDATE_SUCHEN_NR] = Boolean.toString(true);
            } else {
                daten.system[Konstanten.SYSTEM_UPDATE_SUCHEN_NR] = Boolean.toString(false);
                // dann auch das automatische Laden abschalten
                daten.system[Konstanten.SYSTEM_UPDATE_FILME_NR] = String.valueOf(Konstanten.UPDATE_FILME_URL);
            }
            daten.setGeaendert();
        }
        if (!daten.system[Konstanten.SYSTEM_UPDATE_DATUM_NR].equals(Funktionen.getHeute_yyyyMMdd())) {
            //einmal am Tag suchen
            if (Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_UPDATE_SUCHEN_NR])) {
                // wenn update an
                suchen = true;
            }
            if (Funktionen.getUpdateFilme(daten) >= Konstanten.UPDATE_FILME_START) {
                // zum Laden der Filmliste
                suchen = true;
                filmeLaden = true;
            }
        }
        if (suchen) {
            ///////////////////////////////////da wird 2x geladen!
            new UpdateSuchen(daten).suchen(true);
        }
        if (filmeLaden) {
            daten.filmeLaden.filmeImportServer();
        }
    }
}
