/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme.sender;

import java.util.Iterator;
import java.util.LinkedList;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.filme.DatenFilm;
import mediathek.io.GetUrl;

/**
 * 
 * @author
 */
public class MediathekArte7 extends MediathekReader implements Runnable {

    static boolean arte_de = true;
    static boolean arte_fr = true;
    static boolean laufeSchon = false;
    private final String THEMA_ARTE_7 = "Arte+7";
    private int themenLaufen = 0;
    private int MAX_SEITEN = 15;
    private LinkedList<String[]> listeFilmseiten = new LinkedList<String[]>();
    private LinkedList<String[]> listeFilmseitenFertig = new LinkedList<String[]>();
    private boolean de;

    /**
     * 
     * @param ddaten
     * @param dde
     */
    public MediathekArte7(Daten ddaten, boolean dde) {
        super(ddaten);
        de = dde;
        if (de) {
            text = "Arte DE (bis ca. 200 MB, bis 2000 Filme)";
            sender = Konstanten.SENDER_ARTE_DE;
        } else {
            text = "Arte FR (bis ca. 200 MB, bis 2000 Filme)";
            sender = Konstanten.SENDER_ARTE_FR;
        }
    }

    //===================================
    // public
    //===================================
    /**
     * 
     */
    @Override
    public synchronized void addToList() {
        if (!laufeSchon) {
            laufeSchon = true;
            daten.fehler.systemMeldung("Sender Arte: " + sender);
            addToList_de_fr();
        }
    }

    void addToList_de_fr() {
        try {
            threads = 0;
            arte_de = daten.filmeLaden.senderAn(Konstanten.SENDER_ARTE_DE);
            arte_fr = daten.filmeLaden.senderAn(Konstanten.SENDER_ARTE_FR);
            listeThemen.clear();
            listeFilmseiten.clear();
            listeFilmseitenFertig.clear();
            //immer erst mal Arte7!!
            String[] add = new String[]{"http://videos.arte.tv/de/videos", THEMA_ARTE_7};
            listeThemen.add(add);
            //und der Rest nur auf Wunsch
            if (daten.allesLaden) {
                //erst mal alle Themen suchen um die Filme nicht doppelt zu suchen
                addToList__("http://videos.arte.tv/de/videos/sendungen");
                addToList__("http://videos.arte.tv/de/videos/alleVideos");
            }
            notifyStart(listeThemen.size());
            new Thread(new ArteThemaLaden()).start(); // da reicht einer
        } catch (Exception ex) {
            daten.fehler.fehlerMeldung(ex, "MediathekArte7.addToList");
        }
    }

    private boolean addToList__(String ADRESSE) {
        //Theman suchen
        boolean ret = false;
        final String START = "<div class=\"navTop\"></div>";
        final String STOP = "<div id=\"content\">";
        final String MUSTER_URL = "<li><a href=\"";
        final String URL_THEMA_PREFIX = "http://videos.arte.tv";
        //url-Thema
        // http://videos.arte.tv/de/videos/sendungen/360_geo/index-3188704.html
        //url
        // <li><a href="/de/videos/sendungen/360_geo/index-3188704.html">360° - GEO-Reportage<span id="3188704"></span></a></li>
//        de = Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_ARTE_DE_NR]);
//        fr = Boolean.parseBoolean(daten.system[Konstanten.SYSTEM_ARTE_FR_NR]);
        StringBuffer strSeite = new StringBuffer();
        strSeite = getUrlIo.getUri_Utf(sender, ADRESSE, strSeite, "");
        int pos = 0;
        int pos1 = 0;
        int pos2 = 0;
        int ende = strSeite.indexOf(STOP);
        String url = "";
        String thema = "";
        if ((pos = strSeite.indexOf(START, pos)) != -1) {
            while (!stop && (pos = strSeite.indexOf(MUSTER_URL, pos)) != -1) {
                if (pos > ende) {
                    //Themenbereich zu Ende
                    break;
                }
                url = "";
                thema = "";
                pos += MUSTER_URL.length();
                pos1 = pos;
                pos2 = strSeite.indexOf("\"", pos);
                if (pos1 != -1 && pos2 != -1 && pos1 != pos2) {
                    url = strSeite.substring(pos1, pos2);
                    pos1 = strSeite.indexOf("\">", pos);
                    pos2 = strSeite.indexOf("<", pos);
                    if (!url.equals("")) {
                        ret = true;
                    }
                    if (pos1 != -1 && pos2 != -1) {
                        thema = strSeite.substring(pos1 + 2, pos2);
                        if (nurAboLaden()) {
                            //nur Abos laden
                            if (!daten.listeAbo.aboExists(Konstanten.SENDER_ARTE_DE, thema) && arte_de || !daten.listeAbo.aboExists(Konstanten.SENDER_ARTE_FR, thema) && arte_fr) {
                                continue;
                            }
                        }
                    }
                    if (url.equals("")) {
                        daten.fehler.fehlerMeldung("Fehler!", "MediathekArte.addToList: keine URL");
                    } else {
                        String[] add = new String[]{URL_THEMA_PREFIX + url, thema};
                        if (!istInListe(listeThemen, url, 0)) {
                            listeThemen.add(add);
                        }
                    }
                }
            }
        }
        return ret;
    }

    //===================================
    // private
    //===================================
    private class ArteThemaLaden implements Runnable {

        GetUrl getUrl7 = new GetUrl(daten, 20000, Konstanten.WARTEN_BASIS_URL);
        GetUrl getUrl = new GetUrl(daten, 10000, Konstanten.WARTEN_BASIS_URL);
        String[] link = null;
        private StringBuffer strSeite1 = new StringBuffer();
//        private StringBuffer strSeite2 = new StringBuffer();
//        private StringBuffer strSeite3 = new StringBuffer();

        @Override
        public void run() {
            getSem();
            ++themenLaufen;
            ++threads;
            notifyThread();
            relSem();
            // dieser Thread läuft nur 1x
            for (int t = 0; t < Konstanten.MAX_THREAD_LADEN_FILME; ++t) {
                new Thread(new ArteFilmseitenLaden()).start();
            }
            while (!stop && (link = getListeThemen()) != null) {
                themenSeitenSuchen(link[0] /*url*/, link[1] /*Thema*/);
                notifyProgress(link[0]);
            }
            getSem();
            --threads;
            --themenLaufen;
            notifyThread();
            relSem();
        }

        private void themenSeitenSuchen(String strUrlFeed, String thema) {
            //weitere Seiten
            //<div class="pagination">
            //<ul class="list">
            //<li><a href="/de/videos/artejournal?hash=fr%2Fthumb%2F%2F%2F1%2F20%2F" class="current">1</a></li>
            //
            //<li><a href="/de/videos/artejournal?hash=fr%2Fthumb%2F%2F%2F2%2F20%2F">2</a></li>
            //<li><a href="/de/videos/artejournal?hash=fr%2Fthumb%2F%2F%2F3%2F20%2F">3</a></li>
            //<li><a href="/de/videos/artejournal?hash=fr%2Fthumb%2F%2F%2F4%2F20%2F">4</a></li>
            //<li><a href="/de/videos/artejournal?hash=fr%2Fthumb%2F%2F%2F2%2F20%2F">Weiter</a></li>

            final String MUSTER_THEMA_START = "<div class=\"pagination";
            final String MUSTER_THEMA_STOP = "Weiter</a></li>";

            final String MUSTER_THEMA_URL = "<li><a href=\"";
            final String MUSTER_URL = "<h2><a href=\"";
            final String URL_THEMA_PREFIX = "http://videos.arte.tv";

            LinkedList<String> themenseiten = new LinkedList<String>();
            themenseiten.add(strUrlFeed); //erste Themenseite
            int count = 0;
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            int start = 0;
            int ende = 0;
            String url = "";
            String titel = "";
            String seite = "";
            boolean gefunden = false;
            boolean ersteSeite = true;
            seite = strUrlFeed;
            if (daten.allesLaden || thema.startsWith(THEMA_ARTE_7)) {
                //auch nach älteren Beiträgen suchen
                do {
                    gefunden = false;
                    notifyProgress("*" + seite);
                    if (thema.startsWith(THEMA_ARTE_7)) {
                        strSeite1 = getUrl7.getUri_Utf(sender, seite, strSeite1, "");
                    } else {
                        strSeite1 = getUrl.getUri_Utf(sender, seite, strSeite1, "");
                    }
                    if ((start = strSeite1.indexOf(MUSTER_THEMA_START)) != -1) {
                        ende = strSeite1.indexOf(MUSTER_THEMA_STOP);
                        pos = start;
                        while (!stop && (pos = strSeite1.indexOf(MUSTER_THEMA_URL, pos)) != -1 && pos < ende) {
                            url = "";
                            titel = "";
                            pos += MUSTER_THEMA_URL.length();
                            pos1 = pos;
                            pos2 = strSeite1.indexOf("\"", pos);
                            if (pos1 != -1 && pos2 != -1 && pos1 != pos2) {
                                url = strSeite1.substring(pos1, pos2);
                                //url = "http://videos.arte.tv/" + url.replaceAll("%2", "/");
                                url = "http://videos.arte.tv/" + url;
                                if (ersteSeite) {
                                    ersteSeite = false;
                                } else if (!themenseiten.contains(url)) {
                                    themenseiten.add(url);
                                    gefunden = true;
                                    ++count;
                                }
                            }
                        }
                    }
                    seite = themenseiten.getLast();
                } while (!stop && gefunden && count < MAX_SEITEN);
            }
            pos = 0;
            pos1 = 0;
            pos2 = 0;
            Iterator<String> it = themenseiten.iterator();
            while (!stop && it.hasNext()) {
                seite = it.next();
                if (thema.startsWith(THEMA_ARTE_7)) {
                    strSeite1 = getUrl7.getUri_Utf(sender, seite, strSeite1, "");
                } else {
                    strSeite1 = getUrl.getUri_Utf(sender, seite, strSeite1, "");
                }
                while (!stop && (pos = strSeite1.indexOf(MUSTER_URL, pos)) != -1) {
                    url = "";
                    titel = "";
                    pos += MUSTER_URL.length();
                    pos1 = pos;
                    pos2 = strSeite1.indexOf("\"", pos);
                    if (pos1 != -1 && pos2 != -1 && pos1 != pos2) {
                        url = strSeite1.substring(pos1, pos2);
                        if (!url.equals("")) {
                            pos1 = strSeite1.indexOf(">", pos);
                            pos2 = strSeite1.indexOf("</a", pos);
                            if (pos1 != -1 && pos2 != -1) {
                                titel = strSeite1.substring(pos1 + 1, pos2);
                                //weiter gehts
                                String[] add = new String[]{strUrlFeed, thema, titel, URL_THEMA_PREFIX + url};
                                if (!istInListeFilmseiteFertig(add)) {
                                    getAddListeFilmseiten(add);
                                    //addFilme2(strUrlFeed, thema, titel, URL_THEMA_PREFIX + url);
                                }
                            }
                        }
                    } else {
                        daten.fehler.fehlerMeldung("Fehler!", "keine Url addFilme" + sender + thema);
                    }
                }
            }
        }
    }

    private class ArteFilmseitenLaden implements Runnable {

        GetUrl getUrl7 = new GetUrl(daten, 20000, Konstanten.WARTEN_BASIS_URL);
        GetUrl getUrl = new GetUrl(daten, 5000, Konstanten.WARTEN_BASIS_URL);
        private StringBuffer strSeite2 = new StringBuffer();
        private StringBuffer strSeite3 = new StringBuffer();

        @Override
        public synchronized void run() {
            getSem();
            ++threads;
            notifyThread();
            relSem();
            String[] filmseite;
            do {
                try {
                    while (!stop && (filmseite = getAddListeFilmseiten(null)) != null) {
                        //addFilme2(String strUrlFeed, String thema, String titel, String urlFilm, String alt);
                        addFilme2(filmseite[0], filmseite[1], filmseite[2], filmseite[3]);
                        notifyProgress(filmseite[3]);
                    }
                    //da ist die Themenliste noch nicht fertig
                    this.wait(500);
                } catch (Exception ex) {
                }
            } while (!stop && themenLaufen > 0);
            getSem();
            --threads;
            notifyThread();
            notifyFertig();
            relSem();
        }

        private void addFilme2(String strUrlFeed, String thema, String titel, String urlFilm) {
            //Film eines Themas laden
            // Muster zum Suchen:
            //vars_player.videorefFileUrl = "http://videos.arte.tv/de/do_delegate/videos/virtuelle_welten_in_cannes-3220966,view,asPlayerXml.xml";
            //zur Auth:
            //var url_player = "http://videos.arte.tv/blob/web/i18n/view/player_8-3188338-data-4797751.swf";

            final String MUSTER_URL = "vars_player.videorefFileUrl = \"";
            final String MUSTER_AUTH = "var url_player = \"";
            notifyProgress("*" + urlFilm);
            if (thema.startsWith(THEMA_ARTE_7)) {
                strSeite2 = getUrl7.getUri_Utf(sender, urlFilm, strSeite2, "");
            } else {
                strSeite2 = getUrl.getUri_Utf(sender, urlFilm, strSeite2, "");
            }
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            String url = "";
            String authurl = "";
            //auth suchen
            if (!stop && (pos = strSeite2.indexOf(MUSTER_AUTH, pos)) != -1) {
                pos += MUSTER_AUTH.length();
                pos1 = pos;
                pos2 = strSeite2.indexOf("\"", pos);
                if (pos1 != -1 && pos2 != -1 && pos1 != pos2) {
                    authurl = strSeite2.substring(pos1, pos2);
                    if (authurl.equals("")) {
                        daten.fehler.fehlerMeldung("Fehler!", "keine Auth-Url addFilme2" + sender + thema);
                    }
                }
            }
            //url suchen
            pos = 0;
            pos1 = 0;
            pos2 = 0;
            if ((pos = strSeite2.indexOf(MUSTER_URL, pos)) != -1) {
                pos += MUSTER_URL.length();
                pos1 = pos;
                pos2 = strSeite2.indexOf("\"", pos);
                if (pos1 != -1 && pos2 != -1 && pos1 != pos2) {
                    url = strSeite2.substring(pos1, pos2);
                    if (!url.equals("")) {
                        //weiter gehts
                        addFilme3(strUrlFeed, thema, titel, url, authurl);
                    } else {
                        daten.fehler.fehlerMeldung("Fehler!", "keine Url addFilme2" + sender + thema);
                    }
                }
            }
        }

        private void addFilme3(String strUrlFeed, String thema, String titel, String urlFilm, String authurl) {
            //Film eines Themas laden
            // Muster zum Suchen:
            // de
            //<video lang="de" ref="
            // fr
            //<video lang="fr" ref="
            //urlFilm
            //<video lang="de" ref="http://videos.arte.tv/de/do_delegate/videos/virtuelle_welten_in_cannes-3220944,view,asPlayerXml.xml"/>

            final String MUSTER_URL_DE = "<video lang=\"de\" ref=\"";
            final String MUSTER_URL_FR = "<video lang=\"fr\" ref=\"";
            if (thema.startsWith(THEMA_ARTE_7)) {
                strSeite2 = getUrl7.getUri_Utf(sender, urlFilm, strSeite2, "");
            } else {
                strSeite2 = getUrl.getUri_Utf(sender, urlFilm, strSeite2, "");
            }
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            String url = "";
            String MUSTER_URL = "";
            if (!stop && arte_de) {
                MUSTER_URL = MUSTER_URL_DE;
                if ((pos = strSeite2.indexOf(MUSTER_URL, pos)) != -1) {
                    url = "";
                    pos += MUSTER_URL.length();
                    pos1 = pos;
                    pos2 = strSeite2.indexOf("\"", pos);
                    if (pos1 != -1 && pos2 != -1 && pos1 != pos2) {
                        url = strSeite2.substring(pos1, pos2);
                        if (!url.equals("")) {
                            //weiter gehts jetzt wirklich zum Film
                            addFilme4(Konstanten.SENDER_ARTE_DE, strUrlFeed, thema, titel, url, authurl);
                        } else {
                            daten.fehler.fehlerMeldung("Fehler!", "keine Url addFilme3" + Konstanten.SENDER_ARTE_DE + thema);
                        }
                    }
                }
            }
            if (!stop && arte_fr) {
                pos = 0;
                pos1 = 0;
                pos2 = 0;
                url = "";
                MUSTER_URL = MUSTER_URL_FR;
                if ((pos = strSeite2.indexOf(MUSTER_URL, pos)) != -1) {
                    url = "";
                    pos += MUSTER_URL.length();
                    pos1 = pos;
                    pos2 = strSeite2.indexOf("\"", pos);
                    if (pos1 != -1 && pos2 != -1 && pos1 != pos2) {
                        url = strSeite2.substring(pos1, pos2);
                        if (!url.equals("")) {
                            //weiter gehts jetzt wirklich zum Film
                            addFilme4(Konstanten.SENDER_ARTE_FR, strUrlFeed, thema, titel, url, authurl);
                        } else {
                            daten.fehler.fehlerMeldung("Fehler!", "keine Url addFilme3" + Konstanten.SENDER_ARTE_FR + thema);
                        }
                    }
                }
            }
        }

        private void addFilme4(String senderArte, String strUrlFeed, String thema, String titel, String urlFilm, String authurl) {
            //Film eines Themas laden
            // Muster zum Suchen:
            //<url quality="hd">
            // rtmp://artestras.fcod.llnwd.net/a3903/o35/MP4:geo/videothek/ALL/arteprod/2010/05/16/ARTE3220966_DE_28919_16by9_800_MP4?h=db7388494aa3ec5cda2a7decfb083ce4
            // </url>
            //<dateVideo>Thu, 25 Nov 2010 18:06:32 +0100</dateVideo>
            String tmp = "";
            String datum = "";
            String zeit = "";
            final String MUSTER_DATUM = "<dateVideo>";
            boolean alt = !thema.startsWith(THEMA_ARTE_7);
            final String MUSTER_URL = "<url quality=\"hd\">";
//            notifyProgress("*" + urlFilm);
            if (thema.startsWith(THEMA_ARTE_7)) {
                strSeite3 = getUrl7.getUri_Utf(sender, urlFilm, strSeite3, "");
            } else {
                strSeite3 = getUrl.getUri_Utf(sender, urlFilm, strSeite3, "");
            }
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            String url = "";
            if ((pos = strSeite3.indexOf(MUSTER_DATUM, pos)) != -1) {
                pos1 = pos + MUSTER_DATUM.length();
                if ((pos2 = strSeite3.indexOf("<", pos1)) != -1) {
                    //<dateVideo>Thu, 25 Nov 2010 18:06:32 +0100</dateVideo>
                    tmp = strSeite3.substring(pos1, pos2);
                    if (tmp.equals("")) {
                        daten.fehler.fehlerMeldung("Fehler!", "Mediathek3Sat.addToList: keine Datum");
                    } else {
                        datum = Funktionen.convertDatum(daten, tmp);
                        zeit = Funktionen.convertTime(daten, tmp);
                    }
                }
            }
            pos = 0;
            pos1 = 0;
            pos2 = 0;
            if ((pos = strSeite3.indexOf(MUSTER_URL, pos)) != -1) {
                pos += MUSTER_URL.length();
                pos1 = pos;
                pos2 = strSeite3.indexOf("</url>", pos);
                if (pos1 != -1 && pos2 != -1 && pos1 != pos2) {
                    url = strSeite3.substring(pos1, pos2);
                    if (!url.equals("")) {
                        // DatenFilm(Daten ddaten, String ssender, String tthema, String urlThema, String ttitel, String uurl, String uurlorg, String zziel) {
                        DatenFilm film = new DatenFilm(daten, senderArte, thema, strUrlFeed, titel, url, url/*urlOrg*/, ""/*urlRtmp*/, datum, zeit, alt);
                        film.arr[Konstanten.FILM_URL_AUTH_NR] = authurl;
                        daten.filmeLaden.listeFilmeSchattenliste.addSenderRtmp(film);
                    } else {
                        daten.fehler.fehlerMeldung("Fehler!", "keine Url addFilme4" + senderArte + thema);
                    }
                }
            }
        }
    }

    private synchronized String[] getAddListeFilmseiten(String[] add) {
        if (add != null) {
            this.notifyMax(1);
            listeFilmseiten.add(add);
            return null;
        } else {
            return listeFilmseiten.pollFirst();
        }
    }

    private synchronized boolean istInListeFilmseiteFertig(String[] link) {
        boolean ret = false;
        //(String strUrlFeed, String thema, String titel, String urlFilm) {
        if (!link[1].startsWith(THEMA_ARTE_7)) {
            if (istInListe(listeFilmseitenFertig, link[3], 3)) {
                ret = true;
            } else {
                listeFilmseitenFertig.add(link);
            }
        }
        return ret;
    }

    @Override
    void notifyFertig() {
        //wird erst ausgeführt wenn alle Threads beendet sind
        if (threads <= 0) { // sonst läuft noch was
            laufeSchon = false;
        }
        super.notifyFertig();
    }
}
